/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.debugger.JniAddressSpace;
import com.ibm.j9ddr.corereaders.debugger.JniNatives;
import com.ibm.j9ddr.corereaders.debugger.JniProcess;
import com.ibm.j9ddr.corereaders.debugger.JniSearchableMemory;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryImageInputStream;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

public class JniReader
extends AbstractCoreReader
implements ICoreFileReader {
    private final Properties properties = new Properties();
    private List<IAddressSpace> addressSpaces;

    public JniReader() throws IOException {
        this.setReader(new IMemoryImageInputStream(new JniSearchableMemory(), 0L));
    }

    @Override
    public ICore processDump(String string) throws InvalidDumpFormatException, IOException {
        return this;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String string) throws IOException {
        return ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream imageInputStream) throws IOException {
        return ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT;
    }

    @Override
    public Collection<? extends IAddressSpace> getAddressSpaces() {
        if (null == this.addressSpaces) {
            IProcess iProcess;
            this.addressSpaces = new ArrayList<IAddressSpace>(1);
            JniAddressSpace jniAddressSpace = new JniAddressSpace(0, this);
            Iterator<? extends IProcess> iterator = jniAddressSpace.getProcesses().iterator();
            if (iterator.hasNext() && (iProcess = iterator.next()) instanceof JniProcess) {
                JniProcess jniProcess = (JniProcess)iProcess;
                int n = jniProcess.getTargetArchitecture();
                switch (n) {
                    case 1: {
                        this.properties.setProperty("cpu.type", "x86");
                        break;
                    }
                    case 2: {
                        this.properties.put("cpu.type", "amd64");
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.properties.put("cpu.type", "s390");
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.properties.put("cpu.type", "ppc");
                        break;
                    }
                }
            }
            this.addressSpaces.add(jniAddressSpace);
        }
        return this.addressSpaces;
    }

    @Override
    public native String getDumpFormat();

    @Override
    public Platform getPlatform() {
        return JniNatives.getPlatform();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ICore processDump(ImageInputStream imageInputStream) throws InvalidDumpFormatException, IOException {
        return this;
    }
}

