/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateCrtKeyImpl
extends PKCS8Key
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -1326088454257084918L;
    private BigInteger n;
    private BigInteger e;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger pe;
    private BigInteger qe;
    private BigInteger coeff;
    static final AlgorithmId rsaId = new AlgorithmId(AlgorithmId.RSAEncryption_oid);
    private static NativeCrypto nativeCrypto = NativeCrypto.getNativeCrypto();
    private long nativeRSAKey = 0L;

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(byArray);
        if (rSAPrivateCrtKeyImpl.getPublicExponent().signum() == 0) {
            return new RSAPrivateKeyImpl(rSAPrivateCrtKeyImpl.getModulus(), rSAPrivateCrtKeyImpl.getPrivateExponent());
        }
        return rSAPrivateCrtKeyImpl;
    }

    RSAPrivateCrtKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
    }

    RSAPrivateCrtKeyImpl(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.n = bigInteger;
        this.e = bigInteger2;
        this.d = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.pe = bigInteger6;
        this.qe = bigInteger7;
        this.coeff = bigInteger8;
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        this.algid = rsaId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            derOutputStream.putInteger(bigInteger4);
            derOutputStream.putInteger(bigInteger5);
            derOutputStream.putInteger(bigInteger6);
            derOutputStream.putInteger(bigInteger7);
            derOutputStream.putInteger(bigInteger8);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.p;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.q;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.pe;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.qe;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.coeff;
    }

    protected long getNativePtr() {
        if (this.nativeRSAKey != 0L) {
            return this.nativeRSAKey;
        }
        BigInteger bigInteger = this.getModulus();
        BigInteger bigInteger2 = this.getPrivateExponent();
        BigInteger bigInteger3 = this.getPublicExponent();
        BigInteger bigInteger4 = this.getPrimeP();
        BigInteger bigInteger5 = this.getPrimeQ();
        BigInteger bigInteger6 = this.getPrimeExponentP();
        BigInteger bigInteger7 = this.getPrimeExponentQ();
        BigInteger bigInteger8 = this.getCrtCoefficient();
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = bigInteger2.toByteArray();
        byte[] byArray3 = bigInteger3.toByteArray();
        byte[] byArray4 = bigInteger4.toByteArray();
        byte[] byArray5 = bigInteger5.toByteArray();
        byte[] byArray6 = bigInteger6.toByteArray();
        byte[] byArray7 = bigInteger7.toByteArray();
        byte[] byArray8 = bigInteger8.toByteArray();
        this.nativeRSAKey = nativeCrypto.createRSAPrivateCrtKey(byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, byArray5, byArray5.length, byArray6, byArray6.length, byArray7, byArray7.length, byArray8, byArray8.length);
        return this.nativeRSAKey;
    }

    public void finalize() {
        if (this.nativeRSAKey != 0L && this.nativeRSAKey != -1L) {
            nativeCrypto.destroyRSAKey(this.nativeRSAKey);
        }
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream derInputStream2 = derValue.data;
            int n = derInputStream2.getInteger();
            if (n != 0) {
                throw new IOException("Version must be 0");
            }
            this.n = derInputStream2.getPositiveBigInteger();
            this.e = derInputStream2.getPositiveBigInteger();
            this.d = derInputStream2.getPositiveBigInteger();
            this.p = derInputStream2.getPositiveBigInteger();
            this.q = derInputStream2.getPositiveBigInteger();
            this.pe = derInputStream2.getPositiveBigInteger();
            this.qe = derInputStream2.getPositiveBigInteger();
            this.coeff = derInputStream2.getPositiveBigInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid RSA private key", iOException);
        }
    }
}

