/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ClassLoadingMXBeanImpl;
import com.ibm.java.lang.management.internal.CompilationMXBeanImpl;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.lang.management.internal.ExtendedMemoryMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedOperatingSystemMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedRuntimeMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedThreadMXBeanImpl;
import com.ibm.lang.management.internal.OpenTypeMappingIHandler;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ClassLoadingMXBeanImpl.getInstance();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return CompilationMXBeanImpl.getInstance();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ExtendedMemoryMXBeanImpl.getInstance().getGarbageCollectorMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ExtendedMemoryMXBeanImpl.getInstance().getMemoryManagerMXBeans(true);
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ExtendedMemoryMXBeanImpl.getInstance();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ExtendedMemoryMXBeanImpl.getInstance().getMemoryPoolMXBeans(true);
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ExtendedOperatingSystemMXBeanImpl.getInstance();
    }

    public static MBeanServer getPlatformMBeanServer() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        return ServerHolder.platformServer;
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ExtendedRuntimeMXBeanImpl.getInstance();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ExtendedThreadMXBeanImpl.getInstance();
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        ObjectName objectName = ManagementUtils.checkNamedMXBean(string, clazz);
        Class[] classArray = ManagementUtils.isANotificationEmitter(mBeanServerConnection, objectName) ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        OpenTypeMappingIHandler openTypeMappingIHandler = new OpenTypeMappingIHandler(mBeanServerConnection, clazz, objectName);
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, openTypeMappingIHandler);
        return clazz.cast(object);
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> clazz) {
        return ManagementUtils.getPlatformMXBean(clazz);
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) throws IllegalArgumentException {
        return ManagementUtils.getPlatformMXBeans(clazz);
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        ManagementUtils.checkSupportedSingleton(clazz);
        String string = clazz.getName();
        Set<ObjectName> set = mBeanServerConnection.queryNames(null, null);
        for (ObjectName objectName : set) {
            block4: {
                try {
                    if (!mBeanServerConnection.isInstanceOf(objectName, string)) {
                    }
                    break block4;
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!ManagementUtils.VERBOSE_MODE) continue;
                    instanceNotFoundException.printStackTrace(System.err);
                }
                continue;
            }
            return (T)((PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName.toString(), clazz));
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IllegalArgumentException, IOException {
        ManagementUtils.checkSupported(clazz);
        LinkedList<T> linkedList = new LinkedList<T>();
        Set<ObjectName> set = mBeanServerConnection.queryNames(null, null);
        for (ObjectName objectName : set) {
            block4: {
                try {
                    if (!mBeanServerConnection.isInstanceOf(objectName, clazz.getName())) {
                    }
                    break block4;
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!ManagementUtils.VERBOSE_MODE) continue;
                    instanceNotFoundException.printStackTrace(System.err);
                }
                continue;
            }
            linkedList.add(ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName.toString(), clazz));
        }
        return linkedList;
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        return ManagementUtils.getPlatformManagementInterfaces();
    }

    private static final class ServerHolder {
        static final MBeanServer platformServer = MBeanServerFactory.createMBeanServer();

        private ServerHolder() {
        }

        static {
            final class Registration
            implements PrivilegedAction<Void> {
                private final MBeanServer server;

                Registration(MBeanServer mBeanServer) {
                    this.server = mBeanServer;
                }

                @Override
                public Void run() {
                    for (PlatformManagedObject platformManagedObject : ManagementUtils.getAllAvailableMXBeans()) {
                        ObjectName objectName = platformManagedObject.getObjectName();
                        if (this.server.isRegistered(objectName)) continue;
                        try {
                            this.server.registerMBean(platformManagedObject, objectName);
                        }
                        catch (NullPointerException | InstanceAlreadyExistsException | MBeanRegistrationException exception) {
                            if (!ManagementUtils.VERBOSE_MODE) continue;
                            exception.printStackTrace(System.err);
                        }
                        catch (NotCompliantMBeanException notCompliantMBeanException) {
                            notCompliantMBeanException.printStackTrace();
                            if (!ManagementUtils.VERBOSE_MODE) continue;
                            notCompliantMBeanException.printStackTrace(System.err);
                        }
                    }
                    return null;
                }
            }
            AccessController.doPrivileged(new Registration(platformServer));
        }
    }
}

