/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.NamedWeakReference;
import com.sun.naming.internal.VersionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String DISABLE_APP_RESOURCE_FILES = "com.sun.naming.disable.app.resource.files";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final WeakHashMap<Object, Hashtable<? super String, Object>> propertiesCache = new WeakHashMap(11);
    private static final WeakHashMap<ClassLoader, Map<String, List<NamedWeakReference<Object>>>> factoryCache = new WeakHashMap(11);
    private static final WeakHashMap<ClassLoader, Map<String, WeakReference<Object>>> urlFactoryCache = new WeakHashMap(11);
    private static final WeakReference<Object> NO_FACTORY = new WeakReference<Object>(null);

    private ResourceManager() {
    }

    public static Hashtable<?, ?> getInitialEnvironment(Hashtable<?, ?> hashtable) throws NamingException {
        String[] stringArray = VersionHelper.PROPS;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
        }
        Object obj = hashtable.get("java.naming.applet");
        String[] stringArray2 = helper.getJndiProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = hashtable.get(stringArray[i]);
            if (object != null) continue;
            if (obj != null) {
                object = AppletParameter.get(obj, stringArray[i]);
            }
            if (object == null) {
                Object object2 = object = stringArray2 != null ? stringArray2[i] : helper.getJndiProperty(i);
            }
            if (object == null) continue;
            hashtable.put(stringArray[i], object);
        }
        String string = (String)hashtable.get(DISABLE_APP_RESOURCE_FILES);
        if (string != null && string.equalsIgnoreCase("true")) {
            return hashtable;
        }
        ResourceManager.mergeTables(hashtable, ResourceManager.getApplicationResources());
        return hashtable;
    }

    public static String getProperty(String string, Hashtable<?, ?> hashtable, Context context, boolean bl) throws NamingException {
        String string2;
        String string3 = string2 = hashtable != null ? (String)hashtable.get(string) : null;
        if (context == null || string2 != null && !bl) {
            return string2;
        }
        String string4 = (String)ResourceManager.getProviderResource(context).get(string);
        if (string2 == null) {
            return string4;
        }
        if (string4 == null || !bl) {
            return string2;
        }
        return string2 + ":" + string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryEnumeration getFactories(String string, Hashtable<?, ?> hashtable, Context context) throws NamingException {
        String string2 = ResourceManager.getProperty(string, hashtable, context, true);
        if (string2 == null) {
            return null;
        }
        ClassLoader classLoader = helper.getContextClassLoader();
        Map<String, List<NamedWeakReference<Object>>> map = null;
        Map<Object, Object> map2 = factoryCache;
        synchronized (map2) {
            map = factoryCache.get(classLoader);
            if (map == null) {
                map = new HashMap<String, List<NamedWeakReference<Object>>>(11);
                factoryCache.put(classLoader, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            List<NamedWeakReference<Object>> list = map.get(string2);
            if (list != null) {
                return list.size() == 0 ? null : new FactoryEnumeration(list, classLoader);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            list = new ArrayList<NamedWeakReference<Object>>(5);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string3 = stringTokenizer.nextToken();
                    Class<?> clazz = helper.loadClass(string3, classLoader);
                    list.add(new NamedWeakReference(clazz, string3));
                }
                catch (Exception exception) {}
            }
            map.put(string2, list);
            return new FactoryEnumeration(list, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String string, Hashtable<?, ?> hashtable, Context context, String string2, String string3) throws NamingException {
        String string4 = ResourceManager.getProperty(string, hashtable, context, true);
        string4 = string4 != null ? string4 + ":" + string3 : string3;
        ClassLoader classLoader = helper.getContextClassLoader();
        String string5 = string2 + " " + string4;
        Map<String, WeakReference<Object>> map = null;
        Map<Object, Object> map2 = urlFactoryCache;
        synchronized (map2) {
            map = urlFactoryCache.get(classLoader);
            if (map == null) {
                map = new HashMap<String, WeakReference<Object>>(11);
                urlFactoryCache.put(classLoader, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            Object t = null;
            WeakReference<Object> weakReference = map.get(string5);
            if (weakReference == NO_FACTORY) {
                return null;
            }
            if (weakReference != null && (t = (Object)weakReference.get()) != null) {
                return t;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
            while (t == null && stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken() + string2;
                try {
                    t = helper.loadClass(string6, classLoader).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    NamingException namingException = new NamingException("Cannot instantiate " + string6);
                    namingException.setRootCause(instantiationException);
                    throw namingException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    NamingException namingException = new NamingException("Cannot access " + string6);
                    namingException.setRootCause(illegalAccessException);
                    throw namingException;
                }
                catch (Exception exception) {
                }
            }
            map.put(string5, (WeakReference<Object>)(t != null ? new WeakReference<Object>(t) : NO_FACTORY));
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable<? super String, Object> getProviderResource(Object object) throws NamingException {
        if (object == null) {
            return new Hashtable(1);
        }
        WeakHashMap<Object, Hashtable<? super String, Object>> weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Class<? extends Object> clazz = object.getClass();
            Properties properties = propertiesCache.get(clazz);
            if (properties != null) {
                return properties;
            }
            properties = new Properties();
            InputStream inputStream = helper.getResourceAsStream(clazz, PROVIDER_RESOURCE_FILE_NAME);
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading provider resource file for " + clazz);
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            propertiesCache.put(clazz, properties);
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable<? super String, Object> getApplicationResources() throws NamingException {
        ClassLoader classLoader = helper.getContextClassLoader();
        WeakHashMap<Object, Hashtable<? super String, Object>> weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Object object;
            block23: {
                object = propertiesCache.get(classLoader);
                if (object != null) {
                    return object;
                }
                try {
                    Object object2;
                    Object object3;
                    NamingEnumeration<InputStream> namingEnumeration = helper.getResources(classLoader, "jndi.properties");
                    try {
                        while (namingEnumeration.hasMore()) {
                            object3 = new Properties();
                            object2 = namingEnumeration.next();
                            try {
                                ((Properties)object3).load((InputStream)object2);
                            }
                            finally {
                                ((InputStream)object2).close();
                            }
                            if (object == null) {
                                object = object3;
                                continue;
                            }
                            ResourceManager.mergeTables(object, (Hashtable<? super String, Object>)object3);
                        }
                    }
                    finally {
                        while (namingEnumeration.hasMore()) {
                            namingEnumeration.next().close();
                        }
                    }
                    object3 = helper.getJavaHomeLibStream("jndi.properties");
                    if (object3 == null) break block23;
                    try {
                        object2 = new Properties();
                        ((Properties)object2).load((InputStream)object3);
                        if (object == null) {
                            object = object2;
                        } else {
                            ResourceManager.mergeTables((Hashtable<? super String, Object>)object, (Hashtable<? super String, Object>)object2);
                        }
                    }
                    finally {
                        ((InputStream)object3).close();
                    }
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            if (object == null) {
                object = new Hashtable(11);
            }
            propertiesCache.put(classLoader, (Hashtable<? super String, Object>)object);
            return object;
        }
    }

    private static void mergeTables(Hashtable<? super String, Object> hashtable, Hashtable<? super String, Object> hashtable2) {
        for (String string : hashtable2.keySet()) {
            String string2 = string;
            Object object = hashtable.get(string2);
            if (object == null) {
                hashtable.put(string2, hashtable2.get(string2));
                continue;
            }
            if (!ResourceManager.isListProperty(string2)) continue;
            String string3 = (String)hashtable2.get(string2);
            hashtable.put(string2, (String)object + ":" + string3);
        }
    }

    private static boolean isListProperty(String string) {
        string = string.intern();
        for (int i = 0; i < listProperties.length; ++i) {
            if (string != listProperties[i]) continue;
            return true;
        }
        return false;
    }

    private static class AppletParameter {
        private static final Class<?> clazz = AppletParameter.getClass("java.applet.Applet");
        private static final Method getMethod = AppletParameter.getMethod(clazz, "getParameter", String.class);

        private AppletParameter() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            if (clazz != null) {
                try {
                    return clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)noSuchMethodException);
                }
            }
            return null;
        }

        static Object get(Object object, String string) {
            if (clazz == null || !clazz.isInstance(object)) {
                throw new ClassCastException(object.getClass().getName());
            }
            try {
                return getMethod.invoke(object, string);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }
    }
}

