/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;

public class LockInfo {
    private final String className;
    private final int identityHashCode;

    private LockInfo(Object object) {
        this(object.getClass().getName(), System.identityHashCode(object));
    }

    public LockInfo(String string, int n) {
        if (string == null) {
            throw new NullPointerException(Msg.getString("K0600"));
        }
        this.className = string;
        this.identityHashCode = n;
    }

    public String getClassName() {
        return this.className;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static LockInfo from(CompositeData compositeData) {
        LockInfo lockInfo = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 2);
            String[] stringArray = new String[]{"className", "identityHashCode"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.String", "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            String string = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            lockInfo = new LockInfo(string, n);
        }
        return lockInfo;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.className);
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.identityHashCode));
        return stringBuilder.toString();
    }
}

