/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.MethodType;
import java.lang.invoke.PrimitiveHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

abstract class FieldHandle
extends PrimitiveHandle {
    final Class<?> fieldClass;
    final int final_modifiers;

    FieldHandle(MethodType methodType, Class<?> clazz, String string, Class<?> clazz2, byte by, Class<?> clazz3) throws IllegalAccessException, NoSuchFieldException {
        super(methodType, clazz, string, by, null);
        this.fieldClass = clazz2;
        this.defc = this.finishFieldInitialization(clazz3);
        this.final_modifiers = this.rawModifiers;
        assert (this.isVMSlotCorrectlyTagged());
    }

    FieldHandle(MethodType methodType, Field field, byte by, boolean bl) throws IllegalAccessException {
        super(methodType, field.getDeclaringClass(), field.getName(), by, field.getModifiers(), null);
        this.fieldClass = field.getType();
        assert (bl == Modifier.isStatic(field.getModifiers()));
        boolean bl2 = FieldHandle.setVMSlotAndRawModifiersFromField(this, field);
        if (!bl2) {
            throw new IllegalAccessException();
        }
        this.final_modifiers = this.rawModifiers;
        assert (this.isVMSlotCorrectlyTagged());
    }

    FieldHandle(FieldHandle fieldHandle, MethodType methodType) {
        super(fieldHandle, methodType);
        this.fieldClass = fieldHandle.fieldClass;
        this.final_modifiers = this.rawModifiers;
        assert (this.isVMSlotCorrectlyTagged());
    }

    final Class<?> finishFieldInitialization(Class<?> clazz) throws IllegalAccessException, NoSuchFieldException {
        String string = MethodType.getBytecodeStringName(this.fieldClass);
        try {
            boolean bl = 2 == this.kind || 4 == this.kind;
            return this.lookupField(this.referenceClass, this.name, string, bl, clazz);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            throw new NoSuchFieldException(noSuchFieldError.getMessage());
        }
        catch (LinkageError linkageError) {
            throw (IllegalAccessException)new IllegalAccessException(linkageError.getMessage()).initCause(linkageError);
        }
    }

    boolean isVMSlotCorrectlyTagged() {
        if (4 == this.kind || 2 == this.kind) {
            return (this.vmSlot & 1L) == 1L;
        }
        return (this.vmSlot & 1L) == 0L;
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    final void compareWithField(FieldHandle fieldHandle, Comparator comparator) {
        comparator.compareStructuralParameter(fieldHandle.referenceClass, this.referenceClass);
        comparator.compareStructuralParameter(fieldHandle.vmSlot, this.vmSlot);
    }
}

