/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Arrays;
import java.util.Iterator;

public class GCHeapRegionManager {
    protected static GCHeapRegionManager singleton;
    protected MM_HeapRegionManagerPointer _heapRegionManager;
    GCHeapRegionDescriptor[] _auxRegionDescriptorList;
    protected int _auxRegionCount;
    protected UDATA _regionSize;
    protected UDATA _regionShift;
    protected GCHeapRegionDescriptor[] _regionTable;
    protected int _tableRegionCount;
    protected VoidPointer _lowTableEdge;
    protected VoidPointer _highTableEdge;
    protected UDATA _tableDescriptorSize;
    protected UDATA _totalHeapSize;

    protected GCHeapRegionManager(MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer) throws CorruptDataException {
        this._heapRegionManager = mM_HeapRegionManagerPointer;
        this._auxRegionCount = mM_HeapRegionManagerPointer._auxRegionCount().intValue();
        this._regionSize = mM_HeapRegionManagerPointer._regionSize();
        this._regionShift = mM_HeapRegionManagerPointer._regionShift();
        this._tableRegionCount = mM_HeapRegionManagerPointer._tableRegionCount().intValue();
        this._lowTableEdge = mM_HeapRegionManagerPointer._lowTableEdge();
        this._highTableEdge = mM_HeapRegionManagerPointer._highTableEdge();
        this._tableDescriptorSize = mM_HeapRegionManagerPointer._tableDescriptorSize();
        this._totalHeapSize = mM_HeapRegionManagerPointer._totalHeapSize();
        this.initializeTableRegionDescriptors();
        this.initializeAuxRegionDescriptors();
    }

    public static GCHeapRegionManager fromHeapRegionManager(MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer) throws CorruptDataException {
        if (null != singleton) {
            return singleton;
        }
        singleton = new GCHeapRegionManager(mM_HeapRegionManagerPointer);
        return singleton;
    }

    protected void initializeAuxRegionDescriptors() throws CorruptDataException {
        GCHeapRegionDescriptor[] gCHeapRegionDescriptorArray = new GCHeapRegionDescriptor[this._auxRegionCount];
        if (gCHeapRegionDescriptorArray.length > 0) {
            MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer = this._heapRegionManager._auxRegionDescriptorList();
            for (int i = 0; i < this._auxRegionCount; ++i) {
                gCHeapRegionDescriptorArray[i] = GCHeapRegionDescriptor.fromHeapRegionDescriptor(mM_HeapRegionDescriptorPointer);
                mM_HeapRegionDescriptorPointer = mM_HeapRegionDescriptorPointer._nextRegion();
            }
        }
        this._auxRegionDescriptorList = gCHeapRegionDescriptorArray;
    }

    protected void initializeTableRegionDescriptors() throws CorruptDataException {
        GCHeapRegionDescriptor[] gCHeapRegionDescriptorArray = new GCHeapRegionDescriptor[this._tableRegionCount];
        if (gCHeapRegionDescriptorArray.length > 0) {
            MM_HeapRegionDescriptorPointer mM_HeapRegionDescriptorPointer = this._heapRegionManager._regionTable();
            for (int i = 0; i < this._tableRegionCount; ++i) {
                gCHeapRegionDescriptorArray[i] = GCHeapRegionDescriptor.fromHeapRegionDescriptor(mM_HeapRegionDescriptorPointer);
                mM_HeapRegionDescriptorPointer = mM_HeapRegionDescriptorPointer.addOffset(this._tableDescriptorSize);
            }
        }
        this._regionTable = gCHeapRegionDescriptorArray;
    }

    public UDATA getTotalHeapSize() {
        return this._totalHeapSize;
    }

    public UDATA getRegionSize() {
        return this._regionSize;
    }

    public int getTableRegionCount() {
        return this._tableRegionCount;
    }

    public UDATA getHeapSize() {
        return new UDATA(this._highTableEdge.sub(this._lowTableEdge));
    }

    public Iterator<GCHeapRegionDescriptor> getAuxiliaryRegions() throws CorruptDataException {
        return Arrays.asList(this._auxRegionDescriptorList).iterator();
    }

    public Iterator<GCHeapRegionDescriptor> getTableRegions() throws CorruptDataException {
        return Arrays.asList(this._regionTable).iterator();
    }

    public GCHeapRegionDescriptor regionDescriptorForAddress(AbstractPointer abstractPointer) {
        GCHeapRegionDescriptor gCHeapRegionDescriptor = null;
        gCHeapRegionDescriptor = abstractPointer.gte(this._lowTableEdge) && abstractPointer.lt(this._highTableEdge) ? this.tableDescriptorForAddress(abstractPointer) : this.auxillaryDescriptorForAddress(abstractPointer);
        return gCHeapRegionDescriptor;
    }

    public GCHeapRegionDescriptor auxillaryDescriptorForAddress(AbstractPointer abstractPointer) {
        for (int i = 0; i < this._auxRegionCount; ++i) {
            GCHeapRegionDescriptor gCHeapRegionDescriptor = this._auxRegionDescriptorList[i];
            if (!gCHeapRegionDescriptor.isAddressInRegion(abstractPointer)) continue;
            return gCHeapRegionDescriptor;
        }
        return null;
    }

    public GCHeapRegionDescriptor tableDescriptorForIndex(int n) {
        return this._regionTable[n].getHeadOfSpan();
    }

    public GCHeapRegionDescriptor physicalTableDescriptorForIndex(int n) {
        return this._regionTable[n];
    }

    protected int physicalTableDescriptorIndexForAddress(AbstractPointer abstractPointer) {
        UDATA uDATA = UDATA.cast(abstractPointer).sub(UDATA.cast(this._regionTable[0].getLowAddress()));
        return uDATA.rightShift(this._regionShift).intValue();
    }

    public GCHeapRegionDescriptor tableDescriptorForAddress(AbstractPointer abstractPointer) {
        int n = this.physicalTableDescriptorIndexForAddress(abstractPointer);
        return this.tableDescriptorForIndex(n);
    }
}

