/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

abstract class JniRegisters {
    SortedMap<String, Number> _registers = new TreeMap<String, Number>(new RegisterComparator());

    JniRegisters() {
    }

    public static native long getNumberRegisters(long var0);

    public static native String getRegisterName(long var0);

    public static native Number getRegisterValue(long var0, long var2);

    private native boolean fetchRegisters(long var1);

    protected abstract long getStackPointer();

    protected abstract long getInstructionPointer();

    protected abstract long getLinkRegister();

    protected abstract long getBasePointer();

    public int size() {
        return this._registers.size();
    }

    public void setRegister(String string, long l) {
        this._registers.put(new String(string), new Long(l));
    }

    public SortedMap<String, Number> readRegisters(long l) {
        this.fetchRegisters(l);
        return this._registers;
    }

    public SortedMap<String, Number> getRegisters() {
        return this._registers;
    }

    public class RegisterComparator
    implements Comparator<String> {
        @Override
        public int compare(String string, String string2) {
            int n = string.length() - 1;
            if (n >= 1 && Character.isDigit(string.charAt(n)) && Character.isLetter(string.charAt(n - 1))) {
                string = string.substring(0, n) + "0" + string.substring(n);
            }
            if ((n = string2.length() - 1) >= 1 && Character.isDigit(string2.charAt(n)) && Character.isLetter(string2.charAt(n - 1))) {
                string2 = string2.substring(0, n) + "0" + string2.substring(n);
            }
            return string.compareTo(string2);
        }
    }
}

