/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.DoublePointer;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.I16Pointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class J9ObjectStructureFormatter
extends BaseStructureFormatter {
    public static final int DEFAULT_ARRAY_FORMAT_BEGIN = 0;
    public static final int DEFAULT_ARRAY_FORMAT_END = 16;
    public static final String PADDING = "      ";

    @Override
    public FormatWalkResult format(String string, long l, PrintStream printStream, Context context, List<IFieldFormatter> list, String[] stringArray) {
        if (string.equalsIgnoreCase("j9object") || string.equalsIgnoreCase("j9indexableobject")) {
            J9ClassPointer j9ClassPointer = null;
            J9ObjectPointer j9ObjectPointer = null;
            try {
                j9ObjectPointer = J9ObjectPointer.cast(l);
                j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
                if (j9ClassPointer.isNull()) {
                    printStream.println("<can not read RAM class address>");
                    return FormatWalkResult.STOP_WALKING;
                }
                boolean bl = J9ClassHelper.isArrayClass(j9ClassPointer);
                String string2 = J9UTF8Helper.stringValue(j9ClassPointer.romClass().className());
                U8Pointer u8Pointer = U8Pointer.cast(j9ObjectPointer).add(ObjectModel.getHeaderSize(j9ObjectPointer));
                if (string2.equals("java/lang/String")) {
                    this.formatStringObject(printStream, 0, j9ClassPointer, u8Pointer, j9ObjectPointer);
                } else if (bl) {
                    int n = 0;
                    int n2 = 16;
                    if (stringArray.length > 0) {
                        n = Integer.parseInt(stringArray[0]);
                    }
                    if (stringArray.length > 1) {
                        n2 = Integer.parseInt(stringArray[1]);
                    }
                    this.formatArrayObject(printStream, j9ClassPointer, u8Pointer, J9IndexableObjectPointer.cast(j9ObjectPointer), n, n2);
                } else {
                    this.formatObject(printStream, j9ClassPointer, u8Pointer, j9ObjectPointer);
                }
            }
            catch (MemoryFault memoryFault) {
                printStream.println("Unable to read object clazz at " + j9ObjectPointer.getHexAddress() + " (clazz = " + j9ClassPointer.getHexAddress() + ")");
            }
            catch (CorruptDataException corruptDataException) {
                printStream.println("Error for ");
                corruptDataException.printStackTrace(printStream);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private void formatObject(PrintStream printStream, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        printStream.print(String.format("!J9Object %s {", j9ObjectPointer.getHexAddress()));
        printStream.println();
        this.printJ9ObjectFields(printStream, 1, j9ClassPointer, u8Pointer, j9ObjectPointer);
        printStream.println("}");
    }

    private void formatArrayObject(PrintStream printStream, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
        printStream.print(String.format("!J9IndexableObject %s {", j9IndexableObjectPointer.getHexAddress()));
        printStream.println();
        printStream.println(String.format("    struct J9Class* clazz = !j9arrayclass 0x%X   // %s", j9ClassPointer.getAddress(), string));
        printStream.println(String.format("    Object flags = %s;", J9IndexableObjectHelper.flags(j9IndexableObjectPointer).getHexValue()));
        U32 u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (!J9BuildFlags.thr_lockNursery) {
            printStream.println(String.format("    j9objectmonitor_t monitor = %s;", J9IndexableObjectHelper.monitor(j9IndexableObjectPointer).getHexValue()));
        }
        if (u32.anyBitsIn(Integer.MIN_VALUE)) {
            printStream.println(String.format("    U_32 size = %s; // Size exceeds Integer.MAX_VALUE!", u32.getHexValue()));
        } else {
            printStream.println(String.format("    U_32 size = %s;", u32.getHexValue()));
        }
        this.printSubArrayType(printStream, 1, j9ClassPointer, u8Pointer, n, n2, j9IndexableObjectPointer);
        printStream.println("}");
    }

    void printSubArrayType(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, int n2, int n3, J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        int n4;
        U32 u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (u32.anyBitsIn(Integer.MIN_VALUE)) {
            u32 = new U32(Integer.MAX_VALUE);
        }
        if (n2 < (n4 = Math.min(u32.intValue(), n3))) {
            String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
            char c = string.charAt(1);
            switch (c) {
                case 'B': 
                case 'Z': {
                    for (int i = n2; i < n4; ++i) {
                        this.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 1);
                        printStream.println(String.format("[%d] = %3d, 0x%02x", i, U8Pointer.cast(voidPointer).at(0L).longValue(), U8Pointer.cast(voidPointer).at(0L).longValue()));
                    }
                    break;
                }
                case 'C': {
                    for (int i = n2; i < n4; ++i) {
                        this.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 2);
                        long l = U16Pointer.cast(voidPointer).at(0L).longValue();
                        printStream.println(String.format("[%d] = %5d, 0x%2$04x, '%c'", i, l, Character.valueOf((char)l)));
                    }
                    break;
                }
                case 'S': {
                    for (int i = n2; i < n4; ++i) {
                        this.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 2);
                        printStream.println(String.format("[%d] = %6d, 0x%04x", i, I16Pointer.cast(voidPointer).at(0L).longValue(), U16Pointer.cast(voidPointer).at(0L).longValue()));
                    }
                    break;
                }
                case 'F': 
                case 'I': {
                    for (int i = n2; i < n4; ++i) {
                        this.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 4);
                        printStream.println(String.format("[%d] = %10d, 0x%08x, %8.8fF", i, I32Pointer.cast(voidPointer).at(0L).longValue(), U32Pointer.cast(voidPointer).at(0L).longValue(), Float.valueOf(FloatPointer.cast(voidPointer).floatAt(0L))));
                    }
                    break;
                }
                case 'D': 
                case 'J': {
                    for (int i = n2; i < n4; ++i) {
                        this.padding(printStream, n);
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, 8);
                        printStream.println(String.format("[%d] = %2d, 0x%016x, %8.8fF", i, I64Pointer.cast(voidPointer).at(0L).longValue(), I64Pointer.cast(voidPointer).at(0L).longValue(), DoublePointer.cast(voidPointer).doubleAt(0L)));
                    }
                    break;
                }
                case 'L': 
                case '[': {
                    for (int i = n2; i < n4; ++i) {
                        VoidPointer voidPointer = J9IndexableObjectHelper.getElementEA(j9IndexableObjectPointer, i, (int)ObjectReferencePointer.SIZEOF);
                        if (voidPointer.notNull()) {
                            long l = J9BuildFlags.gc_compressedPointers ? I32Pointer.cast(voidPointer).at(0L).longValue() : DataType.getProcess().getPointerAt(voidPointer.getAddress());
                            this.padding(printStream, n);
                            printStream.println(String.format("[%d] = !fj9object 0x%x = !j9object 0x%x", i, l, ObjectReferencePointer.cast(voidPointer).at(0L).longValue()));
                            continue;
                        }
                        this.padding(printStream, n);
                        printStream.println(String.format("[%d] = null", voidPointer));
                    }
                    break;
                }
            }
        }
        u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (n2 > 0 || u32.longValue() > (long)n4) {
            printStream.println(String.format("To print entire range: !j9indexableobject %s %d %d\n", j9IndexableObjectPointer.getHexAddress(), 0, u32.longValue()));
        }
    }

    private void formatStringObject(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        printStream.println(String.format("J9VMJavaLangString at %s {\n", j9ObjectPointer.getHexAddress()));
        this.printJ9ObjectFields(printStream, n, j9ClassPointer, u8Pointer, j9ObjectPointer);
        this.padding(printStream, n);
        printStream.println(String.format("\"%s\"\n", J9ObjectHelper.stringValue(j9ObjectPointer)));
        printStream.println("}");
    }

    private void printJ9ObjectFields(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        DataType dataType;
        J9ClassPointer j9ClassPointer2 = j9ClassPointer;
        DataType dataType2 = J9ClassPointer.NULL;
        boolean bl = false;
        if (J9BuildFlags.thr_lockNursery) {
            bl = false;
        }
        J9UTF8Pointer j9UTF8Pointer = j9ClassPointer2.romClass().className();
        this.padding(printStream, n);
        printStream.println(String.format("struct J9Class* clazz = !j9class 0x%X   // %s", j9ClassPointer.getAddress(), J9UTF8Helper.stringValue(j9UTF8Pointer)));
        this.padding(printStream, n);
        printStream.println(String.format("Object flags = %s;", J9ObjectHelper.flags(j9ObjectPointer).getHexValue()));
        if (!J9BuildFlags.thr_lockNursery && (dataType = J9ObjectHelper.monitor(j9ObjectPointer)) != null) {
            this.padding(printStream, n);
            printStream.println(String.format("j9objectmonitor_t monitor = %s;", ((Scalar)dataType).getHexValue()));
        }
        long l = J9ClassHelper.classDepth(j9ClassPointer2).longValue();
        for (long i = 0L; i <= l; ++i) {
            dataType = i == l ? j9ClassPointer2 : J9ClassPointer.cast(j9ClassPointer2.superclasses().at(i));
            U32 u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
            Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(((J9ClassPointer)dataType).romClass(), j9ClassPointer2, dataType2, u32);
            while (iterator.hasNext()) {
                J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                boolean bl2 = true;
                boolean bl3 = j9ObjectFieldOffset.isHidden();
                if (J9BuildFlags.thr_lockNursery) {
                    boolean bl4;
                    boolean bl5 = bl4 = bl3 && j9ObjectFieldOffset.getOffsetOrAddress().add(J9Object.SIZEOF).eq(((J9ClassPointer)dataType).lockOffset());
                    if (bl4) {
                        boolean bl6 = bl2 = !bl && j9ClassPointer2.lockOffset().eq(((J9ClassPointer)dataType).lockOffset());
                        if (bl2) {
                            bl = true;
                        }
                    }
                }
                if (!bl2) continue;
                this.printObjectField(printStream, n, j9ClassPointer, u8Pointer, (J9ClassPointer)dataType, j9ObjectFieldOffset);
                printStream.println();
            }
            dataType2 = dataType;
        }
    }

    public void printObjectField(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ClassPointer j9ClassPointer2, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        J9ROMFieldShapePointer j9ROMFieldShapePointer = j9ObjectFieldOffset.getField();
        UDATA uDATA = j9ObjectFieldOffset.getOffsetOrAddress();
        boolean bl = j9ObjectFieldOffset.isHidden();
        String string = J9UTF8Helper.stringValue(j9ClassPointer2.romClass().className());
        String string2 = J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().name());
        String string3 = J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().signature());
        U8Pointer u8Pointer2 = u8Pointer;
        u8Pointer2 = u8Pointer2.add(uDATA);
        this.padding(printStream, n);
        printStream.print(String.format("%s %s = ", string3, string2));
        if (j9ROMFieldShapePointer.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            printStream.print(U64Pointer.cast(u8Pointer2).at(0L).getHexValue());
        } else if (j9ROMFieldShapePointer.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            UDATAPointer uDATAPointer = J9BuildFlags.gc_compressedPointers ? U32Pointer.cast(u8Pointer2) : UDATAPointer.cast(u8Pointer2);
            printStream.print(String.format("!fj9object 0x%x", ((AbstractPointer)uDATAPointer).at(0L).longValue()));
        } else {
            printStream.print(I32Pointer.cast(u8Pointer2).at(0L).getHexValue());
        }
        printStream.print(String.format(" (offset=%d) (%s)", uDATA.longValue(), string));
        if (bl) {
            printStream.print(" <hidden>");
        }
    }

    private void padding(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(PADDING);
        }
    }
}

