/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCEmptyObjectIterator_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCMixedObjectIterator_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCPointerArrayIterator_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCPointerArrayletIterator_V1;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class GCObjectIterator
extends GCIterator {
    protected J9ObjectPointer object;
    protected boolean includeClassSlot;

    protected GCObjectIterator(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        this.object = j9ObjectPointer;
        this.includeClassSlot = bl;
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract J9ObjectPointer next();

    @Override
    public abstract VoidPointer nextAddress();

    public static GCObjectIterator fromJ9Object(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        if (ObjectModel.isIndexable(j9ObjectPointer)) {
            UDATA uDATA = ObjectModel.getClassShape(j9ObjectPointer);
            if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
                return GCObjectIterator.getPointerArrayImpl(j9ObjectPointer, bl);
            }
            return GCObjectIterator.getEmptyObjectIteratorImpl(j9ObjectPointer, bl);
        }
        return GCObjectIterator.getMixedObjectIteratorImpl(j9ObjectPointer, bl);
    }

    public static GCObjectIterator fromJ9Class(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) throws CorruptDataException {
        if (J9ClassHelper.isArrayClass(j9ClassPointer)) {
            UDATA uDATA = ObjectModel.getClassShape(j9ClassPointer);
            if (uDATA.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
                return GCObjectIterator.getPointerArrayImpl(j9ClassPointer, voidPointer);
            }
            return GCObjectIterator.getEmptyObjectIteratorImpl(j9ClassPointer, voidPointer);
        }
        return GCObjectIterator.getMixedObjectIteratorImpl(j9ClassPointer, voidPointer);
    }

    private static GCObjectIterator getPointerArrayImpl(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        if (J9BuildFlags.gc_arraylets) {
            AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_GC_POINTER_ARRAYLET_ITERATOR_VERSION");
            switch (algorithmVersion.getAlgorithmVersion()) {
                default: 
            }
            return new GCPointerArrayletIterator_V1(j9ObjectPointer, bl);
        }
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_GC_POINTER_ARRAY_ITERATOR_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new GCPointerArrayIterator_V1(j9ObjectPointer, bl);
    }

    private static GCObjectIterator getPointerArrayImpl(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) throws CorruptDataException {
        throw new IllegalArgumentException("Not implemented yet");
    }

    private static GCObjectIterator getEmptyObjectIteratorImpl(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new GCEmptyObjectIterator_V1(j9ObjectPointer, bl);
    }

    private static GCObjectIterator getEmptyObjectIteratorImpl(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new GCEmptyObjectIterator_V1(null, false);
    }

    private static GCObjectIterator getMixedObjectIteratorImpl(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_ITERATOR_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectIterator_V1(j9ObjectPointer, bl);
    }

    private static GCObjectIterator getMixedObjectIteratorImpl(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) throws CorruptDataException {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_ITERATOR_VERSION");
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectIterator_V1(j9ClassPointer, voidPointer);
    }
}

