/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.AsTypeHandle;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.BruteArgumentMoverHandle;
import java.lang.invoke.CacheKey;
import java.lang.invoke.CallSite;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.OpenJDKCompileStub;
import java.lang.invoke.PermuteHandle;
import java.lang.invoke.PrimitiveHandle;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.SpreadHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;

public abstract class MethodHandle {
    static final byte KIND_BOUND = 0;
    static final byte KIND_GETFIELD = 1;
    static final byte KIND_GETSTATICFIELD = 2;
    static final byte KIND_PUTFIELD = 3;
    static final byte KIND_PUTSTATICFIELD = 4;
    static final byte KIND_VIRTUAL = 5;
    static final byte KIND_STATIC = 6;
    static final byte KIND_SPECIAL = 7;
    static final byte KIND_CONSTRUCTOR = 8;
    static final byte KIND_INTERFACE = 9;
    static final byte KIND_COLLECT = 10;
    static final byte KIND_INVOKEEXACT = 11;
    static final byte KIND_INVOKEGENERIC = 12;
    static final byte KIND_ASTYPE = 13;
    static final byte KIND_DYNAMICINVOKER = 14;
    static final byte KIND_FILTERRETURN = 15;
    static final byte KIND_EXPLICITCAST = 16;
    static final byte KIND_VARARGSCOLLECT = 17;
    static final byte KIND_PASSTHROUGH = 18;
    static final byte KIND_SPREAD = 19;
    static final byte KIND_INSERT = 20;
    static final byte KIND_PERMUTE = 21;
    static final byte KIND_CONSTANTOBJECT = 22;
    static final byte KIND_CONSTANTINT = 23;
    static final byte KIND_CONSTANTFLOAT = 24;
    static final byte KIND_CONSTANTLONG = 25;
    static final byte KIND_CONSTANTDOUBLE = 26;
    static final byte KIND_FOLDHANDLE = 27;
    static final byte KIND_GUARDWITHTEST = 28;
    static final byte KIND_FILTERARGUMENTS = 29;
    static final byte KIND_VARHANDLEINVOKEEXACT = 30;
    static final byte KIND_VARHANDLEINVOKEGENERIC = 31;
    MethodHandle asTypeCache = null;
    LambdaForm form = null;
    static final int PUBLIC_FINAL_NATIVE = 4369;
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final JITHelpers JITHELPERS = JITHelpers.getHelpers();
    private static final int CUSTOM_THUNK_INVOCATION_COUNT = 1000;
    private static final int DONT_CHECK_FOR_A_WHILE_COUNT = -1000000000;
    final MethodType type;
    final byte kind;
    int invocationCount;
    ThunkTuple thunks;
    static final int VTABLE_ENTRY_SIZE = VM.ADDRESS_SIZE;
    static final int VTABLE_ENTRY_SHIFT = 31 - Integer.numberOfLeadingZeros(VTABLE_ENTRY_SIZE);
    static final int J9CLASS_OFFSET = MethodHandle.vmRefFieldOffset(Class.class);
    static final long INTRP_VTABLE_OFFSET = VM.J9CLASS_SIZE;
    static final int HEADER_SIZE = VM.OBJECT_HEADER_SIZE;
    static final Class<?>[] EMPTY_CLASS_ARRAY;
    CacheKey cacheKey;
    private MethodHandle previousAsType;
    private static final int BSM_ARGUMENT_SIZE = 2;
    private static final int BSM_ARGUMENT_COUNT_OFFSET = 2;
    private static final int BSM_ARGUMENTS_OFFSET = 4;
    private static final int BSM_LOOKUP_ARGUMENT_INDEX = 0;
    private static final int BSM_NAME_ARGUMENT_INDEX = 1;
    private static final int BSM_TYPE_ARGUMENT_INDEX = 2;
    private static final int BSM_OPTIONAL_ARGUMENTS_START_INDEX = 3;

    final void doCustomizationLogic() {
        if (++this.invocationCount > 1000) {
            this.requestCustomThunk();
            this.invocationCount = -1000000000;
        }
    }

    final void undoCustomizationLogic(MethodHandle methodHandle) {
        --methodHandle.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle methodHandle, MethodHandle methodHandle2) {
        --methodHandle.invocationCount;
        --methodHandle2.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        --methodHandle.invocationCount;
        --methodHandle2.invocationCount;
        --methodHandle3.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle ... methodHandleArray) {
        for (MethodHandle methodHandle : methodHandleArray) {
            if (methodHandle == null) continue;
            --methodHandle.invocationCount;
        }
    }

    final void requestCustomThunk() {
        this.thunks = ThunkTuple.copyOf(this.thunks);
        this.requestCustomThunkFromJit(this.thunks);
    }

    private native void requestCustomThunkFromJit(ThunkTuple var1);

    ThunkTable thunkTable() {
        throw new UnsupportedOperationException("Subclass must implement this");
    }

    ThunkTuple computeThunks(Object object) {
        return this.thunkTable().get(new ThunkKey(ThunkKey.computeThunkableType(this.type())));
    }

    final long invokeExactTargetAddress() {
        return this.thunks.invokeExactThunk;
    }

    static long getJ9ClassFromClass(Class<?> clazz) {
        if (JITHELPERS.is32Bit()) {
            return JITHELPERS.getJ9ClassFromClass32(clazz);
        }
        return JITHELPERS.getJ9ClassFromClass64(clazz);
    }

    MethodHandle cloneWithNewType(MethodType methodType) {
        throw new UnsupportedOperationException("Subclass must implement this");
    }

    private static MethodHandle asType(MethodHandle methodHandle, MethodType methodType) {
        return methodHandle.asType(methodType);
    }

    MethodHandle(MethodType methodType, byte by, Object object) {
        this.kind = by;
        this.type = methodType;
        MethodHandle.enforceArityLimit(by, this.type);
        this.thunks = this.computeThunks(object);
        long l = this.thunks.invokeExactThunk;
    }

    MethodHandle(MethodHandle methodHandle, MethodType methodType) {
        this.kind = methodHandle.kind;
        this.type = methodType;
        MethodHandle.enforceArityLimit(methodHandle.kind, methodType);
        this.thunks = methodHandle.thunks;
        this.previousAsType = methodHandle.previousAsType;
    }

    Class<?> getDefc() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    Class<?> getReferenceClass() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    Class<?> getSpecialCaller() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    String getMethodName() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    int getModifiers() throws InternalError {
        throw new InternalError(Msg.getString("K05da"));
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable, WrongMethodTypeException;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable, WrongMethodTypeException, ClassCastException;

    private static native boolean lookupVMDispatchTargets(long[] var0);

    public MethodType type() {
        return this.type;
    }

    public MethodHandle asSpreader(Class<?> clazz, int n) throws IllegalArgumentException, WrongMethodTypeException {
        return this.asSpreaderCommon(this.type.parameterCount() - n, clazz, n);
    }

    private final MethodHandle asSpreaderCommon(int n, Class<?> clazz, int n2) throws IllegalArgumentException, WrongMethodTypeException {
        MethodType methodType;
        int n3 = this.type.parameterCount();
        if (!clazz.isArray() || n < 0 || n > n3) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 > n3) {
            MethodHandle.throwIllegalArgumentExceptionForMHArgCount();
        }
        MethodHandle methodHandle = this;
        if (0 == n2) {
            methodType = this.type.insertParameterTypes(n, clazz);
        } else {
            Class<?> clazz2 = clazz.getComponentType();
            methodType = this.type.changeParameterType(n, clazz);
            if (n2 > 1) {
                methodType = methodType.dropParameterTypes(n + 1, n + n2);
            }
            Object[] objectArray = (Class[])this.type.arguments.clone();
            Arrays.fill(objectArray, n, n + n2, clazz2);
            methodHandle = this.asType(MethodType.methodType(this.type.returnType, objectArray));
        }
        return new SpreadHandle(methodHandle, methodType, clazz, n2, n);
    }

    public MethodHandle asCollector(Class<?> clazz, int n) throws IllegalArgumentException, WrongMethodTypeException, NullPointerException {
        return this.asCollectorCommon(this.type.parameterCount() - 1, clazz, n);
    }

    private final MethodHandle asCollectorCommon(int n, Class<?> clazz, int n2) throws IllegalArgumentException, WrongMethodTypeException, NullPointerException {
        int n3 = this.type.parameterCount();
        if (0 == n3 || n2 < 0 || n2 > 255 || n < 0 || n >= n3) {
            throw new IllegalArgumentException();
        }
        clazz.getClass();
        Class<?> clazz2 = this.type.parameterType(n);
        if (!clazz.isArray() || !clazz2.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Msg.getString("K05cc", (Object)clazz.toString(), this.type.toString()));
        }
        return new CollectHandle(this.asType(this.type.changeParameterType(n, clazz)), n2, n);
    }

    public MethodHandle asType(MethodType methodType) throws ClassCastException {
        if (this.type.equals(methodType)) {
            return this;
        }
        MethodHandle methodHandle = this.previousAsType;
        if (methodHandle != null && methodHandle.type == methodType) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = this;
        Class<?> clazz = this.type.returnType;
        Class<?> clazz2 = methodType.returnType;
        if (clazz != clazz2) {
            if (clazz2.isAssignableFrom(clazz)) {
                methodHandle2 = this.cloneWithNewType(MethodType.methodType(clazz2, this.type.arguments));
            } else {
                MethodHandle methodHandle3 = ConvertHandle.FilterHelpers.getReturnFilter(clazz, clazz2, false);
                methodHandle2 = new FilterReturnHandle(this, methodHandle3);
            }
        }
        if (methodHandle2.type != methodType) {
            methodHandle2 = new AsTypeHandle(methodHandle2, methodType);
        }
        this.previousAsType = methodHandle2;
        return methodHandle2;
    }

    private static final native int vmRefFieldOffset(Class<?> var0);

    public Object invokeWithArguments(Object ... objectArray) throws Throwable, WrongMethodTypeException, ClassCastException {
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (n != this.type.arguments.length) {
            throw MethodHandle.newWrongMethodTypeException(this.type, objectArray, n);
        }
        if (n < 253) {
            return IWAContainer.getMH(this.type.arguments.length).invokeExact(this, objectArray);
        }
        return this.asSpreader(Object[].class, n).invoke(objectArray);
    }

    private static WrongMethodTypeException newWrongMethodTypeException(MethodType methodType, Object[] objectArray, int n) {
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            Class clazz = Void.class;
            Object object = objectArray[i];
            if (object != null) {
                clazz = object.getClass();
            }
            classArray[i] = clazz;
        }
        return WrongMethodTypeException.newWrongMethodTypeException(methodType, MethodType.methodType(methodType.returnType, classArray));
    }

    private static native Object invokeWithArgumentsHelper(MethodHandle var0, Object[] var1);

    public Object invokeWithArguments(List<?> list) throws Throwable, WrongMethodTypeException, ClassCastException, NullPointerException {
        return this.invokeWithArguments(list.toArray());
    }

    public MethodHandle asVarargsCollector(Class<?> clazz) throws IllegalArgumentException {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz2 = this.type().lastParameterType();
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        return new VarargsCollectorHandle(this, clazz, false);
    }

    public boolean isVarargsCollector() {
        return this instanceof VarargsCollectorHandle;
    }

    boolean canRevealDirect() {
        return false;
    }

    boolean directHandleOriginatedInFindVirtual() {
        return false;
    }

    public MethodHandle asFixedArity() {
        return this;
    }

    public MethodHandle bindTo(Object object) throws IllegalArgumentException, ClassCastException {
        Class<?> clazz = this.type().parameterType(0);
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        object = clazz.cast(object);
        if (this.getClass() == DirectHandle.class) {
            return new ReceiverBoundHandle((PrimitiveHandle)this, object, MethodHandles.insertArguments(this, 0, object));
        }
        return MethodHandles.insertArguments(this, 0, object);
    }

    MethodHandle permuteArguments(MethodType methodType, int ... nArray) {
        MethodHandle methodHandle = new PermuteHandle(methodType, this, nArray);
        methodHandle = new BruteArgumentMoverHandle(methodType, this, nArray, EMPTY_CLASS_ARRAY, methodHandle);
        return methodHandle;
    }

    MethodHandle insertArguments(MethodHandle methodHandle, MethodHandle methodHandle2, int n, Object ... objectArray) {
        MethodHandle methodHandle3 = methodHandle;
        int n2 = objectArray.length;
        MethodType methodType = methodHandle.type();
        int[] nArray = BruteArgumentMoverHandle.insertPermute(BruteArgumentMoverHandle.identityPermute(methodType), n, n2, -1);
        methodHandle3 = new BruteArgumentMoverHandle(methodType, methodHandle2, nArray, objectArray, methodHandle3);
        return methodHandle3;
    }

    private static final Class<?> fromFieldDescriptorString(String string, ClassLoader classLoader) {
        ArrayList arrayList = new ArrayList();
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException(Msg.getString("K05d3", string));
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        MethodType.parseIntoClass(cArray, 0, arrayList, classLoader, string);
        return arrayList.get(0);
    }

    private static final native int getCPTypeAt(Object var0, int var1);

    private static final native MethodType getCPMethodTypeAt(Object var0, int var1);

    private static final native MethodHandle getCPMethodHandleAt(Object var0, int var1);

    private static final native String getCPClassNameAt(Class<?> var0, int var1);

    private static final MethodHandle resolveInvokeDynamic(long l, String string, String string2, long l2) throws Throwable {
        MethodHandle methodHandle = null;
        MethodType methodType = null;
        try {
            VMLangAccess vMLangAccess = VM.getVMLangAccess();
            Object object = vMLangAccess.createInternalRamClass(l);
            Class clazz = null;
            clazz = JITHELPERS.is32Bit() ? JITHELPERS.getClassFromJ9Class32((int)l) : JITHELPERS.getClassFromJ9Class64(l);
            Objects.requireNonNull(clazz);
            methodType = MethodType.vmResolveFromMethodDescriptorString(string2, vMLangAccess.getClassloader(clazz), null);
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(clazz, false);
            try {
                lookup.accessCheckArgRetTypes(methodType);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessError illegalAccessError = new IllegalAccessError();
                illegalAccessError.initCause(illegalAccessException);
                throw illegalAccessError;
            }
            short s = UNSAFE.getShort(l2);
            int n = UNSAFE.getShort(l2 + 2L);
            long l3 = l2 + 4L;
            MethodHandle methodHandle2 = MethodHandle.getCPMethodHandleAt(object, s);
            if (null == methodHandle2) {
                throw new NullPointerException(Msg.getString("K05cd", (Object)clazz.toString(), s));
            }
            Object[] objectArray = new Object[3 + n];
            objectArray[0] = lookup;
            objectArray[1] = string;
            objectArray[2] = methodType;
            ConstantPool constantPool = vMLangAccess.getConstantPool(object);
            boolean bl = methodHandle2.isVarargsCollector();
            Class<?> clazz2 = methodHandle2.type.lastParameterType().getComponentType();
            int n2 = methodHandle2.type.parameterCount();
            for (int i = 0; i < n; ++i) {
                int n3 = 3 + i;
                short s2 = UNSAFE.getShort(l3 + (long)(i * 2));
                int n4 = MethodHandle.getCPTypeAt(object, s2);
                Object object2 = null;
                switch (n4) {
                    case 1: {
                        object2 = constantPool.getClassAt(s2);
                        if (object2 != null) break;
                        throw MethodHandle.throwNoClassDefFoundError(clazz, s2);
                    }
                    case 2: {
                        object2 = constantPool.getStringAt(s2);
                        break;
                    }
                    case 3: {
                        int n5 = constantPool.getIntAt(s2);
                        Class<?> clazz3 = bl && n3 >= n2 - 1 ? clazz2 : methodHandle2.type.parameterType(n3);
                        if (clazz3 == Short.TYPE) {
                            object2 = (short)n5;
                            break;
                        }
                        if (clazz3 == Boolean.TYPE) {
                            object2 = n5 == 0 ? Boolean.FALSE : Boolean.TRUE;
                            break;
                        }
                        if (clazz3 == Byte.TYPE) {
                            object2 = (byte)n5;
                            break;
                        }
                        if (clazz3 == Character.TYPE) {
                            object2 = Character.valueOf((char)n5);
                            break;
                        }
                        object2 = n5;
                        break;
                    }
                    case 4: {
                        object2 = Float.valueOf(constantPool.getFloatAt(s2));
                        break;
                    }
                    case 5: {
                        object2 = constantPool.getLongAt(s2);
                        break;
                    }
                    case 6: {
                        object2 = constantPool.getDoubleAt(s2);
                        break;
                    }
                    case 13: {
                        object2 = MethodHandle.getCPMethodTypeAt(object, s2);
                        break;
                    }
                    case 14: {
                        object2 = MethodHandle.getCPMethodHandleAt(object, s2);
                        break;
                    }
                }
                object2.getClass();
                objectArray[n3] = object2;
            }
            CallSite callSite = null;
            switch (objectArray.length) {
                case 3: {
                    callSite = methodHandle2.invoke(objectArray[0], objectArray[1], objectArray[2]);
                    break;
                }
                case 4: {
                    callSite = methodHandle2.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
                    break;
                }
                case 5: {
                    callSite = methodHandle2.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
                    break;
                }
                case 6: {
                    callSite = methodHandle2.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5]);
                    break;
                }
                case 7: {
                    callSite = methodHandle2.invoke(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6]);
                    break;
                }
                default: {
                    callSite = (CallSite)methodHandle2.invokeWithArguments(objectArray);
                }
            }
            if (callSite != null) {
                MethodType methodType2 = callSite.type();
                if (methodType2 != methodType) {
                    throw WrongMethodTypeException.newWrongMethodTypeException(methodType, methodType2);
                }
                methodHandle = callSite.dynamicInvoker();
            }
        }
        catch (Throwable throwable) {
            if (methodType == null) {
                throw new BootstrapMethodError(throwable);
            }
            try {
                MethodHandle methodHandle3 = MethodHandles.throwException(methodType.returnType(), BootstrapMethodError.class);
                MethodHandle methodHandle4 = MethodHandles.Lookup.IMPL_LOOKUP.findConstructor(BootstrapMethodError.class, MethodType.methodType(Void.TYPE, Throwable.class));
                methodHandle = MethodHandles.foldArguments(methodHandle3, methodHandle4.bindTo(throwable));
                methodHandle = MethodHandles.dropArguments(methodHandle, 0, methodType.parameterList());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error(illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error(noSuchMethodException);
            }
        }
        return methodHandle;
    }

    private static final Throwable throwNoClassDefFoundError(Class<?> clazz, int n) {
        String string = MethodHandle.getCPClassNameAt(clazz, n);
        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(string);
        noClassDefFoundError.initCause(new ClassNotFoundException(string));
        throw noClassDefFoundError;
    }

    public String toString() {
        return "MethodHandle" + this.type.toString();
    }

    private final MethodHandle forGenericInvoke(MethodType methodType, boolean bl) {
        if (this.type == methodType) {
            return this;
        }
        if (bl) {
            return this.asType(methodType.dropFirstParameterType());
        }
        return this.asType(methodType);
    }

    private static final MethodHandle sendResolveMethodHandle(int n, Class<?> clazz, Class<?> clazz2, String string, String string2, ClassLoader classLoader) throws Throwable {
        try {
            MethodHandles.Lookup lookup = new MethodHandles.Lookup(clazz, false);
            MethodType methodType = null;
            MethodHandle methodHandle = null;
            switch (n) {
                case 1: {
                    methodHandle = lookup.findGetter(clazz2, string, MethodHandle.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 2: {
                    methodHandle = lookup.findStaticGetter(clazz2, string, MethodHandle.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 3: {
                    methodHandle = lookup.findSetter(clazz2, string, MethodHandle.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 4: {
                    methodHandle = lookup.findStaticSetter(clazz2, string, MethodHandle.resolveFieldHandleHelper(string2, lookup, classLoader));
                    break;
                }
                case 5: {
                    methodType = MethodType.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findVirtual(clazz2, string, methodType);
                    break;
                }
                case 6: {
                    methodType = MethodType.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findStatic(clazz2, string, methodType);
                    break;
                }
                case 7: {
                    methodType = MethodType.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findSpecial(clazz2, string, methodType, clazz);
                    break;
                }
                case 8: {
                    methodType = MethodType.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findConstructor(clazz2, methodType);
                    break;
                }
                case 9: {
                    methodType = MethodType.vmResolveFromMethodDescriptorString(string2, classLoader, null);
                    lookup.accessCheckArgRetTypes(methodType);
                    methodHandle = lookup.findVirtual(clazz2, string, methodType);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return methodHandle;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage()).initCause(illegalAccessException);
        }
    }

    private static final Class<?> resolveFieldHandleHelper(String string, MethodHandles.Lookup lookup, ClassLoader classLoader) throws Throwable {
        MethodType methodType = MethodType.vmResolveFromMethodDescriptorString("(" + string + ")V", classLoader, null);
        lookup.accessCheckArgRetTypes(methodType);
        return methodType.parameterType(0);
    }

    private MethodHandle returnFilterPlaceHolder() {
        return this;
    }

    private MethodHandle foldHandlePlaceHolder() {
        return this;
    }

    private MethodHandle guardWithTestPlaceHolder() {
        return this;
    }

    private MethodHandle filterArgumentsPlaceHolder(int n, int n2, int n3) {
        return this;
    }

    private static Object constructorPlaceHolder(Object object) {
        return object;
    }

    void compareWith(MethodHandle methodHandle, Comparator comparator) {
        throw new UnsupportedOperationException("Subclass must implement this");
    }

    static final void enforceArityLimit(byte by, MethodType methodType) {
        int n = methodType.argSlots;
        if (8 == by) {
            ++n;
        }
        if (n > 254) {
            MethodHandle.throwIllegalArgumentExceptionForMTArgCount(n);
        }
    }

    static void throwIllegalArgumentExceptionForMTArgCount(int n) {
        throw new IllegalArgumentException(Msg.getString("K0578", n + 1));
    }

    static void throwIllegalArgumentExceptionForMHArgCount() {
        throw new IllegalArgumentException(Msg.getString("K0579"));
    }

    String mapKindToBytecode() {
        switch (this.kind) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 0: 
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
            case 17: {
                return ((VarargsCollectorHandle)this).next.mapKindToBytecode();
            }
        }
        return "KIND_#" + this.kind;
    }

    MethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodHandle getTarget() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodHandle setVarargs(MemberName memberName) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodHandle asTypeUncached(MethodType methodType) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    boolean viewAsTypeChecks(MethodType methodType, boolean bl) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodHandle viewAsType(MethodType methodType, boolean bl) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MemberName internalMemberName() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    BoundMethodHandle rebind() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    void updateForm(LambdaForm lambdaForm) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    final Object invokeBasic(Object ... objectArray) throws Throwable {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodHandle withInternalMemberName(MemberName memberName, boolean bl) {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    LambdaForm internalForm() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    boolean isInvokeSpecial() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    Class<?> internalCallerClass() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    MethodHandleImpl.Intrinsic intrinsicName() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    String internalProperties() {
        throw OpenJDKCompileStub.OpenJDKCompileStubThrowError();
    }

    static {
        ComputedCalls.load();
        ThunkKey.load();
        ThunkTuple.load();
        ILGenMacros.load();
        EMPTY_CLASS_ARRAY = new Class[0];
    }

    static final class IWAContainer {
        static final MethodHandle spreader_0 = MethodHandles.spreadInvoker(MethodType.genericMethodType(0), 0);
        static final MethodHandle spreader_1 = MethodHandles.spreadInvoker(MethodType.genericMethodType(1), 0);
        static final MethodHandle spreader_2 = MethodHandles.spreadInvoker(MethodType.genericMethodType(2), 0);
        static final MethodHandle spreader_3 = MethodHandles.spreadInvoker(MethodType.genericMethodType(3), 0);
        static final MethodHandle spreader_4 = MethodHandles.spreadInvoker(MethodType.genericMethodType(4), 0);
        static final MethodHandle spreader_5 = MethodHandles.spreadInvoker(MethodType.genericMethodType(5), 0);
        static final MethodHandle spreader_6 = MethodHandles.spreadInvoker(MethodType.genericMethodType(6), 0);
        static final MethodHandle spreader_7 = MethodHandles.spreadInvoker(MethodType.genericMethodType(7), 0);

        IWAContainer() {
        }

        static MethodHandle getMH(int n) {
            switch (n) {
                case 0: {
                    return spreader_0;
                }
                case 1: {
                    return spreader_1;
                }
                case 2: {
                    return spreader_2;
                }
                case 3: {
                    return spreader_3;
                }
                case 4: {
                    return spreader_4;
                }
                case 5: {
                    return spreader_5;
                }
                case 6: {
                    return spreader_6;
                }
                case 7: {
                    return spreader_7;
                }
            }
            return MethodHandles.spreadInvoker(MethodType.genericMethodType(n), 0);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface FrameIteratorSkip {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

