/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.j9.walkers.HeapWalker;
import com.ibm.j9ddr.vm29.pointer.generated.J9AbstractThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9ThreadAbstractMonitor;
import com.ibm.j9ddr.vm29.structure.J9ThreadMonitorPool;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorIterator
implements Iterator {
    private static final long freeTag = new UDATA(-1L).longValue();
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private J9ThreadMonitorPoolPointer pool;
    private int index = 0;
    private J9ThreadMonitorPointer poolEntries;
    private long poolSize = 0L;
    private Object current;
    private boolean walkThreadPool = true;
    private final Iterator<ObjectMonitor> flatMonitorIterator;
    private boolean EOI = false;

    public MonitorIterator(J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        J9AbstractThreadPointer j9AbstractThreadPointer = this.getThreadLibrary(j9JavaVMPointer);
        J9ThreadLibraryPointer j9ThreadLibraryPointer = j9AbstractThreadPointer.library();
        this.log.fine(String.format("Thread library 0x%016x", j9ThreadLibraryPointer.getAddress()));
        this.pool = j9ThreadLibraryPointer.monitor_pool();
        if (this.pool.notNull()) {
            this.poolEntries = this.pool.entriesEA();
            this.poolSize = J9ThreadMonitorPool.MONITOR_POOL_SIZE;
        }
        this.flatMonitorIterator = HeapWalker.getFlatLockedMonitors().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.EOI) {
            return false;
        }
        boolean bl = false;
        try {
            if (this.walkThreadPool) {
                this.walkThreadPool = bl = this.threadPoolHasNext();
            }
            if (!this.walkThreadPool && (bl = this.flatMonitorIterator.hasNext()) && this.current == null) {
                this.current = this.flatMonitorIterator.next();
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Could not locate the next monitor", corruptDataException, true);
            this.EOI = true;
        }
        return this.current != null || bl;
    }

    private boolean threadPoolHasNext() throws CorruptDataException {
        while (this.current == null && this.pool.notNull()) {
            while ((long)this.index < this.poolSize) {
                J9ThreadMonitorPointer j9ThreadMonitorPointer = J9ThreadMonitorPointer.cast(this.poolEntries.add(this.index));
                ++this.index;
                if (freeTag == j9ThreadMonitorPointer.count().longValue()) continue;
                J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast(j9ThreadMonitorPointer);
                if (j9ThreadAbstractMonitorPointer.flags().allBitsIn(J9ThreadAbstractMonitor.J9THREAD_MONITOR_OBJECT)) {
                    if (!j9ThreadAbstractMonitorPointer.userData().eq(0L)) {
                        J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(j9ThreadAbstractMonitorPointer.userData());
                        ObjectMonitor objectMonitor = ObjectAccessBarrier.getMonitor(j9ObjectPointer);
                        if (objectMonitor == null || !objectMonitor.isInflated()) continue;
                        this.current = objectMonitor;
                    }
                } else {
                    this.current = j9ThreadMonitorPointer;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.format("Found monitor @ 0x%016x : %s", j9ThreadMonitorPointer.getAddress(), j9ThreadMonitorPointer.name().getCStringAtOffset(0L)));
                }
                return true;
            }
            this.pool = this.pool.next();
            if (!this.pool.notNull()) continue;
            this.index = 0;
            this.poolEntries = this.pool.entriesEA();
        }
        return this.pool.notNull();
    }

    public Object next() {
        if (this.hasNext()) {
            Object object = this.current;
            this.current = null;
            return object;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }

    private J9AbstractThreadPointer getThreadLibrary(J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        J9AbstractThreadPointer j9AbstractThreadPointer;
        J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
        if (j9VMThreadPointer.notNull() && (j9AbstractThreadPointer = J9AbstractThreadPointer.cast(j9VMThreadPointer.osThread())).notNull()) {
            return j9AbstractThreadPointer;
        }
        throw new CorruptDataException("Cannot locate thread library");
    }
}

