/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.WrongMethodTypeException;

final class VarargsCollectorHandle
extends MethodHandle {
    final MethodHandle next;
    final Class<?> arrayType;
    final boolean isPrimitiveVarargs;
    private CollectHandle previousCollector = null;
    private static final ThunkTable _thunkTable = new ThunkTable();

    VarargsCollectorHandle(MethodHandle methodHandle, Class<?> clazz, boolean bl) {
        super(VarargsCollectorHandle.varargsCollectorType(methodHandle.type, clazz), (byte)17, null);
        this.next = methodHandle;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this.arrayType = clazz;
        this.isPrimitiveVarargs = bl;
    }

    VarargsCollectorHandle(VarargsCollectorHandle varargsCollectorHandle, MethodType methodType) {
        super(varargsCollectorHandle, methodType);
        this.next = varargsCollectorHandle.next;
        this.arrayType = varargsCollectorHandle.arrayType;
        this.isPrimitiveVarargs = varargsCollectorHandle.isPrimitiveVarargs;
    }

    @Override
    Class<?> getDefc() throws InternalError {
        if (this.isPrimitiveVarargs) {
            return this.next.getDefc();
        }
        return super.getDefc();
    }

    @Override
    Class<?> getReferenceClass() throws InternalError {
        if (this.isPrimitiveVarargs) {
            return this.next.getReferenceClass();
        }
        return super.getReferenceClass();
    }

    @Override
    Class<?> getSpecialCaller() throws InternalError {
        if (this.isPrimitiveVarargs) {
            return this.next.getSpecialCaller();
        }
        return super.getSpecialCaller();
    }

    @Override
    String getMethodName() throws InternalError {
        if (this.isPrimitiveVarargs) {
            return this.next.getMethodName();
        }
        return super.getMethodName();
    }

    @Override
    int getModifiers() throws InternalError {
        if (this.isPrimitiveVarargs) {
            return this.next.getModifiers();
        }
        return super.getModifiers();
    }

    static MethodType varargsCollectorType(MethodType methodType, Class<?> clazz) {
        return methodType.changeParameterType(methodType.parameterCount() - 1, clazz);
    }

    @Override
    public Object invokeWithArguments(Object ... objectArray) throws Throwable, WrongMethodTypeException, ClassCastException {
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (n < 253) {
            MethodHandle methodHandle = MethodHandle.IWAContainer.getMH(n);
            return methodHandle.invokeExact(this, objectArray);
        }
        MethodHandle methodHandle = this.asType(MethodType.genericMethodType(n));
        methodHandle = methodHandle.asSpreader(Object[].class, n);
        return methodHandle.invokeExact(objectArray);
    }

    @Override
    public MethodHandle asType(MethodType methodType) throws ClassCastException {
        int n;
        if (this.type == methodType) {
            return this;
        }
        int n2 = this.type.parameterCount();
        if (n2 == (n = methodType.parameterCount()) && this.type.lastParameterType().isAssignableFrom(methodType.lastParameterType())) {
            return this.next.asType(methodType);
        }
        int n3 = n - n2 + 1;
        if (n3 < 0) {
            throw new WrongMethodTypeException();
        }
        CollectHandle collectHandle = this.previousCollector;
        if (collectHandle == null || collectHandle.collectArraySize != n3) {
            this.previousCollector = collectHandle = (CollectHandle)this.next.asCollector(this.arrayType, n3);
        }
        return collectHandle.asType(methodType);
    }

    @Override
    public MethodHandle asVarargsCollector(Class<?> clazz) throws IllegalArgumentException {
        if (this.arrayType == clazz) {
            return this;
        }
        if (!this.arrayType.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Msg.getString("K05cc", clazz, this.type));
        }
        return this.next.asVarargsCollector(clazz);
    }

    @Override
    public MethodHandle asFixedArity() {
        MethodHandle methodHandle = this.next;
        while (methodHandle.isVarargsCollector()) {
            methodHandle = ((VarargsCollectorHandle)methodHandle).next;
        }
        return methodHandle.asType(this.type());
    }

    @Override
    boolean canRevealDirect() {
        return this.isPrimitiveVarargs;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int n) throws Throwable {
        return ILGenMacros.invokeExact_X(this.next, n);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new VarargsCollectorHandle(this, methodType);
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof VarargsCollectorHandle) {
            ((VarargsCollectorHandle)methodHandle).compareWithVarargsCollector(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithVarargsCollector(VarargsCollectorHandle varargsCollectorHandle, Comparator comparator) {
        comparator.compareStructuralParameter(varargsCollectorHandle.arrayType, this.arrayType);
        comparator.compareChildHandle(varargsCollectorHandle.next, this.next);
    }
}

