/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.Serializable;
import java.security.ProtectionDomain;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String declaringClass;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;
    transient Object source;
    private static final String[] digits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public StackTraceElement(String string, String string2, String string3, int n) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.declaringClass = string;
        this.methodName = string2;
        this.fileName = string3;
        this.lineNumber = n;
    }

    private StackTraceElement() {
        this.declaringClass = null;
        this.methodName = null;
        this.fileName = null;
        this.lineNumber = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        if (this.methodName == null || stackTraceElement.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(stackTraceElement.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(stackTraceElement.getClassName())) {
            return false;
        }
        String string = this.getFileName();
        if (string == null ? stackTraceElement.getFileName() != null : !string.equals(stackTraceElement.getFileName())) {
            return false;
        }
        return this.getLineNumber() == stackTraceElement.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        int n = this.methodName.hashCode() ^ this.declaringClass.hashCode();
        return n;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        this.appendTo(stringBuilder);
        return stringBuilder.toString();
    }

    void appendTo(Appendable appendable) {
        Object object;
        StackTraceElement.appendTo(appendable, this.getClassName());
        StackTraceElement.appendTo(appendable, ".");
        StackTraceElement.appendTo(appendable, this.getMethodName());
        StackTraceElement.appendTo(appendable, "(");
        if (this.isNativeMethod()) {
            StackTraceElement.appendTo(appendable, "Native Method");
        } else {
            object = this.getFileName();
            if (object == null) {
                StackTraceElement.appendTo(appendable, "Unknown Source");
            } else {
                int n = this.getLineNumber();
                StackTraceElement.appendTo(appendable, (CharSequence)object);
                if (n >= 0) {
                    StackTraceElement.appendTo(appendable, ":");
                    StackTraceElement.appendTo(appendable, n);
                }
            }
        }
        StackTraceElement.appendTo(appendable, ")");
        if (this.source != null) {
            StackTraceElement.appendTo(appendable, " from ");
            if (this.source instanceof String) {
                StackTraceElement.appendTo(appendable, (String)this.source);
            } else if (this.source instanceof ProtectionDomain) {
                object = (ProtectionDomain)this.source;
                StackTraceElement.appendTo(appendable, ((ProtectionDomain)object).getClassLoader().toString());
                StackTraceElement.appendTo(appendable, "(");
                StackTraceElement.appendTo(appendable, ((ProtectionDomain)object).getCodeSource().getLocation().toString());
                StackTraceElement.appendTo(appendable, ")");
            }
        }
    }

    static void appendTo(Appendable appendable, CharSequence charSequence) {
        try {
            appendable.append(charSequence);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void appendTo(Appendable appendable, int n) {
        int n2;
        int n3 = 1;
        for (n2 = n; n2 >= 10; n2 /= 10) {
            n3 *= 10;
        }
        StackTraceElement.appendTo(appendable, digits[n2]);
        while (n3 >= 10) {
            n2 = (n -= n3 * n2) / (n3 /= 10);
            StackTraceElement.appendTo(appendable, digits[n2]);
        }
    }
}

