/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.BoolPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.Entry;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=Entry.class)
public class EntryPointer
extends StructurePointer {
    public static final EntryPointer NULL = new EntryPointer(0L);

    protected EntryPointer(long address) {
        super(address);
    }

    public static EntryPointer cast(AbstractPointer structure) {
        return EntryPointer.cast(structure.getAddress());
    }

    public static EntryPointer cast(UDATA udata) {
        return EntryPointer.cast(udata.longValue());
    }

    public static EntryPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new EntryPointer(address);
    }

    @Override
    public EntryPointer add(long count) {
        return EntryPointer.cast(this.address + Entry.SIZEOF * count);
    }

    @Override
    public EntryPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public EntryPointer addOffset(long offset) {
        return EntryPointer.cast(this.address + offset);
    }

    @Override
    public EntryPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public EntryPointer sub(long count) {
        return EntryPointer.cast(this.address - Entry.SIZEOF * count);
    }

    @Override
    public EntryPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public EntryPointer subOffset(long offset) {
        return EntryPointer.cast(this.address - offset);
    }

    @Override
    public EntryPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public EntryPointer untag(long mask) {
        return EntryPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public EntryPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return Entry.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_internedOffset_", declaredType="bool")
    public boolean interned() throws CorruptDataException {
        return this.getBoolAtOffset(Entry._internedOffset_);
    }

    public BoolPointer internedEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return BoolPointer.cast(this.address + (long)Entry._internedOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_markedOffset_", declaredType="bool")
    public boolean marked() throws CorruptDataException {
        return this.getBoolAtOffset(Entry._markedOffset_);
    }

    public BoolPointer markedEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return BoolPointer.cast(this.address + (long)Entry._markedOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_offsetOffset_", declaredType="UDATA")
    public UDATA offset() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(Entry._offsetOffset_));
    }

    public UDATAPointer offsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)Entry._offsetOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tagOffset_", declaredType="UDATA")
    public UDATA tag() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(Entry._tagOffset_));
    }

    public UDATAPointer tagEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)Entry._tagOffset_);
    }
}

