/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_jv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_DE = "J\u00e9rman";
        final String metaValue_FR = "Prancis";
        final String metaValue_HR = "Kroasia";
        final String metaValue_JP = "Jepang";
        final String metaValue_LA = "Laos";
        final String metaValue_LU = "Luksemburg";
        final String metaValue_LV = "Latvia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NL = "Walanda";
        final String metaValue_RU = "Rusia";
        final String metaValue_SO = "Somalia";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_WS = "Samoa";
        final String metaValue_ar = "Arab";
        final String metaValue_el = "Yunani";
        final String metaValue_he = "Ibrani";
        final String metaValue_hy = "Armenia";
        final String metaValue_ka = "Georgia";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_my = "Myanmar";
        final String metaValue_or = "Odia";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "Colonia" },
            { "nyn", "Nyankole" },
            { "luo", "Luo" },
            { "Zsym", "Simbol" },
            { "fil", "Tagalog" },
            { "hmn", "Hmong" },
            { "ban", "ban" },
            { "Zsye", "Emoji" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "es_ES", "Spanyol (Eropah)" },
            { "teo", "Teso" },
            { "AC", "Pulo Ascension" },
            { "AD", "Andora" },
            { "AE", "Uni \u00c9mirat Arab" },
            { "nl_BE", "Flemis" },
            { "AF", "Afganistan" },
            { "af", "af" },
            { "AG", "Antigua lan Barbuda" },
            { "type.ca.ethiopic", "Tanggalan Etiopia" },
            { "AI", "Anguilla" },
            { "ak", "Akan" },
            { "AL", "Albani" },
            { "AM", "Arm\u00e9nia" },
            { "am", "Amharik" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_JP },
            { "AQ", "Antartika" },
            { "ar", metaValue_ar },
            { "AR", "Arg\u00e8ntina" },
            { "Hrkt", "Silabaris Jepang" },
            { "AS", "Samoa Amerika" },
            { "as", "Assam" },
            { "AT", "Ostenrik" },
            { "AU", "Ostrali" },
            { "AW", "Aruba" },
            { "AX", "Kapuloan Alan" },
            { "az", metaValue_AZ },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia lan H\u00e8rs\u00e9govina" },
            { "BB", "Barbadhos" },
            { "ceb", "Cebuano" },
            { "BD", "Banggalad\u00e9sa" },
            { "BE", "B\u00e8lgi" },
            { "be", "be" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgari" },
            { "bg", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "B\u00e9nin" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "BN", "Brun\u00e9i" },
            { "bn", "Bengali" },
            { "BO", "Bolivia" },
            { "bo", "Tibet" },
            { "BQ", "Karibia Walanda" },
            { "BR", "Brasil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "bs" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Pulo Bov\u00e8t" },
            { "Mymr", metaValue_my },
            { "BW", "Botswana" },
            { "type.nu.laoo", "Digit Lao" },
            { "BY", "B\u00e9larus" },
            { "seh", "Sena" },
            { "BZ", "B\u00e9lis\u00e9" },
            { "type.ca.persian", "Tanggalan Persia" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "CA", "Kanada" },
            { "ca", "Katala" },
            { "CC", "Kapuloan Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Kongo - Kinshasa" },
            { "ce", "Chechen" },
            { "CF", "R\u00e9publik Afrika Tengah" },
            { "CG", "Kongo - Brassaville" },
            { "CH", "Switserlan" },
            { "CI", "Pasisir Gadhing" },
            { "CK", "Kapuloan Cook" },
            { "CL", "Cil\u00e9" },
            { "CM", "Kamerun" },
            { "CN", "Tyongkok" },
            { "CO", "Kolombia" },
            { "co", "Korsika" },
            { "CP", "Pulo Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Kosta Rika" },
            { "cs", "Ceska" },
            { "CU", "Kuba" },
            { "cu", "Slavia Gerejani" },
            { "CV", "Pongol Verd\u00e9" },
            { "CW", "Kurasao" },
            { "CX", "Pulo Natal" },
            { "CY", "Siprus" },
            { "cy", "Welsh" },
            { "CZ", "C\u00e9ko" },
            { "type.nu.ethi", "Angka Etiopia" },
            { "da", "Dansk" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.cf.standard", "Format Mata Uang Standar" },
            { "type.nu.deva", "Digit Devanagari" },
            { "DJ", "Jibuti" },
            { "DK", "Dh\u00e8nemarken" },
            { "Brai", "Braille" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Angka Huruf Cilik Armenia" },
            { "DO", "R\u00e9publik Dominika" },
            { "bem", "Bemba" },
            { "es_419", "Spanyol (Amerika Latin)" },
            { "DZ", "Aljasair" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Tanggalan Cina" },
            { "EA", "S\u00e9uta lan Melila" },
            { "EC", "\u00c9kuadhor" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Angka Yunani" },
            { "EE", "\u00c9stonia" },
            { "ee", "Ewe" },
            { "type.lb.normal", "Gaya Ganti Baris Normal" },
            { "EG", "Mesir" },
            { "EH", "Sahara Kulon" },
            { "el", metaValue_el },
            { "en", "Inggris" },
            { "eo", "Esperanto" },
            { "chr", "Cherokee" },
            { "ER", "\u00c9ritr\u00e9a" },
            { "ES", "Sepanyol" },
            { "es", "Spanyol" },
            { "ET", "\u00c9tiopia" },
            { "et", "Estonia" },
            { "Hanb", "Han nganggo Bopomofo" },
            { "EU", "Uni \u00c9ropah" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "type.ca.gregorian", "Tanggalan Gregorian" },
            { "EZ", "Zona \u00c9uro" },
            { "shi", "Tachelhit" },
            { "type.nu.gujr", "Digit Gujarat" },
            { "hsb", "Sorbia Standar" },
            { "Hani", "Han" },
            { "fa", "Persia" },
            { "Hans", "Prasaja" },
            { "type.nu.latn", "Digit Latin" },
            { "Hant", "Tradhisional" },
            { "ff", "Fulah" },
            { "FI", "Finlan" },
            { "fi", "Suomi" },
            { "FJ", "Fiji" },
            { "FK", "Kapuloan Falkland" },
            { "yue", "Kanton" },
            { "FO", "Kapuloan Faro" },
            { "fo", "Faroe" },
            { "Taml", metaValue_ta },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "fy", "Frisia Sisih Kulon" },
            { "GA", "Gabon" },
            { "ga", "Irlandia" },
            { "GB", "Karajan Manunggal" },
            { "GD", "Gr\u00e9nada" },
            { "gd", "Gaulia" },
            { "GE", "G\u00e9orgia" },
            { "GF", "Guyana Prancis" },
            { "GG", "Guernsei" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "gl", "Galisia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guad\u00e9lup" },
            { "und", "Basa Ora Dikenali" },
            { "GS", "Georgia Kidul lan Kapuloan Sandwich Kidul" },
            { "GT", "Guat\u00e9mala" },
            { "GU", "Guam" },
            { "gu", "Gujarat" },
            { "gv", "Manx" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Kurdi Tengah" },
            { "zxx", "Konten tanpa linguistik" },
            { "he", metaValue_he },
            { "hi", "India" },
            { "HK", "Laladan Administratif Astamiwa Hong Kong" },
            { "HM", "Kapuloan Heard lan McDonald" },
            { "HN", "Honduras" },
            { "hr", metaValue_HR },
            { "HR", metaValue_HR },
            { "agq", "Aghem" },
            { "gsw", "Jerman Swiss" },
            { "HT", "Haiti" },
            { "ht", "Kreol Haiti" },
            { "HU", "Honggari" },
            { "hu", "Hungaria" },
            { "hy", metaValue_hy },
            { "ia", "Interlingua" },
            { "IC", "Kapuloan Kanari" },
            { "ID", "Indon\u00e9sia" },
            { "id", "Indonesia" },
            { "type.nu.tibt", "Digit Tibet" },
            { "IE", "R\u00e9publik Irlan" },
            { "ig", "Iqbo" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "IL", "Isra\u00e8l" },
            { "IM", "Pulo Man" },
            { "IO", "Wilayah Inggris nang Segoro Hindia" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "\u00c8slan" },
            { "is", "Islandia" },
            { "IT", "Itali" },
            { "it", "Italia" },
            { "Zmth", "Notasi Matematika" },
            { "type.nu.thai", "Digit Thailand" },
            { "type.nu.beng", "Digit Bengali" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Tanggalan Islam" },
            { "JM", "Jamaika" },
            { "Beng", "Bangla" },
            { "JO", "Yordania" },
            { "JP", metaValue_JP },
            { "jv", "Jawa" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Digit Kannada" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "type.ca.buddhist", "Tanggalan Buddha" },
            { "KE", "K\u00e9nya" },
            { "419", "Am\u00e9rika Latin" },
            { "KG", "Kirgistan" },
            { "KH", "Kamboja" },
            { "KI", "Kiribati" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Komoro" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "KR", "Kor\u00e9a Kidul" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdis" },
            { "KW", "Kuwait" },
            { "kw", "Kernowek" },
            { "KY", "Kapuloan K\u00e9man" },
            { "ky", "Kirgis" },
            { "KZ", "Kasakstan" },
            { "Cyrl", "Sirilik" },
            { "LA", metaValue_LA },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "LB", "Libanon" },
            { "LC", "Santa Lusia" },
            { "type.nu.mlym", "Digit Malayalam" },
            { "lg", "Ganda" },
            { "nds", "Jerman Non Standar" },
            { "LI", "Liktenst\u00e9n" },
            { "LK", "Sri Lanka" },
            { "Tibt", "Tibetan" },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "Sistem Pangukuran Imperial" },
            { "LR", "Lib\u00e8ria" },
            { "LS", "L\u00e9sotho" },
            { "LT", "Litowen" },
            { "lt", "Lithuania" },
            { "LU", metaValue_LU },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "LV", metaValue_LV },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Monten\u00e9gro" },
            { "MF", "Santa Martin" },
            { "MG", "Madagaskar" },
            { "mg", "Malagasi" },
            { "MH", "Kapuloan Marshall" },
            { "type.co.ducet", "Urutan Pamilahan Unicode Default" },
            { "mi", "Maori" },
            { "mk", "Makedonia" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "mn", metaValue_MN },
            { "MN", metaValue_MN },
            { "MO", "Laladan Administratif Astamiwa Makau" },
            { "MP", "Kapuloan Mariana Lor" },
            { "MQ", "Martinik" },
            { "MR", "Mauritania" },
            { "mr", "Marathi" },
            { "MS", "Mons\u00e9rat" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "MV", "Malad\u00e9wa" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8ksiko" },
            { "type.ca.japanese", "Tanggalan Jepang" },
            { "my", metaValue_my },
            { "MY", "Malaysia" },
            { "Armn", metaValue_hy },
            { "MZ", "Mosambik" },
            { "dsb", "Sorbia Non Standar" },
            { "NA", "Namibia" },
            { "type.co.search", "Panlusuran Tujuan Umum" },
            { "202", "Afrika Kidule Sahara" },
            { "nb", "Bokm\u00e5l Norwegia" },
            { "type.ca.hebrew", "Tanggalan Ibrani" },
            { "NC", "Kal\u00e9donia Anyar" },
            { "nd", "Ndebele Lor" },
            { "NE", "Nig\u00e9r" },
            { "ne", "Nepal" },
            { "NF", "Pulo Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "NI", "Nikaragua" },
            { "nl", metaValue_NL },
            { "NL", metaValue_NL },
            { "nn", "Nynorsk Norwegia" },
            { "NO", "Nurw\u00e8gen" },
            { "NP", "N\u00e9pal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "kab", "Kabyle" },
            { "kam", "Kamba" },
            { "mer", "Meru" },
            { "type.nu.armn", "Angka Armenia" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetia" },
            { "mfe", "Morisyen" },
            { "PA", "Panama" },
            { "pa", "Punjab" },
            { "dua", "Duala" },
            { "PE", "Peru" },
            { "PF", "Polinesia Prancis" },
            { "PG", "Papua Nugini" },
            { "PH", "Pilipina" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "pl", "Polandia" },
            { "ewo", "Ewondo" },
            { "PN", "Kapuloan Pitcairn" },
            { "type.ca.dangi", "Tanggalan Dangi" },
            { "PR", "Pu\u00e8rto Riko" },
            { "PS", "Tlatah Pal\u00e8stina" },
            { "ps", "Pashto" },
            { "PT", "Portugal" },
            { "pt", "Portugis" },
            { "key.co", "Urutan Pamilahan" },
            { "PW", "Palau" },
            { "type.nu.greklow", "Angka Huruf Cilik Yunani" },
            { "PY", "Paraguay" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meeto" },
            { "key.cf", "Format Mata Uang" },
            { "QA", "Katar" },
            { "key.ca", "Tanggalan" },
            { "Laoo", "Lao" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "type.nu.mymr", "Digit Myanmar" },
            { "QO", "Oseania Paling Njaba" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "001", "Donya" },
            { "Ethi", "Ethiopik" },
            { "002", "Afrika" },
            { "RE", "R\u00e9union" },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "005", "Am\u00e9rika Kidul" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "009", "Os\u00e9ania" },
            { "rm", "Roman" },
            { "rn", "Rundi" },
            { "key.cu", "Mata Uang" },
            { "RO", "Rum\u00e9ni" },
            { "ro", "Rumania" },
            { "type.nu.orya", "Digit Odia" },
            { "type.nu.hanidec", "Angka Desimal Mandarin" },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "SA", "Arab Saudi" },
            { "sa", "Sanskerta" },
            { "SB", "Kapuloan Suleman" },
            { "twq", "Tasawaq" },
            { "011", "Afrika Kulon" },
            { "SC", "S\u00e9s\u00e8l" },
            { "SD", "Sudan" },
            { "sd", "Sindhi" },
            { "013", "Am\u00e9rika Tengah" },
            { "SE", "Sw\u00e8dhen" },
            { "se", "Sami Sisih Lor" },
            { "014", "Afrika W\u00e9tan" },
            { "SG", "Singapura" },
            { "sg", "Sango" },
            { "type.lb.strict", "Gaya Ganti Baris Strik" },
            { "si", metaValue_si },
            { "017", "Afrika Sisih Tengah" },
            { "SI", "Slov\u00e9nia" },
            { "018", "Afrika Sisih Kidul" },
            { "SJ", "Svalbard lan Jan Mayen" },
            { "019", "Am\u00e9rika" },
            { "SK", "Slowak" },
            { "sk", "Slowakia" },
            { "SL", "Si\u00e9ra L\u00e9on\u00e9" },
            { "sl", "Slovenia" },
            { "sm", metaValue_WS },
            { "SM", "San Marino" },
            { "SN", "S\u00e9n\u00e9gal" },
            { "sn", "Shona" },
            { "so", metaValue_SO },
            { "SO", metaValue_SO },
            { "type.nu.arab", "Digit Hindu-Arab" },
            { "sq", "Albania" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "SR", "Suriname" },
            { "sr", "Serbia" },
            { "SS", "Sudan Kidul" },
            { "type.cf.account", "Format Mata Uang Akuntansi" },
            { "ST", "Sao Tom\u00e9 lan Princip\u00e9" },
            { "st", "Sotho Sisih Kidul" },
            { "su", "Sunda" },
            { "SV", "\u00c8l Salvador" },
            { "sv", "Swedia" },
            { "sw", "Swahili" },
            { "SX", "Sint Mart\u00e9n" },
            { "SY", "Suriah" },
            { "type.nu.hantfin", "Angka Finansial Mandarin Tradisional" },
            { "SZ", "Swasiland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistem Pangukuran AS" },
            { "021", "Am\u00e9rika Sisih Lor" },
            { "142", "Asia" },
            { "TC", "Turks lan Kapuloan Kaikos" },
            { "yav", "Yangben" },
            { "143", "Asia Tengah" },
            { "TD", "Chad" },
            { "te", "Telugu" },
            { "145", "Asia Kulon" },
            { "TF", "Wilayah Prancis nang Kutub Kidul" },
            { "TG", "Togo" },
            { "tg", "Tajik" },
            { "TH", "Tanah Thai" },
            { "th", "Thailand" },
            { "ti", "Tigrinya" },
            { "TJ", "Tajikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "tk", "Turkmen" },
            { "TL", "Timor Leste" },
            { "TM", "Turkm\u00e9nistan" },
            { "TN", "Tunisia" },
            { "to", metaValue_TO },
            { "TO", metaValue_TO },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Angka Jepang" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "TT", "Trinidad lan Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturia" },
            { "TZ", "Tansania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Skrip Ora Dikenali" },
            { "150", "\u00c9ropah" },
            { "UA", "Ukrania" },
            { "030", "Asia W\u00e9tan" },
            { "151", "\u00c9ropah W\u00e9tan" },
            { "034", "Asia Kidul" },
            { "155", "\u00c9ropah Kulon" },
            { "035", "Asia Kidul-w\u00e9tan" },
            { "UG", "Uganda" },
            { "ug", "Uighur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Umum" },
            { "039", "\u00c9ropah Kidul" },
            { "uk", "Ukraina" },
            { "Sinh", metaValue_si },
            { "UM", "Kapuloan AS Paling Njaba" },
            { "UN", "Pasar\u00e9katan Bangsa-Bangsa" },
            { "ur", "Urdu" },
            { "US", "Am\u00e9rika Sar\u00e9kat" },
            { "haw", "Hawaii" },
            { "UY", "Uruguay" },
            { "prg", "Prusia" },
            { "UZ", "Usb\u00e8kistan" },
            { "uz", "Uzbek" },
            { "tzm", "Tamazight Atlas Tengah" },
            { "nnh", "Ngiemboon" },
            { "VA", "Kutha Vatikan" },
            { "VE", "V\u00e9n\u00e9su\u00e9la" },
            { "type.ca.roc", "Tanggalan Minguo" },
            { "VG", "Kapuloan Virgin Britania" },
            { "VI", "Kapuloan Virgin Am\u00e9rika" },
            { "vi", "Vietnam" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Siklus Jam (12 vs 24)" },
            { "VN", "Vi\u00e8tnam" },
            { "vo", "Volapuk" },
            { "VU", "Vanuatu" },
            { "rwk", "Rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis lan Futuna" },
            { "Grek", metaValue_el },
            { "057", "Daerah Mikronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wo", "Wolof" },
            { "wae", "Walser" },
            { "zgh", "Tamazight Moroko Standar" },
            { "ar_001", "Arab Standar Anyar" },
            { "WS", metaValue_WS },
            { "Mong", metaValue_MN },
            { "Latn", metaValue_la },
            { "061", "Polinesia" },
            { "type.nu.hans", "Angka Mandarin Prasaja" },
            { "type.nu.hant", "Angka Mandarin Tradisional" },
            { "xh", "Xhosa" },
            { "XK", "Kosovo" },
            { "type.nu.romanlow", "Angka Huruf Cilik Romawi" },
            { "Gujr", "Gujarati" },
            { "Zxxx", "Ora Ketulis" },
            { "kkj", "Kako" },
            { "YE", "Yaman" },
            { "type.co.standard", "Standar Ngurutke Urutan" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "es_MX", "Spanyol (Meksiko)" },
            { "YT", "Mayotte" },
            { "vai", "Vai" },
            { "ZA", "Afrika Kidul" },
            { "type.lb.loose", "Gaya Ganti Baris Longgar" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Tyonghwa" },
            { "type.nu.geor", "Angka Georgian" },
            { "Hira", "Hiragana" },
            { "ZM", "Sambia" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Gaya Ganti Baris" },
            { "zu", "Zulu" },
            { "ZW", "Simbabwe" },
            { "Geor", metaValue_ka },
            { "ZZ", "Daerah Ora Dikenali" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.ca.iso8601", "Tanggalan ISO-8601" },
            { "type.nu.telu", "Digit Telugu" },
            { "type.nu.jpanfin", "Angka Finansial Jepang" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "type.nu.hansfin", "Angka Finansial Mandarin Prasaja" },
            { "kok", "Konkani" },
            { "type.nu.arabext", "Digit Hindu-Arab Diambakake" },
            { "nus", "Nuer" },
            { "type.nu.fullwide", "Digit Amba Kebak" },
            { "dav", "Taita" },
            { "lrc", "Luri Sisih Lor" },
            { "zh_Hant", "Tyonghwa (Tradisional)" },
            { "type.nu.khmr", "Digit Khmer" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Digit Gurmukhi" },
            { "Khmr", metaValue_km },
            { "mul", "Basa Multilingua" },
            { "key.ms", "Sistem Pangukuran" },
            { "type.nu.roman", "Angka Romawi" },
            { "sah", "Sakha" },
            { "type.nu.tamldec", "Digit Tamil" },
            { "saq", "Samburu" },
            { "key.nu", "Angka" },
            { "Guru", "Gurmukhi" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
