/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "isi-Arabic";
        final String metaValue_el = "isi-Greek";
        final String metaValue_gu = "isi-Gujarati";
        final String metaValue_he = "isi-Hebrew";
        final String metaValue_ja = "isi-Japanese";
        final String metaValue_ka = "isi-Georgian";
        final String metaValue_km = "isi-Khmer";
        final String metaValue_kn = "isi-Kannada";
        final String metaValue_ko = "isi-Korean";
        final String metaValue_la = "isi-Latin";
        final String metaValue_lo = "isi-Lao";
        final String metaValue_ml = "isi-Malayalam";
        final String metaValue_mn = "isi-Mongolian";
        final String metaValue_or = "isi-Odia";
        final String metaValue_si = "isi-Sinhala";
        final String metaValue_ta = "isi-Tamil";
        final String metaValue_te = "isi-Telugu";
        final String metaValue_th = "isi-Thai";
        final String metaValue_type_nu_taml = "izinombolo zesi-Tamil";
        final Object[][] data = new Object[][] {
            { "ksh", "isi-Colognian" },
            { "mwl", "isi-Mirandese" },
            { "Zsym", "amasimbuli" },
            { "Zsye", "i-Emoji" },
            { "ccp", "i-Chakma" },
            { "tem", "isi-Timne" },
            { "teo", "isi-Teso" },
            { "rap", "isi-Rapanui" },
            { "AC", "i-Ascension Island" },
            { "rar", "isi-Rarotongan" },
            { "tet", "isi-Tetum" },
            { "AD", "i-Andorra" },
            { "AE", "i-United Arab Emirates" },
            { "nl_BE", "isi-Flemish" },
            { "AF", "i-Afghanistan" },
            { "AG", "i-Antigua ne-Barbuda" },
            { "type.ca.ethiopic", "ikhalenda lesi-Ethiopic" },
            { "AI", "i-Anguilla" },
            { "key.tz", "Izoni yesikhathi:" },
            { "AL", "i-Albania" },
            { "AM", "i-Armenia" },
            { "AO", "i-Angola" },
            { "AQ", "i-Antarctica" },
            { "AR", "i-Argentina" },
            { "AS", "i-American Samoa" },
            { "AT", "i-Austria" },
            { "AU", "i-Australia" },
            { "AW", "i-Aruba" },
            { "en_US", "i-American English" },
            { "AX", "i-\u00c5land Islands" },
            { "AZ", "i-Azerbaijan" },
            { "BA", "i-Bosnia ne-Herzegovina" },
            { "BB", "i-Barbados" },
            { "ceb", "isi-Cebuano" },
            { "BD", "i-Bangladesh" },
            { "kum", "isi-Kumyk" },
            { "BE", "i-Belgium" },
            { "BF", "i-Burkina Faso" },
            { "BG", "i-Bulgaria" },
            { "BH", "i-Bahrain" },
            { "BI", "i-Burundi" },
            { "BJ", "i-Benin" },
            { "BL", "i-Saint Barth\u00e9lemy" },
            { "BM", "i-Bermuda" },
            { "myv", "isi-Erzya" },
            { "BN", "i-Brunei" },
            { "BO", "i-Bolivia" },
            { "BQ", "i-Caribbean Netherlands" },
            { "BR", "i-Brazil" },
            { "BS", "i-Bahamas" },
            { "xog", "isi-Soga" },
            { "BT", "i-Bhutan" },
            { "BV", "i-Bouvet Island" },
            { "BW", "iBotswana" },
            { "BY", "i-Belarus" },
            { "BZ", "i-Belize" },
            { "type.ca.persian", "ikhalenda lesi-Persian" },
            { "type.nu.hebr", "izinombolo zesi-Hebrew" },
            { "CA", "i-Canada" },
            { "CC", "i-Cocos (Keeling) Islands" },
            { "mzn", "isi-Mazanderani" },
            { "CD", "i-Congo - Kinshasa" },
            { "CF", "i-Central African Republic" },
            { "CG", "i-Congo - Brazzaville" },
            { "CH", "i-Switzerland" },
            { "CI", "i-C\u00f4te d\u2019Ivoire" },
            { "CK", "i-Cook Islands" },
            { "CL", "i-Chile" },
            { "CM", "i-Cameroon" },
            { "CN", "i-China" },
            { "CO", "i-Colombia" },
            { "CP", "i-Clipperton Island" },
            { "CR", "i-Costa Rica" },
            { "CU", "i-Cuba" },
            { "CV", "i-Cape Verde" },
            { "CW", "i-Cura\u00e7ao" },
            { "CX", "i-Christmas Island" },
            { "CY", "i-Cyprus" },
            { "CZ", "i-Czechia" },
            { "eka", "isi-Ekajuk" },
            { "DE", "i-Germany" },
            { "ace", "isi-Achinese" },
            { "cgg", "isi-Chiga" },
            { "DG", "i-Diego Garcia" },
            { "type.nu.deva", "izinombolo zesi-Devanagari" },
            { "DJ", "i-Djibouti" },
            { "DK", "i-Denmark" },
            { "ach", "isi-Acoli" },
            { "Brai", "i-Braille" },
            { "DM", "i-Dominica" },
            { "type.nu.armnlow", "izinombolo ezincane zesi-Armenian" },
            { "DO", "i-Dominican Republic" },
            { "gor", "isi-Gorontalo" },
            { "zun", "isi-Zuni" },
            { "tig", "isi-Tigre" },
            { "DZ", "i-Algeria" },
            { "pag", "isi-Pangasinan" },
            { "type.d0.hwidth", "Ubude obuhhafu" },
            { "EA", "i-Cueta ne-Melilla" },
            { "pam", "isi-Pampanga" },
            { "EC", "i-Ecuador" },
            { "pap", "isi-Papiamento" },
            { "ada", "isi-Adangme" },
            { "EE", "i-Estonia" },
            { "EG", "i-Egypt" },
            { "EH", "i-Western Sahara" },
            { "pau", "isi-Palauan" },
            { "chk", "isi-Chuukese" },
            { "chm", "isi-Mari" },
            { "cho", "isi-Choctaw" },
            { "chr", "isi-Cherokee" },
            { "ER", "i-Eritrea" },
            { "ES", "i-Spain" },
            { "ET", "i-Ethiopia" },
            { "EU", "i-European Union" },
            { "type.ca.gregorian", "ikhalenda lesi-Gregorian" },
            { "EZ", "EZ" },
            { "chy", "isi-Cheyenne" },
            { "type.nu.gujr", "amadijithi esi-Gujarati" },
            { "ady", "isi-Adyghe" },
            { "FI", "i-Finland" },
            { "FJ", "i-Fiji" },
            { "FK", "i-Falkland Islands" },
            { "FM", "i-Micronesia" },
            { "key.va", "Okokwehlukanisa Kwasendaweni" },
            { "FO", "i-Faroe Islands" },
            { "Taml", metaValue_ta },
            { "FR", "i-France" },
            { "root", "isi-Root" },
            { "type.ca.indian", "i-Indian National Calender" },
            { "GA", "i-Gabon" },
            { "GB", "i-United Kingdom" },
            { "pcm", "isi-Nigerian Pidgin" },
            { "GD", "i-Grenada" },
            { "GE", "i-Georgia" },
            { "GF", "i-French Guiana" },
            { "GG", "i-Guernsey" },
            { "GH", "i-Ghana" },
            { "GI", "i-Gibraltar" },
            { "GL", "i-Greenland" },
            { "GM", "i-Gambia" },
            { "GN", "i-Guinea" },
            { "GP", "i-Guadeloupe" },
            { "GQ", "i-Equatorial Guinea" },
            { "GR", "i-Greece" },
            { "GS", "i-South Georgia ne-South Sandwich Islands" },
            { "GT", "i-Guatemala" },
            { "GU", "i-Guam" },
            { "GW", "i-Guinea-Bissau" },
            { "tlh", "isi-Klingon" },
            { "GY", "i-Guyana" },
            { "ckb", "isi-Central Kurdish" },
            { "zxx", "akukho okuqukethwe kolimi" },
            { "de_AT", "isi-Austrian German" },
            { "HK", "i-Hong Kong SAR China" },
            { "HM", "i-Heard Island ne-McDonald Islands" },
            { "HN", "i-Honduras" },
            { "HR", "i-Croatia" },
            { "agq", "isi-Aghem" },
            { "gsw", "isi-Swiss German" },
            { "HT", "i-Haiti" },
            { "HU", "i-Hungary" },
            { "IC", "i-Canary Islands" },
            { "nan", "isi-Min Nan Chinese" },
            { "ID", "i-Indonesia" },
            { "IE", "i-Ireland" },
            { "nap", "isi-Neapolitan" },
            { "naq", "isi-Nama" },
            { "zza", "isi-Zaza" },
            { "IL", "kwa-Israel" },
            { "IM", "i-Isle of Man" },
            { "IN", "i-India" },
            { "IO", "i-British Indian Ocean Territory" },
            { "IQ", "i-Iraq" },
            { "IR", "i-Iran" },
            { "IS", "i-Iceland" },
            { "IT", "i-Italy" },
            { "Zmth", "i-Mathematical Notation" },
            { "type.nu.thai", "amadijithi esi-Thai" },
            { "type.nu.beng", "izinombolo zesi-Bengali" },
            { "JE", "i-Jersey" },
            { "type.ca.islamic", "ikhalenda lesi-Islamic" },
            { "JM", "i-Jamaica" },
            { "Beng", "isi-Bangla" },
            { "JO", "i-Jordan" },
            { "JP", "i-Japan" },
            { "ain", "isi-Ainu" },
            { "guz", "isi-Gusli" },
            { "type.nu.knda", "amadijithi esi-Kannada" },
            { "de_CH", "Isi-Swiss High German" },
            { "type.co.phonetic", "Hlela Ngokwefonetiki" },
            { "type.ca.buddhist", "ikhalenda lesi-Buddhist" },
            { "KE", "i-Kenya" },
            { "419", "i-Latin America" },
            { "KG", "i-Kyrgyzstan" },
            { "KH", "i-Cambodia" },
            { "KI", "i-Kiribati" },
            { "KM", "i-Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "i-Saint Kitts ne-Nevis" },
            { "fr_CA", "isi-Canadian French" },
            { "KP", "i-North Korea" },
            { "KR", "i-South Korea" },
            { "fr_CH", "isi-Swiss French" },
            { "KW", "i-Kuwait" },
            { "tpi", "isi-Tok Pisin" },
            { "KY", "i-Cayman Islands" },
            { "KZ", "i-Kazakhstan" },
            { "Cyrl", "isi-Cyrillic" },
            { "LA", "i-Laos" },
            { "LB", "i-Lebanon" },
            { "LC", "i-Saint Lucia" },
            { "gwi", "isi-Gwich\u02bcin" },
            { "nds", "isi-Low German" },
            { "LI", "i-Liechtenstein" },
            { "LK", "i-Sri Lanka" },
            { "LR", "i-Liberia" },
            { "LS", "iLesotho" },
            { "LT", "i-Lithuania" },
            { "LU", "i-Luxembourg" },
            { "LV", "i-Latvia" },
            { "Kana", "isi-Katakana" },
            { "LY", "i-Libya" },
            { "lad", "isi-Ladino" },
            { "vun", "isiVunjo" },
            { "lag", "isi-Langi" },
            { "Thaa", "isi-Thaana" },
            { "MA", "i-Morocco" },
            { "MC", "i-Monaco" },
            { "MD", "i-Moldova" },
            { "ME", "i-Montenegro" },
            { "MF", "i-Saint Martin" },
            { "MG", "i-Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "i-Marshall Islands" },
            { "ale", "isi-Aleut" },
            { "type.nu.vaii", "Izinhlazu Zezinombolo ze-Vai" },
            { "MK", "i-Macedonia" },
            { "ML", "iMali" },
            { "MM", "i-Myanmar (Burma)" },
            { "MN", "i-Mongolia" },
            { "new", "isi-Newari" },
            { "MO", "i-Macau SAR China" },
            { "MP", "i-Northern Mariana Islands" },
            { "MQ", "i-Martinique" },
            { "MR", "i-Mauritania" },
            { "MS", "i-Montserrat" },
            { "MT", "i-Malta" },
            { "type.m0.ungegn", "I-UNGEGN" },
            { "MU", "i-Mauritius" },
            { "alt", "isi-Southern Altai" },
            { "MV", "i-Maldives" },
            { "MW", "iMalawi" },
            { "MX", "i-Mexico" },
            { "type.ca.japanese", "ikhalenda lesi-Japanese" },
            { "MY", "i-Malaysia" },
            { "MZ", "i-Mozambique" },
            { "NA", "i-Namibia" },
            { "202", "Sub-Saharan Africa" },
            { "type.ca.hebrew", "ikhalenda lesi-Hebrew" },
            { "type.co.dictionary", "Ukuhlunga kwesichazimazwi" },
            { "NC", "i-New Caledonia" },
            { "NE", "i-Niger" },
            { "NF", "i-Norfolk Island" },
            { "NG", "i-Nigeria" },
            { "trv", "isi-Taroko" },
            { "NI", "i-Nicaragua" },
            { "NL", "i-Netherlands" },
            { "NO", "i-Norway" },
            { "NP", "i-Nepal" },
            { "NR", "i-Nauru" },
            { "NU", "i-Niue" },
            { "rof", "isi-Rombo" },
            { "NZ", "i-New Zealand" },
            { "OM", "i-Oman" },
            { "anp", "isi-Angika" },
            { "crs", "i-Seselwa Creole French" },
            { "PA", "i-Panama" },
            { "type.ca.islamic-civil", "i-Islamic-Civil Calendar" },
            { "en_GB", "i-British English" },
            { "PE", "i-Peru" },
            { "PF", "i-French Polynesia" },
            { "PG", "i-Papua New Guinea" },
            { "PH", "i-Philippines" },
            { "PK", "i-Pakistan" },
            { "PL", "i-Poland" },
            { "ewo", "isi-Ewondo" },
            { "PM", "i-Saint Pierre kanye ne-Miquelon" },
            { "PN", "i-Pitcairn Islands" },
            { "PR", "i-Puerto Rico" },
            { "PS", "i-Palestinian Territories" },
            { "PT", "i-Portugal" },
            { "PW", "i-Palau" },
            { "nia", "isi-Nias" },
            { "type.nu.greklow", "izinombolo ezincane zesi-Greek" },
            { "PY", "i-Paraguay" },
            { "tum", "isi-Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "i-Qatar" },
            { "niu", "isi-Niuean" },
            { "QO", "i-Outlying Oceania" },
            { "lez", "isi-Lezghian" },
            { "tvl", "isi-Tuvalu" },
            { "001", "umhlaba" },
            { "002", "i-Africa" },
            { "003", "i-North America" },
            { "RE", "i-R\u00e9union" },
            { "005", "i-South America" },
            { "jbo", "isi-Lojban" },
            { "009", "i-Oceania" },
            { "RO", "i-Romania" },
            { "RS", "i-Serbia" },
            { "RU", "i-Russia" },
            { "RW", "i-Rwanda" },
            { "SA", "i-Saudi Arabia" },
            { "SB", "i-Solomon Islands" },
            { "twq", "isi-Tasawaq" },
            { "011", "i-Western Africa" },
            { "SC", "i-Seychelles" },
            { "SD", "i-Sudan" },
            { "013", "i-Central America" },
            { "SE", "i-Sweden" },
            { "014", "i-Eastern Africa" },
            { "015", "i-Northern Africa" },
            { "SG", "i-Singapore" },
            { "SH", "i-St. Helena" },
            { "type.lb.strict", "i-Line Break Style enomthetho oqinile" },
            { "017", "i-Middle Africa" },
            { "SI", "i-Slovenia" },
            { "018", "i-Southern Africa" },
            { "SJ", "i-Svalbard ne-Jan Mayen" },
            { "019", "i-Americas" },
            { "SK", "i-Slovakia" },
            { "SL", "i-Sierra Leone" },
            { "SM", "i-San Marino" },
            { "SN", "i-Senegal" },
            { "SO", "i-Somalia" },
            { "arn", "isi-Mapuche" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "arp", "isi-Arapaho" },
            { "SR", "i-Suriname" },
            { "SS", "i-South Sudan" },
            { "ST", "i-S\u00e3o Tom\u00e9 kanye ne-Pr\u00edncipe" },
            { "SV", "i-El Salvador" },
            { "SX", "i-Sint Maarten" },
            { "SY", "i-Syria" },
            { "SZ", "i-Swaziland" },
            { "TA", "i-Tristan da Cunha" },
            { "asa", "isi-Asu" },
            { "type.ms.ussystem", "isistimu yokulinganisa yase-US" },
            { "021", "i-Northern America" },
            { "TC", "i-Turks ne-Caicos Islands" },
            { "yav", "isi-Yangben" },
            { "TD", "i-Chad" },
            { "TF", "i-French Southern Territories" },
            { "TG", "i-Togo" },
            { "TH", "i-Thailand" },
            { "TJ", "i-Tajikistan" },
            { "029", "i-Caribbean" },
            { "TK", "i-Tokelau" },
            { "TL", "i-Timor-Leste" },
            { "ybb", "isi-Yemba" },
            { "type.co.searchjl", "Sesha nge-Hangul Ongwaqa Basekuqaleni" },
            { "TM", "i-Turkmenistan" },
            { "TN", "i-Tunisia" },
            { "TO", "i-Tonga" },
            { "TR", "i-Turkey" },
            { "TT", "i-Trinidad ne-Tobago" },
            { "TV", "i-Tuvalu" },
            { "TW", "i-Taiwan" },
            { "ast", "isi-Asturian" },
            { "TZ", "i-Tanzania" },
            { "nmg", "isi-Kwasio" },
            { "Zzzz", "iskripthi esingaziwa" },
            { "UA", "i-Ukraine" },
            { "rup", "isi-Aromanian" },
            { "030", "i-Eastern Asia" },
            { "tyv", "isi-Tuvinian" },
            { "sw_CD", "isi-Congo Swahili" },
            { "034", "i-Southern Asia" },
            { "035", "i-South-Eastern Asia" },
            { "UG", "i-Uganda" },
            { "hak", "isi-Hakka Chinese" },
            { "type.co.pinyin", "Ukuhlunga nge-Pinyin" },
            { "039", "i-Southern Europe" },
            { "Sinh", metaValue_si },
            { "UM", "i-U.S. Minor Outlying Islands" },
            { "UN", "I-United Nations" },
            { "US", "i-United States" },
            { "haw", "isi-Hawaiian" },
            { "type.co.gb2312han", "Ukuhlunga kwe-Simplified Chinese - GB2312" },
            { "UY", "i-Uruguay" },
            { "prg", "isi-Prussian" },
            { "UZ", "i-Uzbekistan" },
            { "tzm", "isi-Central Atlas Tamazight" },
            { "type.co.stroke", "Ukuhlunga kwe-Stroke" },
            { "nnh", "isi-Ngiemboon" },
            { "VA", "i-Vatican City" },
            { "VC", "i-Saint Vincent ne-Grenadines" },
            { "VE", "i-Venezuela" },
            { "VG", "i-British Virgin Islands" },
            { "VI", "i-U.S. Virgin Islands" },
            { "VN", "i-Vietnam" },
            { "VU", "i-Vanuatu" },
            { "nog", "isi-Nogai" },
            { "rwk", "isi-Rwa" },
            { "053", "i-Australasia" },
            { "054", "i-Melanesia" },
            { "WF", "i-Wallis ne-Futuna" },
            { "type.co.traditional", "Ukuhlunga ngokisiko" },
            { "057", "i-Micronesian Region" },
            { "jgo", "isi-Ngomba" },
            { "lkt", "isi-Lakota" },
            { "type.nu.finance", "Izinombolo Zezomnotho" },
            { "wae", "isi-Walser" },
            { "WS", "i-Samoa" },
            { "wal", "isi-Wolaytta" },
            { "XA", "Pseudo-Accents" },
            { "war", "isi-Waray" },
            { "XB", "Pseudo-Bidi" },
            { "awa", "isi-Awadhi" },
            { "061", "i-Polynesia" },
            { "XK", "i-Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "okungabhaliwe" },
            { "wbp", "isi-Warlpiri" },
            { "YE", "i-Yemen" },
            { "nqo", "isi-N\u2019Ko" },
            { "type.co.standard", "I-oda yokuhlunga ejwayelekile" },
            { "YT", "i-Mayotte" },
            { "ZA", "iNingizimu Afrika" },
            { "type.lb.loose", "i-Line Break Style exegayo" },
            { "Deva", "isi-Devanagari" },
            { "type.nu.geor", "izinombolo zesi-Georgian" },
            { "Hira", "isi-Hiragana" },
            { "ZM", "i-Zambia" },
            { "ZW", "iZimbabwe" },
            { "ZZ", "iSifunda esingaziwa" },
            { "type.ms.metric", "isistimu ye-Metric" },
            { "type.ca.iso8601", "ikhalenda le-ISO-8601" },
            { "nso", "isi-Northern Sotho" },
            { "type.nu.telu", "amadijithi esi-Telegu" },
            { "loz", "isi-Lozi" },
            { "jmc", "isi-Machame" },
            { "type.nu.hansfin", "izinombolo ezicacile zezezimali zesi-Chinese" },
            { "hil", "isi-Hiligaynon" },
            { "type.nu.arabext", "amadijithi esi-Arabic-Indic eluliwe" },
            { "nus", "isi-Nuer" },
            { "dak", "isi-Dakota" },
            { "type.nu.fullwide", "ububanzi obugcwele bamadijithi" },
            { "dar", "isi-Dargwa" },
            { "dav", "isi-Taita" },
            { "lrc", "isi-Northern Luri" },
            { "udm", "isi-Udmurt" },
            { "Khmr", metaValue_km },
            { "sad", "isi-Sandawe" },
            { "type.nu.roman", "izinombolo zesi-Roman" },
            { "sah", "i-Sakha" },
            { "saq", "isi-Samburu" },
            { "sat", "isi-Santali" },
            { "type.d0.npinyin", "Okwezinombolo" },
            { "type.nu.native", "Izinkinobho Zasendaweni" },
            { "sba", "isi-Ngambay" },
            { "Guru", "isi-Gurmukhi" },
            { "lua", "isi-Luba-Lulua" },
            { "type.d0.fwidth", "i-Fullwidth" },
            { "sbp", "isi-Sangu" },
            { "nyn", "isi-Nyankole" },
            { "lun", "isi-Lunda" },
            { "luo", "isi-Luo" },
            { "fil", "isi-Filipino" },
            { "hmn", "isi-Hmong" },
            { "lus", "isi-Mizo" },
            { "ban", "isi-Balinese" },
            { "luy", "isi-Luyia" },
            { "bas", "isi-Basaa" },
            { "es_ES", "isi-European Spanish" },
            { "sco", "isi-Scots" },
            { "scn", "isi-Sicilian" },
            { "aa", "isi-Afar" },
            { "ab", "isi-Abkhazian" },
            { "af", "i-Afrikaans" },
            { "ak", "isi-Akan" },
            { "am", "isi-Amharic" },
            { "Arab", metaValue_ar },
            { "an", "isi-Aragonese" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "i-Japanese syllabaries" },
            { "as", "isi-Assamese" },
            { "av", "isi-Avaric" },
            { "sdh", "i-Southern Kurdish" },
            { "ay", "isi-Aymara" },
            { "az", "isi-Azerbaijani" },
            { "ba", "isi-Bashkir" },
            { "type.co.unihan", "Ukuhlunga kwe-Radical-Stroke" },
            { "be", "isi-Belarusian" },
            { "bg", "isi-Bulgari" },
            { "bi", "isi-Bislama" },
            { "bm", "isi-Bambara" },
            { "bn", "isi-Bengali" },
            { "bo", "isi-Tibetan" },
            { "dgr", "isi-Dogrib" },
            { "br", "isi-Breton" },
            { "bs", "isi-Bosnian" },
            { "Mymr", "isi-Myanmar" },
            { "type.nu.laoo", "amadijithi esi-Lao" },
            { "seh", "isi-Sena" },
            { "ca", "isi-Catalan" },
            { "ses", "isi-Koyraboro Senni" },
            { "ce", "isi-Chechen" },
            { "ch", "isi-Chamorro" },
            { "co", "isi-Corsican" },
            { "Orya", metaValue_or },
            { "cs", "isi-Czech" },
            { "cu", "isi-Church Slavic" },
            { "cv", "isi-Chuvash" },
            { "cy", "isi-Welsh" },
            { "type.nu.ethi", "izinombolo zesi-Ethiopic" },
            { "da", "isi-Danish" },
            { "pt_PT", "isi-European Portuguese" },
            { "de", "isi-German" },
            { "type.cf.standard", "Ifomethi yemali ejwayelekile" },
            { "bem", "isi-Bemba" },
            { "type.nu.mong", "i-Mongolian Digits" },
            { "dv", "isi-Divehi" },
            { "es_419", "isi-Latin American Spanish" },
            { "dz", "isi-Dzongkha" },
            { "bez", "isi-Bena" },
            { "type.ca.chinese", "ikhalenda lesi-Chinese" },
            { "dje", "isi-Zarma" },
            { "type.nu.grek", "izinombolo zesi-Greek" },
            { "ee", "isi-Ewe" },
            { "type.lb.normal", "i-Line Break Style ekahle" },
            { "ro_MD", "isi-Moldavian" },
            { "el", metaValue_el },
            { "en", "i-English" },
            { "eo", "isi-Esperanto" },
            { "type.co.big5han", "Ukuhlunga kwe-Traditional Chinese - Big5" },
            { "es", "isi-Spanish" },
            { "et", "isi-Estonia" },
            { "Hanb", "isi-Hanb" },
            { "eu", "isi-Basque" },
            { "Hang", "isi-Hangul" },
            { "shi", "isi-Tachelhit" },
            { "hsb", "isi-Upper Sorbian" },
            { "Hani", "isi-Han" },
            { "shn", "isi-Shan" },
            { "fa", "isi-Persian" },
            { "Hans", "enziwe lula" },
            { "type.nu.latn", "amadijithi ase-Western" },
            { "Hant", "okosiko" },
            { "ff", "isi-Fulah" },
            { "hsn", "isi-Xiang Chinese" },
            { "fi", "isi-Finnish" },
            { "fj", "isi-Fijian" },
            { "fon", "isi-Fon" },
            { "bgn", "isi-Western Balochi" },
            { "yue", "isi-Cantonese" },
            { "fo", "isi-Faroese" },
            { "type.m0.bgn", "I-BGN" },
            { "umb", "isi-Umbundu" },
            { "fr", "isi-French" },
            { "fy", "isi-Western Frisian" },
            { "ga", "isi-Irish" },
            { "gd", "isi-Scottish Gaelic" },
            { "gl", "isi-Galicia" },
            { "gn", "isi-Guarani" },
            { "bho", "isi-Bhojpuri" },
            { "und", "ulimi olungaziwa" },
            { "type.ca.ethiopic-amete-alem", "i-Ethiopic Amete Alem Calender" },
            { "gu", metaValue_gu },
            { "gv", "isi-Manx" },
            { "ha", "isi-Hausa" },
            { "he", metaValue_he },
            { "hi", "isi-Hindi" },
            { "hup", "isi-Hupa" },
            { "bin", "isi-Bini" },
            { "hr", "isi-Croatian" },
            { "ht", "isi-Haitian" },
            { "hu", "isi-Hungarian" },
            { "hy", "isi-Armenia" },
            { "hz", "isi-Herero" },
            { "ia", "izilimi ezihlangene" },
            { "Jamo", "isi-Jamo" },
            { "id", "isi-Indonesian" },
            { "type.nu.tibt", "amadijithi esi-Tibetan" },
            { "ie", "izimili" },
            { "ig", "isi-Igbo" },
            { "ii", "isi-Sichuan Yi" },
            { "io", "isi-Ido" },
            { "is", "isi-Icelandic" },
            { "it", "isi-Italian" },
            { "iu", "isi-Inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "isi-Southern Sami" },
            { "jv", "isi-Javanese" },
            { "mad", "isi-Madurese" },
            { "smj", "isi-Lule Sami" },
            { "mag", "isi-Magahi" },
            { "mai", "isi-Maithili" },
            { "smn", "isi-Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "isi-Siksika" },
            { "mak", "isi-Makasar" },
            { "wuu", "isi-Wu Chinese" },
            { "sms", "isi-Skolt Sami" },
            { "kg", "isi-Kongo" },
            { "ki", "isi-Kikuyu" },
            { "mas", "isi-Masai" },
            { "kj", "isi-Kuanyama" },
            { "kk", "isi-Kazakh" },
            { "kl", "isi-Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "isi-Kanuri" },
            { "ks", "isi-Kashmiri" },
            { "ku", "isi-Kurdish" },
            { "kv", "isi-Komi" },
            { "kw", "isi-Cornish" },
            { "ky", "isi-Kyrgyz" },
            { "snk", "isi-Soninke" },
            { "la", metaValue_la },
            { "lb", "isi-Luxembourgish" },
            { "type.nu.mlym", "amadijithi esi-Malayalam" },
            { "lg", "isi-Ganda" },
            { "li", "isi-Limburgish" },
            { "Tibt", "i-Tibetan" },
            { "ln", "isi-Lingala" },
            { "fur", "isi-Friulian" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "isistimu yokulinganisa ebusayo" },
            { "lt", "isi-Lithuanian" },
            { "lu", "isi-Luba-Katanga" },
            { "lv", "isi-Latvian" },
            { "mg", "isi-Malagasy" },
            { "mh", "isi-Marshallese" },
            { "type.co.ducet", "Ukuhlunga okuzenzakalelayo kwe-Unicode" },
            { "mi", "isi-Maori" },
            { "mk", "isi-Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "isi-Marathi" },
            { "ms", "isi-Malay" },
            { "mt", "isi-Maltese" },
            { "my", "isi-Burmese" },
            { "Armn", "isi-Armenian" },
            { "mdf", "isi-Moksha" },
            { "dsb", "isi-Lower Sorbian" },
            { "na", "isi-Nauru" },
            { "type.co.search", "Usesho olujwayelekile" },
            { "nb", "isi-Norwegian Bokm\u00e5l" },
            { "nd", "isi-North Ndebele" },
            { "ne", "isi-Nepali" },
            { "ng", "isi-Ndonga" },
            { "nl", "isi-Dutch" },
            { "nn", "isi-Norwegian Nynorsk" },
            { "no", "isi-Norwegian" },
            { "nr", "isi-South Ndebele" },
            { "nv", "isi-Navajo" },
            { "ny", "isi-Nyanja" },
            { "kac", "isi-Kachin" },
            { "kab", "isi-Kabyle" },
            { "oc", "isi-Occitan" },
            { "kaj", "isi-Jju" },
            { "kam", "isi-Kamba" },
            { "men", "isi-Mende" },
            { "mer", "isi-Meru" },
            { "type.nu.armn", "izinombolo zesi-Armenian" },
            { "om", "isi-Oromo" },
            { "or", metaValue_or },
            { "os", "isi-Ossetic" },
            { "kbd", "isi-Kabardian" },
            { "mfe", "isi-Morisyen" },
            { "srn", "isi-Sranan Tongo" },
            { "pa", "isi-Punjabi" },
            { "dua", "isi-Duala" },
            { "pl", "isi-Polish" },
            { "type.ca.dangi", "ikhalenda lesi-Dangi" },
            { "ps", "isi-Pashto" },
            { "pt", "isi-Portuguese" },
            { "key.co", "Uhlelo lokuhlunga" },
            { "pt_BR", "isi-Brazillian Portuguese" },
            { "kcg", "isi-Tyap" },
            { "mgh", "isi-Makhuwa-Meetto" },
            { "key.cf", "Ifomethi yemali" },
            { "key.ca", "Ikhalenda" },
            { "Laoo", metaValue_lo },
            { "mgo", "isi-Meta\u2019" },
            { "type.hc.h23", "isistimu yamahora angu-24 (0-23)" },
            { "type.hc.h24", "isistimu yamahora angu-24 (1-24)" },
            { "ssy", "isi-Saho" },
            { "type.nu.mymr", "amadijithi esi-Maynmar" },
            { "qu", "isi-Quechua" },
            { "brx", "isi-Bodo" },
            { "kde", "isi-Makonde" },
            { "Ethi", "isi-Ethiopic" },
            { "type.hc.h12", "isistimu yamahora angu-12 (1-12)" },
            { "type.hc.h11", "isistimu yamahora angu-12 (0-11)" },
            { "rm", "isi-Romansh" },
            { "rn", "isi-Rundi" },
            { "key.cu", "Ikharensi" },
            { "ro", "isi-Romanian" },
            { "type.nu.orya", "Amadijithi ase-Odia" },
            { "type.nu.hanidec", "izinombolo zezinombolo zesi-Chinese" },
            { "ru", "isi-Russian" },
            { "rw", "isi-Kinyarwanda" },
            { "kea", "isi-Kabuverdianu" },
            { "mic", "isi-Micmac" },
            { "suk", "isi-Sukuma" },
            { "en_AU", "i-Australian English" },
            { "sa", "isi-Sanskrit" },
            { "sc", "isi-Sardinian" },
            { "sd", "isi-Sindhi" },
            { "se", "isi-Northern Sami" },
            { "min", "isi-Minangkabau" },
            { "sg", "isi-Sango" },
            { "sh", "isi-Serbo-Croatian" },
            { "si", metaValue_si },
            { "sk", "isi-Slovak" },
            { "sl", "isi-Slovenian" },
            { "sm", "isi-Samoan" },
            { "sn", "isiShona" },
            { "so", "isi-Somali" },
            { "type.nu.arab", "amadijithi esi-Arabic-Indic" },
            { "sq", "isi-Albania" },
            { "sr", "isi-Serbian" },
            { "ss", "isiSwati" },
            { "type.cf.account", "Ifomethi yemali ye-Accounting" },
            { "st", "isi-Southern Sotho" },
            { "su", "isi-Sundanese" },
            { "sv", "isi-Swedish" },
            { "sw", "isiSwahili" },
            { "type.nu.hantfin", "izinombolo zosiko zezezimali zesi-Chinese" },
            { "ibb", "isi-Ibibio" },
            { "iba", "isi-Iban" },
            { "ta", metaValue_ta },
            { "142", "i-Asia" },
            { "143", "i-Central Asia" },
            { "te", metaValue_te },
            { "145", "i-Western Asia" },
            { "tg", "isi-Tajik" },
            { "th", metaValue_th },
            { "ti", "isi-Tigrinya" },
            { "bug", "isi-Buginese" },
            { "kfo", "isi-Koro" },
            { "en_CA", "i-Canadian English" },
            { "tk", "isi-Turkmen" },
            { "tn", "isi-Tswana" },
            { "to", "isi-Tongan" },
            { "dyo", "isi-Jola-Fonyi" },
            { "type.nu.jpan", "izinombolo zesi-Japanese" },
            { "tr", "isi-Turkish" },
            { "ts", "isi-Tsonga" },
            { "swb", "isi-Comorian" },
            { "tt", "isi-Tatar" },
            { "tw", "isi-Twi" },
            { "ty", "isi-Tahitian" },
            { "150", "i-Europe" },
            { "151", "i-Eastern Europe" },
            { "154", "i-Northern Europe" },
            { "dzg", "isi-Dazaga" },
            { "155", "i-Western Europe" },
            { "ug", "isi-Uighur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "jwayelekile" },
            { "uk", "isi-Ukrainian" },
            { "type.ca.coptic", "i-Coptic Calender" },
            { "ur", "isi-Urdu" },
            { "xal", "isi-Kalmyk" },
            { "uz", "isi-Uzbek" },
            { "kha", "isi-Khasi" },
            { "nds_NL", "isi-Low Saxon" },
            { "ve", "isi-Venda" },
            { "type.ca.roc", "ikhalenda lesi-Minguo" },
            { "vi", "isi-Vietnamese" },
            { "khq", "isi-Koyra Chiini" },
            { "key.hc", "Umjikelezo wehora (12 vs 24" },
            { "vo", "isi-Volap\u00fck" },
            { "quc", "isi-K\u02bciche\u02bc" },
            { "gaa", "isi-Ga" },
            { "wa", "isi-Walloon" },
            { "gag", "isi-Gagauz" },
            { "syr", "isi-Syriac" },
            { "Grek", metaValue_el },
            { "gan", "isi-Gan Chinese" },
            { "wo", "isi-Wolof" },
            { "zgh", "isi-Moroccan Tamazight esivamile" },
            { "ar_001", "isi-Arabic esivamile sesimanje" },
            { "Mong", metaValue_mn },
            { "mni", "isi-Manipuri" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "izinombolo ezicacile zesi-Chinese" },
            { "type.nu.hant", "izinombolo zosiko zesi-Chinese" },
            { "xh", "isiXhosa" },
            { "type.nu.romanlow", metaValue_type_nu_taml },
            { "byn", "isi-Blin" },
            { "moh", "isi-Mohawk" },
            { "kkj", "isi-Kako" },
            { "yi", "isi-Yiddish" },
            { "mos", "isi-Mossi" },
            { "yo", "isi-Yoruba" },
            { "type.nu.traditional", "Izinombolo Ezijwayelekile" },
            { "es_MX", "Isi-Mexican Spanish" },
            { "vai", "isi-Vai" },
            { "kln", "isi-Kalenjin" },
            { "zh", "isi-Chinese" },
            { "Bopo", "isi-Bopomofo" },
            { "key.lb", "I-Line Break Style" },
            { "zu", "isiZulu" },
            { "type.co.phonebook", "Ukuhlunga kwebhuku lefoni" },
            { "Geor", metaValue_ka },
            { "kmb", "isi-Kimbundu" },
            { "type.nu.jpanfin", "izinombolo zezezimali zesi-Japanese" },
            { "gez", "isi-Geez" },
            { "type.co.reformed", "Ukuhlunga okwenziwe kabusha" },
            { "ebu", "isi-Embu" },
            { "zh_Hans", "isi-Chinese (esenziwe-lula)" },
            { "koi", "isi-Komi-Permyak" },
            { "kok", "isi-Konkani" },
            { "zh_Hant", "isi-Chinese (Okosiko)" },
            { "kpe", "isi-Kpelle" },
            { "type.nu.khmr", "amadijithi esi-Khmer" },
            { "ilo", "isi-Iloko" },
            { "mua", "isi-Mundang" },
            { "type.nu.guru", "amadijithi esi-Gurmukhi" },
            { "mul", "izilimi ezehlukene" },
            { "key.ms", "Isistimu yokulinganisa" },
            { "mus", "isi-Creek" },
            { "gil", "isi-Gilbertese" },
            { "type.nu.tamldec", "amadijithi esi-Tamil" },
            { "krc", "isi-Karachay-Balkar" },
            { "inh", "isi-Ingush" },
            { "krl", "isi-Karelian" },
            { "efi", "isi-Efik" },
            { "key.nu", "Izinombolo" },
            { "kru", "isi-Kurukh" },
            { "ksb", "isiShambala" },
            { "Telu", metaValue_te },
            { "ksf", "isi-Bafia" },
        };
        return data;
    }
}
