/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;

public class J9DDRClassLoader
extends SecureClassLoader {
    private final HashMap<String, Class<?>> cache = new HashMap();
    private final boolean generatePointers;
    private final StructureReader reader;
    private final String pointerPackageDotName;
    private final String structurePackageDotName;
    private final String streamPackageDotName;
    private IVMData vmData;

    private static boolean shouldGeneratePointerClasses(StructureReader reader) {
        if (reader.getPackageVersion() < 29L) {
            return false;
        }
        String packageName = reader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_SLASH_NAME);
        String resourceName = "/" + packageName + "dynamic.properties";
        InputStream stream = J9DDRClassLoader.class.getResourceAsStream(resourceName);
        if (stream == null) {
            return false;
        }
        Properties dynamic = new Properties();
        try {
            dynamic.load(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Boolean.parseBoolean(dynamic.getProperty("generate.pointers"));
    }

    private static String withTrailingDot(String name) {
        if (name.endsWith(".")) {
            return name;
        }
        return name + ".";
    }

    public J9DDRClassLoader(StructureReader reader, ClassLoader parent) {
        super(parent);
        this.reader = Objects.requireNonNull(reader);
        this.generatePointers = J9DDRClassLoader.shouldGeneratePointerClasses(reader);
        this.pointerPackageDotName = J9DDRClassLoader.withTrailingDot(reader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_DOT_NAME));
        this.structurePackageDotName = J9DDRClassLoader.withTrailingDot(reader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_DOT_NAME));
        this.streamPackageDotName = J9DDRClassLoader.withTrailingDot(reader.getPackageName(StructureReader.PackageNameType.PACKAGE_DOT_BASE_NAME));
        this.vmData = null;
    }

    public StructureHeader getHeader() {
        return this.reader.getHeader();
    }

    @Override
    protected Class<?> findClass(String binaryName) throws ClassNotFoundException {
        Class<?> clazz = this.cache.get(binaryName);
        if (clazz == null) {
            boolean generated;
            byte[] data;
            if (binaryName.startsWith(this.structurePackageDotName)) {
                data = this.getStructureClass(binaryName);
                generated = true;
            } else if (this.generatePointers && binaryName.startsWith(this.pointerPackageDotName)) {
                data = this.getPointerClass(binaryName);
                generated = true;
            } else {
                data = this.loadClassBytes(binaryName);
                generated = false;
            }
            clazz = this.defineClass(binaryName, data, 0, data.length);
            if (generated) {
                this.cache.put(binaryName, clazz);
            }
        }
        return clazz;
    }

    private byte[] loadClassBytes(String binaryName) throws ClassNotFoundException {
        String resourceName = "/" + binaryName.replace('.', '/') + ".class";
        InputStream stream = J9DDRClassLoader.class.getResourceAsStream(resourceName);
        if (stream == null) {
            throw new ClassNotFoundException("Couldn't duplicate class " + binaryName + ". Couldn't load resource " + resourceName + ", parent classloader " + this.getParent());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] localBuffer = new byte[1024];
        try {
            int read;
            while ((read = stream.read(localBuffer)) != -1) {
                baos.write(localBuffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("IOException reading resource " + resourceName + " for class " + binaryName, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    private void definePackage(String name) {
        int finalSeparator = name.lastIndexOf(46);
        if (finalSeparator != -1) {
            String packageName = name.substring(0, finalSeparator);
            if (this.getPackage(packageName) != null) {
                return;
            }
            this.definePackage(packageName, "J9DDR", "0.1", "IBM", "J9DDR", "0.1", "IBM", null);
        }
    }

    public Class<?> loadClassRelativeToStream(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(this.streamPackageDotName + name, resolve);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith(this.streamPackageDotName)) {
            Class<?> clazz = this.findLoadedClass(name);
            if (null == clazz) {
                clazz = this.findClass(name);
                this.definePackage(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
        if (name.startsWith(this.reader.getBasePackage())) {
            throw new ClassNotFoundException("Cannot load " + name + ". J9DDRClassLoader is configured to load " + this.streamPackageDotName + " DDR classes only.");
        }
        return this.getParent().loadClass(name);
    }

    private byte[] getPointerClass(String binaryName) throws ClassNotFoundException {
        try {
            return this.reader.getPointerClassBytes(binaryName);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(binaryName);
        }
    }

    private byte[] getStructureClass(String binaryName) throws ClassNotFoundException {
        try {
            return this.reader.getStructureClassBytes(binaryName);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(binaryName);
        }
    }

    public Collection<StructureReader.StructureDescriptor> getStructures() {
        return Collections.unmodifiableCollection(this.reader.getStructures());
    }

    public IVMData getIVMData(IProcess process, long address) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.vmData == null) {
            Class<?> vmDataClazz = this.loadClassRelativeToStream("j9.VMData", false);
            this.vmData = (IVMData)vmDataClazz.newInstance();
        }
        return this.vmData;
    }

    public String toString() {
        return "J9DDRClassloader for " + this.streamPackageDotName;
    }

    public StructureReader getReader() {
        return this.reader;
    }
}

