/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.tools.ddrinteractive.commands.TraceFileHeaderWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public abstract class SnapBaseCommand
extends Command {
    private String fileName = null;

    protected abstract void writeHeaderBytesToTrace(Context var1, byte[] var2, PrintStream var3);

    protected abstract void writeBytesToTrace(Context var1, long var2, int var4, PrintStream var5);

    protected void extractTraceData(Context context, PrintStream out) throws DDRInteractiveCommandException {
        long vmAddress = context.vmAddress;
        try {
            long j9rasglobalstorageAddress = CommandUtils.followPointerFromStructure(context, "J9JavaVM", vmAddress, "j9rasGlobalStorage");
            long utglobaldataAddress = CommandUtils.followPointerFromStructure(context, "RasGlobalStorage", j9rasglobalstorageAddress, "utGlobalData");
            if (utglobaldataAddress == 0L) {
                out.println("Encountered null J9JavaVM->j9rasGlobalStorage->utGlobalData pointer. Trace was not initialized, check dump VM options for -Xtrace:none");
                return;
            }
            long traceheaderAddress = CommandUtils.followPointerFromStructure(context, "UtGlobalData", utglobaldataAddress, "traceHeader");
            long bufferSizeOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "bufferSize");
            int bufferSize = context.process.getIntAt(utglobaldataAddress + bufferSizeOffset);
            if (traceheaderAddress != 0L) {
                long headerOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtTraceFileHdr", context), "header");
                long lengthOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtDataHeader", context), "length");
                int headerLength = context.process.getIntAt(traceheaderAddress + headerOffset + lengthOffset);
                out.println("traceHeader: !uttracefilehdr 0x" + Long.toHexString(traceheaderAddress));
                out.println("traceHeader: length     = " + headerLength);
                byte[] headerBytes = new byte[headerLength];
                context.process.getBytesAt(traceheaderAddress, headerBytes);
                this.writeHeaderBytesToTrace(context, headerBytes, out);
            } else {
                this.createAndWriteTraceFileHeader(context, utglobaldataAddress, bufferSize, out);
            }
            long nextTraceBufferAddress = CommandUtils.followPointerFromStructure(context, "UtGlobalData", utglobaldataAddress, "traceGlobal");
            out.println("Buffer size = " + bufferSize);
            out.println("firstBuffer: !uttracebuffer 0x" + Long.toHexString(nextTraceBufferAddress));
            int count = 0;
            long recordOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtTraceBuffer", context), "record");
            while (nextTraceBufferAddress != 0L) {
                this.writeBytesToTrace(context, nextTraceBufferAddress + recordOffset, bufferSize, out);
                nextTraceBufferAddress = CommandUtils.followPointerFromStructure(context, "UtTraceBuffer", nextTraceBufferAddress, "globalNext");
                if (++count < 10 && nextTraceBufferAddress != 0L) {
                    out.println("nextBuffer:  !uttracebuffer 0x" + Long.toHexString(nextTraceBufferAddress));
                    continue;
                }
                if (count != 10 || nextTraceBufferAddress == 0L) continue;
                out.println("...");
            }
            if (count > 0) {
                out.println(count + " trace buffers extracted from the dump.");
            } else {
                out.println("There were no trace buffers found in the dump");
            }
        }
        catch (MemoryFault e) {
            e.printStackTrace(out);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace(out);
        }
        catch (CorruptDataException e) {
            e.printStackTrace(out);
        }
    }

    private void createAndWriteTraceFileHeader(Context context, long utglobaldataAddress, int bufferSize, PrintStream out) throws CorruptDataException, DDRInteractiveCommandException {
        IProcess process = context.process;
        boolean isBigEndian = process.getByteOrder().equals(ByteOrder.BIG_ENDIAN);
        long j9rasAddress = CommandUtils.followPointerFromStructure(context, "J9JavaVM", context.vmAddress, "j9ras");
        long cpuOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("J9RAS", context), "cpus");
        int cpuCount = context.process.getIntAt(j9rasAddress + cpuOffset);
        long archOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("J9RAS", context), "osarch");
        String arch = this.getCStringAtAddress(process, j9rasAddress + archOffset, 16L);
        String processorSubType = "";
        long serviceInfoOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "serviceInfo");
        long serviceInfoAddress = process.getPointerAt(utglobaldataAddress + serviceInfoOffset);
        String serviceLevel = this.getCStringAtAddress(process, serviceInfoAddress);
        long propertiesOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "properties");
        long propertiesAddress = process.getPointerAt(utglobaldataAddress + propertiesOffset);
        String startupOptions = this.getCStringAtAddress(process, propertiesAddress);
        int wordSize = process.bytesPerPointer() * 8;
        Object traceConfig = "";
        long commandOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtTraceCfg", context), "command");
        long nextConfigAddress = CommandUtils.followPointerFromStructure(context, "UtGlobalData", utglobaldataAddress, "config");
        while (nextConfigAddress != 0L) {
            traceConfig = (String)traceConfig + this.getCStringAtAddress(process, nextConfigAddress + commandOffset);
            if ((nextConfigAddress = CommandUtils.followPointerFromStructure(context, "UtTraceCfg", nextConfigAddress, "next")) == 0L) continue;
            traceConfig = (String)traceConfig + "\n";
        }
        long startPlatformOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "startPlatform");
        long startPlatform = context.process.getLongAt(utglobaldataAddress + startPlatformOffset);
        long startSystemOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "startSystem");
        long startSystem = context.process.getLongAt(utglobaldataAddress + startSystemOffset);
        long externalTraceOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "externalTrace");
        int type2 = context.process.getIntAt(utglobaldataAddress + externalTraceOffset);
        long traceGenerationsOffset = CommandUtils.getOffsetForField(StructureCommandUtil.getStructureDescriptor("UtGlobalData", context), "traceGenerations");
        int generations = context.process.getIntAt(utglobaldataAddress + traceGenerationsOffset);
        try {
            TraceFileHeaderWriter headerWriter = new TraceFileHeaderWriter(this.fileName, isBigEndian, cpuCount, wordSize, bufferSize, arch, processorSubType, serviceLevel, startupOptions, (String)traceConfig, startPlatform, startSystem, type2, generations);
            byte[] headerBytes = headerWriter.createAndWriteTraceFileHeader();
            this.writeHeaderBytesToTrace(context, headerBytes, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCStringAtAddress(IProcess process, long address) throws CorruptDataException {
        return this.getCStringAtAddress(process, address, Long.MAX_VALUE);
    }

    public String getCStringAtAddress(IProcess process, long address, long maxLength) throws CorruptDataException {
        int length = 0;
        while (0 != process.getByteAt(address + (long)length) && (long)length < maxLength) {
            ++length;
        }
        byte[] buffer = new byte[length];
        process.getBytesAt(address, buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

