/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.structure.KeyValuePair;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=KeyValuePair.class)
public class KeyValuePairPointer
extends StructurePointer {
    public static final KeyValuePairPointer NULL = new KeyValuePairPointer(0L);

    protected KeyValuePairPointer(long address) {
        super(address);
    }

    public static KeyValuePairPointer cast(AbstractPointer structure) {
        return KeyValuePairPointer.cast(structure.getAddress());
    }

    public static KeyValuePairPointer cast(UDATA udata) {
        return KeyValuePairPointer.cast(udata.longValue());
    }

    public static KeyValuePairPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new KeyValuePairPointer(address);
    }

    @Override
    public KeyValuePairPointer add(long count) {
        return KeyValuePairPointer.cast(this.address + KeyValuePair.SIZEOF * count);
    }

    @Override
    public KeyValuePairPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public KeyValuePairPointer addOffset(long offset) {
        return KeyValuePairPointer.cast(this.address + offset);
    }

    @Override
    public KeyValuePairPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public KeyValuePairPointer sub(long count) {
        return KeyValuePairPointer.cast(this.address - KeyValuePair.SIZEOF * count);
    }

    @Override
    public KeyValuePairPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public KeyValuePairPointer subOffset(long offset) {
        return KeyValuePairPointer.cast(this.address - offset);
    }

    @Override
    public KeyValuePairPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public KeyValuePairPointer untag(long mask) {
        return KeyValuePairPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public KeyValuePairPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return KeyValuePair.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_keyOffset_", declaredType="U8*")
    public U8Pointer key() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(KeyValuePair._keyOffset_));
    }

    public PointerPointer keyEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)KeyValuePair._keyOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_valueOffset_", declaredType="U8*")
    public U8Pointer value() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(KeyValuePair._valueOffset_));
    }

    public PointerPointer valueEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)KeyValuePair._valueOffset_);
    }
}

