/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.walkers.MemorySegmentIterator;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgROMClassBuilderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgStringInternTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9InternHashTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9TranslationBufferSetPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.structure.J9ClassInitFlags;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class VmCheckCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final int J9_XACCESS_EXCLUSIVE = 2;

    public VmCheckCommand() {
        this.addCommand("vmcheck", "", "Run VM state sanity checks");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer javaVM = J9RASHelper.getVM(DataType.getJ9RASPointer());
            try {
                this.checkJ9VMThreadSanity(javaVM, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
            try {
                this.checkJ9ClassSanity(javaVM, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
            try {
                this.checkJ9ROMClassSanity(javaVM, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
            try {
                this.checkJ9MethodSanity(javaVM, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
            try {
                this.checkLocalInternTableSanity(javaVM, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void appendLine(PrintStream out, String format, Object ... args) {
        String line = String.format(format, args);
        out.append(line);
        out.append(nl);
    }

    private void reportError(PrintStream out, String format, Object ... args) {
        this.appendLine(out, "<vm check: FAILED - Error %s>", String.format(format, args));
    }

    private void reportMessage(PrintStream out, String format, Object ... args) {
        this.appendLine(out, "<vm check: %s>", String.format(format, args));
    }

    private void checkJ9VMThreadSanity(J9JavaVMPointer javaVM, PrintStream out) throws CorruptDataException {
        GCVMThreadListIterator gcvmThreadListIterator = GCVMThreadListIterator.from();
        int count = 0;
        int numberOfThreadsWithVMAccess = 0;
        boolean exclusiveVMAccess = javaVM.exclusiveAccessState().eq(2L);
        this.reportMessage(out, "Checking threads", new Object[0]);
        while (gcvmThreadListIterator.hasNext()) {
            J9VMThreadPointer thread = gcvmThreadListIterator.next();
            this.verifyJ9VMThread(out, thread, javaVM);
            if (thread.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_VM_ACCESS)) {
                ++numberOfThreadsWithVMAccess;
            }
            ++count;
        }
        if (exclusiveVMAccess && numberOfThreadsWithVMAccess > 1) {
            this.reportError(out, "numberOfThreadsWithVMAccess (%d) > 1 with vm->exclusiveAccessState == J9_XACCESS_EXCLUSIVE", numberOfThreadsWithVMAccess);
        }
        this.reportMessage(out, "Checking %d threads done", count);
    }

    private void verifyJ9VMThread(PrintStream out, J9VMThreadPointer thread, J9JavaVMPointer javaVM) throws CorruptDataException {
        J9JavaVMPointer threadJavaVM = thread.javaVM();
        if (!threadJavaVM.eq(javaVM)) {
            this.reportError(out, "vm (0x%s) != thread->javaVM (0x%s) for thread=0x%s", Long.toHexString(javaVM.getAddress()), Long.toHexString(threadJavaVM.getAddress()), Long.toHexString(thread.getAddress()));
        } else {
            J9JavaVMPointer threadJavaVMJavaVM = threadJavaVM.javaVM();
            if (!threadJavaVMJavaVM.eq(javaVM)) {
                this.reportError(out, "thread->javaVM (0x%s) != thread->javaVM->javaVM (0x%s) for thread=0x%s", Long.toHexString(threadJavaVM.getAddress()), Long.toHexString(threadJavaVMJavaVM.getAddress()), Long.toHexString(thread.getAddress()));
            }
        }
    }

    private void checkJ9ClassSanity(J9JavaVMPointer javaVM, PrintStream out) throws CorruptDataException {
        this.reportMessage(out, "Checking classes", new Object[0]);
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(javaVM.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        int count = 0;
        int obsoleteCount = 0;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
            while (classHeapIterator.hasNext()) {
                J9ClassPointer clazz = classHeapIterator.next();
                if (!J9ClassHelper.isObsolete(clazz)) {
                    this.verifyJ9Class(javaVM, out, clazz);
                } else {
                    this.verifyObsoleteJ9Class(javaVM, out, clazz);
                    ++obsoleteCount;
                }
                ++count;
            }
        }
        this.reportMessage(out, "Checking %d classes (%d obsolete) done", count, obsoleteCount);
    }

    private boolean verifyJ9Class(J9JavaVMPointer javaVM, PrintStream out, J9ClassPointer classPointer) throws CorruptDataException {
        boolean passed = this.verifyJ9ClassHeader(javaVM, out, classPointer);
        if (!classPointer.classLoader().isNull()) {
            J9MemorySegmentPointer segment = classPointer.classLoader().classSegments();
            if ((segment = this.findSegmentInClassLoaderForAddress(classPointer, segment)).isNull()) {
                this.reportError(out, "class=0x%s not found in classLoader=0x%s", Long.toHexString(classPointer.getAddress()), Long.toHexString(classPointer.classLoader().getAddress()));
                passed = false;
            }
        }
        if (!this.verifyJ9ClassSubclassHierarchy(javaVM, out, classPointer)) {
            passed = false;
        }
        return passed;
    }

    private boolean verifyJ9ClassHeader(J9JavaVMPointer javaVM, PrintStream out, J9ClassPointer classPointer) throws CorruptDataException {
        J9ConstantPoolPointer constantPool;
        J9ClassPointer cpClass;
        long classDepth;
        boolean passed = true;
        J9ROMClassPointer romClass = classPointer.romClass();
        String rootClasses = "java.lang.Object";
        if (!J9ClassHelper.hasValidEyeCatcher(classPointer)) {
            this.reportError(out, "0x99669966 != eyecatcher (0x%s) for class=0x%s", Long.toHexString(classPointer.eyecatcher().longValue()), Long.toHexString(classPointer.getAddress()));
            passed = false;
        }
        if (romClass.isNull()) {
            this.reportError(out, "NULL == romClass for class=0x%s", Long.toHexString(classPointer.getAddress()));
            passed = false;
        }
        if (classPointer.classLoader().isNull()) {
            this.reportError(out, "NULL == classLoader for class=0x%s", Long.toHexString(classPointer.getAddress()));
            passed = false;
        }
        if ((classDepth = J9ClassHelper.classDepth(classPointer).longValue()) > 0L) {
            if (classPointer.superclasses().isNull()) {
                this.reportError(out, "NULL == superclasses for non-" + rootClasses + " class=0x%s", Long.toHexString(classPointer.getAddress()));
                passed = false;
            } else {
                for (long i = 0L; i < classDepth; ++i) {
                    if (!classPointer.superclasses().at(i).isNull()) continue;
                    this.reportError(out, "superclasses[%d] is NULL for class=0x%s", Long.toHexString(classPointer.getAddress()));
                    passed = false;
                    break;
                }
            }
        } else if (classPointer.superclasses().at(-1L).notNull()) {
            this.reportError(out, "superclasses[-1] should be NULL for class=0x%s", Long.toHexString(classPointer.getAddress()));
            passed = false;
        }
        if (classPointer.initializeStatus().eq(J9ClassInitFlags.J9ClassInitSucceeded) && classPointer.classObject().isNull()) {
            this.reportError(out, "NULL == class->classObject for initialized class=0x%s", Long.toHexString(classPointer.getAddress()));
            passed = false;
        }
        if (J9ClassHelper.isObsolete(classPointer)) {
            this.reportError(out, "clazz=0x%s is obsolete", Long.toHexString(classPointer.getAddress()));
            passed = false;
        }
        if (!(romClass.isNull() || romClass.romConstantPoolCount().eq(0L) || classPointer.eq(cpClass = (constantPool = J9ConstantPoolPointer.cast(classPointer.ramConstantPool())).ramClass()))) {
            this.reportError(out, "clazz=0x%s not equal clazz->ramConstantPool->ramClass=0x%s", Long.toHexString(classPointer.getAddress()), Long.toHexString(cpClass.getAddress()));
            passed = false;
        }
        return passed;
    }

    private boolean verifyObsoleteJ9Class(J9JavaVMPointer javaVM, PrintStream out, J9ClassPointer classPointer) throws CorruptDataException {
        boolean passed = true;
        J9ClassPointer currentClass = J9ClassHelper.currentClass(classPointer);
        this.verifyJ9ClassHeader(javaVM, out, currentClass);
        J9ClassPointer replacedClass = currentClass.replacedClass();
        while (!replacedClass.isNull() && !replacedClass.eq(classPointer)) {
            replacedClass = replacedClass.replacedClass();
        }
        if (replacedClass.isNull()) {
            this.reportError(out, "obsolete class=0x%s is not in replaced list on currentClass=0x%s", Long.toHexString(classPointer.getAddress()), Long.toHexString(currentClass.getAddress()));
            passed = false;
        }
        return passed;
    }

    private boolean verifyJ9ClassSubclassHierarchy(J9JavaVMPointer javaVM, PrintStream out, J9ClassPointer classPointer) throws CorruptDataException {
        int index = 0;
        UDATA rootDepth = J9ClassHelper.classDepth(classPointer);
        J9ClassPointer currentClass = classPointer;
        boolean done = false;
        while (!done) {
            J9ClassPointer nextSubclass = currentClass.subclassTraversalLink();
            if (nextSubclass.isNull()) {
                this.reportError(out, "class=0x%s had NULL entry in subclassTraversalLink list at index=%d following class=0x%s", Long.toHexString(classPointer.getAddress()), index, Long.toHexString(currentClass.getAddress()));
                return false;
            }
            if (!this.verifyJ9ClassHeader(javaVM, out, nextSubclass)) {
                return false;
            }
            if (J9ClassHelper.classDepth(nextSubclass).lte(rootDepth)) {
                done = true;
                continue;
            }
            currentClass = nextSubclass;
            ++index;
        }
        return true;
    }

    private J9MemorySegmentPointer findSegmentInClassLoaderForAddress(J9ClassPointer classPointer, J9MemorySegmentPointer segment) throws CorruptDataException {
        long address;
        while (!(segment.isNull() || (address = classPointer.getAddress()) >= segment.heapBase().longValue() && address < segment.heapAlloc().longValue())) {
            segment = segment.nextSegment();
        }
        return segment;
    }

    private void checkJ9ROMClassSanity(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        this.reportMessage(out, "Checking ROM classes", new Object[0]);
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(vm.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        int count = 0;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
            while (classHeapIterator.hasNext()) {
                J9ClassPointer clazz = classHeapIterator.next();
                this.verifyJ9ROMClass(out, vm, clazz);
                ++count;
            }
        }
        this.reportMessage(out, "Checking %d ROM classes done", count);
    }

    private void verifyJ9ROMClass(PrintStream out, J9JavaVMPointer vm, J9ClassPointer clazz) throws CorruptDataException {
        UDATA romConstantPoolCount;
        UDATA ramConstantPoolCount;
        J9ROMClassPointer romClass = clazz.romClass();
        J9ClassLoaderPointer classLoader = clazz.classLoader();
        J9MemorySegmentPointer segment = this.findSegmentInClassLoaderForAddress(classLoader, romClass);
        if (!segment.isNull()) {
            U32Pointer cpShapeDescription;
            long address;
            if (romClass.interfaceCount().longValue() != 0L) {
                address = romClass.interfaces().getAddress();
                this.verifyAddressInSegment(out, vm, segment, address, "romClass->interfaces");
            }
            if (romClass.romMethodCount().longValue() != 0L) {
                address = romClass.romMethods().longValue();
                this.verifyAddressInSegment(out, vm, segment, address, "romClass->romMethods");
            }
            if (romClass.romFieldCount().longValue() != 0L) {
                address = romClass.romFields().longValue();
                this.verifyAddressInSegment(out, vm, segment, address, "romClass->romFields");
            }
            if (romClass.innerClassCount().longValue() != 0L) {
                address = romClass.innerClasses().longValue();
                this.verifyAddressInSegment(out, vm, segment, address, "romClass->innerClasses");
            }
            if (!(cpShapeDescription = J9ROMClassHelper.cpShapeDescription(romClass)).isNull()) {
                address = cpShapeDescription.getAddress();
                this.verifyAddressInSegment(out, vm, segment, address, "romClass->cpShapeDescription");
            }
        }
        J9UTF8Pointer className = romClass.className();
        J9UTF8Pointer superclassName = romClass.superclassName();
        J9UTF8Pointer outerClassName = romClass.outerClassName();
        if (className.isNull() || !this.verifyUTF8(className)) {
            this.reportError(out, "invalid className=0x%s utf8 for romClass=0x%s", Long.toHexString(className.getAddress()), Long.toHexString(romClass.getAddress()));
        }
        if (!superclassName.isNull() && !this.verifyUTF8(superclassName)) {
            this.reportError(out, "invalid superclassName=0x%s utf8 for romClass=0x%s", Long.toHexString(superclassName.getAddress()), Long.toHexString(romClass.getAddress()));
        }
        if (!outerClassName.isNull() && !this.verifyUTF8(outerClassName)) {
            this.reportError(out, "invalid outerclassName=0x%s utf8 for romClass=0x%s", Long.toHexString(outerClassName.getAddress()), Long.toHexString(romClass.getAddress()));
        }
        if ((ramConstantPoolCount = romClass.ramConstantPoolCount()).gt(romConstantPoolCount = romClass.romConstantPoolCount())) {
            this.reportError(out, "ramConstantPoolCount=%d > romConstantPoolCount=%d for romClass=0x%s", ramConstantPoolCount.longValue(), romConstantPoolCount.longValue(), Long.toHexString(romClass.getAddress()));
        }
    }

    private boolean verifyUTF8(J9UTF8Pointer utf8) throws CorruptDataException {
        if (utf8.isNull()) {
            return false;
        }
        UDATA length = new UDATA(utf8.length());
        U8Pointer utf8Data = utf8.dataEA();
        while (length.longValue() > 0L) {
            U16 temp = new U16(0L);
            U32 lengthRead = this.decodeUTF8CharN(utf8Data, temp, length);
            if (lengthRead.eq(0L)) {
                return false;
            }
            length = length.sub(lengthRead);
            utf8Data = utf8Data.addOffset(lengthRead);
        }
        return true;
    }

    U32 decodeUTF8CharN(U8Pointer input, U16 result, UDATA bytesRemaining) throws CorruptDataException {
        U8Pointer cursor = input;
        if (bytesRemaining.longValue() < 1L) {
            return new U32(0L);
        }
        U8 c = cursor.at(0L);
        cursor = cursor.add(1L);
        if (c.eq(0L)) {
            return new U32(0L);
        }
        if (c.bitAnd(128).eq(0L)) {
            return new U32(1L);
        }
        if (c.bitAnd(224).eq(192L)) {
            if (bytesRemaining.lt(2)) {
                return new U32(0L);
            }
            U16 unicodeC = new U16(c.bitAnd(31).leftShift(6));
            c = cursor.at(0L);
            cursor = cursor.add(1L);
            unicodeC = unicodeC.add(new U16(unicodeC.add(c.bitAnd(63))));
            if (!c.bitAnd(192).eq(128L)) {
                return new U32(0L);
            }
            return new U32(2L);
        }
        if (c.bitAnd(240).eq(224L)) {
            if (bytesRemaining.lt(3)) {
                return new U32(0L);
            }
            U16 unicodeC = new U16(c.bitAnd(15).leftShift(12));
            c = cursor.at(0L);
            cursor = cursor.add(1L);
            unicodeC = unicodeC.add(new U16(c.bitAnd(63).leftShift(6)));
            if (!c.bitAnd(192).eq(128L)) {
                return new U32(0L);
            }
            c = cursor.at(0L);
            cursor = cursor.add(1L);
            unicodeC = unicodeC.add(new U16(c.bitAnd(63)));
            if (!c.bitAnd(192).eq(128L)) {
                return new U32(0L);
            }
            return new U32(3L);
        }
        return new U32(0L);
    }

    private void verifyAddressInSegment(PrintStream out, J9JavaVMPointer vm, J9MemorySegmentPointer segment, long address, String description) throws CorruptDataException {
        U8Pointer heapBase = segment.heapBase();
        U8Pointer heapAlloc = segment.heapAlloc();
        if (address < heapBase.getAddress() || address >= heapAlloc.getAddress()) {
            this.reportError(out, "address 0x%s (%s) not in segment [heapBase=0x%s, heapAlloc=0x%s]", address, description, Long.toHexString(heapBase.getAddress()), Long.toHexString(heapAlloc.getAddress()));
        }
    }

    public J9MemorySegmentPointer findSegmentInClassLoaderForAddress(J9ClassLoaderPointer classLoader, J9ROMClassPointer romClassPointer) throws CorruptDataException {
        MemorySegmentIterator memorySegmentIterator = new MemorySegmentIterator(classLoader.classSegments(), -1, true);
        J9MemorySegmentPointer memorySegmentPointer = J9MemorySegmentPointer.NULL;
        J9MemorySegmentPointer foundMemorySegmentPointer = J9MemorySegmentPointer.NULL;
        while (memorySegmentIterator.hasNext()) {
            Object next2 = memorySegmentIterator.next();
            memorySegmentPointer = (J9MemorySegmentPointer)next2;
            if (romClassPointer.getAddress() < memorySegmentPointer.heapBase().longValue() || romClassPointer.getAddress() >= memorySegmentPointer.heapAlloc().longValue()) continue;
            foundMemorySegmentPointer = memorySegmentPointer;
            break;
        }
        return foundMemorySegmentPointer;
    }

    private void checkJ9MethodSanity(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        this.reportMessage(out, "Checking methods", new Object[0]);
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(vm.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        int count = 0;
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
            while (classHeapIterator.hasNext()) {
                J9ClassPointer clazz = classHeapIterator.next();
                if (J9ClassHelper.isObsolete(clazz)) continue;
                count += this.verifyClassMethods(vm, out, clazz);
            }
        }
        this.reportMessage(out, "Checking %d methods done", count);
    }

    private int verifyClassMethods(J9JavaVMPointer vm, PrintStream out, J9ClassPointer clazz) throws CorruptDataException {
        int count = 0;
        J9ROMClassPointer romClass = clazz.romClass();
        int methodCount = romClass.romMethodCount().intValue();
        J9MethodPointer methods = clazz.ramMethods();
        boolean isInterfaceClass = J9ROMClassHelper.isInterface(romClass);
        J9ConstantPoolPointer ramConstantPool = J9ConstantPoolPointer.cast(clazz.ramConstantPool());
        for (int i = 0; i < methodCount; ++i) {
            J9MethodPointer method = methods.add(i);
            J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(method);
            boolean methodInVTable = J9ROMMethodHelper.hasVTable(romMethod);
            if (!this.findROMMethodInClass(vm, romClass, romMethod, methodCount)) {
                this.reportError(out, "romMethod=0x%s (ramMethod=0x%s) not found in romClass=0x%s", Long.toHexString(romMethod.getAddress()), Long.toHexString(method.getAddress()), Long.toHexString(romClass.getAddress()));
            }
            if (!isInterfaceClass && methodInVTable && !this.findMethodInVTable(method, clazz)) {
                this.reportError(out, "romMethod=0x%s (ramMethod=0x%s) not found in vTable of ramClass=0x%s", Long.toHexString(romMethod.getAddress()), Long.toHexString(method.getAddress()), Long.toHexString(clazz.getAddress()));
            }
            if (!ramConstantPool.eq(ConstantPoolHelpers.J9_CP_FROM_METHOD(method))) {
                this.reportError(out, "ramConstantPool=0x%s on ramMethod=0x%s not equal to ramConstantPool=0x%s on ramClass=0x%s", Long.toHexString(ConstantPoolHelpers.J9_CP_FROM_METHOD(method).getAddress()), Long.toHexString(method.getAddress()), Long.toHexString(ramConstantPool.getAddress()), Long.toHexString(clazz.getAddress()));
            }
            ++count;
        }
        return count;
    }

    private boolean findMethodInVTable(J9MethodPointer method, J9ClassPointer classPointer) throws CorruptDataException {
        long vTableIndex;
        UDATAPointer vTable;
        long vTableSize;
        if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
            J9VTableHeaderPointer vTableHeader = J9ClassHelper.vTableHeader(classPointer);
            vTableSize = vTableHeader.size().longValue();
            vTable = J9ClassHelper.vTable(vTableHeader);
            vTableIndex = 0L;
        } else {
            vTable = J9ClassHelper.oldVTable(classPointer);
            vTableSize = vTable.at(0L).longValue() + 1L;
            vTableIndex = 2L;
        }
        while (vTableIndex < vTableSize) {
            if (method.eq(J9MethodPointer.cast(vTable.at(vTableIndex)))) {
                return true;
            }
            ++vTableIndex;
        }
        return false;
    }

    private boolean findROMMethodInClass(J9JavaVMPointer vm, J9ROMClassPointer romClass, J9ROMMethodPointer romMethodToFind, int methodCount) throws CorruptDataException {
        J9ROMMethodPointer romMethod = romClass.romMethods();
        for (int i = 0; i < methodCount; ++i) {
            if (i != 0) {
                romMethod = ROMHelp.nextROMMethod(romMethod);
            }
            if (!romMethodToFind.eq(romMethod)) continue;
            return true;
        }
        return false;
    }

    private void checkLocalInternTableSanity(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        int count = 0;
        this.reportMessage(out, "Checking ROM intern string nodes", new Object[0]);
        J9TranslationBufferSetPointer dynamicLoadBuffers = vm.dynamicLoadBuffers();
        if (!dynamicLoadBuffers.isNull()) {
            J9DbgROMClassBuilderPointer romClassBuilder = J9DbgROMClassBuilderPointer.cast(dynamicLoadBuffers.romClassBuilder());
            J9DbgStringInternTablePointer stringInternTable = romClassBuilder.stringInternTable();
            J9InternHashTableEntryPointer node = stringInternTable.headNode();
            while (!node.isNull()) {
                J9UTF8Pointer utf8 = node.utf8();
                J9ClassLoaderPointer classLoader = node.classLoader();
                if (!this.verifyUTF8(utf8)) {
                    this.reportError(out, "invalid utf8=0x%s for node=0x%s", Long.toHexString(utf8.getAddress()), Long.toHexString(node.getAddress()));
                }
                if (!this.verifyJ9ClassLoader(vm, classLoader)) {
                    this.reportError(out, "invalid classLoader=0x%s for node=0x%s", Long.toHexString(classLoader.getAddress()), Long.toHexString(node.getAddress()));
                }
                ++count;
                node = node.nextNode();
            }
        }
        this.reportMessage(out, "Checking %d ROM intern string nodes done", count);
    }

    private boolean verifyJ9ClassLoader(J9JavaVMPointer vm, J9ClassLoaderPointer classLoader) throws CorruptDataException {
        GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.from();
        while (classLoaderIterator.hasNext()) {
            J9ClassLoaderPointer classLoaderPointer = classLoaderIterator.next();
            if (!classLoaderPointer.eq(classLoader)) continue;
            return true;
        }
        return false;
    }
}

