/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;

public class J9DDRCorruptData
implements CorruptData {
    private final IProcess proc;
    private final CorruptDataException cde;
    private final String message;
    private final boolean addressSet;
    private final long address;

    public J9DDRCorruptData(IProcess proc, CorruptDataException e) {
        this.proc = proc;
        this.message = null;
        this.address = 0L;
        this.addressSet = false;
        this.cde = e;
    }

    public J9DDRCorruptData(IProcess proc) {
        this.cde = null;
        this.proc = proc;
        this.message = null;
        this.addressSet = false;
        this.address = 0L;
    }

    public J9DDRCorruptData(IProcess proc, String message) {
        this.proc = proc;
        this.cde = null;
        this.message = message;
        this.address = 0L;
        this.addressSet = false;
    }

    public J9DDRCorruptData(IProcess proc, String message, long address) {
        this.proc = proc;
        this.cde = null;
        this.message = message;
        this.address = address;
        this.addressSet = true;
    }

    public ImagePointer getAddress() {
        if (this.addressSet) {
            return new J9DDRImagePointer(this.proc, this.address);
        }
        if (this.cde != null && this.cde instanceof AddressedCorruptDataException) {
            return new J9DDRImagePointer(this.proc, ((AddressedCorruptDataException)this.cde).getAddress());
        }
        return null;
    }

    public String toString() {
        Object messageComponent = "";
        if (this.message != null) {
            messageComponent = " Message: " + this.message;
        } else if (this.cde != null) {
            messageComponent = " Message: " + this.cde.getMessage();
        }
        Object addressComponent = "";
        if (this.addressSet) {
            addressComponent = " Address: 0x" + Long.toHexString(this.address);
        } else if (this.cde != null && this.cde instanceof AddressedCorruptDataException) {
            addressComponent = " Address: 0x" + Long.toHexString(((AddressedCorruptDataException)this.cde).getAddress());
        }
        return "J9DDRCorruptData [as=" + this.proc.getAddressSpace() + (String)messageComponent + (String)addressComponent + "]";
    }
}

