/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NoSuchFieldException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;

public class GpInfoCommand
extends Command {
    public GpInfoCommand() {
        this.addCommand("gpinfo", "", "print out info about a gpf if one occured");
    }

    @Override
    public Collection<String> getCommandDescriptions() {
        return Collections.singleton("gpinfo                         - print out info about a gpf if one occured");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        long vmAddress = context.vmAddress;
        try {
            long j9rasAddress = CommandUtils.followPointerFromStructure(context, "J9JavaVM", vmAddress, "j9ras");
            long crashInfoAddress = CommandUtils.followPointerFromStructure(context, "J9RAS", j9rasAddress, "crashInfo");
            if (crashInfoAddress != 0L) {
                long failingThread = CommandUtils.followPointerFromStructure(context, "J9RASCrashInfo", crashInfoAddress, "failingThread");
                long failingThreadID = CommandUtils.followPointerFromStructure(context, "J9RASCrashInfo", crashInfoAddress, "failingThreadID");
                long gpinfo = CommandUtils.followPointerFromStructure(context, "J9RASCrashInfo", crashInfoAddress, "gpInfo");
                out.println("Failing Thread: !j9vmthread 0x" + Long.toHexString(failingThread));
                out.println("Failing Thread ID: 0x" + Long.toHexString(failingThreadID) + " (" + failingThreadID + ")");
                out.println("gpInfo:");
                out.println(CommandUtils.getCStringAtAddress(context.process, gpinfo));
            } else {
                out.println("Core does not appear to have been triggered by a gpf. No J9RASCrashInfo found.");
            }
        }
        catch (MemoryFault e) {
            throw new DDRInteractiveCommandException(e);
        }
        catch (NoSuchFieldException e) {
            throw new DDRInteractiveCommandException(e);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

