/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.elf.unwind.CIE;
import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.stream.ImageInputStream;

public class FDE {
    private final Unwind unwind;
    CIE cie;
    private long pcBegin;
    private long pcBeginAddress;
    private long pcRange;
    private byte[] callFrameInstructions;
    long startPos;
    long length;

    public FDE(Unwind unwind, ImageInputStream cfiStream, CIE parentCIE, long startPos, long length) throws IOException, CorruptDataException {
        this.unwind = unwind;
        if (parentCIE == null) {
            throw new CorruptDataException("An FDE record must have a parent CIE");
        }
        this.cie = parentCIE;
        this.startPos = startPos;
        this.length = length;
        this.pcBegin = 0L;
        this.pcRange = 0L;
        this.pcBegin = this.unwind.readEncodedPC(cfiStream, parentCIE.fdePointerEncoding);
        this.pcRange = this.unwind.readEncodedPC(cfiStream, parentCIE.fdePointerEncoding);
        this.pcBeginAddress = startPos + 8L;
        if (parentCIE.augmentationStr.startsWith("z")) {
            long augmentationLength = Unwind.readUnsignedLEB128(cfiStream);
            byte[] augmentationData = new byte[(int)augmentationLength];
            cfiStream.read(augmentationData, 0, augmentationData.length);
        }
        this.callFrameInstructions = new byte[(int)(length - (cfiStream.getStreamPosition() - startPos))];
        cfiStream.read(this.callFrameInstructions, 0, this.callFrameInstructions.length);
        int remainder = (int)(cfiStream.getStreamPosition() % (long)this.unwind.process.bytesPerPointer());
        cfiStream.read(new byte[remainder], 0, remainder);
    }

    public boolean contains(long instructionAddress) throws CorruptDataException, IOException {
        long base = this.getBaseAddress();
        long end = base + this.pcRange;
        return instructionAddress >= base && instructionAddress <= end;
    }

    public long getBaseAddress() throws IOException {
        long base = 0L;
        if ((this.cie.fdePointerEncoding & 0x10) == 0) {
            base = this.pcBegin;
        } else if ((this.cie.fdePointerEncoding & 0x10) == 16) {
            base = this.pcBeginAddress + this.pcBegin;
        } else {
            throw new IOException(String.format("Unsupported address modifier 0x%x", this.cie.fdePointerEncoding));
        }
        return base;
    }

    public void dump(PrintStream out) throws IOException {
        out.printf("Position 0x%x, length 0x%x, CIE ptr 0x%x\n", this.startPos, this.length, 0);
        out.printf("\tpcStart 0x%x...0x%x\n", this.pcBegin, this.pcBegin + this.pcRange);
        out.printf("\t(pcStart 0x%x...0x%x)\n", this.getBaseAddress(), this.getBaseAddress() + this.pcRange);
        UnwindTable.dumpInstructions(out, this.callFrameInstructions, this.cie);
        out.println();
    }

    public CIE getCIE() {
        return this.cie;
    }

    public byte[] getCallFrameInstructions() {
        return this.callFrameInstructions;
    }
}

