/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFAArch64DumpReader
extends ELFDumpReader {
    ELFAArch64DumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        super(reader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "arm64";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        TreeMap<String, Number> registers = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator(this));
        for (int i = 0; i < 30; ++i) {
            registers.put("x" + i, this._reader.readLong());
        }
        registers.put("lr", this._reader.readLong());
        registers.put("sp", this._reader.readLong());
        registers.put("pc", this._reader.readLong());
        registers.put("pstate", this._reader.readLong());
        return registers;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "sp";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> registers) {
        return this.getStackPointerFrom(registers);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return registers.get("pc").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return registers.get("lr").longValue();
    }

    @Override
    protected void readHighwordRegisters(DataEntry entry, Map<String, Number> registers) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in AArch64 ELF dump");
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] registersVals = new String[34];
        for (int i = 0; i < 30; ++i) {
            registersVals[i] = "x" + i;
        }
        registersVals[30] = "lr";
        registersVals[31] = "sp";
        registersVals[32] = "pc";
        registersVals[33] = "sptate";
        return registersVals;
    }
}

