/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.structure.ClassEntry;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=ClassEntry.class)
public class ClassEntryPointer
extends StructurePointer {
    public static final ClassEntryPointer NULL = new ClassEntryPointer(0L);

    protected ClassEntryPointer(long address) {
        super(address);
    }

    public static ClassEntryPointer cast(AbstractPointer structure) {
        return ClassEntryPointer.cast(structure.getAddress());
    }

    public static ClassEntryPointer cast(UDATA udata) {
        return ClassEntryPointer.cast(udata.longValue());
    }

    public static ClassEntryPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ClassEntryPointer(address);
    }

    @Override
    public ClassEntryPointer add(long count) {
        return ClassEntryPointer.cast(this.address + ClassEntry.SIZEOF * count);
    }

    @Override
    public ClassEntryPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ClassEntryPointer addOffset(long offset) {
        return ClassEntryPointer.cast(this.address + offset);
    }

    @Override
    public ClassEntryPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public ClassEntryPointer sub(long count) {
        return ClassEntryPointer.cast(this.address - ClassEntry.SIZEOF * count);
    }

    @Override
    public ClassEntryPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ClassEntryPointer subOffset(long offset) {
        return ClassEntryPointer.cast(this.address - offset);
    }

    @Override
    public ClassEntryPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ClassEntryPointer untag(long mask) {
        return ClassEntryPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ClassEntryPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ClassEntry.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_clazzOffset_", declaredType="J9Class*")
    public J9ClassPointer clazz() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(ClassEntry._clazzOffset_);
        return J9ClassPointer.cast(pointer);
    }

    public PointerPointer clazzEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ClassEntry._clazzOffset_);
    }

    public UDATAPointer countEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)ClassEntry._countOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="ClassEntry*")
    public ClassEntryPointer next() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(ClassEntry._nextOffset_);
        return ClassEntryPointer.cast(pointer);
    }

    public PointerPointer nextEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ClassEntry._nextOffset_);
    }
}

