/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFPPC64DumpReader
extends ELFDumpReader {
    protected ELFPPC64DumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        super(eLFFileReader);
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> map) {
        return this.getStackPointerFrom(map);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> map) {
        return map.get("pc").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> map) {
        return map.get("lr").longValue();
    }

    @Override
    protected String getProcessorType() {
        return "ppc";
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "gpr1";
    }

    @Override
    protected long getOffsetToIPFromBP() {
        return 2L;
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        TreeMap<String, Number> treeMap = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator(this));
        for (int i = 0; i < 32; ++i) {
            treeMap.put("gpr" + i, this._reader.readLong());
        }
        treeMap.put("pc", this._reader.readLong());
        this._reader.readLong();
        this._reader.readLong();
        treeMap.put("ctr", this._reader.readLong());
        treeMap.put("lr", this._reader.readLong());
        long l = this._reader.readLong() >> 32 & 0xFFFFFFFFL;
        treeMap.put("xer", l);
        l = this._reader.readLong() >> 32 & 0xFFFFFFFFL;
        treeMap.put("cr", l);
        return treeMap;
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        int n;
        String[] stringArray = new String[132];
        for (n = 0; n < 32; ++n) {
            stringArray[n] = "gpr" + n;
        }
        for (n = 32; n < 64; ++n) {
            stringArray[n] = "fpr" + n;
        }
        stringArray[64] = "ctr";
        stringArray[65] = "lr";
        for (n = 100; n < 132; ++n) {
            stringArray[n] = "spr" + n;
        }
        return stringArray;
    }

    @Override
    protected void readHighwordRegisters(DataEntry dataEntry, Map<String, Number> map) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in PPC64 ELF dump");
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }
}

