/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.structure.MM_HeapRegionDescriptor;
import java.io.PrintStream;

public class DumpAllRegionsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static String[] regionTypesString = new String[(int)MM_HeapRegionDescriptor.RegionType.LAST_REGION_TYPE];

    public DumpAllRegionsCommand() {
        this.initializeRegionTypes();
        this.addCommand("dumpallregions", "cmd|help", "dump all regions in the GC");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (0 != stringArray.length) {
            object = stringArray[0];
            if (((String)object).equalsIgnoreCase("help")) {
                this.help(printStream);
                return;
            }
            bl2 = bl = ((String)object).equalsIgnoreCase("stats");
        }
        try {
            int n;
            Object object2;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            object = GCHeapRegionIterator.from();
            int[] nArray = new int[regionTypesString.length];
            int n2 = 0;
            this.initializeStats(nArray);
            if (J9BuildFlags.env_data64) {
                string6 = "+----------------+----------------+----------------+----------------+--------+----------------+----------------------\n";
                string5 = "|    region      |     start      |      end       |    subspace    | flags  |      size      |      region type     \n";
                string4 = "+----------------+----------------+----------------+----------------+--------+----------------+----------------------\n";
                string3 = " %016x %016x %016x %016x %08x %16x %s\n";
                string2 = "+----------------+----------------+----------------+----------------+--------+----------------+----------------------\n";
            } else {
                string6 = "+--------+--------+--------+--------+--------+--------+----------------------\n";
                string5 = "| region | start  |  end   |subspace| flags  |  size  |      region type     \n";
                string4 = "+--------+--------+--------+--------+--------+--------+----------------------\n";
                string3 = " %08x %08x %08x %08x %08x %8x %s\n";
                string2 = "+--------+--------+--------+--------+--------+--------+----------------------\n";
            }
            if (!bl2) {
                printStream.append(string6);
                printStream.append(string5);
                printStream.append(string4);
            }
            while (((GCHeapRegionIterator)object).hasNext()) {
                String string7;
                object2 = ((GCHeapRegionIterator)object).next();
                n = (int)((GCHeapRegionDescriptor)object2).getRegionType();
                ++n2;
                if (n < regionTypesString.length) {
                    string7 = regionTypesString[n];
                    int n3 = n;
                    nArray[n3] = nArray[n3] + 1;
                } else {
                    string7 = "Unknown";
                }
                if (bl2) continue;
                printStream.append(String.format(string3, ((GCHeapRegionDescriptor)object2).getHeapRegionDescriptorPointer().getAddress(), ((GCHeapRegionDescriptor)object2).getLowAddress().getAddress(), ((GCHeapRegionDescriptor)object2).getHighAddress().getAddress(), ((GCHeapRegionDescriptor)object2).getSubSpace().getAddress(), ((GCHeapRegionDescriptor)object2).getTypeFlags().longValue(), ((GCHeapRegionDescriptor)object2).getSize().longValue(), string7));
            }
            if (!bl2) {
                printStream.append(string2);
            }
            if (bl) {
                object2 = " \t%s: %d\n";
                for (n = 0; n < regionTypesString.length; ++n) {
                    if (0 == nArray[n]) continue;
                    printStream.append(String.format((String)object2, regionTypesString[n], nArray[n]));
                }
                printStream.append(String.format((String)object2, "++++ TOTAL", n2));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void initializeStats(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
    }

    private void initializeRegionTypes() {
        for (int i = 0; i < regionTypesString.length; ++i) {
            DumpAllRegionsCommand.regionTypesString[i] = "Unknown";
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.RESERVED] = "RESERVED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.FREE] = "FREE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.SEGREGATED_SMALL] = "SEGREGATED_SMALL";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.SEGREGATED_LARGE] = "SEGREGATED_LARGE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ARRAYLET_LEAF] = "ARRAYLET_LEAF";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ADDRESS_ORDERED] = "ADDRESS_ORDERED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ADDRESS_ORDERED_IDLE] = "ADDRESS_ORDERED_IDLE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.ADDRESS_ORDERED_MARKED] = "ADDRESS_ORDERED_MARKED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.BUMP_ALLOCATED] = "BUMP_ALLOCATED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.BUMP_ALLOCATED_IDLE] = "BUMP_ALLOCATED_IDLE";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        try {
            DumpAllRegionsCommand.regionTypesString[(int)MM_HeapRegionDescriptor.RegionType.BUMP_ALLOCATED_MARKED] = "BUMP_ALLOCATED_MARKED";
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }

    private void help(PrintStream printStream) {
        printStream.append("!dumpallregions       -- dump all regions");
        printStream.append(nl);
        printStream.append("!dumpallregions stats -- calculate regions stats");
        printStream.append(nl);
    }
}

