/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.elf.unwind.CIE;
import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.stream.ImageInputStream;

public class FDE {
    private final Unwind unwind;
    CIE cie;
    private long pcBegin;
    private long pcBeginAddress;
    private long pcRange;
    private byte[] callFrameInstructions;
    long startPos;
    long length;

    public FDE(Unwind unwind, ImageInputStream imageInputStream, CIE cIE, long l, long l2) throws IOException, CorruptDataException {
        this.unwind = unwind;
        if (cIE == null) {
            throw new CorruptDataException("An FDE record must have a parent CIE");
        }
        this.cie = cIE;
        this.startPos = l;
        this.length = l2;
        this.pcBegin = 0L;
        this.pcRange = 0L;
        this.pcBegin = this.unwind.readEncodedPC(imageInputStream, cIE.fdePointerEncoding);
        this.pcRange = this.unwind.readEncodedPC(imageInputStream, cIE.fdePointerEncoding);
        this.pcBeginAddress = l + 8L;
        if (cIE.augmentationStr.startsWith("z")) {
            long l3 = Unwind.readUnsignedLEB128(imageInputStream);
            byte[] byArray = new byte[(int)l3];
            imageInputStream.read(byArray, 0, byArray.length);
        }
        this.callFrameInstructions = new byte[(int)(l2 - (imageInputStream.getStreamPosition() - l))];
        imageInputStream.read(this.callFrameInstructions, 0, this.callFrameInstructions.length);
        int n = (int)(imageInputStream.getStreamPosition() % (long)this.unwind.process.bytesPerPointer());
        imageInputStream.read(new byte[n], 0, n);
    }

    public boolean contains(long l) throws CorruptDataException, IOException {
        long l2 = this.getBaseAddress();
        long l3 = l2 + this.pcRange;
        return l >= l2 && l <= l3;
    }

    public long getBaseAddress() throws IOException {
        long l = 0L;
        if ((this.cie.fdePointerEncoding & 0x10) == 0) {
            l = this.pcBegin;
        } else if ((this.cie.fdePointerEncoding & 0x10) == 16) {
            l = this.pcBeginAddress + this.pcBegin;
        } else {
            throw new IOException(String.format("Unsupported address modifier 0x%x", this.cie.fdePointerEncoding));
        }
        return l;
    }

    public void dump(PrintStream printStream) throws IOException {
        printStream.printf("Position 0x%x, length 0x%x, CIE ptr 0x%x\n", this.startPos, this.length, 0);
        printStream.printf("\tpcStart 0x%x...0x%x\n", this.pcBegin, this.pcBegin + this.pcRange);
        printStream.printf("\t(pcStart 0x%x...0x%x)\n", this.getBaseAddress(), this.getBaseAddress() + this.pcRange);
        UnwindTable.dumpInstructions(printStream, this.callFrameInstructions, this.cie);
        printStream.println();
    }

    public CIE getCIE() {
        return this.cie;
    }

    public byte[] getCallFrameInstructions() {
        return this.callFrameInstructions;
    }
}

