/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCMarkMap;
import com.ibm.j9ddr.vm29.j9.gc.GCMarkMapStandard;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapMapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_IncrementalGenerationalGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MarkMapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_ParallelGlobalGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SegregatedGCPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.MM_HeapMap;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;

public abstract class GCHeapMap {
    public static final long J9BITS_BITS_IN_SLOT = (long)UDATA.SIZEOF * 8L;
    public static final long BITS_IN_BYTES = 8L;
    public static final UDATA J9MODRON_HEAP_SLOTS_PER_HEAPMAP_SLOT = new UDATA(MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * J9BITS_BITS_IN_SLOT);
    public static final UDATA J9MODRON_HEAP_BYTES_PER_HEAPMAP_BIT = new UDATA(MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * (long)UDATA.SIZEOF);
    public static final UDATA J9MODRON_HEAP_BYTES_PER_HEAPMAP_BYTE = J9MODRON_HEAP_BYTES_PER_HEAPMAP_BIT.mult(8L);
    public static final UDATA J9MODRON_HEAP_BYTES_PER_HEAPMAP_SLOT = J9MODRON_HEAP_BYTES_PER_HEAPMAP_BYTE.mult(UDATA.SIZEOF);
    protected MM_HeapMapPointer _heapMap;
    protected VoidPointer _heapBase;
    protected VoidPointer _heapTop;
    protected UDATAPointer _heapMapBits;
    protected UDATA _maxOffset;
    protected UDATA _heapMapIndexShift;
    protected UDATA _heapMapBitMask;
    protected UDATA _heapMapBitShift;

    public static GCHeapMap from() throws CorruptDataException {
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
        if (GCExtensions.isStandardGC()) {
            if (!GCExtensions.isSegregatedHeap()) {
                MM_ParallelGlobalGCPointer mM_ParallelGlobalGCPointer = MM_ParallelGlobalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
                MM_MarkMapPointer mM_MarkMapPointer = mM_ParallelGlobalGCPointer._markingScheme()._markMap();
                return new GCMarkMapStandard(mM_MarkMapPointer);
            }
            MM_SegregatedGCPointer mM_SegregatedGCPointer = MM_SegregatedGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
            MM_MarkMapPointer mM_MarkMapPointer = mM_SegregatedGCPointer._markingScheme()._markMap();
            return new GCMarkMap(mM_MarkMapPointer);
        }
        if (GCExtensions.isVLHGC()) {
            MM_IncrementalGenerationalGCPointer mM_IncrementalGenerationalGCPointer = MM_IncrementalGenerationalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
            MM_MarkMapPointer mM_MarkMapPointer = mM_IncrementalGenerationalGCPointer._markMapManager()._previousMarkMap();
            return new GCMarkMap(mM_MarkMapPointer);
        }
        if (GCExtensions.isMetronomeGC()) {
            MM_MarkMapPointer mM_MarkMapPointer = mM_GCExtensionsPointer.realtimeGC()._markingScheme()._markMap();
            return new GCMarkMap(mM_MarkMapPointer);
        }
        throw new UnsupportedOperationException("GC policy not supported");
    }

    public static GCHeapMap fromHeapMap(MM_HeapMapPointer mM_HeapMapPointer) throws CorruptDataException {
        if (GCExtensions.isStandardGC()) {
            if (!GCExtensions.isSegregatedHeap()) {
                return new GCMarkMapStandard(mM_HeapMapPointer);
            }
            return new GCMarkMap(mM_HeapMapPointer);
        }
        if (GCExtensions.isVLHGC() || GCExtensions.isMetronomeGC()) {
            return new GCMarkMap(mM_HeapMapPointer);
        }
        throw new UnsupportedOperationException("GC policy not supported");
    }

    public GCHeapMap(MM_HeapMapPointer mM_HeapMapPointer) throws CorruptDataException {
        this._heapMap = mM_HeapMapPointer;
        this._heapBase = mM_HeapMapPointer._heapBase();
        this._heapTop = mM_HeapMapPointer._heapTop();
        this._heapMapBits = mM_HeapMapPointer._heapMapBits();
        this._maxOffset = UDATA.cast(this._heapTop).sub(UDATA.cast(this._heapBase));
        try {
            this._heapMapIndexShift = mM_HeapMapPointer._heapMapIndexShift();
            this._heapMapBitMask = mM_HeapMapPointer._heapMapBitMask();
            this._heapMapBitShift = mM_HeapMapPointer._heapMapBitShift();
        }
        catch (NoSuchFieldError noSuchFieldError) {
            if (!GCExtensions.isMetronomeGC()) {
                this._heapMapIndexShift = new UDATA(MM_HeapMap.J9MODRON_HEAPMAP_INDEX_SHIFT);
                this._heapMapBitMask = new UDATA(MM_HeapMap.J9MODRON_HEAPMAP_BIT_MASK);
                this._heapMapBitShift = new UDATA(MM_HeapMap.J9MODRON_HEAPMAP_BIT_SHIFT);
            }
            this._heapMapIndexShift = new UDATA(MM_HeapMap.J9MODRON_HEAPMAP_LOG_SIZEOF_UDATA + J9Consts.J9VMGC_SIZECLASSES_LOG_SMALLEST);
            this._heapMapBitMask = new UDATA(1L).leftShift(this._heapMapIndexShift).sub(1L);
            this._heapMapBitShift = new UDATA(J9Consts.J9VMGC_SIZECLASSES_LOG_SMALLEST);
        }
    }

    public MM_HeapMapPointer getHeapMap() {
        return this._heapMap;
    }

    public VoidPointer getHeapBase() {
        return this._heapBase;
    }

    public UDATAPointer getHeapMapBits() {
        return this._heapMapBits;
    }

    public VoidPointer getHeapTop() {
        return this._heapTop;
    }

    public int getObjectGrain() {
        return 1 << this._heapMapBitShift.intValue();
    }

    public int getPageSize(J9ObjectPointer j9ObjectPointer) {
        return this.getObjectGrain() * 8 * UDATA.SIZEOF;
    }

    public UDATA[] getSlotIndexAndMask(J9ObjectPointer j9ObjectPointer) {
        UDATA uDATA = UDATA.cast(j9ObjectPointer).sub(UDATA.cast(this._heapBase));
        if (uDATA.gte(this._maxOffset)) {
            throw new IllegalArgumentException("Object is not in heap: " + j9ObjectPointer);
        }
        UDATA uDATA2 = uDATA.bitAnd(this._heapMapBitMask);
        uDATA2 = uDATA2.rightShift(this._heapMapBitShift);
        UDATA uDATA3 = new UDATA(1L).leftShift(uDATA2);
        UDATA uDATA4 = uDATA.rightShift(new UDATA(this._heapMapIndexShift));
        UDATA[] uDATAArray = new UDATA[]{uDATA4, uDATA3};
        return uDATAArray;
    }

    public boolean isBitSet(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (j9ObjectPointer.gte(this._heapTop) || j9ObjectPointer.lt(this._heapBase)) {
            throw new IllegalArgumentException("Pointer outside of the committed heap");
        }
        return this.isBitSetNoCheck(j9ObjectPointer);
    }

    public boolean isMarked(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (j9ObjectPointer.gte(this._heapTop) || j9ObjectPointer.lt(this._heapBase)) {
            return true;
        }
        return this.isBitSetNoCheck(j9ObjectPointer);
    }

    protected boolean isBitSetNoCheck(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA[] uDATAArray = this.getSlotIndexAndMask(j9ObjectPointer);
        boolean bl = this._heapMapBits.add(uDATAArray[0]).at(0L).bitAnd(uDATAArray[1]).gt(0);
        return bl;
    }

    public MarkedObject queryObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        MarkedObject[] markedObjectArray = this.queryRange(j9ObjectPointer, j9ObjectPointer.addOffset(this.getObjectGrain()));
        if (markedObjectArray.length > 0 && markedObjectArray[0].object.eq(j9ObjectPointer)) {
            return markedObjectArray[0];
        }
        return null;
    }

    public MarkedObject[] queryRange(J9ObjectPointer j9ObjectPointer, J9ObjectPointer j9ObjectPointer2) throws CorruptDataException {
        ArrayList<MarkedObject> arrayList = new ArrayList<MarkedObject>();
        if (j9ObjectPointer.lt(this._heapBase)) {
            j9ObjectPointer = J9ObjectPointer.cast(this._heapBase);
        }
        if (j9ObjectPointer2.gt(this._heapTop)) {
            j9ObjectPointer2 = J9ObjectPointer.cast(this._heapTop);
        }
        if (j9ObjectPointer.gt(j9ObjectPointer2)) {
            j9ObjectPointer = j9ObjectPointer2;
        }
        J9ObjectPointer j9ObjectPointer3 = j9ObjectPointer;
        while (j9ObjectPointer3.lt(j9ObjectPointer2)) {
            UDATA[] uDATAArray = this.getSlotIndexAndMask(j9ObjectPointer3);
            UDATAPointer uDATAPointer = this._heapMapBits.add(uDATAArray[0]);
            if (uDATAPointer.at(0L).bitAnd(uDATAArray[1]).gt(0)) {
                arrayList.add(new MarkedObject(j9ObjectPointer3, uDATAPointer));
            }
            j9ObjectPointer3 = j9ObjectPointer3.addOffset(this.getObjectGrain());
        }
        return arrayList.toArray(new MarkedObject[arrayList.size()]);
    }

    public static class MarkedObject {
        public final J9ObjectPointer object;
        public final UDATAPointer markBitsSlot;
        public final J9ObjectPointer relocatedObject;

        public MarkedObject(J9ObjectPointer j9ObjectPointer, UDATAPointer uDATAPointer) {
            this(j9ObjectPointer, uDATAPointer, null);
        }

        public MarkedObject(J9ObjectPointer j9ObjectPointer, UDATAPointer uDATAPointer, J9ObjectPointer j9ObjectPointer2) {
            this.object = j9ObjectPointer;
            this.markBitsSlot = uDATAPointer;
            this.relocatedObject = j9ObjectPointer2;
        }

        public boolean wasRelocated() {
            return this.relocatedObject != null;
        }
    }
}

