/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.types.U32;
import java.util.Iterator;

public class ConstantPoolHelpers {
    private static J9ObjectFieldOffset vmRefOffset = null;

    private ConstantPoolHelpers() {
    }

    public static UDATAPointer J9_AFTER_CLASS(J9ClassPointer j9ClassPointer) {
        return UDATAPointer.cast(j9ClassPointer.add(1L));
    }

    public static J9ConstantPoolPointer J9_CP_FROM_METHOD(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        return j9MethodPointer.constantPool().untag(J9Consts.J9_STARTPC_STATUS);
    }

    public static J9ConstantPoolPointer J9_CP_FROM_CLASS(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ConstantPoolPointer.cast(j9ClassPointer.ramMethods().add(j9ClassPointer.romClass().romMethodCount()));
    }

    public static J9ClassPointer J9_CLASS_FROM_CP(J9ConstantPoolPointer j9ConstantPoolPointer) throws CorruptDataException {
        return j9ConstantPoolPointer.ramClass();
    }

    public static J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        return ConstantPoolHelpers.J9_CLASS_FROM_CP(ConstantPoolHelpers.J9_CP_FROM_METHOD(j9MethodPointer));
    }

    public static J9ROMConstantPoolItemPointer J9_ROM_CP_FROM_CP(J9ConstantPoolPointer j9ConstantPoolPointer) throws CorruptDataException {
        return j9ConstantPoolPointer.romConstantPool();
    }

    public static J9ROMConstantPoolItemPointer J9_ROM_CP_FROM_ROM_CLASS(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return J9ROMConstantPoolItemPointer.cast(j9ROMClassPointer.add(1L));
    }

    public static boolean J9_IS_CLASS_OBSOLETE(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        if (J9BuildFlags.interp_hotCodeReplacement) {
            return J9ClassHelper.isSwappedOut(j9ClassPointer);
        }
        return false;
    }

    public static J9ClassPointer J9_CURRENT_CLASS(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        if (ConstantPoolHelpers.J9_IS_CLASS_OBSOLETE(j9ClassPointer)) {
            return j9ClassPointer.arrayClass();
        }
        return j9ClassPointer;
    }

    public static J9ClassPointer J9VM_J9CLASS_FROM_HEAPCLASS(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (j9ObjectPointer.isNull()) {
            return J9ClassPointer.NULL;
        }
        if (vmRefOffset == null) {
            Iterator<J9ObjectFieldOffset> iterator = J9ClassHelper.getFieldOffsets(J9ObjectHelper.clazz(j9ObjectPointer));
            while (iterator.hasNext()) {
                J9ObjectFieldOffset j9ObjectFieldOffset;
                J9ObjectFieldOffset j9ObjectFieldOffset2 = iterator.next();
                if (!(j9ObjectFieldOffset2 instanceof J9ObjectFieldOffset) || !"vmRef".equals((j9ObjectFieldOffset = j9ObjectFieldOffset2).getName())) continue;
                vmRefOffset = j9ObjectFieldOffset;
                break;
            }
        }
        if (vmRefOffset != null) {
            long l = J9ObjectHelper.getLongField(j9ObjectPointer, vmRefOffset);
            return J9ClassPointer.cast(l);
        }
        throw new CorruptDataException("Unable to find field offset for the 'vmRef' field");
    }

    public static J9ObjectPointer J9VM_J9CLASS_TO_HEAPCLASS(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        if (j9ClassPointer.isNull()) {
            return J9ObjectPointer.NULL;
        }
        return J9ObjectPointer.cast(j9ClassPointer.classObject());
    }

    public static long J9_CP_TYPE(U32Pointer u32Pointer, int n) throws CorruptDataException {
        U32 u32 = u32Pointer.at((long)n / J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32);
        long l = u32.rightShift((int)((long)n % J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 * J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION)).bitAnd(J9ConstantPool.J9_CP_DESCRIPTION_MASK).longValue();
        return l;
    }
}

