/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class LittleEndianDumpReader
extends DumpReader {
    public LittleEndianDumpReader(ImageInputStream imageInputStream, boolean bl) {
        super(imageInputStream, bl);
    }

    @Override
    public short readShort() throws IOException {
        return this.byteSwap(super.readShort());
    }

    @Override
    public int readInt() throws IOException {
        return this.byteSwap(super.readInt());
    }

    @Override
    public long readLong() throws IOException {
        return this.byteSwap(super.readLong());
    }

    private short byteSwap(short s) {
        return (short)(s >> 8 & 0xFF | s << 8 & 0xFF00);
    }

    private int byteSwap(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    private long byteSwap(long l) {
        return l >> 56 & 0xFFL | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L | l << 56 & 0xFF00000000000000L;
    }
}

