/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.Connections;
import com.sun.jndi.ldap.pool.ConnectionsRef;
import com.sun.jndi.ldap.pool.ConnectionsWeakRef;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NamingException;

public final class Pool {
    static final boolean debug = LdapPoolManager.debug;
    private static final ReferenceQueue<ConnectionsRef> queue = new ReferenceQueue();
    private static final Collection<Reference<ConnectionsRef>> weakRefs = Collections.synchronizedList(new LinkedList());
    private final int maxSize;
    private final int prefSize;
    private final int initSize;
    private final Map<Object, ConnectionsRef> map = new WeakHashMap<Object, ConnectionsRef>();

    public Pool(int n, int n2, int n3) {
        this.prefSize = n2;
        this.maxSize = n3;
        this.initSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(Object object, long l, PooledConnectionFactory pooledConnectionFactory) throws NamingException {
        Object object2;
        this.d("get(): ", object);
        if (debug) {
            object2 = this.map;
            synchronized (object2) {
                this.d("size: ", this.map.size());
            }
        }
        Pool.expungeStaleConnections();
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            object2 = this.getConnections(object);
            if (object2 == null) {
                this.d("get(): creating new connections list for ", object);
                object2 = new Connections(object, this.initSize, this.prefSize, this.maxSize, pooledConnectionFactory);
                ConnectionsRef connectionsRef = new ConnectionsRef((Connections)object2);
                this.map.put(object, connectionsRef);
                ConnectionsWeakRef connectionsWeakRef = new ConnectionsWeakRef(connectionsRef, queue);
                weakRefs.add(connectionsWeakRef);
            }
            this.d("get(): size after: ", this.map.size());
        }
        return ((Connections)object2).get(l, pooledConnectionFactory);
    }

    private Connections getConnections(Object object) {
        ConnectionsRef connectionsRef = this.map.get(object);
        return connectionsRef != null ? connectionsRef.getConnections() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(long l) {
        ArrayList<ConnectionsRef> arrayList;
        Object object = this.map;
        synchronized (object) {
            arrayList = new ArrayList<ConnectionsRef>(this.map.values());
        }
        object = new ArrayList();
        for (ConnectionsRef connectionsRef : arrayList) {
            Connections connections = connectionsRef.getConnections();
            if (!connections.expire(l)) continue;
            this.d("expire(): removing ", connections);
            ((ArrayList)object).add(connectionsRef);
        }
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            this.map.values().removeAll((Collection<?>)object);
        }
        Pool.expungeStaleConnections();
    }

    private static void expungeStaleConnections() {
        ConnectionsWeakRef connectionsWeakRef = null;
        while ((connectionsWeakRef = (ConnectionsWeakRef)queue.poll()) != null) {
            Connections connections = connectionsWeakRef.getConnections();
            if (debug) {
                System.err.println("weak reference cleanup: Closing Connections:" + connections);
            }
            connections.close();
            weakRefs.remove(connectionsWeakRef);
            connectionsWeakRef.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showStats(PrintStream printStream) {
        printStream.println("===== Pool start ======================");
        printStream.println("maximum pool size: " + this.maxSize);
        printStream.println("preferred pool size: " + this.prefSize);
        printStream.println("initial pool size: " + this.initSize);
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            printStream.println("current pool size: " + this.map.size());
            for (Map.Entry<Object, ConnectionsRef> entry : this.map.entrySet()) {
                Object object = entry.getKey();
                Connections connections = entry.getValue().getConnections();
                printStream.println("   " + object + ":" + connections.getStats());
            }
        }
        printStream.println("====== Pool end =====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            return super.toString() + " " + this.map.toString();
        }
    }

    private void d(String string, int n) {
        if (debug) {
            System.err.println(this + "." + string + n);
        }
    }

    private void d(String string, Object object) {
        if (debug) {
            System.err.println(this + "." + string + object);
        }
    }
}

