/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpAllClassesInModuleCommand
extends Command {
    public DumpAllClassesInModuleCommand() {
        this.addCommand("dumpallclassesinmodule", "<moduleAddress>", "dump all loaded classes in the target module");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            CommandUtils.dbgPrint(printStream, "Usage: !dumpallclassesinmodule <moduleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
                String string2 = stringArray[0];
                J9ModulePointer j9ModulePointer = J9ModulePointer.cast(Long.decode(string2));
                J9ClassLoaderPointer j9ClassLoaderPointer = j9ModulePointer.classLoader();
                Iterator<J9ClassPointer> iterator = ClassIterator.fromJ9Classloader(j9ClassLoaderPointer);
                J9ClassPointer j9ClassPointer = null;
                int n = 0;
                PatternString patternString = new PatternString(string2);
                while (iterator.hasNext()) {
                    j9ClassPointer = iterator.next();
                    String string3 = j9ClassPointer.module().getHexAddress();
                    if (!patternString.isMatch(string3)) continue;
                    String string4 = J9ClassHelper.getName(j9ClassPointer);
                    String string5 = j9ClassPointer.getHexAddress();
                    ++n;
                    printStream.printf("%-30s !j9class %s%n", string4, string5);
                }
                printStream.printf("Found %d loaded classes in !j9module %s\n", n, string2);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

