/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsahpTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transition32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transition64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transitionTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexcibTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexcibhTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdsaf;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhcom32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhcom64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexhcomTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexhepvTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhp1bTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexoepvTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexpp1bTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexrcb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexrcb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexrcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexsfxmTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Function;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DsaStackFrame {
    private long address;
    private boolean isDownStack;
    private boolean isParentDownStack;
    private boolean isParentTransitionFrame;
    private long parentAddress;
    private long parentCallingAddress;
    private DsaStackFrame childDsa;
    private RegisterSet registers;
    private long entryPoint;
    private long entryOffset;
    private String entryName = "(unknown)";
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Caa caa;
    CeedsahpTemplate ceedsahpTemplate;
    Ceedsahp_transitionTemplate ceedsahp_transitionTemplate;
    CeexhcomTemplate ceexhcomTemplate;
    CeexrcbTemplate ceexrcbTemplate;
    static final long Ceedsahp_UpTran_Ind = 0xFFFFFFFFL;
    private static final long Ceedsahp_UpToDown = 2L;
    private static final long Ceedsahp_DownToUp = 3L;
    private static final long Hpcl_Basr_Call = 0L;
    private static final long Hpcl_Bras_Call = 1L;
    private static final long Hpcl_Brasl_Call = 3L;
    private static final int US_FORMAT = 0;
    private static final int DS_FORMAT = 1;
    private static final int UK_FORMAT = -1;
    private static final int CEEEYECAT = 0xC3C5C5;
    private static final short BASSM1415 = 3311;
    private static final int L14DSAMODE = 1491128428;
    private static final boolean lenient = true;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public DsaStackFrame(long l, boolean bl, RegisterSet registerSet, AddressSpace addressSpace, Caa caa) throws IOException {
        this.address = l;
        this.isDownStack = bl;
        this.registers = registerSet;
        this.space = addressSpace;
        this.inputStream = addressSpace.getImageInputStream();
        this.caa = caa;
        this.createTemplates(addressSpace);
        this.ceextbck(l, bl, caa);
    }

    public boolean isDownStack() {
        return this.isDownStack;
    }

    void createTemplates(AddressSpace addressSpace) {
        if (this.caa.is64bit()) {
            this.ceedsahpTemplate = new Ceedsahp64Template();
            this.ceedsahp_transitionTemplate = new Ceedsahp_transition64Template();
            this.ceexhcomTemplate = new Ceexhcom64Template();
            this.ceexrcbTemplate = new Ceexrcb64Template();
        } else {
            this.ceedsahpTemplate = new Ceedsahp32Template();
            this.ceedsahp_transitionTemplate = new Ceedsahp_transition32Template();
            this.ceexhcomTemplate = new Ceexhcom32Template();
            this.ceexrcbTemplate = new Ceexrcb32Template();
        }
    }

    public AddressSpace getAddressSpace() {
        return this.space;
    }

    public long getDsaAddress() {
        return this.address;
    }

    public RegisterSet getRegisterSet() {
        return this.registers;
    }

    public long getEntryOffset() {
        if (this.registers != null) {
            return this.stripTopBit(this.registers.getPSW() & Integer.MAX_VALUE) - this.getEntryPoint();
        }
        if (this.childDsa != null) {
            return this.childDsa.parentCallingAddress - this.entryPoint;
        }
        return this.entryOffset;
    }

    public long getEntryPoint() {
        return this.entryPoint;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public DsaStackFrame getParentFrame() {
        log.finer("for " + DsaStackFrame.hex(this.address) + " parent is " + DsaStackFrame.hex(this.parentAddress));
        if (this.parentAddress == 0L || this.parentAddress == this.caa.ceecaaddsa() || this.parentAddress == this.address) {
            return null;
        }
        try {
            DsaStackFrame dsaStackFrame = new DsaStackFrame(this.parentAddress, this.isParentDownStack, null, this.space, this.caa);
            dsaStackFrame.childDsa = this;
            return dsaStackFrame;
        }
        catch (IOException iOException) {
            log.logp(Level.FINER, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame", "getParentFrame", "Caught IOException", iOException);
            return null;
        }
    }

    public Function getFunction() {
        return new Function(this);
    }

    long stripTopBit(long l) {
        return this.caa.is64bit() ? l : l & Integer.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ceextbck(long l, boolean bl, Caa caa) throws IOException {
        int n;
        int n2;
        int n3;
        boolean bl2;
        log.fine("ceextbck, dsaptr = " + DsaStackFrame.hex(l) + " downstack = " + bl);
        int n4 = bl ? 1 : 0;
        long l2 = -4995072469322842385L;
        int n5 = n4;
        if (n4 == -1) {
            throw new Error("tbc");
        }
        int n6 = n5;
        boolean bl3 = this.verifyFormat(l, n4);
        Ceexdsaf ceexdsaf = new Ceexdsaf(this.space, l, n4, caa.is64bit());
        n6 = ceexdsaf.DSA_Format;
        long l3 = ceexdsaf.DSA_Prev;
        log.fine("callers_dsaptr = " + DsaStackFrame.hex(l3) + " transition = " + (bl3 ? "true" : " false"));
        this.parentAddress = l3;
        this.isParentDownStack = n6 == 1;
        long l4 = this.findCib(l);
        long l5 = this.findCib(l3);
        long l6 = this.findSfxm(l, n5);
        long l7 = this.findSfxm(l3, n6);
        if (n5 == 1) {
            this.processDsfmt(l, n5, l3, n6, bl3, l4, l5, l6);
            return;
        }
        if (!bl3) {
            int n7 = this.space.readInt(l + 72L);
            if ((n7 & 0xFFFFFFF0) == 134794976) {
                throw new Error("tbc");
            }
            l2 = this.stripTopBit(CeedsaTemplate.getCeedsar15(this.inputStream, l3));
            log.fine("upstack entry address = " + DsaStackFrame.hex(l2));
        } else {
            long l8 = CeedsaTemplate.getCeedsatran(this.inputStream, l);
            l2 = this.stripTopBit(this.ceedsahp_transitionTemplate.getCeedsahp_tran_ep(this.inputStream, l8));
            log.fine("upstack transition entry address = " + DsaStackFrame.hex(l2));
        }
        try {
            this.space.readLong(l2);
        }
        catch (IOException iOException) {
            log.fine("can't read entry address so reset to zero");
            l2 = 0L;
        }
        long l9 = l2;
        if (l2 == 0L) {
            bl2 = false;
        } else {
            n3 = 0;
            try {
                n3 = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, l9);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.fine("signature = " + DsaStackFrame.hex(n3));
            n2 = n3 >>> 24;
            if ((n2 == 0 || n2 == 1) && (n3 & 0xFFFFFF) == 0xC3C5C5) {
                try {
                    n3 = this.getPpa1Sig(l9);
                }
                catch (IOException iOException) {
                    n3 = 0;
                }
                bl2 = (n3 & 0xFF) == 206;
            } else {
                bl2 = false;
                try {
                    n3 = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, l9);
                    log.fine("oldep signature = " + DsaStackFrame.hex(n3));
                    int n8 = n3 >>> 12;
                    if (n8 == 294671) {
                        n = n3 & 0xFFF;
                        int n9 = CeexoepvTemplate.length();
                        assert (n9 == 20) : n9;
                        n3 = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, l9 = l9 + (long)n - (long)n9);
                        if (n3 == 0) {
                            n3 = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, l9);
                            if ((n3 & 0xFFFFFF) == 0xC3C5C5) {
                                n3 = this.getPpa1Sig(l9);
                                if ((n3 & 0xFF) != 206) throw new Error("tbc");
                                bl2 = true;
                                log.fine("found a good ppa1 eyecatcher");
                            } else {
                                l9 = l2;
                            }
                        } else {
                            l9 = l2;
                        }
                    } else {
                        l9 = l2;
                    }
                }
                catch (IOException iOException) {
                    log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame", "ceextbck", "Unexpected IOException", iOException);
                    throw new Error("Unexpected IOException: " + iOException);
                }
            }
        }
        n3 = 0;
        if (bl2 && (n2 = (int)CeexoepvTemplate.getOepv_cnameoffs(this.inputStream, l9)) == 1) {
            n3 = 1;
        }
        long l10 = this.getCallingAddr(l3, n6, l, n5, bl3, l5, l7);
        log.fine("callers address is " + DsaStackFrame.hex(l10));
        this.parentCallingAddress = l10;
        if (bl2) {
            if (this.registers != null) {
                long l11 = this.getCallingAddr(l, n5, 0L, 0, false, l4, l6);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(l11));
            }
            if ((n = this.getPpa1Nmo(l9)) == 0) {
                throw new Error("tbc");
            }
            int n10 = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, l9);
            long l12 = l9 + (long)n10;
            long l13 = n3 != 0 ? l12 + (long)(n * 2) : l12 + (long)n;
            this.entryName = this.space.readEbcdicString(l13);
            if (!Function.isValidName(this.entryName)) {
                this.entryName = "(bad name)";
            }
            log.fine("read entry name: " + this.entryName);
        } else {
            this.entryName = "(unknown)";
        }
        this.entryPoint = l2;
    }

    void processDsfmt(long l, int n, long l2, int n2, boolean bl, long l3, long l4, long l5) throws IOException {
        Ceexepaf ceexepaf = new Ceexepaf(l, n);
        this.entryPoint = ceexepaf.entry_address;
        if (ceexepaf.ppa1_addr != 0L) {
            long l6;
            if (this.registers != null) {
                l6 = this.getCallingAddr(l, n, 0L, 0, false, l3, 0L);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(l6));
            }
            l6 = this.getCallingAddr(l2, n2, l, n, bl, l4, l5);
            log.fine("got call addr " + DsaStackFrame.hex(l6));
            this.parentCallingAddress = l6;
            Ceexppaf ceexppaf = new Ceexppaf(ceexepaf.ppa1_addr, "NAM");
            if (ceexppaf.opt_ptr != 0L) {
                this.entryName = this.space.readEbcdicString(ceexppaf.opt_ptr);
                if (!Function.isValidName(this.entryName)) {
                    this.entryName = "(bad name)";
                }
            }
            log.fine("read entry name: " + this.entryName);
        } else {
            this.entryPoint = 0L;
        }
    }

    private int getPpa1Sig(long l) throws IOException {
        int n = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, l);
        long l2 = l + (long)n;
        int n2 = (int)Ceexpp1bTemplate.getPpa1_sig(this.inputStream, l2);
        log.fine("read ppa1 signature " + DsaStackFrame.hex(n2) + " from entry point " + DsaStackFrame.hex(l));
        return n2;
    }

    private int getPpa1Nmo(long l) throws IOException {
        int n = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, l);
        long l2 = l + (long)n;
        int n2 = (int)Ceexpp1bTemplate.getPpa1_nmo(this.inputStream, l2);
        log.fine("read ppa1 nmo " + DsaStackFrame.hex(n2 &= 0xFF) + " from entry point " + DsaStackFrame.hex(l));
        return n2;
    }

    boolean verifyFormat(long l, int n) throws IOException {
        if (n == 0) {
            long l2 = CeedsaTemplate.getCeedsabkc(this.inputStream, l);
            log.fine("read ceedsabkc " + DsaStackFrame.hex(l2));
            if (l2 == 0xFFFFFFFFL) {
                long l3 = CeedsaTemplate.getCeedsatran(this.inputStream, l);
                log.fine("read ceedsatran " + DsaStackFrame.hex(l3));
                long l4 = this.ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, l3);
                if (l4 > 0L && l4 <= 6L) {
                    return true;
                }
            }
        } else if (n == 1) {
            long l5 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, l);
            log.fine("read ceedsahpr7 " + DsaStackFrame.hex(l5));
            if (l5 == 0L) {
                long l6 = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, l);
                log.fine("read ceedsahptran " + DsaStackFrame.hex(l6));
                long l7 = this.ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, l6);
                log.fine("read ceedsahp_trtype " + DsaStackFrame.hex(l7));
                if (l7 > 0L && l7 <= 6L) {
                    return true;
                }
            }
        }
        return false;
    }

    long getCallingAddr(long l, int n, long l2, int n2, boolean bl, long l3, long l4) throws IOException {
        long l5;
        block30: {
            log.fine("try to get calling address for " + DsaStackFrame.hex(l) + " in_dsafmt " + n + " in_cib " + DsaStackFrame.hex(l3) + " in_sfxm " + DsaStackFrame.hex(l4));
            l5 = -4995072469322842385L;
            long l6 = 0L;
            if (l3 != 0L) {
                l5 = CeexcibTemplate.getCib_int(this.inputStream, l3);
                log.fine("got calling address " + DsaStackFrame.hex(l5) + " from cib");
            } else {
                long l7;
                if (l4 != 0L) {
                    l6 = n == 0 ? CeexsfxmTemplate.getSfxm_save_r14(this.inputStream, l4) : CeexsfxmTemplate.getSfxm_save_r7(this.inputStream, l4);
                } else if (n == 0) {
                    l6 = CeedsaTemplate.getCeedsar14(this.inputStream, l);
                } else if (l2 == 0L) {
                    log.fine("no callee dsa");
                } else if (n2 == 0 && bl) {
                    l7 = CeedsaTemplate.getCeedsatran(this.inputStream, l2);
                    l6 = this.ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, l7);
                    log.fine("up transition, ceedsatran = " + DsaStackFrame.hex(l7));
                } else if (n2 == 1 && bl) {
                    l7 = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, l2);
                    l6 = this.ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, l7);
                    log.fine("down transition");
                } else {
                    l6 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, l2);
                    log.fine("not a transition");
                }
                log.fine("next_instruction_address = " + DsaStackFrame.hex(l6));
                if (l6 != 0L) {
                    if (!this.caa.is64bit()) {
                        l6 = n == 0 && (l6 & Integer.MIN_VALUE) == 0L ? (l6 &= 0xFFFFFFL) : (l6 &= Integer.MAX_VALUE);
                    }
                    if (n == 0) {
                        if (l6 == this.caa.getEdb().ceeedb_ceeosigr()) {
                            throw new Error("tbc");
                        }
                        try {
                            int n3;
                            short s = this.space.readShort(l6 - 2L);
                            if (s == 3311 && (n3 = this.space.readInt(l6)) == 1491128428) {
                                l6 = CeedsaTemplate.getCeedsamode(this.inputStream, l);
                                if (!this.caa.is64bit()) {
                                    l6 = (l6 & Integer.MIN_VALUE) == 0L ? (l6 &= 0xFFFFFFL) : (l6 &= Integer.MAX_VALUE);
                                }
                            }
                            n3 = 0;
                            int n4 = this.space.readInt(l6);
                            if (n4 >>> 16 == 18176) {
                                n3 = 1;
                            }
                            l5 = l6 - 2L;
                            log.fine("found callingaddr = 0x" + DsaStackFrame.hex(l5));
                        }
                        catch (IOException iOException) {
                            log.fine("could not read next_instruction_address at " + DsaStackFrame.hex(l6));
                            l5 = l6 - 2L;
                        }
                    } else {
                        log.fine("downstack nsi adjust");
                        l7 = this.caa.ceecaarcb();
                        long l8 = this.ceexrcbTemplate.getCeercb_ceeosigx(this.inputStream, l7);
                        if (l6 == l8) {
                            throw new Error("tbc");
                        }
                        try {
                            int n5 = this.space.readInt(l6);
                            int n6 = n5 >> 16 & 0xF;
                            if (n5 >>> 20 != (this.caa.is64bit() ? 112 : 1136)) {
                                l5 = 0L;
                                log.fine("did not find expected nop");
                                break block30;
                            }
                            if ((long)n6 == 0L) {
                                l5 = l6 - 2L;
                                break block30;
                            }
                            if ((long)n6 == 1L) {
                                l5 = l6 - 4L;
                                break block30;
                            }
                            if ((long)n6 == 3L) {
                                l5 = l6 - 6L;
                                break block30;
                            }
                            l5 = 0L;
                            log.fine("did not recognize call type " + n6);
                        }
                        catch (IOException iOException) {
                            log.fine("caught exception: " + iOException);
                            l5 = 0L;
                        }
                    }
                } else {
                    log.fine("next_instruction_address zero, cannot get calling address");
                }
            }
        }
        return l5;
    }

    long findCib(long l) {
        try {
            long l2 = 0L;
            long l3 = this.caa.ceecaaerrcm();
            long l4 = this.ceexhcomTemplate.getHcom_cibh(this.inputStream, l3);
            long l5 = 0L;
            int n = 0;
            while (l4 != 0L && l4 != l5 && n++ < 256) {
                boolean bl = CeexcibhTemplate.getCibh_in_use(this.inputStream, l4) != 0L;
                l2 = CeexcibhTemplate.getCibh_ptr_cib(this.inputStream, l4);
                long l6 = CeexcibTemplate.getCib_sv1(this.inputStream, l2);
                if (bl && l6 == l) break;
                l5 = l4;
                l4 = CeexcibhTemplate.getCibh_back(this.inputStream, l4);
            }
            if (l4 == 0L || l4 == l5 || n >= 256) {
                return 0L;
            }
            log.fine("found a cib: " + DsaStackFrame.hex(l2));
            return l2;
        }
        catch (Exception exception) {
            log.fine("problem with cib: " + exception);
            return 0L;
        }
    }

    long findSfxm(long l, int n) throws IOException {
        long l2;
        block11: {
            l2 = 0L;
            try {
                if (n == 0) {
                    log.fine("findSfxm processing upstack dsa");
                    long l3 = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                    log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(l3));
                    long l4 = l3;
                    while (l4 != 0L) {
                        long l5;
                        long l6;
                        long l7 = CeexsfxmTemplate.getSfxm_code_eyecatch(this.inputStream, l4);
                        if (l7 >>> 8 != 214408072578304L && (l6 = CeedsaTemplate.getCeedsabkc(this.inputStream, l5 = CeexsfxmTemplate.getSfxm_parm_sf(this.inputStream, l4))) == l) {
                            log.fine("found the upstack sfxm at " + DsaStackFrame.hex(l4));
                            l2 = l4;
                        }
                        l4 = CeexsfxmTemplate.getSfxm_next(this.inputStream, l4);
                    }
                    break block11;
                }
                log.fine("findSfxm processing downstack dsa");
                long l8 = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(l8));
                int n2 = CeexsfxmTemplate.getSfxm_code_return_pt$offset();
                long l9 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, l);
                l9 = this.stripTopBit(l9);
                long l10 = l8;
                while (l10 != 0L) {
                    if (l10 + (long)n2 == l9) {
                        long l11 = CeexsfxmTemplate.getSfxm_next(this.inputStream, l10);
                        while (l11 + (long)n2 == CeexsfxmTemplate.getSfxm_save_r7(this.inputStream, l10)) {
                            l10 = l11;
                            l11 = CeexsfxmTemplate.getSfxm_next(this.inputStream, l10);
                        }
                        log.fine("found the downstack sfxm at " + DsaStackFrame.hex(l10));
                        l2 = l10;
                        break;
                    }
                    try {
                        l10 = CeexsfxmTemplate.getSfxm_next(this.inputStream, l10);
                    }
                    catch (IOException iOException) {
                        log.fine("bad tptr: " + DsaStackFrame.hex(l10));
                        l10 = 0L;
                    }
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new Error("oops: " + exception);
            }
        }
        return l2;
    }

    static long hpclEntryPoint(AddressSpace addressSpace, long l, long l2, CeedsahpTemplate ceedsahpTemplate) throws Exception {
        long l3;
        log.fine("ceedsahpr7: " + DsaStackFrame.hex(l2));
        AddressSpaceImageInputStream addressSpaceImageInputStream = addressSpace.getImageInputStream();
        int n = addressSpace.readInt(l2) >> 16 & 0xF;
        if ((long)n == 0L) {
            l3 = ceedsahpTemplate.getCeedsahpr6(addressSpaceImageInputStream, l);
            log.fine("BASR 7,6: " + DsaStackFrame.hex(l3));
        } else if ((long)n == 1L) {
            short s = addressSpace.readShort(l2 - 2L);
            log.fine("offset: " + DsaStackFrame.hex(s));
            l3 = l2 - 4L + (long)(s * 2);
            log.fine("BRAS 7,xxx: " + DsaStackFrame.hex(l3) + (l3 < 0L ? " (neg)" : "") + " offset = " + s);
        } else if ((long)n == 3L) {
            int n2 = addressSpace.readInt(l2 - 4L);
            l3 = l2 - 6L + (long)(n2 * 2);
            log.fine("BRASL 7,xxx: " + DsaStackFrame.hex(l3));
        } else {
            return 0L;
        }
        if (addressSpace.readInt(l3 - 16L) != 12779717) {
            l3 = 0L;
        }
        return l3;
    }

    public static String getEntryPointName(AddressSpace addressSpace, long l) throws IOException {
        return DsaStackFrame.getEntryPointName(addressSpace, l, false);
    }

    public static String getEntryPointName(AddressSpace addressSpace, long l, boolean bl) throws IOException {
        String string;
        ObjectMap objectMap = (ObjectMap)addressSpace.getUserMap().get("function_map");
        if (objectMap == null) {
            objectMap = new ObjectMap();
            addressSpace.getUserMap().put("function_map", objectMap);
        }
        if ((string = (String)objectMap.get(l)) == null) {
            if (bl) {
                long l2 = l + 4L & (addressSpace.is64bit() ? -4L : 0x7FFFFFFCL);
                for (int i = 0; i < 4096 && string == null; ++i) {
                    try {
                        string = DsaStackFrame.getName(addressSpace, l2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    l2 -= 4L;
                }
            } else {
                string = DsaStackFrame.getName(addressSpace, l);
                if (string == null) {
                    string = "(unknown)";
                }
            }
            string = string != null ? string.trim() : "";
            objectMap.put(l, string);
        }
        return string.length() == 0 ? null : string;
    }

    private static String getName(AddressSpace addressSpace, long l) throws IOException {
        String string = null;
        int n = addressSpace.readInt(l + 4L);
        if (n == 0xC3C5C5 || n == 29607365) {
            long l2 = l + (long)addressSpace.readInt(l + 12L);
            int n2 = addressSpace.readUnsignedByte(l2);
            if (n == 29607365) {
                n2 <<= 1;
            }
            string = addressSpace.readEbcdicString(l2 + (long)n2);
        } else if ((n & 0xFF0000) == 0xCE0000) {
            long l3 = l;
            int n3 = n >>> 24;
            string = addressSpace.readEbcdicString(l3 + (long)n3);
        } else if ((addressSpace.readInt(l) & 0xFFFFF000) == 1206972416) {
            int n4 = addressSpace.readUnsignedByte(l + 4L);
            string = addressSpace.readEbcdicString(l + 5L, n4);
        } else if (n == -775298074) {
            long l4 = addressSpace.readWord(l + 8L);
            String string2 = addressSpace.readAsciiString(addressSpace.readWord(l4));
            String string3 = addressSpace.readAsciiString(addressSpace.readWord(l4 + (long)addressSpace.getWordLength()));
            string = string2 + "." + string3;
        } else {
            long l5 = l - 16L;
            long l6 = addressSpace.readLong(l5);
            if (l6 == 54888466580046065L) {
                int n5;
                int n6 = addressSpace.readInt(l5 + 8L);
                long l7 = l5 + (long)n6;
                long l8 = l7 + 20L;
                int n7 = addressSpace.readUnsignedByte(l7 + 10L);
                int n8 = addressSpace.readUnsignedByte(l7 + 11L);
                if ((n7 & 0x80) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 0x40) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 0x20) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 0x10) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 8) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 4) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 2) != 0) {
                    l8 += 4L;
                }
                if ((n7 & 1) != 0) {
                    l8 += 8L;
                }
                if ((n8 & 1) != 0 && (n5 = addressSpace.readUnsignedShort(l8)) > 0 && n5 < 1000) {
                    string = addressSpace.readEbcdicString(l8 + 2L, n5);
                }
            }
        }
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c <= '~') continue;
                string = null;
                break;
            }
        }
        return string;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    class Ceexppaf {
        long opt_ptr;

        Ceexppaf(long l, String string) throws IOException {
            block15: {
                try {
                    int n = Ceexhp1bTemplate.length();
                    assert (n == 20) : n;
                    this.opt_ptr = l + (long)n;
                    if (string.equals("NAM")) {
                        long l2 = DsaStackFrame.this.caa.ceecaarcb();
                        log.fine("ceecaarcb = " + DsaStackFrame.hex(l2));
                        long l3 = DsaStackFrame.this.stripTopBit(DsaStackFrame.this.ceexrcbTemplate.getCeercb_ppa1tabl(DsaStackFrame.this.inputStream, l2));
                        log.fine("tabl_ptr = " + DsaStackFrame.hex(l3));
                        long l4 = Ceexhp1bTemplate.getPpa1h_flag3(DsaStackFrame.this.inputStream, l);
                        log.fine("ppa1h_flag3 = " + DsaStackFrame.hex(l4));
                        try {
                            int n2 = DsaStackFrame.this.space.readUnsignedByte(l3 + (l4 & 0xFFL));
                            this.opt_ptr += (long)n2;
                            log.fine("found offset of " + n2 + ", opt_ptr now " + DsaStackFrame.hex(this.opt_ptr));
                        }
                        catch (Exception exception) {
                            if ((l4 & 0x80L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 0x40L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 0x20L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 0x10L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 8L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 4L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 2L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((l4 & 1L) != 0L) {
                                this.opt_ptr += 8L;
                            }
                            break block15;
                        }
                    }
                    throw new Error("unsupported option: " + string);
                }
                catch (IOException iOException) {
                    log.fine("got exception: " + iOException);
                    this.opt_ptr = 0L;
                }
                catch (Exception exception) {
                    log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame.Ceexppaf", "Ceexppaf", "Unexpected Exception", exception);
                    throw new Error("Unexpected Exception: " + exception);
                }
            }
        }
    }

    class Ceexepaf {
        long ppa1_addr;
        long ppa2_addr;
        long entry_address;

        Ceexepaf(long l, int n) throws IOException {
            try {
                long l2 = DsaStackFrame.this.stripTopBit(DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr7(DsaStackFrame.this.inputStream, l));
                this.entry_address = l2 == 0L ? DsaStackFrame.this.stripTopBit(DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr6(DsaStackFrame.this.inputStream, l)) : DsaStackFrame.this.stripTopBit(DsaStackFrame.hpclEntryPoint(DsaStackFrame.this.space, l, l2, DsaStackFrame.this.ceedsahpTemplate));
                log.fine("read entry_address 0x" + DsaStackFrame.hex(this.entry_address));
                int n2 = CeexhepvTemplate.getHepv_entry_point$offset();
                long l3 = this.entry_address - (long)n2;
                long l4 = CeexhepvTemplate.getHepv_ppa1_offset_p(DsaStackFrame.this.inputStream, l3);
                this.ppa1_addr = l3 + l4;
                log.fine("ppa1 = 0x" + DsaStackFrame.hex(this.ppa1_addr));
                long l5 = Ceexhp1bTemplate.getPpa1h_ppa2_off(DsaStackFrame.this.inputStream, this.ppa1_addr);
                this.ppa2_addr = this.ppa1_addr + l5;
                log.fine("ppa2 = 0x" + DsaStackFrame.hex(this.ppa2_addr));
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame.Ceexepaf", "Ceexepaf", "Unexpected Exception", exception);
                throw new Error("Unexpected Exception: " + exception);
            }
        }
    }
}

