/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.KeyUsage;
import sun.security.krb5.internal.crypto.dk.DkCrypto;
import sun.security.provider.MD4;

public class ArcFourCrypto
extends DkCrypto {
    private static final boolean debug = false;
    private static final int confounderSize = 8;
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int hashSize = 16;
    private final int keyLength;

    public ArcFourCrypto(int n) {
        this.keyLength = n;
    }

    @Override
    protected int getKeySeedLength() {
        return this.keyLength;
    }

    @Override
    protected byte[] randomToKey(byte[] byArray) {
        return byArray;
    }

    public byte[] stringToKey(char[] cArray) throws GeneralSecurityException {
        return this.stringToKey(cArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] stringToKey(char[] cArray, byte[] byArray) throws GeneralSecurityException {
        if (byArray != null && byArray.length > 0) {
            throw new RuntimeException("Invalid parameter to stringToKey");
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = ArcFourCrypto.charToUtf16(cArray);
            MessageDigest messageDigest = MD4.getInstance();
            messageDigest.update(byArray2);
            byArray3 = messageDigest.digest();
        }
        catch (Exception exception) {
            byte[] byArray4 = null;
            return byArray4;
        }
        finally {
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
        return byArray3;
    }

    @Override
    protected Cipher getCipher(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        if (byArray2 == null) {
            byArray2 = ZERO_IV;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "ARCFOUR");
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 0, byArray2.length);
        cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    @Override
    public int getChecksumLength() {
        return 16;
    }

    @Override
    protected byte[] getHmac(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(secretKeySpec);
        byte[] byArray3 = mac.doFinal(byArray2);
        return byArray3;
    }

    @Override
    public byte[] calculateChecksum(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws GeneralSecurityException {
        Object object;
        byte[] byArray3;
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = null;
        try {
            byArray3 = "signaturekey".getBytes();
            object = new byte[byArray3.length + 1];
            System.arraycopy((Object)byArray3, 0, object, 0, byArray3.length);
            byArray4 = this.getHmac(byArray, (byte[])object);
        }
        catch (Exception exception) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Calculate Checkum Failed!");
            generalSecurityException.initCause(exception);
            throw generalSecurityException;
        }
        byArray3 = this.getSalt(n);
        object = null;
        try {
            object = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("Calculate Checkum Failed!");
            generalSecurityException.initCause(noSuchAlgorithmException);
            throw generalSecurityException;
        }
        ((MessageDigest)object).update(byArray3);
        ((MessageDigest)object).update(byArray2, n2, n3);
        byte[] byArray5 = ((MessageDigest)object).digest();
        byte[] byArray6 = this.getHmac(byArray4, byArray5);
        if (byArray6.length == this.getChecksumLength()) {
            return byArray6;
        }
        if (byArray6.length > this.getChecksumLength()) {
            byte[] byArray7 = new byte[this.getChecksumLength()];
            System.arraycopy((Object)byArray6, 0, (Object)byArray7, 0, byArray7.length);
            return byArray7;
        }
        throw new GeneralSecurityException("checksum size too short: " + byArray6.length + "; expecting : " + this.getChecksumLength());
    }

    public byte[] encryptSeq(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = this.getHmac(byArray, byArray4);
        byArray5 = this.getHmac(byArray5, byArray2);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, "ARCFOUR");
        cipher.init(1, secretKeySpec);
        byte[] byArray6 = cipher.doFinal(byArray3, n2, n3);
        return byArray6;
    }

    public byte[] decryptSeq(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = this.getHmac(byArray, byArray4);
        byArray5 = this.getHmac(byArray5, byArray2);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, "ARCFOUR");
        cipher.init(2, secretKeySpec);
        byte[] byArray6 = cipher.doFinal(byArray3, n2, n3);
        return byArray6;
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray5 = Confounder.bytes(8);
        int n4 = this.roundup(byArray5.length + n3, 1);
        byte[] byArray6 = new byte[n4];
        System.arraycopy((Object)byArray5, 0, (Object)byArray6, 0, byArray5.length);
        System.arraycopy((Object)byArray4, n2, (Object)byArray6, byArray5.length, n3);
        byte[] byArray7 = new byte[byArray.length];
        System.arraycopy((Object)byArray, 0, (Object)byArray7, 0, byArray.length);
        byte[] byArray8 = this.getSalt(n);
        byte[] byArray9 = this.getHmac(byArray7, byArray8);
        byte[] byArray10 = this.getHmac(byArray9, byArray6);
        byte[] byArray11 = this.getHmac(byArray9, byArray10);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray11, "ARCFOUR");
        cipher.init(1, secretKeySpec);
        byte[] byArray12 = cipher.doFinal(byArray6, 0, byArray6.length);
        byte[] byArray13 = new byte[16 + byArray12.length];
        System.arraycopy((Object)byArray10, 0, (Object)byArray13, 0, 16);
        System.arraycopy((Object)byArray12, 0, (Object)byArray13, 16, byArray12.length);
        return byArray13;
    }

    @Override
    public byte[] encryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = new byte[byArray.length];
        for (int i = 0; i <= 15; ++i) {
            byArray4[i] = (byte)(byArray[i] ^ 0xF0);
        }
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = this.getHmac(byArray4, byArray5);
        byArray6 = this.getHmac(byArray6, byArray2);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray6, "ARCFOUR");
        cipher.init(1, secretKeySpec);
        byte[] byArray7 = cipher.doFinal(byArray3, n2, n3);
        return byArray7;
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray4 = new byte[byArray.length];
        System.arraycopy((Object)byArray, 0, (Object)byArray4, 0, byArray.length);
        byte[] byArray5 = this.getSalt(n);
        byte[] byArray6 = this.getHmac(byArray4, byArray5);
        byte[] byArray7 = new byte[16];
        System.arraycopy((Object)byArray3, n2, (Object)byArray7, 0, 16);
        byte[] byArray8 = this.getHmac(byArray6, byArray7);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray8, "ARCFOUR");
        cipher.init(2, secretKeySpec);
        byte[] byArray9 = cipher.doFinal(byArray3, n2 + 16, n3 - 16);
        byte[] byArray10 = this.getHmac(byArray6, byArray9);
        boolean bl = false;
        if (byArray10.length >= 16) {
            for (int i = 0; i < 16; ++i) {
                if (byArray10[i] == byArray3[i]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            throw new GeneralSecurityException("Checksum failed");
        }
        byte[] byArray11 = new byte[byArray9.length - 8];
        System.arraycopy((Object)byArray9, 8, (Object)byArray11, 0, byArray11.length);
        return byArray11;
    }

    public byte[] decryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3, byte[] byArray4) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray5 = new byte[byArray.length];
        for (int i = 0; i <= 15; ++i) {
            byArray5[i] = (byte)(byArray[i] ^ 0xF0);
        }
        byte[] byArray6 = new byte[4];
        byte[] byArray7 = this.getHmac(byArray5, byArray6);
        byte[] byArray8 = new byte[4];
        System.arraycopy((Object)byArray4, 0, (Object)byArray8, 0, byArray8.length);
        byArray7 = this.getHmac(byArray7, byArray8);
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray7, "ARCFOUR");
        cipher.init(2, secretKeySpec);
        byte[] byArray9 = cipher.doFinal(byArray3, n2, n3);
        return byArray9;
    }

    private byte[] getSalt(int n) {
        int n2 = this.arcfour_translate_usage(n);
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        return byArray;
    }

    private int arcfour_translate_usage(int n) {
        switch (n) {
            case 3: {
                return 8;
            }
            case 9: {
                return 8;
            }
            case 23: {
                return 13;
            }
        }
        return n;
    }
}

