/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsahpTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transition32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transition64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transitionTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexcibTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexcibhTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdsaf;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhcom32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhcom64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexhcomTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexhepvTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhp1bTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexoepvTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexpp1bTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexrcb32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexrcb64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexrcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexsfxmTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Function;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DsaStackFrame {
    private long address;
    private boolean isDownStack;
    private boolean isParentDownStack;
    private boolean isParentTransitionFrame;
    private long parentAddress;
    private long parentCallingAddress;
    private DsaStackFrame childDsa;
    private RegisterSet registers;
    private long entryPoint;
    private long entryOffset;
    private String entryName = "(unknown)";
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Caa caa;
    CeedsahpTemplate ceedsahpTemplate;
    Ceedsahp_transitionTemplate ceedsahp_transitionTemplate;
    CeexhcomTemplate ceexhcomTemplate;
    CeexrcbTemplate ceexrcbTemplate;
    static final long Ceedsahp_UpTran_Ind = 0xFFFFFFFFL;
    private static final long Ceedsahp_UpToDown = 2L;
    private static final long Ceedsahp_DownToUp = 3L;
    private static final long Hpcl_Basr_Call = 0L;
    private static final long Hpcl_Bras_Call = 1L;
    private static final long Hpcl_Brasl_Call = 3L;
    private static final int US_FORMAT = 0;
    private static final int DS_FORMAT = 1;
    private static final int UK_FORMAT = -1;
    private static final int CEEEYECAT = 0xC3C5C5;
    private static final short BASSM1415 = 3311;
    private static final int L14DSAMODE = 1491128428;
    private static final boolean lenient = true;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public DsaStackFrame(long address, boolean isDownStack, RegisterSet registers, AddressSpace space, Caa caa) throws IOException {
        this.address = address;
        this.isDownStack = isDownStack;
        this.registers = registers;
        this.space = space;
        this.inputStream = space.getImageInputStream();
        this.caa = caa;
        this.createTemplates(space);
        this.ceextbck(address, isDownStack, caa);
    }

    public boolean isDownStack() {
        return this.isDownStack;
    }

    void createTemplates(AddressSpace space) {
        if (this.caa.is64bit()) {
            this.ceedsahpTemplate = new Ceedsahp64Template();
            this.ceedsahp_transitionTemplate = new Ceedsahp_transition64Template();
            this.ceexhcomTemplate = new Ceexhcom64Template();
            this.ceexrcbTemplate = new Ceexrcb64Template();
        } else {
            this.ceedsahpTemplate = new Ceedsahp32Template();
            this.ceedsahp_transitionTemplate = new Ceedsahp_transition32Template();
            this.ceexhcomTemplate = new Ceexhcom32Template();
            this.ceexrcbTemplate = new Ceexrcb32Template();
        }
    }

    public AddressSpace getAddressSpace() {
        return this.space;
    }

    public long getDsaAddress() {
        return this.address;
    }

    public RegisterSet getRegisterSet() {
        return this.registers;
    }

    public long getEntryOffset() {
        if (this.registers != null) {
            return this.stripTopBit(this.registers.getPSW() & Integer.MAX_VALUE) - this.getEntryPoint();
        }
        if (this.childDsa != null) {
            return this.childDsa.parentCallingAddress - this.entryPoint;
        }
        return this.entryOffset;
    }

    public long getEntryPoint() {
        return this.entryPoint;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public DsaStackFrame getParentFrame() {
        log.finer("for " + DsaStackFrame.hex(this.address) + " parent is " + DsaStackFrame.hex(this.parentAddress));
        if (this.parentAddress == 0L || this.parentAddress == this.caa.ceecaaddsa() || this.parentAddress == this.address) {
            return null;
        }
        try {
            DsaStackFrame parent = new DsaStackFrame(this.parentAddress, this.isParentDownStack, null, this.space, this.caa);
            parent.childDsa = this;
            return parent;
        }
        catch (IOException e) {
            log.logp(Level.FINER, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame", "getParentFrame", "Caught IOException", e);
            return null;
        }
    }

    public Function getFunction() {
        return new Function(this);
    }

    long stripTopBit(long address) {
        return this.caa.is64bit() ? address : address & Integer.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void ceextbck(long dsaptr, boolean isDownStack, Caa caa) throws IOException {
        int oepv_cnameoffs;
        boolean cel_enabled;
        log.fine("ceextbck, dsaptr = " + DsaStackFrame.hex(dsaptr) + " downstack = " + isDownStack);
        int dsa_format = isDownStack ? 1 : 0;
        long entry_address = -4995072469322842385L;
        int dsaformat8 = dsa_format;
        if (dsa_format == -1) {
            throw new Error("tbc");
        }
        int callers_dsa_format = dsaformat8;
        boolean transition = this.verifyFormat(dsaptr, dsa_format);
        Ceexdsaf dsaf = new Ceexdsaf(this.space, dsaptr, dsa_format, caa.is64bit());
        callers_dsa_format = dsaf.DSA_Format;
        long callers_dsaptr = dsaf.DSA_Prev;
        log.fine("callers_dsaptr = " + DsaStackFrame.hex(callers_dsaptr) + " transition = " + (transition ? "true" : " false"));
        this.parentAddress = callers_dsaptr;
        this.isParentDownStack = callers_dsa_format == 1;
        long cibptr = this.findCib(dsaptr);
        long callers_cibptr = this.findCib(callers_dsaptr);
        long sfxmptr = this.findSfxm(dsaptr, dsaformat8);
        long callers_sfxmptr = this.findSfxm(callers_dsaptr, callers_dsa_format);
        if (dsaformat8 == 1) {
            this.processDsfmt(dsaptr, dsaformat8, callers_dsaptr, callers_dsa_format, transition, cibptr, callers_cibptr, sfxmptr);
            return;
        }
        if (!transition) {
            int hdsp_signature = this.space.readInt(dsaptr + 72L);
            if ((hdsp_signature & 0xFFFFFFF0) == 134794976) {
                throw new Error("tbc");
            }
            entry_address = this.stripTopBit(CeedsaTemplate.getCeedsar15(this.inputStream, callers_dsaptr));
            log.fine("upstack entry address = " + DsaStackFrame.hex(entry_address));
        } else {
            long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, dsaptr);
            entry_address = this.stripTopBit(this.ceedsahp_transitionTemplate.getCeedsahp_tran_ep(this.inputStream, ceedsatran));
            log.fine("upstack transition entry address = " + DsaStackFrame.hex(entry_address));
        }
        try {
            this.space.readLong(entry_address);
        }
        catch (IOException e) {
            log.fine("can't read entry address so reset to zero");
            entry_address = 0L;
        }
        long signaturePtr = entry_address;
        if (entry_address == 0L) {
            cel_enabled = false;
        } else {
            int signature = 0;
            try {
                signature = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, signaturePtr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            log.fine("signature = " + DsaStackFrame.hex(signature));
            int msb = signature >>> 24;
            if ((msb == 0 || msb == 1) && (signature & 0xFFFFFF) == 0xC3C5C5) {
                try {
                    signature = this.getPpa1Sig(signaturePtr);
                }
                catch (IOException e) {
                    signature = 0;
                }
                cel_enabled = (signature & 0xFF) == 206;
            } else {
                cel_enabled = false;
                try {
                    signature = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, signaturePtr);
                    log.fine("oldep signature = " + DsaStackFrame.hex(signature));
                    int bcrinstr = signature >>> 12;
                    if (bcrinstr == 294671) {
                        int bcrdispl = signature & 0xFFF;
                        int oepvLength = CeexoepvTemplate.length();
                        assert (oepvLength == 20) : oepvLength;
                        signature = (int)CeexoepvTemplate.getOepv_oldep(this.inputStream, signaturePtr = signaturePtr + (long)bcrdispl - (long)oepvLength);
                        if (signature == 0) {
                            signature = (int)CeexoepvTemplate.getOepv_eyecatch(this.inputStream, signaturePtr);
                            if ((signature & 0xFFFFFF) == 0xC3C5C5) {
                                signature = this.getPpa1Sig(signaturePtr);
                                if ((signature & 0xFF) != 206) throw new Error("tbc");
                                cel_enabled = true;
                                log.fine("found a good ppa1 eyecatcher");
                            } else {
                                signaturePtr = entry_address;
                            }
                        } else {
                            signaturePtr = entry_address;
                        }
                    } else {
                        signaturePtr = entry_address;
                    }
                }
                catch (IOException e) {
                    log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame", "ceextbck", "Unexpected IOException", e);
                    throw new Error("Unexpected IOException: " + e);
                }
            }
        }
        boolean v2ppa = false;
        if (cel_enabled && (oepv_cnameoffs = (int)CeexoepvTemplate.getOepv_cnameoffs(this.inputStream, signaturePtr)) == 1) {
            v2ppa = true;
        }
        long callers_instruction_address = this.getCallingAddr(callers_dsaptr, callers_dsa_format, dsaptr, dsaformat8, transition, callers_cibptr, callers_sfxmptr);
        log.fine("callers address is " + DsaStackFrame.hex(callers_instruction_address));
        this.parentCallingAddress = callers_instruction_address;
        if (cel_enabled) {
            int offset_to_name;
            if (this.registers != null) {
                long call_instruction_address = this.getCallingAddr(dsaptr, dsaformat8, 0L, 0, false, cibptr, sfxmptr);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(call_instruction_address));
            }
            if ((offset_to_name = this.getPpa1Nmo(signaturePtr)) == 0) {
                throw new Error("tbc");
            }
            int ppa1offset = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, signaturePtr);
            long ppa1 = signaturePtr + (long)ppa1offset;
            long ppa1_epn_address = v2ppa ? ppa1 + (long)(offset_to_name * 2) : ppa1 + (long)offset_to_name;
            this.entryName = this.space.readEbcdicString(ppa1_epn_address);
            if (!Function.isValidName(this.entryName)) {
                this.entryName = "(bad name)";
            }
            log.fine("read entry name: " + this.entryName);
        } else {
            this.entryName = "(unknown)";
        }
        this.entryPoint = entry_address;
    }

    void processDsfmt(long in_dsa, int in_dsafmt, long in_callerdsa, int in_caller_dsafmt, boolean in_dsatrans, long in_cibptr, long in_caller_cibptr, long in_sfxmptr) throws IOException {
        Ceexepaf epaf = new Ceexepaf(in_dsa, in_dsafmt);
        this.entryPoint = epaf.entry_address;
        if (epaf.ppa1_addr != 0L) {
            if (this.registers != null) {
                long call_instruction_address = this.getCallingAddr(in_dsa, in_dsafmt, 0L, 0, false, in_cibptr, 0L);
                log.fine("found call_instruction_address at top of stack: 0x" + DsaStackFrame.hex(call_instruction_address));
            }
            long callers_instruction_address = this.getCallingAddr(in_callerdsa, in_caller_dsafmt, in_dsa, in_dsafmt, in_dsatrans, in_caller_cibptr, in_sfxmptr);
            log.fine("got call addr " + DsaStackFrame.hex(callers_instruction_address));
            this.parentCallingAddress = callers_instruction_address;
            Ceexppaf ppaf = new Ceexppaf(epaf.ppa1_addr, "NAM");
            if (ppaf.opt_ptr != 0L) {
                this.entryName = this.space.readEbcdicString(ppaf.opt_ptr);
                if (!Function.isValidName(this.entryName)) {
                    this.entryName = "(bad name)";
                }
            }
            log.fine("read entry name: " + this.entryName);
        } else {
            this.entryPoint = 0L;
        }
    }

    private int getPpa1Sig(long signaturePtr) throws IOException {
        int ppa1offset = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, signaturePtr);
        long ppa1 = signaturePtr + (long)ppa1offset;
        int signature = (int)Ceexpp1bTemplate.getPpa1_sig(this.inputStream, ppa1);
        log.fine("read ppa1 signature " + DsaStackFrame.hex(signature) + " from entry point " + DsaStackFrame.hex(signaturePtr));
        return signature;
    }

    private int getPpa1Nmo(long signaturePtr) throws IOException {
        int ppa1offset = (int)CeexoepvTemplate.getOepv_ppa1offset(this.inputStream, signaturePtr);
        long ppa1 = signaturePtr + (long)ppa1offset;
        int nmo = (int)Ceexpp1bTemplate.getPpa1_nmo(this.inputStream, ppa1);
        log.fine("read ppa1 nmo " + DsaStackFrame.hex(nmo &= 0xFF) + " from entry point " + DsaStackFrame.hex(signaturePtr));
        return nmo;
    }

    boolean verifyFormat(long dsaptr, int dsa_format) throws IOException {
        if (dsa_format == 0) {
            long ceedsabkc = CeedsaTemplate.getCeedsabkc(this.inputStream, dsaptr);
            log.fine("read ceedsabkc " + DsaStackFrame.hex(ceedsabkc));
            if (ceedsabkc == 0xFFFFFFFFL) {
                long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, dsaptr);
                log.fine("read ceedsatran " + DsaStackFrame.hex(ceedsatran));
                long ceedsahp_trtype = this.ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsatran);
                if (ceedsahp_trtype > 0L && ceedsahp_trtype <= 6L) {
                    return true;
                }
            }
        } else if (dsa_format == 1) {
            long ceedsahpr7 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, dsaptr);
            log.fine("read ceedsahpr7 " + DsaStackFrame.hex(ceedsahpr7));
            if (ceedsahpr7 == 0L) {
                long ceedsahptran = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, dsaptr);
                log.fine("read ceedsahptran " + DsaStackFrame.hex(ceedsahptran));
                long ceedsahp_trtype = this.ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsahptran);
                log.fine("read ceedsahp_trtype " + DsaStackFrame.hex(ceedsahp_trtype));
                if (ceedsahp_trtype > 0L && ceedsahp_trtype <= 6L) {
                    return true;
                }
            }
        }
        return false;
    }

    long getCallingAddr(long in_dsa, int in_dsafmt, long fo_dsa, int fo_dsafmt, boolean fo_dsatrans, long in_cib, long in_sfxm) throws IOException {
        long callingaddr;
        block30: {
            log.fine("try to get calling address for " + DsaStackFrame.hex(in_dsa) + " in_dsafmt " + in_dsafmt + " in_cib " + DsaStackFrame.hex(in_cib) + " in_sfxm " + DsaStackFrame.hex(in_sfxm));
            callingaddr = -4995072469322842385L;
            long next_instruction_address = 0L;
            if (in_cib != 0L) {
                callingaddr = CeexcibTemplate.getCib_int(this.inputStream, in_cib);
                log.fine("got calling address " + DsaStackFrame.hex(callingaddr) + " from cib");
            } else {
                if (in_sfxm != 0L) {
                    next_instruction_address = in_dsafmt == 0 ? CeexsfxmTemplate.getSfxm_save_r14(this.inputStream, in_sfxm) : CeexsfxmTemplate.getSfxm_save_r7(this.inputStream, in_sfxm);
                } else if (in_dsafmt == 0) {
                    next_instruction_address = CeedsaTemplate.getCeedsar14(this.inputStream, in_dsa);
                } else if (fo_dsa == 0L) {
                    log.fine("no callee dsa");
                } else if (fo_dsafmt == 0 && fo_dsatrans) {
                    long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, fo_dsa);
                    next_instruction_address = this.ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, ceedsatran);
                    log.fine("up transition, ceedsatran = " + DsaStackFrame.hex(ceedsatran));
                } else if (fo_dsafmt == 1 && fo_dsatrans) {
                    long ceedsahptran = this.ceedsahpTemplate.getCeedsahptran(this.inputStream, fo_dsa);
                    next_instruction_address = this.ceedsahp_transitionTemplate.getCeedsahp_retaddr(this.inputStream, ceedsahptran);
                    log.fine("down transition");
                } else {
                    next_instruction_address = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, fo_dsa);
                    log.fine("not a transition");
                }
                log.fine("next_instruction_address = " + DsaStackFrame.hex(next_instruction_address));
                if (next_instruction_address != 0L) {
                    if (!this.caa.is64bit()) {
                        next_instruction_address = in_dsafmt == 0 && (next_instruction_address & Integer.MIN_VALUE) == 0L ? (next_instruction_address &= 0xFFFFFFL) : (next_instruction_address &= Integer.MAX_VALUE);
                    }
                    if (in_dsafmt == 0) {
                        if (next_instruction_address == this.caa.getEdb().ceeedb_ceeosigr()) {
                            throw new Error("tbc");
                        }
                        try {
                            int rx_inst;
                            short rr_inst = this.space.readShort(next_instruction_address - 2L);
                            if (rr_inst == 3311 && (rx_inst = this.space.readInt(next_instruction_address)) == 1491128428) {
                                next_instruction_address = CeedsaTemplate.getCeedsamode(this.inputStream, in_dsa);
                                if (!this.caa.is64bit()) {
                                    next_instruction_address = (next_instruction_address & Integer.MIN_VALUE) == 0L ? (next_instruction_address &= 0xFFFFFFL) : (next_instruction_address &= Integer.MAX_VALUE);
                                }
                            }
                            boolean fstlink_call = false;
                            int rx_inst2 = this.space.readInt(next_instruction_address);
                            if (rx_inst2 >>> 16 == 18176) {
                                fstlink_call = true;
                            }
                            callingaddr = next_instruction_address - 2L;
                            log.fine("found callingaddr = 0x" + DsaStackFrame.hex(callingaddr));
                        }
                        catch (IOException e) {
                            log.fine("could not read next_instruction_address at " + DsaStackFrame.hex(next_instruction_address));
                            callingaddr = next_instruction_address - 2L;
                        }
                    } else {
                        log.fine("downstack nsi adjust");
                        long ceecaarcb = this.caa.ceecaarcb();
                        long ceercb_ceeosigx = this.ceexrcbTemplate.getCeercb_ceeosigx(this.inputStream, ceecaarcb);
                        if (next_instruction_address == ceercb_ceeosigx) {
                            throw new Error("tbc");
                        }
                        try {
                            int rx_inst = this.space.readInt(next_instruction_address);
                            int Hpcl_Call_Type = rx_inst >> 16 & 0xF;
                            if (rx_inst >>> 20 != (this.caa.is64bit() ? 112 : 1136)) {
                                callingaddr = 0L;
                                log.fine("did not find expected nop");
                                break block30;
                            }
                            if ((long)Hpcl_Call_Type == 0L) {
                                callingaddr = next_instruction_address - 2L;
                                break block30;
                            }
                            if ((long)Hpcl_Call_Type == 1L) {
                                callingaddr = next_instruction_address - 4L;
                                break block30;
                            }
                            if ((long)Hpcl_Call_Type == 3L) {
                                callingaddr = next_instruction_address - 6L;
                                break block30;
                            }
                            callingaddr = 0L;
                            log.fine("did not recognize call type " + Hpcl_Call_Type);
                        }
                        catch (IOException e) {
                            log.fine("caught exception: " + e);
                            callingaddr = 0L;
                        }
                    }
                } else {
                    log.fine("next_instruction_address zero, cannot get calling address");
                }
            }
        }
        return callingaddr;
    }

    long findCib(long in_dsa) {
        try {
            long cibh_ptr_cib = 0L;
            long ceecaaerrcm = this.caa.ceecaaerrcm();
            long cibhptr = this.ceexhcomTemplate.getHcom_cibh(this.inputStream, ceecaaerrcm);
            long previous_cibhptr = 0L;
            int cib_count = 0;
            while (cibhptr != 0L && cibhptr != previous_cibhptr && cib_count++ < 256) {
                boolean cibh_in_use = CeexcibhTemplate.getCibh_in_use(this.inputStream, cibhptr) != 0L;
                cibh_ptr_cib = CeexcibhTemplate.getCibh_ptr_cib(this.inputStream, cibhptr);
                long cib_sv1 = CeexcibTemplate.getCib_sv1(this.inputStream, cibh_ptr_cib);
                if (cibh_in_use && cib_sv1 == in_dsa) break;
                previous_cibhptr = cibhptr;
                cibhptr = CeexcibhTemplate.getCibh_back(this.inputStream, cibhptr);
            }
            if (cibhptr == 0L || cibhptr == previous_cibhptr || cib_count >= 256) {
                return 0L;
            }
            log.fine("found a cib: " + DsaStackFrame.hex(cibh_ptr_cib));
            return cibh_ptr_cib;
        }
        catch (Exception e) {
            log.fine("problem with cib: " + e);
            return 0L;
        }
    }

    long findSfxm(long sfxm_dsa, int p_dsafmt) throws IOException {
        long p_sfxm;
        block11: {
            long HEPV_Entry_Sig = 214408072578304L;
            p_sfxm = 0L;
            try {
                if (p_dsafmt == 0) {
                    log.fine("findSfxm processing upstack dsa");
                    long hcom_exit_stk = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                    log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(hcom_exit_stk));
                    long tptr = hcom_exit_stk;
                    while (tptr != 0L) {
                        long sfxm_parm_sf;
                        long ceedsabkc;
                        long sfxm_code_eyecatch = CeexsfxmTemplate.getSfxm_code_eyecatch(this.inputStream, tptr);
                        if (sfxm_code_eyecatch >>> 8 != 214408072578304L && (ceedsabkc = CeedsaTemplate.getCeedsabkc(this.inputStream, sfxm_parm_sf = CeexsfxmTemplate.getSfxm_parm_sf(this.inputStream, tptr))) == sfxm_dsa) {
                            log.fine("found the upstack sfxm at " + DsaStackFrame.hex(tptr));
                            p_sfxm = tptr;
                        }
                        tptr = CeexsfxmTemplate.getSfxm_next(this.inputStream, tptr);
                    }
                    break block11;
                }
                log.fine("findSfxm processing downstack dsa");
                long hcom_exit_stk = this.ceexhcomTemplate.getHcom_exit_stk(this.inputStream, this.caa.ceecaaerrcm());
                log.fine("findSfxm hcom_exit_stk = 0x" + DsaStackFrame.hex(hcom_exit_stk));
                int offset = CeexsfxmTemplate.getSfxm_code_return_pt$offset();
                long ceedsahpr7 = this.ceedsahpTemplate.getCeedsahpr7(this.inputStream, sfxm_dsa);
                ceedsahpr7 = this.stripTopBit(ceedsahpr7);
                long tptr = hcom_exit_stk;
                while (tptr != 0L) {
                    if (tptr + (long)offset == ceedsahpr7) {
                        long next = CeexsfxmTemplate.getSfxm_next(this.inputStream, tptr);
                        while (next + (long)offset == CeexsfxmTemplate.getSfxm_save_r7(this.inputStream, tptr)) {
                            tptr = next;
                            next = CeexsfxmTemplate.getSfxm_next(this.inputStream, tptr);
                        }
                        log.fine("found the downstack sfxm at " + DsaStackFrame.hex(tptr));
                        p_sfxm = tptr;
                        break;
                    }
                    try {
                        tptr = CeexsfxmTemplate.getSfxm_next(this.inputStream, tptr);
                    }
                    catch (IOException e) {
                        log.fine("bad tptr: " + DsaStackFrame.hex(tptr));
                        tptr = 0L;
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("oops: " + e);
            }
        }
        return p_sfxm;
    }

    static long hpclEntryPoint(AddressSpace space, long DSA_In, long ceedsahpr7, CeedsahpTemplate ceedsahpTemplate) throws Exception {
        long Entry_Temp;
        log.fine("ceedsahpr7: " + DsaStackFrame.hex(ceedsahpr7));
        AddressSpaceImageInputStream inputStream = space.getImageInputStream();
        int Hpcl_Call_Type = space.readInt(ceedsahpr7) >> 16 & 0xF;
        if ((long)Hpcl_Call_Type == 0L) {
            Entry_Temp = ceedsahpTemplate.getCeedsahpr6(inputStream, DSA_In);
            log.fine("BASR 7,6: " + DsaStackFrame.hex(Entry_Temp));
        } else if ((long)Hpcl_Call_Type == 1L) {
            short offset = space.readShort(ceedsahpr7 - 2L);
            log.fine("offset: " + DsaStackFrame.hex(offset));
            Entry_Temp = ceedsahpr7 - 4L + (long)(offset * 2);
            log.fine("BRAS 7,xxx: " + DsaStackFrame.hex(Entry_Temp) + (Entry_Temp < 0L ? " (neg)" : "") + " offset = " + offset);
        } else if ((long)Hpcl_Call_Type == 3L) {
            int offset = space.readInt(ceedsahpr7 - 4L);
            Entry_Temp = ceedsahpr7 - 6L + (long)(offset * 2);
            log.fine("BRASL 7,xxx: " + DsaStackFrame.hex(Entry_Temp));
        } else {
            return 0L;
        }
        if (space.readInt(Entry_Temp - 16L) != 12779717) {
            Entry_Temp = 0L;
        }
        return Entry_Temp;
    }

    public static String getEntryPointName(AddressSpace space, long ep) throws IOException {
        return DsaStackFrame.getEntryPointName(space, ep, false);
    }

    public static String getEntryPointName(AddressSpace space, long ep, boolean scan) throws IOException {
        String function;
        ObjectMap map = (ObjectMap)space.getUserMap().get("function_map");
        if (map == null) {
            map = new ObjectMap();
            space.getUserMap().put("function_map", map);
        }
        if ((function = (String)map.get(ep)) == null) {
            if (scan) {
                long address = ep + 4L & (space.is64bit() ? -4L : 0x7FFFFFFCL);
                for (int i = 0; i < 4096 && function == null; ++i) {
                    try {
                        function = DsaStackFrame.getName(space, address);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    address -= 4L;
                }
            } else {
                function = DsaStackFrame.getName(space, ep);
                if (function == null) {
                    function = "(unknown)";
                }
            }
            function = function != null ? function.trim() : "";
            map.put(ep, function);
        }
        return function.length() == 0 ? null : function;
    }

    private static String getName(AddressSpace space, long ep) throws IOException {
        Object function = null;
        int eyecatcher = space.readInt(ep + 4L);
        if (eyecatcher == 0xC3C5C5 || eyecatcher == 29607365) {
            long ppa1 = ep + (long)space.readInt(ep + 12L);
            int offset = space.readUnsignedByte(ppa1);
            if (eyecatcher == 29607365) {
                offset <<= 1;
            }
            function = space.readEbcdicString(ppa1 + (long)offset);
        } else if ((eyecatcher & 0xFF0000) == 0xCE0000) {
            long ppa1 = ep;
            int offset = eyecatcher >>> 24;
            function = space.readEbcdicString(ppa1 + (long)offset);
        } else if ((space.readInt(ep) & 0xFFFFF000) == 1206972416) {
            int length = space.readUnsignedByte(ep + 4L);
            function = space.readEbcdicString(ep + 5L, length);
        } else if (eyecatcher == -775298074) {
            long names = space.readWord(ep + 8L);
            String className = space.readAsciiString(space.readWord(names));
            String methodName = space.readAsciiString(space.readWord(names + (long)space.getWordLength()));
            function = className + "." + methodName;
        } else {
            long xplhdr = ep - 16L;
            long ceesig = space.readLong(xplhdr);
            if (ceesig == 54888466580046065L) {
                int length;
                int ppa1off = space.readInt(xplhdr + 8L);
                long ptrppa1 = xplhdr + (long)ppa1off;
                long ptrnam = ptrppa1 + 20L;
                int ppa1flags3 = space.readUnsignedByte(ptrppa1 + 10L);
                int ppa1flags4 = space.readUnsignedByte(ptrppa1 + 11L);
                if ((ppa1flags3 & 0x80) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 0x40) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 0x20) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 0x10) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 8) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 4) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 2) != 0) {
                    ptrnam += 4L;
                }
                if ((ppa1flags3 & 1) != 0) {
                    ptrnam += 8L;
                }
                if ((ppa1flags4 & 1) != 0 && (length = space.readUnsignedShort(ptrnam)) > 0 && length < 1000) {
                    function = space.readEbcdicString(ptrnam + 2L, length);
                }
            }
        }
        if (function != null) {
            for (int i = 0; i < ((String)function).length(); ++i) {
                char c = ((String)function).charAt(i);
                if (c >= ' ' && c <= '~') continue;
                function = null;
                break;
            }
        }
        return function;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    class Ceexepaf {
        long ppa1_addr;
        long ppa2_addr;
        long entry_address;

        Ceexepaf(long DSA_In, int DSA_Format) throws IOException {
            try {
                long ceedsahpr7 = DsaStackFrame.this.stripTopBit(DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr7(DsaStackFrame.this.inputStream, DSA_In));
                this.entry_address = ceedsahpr7 == 0L ? DsaStackFrame.this.stripTopBit(DsaStackFrame.this.ceedsahpTemplate.getCeedsahpr6(DsaStackFrame.this.inputStream, DSA_In)) : DsaStackFrame.this.stripTopBit(DsaStackFrame.hpclEntryPoint(DsaStackFrame.this.space, DSA_In, ceedsahpr7, DsaStackFrame.this.ceedsahpTemplate));
                log.fine("read entry_address 0x" + DsaStackFrame.hex(this.entry_address));
                int hepv_prefix_length = CeexhepvTemplate.getHepv_entry_point$offset();
                long hepv = this.entry_address - (long)hepv_prefix_length;
                long hepv_ppa1_offset_p = CeexhepvTemplate.getHepv_ppa1_offset_p(DsaStackFrame.this.inputStream, hepv);
                this.ppa1_addr = hepv + hepv_ppa1_offset_p;
                log.fine("ppa1 = 0x" + DsaStackFrame.hex(this.ppa1_addr));
                long ppa1h_ppa2_off = Ceexhp1bTemplate.getPpa1h_ppa2_off(DsaStackFrame.this.inputStream, this.ppa1_addr);
                this.ppa2_addr = this.ppa1_addr + ppa1h_ppa2_off;
                log.fine("ppa2 = 0x" + DsaStackFrame.hex(this.ppa2_addr));
            }
            catch (IOException ceedsahpr7) {
            }
            catch (Exception e) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame.Ceexepaf", "Ceexepaf", "Unexpected Exception", e);
                throw new Error("Unexpected Exception: " + e);
            }
        }
    }

    class Ceexppaf {
        long opt_ptr;

        Ceexppaf(long ppa1_ptr, String opt_nam) throws IOException {
            block15: {
                try {
                    int ppa1h_lgth = Ceexhp1bTemplate.length();
                    assert (ppa1h_lgth == 20) : ppa1h_lgth;
                    this.opt_ptr = ppa1_ptr + (long)ppa1h_lgth;
                    if (opt_nam.equals("NAM")) {
                        long ceecaarcb = DsaStackFrame.this.caa.ceecaarcb();
                        log.fine("ceecaarcb = " + DsaStackFrame.hex(ceecaarcb));
                        long tabl_ptr = DsaStackFrame.this.stripTopBit(DsaStackFrame.this.ceexrcbTemplate.getCeercb_ppa1tabl(DsaStackFrame.this.inputStream, ceecaarcb));
                        log.fine("tabl_ptr = " + DsaStackFrame.hex(tabl_ptr));
                        long ppa1h_flag3 = Ceexhp1bTemplate.getPpa1h_flag3(DsaStackFrame.this.inputStream, ppa1_ptr);
                        log.fine("ppa1h_flag3 = " + DsaStackFrame.hex(ppa1h_flag3));
                        try {
                            int offset = DsaStackFrame.this.space.readUnsignedByte(tabl_ptr + (ppa1h_flag3 & 0xFFL));
                            this.opt_ptr += (long)offset;
                            log.fine("found offset of " + offset + ", opt_ptr now " + DsaStackFrame.hex(this.opt_ptr));
                        }
                        catch (Exception ee) {
                            if ((ppa1h_flag3 & 0x80L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 0x40L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 0x20L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 0x10L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 8L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 4L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 2L) != 0L) {
                                this.opt_ptr += 4L;
                            }
                            if ((ppa1h_flag3 & 1L) != 0L) {
                                this.opt_ptr += 8L;
                            }
                            break block15;
                        }
                    }
                    throw new Error("unsupported option: " + opt_nam);
                }
                catch (IOException e) {
                    log.fine("got exception: " + e);
                    this.opt_ptr = 0L;
                }
                catch (Exception e) {
                    log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame.Ceexppaf", "Ceexppaf", "Unexpected Exception", e);
                    throw new Error("Unexpected Exception: " + e);
                }
            }
        }
    }
}

