/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.j9ddr.libraries.FooterLibraryEntry;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class Footer
implements Serializable {
    private static final long serialVersionUID = -8257413568391677575L;
    private final int version = 1;
    private final FooterLibraryEntry[] entries;
    private int index = 0;
    private ArrayList<String> errorMessages = new ArrayList();

    public Footer(int size) {
        this.entries = new FooterLibraryEntry[size];
    }

    public int getVersion() {
        return 1;
    }

    public void addErrorMessage(String message2) {
        this.errorMessages.add(message2);
    }

    public String[] getErrorMessages() {
        String[] messages = new String[this.errorMessages.size()];
        return this.errorMessages.toArray(messages);
    }

    public void addEntry(String path, int size, long start) {
        int pos = path.lastIndexOf(File.separatorChar);
        String name = pos == -1 ? path : path.substring(pos + 1);
        FooterLibraryEntry entry = new FooterLibraryEntry(path, name, size, start);
        this.entries[this.index++] = entry;
    }

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("Footer : version ");
        data.append(1);
        data.append("\n");
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            data.append(this.entries[i].toString());
        }
        return data.toString();
    }

    public FooterLibraryEntry findEntry(String path) {
        FooterLibraryEntry namematch = null;
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            if (this.entries[i].getPath().equals(path)) {
                return this.entries[i];
            }
            if (!this.entries[i].getName().equals(path)) continue;
            namematch = this.entries[i];
        }
        return namematch;
    }

    public FooterLibraryEntry[] getEntries() {
        return this.entries;
    }
}

