/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.ByteDataWrapperPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ShrOffsetPointer;
import com.ibm.j9ddr.vm29.pointer.helper.SharedClassesMetaDataHelper;
import com.ibm.j9ddr.vm29.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

public class ByteDataWrapperHelper {
    public static I32 BDWEXTBLOCK(ByteDataWrapperPointer ptr, U8Pointer[] cacheHeader) throws CorruptDataException {
        PointerPointer externalBlockOffset = ptr.externalBlockOffsetEA();
        if (null == cacheHeader) {
            return new I32(I32Pointer.cast(externalBlockOffset.getAddress()).at(0L));
        }
        UDATA offset = J9ShrOffsetPointer.cast(externalBlockOffset).offset();
        if (offset.eq(0L)) {
            return new I32(0L);
        }
        return new I32(offset);
    }

    public static U32 BDWLEN(ByteDataWrapperPointer ptr) throws CorruptDataException {
        return new U32(ptr.dataLength());
    }

    public static U8 BDWTYPE(ByteDataWrapperPointer ptr) throws CorruptDataException {
        return ptr.dataType();
    }

    public static U8Pointer getDataFromByteDataWrapper(ByteDataWrapperPointer ptr, U8Pointer[] cacheHeader) throws CorruptDataException {
        PointerPointer externalBlockOffset = ptr.externalBlockOffsetEA();
        if (null == cacheHeader) {
            I32 externalBlockOffsetI32 = I32Pointer.cast(externalBlockOffset.getAddress()).at(0L);
            if (externalBlockOffsetI32.eq(0L)) {
                return U8Pointer.cast(ptr).add(ByteDataWrapper.SIZEOF);
            }
            return U8Pointer.cast(ptr).add(externalBlockOffsetI32);
        }
        J9ShrOffsetPointer j9shrOffset = J9ShrOffsetPointer.cast(externalBlockOffset);
        UDATA offset = j9shrOffset.offset();
        if (offset.eq(0L)) {
            return U8Pointer.cast(ptr).add(ByteDataWrapper.SIZEOF);
        }
        int layer = SharedClassesMetaDataHelper.getCacheLayerFromJ9shrOffset(j9shrOffset);
        return cacheHeader[layer].add(offset);
    }

    public static U8 BDWINPRIVATEUSE(ByteDataWrapperPointer ptr) throws CorruptDataException {
        return ptr.inPrivateUse();
    }

    public static U16 BDWPRIVATEOWNERID(ByteDataWrapperPointer ptr) throws CorruptDataException {
        return ptr.privateOwnerID();
    }

    public static AbstractPointer BDWTOKEN(ByteDataWrapperPointer ptr, U8Pointer[] cacheHeader) throws CorruptDataException {
        PointerPointer tokenOffset = ptr.tokenOffsetEA();
        if (null == cacheHeader) {
            I32 tokenOffsetI32 = I32Pointer.cast(tokenOffset.getAddress()).at(0L);
            if (tokenOffsetI32.eq(0L)) {
                return U8Pointer.NULL;
            }
            return U8Pointer.cast(ptr).add(tokenOffsetI32);
        }
        J9ShrOffsetPointer j9shrOffset = J9ShrOffsetPointer.cast(tokenOffset);
        UDATA offset = j9shrOffset.offset();
        if (offset.eq(0L)) {
            return U8Pointer.NULL;
        }
        int layer = SharedClassesMetaDataHelper.getCacheLayerFromJ9shrOffset(j9shrOffset);
        return cacheHeader[layer].add(offset);
    }
}

