/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import sun.awt.FontConfiguration;
import sun.awt.FontDescriptor;
import sun.awt.SunToolkit;
import sun.awt.X11FontManager;
import sun.font.CompositeFontDescriptor;
import sun.font.FontConfigManager;
import sun.font.FontUtilities;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public class FcFontConfiguration
extends FontConfiguration {
    private static final String fileVersion = "1";
    private String fcInfoFileName = null;
    private FontConfigManager.FcCompFont[] fcCompFonts = null;

    public FcFontConfiguration(SunFontManager sunFontManager) {
        super(sunFontManager);
        this.init();
    }

    public FcFontConfiguration(SunFontManager sunFontManager, boolean bl, boolean bl2) {
        super(sunFontManager, bl, bl2);
        this.init();
    }

    @Override
    public synchronized boolean init() {
        if (this.fcCompFonts != null) {
            return true;
        }
        this.setFontConfiguration();
        this.readFcInfo();
        X11FontManager x11FontManager = (X11FontManager)this.fontManager;
        FontConfigManager fontConfigManager = x11FontManager.getFontConfigManager();
        if (this.fcCompFonts == null) {
            this.fcCompFonts = fontConfigManager.loadFontConfig();
            if (this.fcCompFonts != null) {
                try {
                    this.writeFcInfo();
                }
                catch (Exception exception) {
                    if (FontUtilities.debugFonts()) {
                        FcFontConfiguration.warning("Exception writing fcInfo " + exception);
                    }
                }
            } else if (FontUtilities.debugFonts()) {
                FcFontConfiguration.warning("Failed to get info from libfontconfig");
            }
        } else {
            fontConfigManager.populateFontConfig(this.fcCompFonts);
        }
        if (this.fcCompFonts == null) {
            return false;
        }
        String string = System.getProperty("java.home");
        if (string == null) {
            throw new Error("java.home property not set");
        }
        String string2 = string + File.separator + "lib";
        this.getInstalledFallbackFonts(string2);
        return true;
    }

    @Override
    public String getFallbackFamilyName(String string, String string2) {
        String string3 = this.getCompatibilityFamilyName(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    @Override
    protected String getFaceNameFromComponentFontName(String string) {
        return null;
    }

    @Override
    protected String getFileNameFromComponentFontName(String string) {
        return null;
    }

    @Override
    public String getFileNameFromPlatformName(String string) {
        return null;
    }

    @Override
    protected Charset getDefaultFontCharset(String string) {
        return Charset.forName("ISO8859_1");
    }

    @Override
    protected String getEncoding(String string, String string2) {
        return "default";
    }

    @Override
    protected void initReorderMap() {
        this.reorderMap = new HashMap();
    }

    @Override
    public FontDescriptor[] getFontDescriptors(String string, int n) {
        return new FontDescriptor[0];
    }

    @Override
    public int getNumberCoreFonts() {
        return 1;
    }

    @Override
    public String[] getPlatformFontNames() {
        HashSet<String> hashSet = new HashSet<String>();
        X11FontManager x11FontManager = (X11FontManager)this.fontManager;
        FontConfigManager fontConfigManager = x11FontManager.getFontConfigManager();
        FontConfigManager.FcCompFont[] fcCompFontArray = fontConfigManager.loadFontConfig();
        for (int i = 0; i < fcCompFontArray.length; ++i) {
            for (int j = 0; j < fcCompFontArray[i].allFonts.length; ++j) {
                hashSet.add(fcCompFontArray[i].allFonts[j].fontFile);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    @Override
    public String getExtraFontPath() {
        return null;
    }

    @Override
    public boolean needToSearchForFile(String string) {
        return false;
    }

    private FontConfigManager.FontConfigFont[] getFcFontList(FontConfigManager.FcCompFont[] fcCompFontArray, String string, int n) {
        if (string.equals("dialog")) {
            string = "sansserif";
        } else if (string.equals("dialoginput")) {
            string = "monospaced";
        }
        for (int i = 0; i < fcCompFontArray.length; ++i) {
            if (!string.equals(fcCompFontArray[i].jdkName) || n != fcCompFontArray[i].style) continue;
            return fcCompFontArray[i].allFonts;
        }
        return fcCompFontArray[0].allFonts;
    }

    @Override
    public CompositeFontDescriptor[] get2DCompositeFontInfo() {
        X11FontManager x11FontManager = (X11FontManager)this.fontManager;
        FontConfigManager fontConfigManager = x11FontManager.getFontConfigManager();
        FontConfigManager.FcCompFont[] fcCompFontArray = fontConfigManager.loadFontConfig();
        CompositeFontDescriptor[] compositeFontDescriptorArray = new CompositeFontDescriptor[20];
        for (int i = 0; i < 5; ++i) {
            String string = publicFontNames[i];
            for (int j = 0; j < 4; ++j) {
                String string2 = string + "." + styleNames[j];
                FontConfigManager.FontConfigFont[] fontConfigFontArray = this.getFcFontList(fcCompFontArray, fontNames[i], j);
                int n = fontConfigFontArray.length;
                if (installedFallbackFontFiles != null) {
                    n += installedFallbackFontFiles.length;
                }
                String[] stringArray = new String[n];
                for (int k = 0; k < fontConfigFontArray.length; ++k) {
                    stringArray[k] = fontConfigFontArray[k].fontFile;
                }
                if (installedFallbackFontFiles != null) {
                    System.arraycopy(installedFallbackFontFiles, 0, stringArray, fontConfigFontArray.length, installedFallbackFontFiles.length);
                }
                compositeFontDescriptorArray[i * 4 + j] = new CompositeFontDescriptor(string2, 1, null, stringArray, null, null);
            }
        }
        return compositeFontDescriptorArray;
    }

    private String getVersionString(File file) {
        try {
            Scanner scanner = new Scanner(file);
            return scanner.findInLine("(\\d)+((\\.)(\\d)+)*");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void setOsNameAndVersion() {
        block12: {
            super.setOsNameAndVersion();
            if (!osName.equals("Linux")) {
                return;
            }
            try {
                File file = new File("/etc/lsb-release");
                if (file.canRead()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    osName = properties.getProperty("DISTRIB_ID");
                    osVersion = properties.getProperty("DISTRIB_RELEASE");
                } else {
                    file = new File("/etc/redhat-release");
                    if (file.canRead()) {
                        osName = "RedHat";
                        osVersion = this.getVersionString(file);
                    } else {
                        file = new File("/etc/SuSE-release");
                        if (file.canRead()) {
                            osName = "SuSE";
                            osVersion = this.getVersionString(file);
                        } else {
                            file = new File("/etc/turbolinux-release");
                            if (file.canRead()) {
                                osName = "Turbo";
                                osVersion = this.getVersionString(file);
                            } else {
                                file = new File("/etc/fedora-release");
                                if (file.canRead()) {
                                    osName = "Fedora";
                                    osVersion = this.getVersionString(file);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!FontUtilities.debugFonts()) break block12;
                FcFontConfiguration.warning("Exception identifying Linux distro.");
            }
        }
    }

    private File getFcInfoFile() {
        if (this.fcInfoFileName == null) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "localhost";
            }
            String string2 = System.getProperty("user.home");
            String string3 = System.getProperty("java.version");
            String string4 = File.separator;
            String string5 = string2 + string4 + ".java" + string4 + "fonts" + string4 + string3;
            String string6 = SunToolkit.getStartupLocale().getLanguage();
            String string7 = "fcinfo-1-" + string + "-" + osName + "-" + osVersion + "-" + string6 + ".properties";
            this.fcInfoFileName = string5 + string4 + string7;
        }
        return new File(this.fcInfoFileName);
    }

    private void writeFcInfo() {
        block7: {
            Object object;
            Object object2;
            int n;
            Properties properties = new Properties();
            properties.setProperty("version", fileVersion);
            X11FontManager x11FontManager = (X11FontManager)this.fontManager;
            FontConfigManager fontConfigManager = x11FontManager.getFontConfigManager();
            FontConfigManager.FontConfigInfo fontConfigInfo = fontConfigManager.getFontConfigInfo();
            properties.setProperty("fcversion", Integer.toString(fontConfigInfo.fcVersion));
            if (fontConfigInfo.cacheDirs != null) {
                for (n = 0; n < fontConfigInfo.cacheDirs.length; ++n) {
                    if (fontConfigInfo.cacheDirs[n] == null) continue;
                    properties.setProperty("cachedir." + n, fontConfigInfo.cacheDirs[n]);
                }
            }
            for (n = 0; n < this.fcCompFonts.length; ++n) {
                object2 = this.fcCompFonts[n];
                object = ((FontConfigManager.FcCompFont)object2).jdkName + "." + ((FontConfigManager.FcCompFont)object2).style;
                properties.setProperty((String)object + ".length", Integer.toString(((FontConfigManager.FcCompFont)object2).allFonts.length));
                for (int i = 0; i < ((FontConfigManager.FcCompFont)object2).allFonts.length; ++i) {
                    properties.setProperty((String)object + "." + i + ".family", ((FontConfigManager.FcCompFont)object2).allFonts[i].familyName);
                    properties.setProperty((String)object + "." + i + ".file", ((FontConfigManager.FcCompFont)object2).allFonts[i].fontFile);
                }
            }
            try {
                File file = this.getFcInfoFile();
                object2 = file.getParentFile();
                ((File)object2).mkdirs();
                object = File.createTempFile("fcinfo", null, (File)object2);
                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                properties.store(fileOutputStream, "JDK Font Configuration Generated File: *Do Not Edit*");
                fileOutputStream.close();
                boolean bl = ((File)object).renameTo(file);
                if (!bl && FontUtilities.debugFonts()) {
                    System.out.println("rename failed");
                    FcFontConfiguration.warning("Failed renaming file to " + this.getFcInfoFile());
                }
            }
            catch (Exception exception) {
                if (!FontUtilities.debugFonts()) break block7;
                FcFontConfiguration.warning("IOException writing to " + this.getFcInfoFile());
            }
        }
    }

    private void readFcInfo() {
        block19: {
            String[] stringArray;
            String[] stringArray2;
            Object object;
            File file = this.getFcInfoFile();
            if (!file.exists()) {
                return;
            }
            Properties properties = new Properties();
            X11FontManager x11FontManager = (X11FontManager)this.fontManager;
            FontConfigManager fontConfigManager = x11FontManager.getFontConfigManager();
            try {
                object = new FileInputStream(file);
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
                if (FontUtilities.debugFonts()) {
                    FcFontConfiguration.warning("IOException reading from " + file.toString());
                }
                return;
            }
            object = (String)properties.get("version");
            if (object == null || !((String)object).equals(fileVersion)) {
                return;
            }
            String string = (String)properties.get("fcversion");
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n != 0) {
                        if (n != fontConfigManager.getFontConfigVersion()) {
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    if (FontUtilities.debugFonts()) {
                        FcFontConfiguration.warning("Exception parsing version " + string);
                    }
                    return;
                }
            }
            long l = file.lastModified();
            for (int i = 0; i < 4 && (stringArray2 = (String[])properties.get("cachedir." + i)) != null; ++i) {
                stringArray = new File((String)stringArray2);
                if (!stringArray.exists() || stringArray.lastModified() <= l) continue;
                return;
            }
            stringArray2 = new String[]{"sansserif", "serif", "monospaced"};
            stringArray = new String[]{"sans", "serif", "monospace"};
            int n = stringArray2.length;
            int n2 = 4;
            FontConfigManager.FcCompFont[] fcCompFontArray = new FontConfigManager.FcCompFont[n * n2];
            try {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = i * n2 + j;
                        fcCompFontArray[n3] = new FontConfigManager.FcCompFont();
                        String string2 = stringArray2[i] + "." + j;
                        fcCompFontArray[n3].jdkName = stringArray2[i];
                        fcCompFontArray[n3].fcFamily = stringArray[i];
                        fcCompFontArray[n3].style = j;
                        String string3 = (String)properties.get(string2 + ".length");
                        int n4 = Integer.parseInt(string3);
                        if (n4 <= 0) {
                            return;
                        }
                        fcCompFontArray[n3].allFonts = new FontConfigManager.FontConfigFont[n4];
                        for (int k = 0; k < n4; ++k) {
                            String string4;
                            fcCompFontArray[n3].allFonts[k] = new FontConfigManager.FontConfigFont();
                            String string5 = string2 + "." + k + ".family";
                            fcCompFontArray[n3].allFonts[k].familyName = string4 = (String)properties.get(string5);
                            string5 = string2 + "." + k + ".file";
                            String string6 = (String)properties.get(string5);
                            if (string6 == null) {
                                return;
                            }
                            fcCompFontArray[n3].allFonts[k].fontFile = string6;
                        }
                        fcCompFontArray[n3].firstFont = fcCompFontArray[n3].allFonts[0];
                    }
                }
                this.fcCompFonts = fcCompFontArray;
            }
            catch (Throwable throwable) {
                if (!FontUtilities.debugFonts()) break block19;
                FcFontConfiguration.warning(throwable.toString());
            }
        }
    }

    private static void warning(String string) {
        PlatformLogger platformLogger = PlatformLogger.getLogger("sun.awt.FontConfiguration");
        platformLogger.warning(string);
    }
}

