/*
 * Copyright (c) 2015, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * @test
 * @summary Test implicit String concatenations, multiple shapes.
 * @bug 8148483 8245959
 *
 * @compile ImplicitStringConcatShapes.java
 * @run main/othervm -Xverify:all ImplicitStringConcatShapes
 *
 * @compile -XDstringConcat=inline ImplicitStringConcatShapes.java
 * @run main/othervm -Xverify:all ImplicitStringConcatShapes
 *
 * @compile -XDstringConcat=indy ImplicitStringConcatShapes.java
 * @run main/othervm -Xverify:all ImplicitStringConcatShapes
 *
 * @compile -XDstringConcat=indyWithConstants ImplicitStringConcatShapes.java
 * @run main/othervm -Xverify:all ImplicitStringConcatShapes
*/
public class ImplicitStringConcatShapes {
    public static void test(String expected, String actual) {
        // Fingers crossed: String concat should work.
        if (!expected.equals(actual)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Expected = ");
            sb.append(expected);
            sb.append(", actual = ");
            sb.append(actual);
            throw new IllegalStateException(sb.toString());
        }
    }

    static class MyClass {
        private final int i;

        public MyClass(int i) {
            this.i = i;
        }

        public String toString() {
            return new StringBuilder("C(").append(i).append(")").toString();
        }
    }

    static class MyClassNullToString {
        public String toString() {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        new ImplicitStringConcatShapes().run();
    }
    static final boolean sf_bl = true;
    static final byte sf_b = 80;
    static final byte sf_bM = -41;
    static final char sf_c = 'C';
    static final short sf_s = 5500;
    static final short sf_sM = -8400;
    static final int sf_i = 75000000;
    static final int sf_iM = -2000000;
    static final Integer sf_I = 1000000;
    static final Integer sf_IN = null;
    static final float sf_f = 17.0f;
    static final float sf_fM = -42.0f;
    static final long sf_l = -194313216L;
    static final long sf_lM = -1705032704L;
    static final double sf_d = 12.0d;
    static final double sf_dM = -84.0d;
    static final Object sf_o = new MyClass(87);
    static final Object sf_oN = null;
    static final Object sf_oNtS = new MyClassNullToString();
    static final String sf_str = "75";
    static final String sf_strU = "\u04511";
    static final String sf_strU1 = "\u000151";
    static final String sf_strU2 = "\u000292";
    static final int[] sf_iAN = null;
    static final Object[] sf_oAN = null;
    static  boolean s_bl = true;
    static  byte s_b = 25;
    static  byte s_bM = -43;
    static  char s_c = 'T';
    static  short s_s = 3900;
    static  short s_sM = -2900;
    static  int s_i = 97000000;
    static  int s_iM = -1000000;
    static  Integer s_I = 25000000;
    static  Integer s_IN = null;
    static  float s_f = 55.0f;
    static  float s_fM = -52.0f;
    static  long s_l = 935228928L;
    static  long s_lM = -1410065408L;
    static  double s_d = 8.0d;
    static  double s_dM = -96.0d;
    static  Object s_o = new MyClass(82);
    static  Object s_oN = null;
    static  Object s_oNtS = new MyClassNullToString();
    static  String s_str = "18";
    static  String s_strU = "\u045180";
    static  String s_strU1 = "\u000112";
    static  String s_strU2 = "\u000291";
    static  int[] s_iAN = null;
    static  Object[] s_oAN = null;
     final boolean f_bl = false;
     final byte f_b = 44;
     final byte f_bM = -54;
     final char f_c = 'I';
     final short f_s = 8000;
     final short f_sM = -9900;
     final int f_i = 58000000;
     final int f_iM = -55000000;
     final Integer f_I = 94000000;
     final Integer f_IN = null;
     final float f_f = 94.0f;
     final float f_fM = -87.0f;
     final long f_l = 1460392448L;
     final long f_lM = -820130816L;
     final double f_d = 83.0d;
     final double f_dM = -99.0d;
     final Object f_o = new MyClass(70);
     final Object f_oN = null;
     final Object f_oNtS = new MyClassNullToString();
     final String f_str = "19";
     final String f_strU = "\u045176";
     final String f_strU1 = "\u000121";
     final String f_strU2 = "\u000218";
     final int[] f_iAN = null;
     final Object[] f_oAN = null;

    public void run() {
        run0();
        run1();
        run2();
        run3();
        run4();
        run5();
        run6();
        run7();
        run8();
        run9();
        run10();
        run11();
        run12();
        run13();
        run14();
        run15();
        run16();
        run17();
    }

    public void run0() {
        test("-96.0", "" + s_dM);
        test("prefix-96.0", "prefix" + s_dM);
        test("-96.0suffix", s_dM + "suffix");
        test("prefix-96.0suffix", "prefix" + s_dM + "suffix");
        test("null", "" + s_oNtS);
        test("prefixnull", "prefix" + s_oNtS);
        test("nullsuffix", s_oNtS + "suffix");
        test("prefixnullsuffix", "prefix" + s_oNtS + "suffix");
        test("\u045176", "" + f_strU);
        test("prefix\u045176", "prefix" + f_strU);
        test("\u045176suffix", f_strU + "suffix");
        test("prefix\u045176suffix", "prefix" + f_strU + "suffix");
        test("92", "" + sf_strU2);
        test("prefix92", "prefix" + sf_strU2);
        test("92suffix", sf_strU2 + "suffix");
        test("prefix92suffix", "prefix" + sf_strU2 + "suffix");
        test("51", "" + sf_strU1);
        test("prefix51", "prefix" + sf_strU1);
        test("51suffix", sf_strU1 + "suffix");
        test("prefix51suffix", "prefix" + sf_strU1 + "suffix");
        test("null", "" + s_iAN);
        test("prefixnull", "prefix" + s_iAN);
        test("nullsuffix", s_iAN + "suffix");
        test("prefixnullsuffix", "prefix" + s_iAN + "suffix");
        test("-54", "" + f_bM);
        test("prefix-54", "prefix" + f_bM);
        test("-54suffix", f_bM + "suffix");
        test("prefix-54suffix", "prefix" + f_bM + "suffix");
        test("-87.0", "" + f_fM);
        test("prefix-87.0", "prefix" + f_fM);
        test("-87.0suffix", f_fM + "suffix");
        test("prefix-87.0suffix", "prefix" + f_fM + "suffix");
        test("null", "" + s_oAN);
        test("prefixnull", "prefix" + s_oAN);
        test("nullsuffix", s_oAN + "suffix");
        test("prefixnullsuffix", "prefix" + s_oAN + "suffix");
        test("19", "" + f_str);
        test("prefix19", "prefix" + f_str);
        test("19suffix", f_str + "suffix");
        test("prefix19suffix", "prefix" + f_str + "suffix");
        test("-41", "" + sf_bM);
        test("prefix-41", "prefix" + sf_bM);
        test("-41suffix", sf_bM + "suffix");
        test("prefix-41suffix", "prefix" + sf_bM + "suffix");
        test("null", "" + sf_IN);
        test("prefixnull", "prefix" + sf_IN);
        test("nullsuffix", sf_IN + "suffix");
        test("prefixnullsuffix", "prefix" + sf_IN + "suffix");
        test("T", "" + s_c);
        test("prefixT", "prefix" + s_c);
        test("Tsuffix", s_c + "suffix");
        test("prefixTsuffix", "prefix" + s_c + "suffix");
        test("-42.0", "" + sf_fM);
        test("prefix-42.0", "prefix" + sf_fM);
        test("-42.0suffix", sf_fM + "suffix");
        test("prefix-42.0suffix", "prefix" + sf_fM + "suffix");
        test("25", "" + s_b);
        test("prefix25", "prefix" + s_b);
        test("25suffix", s_b + "suffix");
        test("prefix25suffix", "prefix" + s_b + "suffix");
        test("null", "" + f_oN);
        test("prefixnull", "prefix" + f_oN);
        test("nullsuffix", f_oN + "suffix");
        test("prefixnullsuffix", "prefix" + f_oN + "suffix");
        test("-1410065408", "" + s_lM);
        test("prefix-1410065408", "prefix" + s_lM);
        test("-1410065408suffix", s_lM + "suffix");
        test("prefix-1410065408suffix", "prefix" + s_lM + "suffix");
        test("8.0", "" + s_d);
        test("prefix8.0", "prefix" + s_d);
        test("8.0suffix", s_d + "suffix");
        test("prefix8.0suffix", "prefix" + s_d + "suffix");
        test("55.0", "" + s_f);
        test("prefix55.0", "prefix" + s_f);
        test("55.0suffix", s_f + "suffix");
        test("prefix55.0suffix", "prefix" + s_f + "suffix");
        test("97000000", "" + s_i);
        test("prefix97000000", "prefix" + s_i);
        test("97000000suffix", s_i + "suffix");
        test("prefix97000000suffix", "prefix" + s_i + "suffix");
        test("-9900", "" + f_sM);
        test("prefix-9900", "prefix" + f_sM);
        test("-9900suffix", f_sM + "suffix");
        test("prefix-9900suffix", "prefix" + f_sM + "suffix");
        test("935228928", "" + s_l);
        test("prefix935228928", "prefix" + s_l);
        test("935228928suffix", s_l + "suffix");
        test("prefix935228928suffix", "prefix" + s_l + "suffix");
        test("-8400", "" + sf_sM);
        test("prefix-8400", "prefix" + sf_sM);
        test("-8400suffix", sf_sM + "suffix");
        test("prefix-8400suffix", "prefix" + sf_sM + "suffix");
        test("C(82)", "" + s_o);
        test("prefixC(82)", "prefix" + s_o);
        test("C(82)suffix", s_o + "suffix");
        test("prefixC(82)suffix", "prefix" + s_o + "suffix");
        test("null", "" + sf_oNtS);
        test("prefixnull", "prefix" + sf_oNtS);
        test("nullsuffix", sf_oNtS + "suffix");
        test("prefixnullsuffix", "prefix" + sf_oNtS + "suffix");
        test("true", "" + s_bl);
        test("prefixtrue", "prefix" + s_bl);
        test("truesuffix", s_bl + "suffix");
        test("prefixtruesuffix", "prefix" + s_bl + "suffix");
        test("3900", "" + s_s);
        test("prefix3900", "prefix" + s_s);
        test("3900suffix", s_s + "suffix");
        test("prefix3900suffix", "prefix" + s_s + "suffix");
        test("null", "" + sf_oN);
        test("prefixnull", "prefix" + sf_oN);
        test("nullsuffix", sf_oN + "suffix");
        test("prefixnullsuffix", "prefix" + sf_oN + "suffix");
        test("94000000", "" + f_I);
        test("prefix94000000", "prefix" + f_I);
        test("94000000suffix", f_I + "suffix");
        test("prefix94000000suffix", "prefix" + f_I + "suffix");
        test("null", "" + f_IN);
        test("prefixnull", "prefix" + f_IN);
        test("nullsuffix", f_IN + "suffix");
        test("prefixnullsuffix", "prefix" + f_IN + "suffix");
        test("true", "" + sf_bl);
        test("prefixtrue", "prefix" + sf_bl);
        test("truesuffix", sf_bl + "suffix");
        test("prefixtruesuffix", "prefix" + sf_bl + "suffix");
        test("5500", "" + sf_s);
        test("prefix5500", "prefix" + sf_s);
        test("5500suffix", sf_s + "suffix");
        test("prefix5500suffix", "prefix" + sf_s + "suffix");
        test("-2900", "" + s_sM);
        test("prefix-2900", "prefix" + s_sM);
        test("-2900suffix", s_sM + "suffix");
        test("prefix-2900suffix", "prefix" + s_sM + "suffix");
        test("-194313216", "" + sf_l);
        test("prefix-194313216", "prefix" + sf_l);
        test("-194313216suffix", sf_l + "suffix");
        test("prefix-194313216suffix", "prefix" + sf_l + "suffix");
        test("12", "" + s_strU1);
        test("prefix12", "prefix" + s_strU1);
        test("12suffix", s_strU1 + "suffix");
        test("prefix12suffix", "prefix" + s_strU1 + "suffix");
        test("C(87)", "" + sf_o);
        test("prefixC(87)", "prefix" + sf_o);
        test("C(87)suffix", sf_o + "suffix");
        test("prefixC(87)suffix", "prefix" + sf_o + "suffix");
        test("91", "" + s_strU2);
        test("prefix91", "prefix" + s_strU2);
        test("91suffix", s_strU2 + "suffix");
        test("prefix91suffix", "prefix" + s_strU2 + "suffix");
        test("21", "" + f_strU1);
        test("prefix21", "prefix" + f_strU1);
        test("21suffix", f_strU1 + "suffix");
        test("prefix21suffix", "prefix" + f_strU1 + "suffix");
        test("18", "" + f_strU2);
        test("prefix18", "prefix" + f_strU2);
        test("18suffix", f_strU2 + "suffix");
        test("prefix18suffix", "prefix" + f_strU2 + "suffix");
        test("null", "" + f_iAN);
        test("prefixnull", "prefix" + f_iAN);
        test("nullsuffix", f_iAN + "suffix");
        test("prefixnullsuffix", "prefix" + f_iAN + "suffix");
        test("null", "" + s_oN);
        test("prefixnull", "prefix" + s_oN);
        test("nullsuffix", s_oN + "suffix");
        test("prefixnullsuffix", "prefix" + s_oN + "suffix");
        test("\u045180", "" + s_strU);
        test("prefix\u045180", "prefix" + s_strU);
        test("\u045180suffix", s_strU + "suffix");
        test("prefix\u045180suffix", "prefix" + s_strU + "suffix");
        test("C", "" + sf_c);
        test("prefixC", "prefix" + sf_c);
        test("Csuffix", sf_c + "suffix");
        test("prefixCsuffix", "prefix" + sf_c + "suffix");
        test("75", "" + sf_str);
        test("prefix75", "prefix" + sf_str);
        test("75suffix", sf_str + "suffix");
        test("prefix75suffix", "prefix" + sf_str + "suffix");
        test("-43", "" + s_bM);
        test("prefix-43", "prefix" + s_bM);
        test("-43suffix", s_bM + "suffix");
        test("prefix-43suffix", "prefix" + s_bM + "suffix");
        test("80", "" + sf_b);
        test("prefix80", "prefix" + sf_b);
        test("80suffix", sf_b + "suffix");
        test("prefix80suffix", "prefix" + sf_b + "suffix");
        test("null", "" + s_IN);
        test("prefixnull", "prefix" + s_IN);
        test("nullsuffix", s_IN + "suffix");
        test("prefixnullsuffix", "prefix" + s_IN + "suffix");
        test("-52.0", "" + s_fM);
        test("prefix-52.0", "prefix" + s_fM);
        test("-52.0suffix", s_fM + "suffix");
        test("prefix-52.0suffix", "prefix" + s_fM + "suffix");
        test("75000000", "" + sf_i);
        test("prefix75000000", "prefix" + sf_i);
        test("75000000suffix", sf_i + "suffix");
        test("prefix75000000suffix", "prefix" + sf_i + "suffix");
        test("44", "" + f_b);
        test("prefix44", "prefix" + f_b);
        test("44suffix", f_b + "suffix");
        test("prefix44suffix", "prefix" + f_b + "suffix");
        test("-1705032704", "" + sf_lM);
        test("prefix-1705032704", "prefix" + sf_lM);
        test("-1705032704suffix", sf_lM + "suffix");
        test("prefix-1705032704suffix", "prefix" + sf_lM + "suffix");
        test("null", "" + f_oAN);
        test("prefixnull", "prefix" + f_oAN);
        test("nullsuffix", f_oAN + "suffix");
        test("prefixnullsuffix", "prefix" + f_oAN + "suffix");
        test("83.0", "" + f_d);
        test("prefix83.0", "prefix" + f_d);
        test("83.0suffix", f_d + "suffix");
        test("prefix83.0suffix", "prefix" + f_d + "suffix");
        test("I", "" + f_c);
        test("prefixI", "prefix" + f_c);
        test("Isuffix", f_c + "suffix");
        test("prefixIsuffix", "prefix" + f_c + "suffix");
        test("94.0", "" + f_f);
        test("prefix94.0", "prefix" + f_f);
        test("94.0suffix", f_f + "suffix");
        test("prefix94.0suffix", "prefix" + f_f + "suffix");
        test("12.0", "" + sf_d);
        test("prefix12.0", "prefix" + sf_d);
        test("12.0suffix", sf_d + "suffix");
        test("prefix12.0suffix", "prefix" + sf_d + "suffix");
        test("-99.0", "" + f_dM);
        test("prefix-99.0", "prefix" + f_dM);
        test("-99.0suffix", f_dM + "suffix");
        test("prefix-99.0suffix", "prefix" + f_dM + "suffix");
        test("17.0", "" + sf_f);
        test("prefix17.0", "prefix" + sf_f);
        test("17.0suffix", sf_f + "suffix");
        test("prefix17.0suffix", "prefix" + sf_f + "suffix");
        test("-84.0", "" + sf_dM);
        test("prefix-84.0", "prefix" + sf_dM);
        test("-84.0suffix", sf_dM + "suffix");
        test("prefix-84.0suffix", "prefix" + sf_dM + "suffix");
        test("58000000", "" + f_i);
        test("prefix58000000", "prefix" + f_i);
        test("58000000suffix", f_i + "suffix");
        test("prefix58000000suffix", "prefix" + f_i + "suffix");
        test("-55000000", "" + f_iM);
        test("prefix-55000000", "prefix" + f_iM);
        test("-55000000suffix", f_iM + "suffix");
        test("prefix-55000000suffix", "prefix" + f_iM + "suffix");
        test("1460392448", "" + f_l);
        test("prefix1460392448", "prefix" + f_l);
        test("1460392448suffix", f_l + "suffix");
        test("prefix1460392448suffix", "prefix" + f_l + "suffix");
        test("C(70)", "" + f_o);
        test("prefixC(70)", "prefix" + f_o);
        test("C(70)suffix", f_o + "suffix");
        test("prefixC(70)suffix", "prefix" + f_o + "suffix");
        test("\u04511", "" + sf_strU);
        test("prefix\u04511", "prefix" + sf_strU);
        test("\u04511suffix", sf_strU + "suffix");
        test("prefix\u04511suffix", "prefix" + sf_strU + "suffix");
        test("8000", "" + f_s);
        test("prefix8000", "prefix" + f_s);
        test("8000suffix", f_s + "suffix");
        test("prefix8000suffix", "prefix" + f_s + "suffix");
        test("18", "" + s_str);
        test("prefix18", "prefix" + s_str);
        test("18suffix", s_str + "suffix");
        test("prefix18suffix", "prefix" + s_str + "suffix");
        test("-1000000", "" + s_iM);
        test("prefix-1000000", "prefix" + s_iM);
        test("-1000000suffix", s_iM + "suffix");
        test("prefix-1000000suffix", "prefix" + s_iM + "suffix");
        test("1000000", "" + sf_I);
        test("prefix1000000", "prefix" + sf_I);
        test("1000000suffix", sf_I + "suffix");
        test("prefix1000000suffix", "prefix" + sf_I + "suffix");
        test("null", "" + f_oNtS);
        test("prefixnull", "prefix" + f_oNtS);
        test("nullsuffix", f_oNtS + "suffix");
        test("prefixnullsuffix", "prefix" + f_oNtS + "suffix");
        test("false", "" + f_bl);
        test("prefixfalse", "prefix" + f_bl);
        test("falsesuffix", f_bl + "suffix");
        test("prefixfalsesuffix", "prefix" + f_bl + "suffix");
        test("null", "" + sf_iAN);
        test("prefixnull", "prefix" + sf_iAN);
        test("nullsuffix", sf_iAN + "suffix");
        test("prefixnullsuffix", "prefix" + sf_iAN + "suffix");
        test("-2000000", "" + sf_iM);
        test("prefix-2000000", "prefix" + sf_iM);
        test("-2000000suffix", sf_iM + "suffix");
        test("prefix-2000000suffix", "prefix" + sf_iM + "suffix");
        test("-820130816", "" + f_lM);
        test("prefix-820130816", "prefix" + f_lM);
        test("-820130816suffix", f_lM + "suffix");
        test("prefix-820130816suffix", "prefix" + f_lM + "suffix");
        test("null", "" + sf_oAN);
        test("prefixnull", "prefix" + sf_oAN);
        test("nullsuffix", sf_oAN + "suffix");
        test("prefixnullsuffix", "prefix" + sf_oAN + "suffix");
        test("25000000", "" + s_I);
        test("prefix25000000", "prefix" + s_I);
        test("25000000suffix", s_I + "suffix");
        test("prefix25000000suffix", "prefix" + s_I + "suffix");
        test("-96.0-96.0", "" + s_dM + s_dM);
        test("-96.0-96.0suffix", "" + s_dM + s_dM + "suffix");
        test("prefix-96.0suffix1-96.0suffix2", "prefix" + s_dM + "suffix1" + s_dM + "suffix2");
        test("-96.0null", "" + s_dM + s_oNtS);
        test("-96.0nullsuffix", "" + s_dM + s_oNtS + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + s_oNtS + "suffix2");
        test("-96.0\u045176", "" + s_dM + f_strU);
        test("-96.0\u045176suffix", "" + s_dM + f_strU + "suffix");
        test("prefix-96.0suffix1\u045176suffix2", "prefix" + s_dM + "suffix1" + f_strU + "suffix2");
        test("-96.092", "" + s_dM + sf_strU2);
        test("-96.092suffix", "" + s_dM + sf_strU2 + "suffix");
        test("prefix-96.0suffix192suffix2", "prefix" + s_dM + "suffix1" + sf_strU2 + "suffix2");
        test("-96.051", "" + s_dM + sf_strU1);
        test("-96.051suffix", "" + s_dM + sf_strU1 + "suffix");
        test("prefix-96.0suffix151suffix2", "prefix" + s_dM + "suffix1" + sf_strU1 + "suffix2");
        test("-96.0null", "" + s_dM + s_iAN);
        test("-96.0nullsuffix", "" + s_dM + s_iAN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + s_iAN + "suffix2");
        test("-96.0-54", "" + s_dM + f_bM);
        test("-96.0-54suffix", "" + s_dM + f_bM + "suffix");
        test("prefix-96.0suffix1-54suffix2", "prefix" + s_dM + "suffix1" + f_bM + "suffix2");
        test("-96.0-87.0", "" + s_dM + f_fM);
        test("-96.0-87.0suffix", "" + s_dM + f_fM + "suffix");
        test("prefix-96.0suffix1-87.0suffix2", "prefix" + s_dM + "suffix1" + f_fM + "suffix2");
        test("-96.0null", "" + s_dM + s_oAN);
        test("-96.0nullsuffix", "" + s_dM + s_oAN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + s_oAN + "suffix2");
        test("-96.019", "" + s_dM + f_str);
        test("-96.019suffix", "" + s_dM + f_str + "suffix");
        test("prefix-96.0suffix119suffix2", "prefix" + s_dM + "suffix1" + f_str + "suffix2");
        test("-96.0-41", "" + s_dM + sf_bM);
        test("-96.0-41suffix", "" + s_dM + sf_bM + "suffix");
        test("prefix-96.0suffix1-41suffix2", "prefix" + s_dM + "suffix1" + sf_bM + "suffix2");
        test("-96.0null", "" + s_dM + sf_IN);
        test("-96.0nullsuffix", "" + s_dM + sf_IN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + sf_IN + "suffix2");
        test("-96.0T", "" + s_dM + s_c);
        test("-96.0Tsuffix", "" + s_dM + s_c + "suffix");
        test("prefix-96.0suffix1Tsuffix2", "prefix" + s_dM + "suffix1" + s_c + "suffix2");
        test("-96.0-42.0", "" + s_dM + sf_fM);
        test("-96.0-42.0suffix", "" + s_dM + sf_fM + "suffix");
        test("prefix-96.0suffix1-42.0suffix2", "prefix" + s_dM + "suffix1" + sf_fM + "suffix2");
        test("-96.025", "" + s_dM + s_b);
        test("-96.025suffix", "" + s_dM + s_b + "suffix");
        test("prefix-96.0suffix125suffix2", "prefix" + s_dM + "suffix1" + s_b + "suffix2");
        test("-96.0null", "" + s_dM + f_oN);
        test("-96.0nullsuffix", "" + s_dM + f_oN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + f_oN + "suffix2");
        test("-96.0-1410065408", "" + s_dM + s_lM);
        test("-96.0-1410065408suffix", "" + s_dM + s_lM + "suffix");
        test("prefix-96.0suffix1-1410065408suffix2", "prefix" + s_dM + "suffix1" + s_lM + "suffix2");
        test("-96.08.0", "" + s_dM + s_d);
        test("-96.08.0suffix", "" + s_dM + s_d + "suffix");
        test("prefix-96.0suffix18.0suffix2", "prefix" + s_dM + "suffix1" + s_d + "suffix2");
        test("-96.055.0", "" + s_dM + s_f);
        test("-96.055.0suffix", "" + s_dM + s_f + "suffix");
        test("prefix-96.0suffix155.0suffix2", "prefix" + s_dM + "suffix1" + s_f + "suffix2");
        test("-96.097000000", "" + s_dM + s_i);
        test("-96.097000000suffix", "" + s_dM + s_i + "suffix");
        test("prefix-96.0suffix197000000suffix2", "prefix" + s_dM + "suffix1" + s_i + "suffix2");
        test("-96.0-9900", "" + s_dM + f_sM);
        test("-96.0-9900suffix", "" + s_dM + f_sM + "suffix");
        test("prefix-96.0suffix1-9900suffix2", "prefix" + s_dM + "suffix1" + f_sM + "suffix2");
        test("-96.0935228928", "" + s_dM + s_l);
        test("-96.0935228928suffix", "" + s_dM + s_l + "suffix");
        test("prefix-96.0suffix1935228928suffix2", "prefix" + s_dM + "suffix1" + s_l + "suffix2");
        test("-96.0-8400", "" + s_dM + sf_sM);
        test("-96.0-8400suffix", "" + s_dM + sf_sM + "suffix");
        test("prefix-96.0suffix1-8400suffix2", "prefix" + s_dM + "suffix1" + sf_sM + "suffix2");
        test("-96.0C(82)", "" + s_dM + s_o);
        test("-96.0C(82)suffix", "" + s_dM + s_o + "suffix");
        test("prefix-96.0suffix1C(82)suffix2", "prefix" + s_dM + "suffix1" + s_o + "suffix2");
        test("-96.0null", "" + s_dM + sf_oNtS);
        test("-96.0nullsuffix", "" + s_dM + sf_oNtS + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + sf_oNtS + "suffix2");
        test("-96.0true", "" + s_dM + s_bl);
        test("-96.0truesuffix", "" + s_dM + s_bl + "suffix");
        test("prefix-96.0suffix1truesuffix2", "prefix" + s_dM + "suffix1" + s_bl + "suffix2");
        test("-96.03900", "" + s_dM + s_s);
        test("-96.03900suffix", "" + s_dM + s_s + "suffix");
        test("prefix-96.0suffix13900suffix2", "prefix" + s_dM + "suffix1" + s_s + "suffix2");
        test("-96.0null", "" + s_dM + sf_oN);
        test("-96.0nullsuffix", "" + s_dM + sf_oN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + sf_oN + "suffix2");
        test("-96.094000000", "" + s_dM + f_I);
        test("-96.094000000suffix", "" + s_dM + f_I + "suffix");
        test("prefix-96.0suffix194000000suffix2", "prefix" + s_dM + "suffix1" + f_I + "suffix2");
        test("-96.0null", "" + s_dM + f_IN);
        test("-96.0nullsuffix", "" + s_dM + f_IN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + f_IN + "suffix2");
        test("-96.0true", "" + s_dM + sf_bl);
        test("-96.0truesuffix", "" + s_dM + sf_bl + "suffix");
        test("prefix-96.0suffix1truesuffix2", "prefix" + s_dM + "suffix1" + sf_bl + "suffix2");
        test("-96.05500", "" + s_dM + sf_s);
        test("-96.05500suffix", "" + s_dM + sf_s + "suffix");
        test("prefix-96.0suffix15500suffix2", "prefix" + s_dM + "suffix1" + sf_s + "suffix2");
        test("-96.0-2900", "" + s_dM + s_sM);
        test("-96.0-2900suffix", "" + s_dM + s_sM + "suffix");
        test("prefix-96.0suffix1-2900suffix2", "prefix" + s_dM + "suffix1" + s_sM + "suffix2");
        test("-96.0-194313216", "" + s_dM + sf_l);
        test("-96.0-194313216suffix", "" + s_dM + sf_l + "suffix");
        test("prefix-96.0suffix1-194313216suffix2", "prefix" + s_dM + "suffix1" + sf_l + "suffix2");
        test("-96.012", "" + s_dM + s_strU1);
        test("-96.012suffix", "" + s_dM + s_strU1 + "suffix");
        test("prefix-96.0suffix112suffix2", "prefix" + s_dM + "suffix1" + s_strU1 + "suffix2");
        test("-96.0C(87)", "" + s_dM + sf_o);
        test("-96.0C(87)suffix", "" + s_dM + sf_o + "suffix");
        test("prefix-96.0suffix1C(87)suffix2", "prefix" + s_dM + "suffix1" + sf_o + "suffix2");
        test("-96.091", "" + s_dM + s_strU2);
        test("-96.091suffix", "" + s_dM + s_strU2 + "suffix");
        test("prefix-96.0suffix191suffix2", "prefix" + s_dM + "suffix1" + s_strU2 + "suffix2");
        test("-96.021", "" + s_dM + f_strU1);
        test("-96.021suffix", "" + s_dM + f_strU1 + "suffix");
        test("prefix-96.0suffix121suffix2", "prefix" + s_dM + "suffix1" + f_strU1 + "suffix2");
        test("-96.018", "" + s_dM + f_strU2);
        test("-96.018suffix", "" + s_dM + f_strU2 + "suffix");
        test("prefix-96.0suffix118suffix2", "prefix" + s_dM + "suffix1" + f_strU2 + "suffix2");
        test("-96.0null", "" + s_dM + f_iAN);
        test("-96.0nullsuffix", "" + s_dM + f_iAN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + f_iAN + "suffix2");
        test("-96.0null", "" + s_dM + s_oN);
        test("-96.0nullsuffix", "" + s_dM + s_oN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + s_oN + "suffix2");
        test("-96.0\u045180", "" + s_dM + s_strU);
        test("-96.0\u045180suffix", "" + s_dM + s_strU + "suffix");
        test("prefix-96.0suffix1\u045180suffix2", "prefix" + s_dM + "suffix1" + s_strU + "suffix2");
        test("-96.0C", "" + s_dM + sf_c);
        test("-96.0Csuffix", "" + s_dM + sf_c + "suffix");
        test("prefix-96.0suffix1Csuffix2", "prefix" + s_dM + "suffix1" + sf_c + "suffix2");
        test("-96.075", "" + s_dM + sf_str);
        test("-96.075suffix", "" + s_dM + sf_str + "suffix");
        test("prefix-96.0suffix175suffix2", "prefix" + s_dM + "suffix1" + sf_str + "suffix2");
        test("-96.0-43", "" + s_dM + s_bM);
        test("-96.0-43suffix", "" + s_dM + s_bM + "suffix");
        test("prefix-96.0suffix1-43suffix2", "prefix" + s_dM + "suffix1" + s_bM + "suffix2");
        test("-96.080", "" + s_dM + sf_b);
        test("-96.080suffix", "" + s_dM + sf_b + "suffix");
        test("prefix-96.0suffix180suffix2", "prefix" + s_dM + "suffix1" + sf_b + "suffix2");
        test("-96.0null", "" + s_dM + s_IN);
        test("-96.0nullsuffix", "" + s_dM + s_IN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + s_IN + "suffix2");
        test("-96.0-52.0", "" + s_dM + s_fM);
        test("-96.0-52.0suffix", "" + s_dM + s_fM + "suffix");
        test("prefix-96.0suffix1-52.0suffix2", "prefix" + s_dM + "suffix1" + s_fM + "suffix2");
        test("-96.075000000", "" + s_dM + sf_i);
        test("-96.075000000suffix", "" + s_dM + sf_i + "suffix");
        test("prefix-96.0suffix175000000suffix2", "prefix" + s_dM + "suffix1" + sf_i + "suffix2");
        test("-96.044", "" + s_dM + f_b);
        test("-96.044suffix", "" + s_dM + f_b + "suffix");
        test("prefix-96.0suffix144suffix2", "prefix" + s_dM + "suffix1" + f_b + "suffix2");
        test("-96.0-1705032704", "" + s_dM + sf_lM);
        test("-96.0-1705032704suffix", "" + s_dM + sf_lM + "suffix");
        test("prefix-96.0suffix1-1705032704suffix2", "prefix" + s_dM + "suffix1" + sf_lM + "suffix2");
        test("-96.0null", "" + s_dM + f_oAN);
        test("-96.0nullsuffix", "" + s_dM + f_oAN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + f_oAN + "suffix2");
        test("-96.083.0", "" + s_dM + f_d);
        test("-96.083.0suffix", "" + s_dM + f_d + "suffix");
        test("prefix-96.0suffix183.0suffix2", "prefix" + s_dM + "suffix1" + f_d + "suffix2");
        test("-96.0I", "" + s_dM + f_c);
        test("-96.0Isuffix", "" + s_dM + f_c + "suffix");
        test("prefix-96.0suffix1Isuffix2", "prefix" + s_dM + "suffix1" + f_c + "suffix2");
        test("-96.094.0", "" + s_dM + f_f);
        test("-96.094.0suffix", "" + s_dM + f_f + "suffix");
        test("prefix-96.0suffix194.0suffix2", "prefix" + s_dM + "suffix1" + f_f + "suffix2");
        test("-96.012.0", "" + s_dM + sf_d);
        test("-96.012.0suffix", "" + s_dM + sf_d + "suffix");
        test("prefix-96.0suffix112.0suffix2", "prefix" + s_dM + "suffix1" + sf_d + "suffix2");
        test("-96.0-99.0", "" + s_dM + f_dM);
        test("-96.0-99.0suffix", "" + s_dM + f_dM + "suffix");
        test("prefix-96.0suffix1-99.0suffix2", "prefix" + s_dM + "suffix1" + f_dM + "suffix2");
        test("-96.017.0", "" + s_dM + sf_f);
        test("-96.017.0suffix", "" + s_dM + sf_f + "suffix");
        test("prefix-96.0suffix117.0suffix2", "prefix" + s_dM + "suffix1" + sf_f + "suffix2");
        test("-96.0-84.0", "" + s_dM + sf_dM);
        test("-96.0-84.0suffix", "" + s_dM + sf_dM + "suffix");
        test("prefix-96.0suffix1-84.0suffix2", "prefix" + s_dM + "suffix1" + sf_dM + "suffix2");
        test("-96.058000000", "" + s_dM + f_i);
        test("-96.058000000suffix", "" + s_dM + f_i + "suffix");
        test("prefix-96.0suffix158000000suffix2", "prefix" + s_dM + "suffix1" + f_i + "suffix2");
        test("-96.0-55000000", "" + s_dM + f_iM);
        test("-96.0-55000000suffix", "" + s_dM + f_iM + "suffix");
        test("prefix-96.0suffix1-55000000suffix2", "prefix" + s_dM + "suffix1" + f_iM + "suffix2");
        test("-96.01460392448", "" + s_dM + f_l);
        test("-96.01460392448suffix", "" + s_dM + f_l + "suffix");
        test("prefix-96.0suffix11460392448suffix2", "prefix" + s_dM + "suffix1" + f_l + "suffix2");
        test("-96.0C(70)", "" + s_dM + f_o);
        test("-96.0C(70)suffix", "" + s_dM + f_o + "suffix");
        test("prefix-96.0suffix1C(70)suffix2", "prefix" + s_dM + "suffix1" + f_o + "suffix2");
        test("-96.0\u04511", "" + s_dM + sf_strU);
        test("-96.0\u04511suffix", "" + s_dM + sf_strU + "suffix");
        test("prefix-96.0suffix1\u04511suffix2", "prefix" + s_dM + "suffix1" + sf_strU + "suffix2");
        test("-96.08000", "" + s_dM + f_s);
        test("-96.08000suffix", "" + s_dM + f_s + "suffix");
        test("prefix-96.0suffix18000suffix2", "prefix" + s_dM + "suffix1" + f_s + "suffix2");
        test("-96.018", "" + s_dM + s_str);
        test("-96.018suffix", "" + s_dM + s_str + "suffix");
        test("prefix-96.0suffix118suffix2", "prefix" + s_dM + "suffix1" + s_str + "suffix2");
        test("-96.0-1000000", "" + s_dM + s_iM);
        test("-96.0-1000000suffix", "" + s_dM + s_iM + "suffix");
        test("prefix-96.0suffix1-1000000suffix2", "prefix" + s_dM + "suffix1" + s_iM + "suffix2");
        test("-96.01000000", "" + s_dM + sf_I);
        test("-96.01000000suffix", "" + s_dM + sf_I + "suffix");
        test("prefix-96.0suffix11000000suffix2", "prefix" + s_dM + "suffix1" + sf_I + "suffix2");
        test("-96.0null", "" + s_dM + f_oNtS);
        test("-96.0nullsuffix", "" + s_dM + f_oNtS + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + f_oNtS + "suffix2");
        test("-96.0false", "" + s_dM + f_bl);
        test("-96.0falsesuffix", "" + s_dM + f_bl + "suffix");
        test("prefix-96.0suffix1falsesuffix2", "prefix" + s_dM + "suffix1" + f_bl + "suffix2");
        test("-96.0null", "" + s_dM + sf_iAN);
        test("-96.0nullsuffix", "" + s_dM + sf_iAN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + sf_iAN + "suffix2");
        test("-96.0-2000000", "" + s_dM + sf_iM);
        test("-96.0-2000000suffix", "" + s_dM + sf_iM + "suffix");
        test("prefix-96.0suffix1-2000000suffix2", "prefix" + s_dM + "suffix1" + sf_iM + "suffix2");
        test("-96.0-820130816", "" + s_dM + f_lM);
        test("-96.0-820130816suffix", "" + s_dM + f_lM + "suffix");
        test("prefix-96.0suffix1-820130816suffix2", "prefix" + s_dM + "suffix1" + f_lM + "suffix2");
        test("-96.0null", "" + s_dM + sf_oAN);
        test("-96.0nullsuffix", "" + s_dM + sf_oAN + "suffix");
        test("prefix-96.0suffix1nullsuffix2", "prefix" + s_dM + "suffix1" + sf_oAN + "suffix2");
        test("-96.025000000", "" + s_dM + s_I);
        test("-96.025000000suffix", "" + s_dM + s_I + "suffix");
        test("prefix-96.0suffix125000000suffix2", "prefix" + s_dM + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + s_oNtS + s_dM);
        test("null-96.0suffix", "" + s_oNtS + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + s_oNtS + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + s_oNtS + s_oNtS);
        test("nullnullsuffix", "" + s_oNtS + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + s_oNtS + f_strU);
        test("null\u045176suffix", "" + s_oNtS + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + s_oNtS + "suffix1" + f_strU + "suffix2");
        test("null92", "" + s_oNtS + sf_strU2);
        test("null92suffix", "" + s_oNtS + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + s_oNtS + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + s_oNtS + sf_strU1);
        test("null51suffix", "" + s_oNtS + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + s_oNtS + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + s_oNtS + s_iAN);
        test("nullnullsuffix", "" + s_oNtS + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + s_oNtS + f_bM);
        test("null-54suffix", "" + s_oNtS + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + s_oNtS + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + s_oNtS + f_fM);
        test("null-87.0suffix", "" + s_oNtS + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + s_oNtS + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + s_oNtS + s_oAN);
        test("nullnullsuffix", "" + s_oNtS + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + s_oNtS + f_str);
        test("null19suffix", "" + s_oNtS + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + s_oNtS + "suffix1" + f_str + "suffix2");
        test("null-41", "" + s_oNtS + sf_bM);
        test("null-41suffix", "" + s_oNtS + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + s_oNtS + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + s_oNtS + sf_IN);
        test("nullnullsuffix", "" + s_oNtS + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + s_oNtS + s_c);
        test("nullTsuffix", "" + s_oNtS + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + s_oNtS + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + s_oNtS + sf_fM);
        test("null-42.0suffix", "" + s_oNtS + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + s_oNtS + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + s_oNtS + s_b);
        test("null25suffix", "" + s_oNtS + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + s_oNtS + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + s_oNtS + f_oN);
        test("nullnullsuffix", "" + s_oNtS + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + s_oNtS + s_lM);
        test("null-1410065408suffix", "" + s_oNtS + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + s_oNtS + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + s_oNtS + s_d);
        test("null8.0suffix", "" + s_oNtS + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + s_oNtS + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + s_oNtS + s_f);
        test("null55.0suffix", "" + s_oNtS + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + s_oNtS + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + s_oNtS + s_i);
        test("null97000000suffix", "" + s_oNtS + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + s_oNtS + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + s_oNtS + f_sM);
        test("null-9900suffix", "" + s_oNtS + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + s_oNtS + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + s_oNtS + s_l);
        test("null935228928suffix", "" + s_oNtS + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + s_oNtS + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + s_oNtS + sf_sM);
        test("null-8400suffix", "" + s_oNtS + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + s_oNtS + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + s_oNtS + s_o);
        test("nullC(82)suffix", "" + s_oNtS + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + s_oNtS + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + s_oNtS + sf_oNtS);
        test("nullnullsuffix", "" + s_oNtS + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + s_oNtS + s_bl);
        test("nulltruesuffix", "" + s_oNtS + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_oNtS + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + s_oNtS + s_s);
        test("null3900suffix", "" + s_oNtS + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + s_oNtS + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + s_oNtS + sf_oN);
        test("nullnullsuffix", "" + s_oNtS + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + s_oNtS + f_I);
        test("null94000000suffix", "" + s_oNtS + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + s_oNtS + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + s_oNtS + f_IN);
        test("nullnullsuffix", "" + s_oNtS + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + s_oNtS + sf_bl);
        test("nulltruesuffix", "" + s_oNtS + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_oNtS + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + s_oNtS + sf_s);
        test("null5500suffix", "" + s_oNtS + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + s_oNtS + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + s_oNtS + s_sM);
        test("null-2900suffix", "" + s_oNtS + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + s_oNtS + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + s_oNtS + sf_l);
        test("null-194313216suffix", "" + s_oNtS + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + s_oNtS + "suffix1" + sf_l + "suffix2");
        test("null12", "" + s_oNtS + s_strU1);
        test("null12suffix", "" + s_oNtS + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + s_oNtS + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + s_oNtS + sf_o);
        test("nullC(87)suffix", "" + s_oNtS + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + s_oNtS + "suffix1" + sf_o + "suffix2");
        test("null91", "" + s_oNtS + s_strU2);
        test("null91suffix", "" + s_oNtS + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + s_oNtS + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + s_oNtS + f_strU1);
        test("null21suffix", "" + s_oNtS + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + s_oNtS + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + s_oNtS + f_strU2);
        test("null18suffix", "" + s_oNtS + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_oNtS + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + s_oNtS + f_iAN);
        test("nullnullsuffix", "" + s_oNtS + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + s_oNtS + s_oN);
        test("nullnullsuffix", "" + s_oNtS + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + s_oNtS + s_strU);
        test("null\u045180suffix", "" + s_oNtS + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + s_oNtS + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + s_oNtS + sf_c);
        test("nullCsuffix", "" + s_oNtS + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + s_oNtS + "suffix1" + sf_c + "suffix2");
        test("null75", "" + s_oNtS + sf_str);
        test("null75suffix", "" + s_oNtS + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + s_oNtS + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + s_oNtS + s_bM);
        test("null-43suffix", "" + s_oNtS + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + s_oNtS + "suffix1" + s_bM + "suffix2");
        test("null80", "" + s_oNtS + sf_b);
        test("null80suffix", "" + s_oNtS + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + s_oNtS + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + s_oNtS + s_IN);
        test("nullnullsuffix", "" + s_oNtS + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + s_oNtS + s_fM);
        test("null-52.0suffix", "" + s_oNtS + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + s_oNtS + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + s_oNtS + sf_i);
        test("null75000000suffix", "" + s_oNtS + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + s_oNtS + "suffix1" + sf_i + "suffix2");
        test("null44", "" + s_oNtS + f_b);
        test("null44suffix", "" + s_oNtS + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + s_oNtS + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + s_oNtS + sf_lM);
        test("null-1705032704suffix", "" + s_oNtS + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + s_oNtS + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + s_oNtS + f_oAN);
        test("nullnullsuffix", "" + s_oNtS + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + s_oNtS + f_d);
        test("null83.0suffix", "" + s_oNtS + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + s_oNtS + "suffix1" + f_d + "suffix2");
        test("nullI", "" + s_oNtS + f_c);
        test("nullIsuffix", "" + s_oNtS + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + s_oNtS + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + s_oNtS + f_f);
        test("null94.0suffix", "" + s_oNtS + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + s_oNtS + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + s_oNtS + sf_d);
        test("null12.0suffix", "" + s_oNtS + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + s_oNtS + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + s_oNtS + f_dM);
        test("null-99.0suffix", "" + s_oNtS + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + s_oNtS + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + s_oNtS + sf_f);
        test("null17.0suffix", "" + s_oNtS + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + s_oNtS + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + s_oNtS + sf_dM);
        test("null-84.0suffix", "" + s_oNtS + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + s_oNtS + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + s_oNtS + f_i);
        test("null58000000suffix", "" + s_oNtS + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + s_oNtS + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + s_oNtS + f_iM);
        test("null-55000000suffix", "" + s_oNtS + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + s_oNtS + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + s_oNtS + f_l);
        test("null1460392448suffix", "" + s_oNtS + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + s_oNtS + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + s_oNtS + f_o);
        test("nullC(70)suffix", "" + s_oNtS + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + s_oNtS + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + s_oNtS + sf_strU);
        test("null\u04511suffix", "" + s_oNtS + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + s_oNtS + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + s_oNtS + f_s);
        test("null8000suffix", "" + s_oNtS + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + s_oNtS + "suffix1" + f_s + "suffix2");
        test("null18", "" + s_oNtS + s_str);
        test("null18suffix", "" + s_oNtS + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_oNtS + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + s_oNtS + s_iM);
        test("null-1000000suffix", "" + s_oNtS + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + s_oNtS + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + s_oNtS + sf_I);
        test("null1000000suffix", "" + s_oNtS + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + s_oNtS + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + s_oNtS + f_oNtS);
        test("nullnullsuffix", "" + s_oNtS + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + s_oNtS + f_bl);
        test("nullfalsesuffix", "" + s_oNtS + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + s_oNtS + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + s_oNtS + sf_iAN);
        test("nullnullsuffix", "" + s_oNtS + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + s_oNtS + sf_iM);
        test("null-2000000suffix", "" + s_oNtS + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + s_oNtS + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + s_oNtS + f_lM);
        test("null-820130816suffix", "" + s_oNtS + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + s_oNtS + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + s_oNtS + sf_oAN);
        test("nullnullsuffix", "" + s_oNtS + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oNtS + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + s_oNtS + s_I);
        test("null25000000suffix", "" + s_oNtS + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + s_oNtS + "suffix1" + s_I + "suffix2");
        test("\u045176-96.0", "" + f_strU + s_dM);
        test("\u045176-96.0suffix", "" + f_strU + s_dM + "suffix");
        test("prefix\u045176suffix1-96.0suffix2", "prefix" + f_strU + "suffix1" + s_dM + "suffix2");
        test("\u045176null", "" + f_strU + s_oNtS);
        test("\u045176nullsuffix", "" + f_strU + s_oNtS + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + s_oNtS + "suffix2");
        test("\u045176\u045176", "" + f_strU + f_strU);
        test("\u045176\u045176suffix", "" + f_strU + f_strU + "suffix");
        test("prefix\u045176suffix1\u045176suffix2", "prefix" + f_strU + "suffix1" + f_strU + "suffix2");
        test("\u04517692", "" + f_strU + sf_strU2);
        test("\u04517692suffix", "" + f_strU + sf_strU2 + "suffix");
        test("prefix\u045176suffix192suffix2", "prefix" + f_strU + "suffix1" + sf_strU2 + "suffix2");
        test("\u04517651", "" + f_strU + sf_strU1);
        test("\u04517651suffix", "" + f_strU + sf_strU1 + "suffix");
        test("prefix\u045176suffix151suffix2", "prefix" + f_strU + "suffix1" + sf_strU1 + "suffix2");
        test("\u045176null", "" + f_strU + s_iAN);
        test("\u045176nullsuffix", "" + f_strU + s_iAN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + s_iAN + "suffix2");
        test("\u045176-54", "" + f_strU + f_bM);
        test("\u045176-54suffix", "" + f_strU + f_bM + "suffix");
        test("prefix\u045176suffix1-54suffix2", "prefix" + f_strU + "suffix1" + f_bM + "suffix2");
        test("\u045176-87.0", "" + f_strU + f_fM);
        test("\u045176-87.0suffix", "" + f_strU + f_fM + "suffix");
        test("prefix\u045176suffix1-87.0suffix2", "prefix" + f_strU + "suffix1" + f_fM + "suffix2");
        test("\u045176null", "" + f_strU + s_oAN);
        test("\u045176nullsuffix", "" + f_strU + s_oAN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + s_oAN + "suffix2");
        test("\u04517619", "" + f_strU + f_str);
        test("\u04517619suffix", "" + f_strU + f_str + "suffix");
        test("prefix\u045176suffix119suffix2", "prefix" + f_strU + "suffix1" + f_str + "suffix2");
        test("\u045176-41", "" + f_strU + sf_bM);
        test("\u045176-41suffix", "" + f_strU + sf_bM + "suffix");
        test("prefix\u045176suffix1-41suffix2", "prefix" + f_strU + "suffix1" + sf_bM + "suffix2");
        test("\u045176null", "" + f_strU + sf_IN);
        test("\u045176nullsuffix", "" + f_strU + sf_IN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + sf_IN + "suffix2");
        test("\u045176T", "" + f_strU + s_c);
        test("\u045176Tsuffix", "" + f_strU + s_c + "suffix");
        test("prefix\u045176suffix1Tsuffix2", "prefix" + f_strU + "suffix1" + s_c + "suffix2");
        test("\u045176-42.0", "" + f_strU + sf_fM);
        test("\u045176-42.0suffix", "" + f_strU + sf_fM + "suffix");
        test("prefix\u045176suffix1-42.0suffix2", "prefix" + f_strU + "suffix1" + sf_fM + "suffix2");
        test("\u04517625", "" + f_strU + s_b);
        test("\u04517625suffix", "" + f_strU + s_b + "suffix");
        test("prefix\u045176suffix125suffix2", "prefix" + f_strU + "suffix1" + s_b + "suffix2");
        test("\u045176null", "" + f_strU + f_oN);
        test("\u045176nullsuffix", "" + f_strU + f_oN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + f_oN + "suffix2");
        test("\u045176-1410065408", "" + f_strU + s_lM);
        test("\u045176-1410065408suffix", "" + f_strU + s_lM + "suffix");
        test("prefix\u045176suffix1-1410065408suffix2", "prefix" + f_strU + "suffix1" + s_lM + "suffix2");
        test("\u0451768.0", "" + f_strU + s_d);
        test("\u0451768.0suffix", "" + f_strU + s_d + "suffix");
        test("prefix\u045176suffix18.0suffix2", "prefix" + f_strU + "suffix1" + s_d + "suffix2");
        test("\u04517655.0", "" + f_strU + s_f);
        test("\u04517655.0suffix", "" + f_strU + s_f + "suffix");
        test("prefix\u045176suffix155.0suffix2", "prefix" + f_strU + "suffix1" + s_f + "suffix2");
        test("\u04517697000000", "" + f_strU + s_i);
        test("\u04517697000000suffix", "" + f_strU + s_i + "suffix");
        test("prefix\u045176suffix197000000suffix2", "prefix" + f_strU + "suffix1" + s_i + "suffix2");
        test("\u045176-9900", "" + f_strU + f_sM);
        test("\u045176-9900suffix", "" + f_strU + f_sM + "suffix");
        test("prefix\u045176suffix1-9900suffix2", "prefix" + f_strU + "suffix1" + f_sM + "suffix2");
        test("\u045176935228928", "" + f_strU + s_l);
        test("\u045176935228928suffix", "" + f_strU + s_l + "suffix");
        test("prefix\u045176suffix1935228928suffix2", "prefix" + f_strU + "suffix1" + s_l + "suffix2");
        test("\u045176-8400", "" + f_strU + sf_sM);
        test("\u045176-8400suffix", "" + f_strU + sf_sM + "suffix");
        test("prefix\u045176suffix1-8400suffix2", "prefix" + f_strU + "suffix1" + sf_sM + "suffix2");
        test("\u045176C(82)", "" + f_strU + s_o);
        test("\u045176C(82)suffix", "" + f_strU + s_o + "suffix");
        test("prefix\u045176suffix1C(82)suffix2", "prefix" + f_strU + "suffix1" + s_o + "suffix2");
        test("\u045176null", "" + f_strU + sf_oNtS);
        test("\u045176nullsuffix", "" + f_strU + sf_oNtS + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + sf_oNtS + "suffix2");
        test("\u045176true", "" + f_strU + s_bl);
        test("\u045176truesuffix", "" + f_strU + s_bl + "suffix");
        test("prefix\u045176suffix1truesuffix2", "prefix" + f_strU + "suffix1" + s_bl + "suffix2");
        test("\u0451763900", "" + f_strU + s_s);
        test("\u0451763900suffix", "" + f_strU + s_s + "suffix");
        test("prefix\u045176suffix13900suffix2", "prefix" + f_strU + "suffix1" + s_s + "suffix2");
        test("\u045176null", "" + f_strU + sf_oN);
        test("\u045176nullsuffix", "" + f_strU + sf_oN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + sf_oN + "suffix2");
        test("\u04517694000000", "" + f_strU + f_I);
        test("\u04517694000000suffix", "" + f_strU + f_I + "suffix");
        test("prefix\u045176suffix194000000suffix2", "prefix" + f_strU + "suffix1" + f_I + "suffix2");
        test("\u045176null", "" + f_strU + f_IN);
        test("\u045176nullsuffix", "" + f_strU + f_IN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + f_IN + "suffix2");
        test("\u045176true", "" + f_strU + sf_bl);
        test("\u045176truesuffix", "" + f_strU + sf_bl + "suffix");
        test("prefix\u045176suffix1truesuffix2", "prefix" + f_strU + "suffix1" + sf_bl + "suffix2");
        test("\u0451765500", "" + f_strU + sf_s);
        test("\u0451765500suffix", "" + f_strU + sf_s + "suffix");
        test("prefix\u045176suffix15500suffix2", "prefix" + f_strU + "suffix1" + sf_s + "suffix2");
        test("\u045176-2900", "" + f_strU + s_sM);
        test("\u045176-2900suffix", "" + f_strU + s_sM + "suffix");
        test("prefix\u045176suffix1-2900suffix2", "prefix" + f_strU + "suffix1" + s_sM + "suffix2");
        test("\u045176-194313216", "" + f_strU + sf_l);
        test("\u045176-194313216suffix", "" + f_strU + sf_l + "suffix");
        test("prefix\u045176suffix1-194313216suffix2", "prefix" + f_strU + "suffix1" + sf_l + "suffix2");
        test("\u04517612", "" + f_strU + s_strU1);
        test("\u04517612suffix", "" + f_strU + s_strU1 + "suffix");
        test("prefix\u045176suffix112suffix2", "prefix" + f_strU + "suffix1" + s_strU1 + "suffix2");
        test("\u045176C(87)", "" + f_strU + sf_o);
        test("\u045176C(87)suffix", "" + f_strU + sf_o + "suffix");
        test("prefix\u045176suffix1C(87)suffix2", "prefix" + f_strU + "suffix1" + sf_o + "suffix2");
        test("\u04517691", "" + f_strU + s_strU2);
        test("\u04517691suffix", "" + f_strU + s_strU2 + "suffix");
        test("prefix\u045176suffix191suffix2", "prefix" + f_strU + "suffix1" + s_strU2 + "suffix2");
        test("\u04517621", "" + f_strU + f_strU1);
        test("\u04517621suffix", "" + f_strU + f_strU1 + "suffix");
        test("prefix\u045176suffix121suffix2", "prefix" + f_strU + "suffix1" + f_strU1 + "suffix2");
        test("\u04517618", "" + f_strU + f_strU2);
        test("\u04517618suffix", "" + f_strU + f_strU2 + "suffix");
        test("prefix\u045176suffix118suffix2", "prefix" + f_strU + "suffix1" + f_strU2 + "suffix2");
        test("\u045176null", "" + f_strU + f_iAN);
        test("\u045176nullsuffix", "" + f_strU + f_iAN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + f_iAN + "suffix2");
        test("\u045176null", "" + f_strU + s_oN);
        test("\u045176nullsuffix", "" + f_strU + s_oN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + s_oN + "suffix2");
        test("\u045176\u045180", "" + f_strU + s_strU);
        test("\u045176\u045180suffix", "" + f_strU + s_strU + "suffix");
        test("prefix\u045176suffix1\u045180suffix2", "prefix" + f_strU + "suffix1" + s_strU + "suffix2");
        test("\u045176C", "" + f_strU + sf_c);
        test("\u045176Csuffix", "" + f_strU + sf_c + "suffix");
        test("prefix\u045176suffix1Csuffix2", "prefix" + f_strU + "suffix1" + sf_c + "suffix2");
        test("\u04517675", "" + f_strU + sf_str);
        test("\u04517675suffix", "" + f_strU + sf_str + "suffix");
        test("prefix\u045176suffix175suffix2", "prefix" + f_strU + "suffix1" + sf_str + "suffix2");
        test("\u045176-43", "" + f_strU + s_bM);
        test("\u045176-43suffix", "" + f_strU + s_bM + "suffix");
        test("prefix\u045176suffix1-43suffix2", "prefix" + f_strU + "suffix1" + s_bM + "suffix2");
        test("\u04517680", "" + f_strU + sf_b);
        test("\u04517680suffix", "" + f_strU + sf_b + "suffix");
        test("prefix\u045176suffix180suffix2", "prefix" + f_strU + "suffix1" + sf_b + "suffix2");
        test("\u045176null", "" + f_strU + s_IN);
        test("\u045176nullsuffix", "" + f_strU + s_IN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + s_IN + "suffix2");
        test("\u045176-52.0", "" + f_strU + s_fM);
        test("\u045176-52.0suffix", "" + f_strU + s_fM + "suffix");
        test("prefix\u045176suffix1-52.0suffix2", "prefix" + f_strU + "suffix1" + s_fM + "suffix2");
        test("\u04517675000000", "" + f_strU + sf_i);
        test("\u04517675000000suffix", "" + f_strU + sf_i + "suffix");
        test("prefix\u045176suffix175000000suffix2", "prefix" + f_strU + "suffix1" + sf_i + "suffix2");
        test("\u04517644", "" + f_strU + f_b);
        test("\u04517644suffix", "" + f_strU + f_b + "suffix");
        test("prefix\u045176suffix144suffix2", "prefix" + f_strU + "suffix1" + f_b + "suffix2");
        test("\u045176-1705032704", "" + f_strU + sf_lM);
        test("\u045176-1705032704suffix", "" + f_strU + sf_lM + "suffix");
        test("prefix\u045176suffix1-1705032704suffix2", "prefix" + f_strU + "suffix1" + sf_lM + "suffix2");
        test("\u045176null", "" + f_strU + f_oAN);
        test("\u045176nullsuffix", "" + f_strU + f_oAN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + f_oAN + "suffix2");
        test("\u04517683.0", "" + f_strU + f_d);
        test("\u04517683.0suffix", "" + f_strU + f_d + "suffix");
        test("prefix\u045176suffix183.0suffix2", "prefix" + f_strU + "suffix1" + f_d + "suffix2");
        test("\u045176I", "" + f_strU + f_c);
        test("\u045176Isuffix", "" + f_strU + f_c + "suffix");
        test("prefix\u045176suffix1Isuffix2", "prefix" + f_strU + "suffix1" + f_c + "suffix2");
        test("\u04517694.0", "" + f_strU + f_f);
        test("\u04517694.0suffix", "" + f_strU + f_f + "suffix");
        test("prefix\u045176suffix194.0suffix2", "prefix" + f_strU + "suffix1" + f_f + "suffix2");
        test("\u04517612.0", "" + f_strU + sf_d);
        test("\u04517612.0suffix", "" + f_strU + sf_d + "suffix");
        test("prefix\u045176suffix112.0suffix2", "prefix" + f_strU + "suffix1" + sf_d + "suffix2");
        test("\u045176-99.0", "" + f_strU + f_dM);
        test("\u045176-99.0suffix", "" + f_strU + f_dM + "suffix");
        test("prefix\u045176suffix1-99.0suffix2", "prefix" + f_strU + "suffix1" + f_dM + "suffix2");
        test("\u04517617.0", "" + f_strU + sf_f);
        test("\u04517617.0suffix", "" + f_strU + sf_f + "suffix");
        test("prefix\u045176suffix117.0suffix2", "prefix" + f_strU + "suffix1" + sf_f + "suffix2");
        test("\u045176-84.0", "" + f_strU + sf_dM);
        test("\u045176-84.0suffix", "" + f_strU + sf_dM + "suffix");
        test("prefix\u045176suffix1-84.0suffix2", "prefix" + f_strU + "suffix1" + sf_dM + "suffix2");
        test("\u04517658000000", "" + f_strU + f_i);
        test("\u04517658000000suffix", "" + f_strU + f_i + "suffix");
        test("prefix\u045176suffix158000000suffix2", "prefix" + f_strU + "suffix1" + f_i + "suffix2");
        test("\u045176-55000000", "" + f_strU + f_iM);
        test("\u045176-55000000suffix", "" + f_strU + f_iM + "suffix");
        test("prefix\u045176suffix1-55000000suffix2", "prefix" + f_strU + "suffix1" + f_iM + "suffix2");
        test("\u0451761460392448", "" + f_strU + f_l);
        test("\u0451761460392448suffix", "" + f_strU + f_l + "suffix");
        test("prefix\u045176suffix11460392448suffix2", "prefix" + f_strU + "suffix1" + f_l + "suffix2");
        test("\u045176C(70)", "" + f_strU + f_o);
        test("\u045176C(70)suffix", "" + f_strU + f_o + "suffix");
        test("prefix\u045176suffix1C(70)suffix2", "prefix" + f_strU + "suffix1" + f_o + "suffix2");
        test("\u045176\u04511", "" + f_strU + sf_strU);
        test("\u045176\u04511suffix", "" + f_strU + sf_strU + "suffix");
        test("prefix\u045176suffix1\u04511suffix2", "prefix" + f_strU + "suffix1" + sf_strU + "suffix2");
        test("\u0451768000", "" + f_strU + f_s);
        test("\u0451768000suffix", "" + f_strU + f_s + "suffix");
        test("prefix\u045176suffix18000suffix2", "prefix" + f_strU + "suffix1" + f_s + "suffix2");
        test("\u04517618", "" + f_strU + s_str);
        test("\u04517618suffix", "" + f_strU + s_str + "suffix");
        test("prefix\u045176suffix118suffix2", "prefix" + f_strU + "suffix1" + s_str + "suffix2");
        test("\u045176-1000000", "" + f_strU + s_iM);
        test("\u045176-1000000suffix", "" + f_strU + s_iM + "suffix");
        test("prefix\u045176suffix1-1000000suffix2", "prefix" + f_strU + "suffix1" + s_iM + "suffix2");
        test("\u0451761000000", "" + f_strU + sf_I);
        test("\u0451761000000suffix", "" + f_strU + sf_I + "suffix");
        test("prefix\u045176suffix11000000suffix2", "prefix" + f_strU + "suffix1" + sf_I + "suffix2");
        test("\u045176null", "" + f_strU + f_oNtS);
        test("\u045176nullsuffix", "" + f_strU + f_oNtS + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + f_oNtS + "suffix2");
        test("\u045176false", "" + f_strU + f_bl);
        test("\u045176falsesuffix", "" + f_strU + f_bl + "suffix");
        test("prefix\u045176suffix1falsesuffix2", "prefix" + f_strU + "suffix1" + f_bl + "suffix2");
        test("\u045176null", "" + f_strU + sf_iAN);
        test("\u045176nullsuffix", "" + f_strU + sf_iAN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + sf_iAN + "suffix2");
        test("\u045176-2000000", "" + f_strU + sf_iM);
        test("\u045176-2000000suffix", "" + f_strU + sf_iM + "suffix");
        test("prefix\u045176suffix1-2000000suffix2", "prefix" + f_strU + "suffix1" + sf_iM + "suffix2");
        test("\u045176-820130816", "" + f_strU + f_lM);
        test("\u045176-820130816suffix", "" + f_strU + f_lM + "suffix");
        test("prefix\u045176suffix1-820130816suffix2", "prefix" + f_strU + "suffix1" + f_lM + "suffix2");
        test("\u045176null", "" + f_strU + sf_oAN);
        test("\u045176nullsuffix", "" + f_strU + sf_oAN + "suffix");
        test("prefix\u045176suffix1nullsuffix2", "prefix" + f_strU + "suffix1" + sf_oAN + "suffix2");
        test("\u04517625000000", "" + f_strU + s_I);
        test("\u04517625000000suffix", "" + f_strU + s_I + "suffix");
        test("prefix\u045176suffix125000000suffix2", "prefix" + f_strU + "suffix1" + s_I + "suffix2");
        test("92-96.0", "" + sf_strU2 + s_dM);
        test("92-96.0suffix", "" + sf_strU2 + s_dM + "suffix");
        test("prefix92suffix1-96.0suffix2", "prefix" + sf_strU2 + "suffix1" + s_dM + "suffix2");
        test("92null", "" + sf_strU2 + s_oNtS);
        test("92nullsuffix", "" + sf_strU2 + s_oNtS + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + s_oNtS + "suffix2");
        test("92\u045176", "" + sf_strU2 + f_strU);
        test("92\u045176suffix", "" + sf_strU2 + f_strU + "suffix");
        test("prefix92suffix1\u045176suffix2", "prefix" + sf_strU2 + "suffix1" + f_strU + "suffix2");
        test("9292", "" + sf_strU2 + sf_strU2);
        test("9292suffix", "" + sf_strU2 + sf_strU2 + "suffix");
        test("prefix92suffix192suffix2", "prefix" + sf_strU2 + "suffix1" + sf_strU2 + "suffix2");
        test("9251", "" + sf_strU2 + sf_strU1);
        test("9251suffix", "" + sf_strU2 + sf_strU1 + "suffix");
        test("prefix92suffix151suffix2", "prefix" + sf_strU2 + "suffix1" + sf_strU1 + "suffix2");
        test("92null", "" + sf_strU2 + s_iAN);
        test("92nullsuffix", "" + sf_strU2 + s_iAN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + s_iAN + "suffix2");
        test("92-54", "" + sf_strU2 + f_bM);
        test("92-54suffix", "" + sf_strU2 + f_bM + "suffix");
        test("prefix92suffix1-54suffix2", "prefix" + sf_strU2 + "suffix1" + f_bM + "suffix2");
        test("92-87.0", "" + sf_strU2 + f_fM);
        test("92-87.0suffix", "" + sf_strU2 + f_fM + "suffix");
        test("prefix92suffix1-87.0suffix2", "prefix" + sf_strU2 + "suffix1" + f_fM + "suffix2");
        test("92null", "" + sf_strU2 + s_oAN);
    }

    public void run1() {
        test("92nullsuffix", "" + sf_strU2 + s_oAN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + s_oAN + "suffix2");
        test("9219", "" + sf_strU2 + f_str);
        test("9219suffix", "" + sf_strU2 + f_str + "suffix");
        test("prefix92suffix119suffix2", "prefix" + sf_strU2 + "suffix1" + f_str + "suffix2");
        test("92-41", "" + sf_strU2 + sf_bM);
        test("92-41suffix", "" + sf_strU2 + sf_bM + "suffix");
        test("prefix92suffix1-41suffix2", "prefix" + sf_strU2 + "suffix1" + sf_bM + "suffix2");
        test("92null", "" + sf_strU2 + sf_IN);
        test("92nullsuffix", "" + sf_strU2 + sf_IN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + sf_IN + "suffix2");
        test("92T", "" + sf_strU2 + s_c);
        test("92Tsuffix", "" + sf_strU2 + s_c + "suffix");
        test("prefix92suffix1Tsuffix2", "prefix" + sf_strU2 + "suffix1" + s_c + "suffix2");
        test("92-42.0", "" + sf_strU2 + sf_fM);
        test("92-42.0suffix", "" + sf_strU2 + sf_fM + "suffix");
        test("prefix92suffix1-42.0suffix2", "prefix" + sf_strU2 + "suffix1" + sf_fM + "suffix2");
        test("9225", "" + sf_strU2 + s_b);
        test("9225suffix", "" + sf_strU2 + s_b + "suffix");
        test("prefix92suffix125suffix2", "prefix" + sf_strU2 + "suffix1" + s_b + "suffix2");
        test("92null", "" + sf_strU2 + f_oN);
        test("92nullsuffix", "" + sf_strU2 + f_oN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + f_oN + "suffix2");
        test("92-1410065408", "" + sf_strU2 + s_lM);
        test("92-1410065408suffix", "" + sf_strU2 + s_lM + "suffix");
        test("prefix92suffix1-1410065408suffix2", "prefix" + sf_strU2 + "suffix1" + s_lM + "suffix2");
        test("928.0", "" + sf_strU2 + s_d);
        test("928.0suffix", "" + sf_strU2 + s_d + "suffix");
        test("prefix92suffix18.0suffix2", "prefix" + sf_strU2 + "suffix1" + s_d + "suffix2");
        test("9255.0", "" + sf_strU2 + s_f);
        test("9255.0suffix", "" + sf_strU2 + s_f + "suffix");
        test("prefix92suffix155.0suffix2", "prefix" + sf_strU2 + "suffix1" + s_f + "suffix2");
        test("9297000000", "" + sf_strU2 + s_i);
        test("9297000000suffix", "" + sf_strU2 + s_i + "suffix");
        test("prefix92suffix197000000suffix2", "prefix" + sf_strU2 + "suffix1" + s_i + "suffix2");
        test("92-9900", "" + sf_strU2 + f_sM);
        test("92-9900suffix", "" + sf_strU2 + f_sM + "suffix");
        test("prefix92suffix1-9900suffix2", "prefix" + sf_strU2 + "suffix1" + f_sM + "suffix2");
        test("92935228928", "" + sf_strU2 + s_l);
        test("92935228928suffix", "" + sf_strU2 + s_l + "suffix");
        test("prefix92suffix1935228928suffix2", "prefix" + sf_strU2 + "suffix1" + s_l + "suffix2");
        test("92-8400", "" + sf_strU2 + sf_sM);
        test("92-8400suffix", "" + sf_strU2 + sf_sM + "suffix");
        test("prefix92suffix1-8400suffix2", "prefix" + sf_strU2 + "suffix1" + sf_sM + "suffix2");
        test("92C(82)", "" + sf_strU2 + s_o);
        test("92C(82)suffix", "" + sf_strU2 + s_o + "suffix");
        test("prefix92suffix1C(82)suffix2", "prefix" + sf_strU2 + "suffix1" + s_o + "suffix2");
        test("92null", "" + sf_strU2 + sf_oNtS);
        test("92nullsuffix", "" + sf_strU2 + sf_oNtS + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + sf_oNtS + "suffix2");
        test("92true", "" + sf_strU2 + s_bl);
        test("92truesuffix", "" + sf_strU2 + s_bl + "suffix");
        test("prefix92suffix1truesuffix2", "prefix" + sf_strU2 + "suffix1" + s_bl + "suffix2");
        test("923900", "" + sf_strU2 + s_s);
        test("923900suffix", "" + sf_strU2 + s_s + "suffix");
        test("prefix92suffix13900suffix2", "prefix" + sf_strU2 + "suffix1" + s_s + "suffix2");
        test("92null", "" + sf_strU2 + sf_oN);
        test("92nullsuffix", "" + sf_strU2 + sf_oN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + sf_oN + "suffix2");
        test("9294000000", "" + sf_strU2 + f_I);
        test("9294000000suffix", "" + sf_strU2 + f_I + "suffix");
        test("prefix92suffix194000000suffix2", "prefix" + sf_strU2 + "suffix1" + f_I + "suffix2");
        test("92null", "" + sf_strU2 + f_IN);
        test("92nullsuffix", "" + sf_strU2 + f_IN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + f_IN + "suffix2");
        test("92true", "" + sf_strU2 + sf_bl);
        test("92truesuffix", "" + sf_strU2 + sf_bl + "suffix");
        test("prefix92suffix1truesuffix2", "prefix" + sf_strU2 + "suffix1" + sf_bl + "suffix2");
        test("925500", "" + sf_strU2 + sf_s);
        test("925500suffix", "" + sf_strU2 + sf_s + "suffix");
        test("prefix92suffix15500suffix2", "prefix" + sf_strU2 + "suffix1" + sf_s + "suffix2");
        test("92-2900", "" + sf_strU2 + s_sM);
        test("92-2900suffix", "" + sf_strU2 + s_sM + "suffix");
        test("prefix92suffix1-2900suffix2", "prefix" + sf_strU2 + "suffix1" + s_sM + "suffix2");
        test("92-194313216", "" + sf_strU2 + sf_l);
        test("92-194313216suffix", "" + sf_strU2 + sf_l + "suffix");
        test("prefix92suffix1-194313216suffix2", "prefix" + sf_strU2 + "suffix1" + sf_l + "suffix2");
        test("9212", "" + sf_strU2 + s_strU1);
        test("9212suffix", "" + sf_strU2 + s_strU1 + "suffix");
        test("prefix92suffix112suffix2", "prefix" + sf_strU2 + "suffix1" + s_strU1 + "suffix2");
        test("92C(87)", "" + sf_strU2 + sf_o);
        test("92C(87)suffix", "" + sf_strU2 + sf_o + "suffix");
        test("prefix92suffix1C(87)suffix2", "prefix" + sf_strU2 + "suffix1" + sf_o + "suffix2");
        test("9291", "" + sf_strU2 + s_strU2);
        test("9291suffix", "" + sf_strU2 + s_strU2 + "suffix");
        test("prefix92suffix191suffix2", "prefix" + sf_strU2 + "suffix1" + s_strU2 + "suffix2");
        test("9221", "" + sf_strU2 + f_strU1);
        test("9221suffix", "" + sf_strU2 + f_strU1 + "suffix");
        test("prefix92suffix121suffix2", "prefix" + sf_strU2 + "suffix1" + f_strU1 + "suffix2");
        test("9218", "" + sf_strU2 + f_strU2);
        test("9218suffix", "" + sf_strU2 + f_strU2 + "suffix");
        test("prefix92suffix118suffix2", "prefix" + sf_strU2 + "suffix1" + f_strU2 + "suffix2");
        test("92null", "" + sf_strU2 + f_iAN);
        test("92nullsuffix", "" + sf_strU2 + f_iAN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + f_iAN + "suffix2");
        test("92null", "" + sf_strU2 + s_oN);
        test("92nullsuffix", "" + sf_strU2 + s_oN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + s_oN + "suffix2");
        test("92\u045180", "" + sf_strU2 + s_strU);
        test("92\u045180suffix", "" + sf_strU2 + s_strU + "suffix");
        test("prefix92suffix1\u045180suffix2", "prefix" + sf_strU2 + "suffix1" + s_strU + "suffix2");
        test("92C", "" + sf_strU2 + sf_c);
        test("92Csuffix", "" + sf_strU2 + sf_c + "suffix");
        test("prefix92suffix1Csuffix2", "prefix" + sf_strU2 + "suffix1" + sf_c + "suffix2");
        test("9275", "" + sf_strU2 + sf_str);
        test("9275suffix", "" + sf_strU2 + sf_str + "suffix");
        test("prefix92suffix175suffix2", "prefix" + sf_strU2 + "suffix1" + sf_str + "suffix2");
        test("92-43", "" + sf_strU2 + s_bM);
        test("92-43suffix", "" + sf_strU2 + s_bM + "suffix");
        test("prefix92suffix1-43suffix2", "prefix" + sf_strU2 + "suffix1" + s_bM + "suffix2");
        test("9280", "" + sf_strU2 + sf_b);
        test("9280suffix", "" + sf_strU2 + sf_b + "suffix");
        test("prefix92suffix180suffix2", "prefix" + sf_strU2 + "suffix1" + sf_b + "suffix2");
        test("92null", "" + sf_strU2 + s_IN);
        test("92nullsuffix", "" + sf_strU2 + s_IN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + s_IN + "suffix2");
        test("92-52.0", "" + sf_strU2 + s_fM);
        test("92-52.0suffix", "" + sf_strU2 + s_fM + "suffix");
        test("prefix92suffix1-52.0suffix2", "prefix" + sf_strU2 + "suffix1" + s_fM + "suffix2");
        test("9275000000", "" + sf_strU2 + sf_i);
        test("9275000000suffix", "" + sf_strU2 + sf_i + "suffix");
        test("prefix92suffix175000000suffix2", "prefix" + sf_strU2 + "suffix1" + sf_i + "suffix2");
        test("9244", "" + sf_strU2 + f_b);
        test("9244suffix", "" + sf_strU2 + f_b + "suffix");
        test("prefix92suffix144suffix2", "prefix" + sf_strU2 + "suffix1" + f_b + "suffix2");
        test("92-1705032704", "" + sf_strU2 + sf_lM);
        test("92-1705032704suffix", "" + sf_strU2 + sf_lM + "suffix");
        test("prefix92suffix1-1705032704suffix2", "prefix" + sf_strU2 + "suffix1" + sf_lM + "suffix2");
        test("92null", "" + sf_strU2 + f_oAN);
        test("92nullsuffix", "" + sf_strU2 + f_oAN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + f_oAN + "suffix2");
        test("9283.0", "" + sf_strU2 + f_d);
        test("9283.0suffix", "" + sf_strU2 + f_d + "suffix");
        test("prefix92suffix183.0suffix2", "prefix" + sf_strU2 + "suffix1" + f_d + "suffix2");
        test("92I", "" + sf_strU2 + f_c);
        test("92Isuffix", "" + sf_strU2 + f_c + "suffix");
        test("prefix92suffix1Isuffix2", "prefix" + sf_strU2 + "suffix1" + f_c + "suffix2");
        test("9294.0", "" + sf_strU2 + f_f);
        test("9294.0suffix", "" + sf_strU2 + f_f + "suffix");
        test("prefix92suffix194.0suffix2", "prefix" + sf_strU2 + "suffix1" + f_f + "suffix2");
        test("9212.0", "" + sf_strU2 + sf_d);
        test("9212.0suffix", "" + sf_strU2 + sf_d + "suffix");
        test("prefix92suffix112.0suffix2", "prefix" + sf_strU2 + "suffix1" + sf_d + "suffix2");
        test("92-99.0", "" + sf_strU2 + f_dM);
        test("92-99.0suffix", "" + sf_strU2 + f_dM + "suffix");
        test("prefix92suffix1-99.0suffix2", "prefix" + sf_strU2 + "suffix1" + f_dM + "suffix2");
        test("9217.0", "" + sf_strU2 + sf_f);
        test("9217.0suffix", "" + sf_strU2 + sf_f + "suffix");
        test("prefix92suffix117.0suffix2", "prefix" + sf_strU2 + "suffix1" + sf_f + "suffix2");
        test("92-84.0", "" + sf_strU2 + sf_dM);
        test("92-84.0suffix", "" + sf_strU2 + sf_dM + "suffix");
        test("prefix92suffix1-84.0suffix2", "prefix" + sf_strU2 + "suffix1" + sf_dM + "suffix2");
        test("9258000000", "" + sf_strU2 + f_i);
        test("9258000000suffix", "" + sf_strU2 + f_i + "suffix");
        test("prefix92suffix158000000suffix2", "prefix" + sf_strU2 + "suffix1" + f_i + "suffix2");
        test("92-55000000", "" + sf_strU2 + f_iM);
        test("92-55000000suffix", "" + sf_strU2 + f_iM + "suffix");
        test("prefix92suffix1-55000000suffix2", "prefix" + sf_strU2 + "suffix1" + f_iM + "suffix2");
        test("921460392448", "" + sf_strU2 + f_l);
        test("921460392448suffix", "" + sf_strU2 + f_l + "suffix");
        test("prefix92suffix11460392448suffix2", "prefix" + sf_strU2 + "suffix1" + f_l + "suffix2");
        test("92C(70)", "" + sf_strU2 + f_o);
        test("92C(70)suffix", "" + sf_strU2 + f_o + "suffix");
        test("prefix92suffix1C(70)suffix2", "prefix" + sf_strU2 + "suffix1" + f_o + "suffix2");
        test("92\u04511", "" + sf_strU2 + sf_strU);
        test("92\u04511suffix", "" + sf_strU2 + sf_strU + "suffix");
        test("prefix92suffix1\u04511suffix2", "prefix" + sf_strU2 + "suffix1" + sf_strU + "suffix2");
        test("928000", "" + sf_strU2 + f_s);
        test("928000suffix", "" + sf_strU2 + f_s + "suffix");
        test("prefix92suffix18000suffix2", "prefix" + sf_strU2 + "suffix1" + f_s + "suffix2");
        test("9218", "" + sf_strU2 + s_str);
        test("9218suffix", "" + sf_strU2 + s_str + "suffix");
        test("prefix92suffix118suffix2", "prefix" + sf_strU2 + "suffix1" + s_str + "suffix2");
        test("92-1000000", "" + sf_strU2 + s_iM);
        test("92-1000000suffix", "" + sf_strU2 + s_iM + "suffix");
        test("prefix92suffix1-1000000suffix2", "prefix" + sf_strU2 + "suffix1" + s_iM + "suffix2");
        test("921000000", "" + sf_strU2 + sf_I);
        test("921000000suffix", "" + sf_strU2 + sf_I + "suffix");
        test("prefix92suffix11000000suffix2", "prefix" + sf_strU2 + "suffix1" + sf_I + "suffix2");
        test("92null", "" + sf_strU2 + f_oNtS);
        test("92nullsuffix", "" + sf_strU2 + f_oNtS + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + f_oNtS + "suffix2");
        test("92false", "" + sf_strU2 + f_bl);
        test("92falsesuffix", "" + sf_strU2 + f_bl + "suffix");
        test("prefix92suffix1falsesuffix2", "prefix" + sf_strU2 + "suffix1" + f_bl + "suffix2");
        test("92null", "" + sf_strU2 + sf_iAN);
        test("92nullsuffix", "" + sf_strU2 + sf_iAN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + sf_iAN + "suffix2");
        test("92-2000000", "" + sf_strU2 + sf_iM);
        test("92-2000000suffix", "" + sf_strU2 + sf_iM + "suffix");
        test("prefix92suffix1-2000000suffix2", "prefix" + sf_strU2 + "suffix1" + sf_iM + "suffix2");
        test("92-820130816", "" + sf_strU2 + f_lM);
        test("92-820130816suffix", "" + sf_strU2 + f_lM + "suffix");
        test("prefix92suffix1-820130816suffix2", "prefix" + sf_strU2 + "suffix1" + f_lM + "suffix2");
        test("92null", "" + sf_strU2 + sf_oAN);
        test("92nullsuffix", "" + sf_strU2 + sf_oAN + "suffix");
        test("prefix92suffix1nullsuffix2", "prefix" + sf_strU2 + "suffix1" + sf_oAN + "suffix2");
        test("9225000000", "" + sf_strU2 + s_I);
        test("9225000000suffix", "" + sf_strU2 + s_I + "suffix");
        test("prefix92suffix125000000suffix2", "prefix" + sf_strU2 + "suffix1" + s_I + "suffix2");
        test("51-96.0", "" + sf_strU1 + s_dM);
        test("51-96.0suffix", "" + sf_strU1 + s_dM + "suffix");
        test("prefix51suffix1-96.0suffix2", "prefix" + sf_strU1 + "suffix1" + s_dM + "suffix2");
        test("51null", "" + sf_strU1 + s_oNtS);
        test("51nullsuffix", "" + sf_strU1 + s_oNtS + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + s_oNtS + "suffix2");
        test("51\u045176", "" + sf_strU1 + f_strU);
        test("51\u045176suffix", "" + sf_strU1 + f_strU + "suffix");
        test("prefix51suffix1\u045176suffix2", "prefix" + sf_strU1 + "suffix1" + f_strU + "suffix2");
        test("5192", "" + sf_strU1 + sf_strU2);
        test("5192suffix", "" + sf_strU1 + sf_strU2 + "suffix");
        test("prefix51suffix192suffix2", "prefix" + sf_strU1 + "suffix1" + sf_strU2 + "suffix2");
        test("5151", "" + sf_strU1 + sf_strU1);
        test("5151suffix", "" + sf_strU1 + sf_strU1 + "suffix");
        test("prefix51suffix151suffix2", "prefix" + sf_strU1 + "suffix1" + sf_strU1 + "suffix2");
        test("51null", "" + sf_strU1 + s_iAN);
        test("51nullsuffix", "" + sf_strU1 + s_iAN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + s_iAN + "suffix2");
        test("51-54", "" + sf_strU1 + f_bM);
        test("51-54suffix", "" + sf_strU1 + f_bM + "suffix");
        test("prefix51suffix1-54suffix2", "prefix" + sf_strU1 + "suffix1" + f_bM + "suffix2");
        test("51-87.0", "" + sf_strU1 + f_fM);
        test("51-87.0suffix", "" + sf_strU1 + f_fM + "suffix");
        test("prefix51suffix1-87.0suffix2", "prefix" + sf_strU1 + "suffix1" + f_fM + "suffix2");
        test("51null", "" + sf_strU1 + s_oAN);
        test("51nullsuffix", "" + sf_strU1 + s_oAN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + s_oAN + "suffix2");
        test("5119", "" + sf_strU1 + f_str);
        test("5119suffix", "" + sf_strU1 + f_str + "suffix");
        test("prefix51suffix119suffix2", "prefix" + sf_strU1 + "suffix1" + f_str + "suffix2");
        test("51-41", "" + sf_strU1 + sf_bM);
        test("51-41suffix", "" + sf_strU1 + sf_bM + "suffix");
        test("prefix51suffix1-41suffix2", "prefix" + sf_strU1 + "suffix1" + sf_bM + "suffix2");
        test("51null", "" + sf_strU1 + sf_IN);
        test("51nullsuffix", "" + sf_strU1 + sf_IN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + sf_IN + "suffix2");
        test("51T", "" + sf_strU1 + s_c);
        test("51Tsuffix", "" + sf_strU1 + s_c + "suffix");
        test("prefix51suffix1Tsuffix2", "prefix" + sf_strU1 + "suffix1" + s_c + "suffix2");
        test("51-42.0", "" + sf_strU1 + sf_fM);
        test("51-42.0suffix", "" + sf_strU1 + sf_fM + "suffix");
        test("prefix51suffix1-42.0suffix2", "prefix" + sf_strU1 + "suffix1" + sf_fM + "suffix2");
        test("5125", "" + sf_strU1 + s_b);
        test("5125suffix", "" + sf_strU1 + s_b + "suffix");
        test("prefix51suffix125suffix2", "prefix" + sf_strU1 + "suffix1" + s_b + "suffix2");
        test("51null", "" + sf_strU1 + f_oN);
        test("51nullsuffix", "" + sf_strU1 + f_oN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + f_oN + "suffix2");
        test("51-1410065408", "" + sf_strU1 + s_lM);
        test("51-1410065408suffix", "" + sf_strU1 + s_lM + "suffix");
        test("prefix51suffix1-1410065408suffix2", "prefix" + sf_strU1 + "suffix1" + s_lM + "suffix2");
        test("518.0", "" + sf_strU1 + s_d);
        test("518.0suffix", "" + sf_strU1 + s_d + "suffix");
        test("prefix51suffix18.0suffix2", "prefix" + sf_strU1 + "suffix1" + s_d + "suffix2");
        test("5155.0", "" + sf_strU1 + s_f);
        test("5155.0suffix", "" + sf_strU1 + s_f + "suffix");
        test("prefix51suffix155.0suffix2", "prefix" + sf_strU1 + "suffix1" + s_f + "suffix2");
        test("5197000000", "" + sf_strU1 + s_i);
        test("5197000000suffix", "" + sf_strU1 + s_i + "suffix");
        test("prefix51suffix197000000suffix2", "prefix" + sf_strU1 + "suffix1" + s_i + "suffix2");
        test("51-9900", "" + sf_strU1 + f_sM);
        test("51-9900suffix", "" + sf_strU1 + f_sM + "suffix");
        test("prefix51suffix1-9900suffix2", "prefix" + sf_strU1 + "suffix1" + f_sM + "suffix2");
        test("51935228928", "" + sf_strU1 + s_l);
        test("51935228928suffix", "" + sf_strU1 + s_l + "suffix");
        test("prefix51suffix1935228928suffix2", "prefix" + sf_strU1 + "suffix1" + s_l + "suffix2");
        test("51-8400", "" + sf_strU1 + sf_sM);
        test("51-8400suffix", "" + sf_strU1 + sf_sM + "suffix");
        test("prefix51suffix1-8400suffix2", "prefix" + sf_strU1 + "suffix1" + sf_sM + "suffix2");
        test("51C(82)", "" + sf_strU1 + s_o);
        test("51C(82)suffix", "" + sf_strU1 + s_o + "suffix");
        test("prefix51suffix1C(82)suffix2", "prefix" + sf_strU1 + "suffix1" + s_o + "suffix2");
        test("51null", "" + sf_strU1 + sf_oNtS);
        test("51nullsuffix", "" + sf_strU1 + sf_oNtS + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + sf_oNtS + "suffix2");
        test("51true", "" + sf_strU1 + s_bl);
        test("51truesuffix", "" + sf_strU1 + s_bl + "suffix");
        test("prefix51suffix1truesuffix2", "prefix" + sf_strU1 + "suffix1" + s_bl + "suffix2");
        test("513900", "" + sf_strU1 + s_s);
        test("513900suffix", "" + sf_strU1 + s_s + "suffix");
        test("prefix51suffix13900suffix2", "prefix" + sf_strU1 + "suffix1" + s_s + "suffix2");
        test("51null", "" + sf_strU1 + sf_oN);
        test("51nullsuffix", "" + sf_strU1 + sf_oN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + sf_oN + "suffix2");
        test("5194000000", "" + sf_strU1 + f_I);
        test("5194000000suffix", "" + sf_strU1 + f_I + "suffix");
        test("prefix51suffix194000000suffix2", "prefix" + sf_strU1 + "suffix1" + f_I + "suffix2");
        test("51null", "" + sf_strU1 + f_IN);
        test("51nullsuffix", "" + sf_strU1 + f_IN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + f_IN + "suffix2");
        test("51true", "" + sf_strU1 + sf_bl);
        test("51truesuffix", "" + sf_strU1 + sf_bl + "suffix");
        test("prefix51suffix1truesuffix2", "prefix" + sf_strU1 + "suffix1" + sf_bl + "suffix2");
        test("515500", "" + sf_strU1 + sf_s);
        test("515500suffix", "" + sf_strU1 + sf_s + "suffix");
        test("prefix51suffix15500suffix2", "prefix" + sf_strU1 + "suffix1" + sf_s + "suffix2");
        test("51-2900", "" + sf_strU1 + s_sM);
        test("51-2900suffix", "" + sf_strU1 + s_sM + "suffix");
        test("prefix51suffix1-2900suffix2", "prefix" + sf_strU1 + "suffix1" + s_sM + "suffix2");
        test("51-194313216", "" + sf_strU1 + sf_l);
        test("51-194313216suffix", "" + sf_strU1 + sf_l + "suffix");
        test("prefix51suffix1-194313216suffix2", "prefix" + sf_strU1 + "suffix1" + sf_l + "suffix2");
        test("5112", "" + sf_strU1 + s_strU1);
        test("5112suffix", "" + sf_strU1 + s_strU1 + "suffix");
        test("prefix51suffix112suffix2", "prefix" + sf_strU1 + "suffix1" + s_strU1 + "suffix2");
        test("51C(87)", "" + sf_strU1 + sf_o);
        test("51C(87)suffix", "" + sf_strU1 + sf_o + "suffix");
        test("prefix51suffix1C(87)suffix2", "prefix" + sf_strU1 + "suffix1" + sf_o + "suffix2");
        test("5191", "" + sf_strU1 + s_strU2);
        test("5191suffix", "" + sf_strU1 + s_strU2 + "suffix");
        test("prefix51suffix191suffix2", "prefix" + sf_strU1 + "suffix1" + s_strU2 + "suffix2");
        test("5121", "" + sf_strU1 + f_strU1);
        test("5121suffix", "" + sf_strU1 + f_strU1 + "suffix");
        test("prefix51suffix121suffix2", "prefix" + sf_strU1 + "suffix1" + f_strU1 + "suffix2");
        test("5118", "" + sf_strU1 + f_strU2);
        test("5118suffix", "" + sf_strU1 + f_strU2 + "suffix");
        test("prefix51suffix118suffix2", "prefix" + sf_strU1 + "suffix1" + f_strU2 + "suffix2");
        test("51null", "" + sf_strU1 + f_iAN);
        test("51nullsuffix", "" + sf_strU1 + f_iAN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + f_iAN + "suffix2");
        test("51null", "" + sf_strU1 + s_oN);
        test("51nullsuffix", "" + sf_strU1 + s_oN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + s_oN + "suffix2");
        test("51\u045180", "" + sf_strU1 + s_strU);
        test("51\u045180suffix", "" + sf_strU1 + s_strU + "suffix");
        test("prefix51suffix1\u045180suffix2", "prefix" + sf_strU1 + "suffix1" + s_strU + "suffix2");
        test("51C", "" + sf_strU1 + sf_c);
        test("51Csuffix", "" + sf_strU1 + sf_c + "suffix");
        test("prefix51suffix1Csuffix2", "prefix" + sf_strU1 + "suffix1" + sf_c + "suffix2");
        test("5175", "" + sf_strU1 + sf_str);
        test("5175suffix", "" + sf_strU1 + sf_str + "suffix");
        test("prefix51suffix175suffix2", "prefix" + sf_strU1 + "suffix1" + sf_str + "suffix2");
        test("51-43", "" + sf_strU1 + s_bM);
        test("51-43suffix", "" + sf_strU1 + s_bM + "suffix");
        test("prefix51suffix1-43suffix2", "prefix" + sf_strU1 + "suffix1" + s_bM + "suffix2");
        test("5180", "" + sf_strU1 + sf_b);
        test("5180suffix", "" + sf_strU1 + sf_b + "suffix");
        test("prefix51suffix180suffix2", "prefix" + sf_strU1 + "suffix1" + sf_b + "suffix2");
        test("51null", "" + sf_strU1 + s_IN);
        test("51nullsuffix", "" + sf_strU1 + s_IN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + s_IN + "suffix2");
        test("51-52.0", "" + sf_strU1 + s_fM);
        test("51-52.0suffix", "" + sf_strU1 + s_fM + "suffix");
        test("prefix51suffix1-52.0suffix2", "prefix" + sf_strU1 + "suffix1" + s_fM + "suffix2");
        test("5175000000", "" + sf_strU1 + sf_i);
        test("5175000000suffix", "" + sf_strU1 + sf_i + "suffix");
        test("prefix51suffix175000000suffix2", "prefix" + sf_strU1 + "suffix1" + sf_i + "suffix2");
        test("5144", "" + sf_strU1 + f_b);
        test("5144suffix", "" + sf_strU1 + f_b + "suffix");
        test("prefix51suffix144suffix2", "prefix" + sf_strU1 + "suffix1" + f_b + "suffix2");
        test("51-1705032704", "" + sf_strU1 + sf_lM);
        test("51-1705032704suffix", "" + sf_strU1 + sf_lM + "suffix");
        test("prefix51suffix1-1705032704suffix2", "prefix" + sf_strU1 + "suffix1" + sf_lM + "suffix2");
        test("51null", "" + sf_strU1 + f_oAN);
        test("51nullsuffix", "" + sf_strU1 + f_oAN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + f_oAN + "suffix2");
        test("5183.0", "" + sf_strU1 + f_d);
        test("5183.0suffix", "" + sf_strU1 + f_d + "suffix");
        test("prefix51suffix183.0suffix2", "prefix" + sf_strU1 + "suffix1" + f_d + "suffix2");
        test("51I", "" + sf_strU1 + f_c);
        test("51Isuffix", "" + sf_strU1 + f_c + "suffix");
        test("prefix51suffix1Isuffix2", "prefix" + sf_strU1 + "suffix1" + f_c + "suffix2");
        test("5194.0", "" + sf_strU1 + f_f);
        test("5194.0suffix", "" + sf_strU1 + f_f + "suffix");
        test("prefix51suffix194.0suffix2", "prefix" + sf_strU1 + "suffix1" + f_f + "suffix2");
        test("5112.0", "" + sf_strU1 + sf_d);
        test("5112.0suffix", "" + sf_strU1 + sf_d + "suffix");
        test("prefix51suffix112.0suffix2", "prefix" + sf_strU1 + "suffix1" + sf_d + "suffix2");
        test("51-99.0", "" + sf_strU1 + f_dM);
        test("51-99.0suffix", "" + sf_strU1 + f_dM + "suffix");
        test("prefix51suffix1-99.0suffix2", "prefix" + sf_strU1 + "suffix1" + f_dM + "suffix2");
        test("5117.0", "" + sf_strU1 + sf_f);
        test("5117.0suffix", "" + sf_strU1 + sf_f + "suffix");
        test("prefix51suffix117.0suffix2", "prefix" + sf_strU1 + "suffix1" + sf_f + "suffix2");
        test("51-84.0", "" + sf_strU1 + sf_dM);
        test("51-84.0suffix", "" + sf_strU1 + sf_dM + "suffix");
        test("prefix51suffix1-84.0suffix2", "prefix" + sf_strU1 + "suffix1" + sf_dM + "suffix2");
        test("5158000000", "" + sf_strU1 + f_i);
        test("5158000000suffix", "" + sf_strU1 + f_i + "suffix");
        test("prefix51suffix158000000suffix2", "prefix" + sf_strU1 + "suffix1" + f_i + "suffix2");
        test("51-55000000", "" + sf_strU1 + f_iM);
        test("51-55000000suffix", "" + sf_strU1 + f_iM + "suffix");
        test("prefix51suffix1-55000000suffix2", "prefix" + sf_strU1 + "suffix1" + f_iM + "suffix2");
        test("511460392448", "" + sf_strU1 + f_l);
        test("511460392448suffix", "" + sf_strU1 + f_l + "suffix");
        test("prefix51suffix11460392448suffix2", "prefix" + sf_strU1 + "suffix1" + f_l + "suffix2");
        test("51C(70)", "" + sf_strU1 + f_o);
        test("51C(70)suffix", "" + sf_strU1 + f_o + "suffix");
        test("prefix51suffix1C(70)suffix2", "prefix" + sf_strU1 + "suffix1" + f_o + "suffix2");
        test("51\u04511", "" + sf_strU1 + sf_strU);
        test("51\u04511suffix", "" + sf_strU1 + sf_strU + "suffix");
        test("prefix51suffix1\u04511suffix2", "prefix" + sf_strU1 + "suffix1" + sf_strU + "suffix2");
        test("518000", "" + sf_strU1 + f_s);
        test("518000suffix", "" + sf_strU1 + f_s + "suffix");
        test("prefix51suffix18000suffix2", "prefix" + sf_strU1 + "suffix1" + f_s + "suffix2");
        test("5118", "" + sf_strU1 + s_str);
        test("5118suffix", "" + sf_strU1 + s_str + "suffix");
        test("prefix51suffix118suffix2", "prefix" + sf_strU1 + "suffix1" + s_str + "suffix2");
        test("51-1000000", "" + sf_strU1 + s_iM);
        test("51-1000000suffix", "" + sf_strU1 + s_iM + "suffix");
        test("prefix51suffix1-1000000suffix2", "prefix" + sf_strU1 + "suffix1" + s_iM + "suffix2");
        test("511000000", "" + sf_strU1 + sf_I);
        test("511000000suffix", "" + sf_strU1 + sf_I + "suffix");
        test("prefix51suffix11000000suffix2", "prefix" + sf_strU1 + "suffix1" + sf_I + "suffix2");
        test("51null", "" + sf_strU1 + f_oNtS);
        test("51nullsuffix", "" + sf_strU1 + f_oNtS + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + f_oNtS + "suffix2");
        test("51false", "" + sf_strU1 + f_bl);
        test("51falsesuffix", "" + sf_strU1 + f_bl + "suffix");
        test("prefix51suffix1falsesuffix2", "prefix" + sf_strU1 + "suffix1" + f_bl + "suffix2");
        test("51null", "" + sf_strU1 + sf_iAN);
        test("51nullsuffix", "" + sf_strU1 + sf_iAN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + sf_iAN + "suffix2");
        test("51-2000000", "" + sf_strU1 + sf_iM);
        test("51-2000000suffix", "" + sf_strU1 + sf_iM + "suffix");
        test("prefix51suffix1-2000000suffix2", "prefix" + sf_strU1 + "suffix1" + sf_iM + "suffix2");
        test("51-820130816", "" + sf_strU1 + f_lM);
        test("51-820130816suffix", "" + sf_strU1 + f_lM + "suffix");
        test("prefix51suffix1-820130816suffix2", "prefix" + sf_strU1 + "suffix1" + f_lM + "suffix2");
        test("51null", "" + sf_strU1 + sf_oAN);
        test("51nullsuffix", "" + sf_strU1 + sf_oAN + "suffix");
        test("prefix51suffix1nullsuffix2", "prefix" + sf_strU1 + "suffix1" + sf_oAN + "suffix2");
        test("5125000000", "" + sf_strU1 + s_I);
        test("5125000000suffix", "" + sf_strU1 + s_I + "suffix");
        test("prefix51suffix125000000suffix2", "prefix" + sf_strU1 + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + s_iAN + s_dM);
        test("null-96.0suffix", "" + s_iAN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + s_iAN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + s_iAN + s_oNtS);
        test("nullnullsuffix", "" + s_iAN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + s_iAN + f_strU);
        test("null\u045176suffix", "" + s_iAN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + s_iAN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + s_iAN + sf_strU2);
        test("null92suffix", "" + s_iAN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + s_iAN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + s_iAN + sf_strU1);
        test("null51suffix", "" + s_iAN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + s_iAN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + s_iAN + s_iAN);
        test("nullnullsuffix", "" + s_iAN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + s_iAN + f_bM);
        test("null-54suffix", "" + s_iAN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + s_iAN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + s_iAN + f_fM);
        test("null-87.0suffix", "" + s_iAN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + s_iAN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + s_iAN + s_oAN);
        test("nullnullsuffix", "" + s_iAN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + s_iAN + f_str);
        test("null19suffix", "" + s_iAN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + s_iAN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + s_iAN + sf_bM);
        test("null-41suffix", "" + s_iAN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + s_iAN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + s_iAN + sf_IN);
        test("nullnullsuffix", "" + s_iAN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + s_iAN + s_c);
        test("nullTsuffix", "" + s_iAN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + s_iAN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + s_iAN + sf_fM);
        test("null-42.0suffix", "" + s_iAN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + s_iAN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + s_iAN + s_b);
        test("null25suffix", "" + s_iAN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + s_iAN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + s_iAN + f_oN);
        test("nullnullsuffix", "" + s_iAN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + s_iAN + s_lM);
        test("null-1410065408suffix", "" + s_iAN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + s_iAN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + s_iAN + s_d);
        test("null8.0suffix", "" + s_iAN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + s_iAN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + s_iAN + s_f);
        test("null55.0suffix", "" + s_iAN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + s_iAN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + s_iAN + s_i);
        test("null97000000suffix", "" + s_iAN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + s_iAN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + s_iAN + f_sM);
        test("null-9900suffix", "" + s_iAN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + s_iAN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + s_iAN + s_l);
        test("null935228928suffix", "" + s_iAN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + s_iAN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + s_iAN + sf_sM);
        test("null-8400suffix", "" + s_iAN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + s_iAN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + s_iAN + s_o);
        test("nullC(82)suffix", "" + s_iAN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + s_iAN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + s_iAN + sf_oNtS);
        test("nullnullsuffix", "" + s_iAN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + s_iAN + s_bl);
        test("nulltruesuffix", "" + s_iAN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_iAN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + s_iAN + s_s);
        test("null3900suffix", "" + s_iAN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + s_iAN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + s_iAN + sf_oN);
        test("nullnullsuffix", "" + s_iAN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + s_iAN + f_I);
        test("null94000000suffix", "" + s_iAN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + s_iAN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + s_iAN + f_IN);
        test("nullnullsuffix", "" + s_iAN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + s_iAN + sf_bl);
        test("nulltruesuffix", "" + s_iAN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_iAN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + s_iAN + sf_s);
        test("null5500suffix", "" + s_iAN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + s_iAN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + s_iAN + s_sM);
        test("null-2900suffix", "" + s_iAN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + s_iAN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + s_iAN + sf_l);
        test("null-194313216suffix", "" + s_iAN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + s_iAN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + s_iAN + s_strU1);
        test("null12suffix", "" + s_iAN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + s_iAN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + s_iAN + sf_o);
        test("nullC(87)suffix", "" + s_iAN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + s_iAN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + s_iAN + s_strU2);
        test("null91suffix", "" + s_iAN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + s_iAN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + s_iAN + f_strU1);
        test("null21suffix", "" + s_iAN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + s_iAN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + s_iAN + f_strU2);
        test("null18suffix", "" + s_iAN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_iAN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + s_iAN + f_iAN);
        test("nullnullsuffix", "" + s_iAN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + s_iAN + s_oN);
        test("nullnullsuffix", "" + s_iAN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + s_iAN + s_strU);
        test("null\u045180suffix", "" + s_iAN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + s_iAN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + s_iAN + sf_c);
        test("nullCsuffix", "" + s_iAN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + s_iAN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + s_iAN + sf_str);
        test("null75suffix", "" + s_iAN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + s_iAN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + s_iAN + s_bM);
        test("null-43suffix", "" + s_iAN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + s_iAN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + s_iAN + sf_b);
        test("null80suffix", "" + s_iAN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + s_iAN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + s_iAN + s_IN);
        test("nullnullsuffix", "" + s_iAN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + s_iAN + s_fM);
        test("null-52.0suffix", "" + s_iAN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + s_iAN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + s_iAN + sf_i);
        test("null75000000suffix", "" + s_iAN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + s_iAN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + s_iAN + f_b);
        test("null44suffix", "" + s_iAN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + s_iAN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + s_iAN + sf_lM);
        test("null-1705032704suffix", "" + s_iAN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + s_iAN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + s_iAN + f_oAN);
        test("nullnullsuffix", "" + s_iAN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + s_iAN + f_d);
        test("null83.0suffix", "" + s_iAN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + s_iAN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + s_iAN + f_c);
        test("nullIsuffix", "" + s_iAN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + s_iAN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + s_iAN + f_f);
        test("null94.0suffix", "" + s_iAN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + s_iAN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + s_iAN + sf_d);
        test("null12.0suffix", "" + s_iAN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + s_iAN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + s_iAN + f_dM);
        test("null-99.0suffix", "" + s_iAN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + s_iAN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + s_iAN + sf_f);
        test("null17.0suffix", "" + s_iAN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + s_iAN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + s_iAN + sf_dM);
        test("null-84.0suffix", "" + s_iAN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + s_iAN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + s_iAN + f_i);
        test("null58000000suffix", "" + s_iAN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + s_iAN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + s_iAN + f_iM);
        test("null-55000000suffix", "" + s_iAN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + s_iAN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + s_iAN + f_l);
        test("null1460392448suffix", "" + s_iAN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + s_iAN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + s_iAN + f_o);
        test("nullC(70)suffix", "" + s_iAN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + s_iAN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + s_iAN + sf_strU);
        test("null\u04511suffix", "" + s_iAN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + s_iAN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + s_iAN + f_s);
        test("null8000suffix", "" + s_iAN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + s_iAN + "suffix1" + f_s + "suffix2");
        test("null18", "" + s_iAN + s_str);
        test("null18suffix", "" + s_iAN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_iAN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + s_iAN + s_iM);
        test("null-1000000suffix", "" + s_iAN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + s_iAN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + s_iAN + sf_I);
        test("null1000000suffix", "" + s_iAN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + s_iAN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + s_iAN + f_oNtS);
        test("nullnullsuffix", "" + s_iAN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + s_iAN + f_bl);
        test("nullfalsesuffix", "" + s_iAN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + s_iAN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + s_iAN + sf_iAN);
        test("nullnullsuffix", "" + s_iAN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + s_iAN + sf_iM);
        test("null-2000000suffix", "" + s_iAN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + s_iAN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + s_iAN + f_lM);
        test("null-820130816suffix", "" + s_iAN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + s_iAN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + s_iAN + sf_oAN);
        test("nullnullsuffix", "" + s_iAN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_iAN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + s_iAN + s_I);
        test("null25000000suffix", "" + s_iAN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + s_iAN + "suffix1" + s_I + "suffix2");
        test("-54-96.0", "" + f_bM + s_dM);
        test("-54-96.0suffix", "" + f_bM + s_dM + "suffix");
        test("prefix-54suffix1-96.0suffix2", "prefix" + f_bM + "suffix1" + s_dM + "suffix2");
        test("-54null", "" + f_bM + s_oNtS);
        test("-54nullsuffix", "" + f_bM + s_oNtS + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + s_oNtS + "suffix2");
        test("-54\u045176", "" + f_bM + f_strU);
        test("-54\u045176suffix", "" + f_bM + f_strU + "suffix");
        test("prefix-54suffix1\u045176suffix2", "prefix" + f_bM + "suffix1" + f_strU + "suffix2");
        test("-5492", "" + f_bM + sf_strU2);
        test("-5492suffix", "" + f_bM + sf_strU2 + "suffix");
        test("prefix-54suffix192suffix2", "prefix" + f_bM + "suffix1" + sf_strU2 + "suffix2");
        test("-5451", "" + f_bM + sf_strU1);
        test("-5451suffix", "" + f_bM + sf_strU1 + "suffix");
        test("prefix-54suffix151suffix2", "prefix" + f_bM + "suffix1" + sf_strU1 + "suffix2");
        test("-54null", "" + f_bM + s_iAN);
        test("-54nullsuffix", "" + f_bM + s_iAN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + s_iAN + "suffix2");
        test("-54-54", "" + f_bM + f_bM);
        test("-54-54suffix", "" + f_bM + f_bM + "suffix");
        test("prefix-54suffix1-54suffix2", "prefix" + f_bM + "suffix1" + f_bM + "suffix2");
        test("-54-87.0", "" + f_bM + f_fM);
        test("-54-87.0suffix", "" + f_bM + f_fM + "suffix");
        test("prefix-54suffix1-87.0suffix2", "prefix" + f_bM + "suffix1" + f_fM + "suffix2");
        test("-54null", "" + f_bM + s_oAN);
        test("-54nullsuffix", "" + f_bM + s_oAN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + s_oAN + "suffix2");
        test("-5419", "" + f_bM + f_str);
        test("-5419suffix", "" + f_bM + f_str + "suffix");
        test("prefix-54suffix119suffix2", "prefix" + f_bM + "suffix1" + f_str + "suffix2");
        test("-54-41", "" + f_bM + sf_bM);
        test("-54-41suffix", "" + f_bM + sf_bM + "suffix");
        test("prefix-54suffix1-41suffix2", "prefix" + f_bM + "suffix1" + sf_bM + "suffix2");
        test("-54null", "" + f_bM + sf_IN);
        test("-54nullsuffix", "" + f_bM + sf_IN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + sf_IN + "suffix2");
        test("-54T", "" + f_bM + s_c);
        test("-54Tsuffix", "" + f_bM + s_c + "suffix");
        test("prefix-54suffix1Tsuffix2", "prefix" + f_bM + "suffix1" + s_c + "suffix2");
        test("-54-42.0", "" + f_bM + sf_fM);
        test("-54-42.0suffix", "" + f_bM + sf_fM + "suffix");
        test("prefix-54suffix1-42.0suffix2", "prefix" + f_bM + "suffix1" + sf_fM + "suffix2");
        test("-5425", "" + f_bM + s_b);
        test("-5425suffix", "" + f_bM + s_b + "suffix");
        test("prefix-54suffix125suffix2", "prefix" + f_bM + "suffix1" + s_b + "suffix2");
        test("-54null", "" + f_bM + f_oN);
        test("-54nullsuffix", "" + f_bM + f_oN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + f_oN + "suffix2");
        test("-54-1410065408", "" + f_bM + s_lM);
        test("-54-1410065408suffix", "" + f_bM + s_lM + "suffix");
        test("prefix-54suffix1-1410065408suffix2", "prefix" + f_bM + "suffix1" + s_lM + "suffix2");
        test("-548.0", "" + f_bM + s_d);
        test("-548.0suffix", "" + f_bM + s_d + "suffix");
        test("prefix-54suffix18.0suffix2", "prefix" + f_bM + "suffix1" + s_d + "suffix2");
        test("-5455.0", "" + f_bM + s_f);
        test("-5455.0suffix", "" + f_bM + s_f + "suffix");
        test("prefix-54suffix155.0suffix2", "prefix" + f_bM + "suffix1" + s_f + "suffix2");
        test("-5497000000", "" + f_bM + s_i);
        test("-5497000000suffix", "" + f_bM + s_i + "suffix");
        test("prefix-54suffix197000000suffix2", "prefix" + f_bM + "suffix1" + s_i + "suffix2");
        test("-54-9900", "" + f_bM + f_sM);
        test("-54-9900suffix", "" + f_bM + f_sM + "suffix");
        test("prefix-54suffix1-9900suffix2", "prefix" + f_bM + "suffix1" + f_sM + "suffix2");
        test("-54935228928", "" + f_bM + s_l);
        test("-54935228928suffix", "" + f_bM + s_l + "suffix");
        test("prefix-54suffix1935228928suffix2", "prefix" + f_bM + "suffix1" + s_l + "suffix2");
        test("-54-8400", "" + f_bM + sf_sM);
        test("-54-8400suffix", "" + f_bM + sf_sM + "suffix");
        test("prefix-54suffix1-8400suffix2", "prefix" + f_bM + "suffix1" + sf_sM + "suffix2");
        test("-54C(82)", "" + f_bM + s_o);
        test("-54C(82)suffix", "" + f_bM + s_o + "suffix");
        test("prefix-54suffix1C(82)suffix2", "prefix" + f_bM + "suffix1" + s_o + "suffix2");
        test("-54null", "" + f_bM + sf_oNtS);
        test("-54nullsuffix", "" + f_bM + sf_oNtS + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + sf_oNtS + "suffix2");
        test("-54true", "" + f_bM + s_bl);
        test("-54truesuffix", "" + f_bM + s_bl + "suffix");
        test("prefix-54suffix1truesuffix2", "prefix" + f_bM + "suffix1" + s_bl + "suffix2");
        test("-543900", "" + f_bM + s_s);
        test("-543900suffix", "" + f_bM + s_s + "suffix");
        test("prefix-54suffix13900suffix2", "prefix" + f_bM + "suffix1" + s_s + "suffix2");
        test("-54null", "" + f_bM + sf_oN);
        test("-54nullsuffix", "" + f_bM + sf_oN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + sf_oN + "suffix2");
        test("-5494000000", "" + f_bM + f_I);
        test("-5494000000suffix", "" + f_bM + f_I + "suffix");
        test("prefix-54suffix194000000suffix2", "prefix" + f_bM + "suffix1" + f_I + "suffix2");
        test("-54null", "" + f_bM + f_IN);
        test("-54nullsuffix", "" + f_bM + f_IN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + f_IN + "suffix2");
        test("-54true", "" + f_bM + sf_bl);
        test("-54truesuffix", "" + f_bM + sf_bl + "suffix");
        test("prefix-54suffix1truesuffix2", "prefix" + f_bM + "suffix1" + sf_bl + "suffix2");
        test("-545500", "" + f_bM + sf_s);
        test("-545500suffix", "" + f_bM + sf_s + "suffix");
        test("prefix-54suffix15500suffix2", "prefix" + f_bM + "suffix1" + sf_s + "suffix2");
        test("-54-2900", "" + f_bM + s_sM);
        test("-54-2900suffix", "" + f_bM + s_sM + "suffix");
        test("prefix-54suffix1-2900suffix2", "prefix" + f_bM + "suffix1" + s_sM + "suffix2");
        test("-54-194313216", "" + f_bM + sf_l);
        test("-54-194313216suffix", "" + f_bM + sf_l + "suffix");
        test("prefix-54suffix1-194313216suffix2", "prefix" + f_bM + "suffix1" + sf_l + "suffix2");
        test("-5412", "" + f_bM + s_strU1);
        test("-5412suffix", "" + f_bM + s_strU1 + "suffix");
        test("prefix-54suffix112suffix2", "prefix" + f_bM + "suffix1" + s_strU1 + "suffix2");
        test("-54C(87)", "" + f_bM + sf_o);
        test("-54C(87)suffix", "" + f_bM + sf_o + "suffix");
        test("prefix-54suffix1C(87)suffix2", "prefix" + f_bM + "suffix1" + sf_o + "suffix2");
        test("-5491", "" + f_bM + s_strU2);
        test("-5491suffix", "" + f_bM + s_strU2 + "suffix");
        test("prefix-54suffix191suffix2", "prefix" + f_bM + "suffix1" + s_strU2 + "suffix2");
        test("-5421", "" + f_bM + f_strU1);
        test("-5421suffix", "" + f_bM + f_strU1 + "suffix");
        test("prefix-54suffix121suffix2", "prefix" + f_bM + "suffix1" + f_strU1 + "suffix2");
        test("-5418", "" + f_bM + f_strU2);
        test("-5418suffix", "" + f_bM + f_strU2 + "suffix");
        test("prefix-54suffix118suffix2", "prefix" + f_bM + "suffix1" + f_strU2 + "suffix2");
        test("-54null", "" + f_bM + f_iAN);
        test("-54nullsuffix", "" + f_bM + f_iAN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + f_iAN + "suffix2");
        test("-54null", "" + f_bM + s_oN);
        test("-54nullsuffix", "" + f_bM + s_oN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + s_oN + "suffix2");
        test("-54\u045180", "" + f_bM + s_strU);
        test("-54\u045180suffix", "" + f_bM + s_strU + "suffix");
        test("prefix-54suffix1\u045180suffix2", "prefix" + f_bM + "suffix1" + s_strU + "suffix2");
        test("-54C", "" + f_bM + sf_c);
        test("-54Csuffix", "" + f_bM + sf_c + "suffix");
        test("prefix-54suffix1Csuffix2", "prefix" + f_bM + "suffix1" + sf_c + "suffix2");
        test("-5475", "" + f_bM + sf_str);
        test("-5475suffix", "" + f_bM + sf_str + "suffix");
        test("prefix-54suffix175suffix2", "prefix" + f_bM + "suffix1" + sf_str + "suffix2");
        test("-54-43", "" + f_bM + s_bM);
        test("-54-43suffix", "" + f_bM + s_bM + "suffix");
        test("prefix-54suffix1-43suffix2", "prefix" + f_bM + "suffix1" + s_bM + "suffix2");
        test("-5480", "" + f_bM + sf_b);
        test("-5480suffix", "" + f_bM + sf_b + "suffix");
        test("prefix-54suffix180suffix2", "prefix" + f_bM + "suffix1" + sf_b + "suffix2");
        test("-54null", "" + f_bM + s_IN);
        test("-54nullsuffix", "" + f_bM + s_IN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + s_IN + "suffix2");
        test("-54-52.0", "" + f_bM + s_fM);
        test("-54-52.0suffix", "" + f_bM + s_fM + "suffix");
        test("prefix-54suffix1-52.0suffix2", "prefix" + f_bM + "suffix1" + s_fM + "suffix2");
        test("-5475000000", "" + f_bM + sf_i);
        test("-5475000000suffix", "" + f_bM + sf_i + "suffix");
        test("prefix-54suffix175000000suffix2", "prefix" + f_bM + "suffix1" + sf_i + "suffix2");
        test("-5444", "" + f_bM + f_b);
        test("-5444suffix", "" + f_bM + f_b + "suffix");
        test("prefix-54suffix144suffix2", "prefix" + f_bM + "suffix1" + f_b + "suffix2");
        test("-54-1705032704", "" + f_bM + sf_lM);
        test("-54-1705032704suffix", "" + f_bM + sf_lM + "suffix");
        test("prefix-54suffix1-1705032704suffix2", "prefix" + f_bM + "suffix1" + sf_lM + "suffix2");
        test("-54null", "" + f_bM + f_oAN);
        test("-54nullsuffix", "" + f_bM + f_oAN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + f_oAN + "suffix2");
        test("-5483.0", "" + f_bM + f_d);
        test("-5483.0suffix", "" + f_bM + f_d + "suffix");
        test("prefix-54suffix183.0suffix2", "prefix" + f_bM + "suffix1" + f_d + "suffix2");
        test("-54I", "" + f_bM + f_c);
        test("-54Isuffix", "" + f_bM + f_c + "suffix");
        test("prefix-54suffix1Isuffix2", "prefix" + f_bM + "suffix1" + f_c + "suffix2");
        test("-5494.0", "" + f_bM + f_f);
        test("-5494.0suffix", "" + f_bM + f_f + "suffix");
        test("prefix-54suffix194.0suffix2", "prefix" + f_bM + "suffix1" + f_f + "suffix2");
        test("-5412.0", "" + f_bM + sf_d);
        test("-5412.0suffix", "" + f_bM + sf_d + "suffix");
        test("prefix-54suffix112.0suffix2", "prefix" + f_bM + "suffix1" + sf_d + "suffix2");
        test("-54-99.0", "" + f_bM + f_dM);
        test("-54-99.0suffix", "" + f_bM + f_dM + "suffix");
        test("prefix-54suffix1-99.0suffix2", "prefix" + f_bM + "suffix1" + f_dM + "suffix2");
        test("-5417.0", "" + f_bM + sf_f);
        test("-5417.0suffix", "" + f_bM + sf_f + "suffix");
        test("prefix-54suffix117.0suffix2", "prefix" + f_bM + "suffix1" + sf_f + "suffix2");
        test("-54-84.0", "" + f_bM + sf_dM);
        test("-54-84.0suffix", "" + f_bM + sf_dM + "suffix");
        test("prefix-54suffix1-84.0suffix2", "prefix" + f_bM + "suffix1" + sf_dM + "suffix2");
        test("-5458000000", "" + f_bM + f_i);
        test("-5458000000suffix", "" + f_bM + f_i + "suffix");
        test("prefix-54suffix158000000suffix2", "prefix" + f_bM + "suffix1" + f_i + "suffix2");
        test("-54-55000000", "" + f_bM + f_iM);
        test("-54-55000000suffix", "" + f_bM + f_iM + "suffix");
        test("prefix-54suffix1-55000000suffix2", "prefix" + f_bM + "suffix1" + f_iM + "suffix2");
        test("-541460392448", "" + f_bM + f_l);
        test("-541460392448suffix", "" + f_bM + f_l + "suffix");
        test("prefix-54suffix11460392448suffix2", "prefix" + f_bM + "suffix1" + f_l + "suffix2");
        test("-54C(70)", "" + f_bM + f_o);
        test("-54C(70)suffix", "" + f_bM + f_o + "suffix");
        test("prefix-54suffix1C(70)suffix2", "prefix" + f_bM + "suffix1" + f_o + "suffix2");
        test("-54\u04511", "" + f_bM + sf_strU);
        test("-54\u04511suffix", "" + f_bM + sf_strU + "suffix");
        test("prefix-54suffix1\u04511suffix2", "prefix" + f_bM + "suffix1" + sf_strU + "suffix2");
        test("-548000", "" + f_bM + f_s);
        test("-548000suffix", "" + f_bM + f_s + "suffix");
        test("prefix-54suffix18000suffix2", "prefix" + f_bM + "suffix1" + f_s + "suffix2");
        test("-5418", "" + f_bM + s_str);
        test("-5418suffix", "" + f_bM + s_str + "suffix");
        test("prefix-54suffix118suffix2", "prefix" + f_bM + "suffix1" + s_str + "suffix2");
        test("-54-1000000", "" + f_bM + s_iM);
        test("-54-1000000suffix", "" + f_bM + s_iM + "suffix");
        test("prefix-54suffix1-1000000suffix2", "prefix" + f_bM + "suffix1" + s_iM + "suffix2");
        test("-541000000", "" + f_bM + sf_I);
        test("-541000000suffix", "" + f_bM + sf_I + "suffix");
        test("prefix-54suffix11000000suffix2", "prefix" + f_bM + "suffix1" + sf_I + "suffix2");
        test("-54null", "" + f_bM + f_oNtS);
        test("-54nullsuffix", "" + f_bM + f_oNtS + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + f_oNtS + "suffix2");
        test("-54false", "" + f_bM + f_bl);
        test("-54falsesuffix", "" + f_bM + f_bl + "suffix");
        test("prefix-54suffix1falsesuffix2", "prefix" + f_bM + "suffix1" + f_bl + "suffix2");
        test("-54null", "" + f_bM + sf_iAN);
        test("-54nullsuffix", "" + f_bM + sf_iAN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + sf_iAN + "suffix2");
        test("-54-2000000", "" + f_bM + sf_iM);
        test("-54-2000000suffix", "" + f_bM + sf_iM + "suffix");
        test("prefix-54suffix1-2000000suffix2", "prefix" + f_bM + "suffix1" + sf_iM + "suffix2");
        test("-54-820130816", "" + f_bM + f_lM);
        test("-54-820130816suffix", "" + f_bM + f_lM + "suffix");
        test("prefix-54suffix1-820130816suffix2", "prefix" + f_bM + "suffix1" + f_lM + "suffix2");
        test("-54null", "" + f_bM + sf_oAN);
        test("-54nullsuffix", "" + f_bM + sf_oAN + "suffix");
        test("prefix-54suffix1nullsuffix2", "prefix" + f_bM + "suffix1" + sf_oAN + "suffix2");
        test("-5425000000", "" + f_bM + s_I);
        test("-5425000000suffix", "" + f_bM + s_I + "suffix");
        test("prefix-54suffix125000000suffix2", "prefix" + f_bM + "suffix1" + s_I + "suffix2");
        test("-87.0-96.0", "" + f_fM + s_dM);
        test("-87.0-96.0suffix", "" + f_fM + s_dM + "suffix");
        test("prefix-87.0suffix1-96.0suffix2", "prefix" + f_fM + "suffix1" + s_dM + "suffix2");
        test("-87.0null", "" + f_fM + s_oNtS);
        test("-87.0nullsuffix", "" + f_fM + s_oNtS + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + s_oNtS + "suffix2");
        test("-87.0\u045176", "" + f_fM + f_strU);
        test("-87.0\u045176suffix", "" + f_fM + f_strU + "suffix");
        test("prefix-87.0suffix1\u045176suffix2", "prefix" + f_fM + "suffix1" + f_strU + "suffix2");
        test("-87.092", "" + f_fM + sf_strU2);
        test("-87.092suffix", "" + f_fM + sf_strU2 + "suffix");
        test("prefix-87.0suffix192suffix2", "prefix" + f_fM + "suffix1" + sf_strU2 + "suffix2");
        test("-87.051", "" + f_fM + sf_strU1);
        test("-87.051suffix", "" + f_fM + sf_strU1 + "suffix");
        test("prefix-87.0suffix151suffix2", "prefix" + f_fM + "suffix1" + sf_strU1 + "suffix2");
        test("-87.0null", "" + f_fM + s_iAN);
        test("-87.0nullsuffix", "" + f_fM + s_iAN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + s_iAN + "suffix2");
        test("-87.0-54", "" + f_fM + f_bM);
        test("-87.0-54suffix", "" + f_fM + f_bM + "suffix");
        test("prefix-87.0suffix1-54suffix2", "prefix" + f_fM + "suffix1" + f_bM + "suffix2");
        test("-87.0-87.0", "" + f_fM + f_fM);
        test("-87.0-87.0suffix", "" + f_fM + f_fM + "suffix");
        test("prefix-87.0suffix1-87.0suffix2", "prefix" + f_fM + "suffix1" + f_fM + "suffix2");
        test("-87.0null", "" + f_fM + s_oAN);
        test("-87.0nullsuffix", "" + f_fM + s_oAN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + s_oAN + "suffix2");
        test("-87.019", "" + f_fM + f_str);
        test("-87.019suffix", "" + f_fM + f_str + "suffix");
        test("prefix-87.0suffix119suffix2", "prefix" + f_fM + "suffix1" + f_str + "suffix2");
        test("-87.0-41", "" + f_fM + sf_bM);
        test("-87.0-41suffix", "" + f_fM + sf_bM + "suffix");
        test("prefix-87.0suffix1-41suffix2", "prefix" + f_fM + "suffix1" + sf_bM + "suffix2");
        test("-87.0null", "" + f_fM + sf_IN);
        test("-87.0nullsuffix", "" + f_fM + sf_IN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + sf_IN + "suffix2");
        test("-87.0T", "" + f_fM + s_c);
        test("-87.0Tsuffix", "" + f_fM + s_c + "suffix");
        test("prefix-87.0suffix1Tsuffix2", "prefix" + f_fM + "suffix1" + s_c + "suffix2");
        test("-87.0-42.0", "" + f_fM + sf_fM);
        test("-87.0-42.0suffix", "" + f_fM + sf_fM + "suffix");
        test("prefix-87.0suffix1-42.0suffix2", "prefix" + f_fM + "suffix1" + sf_fM + "suffix2");
        test("-87.025", "" + f_fM + s_b);
        test("-87.025suffix", "" + f_fM + s_b + "suffix");
        test("prefix-87.0suffix125suffix2", "prefix" + f_fM + "suffix1" + s_b + "suffix2");
        test("-87.0null", "" + f_fM + f_oN);
        test("-87.0nullsuffix", "" + f_fM + f_oN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + f_oN + "suffix2");
        test("-87.0-1410065408", "" + f_fM + s_lM);
        test("-87.0-1410065408suffix", "" + f_fM + s_lM + "suffix");
        test("prefix-87.0suffix1-1410065408suffix2", "prefix" + f_fM + "suffix1" + s_lM + "suffix2");
        test("-87.08.0", "" + f_fM + s_d);
        test("-87.08.0suffix", "" + f_fM + s_d + "suffix");
        test("prefix-87.0suffix18.0suffix2", "prefix" + f_fM + "suffix1" + s_d + "suffix2");
        test("-87.055.0", "" + f_fM + s_f);
        test("-87.055.0suffix", "" + f_fM + s_f + "suffix");
        test("prefix-87.0suffix155.0suffix2", "prefix" + f_fM + "suffix1" + s_f + "suffix2");
        test("-87.097000000", "" + f_fM + s_i);
        test("-87.097000000suffix", "" + f_fM + s_i + "suffix");
        test("prefix-87.0suffix197000000suffix2", "prefix" + f_fM + "suffix1" + s_i + "suffix2");
        test("-87.0-9900", "" + f_fM + f_sM);
        test("-87.0-9900suffix", "" + f_fM + f_sM + "suffix");
        test("prefix-87.0suffix1-9900suffix2", "prefix" + f_fM + "suffix1" + f_sM + "suffix2");
        test("-87.0935228928", "" + f_fM + s_l);
        test("-87.0935228928suffix", "" + f_fM + s_l + "suffix");
        test("prefix-87.0suffix1935228928suffix2", "prefix" + f_fM + "suffix1" + s_l + "suffix2");
        test("-87.0-8400", "" + f_fM + sf_sM);
        test("-87.0-8400suffix", "" + f_fM + sf_sM + "suffix");
        test("prefix-87.0suffix1-8400suffix2", "prefix" + f_fM + "suffix1" + sf_sM + "suffix2");
        test("-87.0C(82)", "" + f_fM + s_o);
        test("-87.0C(82)suffix", "" + f_fM + s_o + "suffix");
        test("prefix-87.0suffix1C(82)suffix2", "prefix" + f_fM + "suffix1" + s_o + "suffix2");
        test("-87.0null", "" + f_fM + sf_oNtS);
        test("-87.0nullsuffix", "" + f_fM + sf_oNtS + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + sf_oNtS + "suffix2");
        test("-87.0true", "" + f_fM + s_bl);
        test("-87.0truesuffix", "" + f_fM + s_bl + "suffix");
        test("prefix-87.0suffix1truesuffix2", "prefix" + f_fM + "suffix1" + s_bl + "suffix2");
        test("-87.03900", "" + f_fM + s_s);
        test("-87.03900suffix", "" + f_fM + s_s + "suffix");
        test("prefix-87.0suffix13900suffix2", "prefix" + f_fM + "suffix1" + s_s + "suffix2");
        test("-87.0null", "" + f_fM + sf_oN);
        test("-87.0nullsuffix", "" + f_fM + sf_oN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + sf_oN + "suffix2");
        test("-87.094000000", "" + f_fM + f_I);
        test("-87.094000000suffix", "" + f_fM + f_I + "suffix");
        test("prefix-87.0suffix194000000suffix2", "prefix" + f_fM + "suffix1" + f_I + "suffix2");
        test("-87.0null", "" + f_fM + f_IN);
        test("-87.0nullsuffix", "" + f_fM + f_IN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + f_IN + "suffix2");
        test("-87.0true", "" + f_fM + sf_bl);
        test("-87.0truesuffix", "" + f_fM + sf_bl + "suffix");
        test("prefix-87.0suffix1truesuffix2", "prefix" + f_fM + "suffix1" + sf_bl + "suffix2");
        test("-87.05500", "" + f_fM + sf_s);
        test("-87.05500suffix", "" + f_fM + sf_s + "suffix");
        test("prefix-87.0suffix15500suffix2", "prefix" + f_fM + "suffix1" + sf_s + "suffix2");
        test("-87.0-2900", "" + f_fM + s_sM);
        test("-87.0-2900suffix", "" + f_fM + s_sM + "suffix");
        test("prefix-87.0suffix1-2900suffix2", "prefix" + f_fM + "suffix1" + s_sM + "suffix2");
        test("-87.0-194313216", "" + f_fM + sf_l);
        test("-87.0-194313216suffix", "" + f_fM + sf_l + "suffix");
        test("prefix-87.0suffix1-194313216suffix2", "prefix" + f_fM + "suffix1" + sf_l + "suffix2");
        test("-87.012", "" + f_fM + s_strU1);
        test("-87.012suffix", "" + f_fM + s_strU1 + "suffix");
        test("prefix-87.0suffix112suffix2", "prefix" + f_fM + "suffix1" + s_strU1 + "suffix2");
        test("-87.0C(87)", "" + f_fM + sf_o);
        test("-87.0C(87)suffix", "" + f_fM + sf_o + "suffix");
        test("prefix-87.0suffix1C(87)suffix2", "prefix" + f_fM + "suffix1" + sf_o + "suffix2");
        test("-87.091", "" + f_fM + s_strU2);
        test("-87.091suffix", "" + f_fM + s_strU2 + "suffix");
        test("prefix-87.0suffix191suffix2", "prefix" + f_fM + "suffix1" + s_strU2 + "suffix2");
        test("-87.021", "" + f_fM + f_strU1);
        test("-87.021suffix", "" + f_fM + f_strU1 + "suffix");
        test("prefix-87.0suffix121suffix2", "prefix" + f_fM + "suffix1" + f_strU1 + "suffix2");
        test("-87.018", "" + f_fM + f_strU2);
        test("-87.018suffix", "" + f_fM + f_strU2 + "suffix");
        test("prefix-87.0suffix118suffix2", "prefix" + f_fM + "suffix1" + f_strU2 + "suffix2");
        test("-87.0null", "" + f_fM + f_iAN);
        test("-87.0nullsuffix", "" + f_fM + f_iAN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + f_iAN + "suffix2");
        test("-87.0null", "" + f_fM + s_oN);
        test("-87.0nullsuffix", "" + f_fM + s_oN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + s_oN + "suffix2");
        test("-87.0\u045180", "" + f_fM + s_strU);
        test("-87.0\u045180suffix", "" + f_fM + s_strU + "suffix");
    }

    public void run2() {
        test("prefix-87.0suffix1\u045180suffix2", "prefix" + f_fM + "suffix1" + s_strU + "suffix2");
        test("-87.0C", "" + f_fM + sf_c);
        test("-87.0Csuffix", "" + f_fM + sf_c + "suffix");
        test("prefix-87.0suffix1Csuffix2", "prefix" + f_fM + "suffix1" + sf_c + "suffix2");
        test("-87.075", "" + f_fM + sf_str);
        test("-87.075suffix", "" + f_fM + sf_str + "suffix");
        test("prefix-87.0suffix175suffix2", "prefix" + f_fM + "suffix1" + sf_str + "suffix2");
        test("-87.0-43", "" + f_fM + s_bM);
        test("-87.0-43suffix", "" + f_fM + s_bM + "suffix");
        test("prefix-87.0suffix1-43suffix2", "prefix" + f_fM + "suffix1" + s_bM + "suffix2");
        test("-87.080", "" + f_fM + sf_b);
        test("-87.080suffix", "" + f_fM + sf_b + "suffix");
        test("prefix-87.0suffix180suffix2", "prefix" + f_fM + "suffix1" + sf_b + "suffix2");
        test("-87.0null", "" + f_fM + s_IN);
        test("-87.0nullsuffix", "" + f_fM + s_IN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + s_IN + "suffix2");
        test("-87.0-52.0", "" + f_fM + s_fM);
        test("-87.0-52.0suffix", "" + f_fM + s_fM + "suffix");
        test("prefix-87.0suffix1-52.0suffix2", "prefix" + f_fM + "suffix1" + s_fM + "suffix2");
        test("-87.075000000", "" + f_fM + sf_i);
        test("-87.075000000suffix", "" + f_fM + sf_i + "suffix");
        test("prefix-87.0suffix175000000suffix2", "prefix" + f_fM + "suffix1" + sf_i + "suffix2");
        test("-87.044", "" + f_fM + f_b);
        test("-87.044suffix", "" + f_fM + f_b + "suffix");
        test("prefix-87.0suffix144suffix2", "prefix" + f_fM + "suffix1" + f_b + "suffix2");
        test("-87.0-1705032704", "" + f_fM + sf_lM);
        test("-87.0-1705032704suffix", "" + f_fM + sf_lM + "suffix");
        test("prefix-87.0suffix1-1705032704suffix2", "prefix" + f_fM + "suffix1" + sf_lM + "suffix2");
        test("-87.0null", "" + f_fM + f_oAN);
        test("-87.0nullsuffix", "" + f_fM + f_oAN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + f_oAN + "suffix2");
        test("-87.083.0", "" + f_fM + f_d);
        test("-87.083.0suffix", "" + f_fM + f_d + "suffix");
        test("prefix-87.0suffix183.0suffix2", "prefix" + f_fM + "suffix1" + f_d + "suffix2");
        test("-87.0I", "" + f_fM + f_c);
        test("-87.0Isuffix", "" + f_fM + f_c + "suffix");
        test("prefix-87.0suffix1Isuffix2", "prefix" + f_fM + "suffix1" + f_c + "suffix2");
        test("-87.094.0", "" + f_fM + f_f);
        test("-87.094.0suffix", "" + f_fM + f_f + "suffix");
        test("prefix-87.0suffix194.0suffix2", "prefix" + f_fM + "suffix1" + f_f + "suffix2");
        test("-87.012.0", "" + f_fM + sf_d);
        test("-87.012.0suffix", "" + f_fM + sf_d + "suffix");
        test("prefix-87.0suffix112.0suffix2", "prefix" + f_fM + "suffix1" + sf_d + "suffix2");
        test("-87.0-99.0", "" + f_fM + f_dM);
        test("-87.0-99.0suffix", "" + f_fM + f_dM + "suffix");
        test("prefix-87.0suffix1-99.0suffix2", "prefix" + f_fM + "suffix1" + f_dM + "suffix2");
        test("-87.017.0", "" + f_fM + sf_f);
        test("-87.017.0suffix", "" + f_fM + sf_f + "suffix");
        test("prefix-87.0suffix117.0suffix2", "prefix" + f_fM + "suffix1" + sf_f + "suffix2");
        test("-87.0-84.0", "" + f_fM + sf_dM);
        test("-87.0-84.0suffix", "" + f_fM + sf_dM + "suffix");
        test("prefix-87.0suffix1-84.0suffix2", "prefix" + f_fM + "suffix1" + sf_dM + "suffix2");
        test("-87.058000000", "" + f_fM + f_i);
        test("-87.058000000suffix", "" + f_fM + f_i + "suffix");
        test("prefix-87.0suffix158000000suffix2", "prefix" + f_fM + "suffix1" + f_i + "suffix2");
        test("-87.0-55000000", "" + f_fM + f_iM);
        test("-87.0-55000000suffix", "" + f_fM + f_iM + "suffix");
        test("prefix-87.0suffix1-55000000suffix2", "prefix" + f_fM + "suffix1" + f_iM + "suffix2");
        test("-87.01460392448", "" + f_fM + f_l);
        test("-87.01460392448suffix", "" + f_fM + f_l + "suffix");
        test("prefix-87.0suffix11460392448suffix2", "prefix" + f_fM + "suffix1" + f_l + "suffix2");
        test("-87.0C(70)", "" + f_fM + f_o);
        test("-87.0C(70)suffix", "" + f_fM + f_o + "suffix");
        test("prefix-87.0suffix1C(70)suffix2", "prefix" + f_fM + "suffix1" + f_o + "suffix2");
        test("-87.0\u04511", "" + f_fM + sf_strU);
        test("-87.0\u04511suffix", "" + f_fM + sf_strU + "suffix");
        test("prefix-87.0suffix1\u04511suffix2", "prefix" + f_fM + "suffix1" + sf_strU + "suffix2");
        test("-87.08000", "" + f_fM + f_s);
        test("-87.08000suffix", "" + f_fM + f_s + "suffix");
        test("prefix-87.0suffix18000suffix2", "prefix" + f_fM + "suffix1" + f_s + "suffix2");
        test("-87.018", "" + f_fM + s_str);
        test("-87.018suffix", "" + f_fM + s_str + "suffix");
        test("prefix-87.0suffix118suffix2", "prefix" + f_fM + "suffix1" + s_str + "suffix2");
        test("-87.0-1000000", "" + f_fM + s_iM);
        test("-87.0-1000000suffix", "" + f_fM + s_iM + "suffix");
        test("prefix-87.0suffix1-1000000suffix2", "prefix" + f_fM + "suffix1" + s_iM + "suffix2");
        test("-87.01000000", "" + f_fM + sf_I);
        test("-87.01000000suffix", "" + f_fM + sf_I + "suffix");
        test("prefix-87.0suffix11000000suffix2", "prefix" + f_fM + "suffix1" + sf_I + "suffix2");
        test("-87.0null", "" + f_fM + f_oNtS);
        test("-87.0nullsuffix", "" + f_fM + f_oNtS + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + f_oNtS + "suffix2");
        test("-87.0false", "" + f_fM + f_bl);
        test("-87.0falsesuffix", "" + f_fM + f_bl + "suffix");
        test("prefix-87.0suffix1falsesuffix2", "prefix" + f_fM + "suffix1" + f_bl + "suffix2");
        test("-87.0null", "" + f_fM + sf_iAN);
        test("-87.0nullsuffix", "" + f_fM + sf_iAN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + sf_iAN + "suffix2");
        test("-87.0-2000000", "" + f_fM + sf_iM);
        test("-87.0-2000000suffix", "" + f_fM + sf_iM + "suffix");
        test("prefix-87.0suffix1-2000000suffix2", "prefix" + f_fM + "suffix1" + sf_iM + "suffix2");
        test("-87.0-820130816", "" + f_fM + f_lM);
        test("-87.0-820130816suffix", "" + f_fM + f_lM + "suffix");
        test("prefix-87.0suffix1-820130816suffix2", "prefix" + f_fM + "suffix1" + f_lM + "suffix2");
        test("-87.0null", "" + f_fM + sf_oAN);
        test("-87.0nullsuffix", "" + f_fM + sf_oAN + "suffix");
        test("prefix-87.0suffix1nullsuffix2", "prefix" + f_fM + "suffix1" + sf_oAN + "suffix2");
        test("-87.025000000", "" + f_fM + s_I);
        test("-87.025000000suffix", "" + f_fM + s_I + "suffix");
        test("prefix-87.0suffix125000000suffix2", "prefix" + f_fM + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + s_oAN + s_dM);
        test("null-96.0suffix", "" + s_oAN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + s_oAN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + s_oAN + s_oNtS);
        test("nullnullsuffix", "" + s_oAN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + s_oAN + f_strU);
        test("null\u045176suffix", "" + s_oAN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + s_oAN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + s_oAN + sf_strU2);
        test("null92suffix", "" + s_oAN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + s_oAN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + s_oAN + sf_strU1);
        test("null51suffix", "" + s_oAN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + s_oAN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + s_oAN + s_iAN);
        test("nullnullsuffix", "" + s_oAN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + s_oAN + f_bM);
        test("null-54suffix", "" + s_oAN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + s_oAN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + s_oAN + f_fM);
        test("null-87.0suffix", "" + s_oAN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + s_oAN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + s_oAN + s_oAN);
        test("nullnullsuffix", "" + s_oAN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + s_oAN + f_str);
        test("null19suffix", "" + s_oAN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + s_oAN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + s_oAN + sf_bM);
        test("null-41suffix", "" + s_oAN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + s_oAN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + s_oAN + sf_IN);
        test("nullnullsuffix", "" + s_oAN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + s_oAN + s_c);
        test("nullTsuffix", "" + s_oAN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + s_oAN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + s_oAN + sf_fM);
        test("null-42.0suffix", "" + s_oAN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + s_oAN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + s_oAN + s_b);
        test("null25suffix", "" + s_oAN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + s_oAN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + s_oAN + f_oN);
        test("nullnullsuffix", "" + s_oAN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + s_oAN + s_lM);
        test("null-1410065408suffix", "" + s_oAN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + s_oAN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + s_oAN + s_d);
        test("null8.0suffix", "" + s_oAN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + s_oAN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + s_oAN + s_f);
        test("null55.0suffix", "" + s_oAN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + s_oAN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + s_oAN + s_i);
        test("null97000000suffix", "" + s_oAN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + s_oAN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + s_oAN + f_sM);
        test("null-9900suffix", "" + s_oAN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + s_oAN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + s_oAN + s_l);
        test("null935228928suffix", "" + s_oAN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + s_oAN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + s_oAN + sf_sM);
        test("null-8400suffix", "" + s_oAN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + s_oAN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + s_oAN + s_o);
        test("nullC(82)suffix", "" + s_oAN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + s_oAN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + s_oAN + sf_oNtS);
        test("nullnullsuffix", "" + s_oAN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + s_oAN + s_bl);
        test("nulltruesuffix", "" + s_oAN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_oAN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + s_oAN + s_s);
        test("null3900suffix", "" + s_oAN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + s_oAN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + s_oAN + sf_oN);
        test("nullnullsuffix", "" + s_oAN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + s_oAN + f_I);
        test("null94000000suffix", "" + s_oAN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + s_oAN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + s_oAN + f_IN);
        test("nullnullsuffix", "" + s_oAN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + s_oAN + sf_bl);
        test("nulltruesuffix", "" + s_oAN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_oAN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + s_oAN + sf_s);
        test("null5500suffix", "" + s_oAN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + s_oAN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + s_oAN + s_sM);
        test("null-2900suffix", "" + s_oAN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + s_oAN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + s_oAN + sf_l);
        test("null-194313216suffix", "" + s_oAN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + s_oAN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + s_oAN + s_strU1);
        test("null12suffix", "" + s_oAN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + s_oAN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + s_oAN + sf_o);
        test("nullC(87)suffix", "" + s_oAN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + s_oAN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + s_oAN + s_strU2);
        test("null91suffix", "" + s_oAN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + s_oAN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + s_oAN + f_strU1);
        test("null21suffix", "" + s_oAN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + s_oAN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + s_oAN + f_strU2);
        test("null18suffix", "" + s_oAN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_oAN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + s_oAN + f_iAN);
        test("nullnullsuffix", "" + s_oAN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + s_oAN + s_oN);
        test("nullnullsuffix", "" + s_oAN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + s_oAN + s_strU);
        test("null\u045180suffix", "" + s_oAN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + s_oAN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + s_oAN + sf_c);
        test("nullCsuffix", "" + s_oAN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + s_oAN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + s_oAN + sf_str);
        test("null75suffix", "" + s_oAN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + s_oAN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + s_oAN + s_bM);
        test("null-43suffix", "" + s_oAN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + s_oAN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + s_oAN + sf_b);
        test("null80suffix", "" + s_oAN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + s_oAN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + s_oAN + s_IN);
        test("nullnullsuffix", "" + s_oAN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + s_oAN + s_fM);
        test("null-52.0suffix", "" + s_oAN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + s_oAN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + s_oAN + sf_i);
        test("null75000000suffix", "" + s_oAN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + s_oAN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + s_oAN + f_b);
        test("null44suffix", "" + s_oAN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + s_oAN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + s_oAN + sf_lM);
        test("null-1705032704suffix", "" + s_oAN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + s_oAN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + s_oAN + f_oAN);
        test("nullnullsuffix", "" + s_oAN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + s_oAN + f_d);
        test("null83.0suffix", "" + s_oAN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + s_oAN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + s_oAN + f_c);
        test("nullIsuffix", "" + s_oAN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + s_oAN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + s_oAN + f_f);
        test("null94.0suffix", "" + s_oAN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + s_oAN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + s_oAN + sf_d);
        test("null12.0suffix", "" + s_oAN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + s_oAN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + s_oAN + f_dM);
        test("null-99.0suffix", "" + s_oAN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + s_oAN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + s_oAN + sf_f);
        test("null17.0suffix", "" + s_oAN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + s_oAN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + s_oAN + sf_dM);
        test("null-84.0suffix", "" + s_oAN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + s_oAN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + s_oAN + f_i);
        test("null58000000suffix", "" + s_oAN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + s_oAN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + s_oAN + f_iM);
        test("null-55000000suffix", "" + s_oAN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + s_oAN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + s_oAN + f_l);
        test("null1460392448suffix", "" + s_oAN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + s_oAN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + s_oAN + f_o);
        test("nullC(70)suffix", "" + s_oAN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + s_oAN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + s_oAN + sf_strU);
        test("null\u04511suffix", "" + s_oAN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + s_oAN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + s_oAN + f_s);
        test("null8000suffix", "" + s_oAN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + s_oAN + "suffix1" + f_s + "suffix2");
        test("null18", "" + s_oAN + s_str);
        test("null18suffix", "" + s_oAN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_oAN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + s_oAN + s_iM);
        test("null-1000000suffix", "" + s_oAN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + s_oAN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + s_oAN + sf_I);
        test("null1000000suffix", "" + s_oAN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + s_oAN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + s_oAN + f_oNtS);
        test("nullnullsuffix", "" + s_oAN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + s_oAN + f_bl);
        test("nullfalsesuffix", "" + s_oAN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + s_oAN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + s_oAN + sf_iAN);
        test("nullnullsuffix", "" + s_oAN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + s_oAN + sf_iM);
        test("null-2000000suffix", "" + s_oAN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + s_oAN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + s_oAN + f_lM);
        test("null-820130816suffix", "" + s_oAN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + s_oAN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + s_oAN + sf_oAN);
        test("nullnullsuffix", "" + s_oAN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oAN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + s_oAN + s_I);
        test("null25000000suffix", "" + s_oAN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + s_oAN + "suffix1" + s_I + "suffix2");
        test("19-96.0", "" + f_str + s_dM);
        test("19-96.0suffix", "" + f_str + s_dM + "suffix");
        test("prefix19suffix1-96.0suffix2", "prefix" + f_str + "suffix1" + s_dM + "suffix2");
        test("19null", "" + f_str + s_oNtS);
        test("19nullsuffix", "" + f_str + s_oNtS + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + s_oNtS + "suffix2");
        test("19\u045176", "" + f_str + f_strU);
        test("19\u045176suffix", "" + f_str + f_strU + "suffix");
        test("prefix19suffix1\u045176suffix2", "prefix" + f_str + "suffix1" + f_strU + "suffix2");
        test("1992", "" + f_str + sf_strU2);
        test("1992suffix", "" + f_str + sf_strU2 + "suffix");
        test("prefix19suffix192suffix2", "prefix" + f_str + "suffix1" + sf_strU2 + "suffix2");
        test("1951", "" + f_str + sf_strU1);
        test("1951suffix", "" + f_str + sf_strU1 + "suffix");
        test("prefix19suffix151suffix2", "prefix" + f_str + "suffix1" + sf_strU1 + "suffix2");
        test("19null", "" + f_str + s_iAN);
        test("19nullsuffix", "" + f_str + s_iAN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + s_iAN + "suffix2");
        test("19-54", "" + f_str + f_bM);
        test("19-54suffix", "" + f_str + f_bM + "suffix");
        test("prefix19suffix1-54suffix2", "prefix" + f_str + "suffix1" + f_bM + "suffix2");
        test("19-87.0", "" + f_str + f_fM);
        test("19-87.0suffix", "" + f_str + f_fM + "suffix");
        test("prefix19suffix1-87.0suffix2", "prefix" + f_str + "suffix1" + f_fM + "suffix2");
        test("19null", "" + f_str + s_oAN);
        test("19nullsuffix", "" + f_str + s_oAN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + s_oAN + "suffix2");
        test("1919", "" + f_str + f_str);
        test("1919suffix", "" + f_str + f_str + "suffix");
        test("prefix19suffix119suffix2", "prefix" + f_str + "suffix1" + f_str + "suffix2");
        test("19-41", "" + f_str + sf_bM);
        test("19-41suffix", "" + f_str + sf_bM + "suffix");
        test("prefix19suffix1-41suffix2", "prefix" + f_str + "suffix1" + sf_bM + "suffix2");
        test("19null", "" + f_str + sf_IN);
        test("19nullsuffix", "" + f_str + sf_IN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + sf_IN + "suffix2");
        test("19T", "" + f_str + s_c);
        test("19Tsuffix", "" + f_str + s_c + "suffix");
        test("prefix19suffix1Tsuffix2", "prefix" + f_str + "suffix1" + s_c + "suffix2");
        test("19-42.0", "" + f_str + sf_fM);
        test("19-42.0suffix", "" + f_str + sf_fM + "suffix");
        test("prefix19suffix1-42.0suffix2", "prefix" + f_str + "suffix1" + sf_fM + "suffix2");
        test("1925", "" + f_str + s_b);
        test("1925suffix", "" + f_str + s_b + "suffix");
        test("prefix19suffix125suffix2", "prefix" + f_str + "suffix1" + s_b + "suffix2");
        test("19null", "" + f_str + f_oN);
        test("19nullsuffix", "" + f_str + f_oN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + f_oN + "suffix2");
        test("19-1410065408", "" + f_str + s_lM);
        test("19-1410065408suffix", "" + f_str + s_lM + "suffix");
        test("prefix19suffix1-1410065408suffix2", "prefix" + f_str + "suffix1" + s_lM + "suffix2");
        test("198.0", "" + f_str + s_d);
        test("198.0suffix", "" + f_str + s_d + "suffix");
        test("prefix19suffix18.0suffix2", "prefix" + f_str + "suffix1" + s_d + "suffix2");
        test("1955.0", "" + f_str + s_f);
        test("1955.0suffix", "" + f_str + s_f + "suffix");
        test("prefix19suffix155.0suffix2", "prefix" + f_str + "suffix1" + s_f + "suffix2");
        test("1997000000", "" + f_str + s_i);
        test("1997000000suffix", "" + f_str + s_i + "suffix");
        test("prefix19suffix197000000suffix2", "prefix" + f_str + "suffix1" + s_i + "suffix2");
        test("19-9900", "" + f_str + f_sM);
        test("19-9900suffix", "" + f_str + f_sM + "suffix");
        test("prefix19suffix1-9900suffix2", "prefix" + f_str + "suffix1" + f_sM + "suffix2");
        test("19935228928", "" + f_str + s_l);
        test("19935228928suffix", "" + f_str + s_l + "suffix");
        test("prefix19suffix1935228928suffix2", "prefix" + f_str + "suffix1" + s_l + "suffix2");
        test("19-8400", "" + f_str + sf_sM);
        test("19-8400suffix", "" + f_str + sf_sM + "suffix");
        test("prefix19suffix1-8400suffix2", "prefix" + f_str + "suffix1" + sf_sM + "suffix2");
        test("19C(82)", "" + f_str + s_o);
        test("19C(82)suffix", "" + f_str + s_o + "suffix");
        test("prefix19suffix1C(82)suffix2", "prefix" + f_str + "suffix1" + s_o + "suffix2");
        test("19null", "" + f_str + sf_oNtS);
        test("19nullsuffix", "" + f_str + sf_oNtS + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + sf_oNtS + "suffix2");
        test("19true", "" + f_str + s_bl);
        test("19truesuffix", "" + f_str + s_bl + "suffix");
        test("prefix19suffix1truesuffix2", "prefix" + f_str + "suffix1" + s_bl + "suffix2");
        test("193900", "" + f_str + s_s);
        test("193900suffix", "" + f_str + s_s + "suffix");
        test("prefix19suffix13900suffix2", "prefix" + f_str + "suffix1" + s_s + "suffix2");
        test("19null", "" + f_str + sf_oN);
        test("19nullsuffix", "" + f_str + sf_oN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + sf_oN + "suffix2");
        test("1994000000", "" + f_str + f_I);
        test("1994000000suffix", "" + f_str + f_I + "suffix");
        test("prefix19suffix194000000suffix2", "prefix" + f_str + "suffix1" + f_I + "suffix2");
        test("19null", "" + f_str + f_IN);
        test("19nullsuffix", "" + f_str + f_IN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + f_IN + "suffix2");
        test("19true", "" + f_str + sf_bl);
        test("19truesuffix", "" + f_str + sf_bl + "suffix");
        test("prefix19suffix1truesuffix2", "prefix" + f_str + "suffix1" + sf_bl + "suffix2");
        test("195500", "" + f_str + sf_s);
        test("195500suffix", "" + f_str + sf_s + "suffix");
        test("prefix19suffix15500suffix2", "prefix" + f_str + "suffix1" + sf_s + "suffix2");
        test("19-2900", "" + f_str + s_sM);
        test("19-2900suffix", "" + f_str + s_sM + "suffix");
        test("prefix19suffix1-2900suffix2", "prefix" + f_str + "suffix1" + s_sM + "suffix2");
        test("19-194313216", "" + f_str + sf_l);
        test("19-194313216suffix", "" + f_str + sf_l + "suffix");
        test("prefix19suffix1-194313216suffix2", "prefix" + f_str + "suffix1" + sf_l + "suffix2");
        test("1912", "" + f_str + s_strU1);
        test("1912suffix", "" + f_str + s_strU1 + "suffix");
        test("prefix19suffix112suffix2", "prefix" + f_str + "suffix1" + s_strU1 + "suffix2");
        test("19C(87)", "" + f_str + sf_o);
        test("19C(87)suffix", "" + f_str + sf_o + "suffix");
        test("prefix19suffix1C(87)suffix2", "prefix" + f_str + "suffix1" + sf_o + "suffix2");
        test("1991", "" + f_str + s_strU2);
        test("1991suffix", "" + f_str + s_strU2 + "suffix");
        test("prefix19suffix191suffix2", "prefix" + f_str + "suffix1" + s_strU2 + "suffix2");
        test("1921", "" + f_str + f_strU1);
        test("1921suffix", "" + f_str + f_strU1 + "suffix");
        test("prefix19suffix121suffix2", "prefix" + f_str + "suffix1" + f_strU1 + "suffix2");
        test("1918", "" + f_str + f_strU2);
        test("1918suffix", "" + f_str + f_strU2 + "suffix");
        test("prefix19suffix118suffix2", "prefix" + f_str + "suffix1" + f_strU2 + "suffix2");
        test("19null", "" + f_str + f_iAN);
        test("19nullsuffix", "" + f_str + f_iAN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + f_iAN + "suffix2");
        test("19null", "" + f_str + s_oN);
        test("19nullsuffix", "" + f_str + s_oN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + s_oN + "suffix2");
        test("19\u045180", "" + f_str + s_strU);
        test("19\u045180suffix", "" + f_str + s_strU + "suffix");
        test("prefix19suffix1\u045180suffix2", "prefix" + f_str + "suffix1" + s_strU + "suffix2");
        test("19C", "" + f_str + sf_c);
        test("19Csuffix", "" + f_str + sf_c + "suffix");
        test("prefix19suffix1Csuffix2", "prefix" + f_str + "suffix1" + sf_c + "suffix2");
        test("1975", "" + f_str + sf_str);
        test("1975suffix", "" + f_str + sf_str + "suffix");
        test("prefix19suffix175suffix2", "prefix" + f_str + "suffix1" + sf_str + "suffix2");
        test("19-43", "" + f_str + s_bM);
        test("19-43suffix", "" + f_str + s_bM + "suffix");
        test("prefix19suffix1-43suffix2", "prefix" + f_str + "suffix1" + s_bM + "suffix2");
        test("1980", "" + f_str + sf_b);
        test("1980suffix", "" + f_str + sf_b + "suffix");
        test("prefix19suffix180suffix2", "prefix" + f_str + "suffix1" + sf_b + "suffix2");
        test("19null", "" + f_str + s_IN);
        test("19nullsuffix", "" + f_str + s_IN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + s_IN + "suffix2");
        test("19-52.0", "" + f_str + s_fM);
        test("19-52.0suffix", "" + f_str + s_fM + "suffix");
        test("prefix19suffix1-52.0suffix2", "prefix" + f_str + "suffix1" + s_fM + "suffix2");
        test("1975000000", "" + f_str + sf_i);
        test("1975000000suffix", "" + f_str + sf_i + "suffix");
        test("prefix19suffix175000000suffix2", "prefix" + f_str + "suffix1" + sf_i + "suffix2");
        test("1944", "" + f_str + f_b);
        test("1944suffix", "" + f_str + f_b + "suffix");
        test("prefix19suffix144suffix2", "prefix" + f_str + "suffix1" + f_b + "suffix2");
        test("19-1705032704", "" + f_str + sf_lM);
        test("19-1705032704suffix", "" + f_str + sf_lM + "suffix");
        test("prefix19suffix1-1705032704suffix2", "prefix" + f_str + "suffix1" + sf_lM + "suffix2");
        test("19null", "" + f_str + f_oAN);
        test("19nullsuffix", "" + f_str + f_oAN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + f_oAN + "suffix2");
        test("1983.0", "" + f_str + f_d);
        test("1983.0suffix", "" + f_str + f_d + "suffix");
        test("prefix19suffix183.0suffix2", "prefix" + f_str + "suffix1" + f_d + "suffix2");
        test("19I", "" + f_str + f_c);
        test("19Isuffix", "" + f_str + f_c + "suffix");
        test("prefix19suffix1Isuffix2", "prefix" + f_str + "suffix1" + f_c + "suffix2");
        test("1994.0", "" + f_str + f_f);
        test("1994.0suffix", "" + f_str + f_f + "suffix");
        test("prefix19suffix194.0suffix2", "prefix" + f_str + "suffix1" + f_f + "suffix2");
        test("1912.0", "" + f_str + sf_d);
        test("1912.0suffix", "" + f_str + sf_d + "suffix");
        test("prefix19suffix112.0suffix2", "prefix" + f_str + "suffix1" + sf_d + "suffix2");
        test("19-99.0", "" + f_str + f_dM);
        test("19-99.0suffix", "" + f_str + f_dM + "suffix");
        test("prefix19suffix1-99.0suffix2", "prefix" + f_str + "suffix1" + f_dM + "suffix2");
        test("1917.0", "" + f_str + sf_f);
        test("1917.0suffix", "" + f_str + sf_f + "suffix");
        test("prefix19suffix117.0suffix2", "prefix" + f_str + "suffix1" + sf_f + "suffix2");
        test("19-84.0", "" + f_str + sf_dM);
        test("19-84.0suffix", "" + f_str + sf_dM + "suffix");
        test("prefix19suffix1-84.0suffix2", "prefix" + f_str + "suffix1" + sf_dM + "suffix2");
        test("1958000000", "" + f_str + f_i);
        test("1958000000suffix", "" + f_str + f_i + "suffix");
        test("prefix19suffix158000000suffix2", "prefix" + f_str + "suffix1" + f_i + "suffix2");
        test("19-55000000", "" + f_str + f_iM);
        test("19-55000000suffix", "" + f_str + f_iM + "suffix");
        test("prefix19suffix1-55000000suffix2", "prefix" + f_str + "suffix1" + f_iM + "suffix2");
        test("191460392448", "" + f_str + f_l);
        test("191460392448suffix", "" + f_str + f_l + "suffix");
        test("prefix19suffix11460392448suffix2", "prefix" + f_str + "suffix1" + f_l + "suffix2");
        test("19C(70)", "" + f_str + f_o);
        test("19C(70)suffix", "" + f_str + f_o + "suffix");
        test("prefix19suffix1C(70)suffix2", "prefix" + f_str + "suffix1" + f_o + "suffix2");
        test("19\u04511", "" + f_str + sf_strU);
        test("19\u04511suffix", "" + f_str + sf_strU + "suffix");
        test("prefix19suffix1\u04511suffix2", "prefix" + f_str + "suffix1" + sf_strU + "suffix2");
        test("198000", "" + f_str + f_s);
        test("198000suffix", "" + f_str + f_s + "suffix");
        test("prefix19suffix18000suffix2", "prefix" + f_str + "suffix1" + f_s + "suffix2");
        test("1918", "" + f_str + s_str);
        test("1918suffix", "" + f_str + s_str + "suffix");
        test("prefix19suffix118suffix2", "prefix" + f_str + "suffix1" + s_str + "suffix2");
        test("19-1000000", "" + f_str + s_iM);
        test("19-1000000suffix", "" + f_str + s_iM + "suffix");
        test("prefix19suffix1-1000000suffix2", "prefix" + f_str + "suffix1" + s_iM + "suffix2");
        test("191000000", "" + f_str + sf_I);
        test("191000000suffix", "" + f_str + sf_I + "suffix");
        test("prefix19suffix11000000suffix2", "prefix" + f_str + "suffix1" + sf_I + "suffix2");
        test("19null", "" + f_str + f_oNtS);
        test("19nullsuffix", "" + f_str + f_oNtS + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + f_oNtS + "suffix2");
        test("19false", "" + f_str + f_bl);
        test("19falsesuffix", "" + f_str + f_bl + "suffix");
        test("prefix19suffix1falsesuffix2", "prefix" + f_str + "suffix1" + f_bl + "suffix2");
        test("19null", "" + f_str + sf_iAN);
        test("19nullsuffix", "" + f_str + sf_iAN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + sf_iAN + "suffix2");
        test("19-2000000", "" + f_str + sf_iM);
        test("19-2000000suffix", "" + f_str + sf_iM + "suffix");
        test("prefix19suffix1-2000000suffix2", "prefix" + f_str + "suffix1" + sf_iM + "suffix2");
        test("19-820130816", "" + f_str + f_lM);
        test("19-820130816suffix", "" + f_str + f_lM + "suffix");
        test("prefix19suffix1-820130816suffix2", "prefix" + f_str + "suffix1" + f_lM + "suffix2");
        test("19null", "" + f_str + sf_oAN);
        test("19nullsuffix", "" + f_str + sf_oAN + "suffix");
        test("prefix19suffix1nullsuffix2", "prefix" + f_str + "suffix1" + sf_oAN + "suffix2");
        test("1925000000", "" + f_str + s_I);
        test("1925000000suffix", "" + f_str + s_I + "suffix");
        test("prefix19suffix125000000suffix2", "prefix" + f_str + "suffix1" + s_I + "suffix2");
        test("-41-96.0", "" + sf_bM + s_dM);
        test("-41-96.0suffix", "" + sf_bM + s_dM + "suffix");
        test("prefix-41suffix1-96.0suffix2", "prefix" + sf_bM + "suffix1" + s_dM + "suffix2");
        test("-41null", "" + sf_bM + s_oNtS);
        test("-41nullsuffix", "" + sf_bM + s_oNtS + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + s_oNtS + "suffix2");
        test("-41\u045176", "" + sf_bM + f_strU);
        test("-41\u045176suffix", "" + sf_bM + f_strU + "suffix");
        test("prefix-41suffix1\u045176suffix2", "prefix" + sf_bM + "suffix1" + f_strU + "suffix2");
        test("-4192", "" + sf_bM + sf_strU2);
        test("-4192suffix", "" + sf_bM + sf_strU2 + "suffix");
        test("prefix-41suffix192suffix2", "prefix" + sf_bM + "suffix1" + sf_strU2 + "suffix2");
        test("-4151", "" + sf_bM + sf_strU1);
        test("-4151suffix", "" + sf_bM + sf_strU1 + "suffix");
        test("prefix-41suffix151suffix2", "prefix" + sf_bM + "suffix1" + sf_strU1 + "suffix2");
        test("-41null", "" + sf_bM + s_iAN);
        test("-41nullsuffix", "" + sf_bM + s_iAN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + s_iAN + "suffix2");
        test("-41-54", "" + sf_bM + f_bM);
        test("-41-54suffix", "" + sf_bM + f_bM + "suffix");
        test("prefix-41suffix1-54suffix2", "prefix" + sf_bM + "suffix1" + f_bM + "suffix2");
        test("-41-87.0", "" + sf_bM + f_fM);
        test("-41-87.0suffix", "" + sf_bM + f_fM + "suffix");
        test("prefix-41suffix1-87.0suffix2", "prefix" + sf_bM + "suffix1" + f_fM + "suffix2");
        test("-41null", "" + sf_bM + s_oAN);
        test("-41nullsuffix", "" + sf_bM + s_oAN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + s_oAN + "suffix2");
        test("-4119", "" + sf_bM + f_str);
        test("-4119suffix", "" + sf_bM + f_str + "suffix");
        test("prefix-41suffix119suffix2", "prefix" + sf_bM + "suffix1" + f_str + "suffix2");
        test("-41-41", "" + sf_bM + sf_bM);
        test("-41-41suffix", "" + sf_bM + sf_bM + "suffix");
        test("prefix-41suffix1-41suffix2", "prefix" + sf_bM + "suffix1" + sf_bM + "suffix2");
        test("-41null", "" + sf_bM + sf_IN);
        test("-41nullsuffix", "" + sf_bM + sf_IN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + sf_IN + "suffix2");
        test("-41T", "" + sf_bM + s_c);
        test("-41Tsuffix", "" + sf_bM + s_c + "suffix");
        test("prefix-41suffix1Tsuffix2", "prefix" + sf_bM + "suffix1" + s_c + "suffix2");
        test("-41-42.0", "" + sf_bM + sf_fM);
        test("-41-42.0suffix", "" + sf_bM + sf_fM + "suffix");
        test("prefix-41suffix1-42.0suffix2", "prefix" + sf_bM + "suffix1" + sf_fM + "suffix2");
        test("-4125", "" + sf_bM + s_b);
        test("-4125suffix", "" + sf_bM + s_b + "suffix");
        test("prefix-41suffix125suffix2", "prefix" + sf_bM + "suffix1" + s_b + "suffix2");
        test("-41null", "" + sf_bM + f_oN);
        test("-41nullsuffix", "" + sf_bM + f_oN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + f_oN + "suffix2");
        test("-41-1410065408", "" + sf_bM + s_lM);
        test("-41-1410065408suffix", "" + sf_bM + s_lM + "suffix");
        test("prefix-41suffix1-1410065408suffix2", "prefix" + sf_bM + "suffix1" + s_lM + "suffix2");
        test("-418.0", "" + sf_bM + s_d);
        test("-418.0suffix", "" + sf_bM + s_d + "suffix");
        test("prefix-41suffix18.0suffix2", "prefix" + sf_bM + "suffix1" + s_d + "suffix2");
        test("-4155.0", "" + sf_bM + s_f);
        test("-4155.0suffix", "" + sf_bM + s_f + "suffix");
        test("prefix-41suffix155.0suffix2", "prefix" + sf_bM + "suffix1" + s_f + "suffix2");
        test("-4197000000", "" + sf_bM + s_i);
        test("-4197000000suffix", "" + sf_bM + s_i + "suffix");
        test("prefix-41suffix197000000suffix2", "prefix" + sf_bM + "suffix1" + s_i + "suffix2");
        test("-41-9900", "" + sf_bM + f_sM);
        test("-41-9900suffix", "" + sf_bM + f_sM + "suffix");
        test("prefix-41suffix1-9900suffix2", "prefix" + sf_bM + "suffix1" + f_sM + "suffix2");
        test("-41935228928", "" + sf_bM + s_l);
        test("-41935228928suffix", "" + sf_bM + s_l + "suffix");
        test("prefix-41suffix1935228928suffix2", "prefix" + sf_bM + "suffix1" + s_l + "suffix2");
        test("-41-8400", "" + sf_bM + sf_sM);
        test("-41-8400suffix", "" + sf_bM + sf_sM + "suffix");
        test("prefix-41suffix1-8400suffix2", "prefix" + sf_bM + "suffix1" + sf_sM + "suffix2");
        test("-41C(82)", "" + sf_bM + s_o);
        test("-41C(82)suffix", "" + sf_bM + s_o + "suffix");
        test("prefix-41suffix1C(82)suffix2", "prefix" + sf_bM + "suffix1" + s_o + "suffix2");
        test("-41null", "" + sf_bM + sf_oNtS);
        test("-41nullsuffix", "" + sf_bM + sf_oNtS + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + sf_oNtS + "suffix2");
        test("-41true", "" + sf_bM + s_bl);
        test("-41truesuffix", "" + sf_bM + s_bl + "suffix");
        test("prefix-41suffix1truesuffix2", "prefix" + sf_bM + "suffix1" + s_bl + "suffix2");
        test("-413900", "" + sf_bM + s_s);
        test("-413900suffix", "" + sf_bM + s_s + "suffix");
        test("prefix-41suffix13900suffix2", "prefix" + sf_bM + "suffix1" + s_s + "suffix2");
        test("-41null", "" + sf_bM + sf_oN);
        test("-41nullsuffix", "" + sf_bM + sf_oN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + sf_oN + "suffix2");
        test("-4194000000", "" + sf_bM + f_I);
        test("-4194000000suffix", "" + sf_bM + f_I + "suffix");
        test("prefix-41suffix194000000suffix2", "prefix" + sf_bM + "suffix1" + f_I + "suffix2");
        test("-41null", "" + sf_bM + f_IN);
        test("-41nullsuffix", "" + sf_bM + f_IN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + f_IN + "suffix2");
        test("-41true", "" + sf_bM + sf_bl);
        test("-41truesuffix", "" + sf_bM + sf_bl + "suffix");
        test("prefix-41suffix1truesuffix2", "prefix" + sf_bM + "suffix1" + sf_bl + "suffix2");
        test("-415500", "" + sf_bM + sf_s);
        test("-415500suffix", "" + sf_bM + sf_s + "suffix");
        test("prefix-41suffix15500suffix2", "prefix" + sf_bM + "suffix1" + sf_s + "suffix2");
        test("-41-2900", "" + sf_bM + s_sM);
        test("-41-2900suffix", "" + sf_bM + s_sM + "suffix");
        test("prefix-41suffix1-2900suffix2", "prefix" + sf_bM + "suffix1" + s_sM + "suffix2");
        test("-41-194313216", "" + sf_bM + sf_l);
        test("-41-194313216suffix", "" + sf_bM + sf_l + "suffix");
        test("prefix-41suffix1-194313216suffix2", "prefix" + sf_bM + "suffix1" + sf_l + "suffix2");
        test("-4112", "" + sf_bM + s_strU1);
        test("-4112suffix", "" + sf_bM + s_strU1 + "suffix");
        test("prefix-41suffix112suffix2", "prefix" + sf_bM + "suffix1" + s_strU1 + "suffix2");
        test("-41C(87)", "" + sf_bM + sf_o);
        test("-41C(87)suffix", "" + sf_bM + sf_o + "suffix");
        test("prefix-41suffix1C(87)suffix2", "prefix" + sf_bM + "suffix1" + sf_o + "suffix2");
        test("-4191", "" + sf_bM + s_strU2);
        test("-4191suffix", "" + sf_bM + s_strU2 + "suffix");
        test("prefix-41suffix191suffix2", "prefix" + sf_bM + "suffix1" + s_strU2 + "suffix2");
        test("-4121", "" + sf_bM + f_strU1);
        test("-4121suffix", "" + sf_bM + f_strU1 + "suffix");
        test("prefix-41suffix121suffix2", "prefix" + sf_bM + "suffix1" + f_strU1 + "suffix2");
        test("-4118", "" + sf_bM + f_strU2);
        test("-4118suffix", "" + sf_bM + f_strU2 + "suffix");
        test("prefix-41suffix118suffix2", "prefix" + sf_bM + "suffix1" + f_strU2 + "suffix2");
        test("-41null", "" + sf_bM + f_iAN);
        test("-41nullsuffix", "" + sf_bM + f_iAN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + f_iAN + "suffix2");
        test("-41null", "" + sf_bM + s_oN);
        test("-41nullsuffix", "" + sf_bM + s_oN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + s_oN + "suffix2");
        test("-41\u045180", "" + sf_bM + s_strU);
        test("-41\u045180suffix", "" + sf_bM + s_strU + "suffix");
        test("prefix-41suffix1\u045180suffix2", "prefix" + sf_bM + "suffix1" + s_strU + "suffix2");
        test("-41C", "" + sf_bM + sf_c);
        test("-41Csuffix", "" + sf_bM + sf_c + "suffix");
        test("prefix-41suffix1Csuffix2", "prefix" + sf_bM + "suffix1" + sf_c + "suffix2");
        test("-4175", "" + sf_bM + sf_str);
        test("-4175suffix", "" + sf_bM + sf_str + "suffix");
        test("prefix-41suffix175suffix2", "prefix" + sf_bM + "suffix1" + sf_str + "suffix2");
        test("-41-43", "" + sf_bM + s_bM);
        test("-41-43suffix", "" + sf_bM + s_bM + "suffix");
        test("prefix-41suffix1-43suffix2", "prefix" + sf_bM + "suffix1" + s_bM + "suffix2");
        test("-4180", "" + sf_bM + sf_b);
        test("-4180suffix", "" + sf_bM + sf_b + "suffix");
        test("prefix-41suffix180suffix2", "prefix" + sf_bM + "suffix1" + sf_b + "suffix2");
        test("-41null", "" + sf_bM + s_IN);
        test("-41nullsuffix", "" + sf_bM + s_IN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + s_IN + "suffix2");
        test("-41-52.0", "" + sf_bM + s_fM);
        test("-41-52.0suffix", "" + sf_bM + s_fM + "suffix");
        test("prefix-41suffix1-52.0suffix2", "prefix" + sf_bM + "suffix1" + s_fM + "suffix2");
        test("-4175000000", "" + sf_bM + sf_i);
        test("-4175000000suffix", "" + sf_bM + sf_i + "suffix");
        test("prefix-41suffix175000000suffix2", "prefix" + sf_bM + "suffix1" + sf_i + "suffix2");
        test("-4144", "" + sf_bM + f_b);
        test("-4144suffix", "" + sf_bM + f_b + "suffix");
        test("prefix-41suffix144suffix2", "prefix" + sf_bM + "suffix1" + f_b + "suffix2");
        test("-41-1705032704", "" + sf_bM + sf_lM);
        test("-41-1705032704suffix", "" + sf_bM + sf_lM + "suffix");
        test("prefix-41suffix1-1705032704suffix2", "prefix" + sf_bM + "suffix1" + sf_lM + "suffix2");
        test("-41null", "" + sf_bM + f_oAN);
        test("-41nullsuffix", "" + sf_bM + f_oAN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + f_oAN + "suffix2");
        test("-4183.0", "" + sf_bM + f_d);
        test("-4183.0suffix", "" + sf_bM + f_d + "suffix");
        test("prefix-41suffix183.0suffix2", "prefix" + sf_bM + "suffix1" + f_d + "suffix2");
        test("-41I", "" + sf_bM + f_c);
        test("-41Isuffix", "" + sf_bM + f_c + "suffix");
        test("prefix-41suffix1Isuffix2", "prefix" + sf_bM + "suffix1" + f_c + "suffix2");
        test("-4194.0", "" + sf_bM + f_f);
        test("-4194.0suffix", "" + sf_bM + f_f + "suffix");
        test("prefix-41suffix194.0suffix2", "prefix" + sf_bM + "suffix1" + f_f + "suffix2");
        test("-4112.0", "" + sf_bM + sf_d);
        test("-4112.0suffix", "" + sf_bM + sf_d + "suffix");
        test("prefix-41suffix112.0suffix2", "prefix" + sf_bM + "suffix1" + sf_d + "suffix2");
        test("-41-99.0", "" + sf_bM + f_dM);
        test("-41-99.0suffix", "" + sf_bM + f_dM + "suffix");
        test("prefix-41suffix1-99.0suffix2", "prefix" + sf_bM + "suffix1" + f_dM + "suffix2");
        test("-4117.0", "" + sf_bM + sf_f);
        test("-4117.0suffix", "" + sf_bM + sf_f + "suffix");
        test("prefix-41suffix117.0suffix2", "prefix" + sf_bM + "suffix1" + sf_f + "suffix2");
        test("-41-84.0", "" + sf_bM + sf_dM);
        test("-41-84.0suffix", "" + sf_bM + sf_dM + "suffix");
        test("prefix-41suffix1-84.0suffix2", "prefix" + sf_bM + "suffix1" + sf_dM + "suffix2");
        test("-4158000000", "" + sf_bM + f_i);
        test("-4158000000suffix", "" + sf_bM + f_i + "suffix");
        test("prefix-41suffix158000000suffix2", "prefix" + sf_bM + "suffix1" + f_i + "suffix2");
        test("-41-55000000", "" + sf_bM + f_iM);
        test("-41-55000000suffix", "" + sf_bM + f_iM + "suffix");
        test("prefix-41suffix1-55000000suffix2", "prefix" + sf_bM + "suffix1" + f_iM + "suffix2");
        test("-411460392448", "" + sf_bM + f_l);
        test("-411460392448suffix", "" + sf_bM + f_l + "suffix");
        test("prefix-41suffix11460392448suffix2", "prefix" + sf_bM + "suffix1" + f_l + "suffix2");
        test("-41C(70)", "" + sf_bM + f_o);
        test("-41C(70)suffix", "" + sf_bM + f_o + "suffix");
        test("prefix-41suffix1C(70)suffix2", "prefix" + sf_bM + "suffix1" + f_o + "suffix2");
        test("-41\u04511", "" + sf_bM + sf_strU);
        test("-41\u04511suffix", "" + sf_bM + sf_strU + "suffix");
        test("prefix-41suffix1\u04511suffix2", "prefix" + sf_bM + "suffix1" + sf_strU + "suffix2");
        test("-418000", "" + sf_bM + f_s);
        test("-418000suffix", "" + sf_bM + f_s + "suffix");
        test("prefix-41suffix18000suffix2", "prefix" + sf_bM + "suffix1" + f_s + "suffix2");
        test("-4118", "" + sf_bM + s_str);
        test("-4118suffix", "" + sf_bM + s_str + "suffix");
        test("prefix-41suffix118suffix2", "prefix" + sf_bM + "suffix1" + s_str + "suffix2");
        test("-41-1000000", "" + sf_bM + s_iM);
        test("-41-1000000suffix", "" + sf_bM + s_iM + "suffix");
        test("prefix-41suffix1-1000000suffix2", "prefix" + sf_bM + "suffix1" + s_iM + "suffix2");
        test("-411000000", "" + sf_bM + sf_I);
        test("-411000000suffix", "" + sf_bM + sf_I + "suffix");
        test("prefix-41suffix11000000suffix2", "prefix" + sf_bM + "suffix1" + sf_I + "suffix2");
        test("-41null", "" + sf_bM + f_oNtS);
        test("-41nullsuffix", "" + sf_bM + f_oNtS + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + f_oNtS + "suffix2");
        test("-41false", "" + sf_bM + f_bl);
        test("-41falsesuffix", "" + sf_bM + f_bl + "suffix");
        test("prefix-41suffix1falsesuffix2", "prefix" + sf_bM + "suffix1" + f_bl + "suffix2");
        test("-41null", "" + sf_bM + sf_iAN);
        test("-41nullsuffix", "" + sf_bM + sf_iAN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + sf_iAN + "suffix2");
        test("-41-2000000", "" + sf_bM + sf_iM);
        test("-41-2000000suffix", "" + sf_bM + sf_iM + "suffix");
        test("prefix-41suffix1-2000000suffix2", "prefix" + sf_bM + "suffix1" + sf_iM + "suffix2");
        test("-41-820130816", "" + sf_bM + f_lM);
        test("-41-820130816suffix", "" + sf_bM + f_lM + "suffix");
        test("prefix-41suffix1-820130816suffix2", "prefix" + sf_bM + "suffix1" + f_lM + "suffix2");
        test("-41null", "" + sf_bM + sf_oAN);
        test("-41nullsuffix", "" + sf_bM + sf_oAN + "suffix");
        test("prefix-41suffix1nullsuffix2", "prefix" + sf_bM + "suffix1" + sf_oAN + "suffix2");
        test("-4125000000", "" + sf_bM + s_I);
        test("-4125000000suffix", "" + sf_bM + s_I + "suffix");
        test("prefix-41suffix125000000suffix2", "prefix" + sf_bM + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + sf_IN + s_dM);
        test("null-96.0suffix", "" + sf_IN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + sf_IN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + sf_IN + s_oNtS);
        test("nullnullsuffix", "" + sf_IN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + sf_IN + f_strU);
        test("null\u045176suffix", "" + sf_IN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + sf_IN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + sf_IN + sf_strU2);
        test("null92suffix", "" + sf_IN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + sf_IN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + sf_IN + sf_strU1);
        test("null51suffix", "" + sf_IN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + sf_IN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + sf_IN + s_iAN);
        test("nullnullsuffix", "" + sf_IN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + sf_IN + f_bM);
        test("null-54suffix", "" + sf_IN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + sf_IN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + sf_IN + f_fM);
        test("null-87.0suffix", "" + sf_IN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + sf_IN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + sf_IN + s_oAN);
        test("nullnullsuffix", "" + sf_IN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + sf_IN + f_str);
        test("null19suffix", "" + sf_IN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + sf_IN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + sf_IN + sf_bM);
        test("null-41suffix", "" + sf_IN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + sf_IN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + sf_IN + sf_IN);
        test("nullnullsuffix", "" + sf_IN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + sf_IN + s_c);
        test("nullTsuffix", "" + sf_IN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + sf_IN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + sf_IN + sf_fM);
        test("null-42.0suffix", "" + sf_IN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + sf_IN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + sf_IN + s_b);
        test("null25suffix", "" + sf_IN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + sf_IN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + sf_IN + f_oN);
        test("nullnullsuffix", "" + sf_IN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + sf_IN + s_lM);
        test("null-1410065408suffix", "" + sf_IN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + sf_IN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + sf_IN + s_d);
        test("null8.0suffix", "" + sf_IN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + sf_IN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + sf_IN + s_f);
        test("null55.0suffix", "" + sf_IN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + sf_IN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + sf_IN + s_i);
        test("null97000000suffix", "" + sf_IN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + sf_IN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + sf_IN + f_sM);
        test("null-9900suffix", "" + sf_IN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + sf_IN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + sf_IN + s_l);
        test("null935228928suffix", "" + sf_IN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + sf_IN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + sf_IN + sf_sM);
        test("null-8400suffix", "" + sf_IN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + sf_IN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + sf_IN + s_o);
        test("nullC(82)suffix", "" + sf_IN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + sf_IN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + sf_IN + sf_oNtS);
        test("nullnullsuffix", "" + sf_IN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + sf_IN + s_bl);
        test("nulltruesuffix", "" + sf_IN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + sf_IN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + sf_IN + s_s);
        test("null3900suffix", "" + sf_IN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + sf_IN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + sf_IN + sf_oN);
        test("nullnullsuffix", "" + sf_IN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + sf_IN + f_I);
        test("null94000000suffix", "" + sf_IN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + sf_IN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + sf_IN + f_IN);
        test("nullnullsuffix", "" + sf_IN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + sf_IN + sf_bl);
        test("nulltruesuffix", "" + sf_IN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + sf_IN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + sf_IN + sf_s);
        test("null5500suffix", "" + sf_IN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + sf_IN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + sf_IN + s_sM);
        test("null-2900suffix", "" + sf_IN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + sf_IN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + sf_IN + sf_l);
        test("null-194313216suffix", "" + sf_IN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + sf_IN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + sf_IN + s_strU1);
        test("null12suffix", "" + sf_IN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + sf_IN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + sf_IN + sf_o);
        test("nullC(87)suffix", "" + sf_IN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + sf_IN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + sf_IN + s_strU2);
        test("null91suffix", "" + sf_IN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + sf_IN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + sf_IN + f_strU1);
        test("null21suffix", "" + sf_IN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + sf_IN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + sf_IN + f_strU2);
        test("null18suffix", "" + sf_IN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + sf_IN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + sf_IN + f_iAN);
        test("nullnullsuffix", "" + sf_IN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + sf_IN + s_oN);
        test("nullnullsuffix", "" + sf_IN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + sf_IN + s_strU);
        test("null\u045180suffix", "" + sf_IN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + sf_IN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + sf_IN + sf_c);
        test("nullCsuffix", "" + sf_IN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + sf_IN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + sf_IN + sf_str);
        test("null75suffix", "" + sf_IN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + sf_IN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + sf_IN + s_bM);
        test("null-43suffix", "" + sf_IN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + sf_IN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + sf_IN + sf_b);
        test("null80suffix", "" + sf_IN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + sf_IN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + sf_IN + s_IN);
        test("nullnullsuffix", "" + sf_IN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + sf_IN + s_fM);
        test("null-52.0suffix", "" + sf_IN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + sf_IN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + sf_IN + sf_i);
        test("null75000000suffix", "" + sf_IN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + sf_IN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + sf_IN + f_b);
        test("null44suffix", "" + sf_IN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + sf_IN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + sf_IN + sf_lM);
        test("null-1705032704suffix", "" + sf_IN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + sf_IN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + sf_IN + f_oAN);
        test("nullnullsuffix", "" + sf_IN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + sf_IN + f_d);
        test("null83.0suffix", "" + sf_IN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + sf_IN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + sf_IN + f_c);
        test("nullIsuffix", "" + sf_IN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + sf_IN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + sf_IN + f_f);
        test("null94.0suffix", "" + sf_IN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + sf_IN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + sf_IN + sf_d);
        test("null12.0suffix", "" + sf_IN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + sf_IN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + sf_IN + f_dM);
        test("null-99.0suffix", "" + sf_IN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + sf_IN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + sf_IN + sf_f);
        test("null17.0suffix", "" + sf_IN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + sf_IN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + sf_IN + sf_dM);
        test("null-84.0suffix", "" + sf_IN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + sf_IN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + sf_IN + f_i);
        test("null58000000suffix", "" + sf_IN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + sf_IN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + sf_IN + f_iM);
        test("null-55000000suffix", "" + sf_IN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + sf_IN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + sf_IN + f_l);
        test("null1460392448suffix", "" + sf_IN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + sf_IN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + sf_IN + f_o);
        test("nullC(70)suffix", "" + sf_IN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + sf_IN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + sf_IN + sf_strU);
        test("null\u04511suffix", "" + sf_IN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + sf_IN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + sf_IN + f_s);
        test("null8000suffix", "" + sf_IN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + sf_IN + "suffix1" + f_s + "suffix2");
        test("null18", "" + sf_IN + s_str);
        test("null18suffix", "" + sf_IN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + sf_IN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + sf_IN + s_iM);
        test("null-1000000suffix", "" + sf_IN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + sf_IN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + sf_IN + sf_I);
        test("null1000000suffix", "" + sf_IN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + sf_IN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + sf_IN + f_oNtS);
        test("nullnullsuffix", "" + sf_IN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + sf_IN + f_bl);
        test("nullfalsesuffix", "" + sf_IN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + sf_IN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + sf_IN + sf_iAN);
        test("nullnullsuffix", "" + sf_IN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + sf_IN + sf_iM);
        test("null-2000000suffix", "" + sf_IN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + sf_IN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + sf_IN + f_lM);
        test("null-820130816suffix", "" + sf_IN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + sf_IN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + sf_IN + sf_oAN);
        test("nullnullsuffix", "" + sf_IN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_IN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + sf_IN + s_I);
        test("null25000000suffix", "" + sf_IN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + sf_IN + "suffix1" + s_I + "suffix2");
    }

    public void run3() {
        test("T-96.0", "" + s_c + s_dM);
        test("T-96.0suffix", "" + s_c + s_dM + "suffix");
        test("prefixTsuffix1-96.0suffix2", "prefix" + s_c + "suffix1" + s_dM + "suffix2");
        test("Tnull", "" + s_c + s_oNtS);
        test("Tnullsuffix", "" + s_c + s_oNtS + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + s_oNtS + "suffix2");
        test("T\u045176", "" + s_c + f_strU);
        test("T\u045176suffix", "" + s_c + f_strU + "suffix");
        test("prefixTsuffix1\u045176suffix2", "prefix" + s_c + "suffix1" + f_strU + "suffix2");
        test("T92", "" + s_c + sf_strU2);
        test("T92suffix", "" + s_c + sf_strU2 + "suffix");
        test("prefixTsuffix192suffix2", "prefix" + s_c + "suffix1" + sf_strU2 + "suffix2");
        test("T51", "" + s_c + sf_strU1);
        test("T51suffix", "" + s_c + sf_strU1 + "suffix");
        test("prefixTsuffix151suffix2", "prefix" + s_c + "suffix1" + sf_strU1 + "suffix2");
        test("Tnull", "" + s_c + s_iAN);
        test("Tnullsuffix", "" + s_c + s_iAN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + s_iAN + "suffix2");
        test("T-54", "" + s_c + f_bM);
        test("T-54suffix", "" + s_c + f_bM + "suffix");
        test("prefixTsuffix1-54suffix2", "prefix" + s_c + "suffix1" + f_bM + "suffix2");
        test("T-87.0", "" + s_c + f_fM);
        test("T-87.0suffix", "" + s_c + f_fM + "suffix");
        test("prefixTsuffix1-87.0suffix2", "prefix" + s_c + "suffix1" + f_fM + "suffix2");
        test("Tnull", "" + s_c + s_oAN);
        test("Tnullsuffix", "" + s_c + s_oAN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + s_oAN + "suffix2");
        test("T19", "" + s_c + f_str);
        test("T19suffix", "" + s_c + f_str + "suffix");
        test("prefixTsuffix119suffix2", "prefix" + s_c + "suffix1" + f_str + "suffix2");
        test("T-41", "" + s_c + sf_bM);
        test("T-41suffix", "" + s_c + sf_bM + "suffix");
        test("prefixTsuffix1-41suffix2", "prefix" + s_c + "suffix1" + sf_bM + "suffix2");
        test("Tnull", "" + s_c + sf_IN);
        test("Tnullsuffix", "" + s_c + sf_IN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + sf_IN + "suffix2");
        test("TT", "" + s_c + s_c);
        test("TTsuffix", "" + s_c + s_c + "suffix");
        test("prefixTsuffix1Tsuffix2", "prefix" + s_c + "suffix1" + s_c + "suffix2");
        test("T-42.0", "" + s_c + sf_fM);
        test("T-42.0suffix", "" + s_c + sf_fM + "suffix");
        test("prefixTsuffix1-42.0suffix2", "prefix" + s_c + "suffix1" + sf_fM + "suffix2");
        test("T25", "" + s_c + s_b);
        test("T25suffix", "" + s_c + s_b + "suffix");
        test("prefixTsuffix125suffix2", "prefix" + s_c + "suffix1" + s_b + "suffix2");
        test("Tnull", "" + s_c + f_oN);
        test("Tnullsuffix", "" + s_c + f_oN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + f_oN + "suffix2");
        test("T-1410065408", "" + s_c + s_lM);
        test("T-1410065408suffix", "" + s_c + s_lM + "suffix");
        test("prefixTsuffix1-1410065408suffix2", "prefix" + s_c + "suffix1" + s_lM + "suffix2");
        test("T8.0", "" + s_c + s_d);
        test("T8.0suffix", "" + s_c + s_d + "suffix");
        test("prefixTsuffix18.0suffix2", "prefix" + s_c + "suffix1" + s_d + "suffix2");
        test("T55.0", "" + s_c + s_f);
        test("T55.0suffix", "" + s_c + s_f + "suffix");
        test("prefixTsuffix155.0suffix2", "prefix" + s_c + "suffix1" + s_f + "suffix2");
        test("T97000000", "" + s_c + s_i);
        test("T97000000suffix", "" + s_c + s_i + "suffix");
        test("prefixTsuffix197000000suffix2", "prefix" + s_c + "suffix1" + s_i + "suffix2");
        test("T-9900", "" + s_c + f_sM);
        test("T-9900suffix", "" + s_c + f_sM + "suffix");
        test("prefixTsuffix1-9900suffix2", "prefix" + s_c + "suffix1" + f_sM + "suffix2");
        test("T935228928", "" + s_c + s_l);
        test("T935228928suffix", "" + s_c + s_l + "suffix");
        test("prefixTsuffix1935228928suffix2", "prefix" + s_c + "suffix1" + s_l + "suffix2");
        test("T-8400", "" + s_c + sf_sM);
        test("T-8400suffix", "" + s_c + sf_sM + "suffix");
        test("prefixTsuffix1-8400suffix2", "prefix" + s_c + "suffix1" + sf_sM + "suffix2");
        test("TC(82)", "" + s_c + s_o);
        test("TC(82)suffix", "" + s_c + s_o + "suffix");
        test("prefixTsuffix1C(82)suffix2", "prefix" + s_c + "suffix1" + s_o + "suffix2");
        test("Tnull", "" + s_c + sf_oNtS);
        test("Tnullsuffix", "" + s_c + sf_oNtS + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + sf_oNtS + "suffix2");
        test("Ttrue", "" + s_c + s_bl);
        test("Ttruesuffix", "" + s_c + s_bl + "suffix");
        test("prefixTsuffix1truesuffix2", "prefix" + s_c + "suffix1" + s_bl + "suffix2");
        test("T3900", "" + s_c + s_s);
        test("T3900suffix", "" + s_c + s_s + "suffix");
        test("prefixTsuffix13900suffix2", "prefix" + s_c + "suffix1" + s_s + "suffix2");
        test("Tnull", "" + s_c + sf_oN);
        test("Tnullsuffix", "" + s_c + sf_oN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + sf_oN + "suffix2");
        test("T94000000", "" + s_c + f_I);
        test("T94000000suffix", "" + s_c + f_I + "suffix");
        test("prefixTsuffix194000000suffix2", "prefix" + s_c + "suffix1" + f_I + "suffix2");
        test("Tnull", "" + s_c + f_IN);
        test("Tnullsuffix", "" + s_c + f_IN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + f_IN + "suffix2");
        test("Ttrue", "" + s_c + sf_bl);
        test("Ttruesuffix", "" + s_c + sf_bl + "suffix");
        test("prefixTsuffix1truesuffix2", "prefix" + s_c + "suffix1" + sf_bl + "suffix2");
        test("T5500", "" + s_c + sf_s);
        test("T5500suffix", "" + s_c + sf_s + "suffix");
        test("prefixTsuffix15500suffix2", "prefix" + s_c + "suffix1" + sf_s + "suffix2");
        test("T-2900", "" + s_c + s_sM);
        test("T-2900suffix", "" + s_c + s_sM + "suffix");
        test("prefixTsuffix1-2900suffix2", "prefix" + s_c + "suffix1" + s_sM + "suffix2");
        test("T-194313216", "" + s_c + sf_l);
        test("T-194313216suffix", "" + s_c + sf_l + "suffix");
        test("prefixTsuffix1-194313216suffix2", "prefix" + s_c + "suffix1" + sf_l + "suffix2");
        test("T12", "" + s_c + s_strU1);
        test("T12suffix", "" + s_c + s_strU1 + "suffix");
        test("prefixTsuffix112suffix2", "prefix" + s_c + "suffix1" + s_strU1 + "suffix2");
        test("TC(87)", "" + s_c + sf_o);
        test("TC(87)suffix", "" + s_c + sf_o + "suffix");
        test("prefixTsuffix1C(87)suffix2", "prefix" + s_c + "suffix1" + sf_o + "suffix2");
        test("T91", "" + s_c + s_strU2);
        test("T91suffix", "" + s_c + s_strU2 + "suffix");
        test("prefixTsuffix191suffix2", "prefix" + s_c + "suffix1" + s_strU2 + "suffix2");
        test("T21", "" + s_c + f_strU1);
        test("T21suffix", "" + s_c + f_strU1 + "suffix");
        test("prefixTsuffix121suffix2", "prefix" + s_c + "suffix1" + f_strU1 + "suffix2");
        test("T18", "" + s_c + f_strU2);
        test("T18suffix", "" + s_c + f_strU2 + "suffix");
        test("prefixTsuffix118suffix2", "prefix" + s_c + "suffix1" + f_strU2 + "suffix2");
        test("Tnull", "" + s_c + f_iAN);
        test("Tnullsuffix", "" + s_c + f_iAN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + f_iAN + "suffix2");
        test("Tnull", "" + s_c + s_oN);
        test("Tnullsuffix", "" + s_c + s_oN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + s_oN + "suffix2");
        test("T\u045180", "" + s_c + s_strU);
        test("T\u045180suffix", "" + s_c + s_strU + "suffix");
        test("prefixTsuffix1\u045180suffix2", "prefix" + s_c + "suffix1" + s_strU + "suffix2");
        test("TC", "" + s_c + sf_c);
        test("TCsuffix", "" + s_c + sf_c + "suffix");
        test("prefixTsuffix1Csuffix2", "prefix" + s_c + "suffix1" + sf_c + "suffix2");
        test("T75", "" + s_c + sf_str);
        test("T75suffix", "" + s_c + sf_str + "suffix");
        test("prefixTsuffix175suffix2", "prefix" + s_c + "suffix1" + sf_str + "suffix2");
        test("T-43", "" + s_c + s_bM);
        test("T-43suffix", "" + s_c + s_bM + "suffix");
        test("prefixTsuffix1-43suffix2", "prefix" + s_c + "suffix1" + s_bM + "suffix2");
        test("T80", "" + s_c + sf_b);
        test("T80suffix", "" + s_c + sf_b + "suffix");
        test("prefixTsuffix180suffix2", "prefix" + s_c + "suffix1" + sf_b + "suffix2");
        test("Tnull", "" + s_c + s_IN);
        test("Tnullsuffix", "" + s_c + s_IN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + s_IN + "suffix2");
        test("T-52.0", "" + s_c + s_fM);
        test("T-52.0suffix", "" + s_c + s_fM + "suffix");
        test("prefixTsuffix1-52.0suffix2", "prefix" + s_c + "suffix1" + s_fM + "suffix2");
        test("T75000000", "" + s_c + sf_i);
        test("T75000000suffix", "" + s_c + sf_i + "suffix");
        test("prefixTsuffix175000000suffix2", "prefix" + s_c + "suffix1" + sf_i + "suffix2");
        test("T44", "" + s_c + f_b);
        test("T44suffix", "" + s_c + f_b + "suffix");
        test("prefixTsuffix144suffix2", "prefix" + s_c + "suffix1" + f_b + "suffix2");
        test("T-1705032704", "" + s_c + sf_lM);
        test("T-1705032704suffix", "" + s_c + sf_lM + "suffix");
        test("prefixTsuffix1-1705032704suffix2", "prefix" + s_c + "suffix1" + sf_lM + "suffix2");
        test("Tnull", "" + s_c + f_oAN);
        test("Tnullsuffix", "" + s_c + f_oAN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + f_oAN + "suffix2");
        test("T83.0", "" + s_c + f_d);
        test("T83.0suffix", "" + s_c + f_d + "suffix");
        test("prefixTsuffix183.0suffix2", "prefix" + s_c + "suffix1" + f_d + "suffix2");
        test("TI", "" + s_c + f_c);
        test("TIsuffix", "" + s_c + f_c + "suffix");
        test("prefixTsuffix1Isuffix2", "prefix" + s_c + "suffix1" + f_c + "suffix2");
        test("T94.0", "" + s_c + f_f);
        test("T94.0suffix", "" + s_c + f_f + "suffix");
        test("prefixTsuffix194.0suffix2", "prefix" + s_c + "suffix1" + f_f + "suffix2");
        test("T12.0", "" + s_c + sf_d);
        test("T12.0suffix", "" + s_c + sf_d + "suffix");
        test("prefixTsuffix112.0suffix2", "prefix" + s_c + "suffix1" + sf_d + "suffix2");
        test("T-99.0", "" + s_c + f_dM);
        test("T-99.0suffix", "" + s_c + f_dM + "suffix");
        test("prefixTsuffix1-99.0suffix2", "prefix" + s_c + "suffix1" + f_dM + "suffix2");
        test("T17.0", "" + s_c + sf_f);
        test("T17.0suffix", "" + s_c + sf_f + "suffix");
        test("prefixTsuffix117.0suffix2", "prefix" + s_c + "suffix1" + sf_f + "suffix2");
        test("T-84.0", "" + s_c + sf_dM);
        test("T-84.0suffix", "" + s_c + sf_dM + "suffix");
        test("prefixTsuffix1-84.0suffix2", "prefix" + s_c + "suffix1" + sf_dM + "suffix2");
        test("T58000000", "" + s_c + f_i);
        test("T58000000suffix", "" + s_c + f_i + "suffix");
        test("prefixTsuffix158000000suffix2", "prefix" + s_c + "suffix1" + f_i + "suffix2");
        test("T-55000000", "" + s_c + f_iM);
        test("T-55000000suffix", "" + s_c + f_iM + "suffix");
        test("prefixTsuffix1-55000000suffix2", "prefix" + s_c + "suffix1" + f_iM + "suffix2");
        test("T1460392448", "" + s_c + f_l);
        test("T1460392448suffix", "" + s_c + f_l + "suffix");
        test("prefixTsuffix11460392448suffix2", "prefix" + s_c + "suffix1" + f_l + "suffix2");
        test("TC(70)", "" + s_c + f_o);
        test("TC(70)suffix", "" + s_c + f_o + "suffix");
        test("prefixTsuffix1C(70)suffix2", "prefix" + s_c + "suffix1" + f_o + "suffix2");
        test("T\u04511", "" + s_c + sf_strU);
        test("T\u04511suffix", "" + s_c + sf_strU + "suffix");
        test("prefixTsuffix1\u04511suffix2", "prefix" + s_c + "suffix1" + sf_strU + "suffix2");
        test("T8000", "" + s_c + f_s);
        test("T8000suffix", "" + s_c + f_s + "suffix");
        test("prefixTsuffix18000suffix2", "prefix" + s_c + "suffix1" + f_s + "suffix2");
        test("T18", "" + s_c + s_str);
        test("T18suffix", "" + s_c + s_str + "suffix");
        test("prefixTsuffix118suffix2", "prefix" + s_c + "suffix1" + s_str + "suffix2");
        test("T-1000000", "" + s_c + s_iM);
        test("T-1000000suffix", "" + s_c + s_iM + "suffix");
        test("prefixTsuffix1-1000000suffix2", "prefix" + s_c + "suffix1" + s_iM + "suffix2");
        test("T1000000", "" + s_c + sf_I);
        test("T1000000suffix", "" + s_c + sf_I + "suffix");
        test("prefixTsuffix11000000suffix2", "prefix" + s_c + "suffix1" + sf_I + "suffix2");
        test("Tnull", "" + s_c + f_oNtS);
        test("Tnullsuffix", "" + s_c + f_oNtS + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + f_oNtS + "suffix2");
        test("Tfalse", "" + s_c + f_bl);
        test("Tfalsesuffix", "" + s_c + f_bl + "suffix");
        test("prefixTsuffix1falsesuffix2", "prefix" + s_c + "suffix1" + f_bl + "suffix2");
        test("Tnull", "" + s_c + sf_iAN);
        test("Tnullsuffix", "" + s_c + sf_iAN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + sf_iAN + "suffix2");
        test("T-2000000", "" + s_c + sf_iM);
        test("T-2000000suffix", "" + s_c + sf_iM + "suffix");
        test("prefixTsuffix1-2000000suffix2", "prefix" + s_c + "suffix1" + sf_iM + "suffix2");
        test("T-820130816", "" + s_c + f_lM);
        test("T-820130816suffix", "" + s_c + f_lM + "suffix");
        test("prefixTsuffix1-820130816suffix2", "prefix" + s_c + "suffix1" + f_lM + "suffix2");
        test("Tnull", "" + s_c + sf_oAN);
        test("Tnullsuffix", "" + s_c + sf_oAN + "suffix");
        test("prefixTsuffix1nullsuffix2", "prefix" + s_c + "suffix1" + sf_oAN + "suffix2");
        test("T25000000", "" + s_c + s_I);
        test("T25000000suffix", "" + s_c + s_I + "suffix");
        test("prefixTsuffix125000000suffix2", "prefix" + s_c + "suffix1" + s_I + "suffix2");
        test("-42.0-96.0", "" + sf_fM + s_dM);
        test("-42.0-96.0suffix", "" + sf_fM + s_dM + "suffix");
        test("prefix-42.0suffix1-96.0suffix2", "prefix" + sf_fM + "suffix1" + s_dM + "suffix2");
        test("-42.0null", "" + sf_fM + s_oNtS);
        test("-42.0nullsuffix", "" + sf_fM + s_oNtS + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + s_oNtS + "suffix2");
        test("-42.0\u045176", "" + sf_fM + f_strU);
        test("-42.0\u045176suffix", "" + sf_fM + f_strU + "suffix");
        test("prefix-42.0suffix1\u045176suffix2", "prefix" + sf_fM + "suffix1" + f_strU + "suffix2");
        test("-42.092", "" + sf_fM + sf_strU2);
        test("-42.092suffix", "" + sf_fM + sf_strU2 + "suffix");
        test("prefix-42.0suffix192suffix2", "prefix" + sf_fM + "suffix1" + sf_strU2 + "suffix2");
        test("-42.051", "" + sf_fM + sf_strU1);
        test("-42.051suffix", "" + sf_fM + sf_strU1 + "suffix");
        test("prefix-42.0suffix151suffix2", "prefix" + sf_fM + "suffix1" + sf_strU1 + "suffix2");
        test("-42.0null", "" + sf_fM + s_iAN);
        test("-42.0nullsuffix", "" + sf_fM + s_iAN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + s_iAN + "suffix2");
        test("-42.0-54", "" + sf_fM + f_bM);
        test("-42.0-54suffix", "" + sf_fM + f_bM + "suffix");
        test("prefix-42.0suffix1-54suffix2", "prefix" + sf_fM + "suffix1" + f_bM + "suffix2");
        test("-42.0-87.0", "" + sf_fM + f_fM);
        test("-42.0-87.0suffix", "" + sf_fM + f_fM + "suffix");
        test("prefix-42.0suffix1-87.0suffix2", "prefix" + sf_fM + "suffix1" + f_fM + "suffix2");
        test("-42.0null", "" + sf_fM + s_oAN);
        test("-42.0nullsuffix", "" + sf_fM + s_oAN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + s_oAN + "suffix2");
        test("-42.019", "" + sf_fM + f_str);
        test("-42.019suffix", "" + sf_fM + f_str + "suffix");
        test("prefix-42.0suffix119suffix2", "prefix" + sf_fM + "suffix1" + f_str + "suffix2");
        test("-42.0-41", "" + sf_fM + sf_bM);
        test("-42.0-41suffix", "" + sf_fM + sf_bM + "suffix");
        test("prefix-42.0suffix1-41suffix2", "prefix" + sf_fM + "suffix1" + sf_bM + "suffix2");
        test("-42.0null", "" + sf_fM + sf_IN);
        test("-42.0nullsuffix", "" + sf_fM + sf_IN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + sf_IN + "suffix2");
        test("-42.0T", "" + sf_fM + s_c);
        test("-42.0Tsuffix", "" + sf_fM + s_c + "suffix");
        test("prefix-42.0suffix1Tsuffix2", "prefix" + sf_fM + "suffix1" + s_c + "suffix2");
        test("-42.0-42.0", "" + sf_fM + sf_fM);
        test("-42.0-42.0suffix", "" + sf_fM + sf_fM + "suffix");
        test("prefix-42.0suffix1-42.0suffix2", "prefix" + sf_fM + "suffix1" + sf_fM + "suffix2");
        test("-42.025", "" + sf_fM + s_b);
        test("-42.025suffix", "" + sf_fM + s_b + "suffix");
        test("prefix-42.0suffix125suffix2", "prefix" + sf_fM + "suffix1" + s_b + "suffix2");
        test("-42.0null", "" + sf_fM + f_oN);
        test("-42.0nullsuffix", "" + sf_fM + f_oN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + f_oN + "suffix2");
        test("-42.0-1410065408", "" + sf_fM + s_lM);
        test("-42.0-1410065408suffix", "" + sf_fM + s_lM + "suffix");
        test("prefix-42.0suffix1-1410065408suffix2", "prefix" + sf_fM + "suffix1" + s_lM + "suffix2");
        test("-42.08.0", "" + sf_fM + s_d);
        test("-42.08.0suffix", "" + sf_fM + s_d + "suffix");
        test("prefix-42.0suffix18.0suffix2", "prefix" + sf_fM + "suffix1" + s_d + "suffix2");
        test("-42.055.0", "" + sf_fM + s_f);
        test("-42.055.0suffix", "" + sf_fM + s_f + "suffix");
        test("prefix-42.0suffix155.0suffix2", "prefix" + sf_fM + "suffix1" + s_f + "suffix2");
        test("-42.097000000", "" + sf_fM + s_i);
        test("-42.097000000suffix", "" + sf_fM + s_i + "suffix");
        test("prefix-42.0suffix197000000suffix2", "prefix" + sf_fM + "suffix1" + s_i + "suffix2");
        test("-42.0-9900", "" + sf_fM + f_sM);
        test("-42.0-9900suffix", "" + sf_fM + f_sM + "suffix");
        test("prefix-42.0suffix1-9900suffix2", "prefix" + sf_fM + "suffix1" + f_sM + "suffix2");
        test("-42.0935228928", "" + sf_fM + s_l);
        test("-42.0935228928suffix", "" + sf_fM + s_l + "suffix");
        test("prefix-42.0suffix1935228928suffix2", "prefix" + sf_fM + "suffix1" + s_l + "suffix2");
        test("-42.0-8400", "" + sf_fM + sf_sM);
        test("-42.0-8400suffix", "" + sf_fM + sf_sM + "suffix");
        test("prefix-42.0suffix1-8400suffix2", "prefix" + sf_fM + "suffix1" + sf_sM + "suffix2");
        test("-42.0C(82)", "" + sf_fM + s_o);
        test("-42.0C(82)suffix", "" + sf_fM + s_o + "suffix");
        test("prefix-42.0suffix1C(82)suffix2", "prefix" + sf_fM + "suffix1" + s_o + "suffix2");
        test("-42.0null", "" + sf_fM + sf_oNtS);
        test("-42.0nullsuffix", "" + sf_fM + sf_oNtS + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + sf_oNtS + "suffix2");
        test("-42.0true", "" + sf_fM + s_bl);
        test("-42.0truesuffix", "" + sf_fM + s_bl + "suffix");
        test("prefix-42.0suffix1truesuffix2", "prefix" + sf_fM + "suffix1" + s_bl + "suffix2");
        test("-42.03900", "" + sf_fM + s_s);
        test("-42.03900suffix", "" + sf_fM + s_s + "suffix");
        test("prefix-42.0suffix13900suffix2", "prefix" + sf_fM + "suffix1" + s_s + "suffix2");
        test("-42.0null", "" + sf_fM + sf_oN);
        test("-42.0nullsuffix", "" + sf_fM + sf_oN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + sf_oN + "suffix2");
        test("-42.094000000", "" + sf_fM + f_I);
        test("-42.094000000suffix", "" + sf_fM + f_I + "suffix");
        test("prefix-42.0suffix194000000suffix2", "prefix" + sf_fM + "suffix1" + f_I + "suffix2");
        test("-42.0null", "" + sf_fM + f_IN);
        test("-42.0nullsuffix", "" + sf_fM + f_IN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + f_IN + "suffix2");
        test("-42.0true", "" + sf_fM + sf_bl);
        test("-42.0truesuffix", "" + sf_fM + sf_bl + "suffix");
        test("prefix-42.0suffix1truesuffix2", "prefix" + sf_fM + "suffix1" + sf_bl + "suffix2");
        test("-42.05500", "" + sf_fM + sf_s);
        test("-42.05500suffix", "" + sf_fM + sf_s + "suffix");
        test("prefix-42.0suffix15500suffix2", "prefix" + sf_fM + "suffix1" + sf_s + "suffix2");
        test("-42.0-2900", "" + sf_fM + s_sM);
        test("-42.0-2900suffix", "" + sf_fM + s_sM + "suffix");
        test("prefix-42.0suffix1-2900suffix2", "prefix" + sf_fM + "suffix1" + s_sM + "suffix2");
        test("-42.0-194313216", "" + sf_fM + sf_l);
        test("-42.0-194313216suffix", "" + sf_fM + sf_l + "suffix");
        test("prefix-42.0suffix1-194313216suffix2", "prefix" + sf_fM + "suffix1" + sf_l + "suffix2");
        test("-42.012", "" + sf_fM + s_strU1);
        test("-42.012suffix", "" + sf_fM + s_strU1 + "suffix");
        test("prefix-42.0suffix112suffix2", "prefix" + sf_fM + "suffix1" + s_strU1 + "suffix2");
        test("-42.0C(87)", "" + sf_fM + sf_o);
        test("-42.0C(87)suffix", "" + sf_fM + sf_o + "suffix");
        test("prefix-42.0suffix1C(87)suffix2", "prefix" + sf_fM + "suffix1" + sf_o + "suffix2");
        test("-42.091", "" + sf_fM + s_strU2);
        test("-42.091suffix", "" + sf_fM + s_strU2 + "suffix");
        test("prefix-42.0suffix191suffix2", "prefix" + sf_fM + "suffix1" + s_strU2 + "suffix2");
        test("-42.021", "" + sf_fM + f_strU1);
        test("-42.021suffix", "" + sf_fM + f_strU1 + "suffix");
        test("prefix-42.0suffix121suffix2", "prefix" + sf_fM + "suffix1" + f_strU1 + "suffix2");
        test("-42.018", "" + sf_fM + f_strU2);
        test("-42.018suffix", "" + sf_fM + f_strU2 + "suffix");
        test("prefix-42.0suffix118suffix2", "prefix" + sf_fM + "suffix1" + f_strU2 + "suffix2");
        test("-42.0null", "" + sf_fM + f_iAN);
        test("-42.0nullsuffix", "" + sf_fM + f_iAN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + f_iAN + "suffix2");
        test("-42.0null", "" + sf_fM + s_oN);
        test("-42.0nullsuffix", "" + sf_fM + s_oN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + s_oN + "suffix2");
        test("-42.0\u045180", "" + sf_fM + s_strU);
        test("-42.0\u045180suffix", "" + sf_fM + s_strU + "suffix");
        test("prefix-42.0suffix1\u045180suffix2", "prefix" + sf_fM + "suffix1" + s_strU + "suffix2");
        test("-42.0C", "" + sf_fM + sf_c);
        test("-42.0Csuffix", "" + sf_fM + sf_c + "suffix");
        test("prefix-42.0suffix1Csuffix2", "prefix" + sf_fM + "suffix1" + sf_c + "suffix2");
        test("-42.075", "" + sf_fM + sf_str);
        test("-42.075suffix", "" + sf_fM + sf_str + "suffix");
        test("prefix-42.0suffix175suffix2", "prefix" + sf_fM + "suffix1" + sf_str + "suffix2");
        test("-42.0-43", "" + sf_fM + s_bM);
        test("-42.0-43suffix", "" + sf_fM + s_bM + "suffix");
        test("prefix-42.0suffix1-43suffix2", "prefix" + sf_fM + "suffix1" + s_bM + "suffix2");
        test("-42.080", "" + sf_fM + sf_b);
        test("-42.080suffix", "" + sf_fM + sf_b + "suffix");
        test("prefix-42.0suffix180suffix2", "prefix" + sf_fM + "suffix1" + sf_b + "suffix2");
        test("-42.0null", "" + sf_fM + s_IN);
        test("-42.0nullsuffix", "" + sf_fM + s_IN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + s_IN + "suffix2");
        test("-42.0-52.0", "" + sf_fM + s_fM);
        test("-42.0-52.0suffix", "" + sf_fM + s_fM + "suffix");
        test("prefix-42.0suffix1-52.0suffix2", "prefix" + sf_fM + "suffix1" + s_fM + "suffix2");
        test("-42.075000000", "" + sf_fM + sf_i);
        test("-42.075000000suffix", "" + sf_fM + sf_i + "suffix");
        test("prefix-42.0suffix175000000suffix2", "prefix" + sf_fM + "suffix1" + sf_i + "suffix2");
        test("-42.044", "" + sf_fM + f_b);
        test("-42.044suffix", "" + sf_fM + f_b + "suffix");
        test("prefix-42.0suffix144suffix2", "prefix" + sf_fM + "suffix1" + f_b + "suffix2");
        test("-42.0-1705032704", "" + sf_fM + sf_lM);
        test("-42.0-1705032704suffix", "" + sf_fM + sf_lM + "suffix");
        test("prefix-42.0suffix1-1705032704suffix2", "prefix" + sf_fM + "suffix1" + sf_lM + "suffix2");
        test("-42.0null", "" + sf_fM + f_oAN);
        test("-42.0nullsuffix", "" + sf_fM + f_oAN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + f_oAN + "suffix2");
        test("-42.083.0", "" + sf_fM + f_d);
        test("-42.083.0suffix", "" + sf_fM + f_d + "suffix");
        test("prefix-42.0suffix183.0suffix2", "prefix" + sf_fM + "suffix1" + f_d + "suffix2");
        test("-42.0I", "" + sf_fM + f_c);
        test("-42.0Isuffix", "" + sf_fM + f_c + "suffix");
        test("prefix-42.0suffix1Isuffix2", "prefix" + sf_fM + "suffix1" + f_c + "suffix2");
        test("-42.094.0", "" + sf_fM + f_f);
        test("-42.094.0suffix", "" + sf_fM + f_f + "suffix");
        test("prefix-42.0suffix194.0suffix2", "prefix" + sf_fM + "suffix1" + f_f + "suffix2");
        test("-42.012.0", "" + sf_fM + sf_d);
        test("-42.012.0suffix", "" + sf_fM + sf_d + "suffix");
        test("prefix-42.0suffix112.0suffix2", "prefix" + sf_fM + "suffix1" + sf_d + "suffix2");
        test("-42.0-99.0", "" + sf_fM + f_dM);
        test("-42.0-99.0suffix", "" + sf_fM + f_dM + "suffix");
        test("prefix-42.0suffix1-99.0suffix2", "prefix" + sf_fM + "suffix1" + f_dM + "suffix2");
        test("-42.017.0", "" + sf_fM + sf_f);
        test("-42.017.0suffix", "" + sf_fM + sf_f + "suffix");
        test("prefix-42.0suffix117.0suffix2", "prefix" + sf_fM + "suffix1" + sf_f + "suffix2");
        test("-42.0-84.0", "" + sf_fM + sf_dM);
        test("-42.0-84.0suffix", "" + sf_fM + sf_dM + "suffix");
        test("prefix-42.0suffix1-84.0suffix2", "prefix" + sf_fM + "suffix1" + sf_dM + "suffix2");
        test("-42.058000000", "" + sf_fM + f_i);
        test("-42.058000000suffix", "" + sf_fM + f_i + "suffix");
        test("prefix-42.0suffix158000000suffix2", "prefix" + sf_fM + "suffix1" + f_i + "suffix2");
        test("-42.0-55000000", "" + sf_fM + f_iM);
        test("-42.0-55000000suffix", "" + sf_fM + f_iM + "suffix");
        test("prefix-42.0suffix1-55000000suffix2", "prefix" + sf_fM + "suffix1" + f_iM + "suffix2");
        test("-42.01460392448", "" + sf_fM + f_l);
        test("-42.01460392448suffix", "" + sf_fM + f_l + "suffix");
        test("prefix-42.0suffix11460392448suffix2", "prefix" + sf_fM + "suffix1" + f_l + "suffix2");
        test("-42.0C(70)", "" + sf_fM + f_o);
        test("-42.0C(70)suffix", "" + sf_fM + f_o + "suffix");
        test("prefix-42.0suffix1C(70)suffix2", "prefix" + sf_fM + "suffix1" + f_o + "suffix2");
        test("-42.0\u04511", "" + sf_fM + sf_strU);
        test("-42.0\u04511suffix", "" + sf_fM + sf_strU + "suffix");
        test("prefix-42.0suffix1\u04511suffix2", "prefix" + sf_fM + "suffix1" + sf_strU + "suffix2");
        test("-42.08000", "" + sf_fM + f_s);
        test("-42.08000suffix", "" + sf_fM + f_s + "suffix");
        test("prefix-42.0suffix18000suffix2", "prefix" + sf_fM + "suffix1" + f_s + "suffix2");
        test("-42.018", "" + sf_fM + s_str);
        test("-42.018suffix", "" + sf_fM + s_str + "suffix");
        test("prefix-42.0suffix118suffix2", "prefix" + sf_fM + "suffix1" + s_str + "suffix2");
        test("-42.0-1000000", "" + sf_fM + s_iM);
        test("-42.0-1000000suffix", "" + sf_fM + s_iM + "suffix");
        test("prefix-42.0suffix1-1000000suffix2", "prefix" + sf_fM + "suffix1" + s_iM + "suffix2");
        test("-42.01000000", "" + sf_fM + sf_I);
        test("-42.01000000suffix", "" + sf_fM + sf_I + "suffix");
        test("prefix-42.0suffix11000000suffix2", "prefix" + sf_fM + "suffix1" + sf_I + "suffix2");
        test("-42.0null", "" + sf_fM + f_oNtS);
        test("-42.0nullsuffix", "" + sf_fM + f_oNtS + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + f_oNtS + "suffix2");
        test("-42.0false", "" + sf_fM + f_bl);
        test("-42.0falsesuffix", "" + sf_fM + f_bl + "suffix");
        test("prefix-42.0suffix1falsesuffix2", "prefix" + sf_fM + "suffix1" + f_bl + "suffix2");
        test("-42.0null", "" + sf_fM + sf_iAN);
        test("-42.0nullsuffix", "" + sf_fM + sf_iAN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + sf_iAN + "suffix2");
        test("-42.0-2000000", "" + sf_fM + sf_iM);
        test("-42.0-2000000suffix", "" + sf_fM + sf_iM + "suffix");
        test("prefix-42.0suffix1-2000000suffix2", "prefix" + sf_fM + "suffix1" + sf_iM + "suffix2");
        test("-42.0-820130816", "" + sf_fM + f_lM);
        test("-42.0-820130816suffix", "" + sf_fM + f_lM + "suffix");
        test("prefix-42.0suffix1-820130816suffix2", "prefix" + sf_fM + "suffix1" + f_lM + "suffix2");
        test("-42.0null", "" + sf_fM + sf_oAN);
        test("-42.0nullsuffix", "" + sf_fM + sf_oAN + "suffix");
        test("prefix-42.0suffix1nullsuffix2", "prefix" + sf_fM + "suffix1" + sf_oAN + "suffix2");
        test("-42.025000000", "" + sf_fM + s_I);
        test("-42.025000000suffix", "" + sf_fM + s_I + "suffix");
        test("prefix-42.0suffix125000000suffix2", "prefix" + sf_fM + "suffix1" + s_I + "suffix2");
        test("25-96.0", "" + s_b + s_dM);
        test("25-96.0suffix", "" + s_b + s_dM + "suffix");
        test("prefix25suffix1-96.0suffix2", "prefix" + s_b + "suffix1" + s_dM + "suffix2");
        test("25null", "" + s_b + s_oNtS);
        test("25nullsuffix", "" + s_b + s_oNtS + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + s_oNtS + "suffix2");
        test("25\u045176", "" + s_b + f_strU);
        test("25\u045176suffix", "" + s_b + f_strU + "suffix");
        test("prefix25suffix1\u045176suffix2", "prefix" + s_b + "suffix1" + f_strU + "suffix2");
        test("2592", "" + s_b + sf_strU2);
        test("2592suffix", "" + s_b + sf_strU2 + "suffix");
        test("prefix25suffix192suffix2", "prefix" + s_b + "suffix1" + sf_strU2 + "suffix2");
        test("2551", "" + s_b + sf_strU1);
        test("2551suffix", "" + s_b + sf_strU1 + "suffix");
        test("prefix25suffix151suffix2", "prefix" + s_b + "suffix1" + sf_strU1 + "suffix2");
        test("25null", "" + s_b + s_iAN);
        test("25nullsuffix", "" + s_b + s_iAN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + s_iAN + "suffix2");
        test("25-54", "" + s_b + f_bM);
        test("25-54suffix", "" + s_b + f_bM + "suffix");
        test("prefix25suffix1-54suffix2", "prefix" + s_b + "suffix1" + f_bM + "suffix2");
        test("25-87.0", "" + s_b + f_fM);
        test("25-87.0suffix", "" + s_b + f_fM + "suffix");
        test("prefix25suffix1-87.0suffix2", "prefix" + s_b + "suffix1" + f_fM + "suffix2");
        test("25null", "" + s_b + s_oAN);
        test("25nullsuffix", "" + s_b + s_oAN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + s_oAN + "suffix2");
        test("2519", "" + s_b + f_str);
        test("2519suffix", "" + s_b + f_str + "suffix");
        test("prefix25suffix119suffix2", "prefix" + s_b + "suffix1" + f_str + "suffix2");
        test("25-41", "" + s_b + sf_bM);
        test("25-41suffix", "" + s_b + sf_bM + "suffix");
        test("prefix25suffix1-41suffix2", "prefix" + s_b + "suffix1" + sf_bM + "suffix2");
        test("25null", "" + s_b + sf_IN);
        test("25nullsuffix", "" + s_b + sf_IN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + sf_IN + "suffix2");
        test("25T", "" + s_b + s_c);
        test("25Tsuffix", "" + s_b + s_c + "suffix");
        test("prefix25suffix1Tsuffix2", "prefix" + s_b + "suffix1" + s_c + "suffix2");
        test("25-42.0", "" + s_b + sf_fM);
        test("25-42.0suffix", "" + s_b + sf_fM + "suffix");
        test("prefix25suffix1-42.0suffix2", "prefix" + s_b + "suffix1" + sf_fM + "suffix2");
        test("2525", "" + s_b + s_b);
        test("2525suffix", "" + s_b + s_b + "suffix");
        test("prefix25suffix125suffix2", "prefix" + s_b + "suffix1" + s_b + "suffix2");
        test("25null", "" + s_b + f_oN);
        test("25nullsuffix", "" + s_b + f_oN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + f_oN + "suffix2");
        test("25-1410065408", "" + s_b + s_lM);
        test("25-1410065408suffix", "" + s_b + s_lM + "suffix");
        test("prefix25suffix1-1410065408suffix2", "prefix" + s_b + "suffix1" + s_lM + "suffix2");
        test("258.0", "" + s_b + s_d);
        test("258.0suffix", "" + s_b + s_d + "suffix");
        test("prefix25suffix18.0suffix2", "prefix" + s_b + "suffix1" + s_d + "suffix2");
        test("2555.0", "" + s_b + s_f);
        test("2555.0suffix", "" + s_b + s_f + "suffix");
        test("prefix25suffix155.0suffix2", "prefix" + s_b + "suffix1" + s_f + "suffix2");
        test("2597000000", "" + s_b + s_i);
        test("2597000000suffix", "" + s_b + s_i + "suffix");
        test("prefix25suffix197000000suffix2", "prefix" + s_b + "suffix1" + s_i + "suffix2");
        test("25-9900", "" + s_b + f_sM);
        test("25-9900suffix", "" + s_b + f_sM + "suffix");
        test("prefix25suffix1-9900suffix2", "prefix" + s_b + "suffix1" + f_sM + "suffix2");
        test("25935228928", "" + s_b + s_l);
        test("25935228928suffix", "" + s_b + s_l + "suffix");
        test("prefix25suffix1935228928suffix2", "prefix" + s_b + "suffix1" + s_l + "suffix2");
        test("25-8400", "" + s_b + sf_sM);
        test("25-8400suffix", "" + s_b + sf_sM + "suffix");
        test("prefix25suffix1-8400suffix2", "prefix" + s_b + "suffix1" + sf_sM + "suffix2");
        test("25C(82)", "" + s_b + s_o);
        test("25C(82)suffix", "" + s_b + s_o + "suffix");
        test("prefix25suffix1C(82)suffix2", "prefix" + s_b + "suffix1" + s_o + "suffix2");
        test("25null", "" + s_b + sf_oNtS);
        test("25nullsuffix", "" + s_b + sf_oNtS + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + sf_oNtS + "suffix2");
        test("25true", "" + s_b + s_bl);
        test("25truesuffix", "" + s_b + s_bl + "suffix");
        test("prefix25suffix1truesuffix2", "prefix" + s_b + "suffix1" + s_bl + "suffix2");
        test("253900", "" + s_b + s_s);
        test("253900suffix", "" + s_b + s_s + "suffix");
        test("prefix25suffix13900suffix2", "prefix" + s_b + "suffix1" + s_s + "suffix2");
        test("25null", "" + s_b + sf_oN);
        test("25nullsuffix", "" + s_b + sf_oN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + sf_oN + "suffix2");
        test("2594000000", "" + s_b + f_I);
        test("2594000000suffix", "" + s_b + f_I + "suffix");
        test("prefix25suffix194000000suffix2", "prefix" + s_b + "suffix1" + f_I + "suffix2");
        test("25null", "" + s_b + f_IN);
        test("25nullsuffix", "" + s_b + f_IN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + f_IN + "suffix2");
        test("25true", "" + s_b + sf_bl);
        test("25truesuffix", "" + s_b + sf_bl + "suffix");
        test("prefix25suffix1truesuffix2", "prefix" + s_b + "suffix1" + sf_bl + "suffix2");
        test("255500", "" + s_b + sf_s);
        test("255500suffix", "" + s_b + sf_s + "suffix");
        test("prefix25suffix15500suffix2", "prefix" + s_b + "suffix1" + sf_s + "suffix2");
        test("25-2900", "" + s_b + s_sM);
        test("25-2900suffix", "" + s_b + s_sM + "suffix");
        test("prefix25suffix1-2900suffix2", "prefix" + s_b + "suffix1" + s_sM + "suffix2");
        test("25-194313216", "" + s_b + sf_l);
        test("25-194313216suffix", "" + s_b + sf_l + "suffix");
        test("prefix25suffix1-194313216suffix2", "prefix" + s_b + "suffix1" + sf_l + "suffix2");
        test("2512", "" + s_b + s_strU1);
        test("2512suffix", "" + s_b + s_strU1 + "suffix");
        test("prefix25suffix112suffix2", "prefix" + s_b + "suffix1" + s_strU1 + "suffix2");
        test("25C(87)", "" + s_b + sf_o);
        test("25C(87)suffix", "" + s_b + sf_o + "suffix");
        test("prefix25suffix1C(87)suffix2", "prefix" + s_b + "suffix1" + sf_o + "suffix2");
        test("2591", "" + s_b + s_strU2);
        test("2591suffix", "" + s_b + s_strU2 + "suffix");
        test("prefix25suffix191suffix2", "prefix" + s_b + "suffix1" + s_strU2 + "suffix2");
        test("2521", "" + s_b + f_strU1);
        test("2521suffix", "" + s_b + f_strU1 + "suffix");
        test("prefix25suffix121suffix2", "prefix" + s_b + "suffix1" + f_strU1 + "suffix2");
        test("2518", "" + s_b + f_strU2);
        test("2518suffix", "" + s_b + f_strU2 + "suffix");
        test("prefix25suffix118suffix2", "prefix" + s_b + "suffix1" + f_strU2 + "suffix2");
        test("25null", "" + s_b + f_iAN);
        test("25nullsuffix", "" + s_b + f_iAN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + f_iAN + "suffix2");
        test("25null", "" + s_b + s_oN);
        test("25nullsuffix", "" + s_b + s_oN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + s_oN + "suffix2");
        test("25\u045180", "" + s_b + s_strU);
        test("25\u045180suffix", "" + s_b + s_strU + "suffix");
        test("prefix25suffix1\u045180suffix2", "prefix" + s_b + "suffix1" + s_strU + "suffix2");
        test("25C", "" + s_b + sf_c);
        test("25Csuffix", "" + s_b + sf_c + "suffix");
        test("prefix25suffix1Csuffix2", "prefix" + s_b + "suffix1" + sf_c + "suffix2");
        test("2575", "" + s_b + sf_str);
        test("2575suffix", "" + s_b + sf_str + "suffix");
        test("prefix25suffix175suffix2", "prefix" + s_b + "suffix1" + sf_str + "suffix2");
        test("25-43", "" + s_b + s_bM);
        test("25-43suffix", "" + s_b + s_bM + "suffix");
        test("prefix25suffix1-43suffix2", "prefix" + s_b + "suffix1" + s_bM + "suffix2");
        test("2580", "" + s_b + sf_b);
        test("2580suffix", "" + s_b + sf_b + "suffix");
        test("prefix25suffix180suffix2", "prefix" + s_b + "suffix1" + sf_b + "suffix2");
        test("25null", "" + s_b + s_IN);
        test("25nullsuffix", "" + s_b + s_IN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + s_IN + "suffix2");
        test("25-52.0", "" + s_b + s_fM);
        test("25-52.0suffix", "" + s_b + s_fM + "suffix");
        test("prefix25suffix1-52.0suffix2", "prefix" + s_b + "suffix1" + s_fM + "suffix2");
        test("2575000000", "" + s_b + sf_i);
        test("2575000000suffix", "" + s_b + sf_i + "suffix");
        test("prefix25suffix175000000suffix2", "prefix" + s_b + "suffix1" + sf_i + "suffix2");
        test("2544", "" + s_b + f_b);
        test("2544suffix", "" + s_b + f_b + "suffix");
        test("prefix25suffix144suffix2", "prefix" + s_b + "suffix1" + f_b + "suffix2");
        test("25-1705032704", "" + s_b + sf_lM);
        test("25-1705032704suffix", "" + s_b + sf_lM + "suffix");
        test("prefix25suffix1-1705032704suffix2", "prefix" + s_b + "suffix1" + sf_lM + "suffix2");
        test("25null", "" + s_b + f_oAN);
        test("25nullsuffix", "" + s_b + f_oAN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + f_oAN + "suffix2");
        test("2583.0", "" + s_b + f_d);
        test("2583.0suffix", "" + s_b + f_d + "suffix");
        test("prefix25suffix183.0suffix2", "prefix" + s_b + "suffix1" + f_d + "suffix2");
        test("25I", "" + s_b + f_c);
        test("25Isuffix", "" + s_b + f_c + "suffix");
        test("prefix25suffix1Isuffix2", "prefix" + s_b + "suffix1" + f_c + "suffix2");
        test("2594.0", "" + s_b + f_f);
        test("2594.0suffix", "" + s_b + f_f + "suffix");
        test("prefix25suffix194.0suffix2", "prefix" + s_b + "suffix1" + f_f + "suffix2");
        test("2512.0", "" + s_b + sf_d);
        test("2512.0suffix", "" + s_b + sf_d + "suffix");
        test("prefix25suffix112.0suffix2", "prefix" + s_b + "suffix1" + sf_d + "suffix2");
        test("25-99.0", "" + s_b + f_dM);
        test("25-99.0suffix", "" + s_b + f_dM + "suffix");
        test("prefix25suffix1-99.0suffix2", "prefix" + s_b + "suffix1" + f_dM + "suffix2");
        test("2517.0", "" + s_b + sf_f);
        test("2517.0suffix", "" + s_b + sf_f + "suffix");
        test("prefix25suffix117.0suffix2", "prefix" + s_b + "suffix1" + sf_f + "suffix2");
        test("25-84.0", "" + s_b + sf_dM);
        test("25-84.0suffix", "" + s_b + sf_dM + "suffix");
        test("prefix25suffix1-84.0suffix2", "prefix" + s_b + "suffix1" + sf_dM + "suffix2");
        test("2558000000", "" + s_b + f_i);
        test("2558000000suffix", "" + s_b + f_i + "suffix");
        test("prefix25suffix158000000suffix2", "prefix" + s_b + "suffix1" + f_i + "suffix2");
        test("25-55000000", "" + s_b + f_iM);
        test("25-55000000suffix", "" + s_b + f_iM + "suffix");
        test("prefix25suffix1-55000000suffix2", "prefix" + s_b + "suffix1" + f_iM + "suffix2");
        test("251460392448", "" + s_b + f_l);
        test("251460392448suffix", "" + s_b + f_l + "suffix");
        test("prefix25suffix11460392448suffix2", "prefix" + s_b + "suffix1" + f_l + "suffix2");
        test("25C(70)", "" + s_b + f_o);
        test("25C(70)suffix", "" + s_b + f_o + "suffix");
        test("prefix25suffix1C(70)suffix2", "prefix" + s_b + "suffix1" + f_o + "suffix2");
        test("25\u04511", "" + s_b + sf_strU);
        test("25\u04511suffix", "" + s_b + sf_strU + "suffix");
        test("prefix25suffix1\u04511suffix2", "prefix" + s_b + "suffix1" + sf_strU + "suffix2");
        test("258000", "" + s_b + f_s);
        test("258000suffix", "" + s_b + f_s + "suffix");
        test("prefix25suffix18000suffix2", "prefix" + s_b + "suffix1" + f_s + "suffix2");
        test("2518", "" + s_b + s_str);
        test("2518suffix", "" + s_b + s_str + "suffix");
        test("prefix25suffix118suffix2", "prefix" + s_b + "suffix1" + s_str + "suffix2");
        test("25-1000000", "" + s_b + s_iM);
        test("25-1000000suffix", "" + s_b + s_iM + "suffix");
        test("prefix25suffix1-1000000suffix2", "prefix" + s_b + "suffix1" + s_iM + "suffix2");
        test("251000000", "" + s_b + sf_I);
        test("251000000suffix", "" + s_b + sf_I + "suffix");
        test("prefix25suffix11000000suffix2", "prefix" + s_b + "suffix1" + sf_I + "suffix2");
        test("25null", "" + s_b + f_oNtS);
        test("25nullsuffix", "" + s_b + f_oNtS + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + f_oNtS + "suffix2");
        test("25false", "" + s_b + f_bl);
        test("25falsesuffix", "" + s_b + f_bl + "suffix");
        test("prefix25suffix1falsesuffix2", "prefix" + s_b + "suffix1" + f_bl + "suffix2");
        test("25null", "" + s_b + sf_iAN);
        test("25nullsuffix", "" + s_b + sf_iAN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + sf_iAN + "suffix2");
        test("25-2000000", "" + s_b + sf_iM);
        test("25-2000000suffix", "" + s_b + sf_iM + "suffix");
        test("prefix25suffix1-2000000suffix2", "prefix" + s_b + "suffix1" + sf_iM + "suffix2");
        test("25-820130816", "" + s_b + f_lM);
        test("25-820130816suffix", "" + s_b + f_lM + "suffix");
        test("prefix25suffix1-820130816suffix2", "prefix" + s_b + "suffix1" + f_lM + "suffix2");
        test("25null", "" + s_b + sf_oAN);
        test("25nullsuffix", "" + s_b + sf_oAN + "suffix");
        test("prefix25suffix1nullsuffix2", "prefix" + s_b + "suffix1" + sf_oAN + "suffix2");
        test("2525000000", "" + s_b + s_I);
        test("2525000000suffix", "" + s_b + s_I + "suffix");
        test("prefix25suffix125000000suffix2", "prefix" + s_b + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + f_oN + s_dM);
        test("null-96.0suffix", "" + f_oN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + f_oN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + f_oN + s_oNtS);
        test("nullnullsuffix", "" + f_oN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + f_oN + f_strU);
        test("null\u045176suffix", "" + f_oN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + f_oN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + f_oN + sf_strU2);
        test("null92suffix", "" + f_oN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + f_oN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + f_oN + sf_strU1);
        test("null51suffix", "" + f_oN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + f_oN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + f_oN + s_iAN);
        test("nullnullsuffix", "" + f_oN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + f_oN + f_bM);
        test("null-54suffix", "" + f_oN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + f_oN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + f_oN + f_fM);
        test("null-87.0suffix", "" + f_oN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + f_oN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + f_oN + s_oAN);
        test("nullnullsuffix", "" + f_oN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + f_oN + f_str);
        test("null19suffix", "" + f_oN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + f_oN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + f_oN + sf_bM);
        test("null-41suffix", "" + f_oN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + f_oN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + f_oN + sf_IN);
        test("nullnullsuffix", "" + f_oN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + f_oN + s_c);
        test("nullTsuffix", "" + f_oN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + f_oN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + f_oN + sf_fM);
        test("null-42.0suffix", "" + f_oN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + f_oN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + f_oN + s_b);
        test("null25suffix", "" + f_oN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + f_oN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + f_oN + f_oN);
        test("nullnullsuffix", "" + f_oN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + f_oN + s_lM);
        test("null-1410065408suffix", "" + f_oN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + f_oN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + f_oN + s_d);
        test("null8.0suffix", "" + f_oN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + f_oN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + f_oN + s_f);
        test("null55.0suffix", "" + f_oN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + f_oN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + f_oN + s_i);
        test("null97000000suffix", "" + f_oN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + f_oN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + f_oN + f_sM);
        test("null-9900suffix", "" + f_oN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + f_oN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + f_oN + s_l);
        test("null935228928suffix", "" + f_oN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + f_oN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + f_oN + sf_sM);
        test("null-8400suffix", "" + f_oN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + f_oN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + f_oN + s_o);
        test("nullC(82)suffix", "" + f_oN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + f_oN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + f_oN + sf_oNtS);
        test("nullnullsuffix", "" + f_oN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + f_oN + s_bl);
        test("nulltruesuffix", "" + f_oN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_oN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + f_oN + s_s);
        test("null3900suffix", "" + f_oN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + f_oN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + f_oN + sf_oN);
        test("nullnullsuffix", "" + f_oN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + f_oN + f_I);
        test("null94000000suffix", "" + f_oN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + f_oN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + f_oN + f_IN);
        test("nullnullsuffix", "" + f_oN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + f_oN + sf_bl);
        test("nulltruesuffix", "" + f_oN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_oN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + f_oN + sf_s);
        test("null5500suffix", "" + f_oN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + f_oN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + f_oN + s_sM);
        test("null-2900suffix", "" + f_oN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + f_oN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + f_oN + sf_l);
        test("null-194313216suffix", "" + f_oN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + f_oN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + f_oN + s_strU1);
        test("null12suffix", "" + f_oN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + f_oN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + f_oN + sf_o);
        test("nullC(87)suffix", "" + f_oN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + f_oN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + f_oN + s_strU2);
        test("null91suffix", "" + f_oN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + f_oN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + f_oN + f_strU1);
        test("null21suffix", "" + f_oN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + f_oN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + f_oN + f_strU2);
        test("null18suffix", "" + f_oN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_oN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + f_oN + f_iAN);
        test("nullnullsuffix", "" + f_oN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + f_oN + s_oN);
        test("nullnullsuffix", "" + f_oN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + f_oN + s_strU);
        test("null\u045180suffix", "" + f_oN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + f_oN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + f_oN + sf_c);
        test("nullCsuffix", "" + f_oN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + f_oN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + f_oN + sf_str);
        test("null75suffix", "" + f_oN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + f_oN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + f_oN + s_bM);
        test("null-43suffix", "" + f_oN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + f_oN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + f_oN + sf_b);
        test("null80suffix", "" + f_oN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + f_oN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + f_oN + s_IN);
        test("nullnullsuffix", "" + f_oN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + f_oN + s_fM);
        test("null-52.0suffix", "" + f_oN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + f_oN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + f_oN + sf_i);
        test("null75000000suffix", "" + f_oN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + f_oN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + f_oN + f_b);
        test("null44suffix", "" + f_oN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + f_oN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + f_oN + sf_lM);
        test("null-1705032704suffix", "" + f_oN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + f_oN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + f_oN + f_oAN);
        test("nullnullsuffix", "" + f_oN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + f_oN + f_d);
        test("null83.0suffix", "" + f_oN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + f_oN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + f_oN + f_c);
        test("nullIsuffix", "" + f_oN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + f_oN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + f_oN + f_f);
        test("null94.0suffix", "" + f_oN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + f_oN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + f_oN + sf_d);
        test("null12.0suffix", "" + f_oN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + f_oN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + f_oN + f_dM);
        test("null-99.0suffix", "" + f_oN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + f_oN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + f_oN + sf_f);
        test("null17.0suffix", "" + f_oN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + f_oN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + f_oN + sf_dM);
        test("null-84.0suffix", "" + f_oN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + f_oN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + f_oN + f_i);
        test("null58000000suffix", "" + f_oN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + f_oN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + f_oN + f_iM);
        test("null-55000000suffix", "" + f_oN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + f_oN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + f_oN + f_l);
        test("null1460392448suffix", "" + f_oN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + f_oN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + f_oN + f_o);
        test("nullC(70)suffix", "" + f_oN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + f_oN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + f_oN + sf_strU);
        test("null\u04511suffix", "" + f_oN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + f_oN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + f_oN + f_s);
        test("null8000suffix", "" + f_oN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + f_oN + "suffix1" + f_s + "suffix2");
        test("null18", "" + f_oN + s_str);
        test("null18suffix", "" + f_oN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_oN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + f_oN + s_iM);
        test("null-1000000suffix", "" + f_oN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + f_oN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + f_oN + sf_I);
        test("null1000000suffix", "" + f_oN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + f_oN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + f_oN + f_oNtS);
        test("nullnullsuffix", "" + f_oN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + f_oN + f_bl);
        test("nullfalsesuffix", "" + f_oN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + f_oN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + f_oN + sf_iAN);
        test("nullnullsuffix", "" + f_oN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + f_oN + sf_iM);
        test("null-2000000suffix", "" + f_oN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + f_oN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + f_oN + f_lM);
        test("null-820130816suffix", "" + f_oN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + f_oN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + f_oN + sf_oAN);
        test("nullnullsuffix", "" + f_oN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + f_oN + s_I);
        test("null25000000suffix", "" + f_oN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + f_oN + "suffix1" + s_I + "suffix2");
        test("-1410065408-96.0", "" + s_lM + s_dM);
        test("-1410065408-96.0suffix", "" + s_lM + s_dM + "suffix");
        test("prefix-1410065408suffix1-96.0suffix2", "prefix" + s_lM + "suffix1" + s_dM + "suffix2");
        test("-1410065408null", "" + s_lM + s_oNtS);
        test("-1410065408nullsuffix", "" + s_lM + s_oNtS + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + s_oNtS + "suffix2");
        test("-1410065408\u045176", "" + s_lM + f_strU);
        test("-1410065408\u045176suffix", "" + s_lM + f_strU + "suffix");
        test("prefix-1410065408suffix1\u045176suffix2", "prefix" + s_lM + "suffix1" + f_strU + "suffix2");
        test("-141006540892", "" + s_lM + sf_strU2);
        test("-141006540892suffix", "" + s_lM + sf_strU2 + "suffix");
        test("prefix-1410065408suffix192suffix2", "prefix" + s_lM + "suffix1" + sf_strU2 + "suffix2");
        test("-141006540851", "" + s_lM + sf_strU1);
        test("-141006540851suffix", "" + s_lM + sf_strU1 + "suffix");
        test("prefix-1410065408suffix151suffix2", "prefix" + s_lM + "suffix1" + sf_strU1 + "suffix2");
        test("-1410065408null", "" + s_lM + s_iAN);
        test("-1410065408nullsuffix", "" + s_lM + s_iAN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + s_iAN + "suffix2");
        test("-1410065408-54", "" + s_lM + f_bM);
        test("-1410065408-54suffix", "" + s_lM + f_bM + "suffix");
        test("prefix-1410065408suffix1-54suffix2", "prefix" + s_lM + "suffix1" + f_bM + "suffix2");
        test("-1410065408-87.0", "" + s_lM + f_fM);
        test("-1410065408-87.0suffix", "" + s_lM + f_fM + "suffix");
        test("prefix-1410065408suffix1-87.0suffix2", "prefix" + s_lM + "suffix1" + f_fM + "suffix2");
        test("-1410065408null", "" + s_lM + s_oAN);
        test("-1410065408nullsuffix", "" + s_lM + s_oAN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + s_oAN + "suffix2");
        test("-141006540819", "" + s_lM + f_str);
        test("-141006540819suffix", "" + s_lM + f_str + "suffix");
        test("prefix-1410065408suffix119suffix2", "prefix" + s_lM + "suffix1" + f_str + "suffix2");
        test("-1410065408-41", "" + s_lM + sf_bM);
        test("-1410065408-41suffix", "" + s_lM + sf_bM + "suffix");
        test("prefix-1410065408suffix1-41suffix2", "prefix" + s_lM + "suffix1" + sf_bM + "suffix2");
        test("-1410065408null", "" + s_lM + sf_IN);
        test("-1410065408nullsuffix", "" + s_lM + sf_IN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + sf_IN + "suffix2");
        test("-1410065408T", "" + s_lM + s_c);
        test("-1410065408Tsuffix", "" + s_lM + s_c + "suffix");
        test("prefix-1410065408suffix1Tsuffix2", "prefix" + s_lM + "suffix1" + s_c + "suffix2");
        test("-1410065408-42.0", "" + s_lM + sf_fM);
        test("-1410065408-42.0suffix", "" + s_lM + sf_fM + "suffix");
        test("prefix-1410065408suffix1-42.0suffix2", "prefix" + s_lM + "suffix1" + sf_fM + "suffix2");
        test("-141006540825", "" + s_lM + s_b);
        test("-141006540825suffix", "" + s_lM + s_b + "suffix");
        test("prefix-1410065408suffix125suffix2", "prefix" + s_lM + "suffix1" + s_b + "suffix2");
        test("-1410065408null", "" + s_lM + f_oN);
        test("-1410065408nullsuffix", "" + s_lM + f_oN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + f_oN + "suffix2");
        test("-1410065408-1410065408", "" + s_lM + s_lM);
        test("-1410065408-1410065408suffix", "" + s_lM + s_lM + "suffix");
        test("prefix-1410065408suffix1-1410065408suffix2", "prefix" + s_lM + "suffix1" + s_lM + "suffix2");
        test("-14100654088.0", "" + s_lM + s_d);
        test("-14100654088.0suffix", "" + s_lM + s_d + "suffix");
        test("prefix-1410065408suffix18.0suffix2", "prefix" + s_lM + "suffix1" + s_d + "suffix2");
        test("-141006540855.0", "" + s_lM + s_f);
        test("-141006540855.0suffix", "" + s_lM + s_f + "suffix");
        test("prefix-1410065408suffix155.0suffix2", "prefix" + s_lM + "suffix1" + s_f + "suffix2");
        test("-141006540897000000", "" + s_lM + s_i);
        test("-141006540897000000suffix", "" + s_lM + s_i + "suffix");
        test("prefix-1410065408suffix197000000suffix2", "prefix" + s_lM + "suffix1" + s_i + "suffix2");
        test("-1410065408-9900", "" + s_lM + f_sM);
        test("-1410065408-9900suffix", "" + s_lM + f_sM + "suffix");
        test("prefix-1410065408suffix1-9900suffix2", "prefix" + s_lM + "suffix1" + f_sM + "suffix2");
        test("-1410065408935228928", "" + s_lM + s_l);
        test("-1410065408935228928suffix", "" + s_lM + s_l + "suffix");
        test("prefix-1410065408suffix1935228928suffix2", "prefix" + s_lM + "suffix1" + s_l + "suffix2");
        test("-1410065408-8400", "" + s_lM + sf_sM);
        test("-1410065408-8400suffix", "" + s_lM + sf_sM + "suffix");
        test("prefix-1410065408suffix1-8400suffix2", "prefix" + s_lM + "suffix1" + sf_sM + "suffix2");
        test("-1410065408C(82)", "" + s_lM + s_o);
        test("-1410065408C(82)suffix", "" + s_lM + s_o + "suffix");
        test("prefix-1410065408suffix1C(82)suffix2", "prefix" + s_lM + "suffix1" + s_o + "suffix2");
        test("-1410065408null", "" + s_lM + sf_oNtS);
        test("-1410065408nullsuffix", "" + s_lM + sf_oNtS + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + sf_oNtS + "suffix2");
        test("-1410065408true", "" + s_lM + s_bl);
        test("-1410065408truesuffix", "" + s_lM + s_bl + "suffix");
        test("prefix-1410065408suffix1truesuffix2", "prefix" + s_lM + "suffix1" + s_bl + "suffix2");
        test("-14100654083900", "" + s_lM + s_s);
        test("-14100654083900suffix", "" + s_lM + s_s + "suffix");
        test("prefix-1410065408suffix13900suffix2", "prefix" + s_lM + "suffix1" + s_s + "suffix2");
        test("-1410065408null", "" + s_lM + sf_oN);
        test("-1410065408nullsuffix", "" + s_lM + sf_oN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + sf_oN + "suffix2");
        test("-141006540894000000", "" + s_lM + f_I);
        test("-141006540894000000suffix", "" + s_lM + f_I + "suffix");
        test("prefix-1410065408suffix194000000suffix2", "prefix" + s_lM + "suffix1" + f_I + "suffix2");
        test("-1410065408null", "" + s_lM + f_IN);
        test("-1410065408nullsuffix", "" + s_lM + f_IN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + f_IN + "suffix2");
        test("-1410065408true", "" + s_lM + sf_bl);
        test("-1410065408truesuffix", "" + s_lM + sf_bl + "suffix");
        test("prefix-1410065408suffix1truesuffix2", "prefix" + s_lM + "suffix1" + sf_bl + "suffix2");
        test("-14100654085500", "" + s_lM + sf_s);
        test("-14100654085500suffix", "" + s_lM + sf_s + "suffix");
        test("prefix-1410065408suffix15500suffix2", "prefix" + s_lM + "suffix1" + sf_s + "suffix2");
        test("-1410065408-2900", "" + s_lM + s_sM);
        test("-1410065408-2900suffix", "" + s_lM + s_sM + "suffix");
        test("prefix-1410065408suffix1-2900suffix2", "prefix" + s_lM + "suffix1" + s_sM + "suffix2");
        test("-1410065408-194313216", "" + s_lM + sf_l);
    }

    public void run4() {
        test("-1410065408-194313216suffix", "" + s_lM + sf_l + "suffix");
        test("prefix-1410065408suffix1-194313216suffix2", "prefix" + s_lM + "suffix1" + sf_l + "suffix2");
        test("-141006540812", "" + s_lM + s_strU1);
        test("-141006540812suffix", "" + s_lM + s_strU1 + "suffix");
        test("prefix-1410065408suffix112suffix2", "prefix" + s_lM + "suffix1" + s_strU1 + "suffix2");
        test("-1410065408C(87)", "" + s_lM + sf_o);
        test("-1410065408C(87)suffix", "" + s_lM + sf_o + "suffix");
        test("prefix-1410065408suffix1C(87)suffix2", "prefix" + s_lM + "suffix1" + sf_o + "suffix2");
        test("-141006540891", "" + s_lM + s_strU2);
        test("-141006540891suffix", "" + s_lM + s_strU2 + "suffix");
        test("prefix-1410065408suffix191suffix2", "prefix" + s_lM + "suffix1" + s_strU2 + "suffix2");
        test("-141006540821", "" + s_lM + f_strU1);
        test("-141006540821suffix", "" + s_lM + f_strU1 + "suffix");
        test("prefix-1410065408suffix121suffix2", "prefix" + s_lM + "suffix1" + f_strU1 + "suffix2");
        test("-141006540818", "" + s_lM + f_strU2);
        test("-141006540818suffix", "" + s_lM + f_strU2 + "suffix");
        test("prefix-1410065408suffix118suffix2", "prefix" + s_lM + "suffix1" + f_strU2 + "suffix2");
        test("-1410065408null", "" + s_lM + f_iAN);
        test("-1410065408nullsuffix", "" + s_lM + f_iAN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + f_iAN + "suffix2");
        test("-1410065408null", "" + s_lM + s_oN);
        test("-1410065408nullsuffix", "" + s_lM + s_oN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + s_oN + "suffix2");
        test("-1410065408\u045180", "" + s_lM + s_strU);
        test("-1410065408\u045180suffix", "" + s_lM + s_strU + "suffix");
        test("prefix-1410065408suffix1\u045180suffix2", "prefix" + s_lM + "suffix1" + s_strU + "suffix2");
        test("-1410065408C", "" + s_lM + sf_c);
        test("-1410065408Csuffix", "" + s_lM + sf_c + "suffix");
        test("prefix-1410065408suffix1Csuffix2", "prefix" + s_lM + "suffix1" + sf_c + "suffix2");
        test("-141006540875", "" + s_lM + sf_str);
        test("-141006540875suffix", "" + s_lM + sf_str + "suffix");
        test("prefix-1410065408suffix175suffix2", "prefix" + s_lM + "suffix1" + sf_str + "suffix2");
        test("-1410065408-43", "" + s_lM + s_bM);
        test("-1410065408-43suffix", "" + s_lM + s_bM + "suffix");
        test("prefix-1410065408suffix1-43suffix2", "prefix" + s_lM + "suffix1" + s_bM + "suffix2");
        test("-141006540880", "" + s_lM + sf_b);
        test("-141006540880suffix", "" + s_lM + sf_b + "suffix");
        test("prefix-1410065408suffix180suffix2", "prefix" + s_lM + "suffix1" + sf_b + "suffix2");
        test("-1410065408null", "" + s_lM + s_IN);
        test("-1410065408nullsuffix", "" + s_lM + s_IN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + s_IN + "suffix2");
        test("-1410065408-52.0", "" + s_lM + s_fM);
        test("-1410065408-52.0suffix", "" + s_lM + s_fM + "suffix");
        test("prefix-1410065408suffix1-52.0suffix2", "prefix" + s_lM + "suffix1" + s_fM + "suffix2");
        test("-141006540875000000", "" + s_lM + sf_i);
        test("-141006540875000000suffix", "" + s_lM + sf_i + "suffix");
        test("prefix-1410065408suffix175000000suffix2", "prefix" + s_lM + "suffix1" + sf_i + "suffix2");
        test("-141006540844", "" + s_lM + f_b);
        test("-141006540844suffix", "" + s_lM + f_b + "suffix");
        test("prefix-1410065408suffix144suffix2", "prefix" + s_lM + "suffix1" + f_b + "suffix2");
        test("-1410065408-1705032704", "" + s_lM + sf_lM);
        test("-1410065408-1705032704suffix", "" + s_lM + sf_lM + "suffix");
        test("prefix-1410065408suffix1-1705032704suffix2", "prefix" + s_lM + "suffix1" + sf_lM + "suffix2");
        test("-1410065408null", "" + s_lM + f_oAN);
        test("-1410065408nullsuffix", "" + s_lM + f_oAN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + f_oAN + "suffix2");
        test("-141006540883.0", "" + s_lM + f_d);
        test("-141006540883.0suffix", "" + s_lM + f_d + "suffix");
        test("prefix-1410065408suffix183.0suffix2", "prefix" + s_lM + "suffix1" + f_d + "suffix2");
        test("-1410065408I", "" + s_lM + f_c);
        test("-1410065408Isuffix", "" + s_lM + f_c + "suffix");
        test("prefix-1410065408suffix1Isuffix2", "prefix" + s_lM + "suffix1" + f_c + "suffix2");
        test("-141006540894.0", "" + s_lM + f_f);
        test("-141006540894.0suffix", "" + s_lM + f_f + "suffix");
        test("prefix-1410065408suffix194.0suffix2", "prefix" + s_lM + "suffix1" + f_f + "suffix2");
        test("-141006540812.0", "" + s_lM + sf_d);
        test("-141006540812.0suffix", "" + s_lM + sf_d + "suffix");
        test("prefix-1410065408suffix112.0suffix2", "prefix" + s_lM + "suffix1" + sf_d + "suffix2");
        test("-1410065408-99.0", "" + s_lM + f_dM);
        test("-1410065408-99.0suffix", "" + s_lM + f_dM + "suffix");
        test("prefix-1410065408suffix1-99.0suffix2", "prefix" + s_lM + "suffix1" + f_dM + "suffix2");
        test("-141006540817.0", "" + s_lM + sf_f);
        test("-141006540817.0suffix", "" + s_lM + sf_f + "suffix");
        test("prefix-1410065408suffix117.0suffix2", "prefix" + s_lM + "suffix1" + sf_f + "suffix2");
        test("-1410065408-84.0", "" + s_lM + sf_dM);
        test("-1410065408-84.0suffix", "" + s_lM + sf_dM + "suffix");
        test("prefix-1410065408suffix1-84.0suffix2", "prefix" + s_lM + "suffix1" + sf_dM + "suffix2");
        test("-141006540858000000", "" + s_lM + f_i);
        test("-141006540858000000suffix", "" + s_lM + f_i + "suffix");
        test("prefix-1410065408suffix158000000suffix2", "prefix" + s_lM + "suffix1" + f_i + "suffix2");
        test("-1410065408-55000000", "" + s_lM + f_iM);
        test("-1410065408-55000000suffix", "" + s_lM + f_iM + "suffix");
        test("prefix-1410065408suffix1-55000000suffix2", "prefix" + s_lM + "suffix1" + f_iM + "suffix2");
        test("-14100654081460392448", "" + s_lM + f_l);
        test("-14100654081460392448suffix", "" + s_lM + f_l + "suffix");
        test("prefix-1410065408suffix11460392448suffix2", "prefix" + s_lM + "suffix1" + f_l + "suffix2");
        test("-1410065408C(70)", "" + s_lM + f_o);
        test("-1410065408C(70)suffix", "" + s_lM + f_o + "suffix");
        test("prefix-1410065408suffix1C(70)suffix2", "prefix" + s_lM + "suffix1" + f_o + "suffix2");
        test("-1410065408\u04511", "" + s_lM + sf_strU);
        test("-1410065408\u04511suffix", "" + s_lM + sf_strU + "suffix");
        test("prefix-1410065408suffix1\u04511suffix2", "prefix" + s_lM + "suffix1" + sf_strU + "suffix2");
        test("-14100654088000", "" + s_lM + f_s);
        test("-14100654088000suffix", "" + s_lM + f_s + "suffix");
        test("prefix-1410065408suffix18000suffix2", "prefix" + s_lM + "suffix1" + f_s + "suffix2");
        test("-141006540818", "" + s_lM + s_str);
        test("-141006540818suffix", "" + s_lM + s_str + "suffix");
        test("prefix-1410065408suffix118suffix2", "prefix" + s_lM + "suffix1" + s_str + "suffix2");
        test("-1410065408-1000000", "" + s_lM + s_iM);
        test("-1410065408-1000000suffix", "" + s_lM + s_iM + "suffix");
        test("prefix-1410065408suffix1-1000000suffix2", "prefix" + s_lM + "suffix1" + s_iM + "suffix2");
        test("-14100654081000000", "" + s_lM + sf_I);
        test("-14100654081000000suffix", "" + s_lM + sf_I + "suffix");
        test("prefix-1410065408suffix11000000suffix2", "prefix" + s_lM + "suffix1" + sf_I + "suffix2");
        test("-1410065408null", "" + s_lM + f_oNtS);
        test("-1410065408nullsuffix", "" + s_lM + f_oNtS + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + f_oNtS + "suffix2");
        test("-1410065408false", "" + s_lM + f_bl);
        test("-1410065408falsesuffix", "" + s_lM + f_bl + "suffix");
        test("prefix-1410065408suffix1falsesuffix2", "prefix" + s_lM + "suffix1" + f_bl + "suffix2");
        test("-1410065408null", "" + s_lM + sf_iAN);
        test("-1410065408nullsuffix", "" + s_lM + sf_iAN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + sf_iAN + "suffix2");
        test("-1410065408-2000000", "" + s_lM + sf_iM);
        test("-1410065408-2000000suffix", "" + s_lM + sf_iM + "suffix");
        test("prefix-1410065408suffix1-2000000suffix2", "prefix" + s_lM + "suffix1" + sf_iM + "suffix2");
        test("-1410065408-820130816", "" + s_lM + f_lM);
        test("-1410065408-820130816suffix", "" + s_lM + f_lM + "suffix");
        test("prefix-1410065408suffix1-820130816suffix2", "prefix" + s_lM + "suffix1" + f_lM + "suffix2");
        test("-1410065408null", "" + s_lM + sf_oAN);
        test("-1410065408nullsuffix", "" + s_lM + sf_oAN + "suffix");
        test("prefix-1410065408suffix1nullsuffix2", "prefix" + s_lM + "suffix1" + sf_oAN + "suffix2");
        test("-141006540825000000", "" + s_lM + s_I);
        test("-141006540825000000suffix", "" + s_lM + s_I + "suffix");
        test("prefix-1410065408suffix125000000suffix2", "prefix" + s_lM + "suffix1" + s_I + "suffix2");
        test("8.0-96.0", "" + s_d + s_dM);
        test("8.0-96.0suffix", "" + s_d + s_dM + "suffix");
        test("prefix8.0suffix1-96.0suffix2", "prefix" + s_d + "suffix1" + s_dM + "suffix2");
        test("8.0null", "" + s_d + s_oNtS);
        test("8.0nullsuffix", "" + s_d + s_oNtS + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + s_oNtS + "suffix2");
        test("8.0\u045176", "" + s_d + f_strU);
        test("8.0\u045176suffix", "" + s_d + f_strU + "suffix");
        test("prefix8.0suffix1\u045176suffix2", "prefix" + s_d + "suffix1" + f_strU + "suffix2");
        test("8.092", "" + s_d + sf_strU2);
        test("8.092suffix", "" + s_d + sf_strU2 + "suffix");
        test("prefix8.0suffix192suffix2", "prefix" + s_d + "suffix1" + sf_strU2 + "suffix2");
        test("8.051", "" + s_d + sf_strU1);
        test("8.051suffix", "" + s_d + sf_strU1 + "suffix");
        test("prefix8.0suffix151suffix2", "prefix" + s_d + "suffix1" + sf_strU1 + "suffix2");
        test("8.0null", "" + s_d + s_iAN);
        test("8.0nullsuffix", "" + s_d + s_iAN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + s_iAN + "suffix2");
        test("8.0-54", "" + s_d + f_bM);
        test("8.0-54suffix", "" + s_d + f_bM + "suffix");
        test("prefix8.0suffix1-54suffix2", "prefix" + s_d + "suffix1" + f_bM + "suffix2");
        test("8.0-87.0", "" + s_d + f_fM);
        test("8.0-87.0suffix", "" + s_d + f_fM + "suffix");
        test("prefix8.0suffix1-87.0suffix2", "prefix" + s_d + "suffix1" + f_fM + "suffix2");
        test("8.0null", "" + s_d + s_oAN);
        test("8.0nullsuffix", "" + s_d + s_oAN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + s_oAN + "suffix2");
        test("8.019", "" + s_d + f_str);
        test("8.019suffix", "" + s_d + f_str + "suffix");
        test("prefix8.0suffix119suffix2", "prefix" + s_d + "suffix1" + f_str + "suffix2");
        test("8.0-41", "" + s_d + sf_bM);
        test("8.0-41suffix", "" + s_d + sf_bM + "suffix");
        test("prefix8.0suffix1-41suffix2", "prefix" + s_d + "suffix1" + sf_bM + "suffix2");
        test("8.0null", "" + s_d + sf_IN);
        test("8.0nullsuffix", "" + s_d + sf_IN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + sf_IN + "suffix2");
        test("8.0T", "" + s_d + s_c);
        test("8.0Tsuffix", "" + s_d + s_c + "suffix");
        test("prefix8.0suffix1Tsuffix2", "prefix" + s_d + "suffix1" + s_c + "suffix2");
        test("8.0-42.0", "" + s_d + sf_fM);
        test("8.0-42.0suffix", "" + s_d + sf_fM + "suffix");
        test("prefix8.0suffix1-42.0suffix2", "prefix" + s_d + "suffix1" + sf_fM + "suffix2");
        test("8.025", "" + s_d + s_b);
        test("8.025suffix", "" + s_d + s_b + "suffix");
        test("prefix8.0suffix125suffix2", "prefix" + s_d + "suffix1" + s_b + "suffix2");
        test("8.0null", "" + s_d + f_oN);
        test("8.0nullsuffix", "" + s_d + f_oN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + f_oN + "suffix2");
        test("8.0-1410065408", "" + s_d + s_lM);
        test("8.0-1410065408suffix", "" + s_d + s_lM + "suffix");
        test("prefix8.0suffix1-1410065408suffix2", "prefix" + s_d + "suffix1" + s_lM + "suffix2");
        test("8.08.0", "" + s_d + s_d);
        test("8.08.0suffix", "" + s_d + s_d + "suffix");
        test("prefix8.0suffix18.0suffix2", "prefix" + s_d + "suffix1" + s_d + "suffix2");
        test("8.055.0", "" + s_d + s_f);
        test("8.055.0suffix", "" + s_d + s_f + "suffix");
        test("prefix8.0suffix155.0suffix2", "prefix" + s_d + "suffix1" + s_f + "suffix2");
        test("8.097000000", "" + s_d + s_i);
        test("8.097000000suffix", "" + s_d + s_i + "suffix");
        test("prefix8.0suffix197000000suffix2", "prefix" + s_d + "suffix1" + s_i + "suffix2");
        test("8.0-9900", "" + s_d + f_sM);
        test("8.0-9900suffix", "" + s_d + f_sM + "suffix");
        test("prefix8.0suffix1-9900suffix2", "prefix" + s_d + "suffix1" + f_sM + "suffix2");
        test("8.0935228928", "" + s_d + s_l);
        test("8.0935228928suffix", "" + s_d + s_l + "suffix");
        test("prefix8.0suffix1935228928suffix2", "prefix" + s_d + "suffix1" + s_l + "suffix2");
        test("8.0-8400", "" + s_d + sf_sM);
        test("8.0-8400suffix", "" + s_d + sf_sM + "suffix");
        test("prefix8.0suffix1-8400suffix2", "prefix" + s_d + "suffix1" + sf_sM + "suffix2");
        test("8.0C(82)", "" + s_d + s_o);
        test("8.0C(82)suffix", "" + s_d + s_o + "suffix");
        test("prefix8.0suffix1C(82)suffix2", "prefix" + s_d + "suffix1" + s_o + "suffix2");
        test("8.0null", "" + s_d + sf_oNtS);
        test("8.0nullsuffix", "" + s_d + sf_oNtS + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + sf_oNtS + "suffix2");
        test("8.0true", "" + s_d + s_bl);
        test("8.0truesuffix", "" + s_d + s_bl + "suffix");
        test("prefix8.0suffix1truesuffix2", "prefix" + s_d + "suffix1" + s_bl + "suffix2");
        test("8.03900", "" + s_d + s_s);
        test("8.03900suffix", "" + s_d + s_s + "suffix");
        test("prefix8.0suffix13900suffix2", "prefix" + s_d + "suffix1" + s_s + "suffix2");
        test("8.0null", "" + s_d + sf_oN);
        test("8.0nullsuffix", "" + s_d + sf_oN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + sf_oN + "suffix2");
        test("8.094000000", "" + s_d + f_I);
        test("8.094000000suffix", "" + s_d + f_I + "suffix");
        test("prefix8.0suffix194000000suffix2", "prefix" + s_d + "suffix1" + f_I + "suffix2");
        test("8.0null", "" + s_d + f_IN);
        test("8.0nullsuffix", "" + s_d + f_IN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + f_IN + "suffix2");
        test("8.0true", "" + s_d + sf_bl);
        test("8.0truesuffix", "" + s_d + sf_bl + "suffix");
        test("prefix8.0suffix1truesuffix2", "prefix" + s_d + "suffix1" + sf_bl + "suffix2");
        test("8.05500", "" + s_d + sf_s);
        test("8.05500suffix", "" + s_d + sf_s + "suffix");
        test("prefix8.0suffix15500suffix2", "prefix" + s_d + "suffix1" + sf_s + "suffix2");
        test("8.0-2900", "" + s_d + s_sM);
        test("8.0-2900suffix", "" + s_d + s_sM + "suffix");
        test("prefix8.0suffix1-2900suffix2", "prefix" + s_d + "suffix1" + s_sM + "suffix2");
        test("8.0-194313216", "" + s_d + sf_l);
        test("8.0-194313216suffix", "" + s_d + sf_l + "suffix");
        test("prefix8.0suffix1-194313216suffix2", "prefix" + s_d + "suffix1" + sf_l + "suffix2");
        test("8.012", "" + s_d + s_strU1);
        test("8.012suffix", "" + s_d + s_strU1 + "suffix");
        test("prefix8.0suffix112suffix2", "prefix" + s_d + "suffix1" + s_strU1 + "suffix2");
        test("8.0C(87)", "" + s_d + sf_o);
        test("8.0C(87)suffix", "" + s_d + sf_o + "suffix");
        test("prefix8.0suffix1C(87)suffix2", "prefix" + s_d + "suffix1" + sf_o + "suffix2");
        test("8.091", "" + s_d + s_strU2);
        test("8.091suffix", "" + s_d + s_strU2 + "suffix");
        test("prefix8.0suffix191suffix2", "prefix" + s_d + "suffix1" + s_strU2 + "suffix2");
        test("8.021", "" + s_d + f_strU1);
        test("8.021suffix", "" + s_d + f_strU1 + "suffix");
        test("prefix8.0suffix121suffix2", "prefix" + s_d + "suffix1" + f_strU1 + "suffix2");
        test("8.018", "" + s_d + f_strU2);
        test("8.018suffix", "" + s_d + f_strU2 + "suffix");
        test("prefix8.0suffix118suffix2", "prefix" + s_d + "suffix1" + f_strU2 + "suffix2");
        test("8.0null", "" + s_d + f_iAN);
        test("8.0nullsuffix", "" + s_d + f_iAN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + f_iAN + "suffix2");
        test("8.0null", "" + s_d + s_oN);
        test("8.0nullsuffix", "" + s_d + s_oN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + s_oN + "suffix2");
        test("8.0\u045180", "" + s_d + s_strU);
        test("8.0\u045180suffix", "" + s_d + s_strU + "suffix");
        test("prefix8.0suffix1\u045180suffix2", "prefix" + s_d + "suffix1" + s_strU + "suffix2");
        test("8.0C", "" + s_d + sf_c);
        test("8.0Csuffix", "" + s_d + sf_c + "suffix");
        test("prefix8.0suffix1Csuffix2", "prefix" + s_d + "suffix1" + sf_c + "suffix2");
        test("8.075", "" + s_d + sf_str);
        test("8.075suffix", "" + s_d + sf_str + "suffix");
        test("prefix8.0suffix175suffix2", "prefix" + s_d + "suffix1" + sf_str + "suffix2");
        test("8.0-43", "" + s_d + s_bM);
        test("8.0-43suffix", "" + s_d + s_bM + "suffix");
        test("prefix8.0suffix1-43suffix2", "prefix" + s_d + "suffix1" + s_bM + "suffix2");
        test("8.080", "" + s_d + sf_b);
        test("8.080suffix", "" + s_d + sf_b + "suffix");
        test("prefix8.0suffix180suffix2", "prefix" + s_d + "suffix1" + sf_b + "suffix2");
        test("8.0null", "" + s_d + s_IN);
        test("8.0nullsuffix", "" + s_d + s_IN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + s_IN + "suffix2");
        test("8.0-52.0", "" + s_d + s_fM);
        test("8.0-52.0suffix", "" + s_d + s_fM + "suffix");
        test("prefix8.0suffix1-52.0suffix2", "prefix" + s_d + "suffix1" + s_fM + "suffix2");
        test("8.075000000", "" + s_d + sf_i);
        test("8.075000000suffix", "" + s_d + sf_i + "suffix");
        test("prefix8.0suffix175000000suffix2", "prefix" + s_d + "suffix1" + sf_i + "suffix2");
        test("8.044", "" + s_d + f_b);
        test("8.044suffix", "" + s_d + f_b + "suffix");
        test("prefix8.0suffix144suffix2", "prefix" + s_d + "suffix1" + f_b + "suffix2");
        test("8.0-1705032704", "" + s_d + sf_lM);
        test("8.0-1705032704suffix", "" + s_d + sf_lM + "suffix");
        test("prefix8.0suffix1-1705032704suffix2", "prefix" + s_d + "suffix1" + sf_lM + "suffix2");
        test("8.0null", "" + s_d + f_oAN);
        test("8.0nullsuffix", "" + s_d + f_oAN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + f_oAN + "suffix2");
        test("8.083.0", "" + s_d + f_d);
        test("8.083.0suffix", "" + s_d + f_d + "suffix");
        test("prefix8.0suffix183.0suffix2", "prefix" + s_d + "suffix1" + f_d + "suffix2");
        test("8.0I", "" + s_d + f_c);
        test("8.0Isuffix", "" + s_d + f_c + "suffix");
        test("prefix8.0suffix1Isuffix2", "prefix" + s_d + "suffix1" + f_c + "suffix2");
        test("8.094.0", "" + s_d + f_f);
        test("8.094.0suffix", "" + s_d + f_f + "suffix");
        test("prefix8.0suffix194.0suffix2", "prefix" + s_d + "suffix1" + f_f + "suffix2");
        test("8.012.0", "" + s_d + sf_d);
        test("8.012.0suffix", "" + s_d + sf_d + "suffix");
        test("prefix8.0suffix112.0suffix2", "prefix" + s_d + "suffix1" + sf_d + "suffix2");
        test("8.0-99.0", "" + s_d + f_dM);
        test("8.0-99.0suffix", "" + s_d + f_dM + "suffix");
        test("prefix8.0suffix1-99.0suffix2", "prefix" + s_d + "suffix1" + f_dM + "suffix2");
        test("8.017.0", "" + s_d + sf_f);
        test("8.017.0suffix", "" + s_d + sf_f + "suffix");
        test("prefix8.0suffix117.0suffix2", "prefix" + s_d + "suffix1" + sf_f + "suffix2");
        test("8.0-84.0", "" + s_d + sf_dM);
        test("8.0-84.0suffix", "" + s_d + sf_dM + "suffix");
        test("prefix8.0suffix1-84.0suffix2", "prefix" + s_d + "suffix1" + sf_dM + "suffix2");
        test("8.058000000", "" + s_d + f_i);
        test("8.058000000suffix", "" + s_d + f_i + "suffix");
        test("prefix8.0suffix158000000suffix2", "prefix" + s_d + "suffix1" + f_i + "suffix2");
        test("8.0-55000000", "" + s_d + f_iM);
        test("8.0-55000000suffix", "" + s_d + f_iM + "suffix");
        test("prefix8.0suffix1-55000000suffix2", "prefix" + s_d + "suffix1" + f_iM + "suffix2");
        test("8.01460392448", "" + s_d + f_l);
        test("8.01460392448suffix", "" + s_d + f_l + "suffix");
        test("prefix8.0suffix11460392448suffix2", "prefix" + s_d + "suffix1" + f_l + "suffix2");
        test("8.0C(70)", "" + s_d + f_o);
        test("8.0C(70)suffix", "" + s_d + f_o + "suffix");
        test("prefix8.0suffix1C(70)suffix2", "prefix" + s_d + "suffix1" + f_o + "suffix2");
        test("8.0\u04511", "" + s_d + sf_strU);
        test("8.0\u04511suffix", "" + s_d + sf_strU + "suffix");
        test("prefix8.0suffix1\u04511suffix2", "prefix" + s_d + "suffix1" + sf_strU + "suffix2");
        test("8.08000", "" + s_d + f_s);
        test("8.08000suffix", "" + s_d + f_s + "suffix");
        test("prefix8.0suffix18000suffix2", "prefix" + s_d + "suffix1" + f_s + "suffix2");
        test("8.018", "" + s_d + s_str);
        test("8.018suffix", "" + s_d + s_str + "suffix");
        test("prefix8.0suffix118suffix2", "prefix" + s_d + "suffix1" + s_str + "suffix2");
        test("8.0-1000000", "" + s_d + s_iM);
        test("8.0-1000000suffix", "" + s_d + s_iM + "suffix");
        test("prefix8.0suffix1-1000000suffix2", "prefix" + s_d + "suffix1" + s_iM + "suffix2");
        test("8.01000000", "" + s_d + sf_I);
        test("8.01000000suffix", "" + s_d + sf_I + "suffix");
        test("prefix8.0suffix11000000suffix2", "prefix" + s_d + "suffix1" + sf_I + "suffix2");
        test("8.0null", "" + s_d + f_oNtS);
        test("8.0nullsuffix", "" + s_d + f_oNtS + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + f_oNtS + "suffix2");
        test("8.0false", "" + s_d + f_bl);
        test("8.0falsesuffix", "" + s_d + f_bl + "suffix");
        test("prefix8.0suffix1falsesuffix2", "prefix" + s_d + "suffix1" + f_bl + "suffix2");
        test("8.0null", "" + s_d + sf_iAN);
        test("8.0nullsuffix", "" + s_d + sf_iAN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + sf_iAN + "suffix2");
        test("8.0-2000000", "" + s_d + sf_iM);
        test("8.0-2000000suffix", "" + s_d + sf_iM + "suffix");
        test("prefix8.0suffix1-2000000suffix2", "prefix" + s_d + "suffix1" + sf_iM + "suffix2");
        test("8.0-820130816", "" + s_d + f_lM);
        test("8.0-820130816suffix", "" + s_d + f_lM + "suffix");
        test("prefix8.0suffix1-820130816suffix2", "prefix" + s_d + "suffix1" + f_lM + "suffix2");
        test("8.0null", "" + s_d + sf_oAN);
        test("8.0nullsuffix", "" + s_d + sf_oAN + "suffix");
        test("prefix8.0suffix1nullsuffix2", "prefix" + s_d + "suffix1" + sf_oAN + "suffix2");
        test("8.025000000", "" + s_d + s_I);
        test("8.025000000suffix", "" + s_d + s_I + "suffix");
        test("prefix8.0suffix125000000suffix2", "prefix" + s_d + "suffix1" + s_I + "suffix2");
        test("55.0-96.0", "" + s_f + s_dM);
        test("55.0-96.0suffix", "" + s_f + s_dM + "suffix");
        test("prefix55.0suffix1-96.0suffix2", "prefix" + s_f + "suffix1" + s_dM + "suffix2");
        test("55.0null", "" + s_f + s_oNtS);
        test("55.0nullsuffix", "" + s_f + s_oNtS + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + s_oNtS + "suffix2");
        test("55.0\u045176", "" + s_f + f_strU);
        test("55.0\u045176suffix", "" + s_f + f_strU + "suffix");
        test("prefix55.0suffix1\u045176suffix2", "prefix" + s_f + "suffix1" + f_strU + "suffix2");
        test("55.092", "" + s_f + sf_strU2);
        test("55.092suffix", "" + s_f + sf_strU2 + "suffix");
        test("prefix55.0suffix192suffix2", "prefix" + s_f + "suffix1" + sf_strU2 + "suffix2");
        test("55.051", "" + s_f + sf_strU1);
        test("55.051suffix", "" + s_f + sf_strU1 + "suffix");
        test("prefix55.0suffix151suffix2", "prefix" + s_f + "suffix1" + sf_strU1 + "suffix2");
        test("55.0null", "" + s_f + s_iAN);
        test("55.0nullsuffix", "" + s_f + s_iAN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + s_iAN + "suffix2");
        test("55.0-54", "" + s_f + f_bM);
        test("55.0-54suffix", "" + s_f + f_bM + "suffix");
        test("prefix55.0suffix1-54suffix2", "prefix" + s_f + "suffix1" + f_bM + "suffix2");
        test("55.0-87.0", "" + s_f + f_fM);
        test("55.0-87.0suffix", "" + s_f + f_fM + "suffix");
        test("prefix55.0suffix1-87.0suffix2", "prefix" + s_f + "suffix1" + f_fM + "suffix2");
        test("55.0null", "" + s_f + s_oAN);
        test("55.0nullsuffix", "" + s_f + s_oAN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + s_oAN + "suffix2");
        test("55.019", "" + s_f + f_str);
        test("55.019suffix", "" + s_f + f_str + "suffix");
        test("prefix55.0suffix119suffix2", "prefix" + s_f + "suffix1" + f_str + "suffix2");
        test("55.0-41", "" + s_f + sf_bM);
        test("55.0-41suffix", "" + s_f + sf_bM + "suffix");
        test("prefix55.0suffix1-41suffix2", "prefix" + s_f + "suffix1" + sf_bM + "suffix2");
        test("55.0null", "" + s_f + sf_IN);
        test("55.0nullsuffix", "" + s_f + sf_IN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + sf_IN + "suffix2");
        test("55.0T", "" + s_f + s_c);
        test("55.0Tsuffix", "" + s_f + s_c + "suffix");
        test("prefix55.0suffix1Tsuffix2", "prefix" + s_f + "suffix1" + s_c + "suffix2");
        test("55.0-42.0", "" + s_f + sf_fM);
        test("55.0-42.0suffix", "" + s_f + sf_fM + "suffix");
        test("prefix55.0suffix1-42.0suffix2", "prefix" + s_f + "suffix1" + sf_fM + "suffix2");
        test("55.025", "" + s_f + s_b);
        test("55.025suffix", "" + s_f + s_b + "suffix");
        test("prefix55.0suffix125suffix2", "prefix" + s_f + "suffix1" + s_b + "suffix2");
        test("55.0null", "" + s_f + f_oN);
        test("55.0nullsuffix", "" + s_f + f_oN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + f_oN + "suffix2");
        test("55.0-1410065408", "" + s_f + s_lM);
        test("55.0-1410065408suffix", "" + s_f + s_lM + "suffix");
        test("prefix55.0suffix1-1410065408suffix2", "prefix" + s_f + "suffix1" + s_lM + "suffix2");
        test("55.08.0", "" + s_f + s_d);
        test("55.08.0suffix", "" + s_f + s_d + "suffix");
        test("prefix55.0suffix18.0suffix2", "prefix" + s_f + "suffix1" + s_d + "suffix2");
        test("55.055.0", "" + s_f + s_f);
        test("55.055.0suffix", "" + s_f + s_f + "suffix");
        test("prefix55.0suffix155.0suffix2", "prefix" + s_f + "suffix1" + s_f + "suffix2");
        test("55.097000000", "" + s_f + s_i);
        test("55.097000000suffix", "" + s_f + s_i + "suffix");
        test("prefix55.0suffix197000000suffix2", "prefix" + s_f + "suffix1" + s_i + "suffix2");
        test("55.0-9900", "" + s_f + f_sM);
        test("55.0-9900suffix", "" + s_f + f_sM + "suffix");
        test("prefix55.0suffix1-9900suffix2", "prefix" + s_f + "suffix1" + f_sM + "suffix2");
        test("55.0935228928", "" + s_f + s_l);
        test("55.0935228928suffix", "" + s_f + s_l + "suffix");
        test("prefix55.0suffix1935228928suffix2", "prefix" + s_f + "suffix1" + s_l + "suffix2");
        test("55.0-8400", "" + s_f + sf_sM);
        test("55.0-8400suffix", "" + s_f + sf_sM + "suffix");
        test("prefix55.0suffix1-8400suffix2", "prefix" + s_f + "suffix1" + sf_sM + "suffix2");
        test("55.0C(82)", "" + s_f + s_o);
        test("55.0C(82)suffix", "" + s_f + s_o + "suffix");
        test("prefix55.0suffix1C(82)suffix2", "prefix" + s_f + "suffix1" + s_o + "suffix2");
        test("55.0null", "" + s_f + sf_oNtS);
        test("55.0nullsuffix", "" + s_f + sf_oNtS + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + sf_oNtS + "suffix2");
        test("55.0true", "" + s_f + s_bl);
        test("55.0truesuffix", "" + s_f + s_bl + "suffix");
        test("prefix55.0suffix1truesuffix2", "prefix" + s_f + "suffix1" + s_bl + "suffix2");
        test("55.03900", "" + s_f + s_s);
        test("55.03900suffix", "" + s_f + s_s + "suffix");
        test("prefix55.0suffix13900suffix2", "prefix" + s_f + "suffix1" + s_s + "suffix2");
        test("55.0null", "" + s_f + sf_oN);
        test("55.0nullsuffix", "" + s_f + sf_oN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + sf_oN + "suffix2");
        test("55.094000000", "" + s_f + f_I);
        test("55.094000000suffix", "" + s_f + f_I + "suffix");
        test("prefix55.0suffix194000000suffix2", "prefix" + s_f + "suffix1" + f_I + "suffix2");
        test("55.0null", "" + s_f + f_IN);
        test("55.0nullsuffix", "" + s_f + f_IN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + f_IN + "suffix2");
        test("55.0true", "" + s_f + sf_bl);
        test("55.0truesuffix", "" + s_f + sf_bl + "suffix");
        test("prefix55.0suffix1truesuffix2", "prefix" + s_f + "suffix1" + sf_bl + "suffix2");
        test("55.05500", "" + s_f + sf_s);
        test("55.05500suffix", "" + s_f + sf_s + "suffix");
        test("prefix55.0suffix15500suffix2", "prefix" + s_f + "suffix1" + sf_s + "suffix2");
        test("55.0-2900", "" + s_f + s_sM);
        test("55.0-2900suffix", "" + s_f + s_sM + "suffix");
        test("prefix55.0suffix1-2900suffix2", "prefix" + s_f + "suffix1" + s_sM + "suffix2");
        test("55.0-194313216", "" + s_f + sf_l);
        test("55.0-194313216suffix", "" + s_f + sf_l + "suffix");
        test("prefix55.0suffix1-194313216suffix2", "prefix" + s_f + "suffix1" + sf_l + "suffix2");
        test("55.012", "" + s_f + s_strU1);
        test("55.012suffix", "" + s_f + s_strU1 + "suffix");
        test("prefix55.0suffix112suffix2", "prefix" + s_f + "suffix1" + s_strU1 + "suffix2");
        test("55.0C(87)", "" + s_f + sf_o);
        test("55.0C(87)suffix", "" + s_f + sf_o + "suffix");
        test("prefix55.0suffix1C(87)suffix2", "prefix" + s_f + "suffix1" + sf_o + "suffix2");
        test("55.091", "" + s_f + s_strU2);
        test("55.091suffix", "" + s_f + s_strU2 + "suffix");
        test("prefix55.0suffix191suffix2", "prefix" + s_f + "suffix1" + s_strU2 + "suffix2");
        test("55.021", "" + s_f + f_strU1);
        test("55.021suffix", "" + s_f + f_strU1 + "suffix");
        test("prefix55.0suffix121suffix2", "prefix" + s_f + "suffix1" + f_strU1 + "suffix2");
        test("55.018", "" + s_f + f_strU2);
        test("55.018suffix", "" + s_f + f_strU2 + "suffix");
        test("prefix55.0suffix118suffix2", "prefix" + s_f + "suffix1" + f_strU2 + "suffix2");
        test("55.0null", "" + s_f + f_iAN);
        test("55.0nullsuffix", "" + s_f + f_iAN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + f_iAN + "suffix2");
        test("55.0null", "" + s_f + s_oN);
        test("55.0nullsuffix", "" + s_f + s_oN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + s_oN + "suffix2");
        test("55.0\u045180", "" + s_f + s_strU);
        test("55.0\u045180suffix", "" + s_f + s_strU + "suffix");
        test("prefix55.0suffix1\u045180suffix2", "prefix" + s_f + "suffix1" + s_strU + "suffix2");
        test("55.0C", "" + s_f + sf_c);
        test("55.0Csuffix", "" + s_f + sf_c + "suffix");
        test("prefix55.0suffix1Csuffix2", "prefix" + s_f + "suffix1" + sf_c + "suffix2");
        test("55.075", "" + s_f + sf_str);
        test("55.075suffix", "" + s_f + sf_str + "suffix");
        test("prefix55.0suffix175suffix2", "prefix" + s_f + "suffix1" + sf_str + "suffix2");
        test("55.0-43", "" + s_f + s_bM);
        test("55.0-43suffix", "" + s_f + s_bM + "suffix");
        test("prefix55.0suffix1-43suffix2", "prefix" + s_f + "suffix1" + s_bM + "suffix2");
        test("55.080", "" + s_f + sf_b);
        test("55.080suffix", "" + s_f + sf_b + "suffix");
        test("prefix55.0suffix180suffix2", "prefix" + s_f + "suffix1" + sf_b + "suffix2");
        test("55.0null", "" + s_f + s_IN);
        test("55.0nullsuffix", "" + s_f + s_IN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + s_IN + "suffix2");
        test("55.0-52.0", "" + s_f + s_fM);
        test("55.0-52.0suffix", "" + s_f + s_fM + "suffix");
        test("prefix55.0suffix1-52.0suffix2", "prefix" + s_f + "suffix1" + s_fM + "suffix2");
        test("55.075000000", "" + s_f + sf_i);
        test("55.075000000suffix", "" + s_f + sf_i + "suffix");
        test("prefix55.0suffix175000000suffix2", "prefix" + s_f + "suffix1" + sf_i + "suffix2");
        test("55.044", "" + s_f + f_b);
        test("55.044suffix", "" + s_f + f_b + "suffix");
        test("prefix55.0suffix144suffix2", "prefix" + s_f + "suffix1" + f_b + "suffix2");
        test("55.0-1705032704", "" + s_f + sf_lM);
        test("55.0-1705032704suffix", "" + s_f + sf_lM + "suffix");
        test("prefix55.0suffix1-1705032704suffix2", "prefix" + s_f + "suffix1" + sf_lM + "suffix2");
        test("55.0null", "" + s_f + f_oAN);
        test("55.0nullsuffix", "" + s_f + f_oAN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + f_oAN + "suffix2");
        test("55.083.0", "" + s_f + f_d);
        test("55.083.0suffix", "" + s_f + f_d + "suffix");
        test("prefix55.0suffix183.0suffix2", "prefix" + s_f + "suffix1" + f_d + "suffix2");
        test("55.0I", "" + s_f + f_c);
        test("55.0Isuffix", "" + s_f + f_c + "suffix");
        test("prefix55.0suffix1Isuffix2", "prefix" + s_f + "suffix1" + f_c + "suffix2");
        test("55.094.0", "" + s_f + f_f);
        test("55.094.0suffix", "" + s_f + f_f + "suffix");
        test("prefix55.0suffix194.0suffix2", "prefix" + s_f + "suffix1" + f_f + "suffix2");
        test("55.012.0", "" + s_f + sf_d);
        test("55.012.0suffix", "" + s_f + sf_d + "suffix");
        test("prefix55.0suffix112.0suffix2", "prefix" + s_f + "suffix1" + sf_d + "suffix2");
        test("55.0-99.0", "" + s_f + f_dM);
        test("55.0-99.0suffix", "" + s_f + f_dM + "suffix");
        test("prefix55.0suffix1-99.0suffix2", "prefix" + s_f + "suffix1" + f_dM + "suffix2");
        test("55.017.0", "" + s_f + sf_f);
        test("55.017.0suffix", "" + s_f + sf_f + "suffix");
        test("prefix55.0suffix117.0suffix2", "prefix" + s_f + "suffix1" + sf_f + "suffix2");
        test("55.0-84.0", "" + s_f + sf_dM);
        test("55.0-84.0suffix", "" + s_f + sf_dM + "suffix");
        test("prefix55.0suffix1-84.0suffix2", "prefix" + s_f + "suffix1" + sf_dM + "suffix2");
        test("55.058000000", "" + s_f + f_i);
        test("55.058000000suffix", "" + s_f + f_i + "suffix");
        test("prefix55.0suffix158000000suffix2", "prefix" + s_f + "suffix1" + f_i + "suffix2");
        test("55.0-55000000", "" + s_f + f_iM);
        test("55.0-55000000suffix", "" + s_f + f_iM + "suffix");
        test("prefix55.0suffix1-55000000suffix2", "prefix" + s_f + "suffix1" + f_iM + "suffix2");
        test("55.01460392448", "" + s_f + f_l);
        test("55.01460392448suffix", "" + s_f + f_l + "suffix");
        test("prefix55.0suffix11460392448suffix2", "prefix" + s_f + "suffix1" + f_l + "suffix2");
        test("55.0C(70)", "" + s_f + f_o);
        test("55.0C(70)suffix", "" + s_f + f_o + "suffix");
        test("prefix55.0suffix1C(70)suffix2", "prefix" + s_f + "suffix1" + f_o + "suffix2");
        test("55.0\u04511", "" + s_f + sf_strU);
        test("55.0\u04511suffix", "" + s_f + sf_strU + "suffix");
        test("prefix55.0suffix1\u04511suffix2", "prefix" + s_f + "suffix1" + sf_strU + "suffix2");
        test("55.08000", "" + s_f + f_s);
        test("55.08000suffix", "" + s_f + f_s + "suffix");
        test("prefix55.0suffix18000suffix2", "prefix" + s_f + "suffix1" + f_s + "suffix2");
        test("55.018", "" + s_f + s_str);
        test("55.018suffix", "" + s_f + s_str + "suffix");
        test("prefix55.0suffix118suffix2", "prefix" + s_f + "suffix1" + s_str + "suffix2");
        test("55.0-1000000", "" + s_f + s_iM);
        test("55.0-1000000suffix", "" + s_f + s_iM + "suffix");
        test("prefix55.0suffix1-1000000suffix2", "prefix" + s_f + "suffix1" + s_iM + "suffix2");
        test("55.01000000", "" + s_f + sf_I);
        test("55.01000000suffix", "" + s_f + sf_I + "suffix");
        test("prefix55.0suffix11000000suffix2", "prefix" + s_f + "suffix1" + sf_I + "suffix2");
        test("55.0null", "" + s_f + f_oNtS);
        test("55.0nullsuffix", "" + s_f + f_oNtS + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + f_oNtS + "suffix2");
        test("55.0false", "" + s_f + f_bl);
        test("55.0falsesuffix", "" + s_f + f_bl + "suffix");
        test("prefix55.0suffix1falsesuffix2", "prefix" + s_f + "suffix1" + f_bl + "suffix2");
        test("55.0null", "" + s_f + sf_iAN);
        test("55.0nullsuffix", "" + s_f + sf_iAN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + sf_iAN + "suffix2");
        test("55.0-2000000", "" + s_f + sf_iM);
        test("55.0-2000000suffix", "" + s_f + sf_iM + "suffix");
        test("prefix55.0suffix1-2000000suffix2", "prefix" + s_f + "suffix1" + sf_iM + "suffix2");
        test("55.0-820130816", "" + s_f + f_lM);
        test("55.0-820130816suffix", "" + s_f + f_lM + "suffix");
        test("prefix55.0suffix1-820130816suffix2", "prefix" + s_f + "suffix1" + f_lM + "suffix2");
        test("55.0null", "" + s_f + sf_oAN);
        test("55.0nullsuffix", "" + s_f + sf_oAN + "suffix");
        test("prefix55.0suffix1nullsuffix2", "prefix" + s_f + "suffix1" + sf_oAN + "suffix2");
        test("55.025000000", "" + s_f + s_I);
        test("55.025000000suffix", "" + s_f + s_I + "suffix");
        test("prefix55.0suffix125000000suffix2", "prefix" + s_f + "suffix1" + s_I + "suffix2");
        test("97000000-96.0", "" + s_i + s_dM);
        test("97000000-96.0suffix", "" + s_i + s_dM + "suffix");
        test("prefix97000000suffix1-96.0suffix2", "prefix" + s_i + "suffix1" + s_dM + "suffix2");
        test("97000000null", "" + s_i + s_oNtS);
        test("97000000nullsuffix", "" + s_i + s_oNtS + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + s_oNtS + "suffix2");
        test("97000000\u045176", "" + s_i + f_strU);
        test("97000000\u045176suffix", "" + s_i + f_strU + "suffix");
        test("prefix97000000suffix1\u045176suffix2", "prefix" + s_i + "suffix1" + f_strU + "suffix2");
        test("9700000092", "" + s_i + sf_strU2);
        test("9700000092suffix", "" + s_i + sf_strU2 + "suffix");
        test("prefix97000000suffix192suffix2", "prefix" + s_i + "suffix1" + sf_strU2 + "suffix2");
        test("9700000051", "" + s_i + sf_strU1);
        test("9700000051suffix", "" + s_i + sf_strU1 + "suffix");
        test("prefix97000000suffix151suffix2", "prefix" + s_i + "suffix1" + sf_strU1 + "suffix2");
        test("97000000null", "" + s_i + s_iAN);
        test("97000000nullsuffix", "" + s_i + s_iAN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + s_iAN + "suffix2");
        test("97000000-54", "" + s_i + f_bM);
        test("97000000-54suffix", "" + s_i + f_bM + "suffix");
        test("prefix97000000suffix1-54suffix2", "prefix" + s_i + "suffix1" + f_bM + "suffix2");
        test("97000000-87.0", "" + s_i + f_fM);
        test("97000000-87.0suffix", "" + s_i + f_fM + "suffix");
        test("prefix97000000suffix1-87.0suffix2", "prefix" + s_i + "suffix1" + f_fM + "suffix2");
        test("97000000null", "" + s_i + s_oAN);
        test("97000000nullsuffix", "" + s_i + s_oAN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + s_oAN + "suffix2");
        test("9700000019", "" + s_i + f_str);
        test("9700000019suffix", "" + s_i + f_str + "suffix");
        test("prefix97000000suffix119suffix2", "prefix" + s_i + "suffix1" + f_str + "suffix2");
        test("97000000-41", "" + s_i + sf_bM);
        test("97000000-41suffix", "" + s_i + sf_bM + "suffix");
        test("prefix97000000suffix1-41suffix2", "prefix" + s_i + "suffix1" + sf_bM + "suffix2");
        test("97000000null", "" + s_i + sf_IN);
        test("97000000nullsuffix", "" + s_i + sf_IN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + sf_IN + "suffix2");
        test("97000000T", "" + s_i + s_c);
        test("97000000Tsuffix", "" + s_i + s_c + "suffix");
        test("prefix97000000suffix1Tsuffix2", "prefix" + s_i + "suffix1" + s_c + "suffix2");
        test("97000000-42.0", "" + s_i + sf_fM);
        test("97000000-42.0suffix", "" + s_i + sf_fM + "suffix");
        test("prefix97000000suffix1-42.0suffix2", "prefix" + s_i + "suffix1" + sf_fM + "suffix2");
        test("9700000025", "" + s_i + s_b);
        test("9700000025suffix", "" + s_i + s_b + "suffix");
        test("prefix97000000suffix125suffix2", "prefix" + s_i + "suffix1" + s_b + "suffix2");
        test("97000000null", "" + s_i + f_oN);
        test("97000000nullsuffix", "" + s_i + f_oN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + f_oN + "suffix2");
        test("97000000-1410065408", "" + s_i + s_lM);
        test("97000000-1410065408suffix", "" + s_i + s_lM + "suffix");
        test("prefix97000000suffix1-1410065408suffix2", "prefix" + s_i + "suffix1" + s_lM + "suffix2");
        test("970000008.0", "" + s_i + s_d);
        test("970000008.0suffix", "" + s_i + s_d + "suffix");
        test("prefix97000000suffix18.0suffix2", "prefix" + s_i + "suffix1" + s_d + "suffix2");
        test("9700000055.0", "" + s_i + s_f);
        test("9700000055.0suffix", "" + s_i + s_f + "suffix");
        test("prefix97000000suffix155.0suffix2", "prefix" + s_i + "suffix1" + s_f + "suffix2");
        test("9700000097000000", "" + s_i + s_i);
        test("9700000097000000suffix", "" + s_i + s_i + "suffix");
        test("prefix97000000suffix197000000suffix2", "prefix" + s_i + "suffix1" + s_i + "suffix2");
        test("97000000-9900", "" + s_i + f_sM);
        test("97000000-9900suffix", "" + s_i + f_sM + "suffix");
        test("prefix97000000suffix1-9900suffix2", "prefix" + s_i + "suffix1" + f_sM + "suffix2");
        test("97000000935228928", "" + s_i + s_l);
        test("97000000935228928suffix", "" + s_i + s_l + "suffix");
        test("prefix97000000suffix1935228928suffix2", "prefix" + s_i + "suffix1" + s_l + "suffix2");
        test("97000000-8400", "" + s_i + sf_sM);
        test("97000000-8400suffix", "" + s_i + sf_sM + "suffix");
        test("prefix97000000suffix1-8400suffix2", "prefix" + s_i + "suffix1" + sf_sM + "suffix2");
        test("97000000C(82)", "" + s_i + s_o);
        test("97000000C(82)suffix", "" + s_i + s_o + "suffix");
        test("prefix97000000suffix1C(82)suffix2", "prefix" + s_i + "suffix1" + s_o + "suffix2");
        test("97000000null", "" + s_i + sf_oNtS);
        test("97000000nullsuffix", "" + s_i + sf_oNtS + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + sf_oNtS + "suffix2");
        test("97000000true", "" + s_i + s_bl);
        test("97000000truesuffix", "" + s_i + s_bl + "suffix");
        test("prefix97000000suffix1truesuffix2", "prefix" + s_i + "suffix1" + s_bl + "suffix2");
        test("970000003900", "" + s_i + s_s);
        test("970000003900suffix", "" + s_i + s_s + "suffix");
        test("prefix97000000suffix13900suffix2", "prefix" + s_i + "suffix1" + s_s + "suffix2");
        test("97000000null", "" + s_i + sf_oN);
        test("97000000nullsuffix", "" + s_i + sf_oN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + sf_oN + "suffix2");
        test("9700000094000000", "" + s_i + f_I);
        test("9700000094000000suffix", "" + s_i + f_I + "suffix");
        test("prefix97000000suffix194000000suffix2", "prefix" + s_i + "suffix1" + f_I + "suffix2");
        test("97000000null", "" + s_i + f_IN);
        test("97000000nullsuffix", "" + s_i + f_IN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + f_IN + "suffix2");
        test("97000000true", "" + s_i + sf_bl);
        test("97000000truesuffix", "" + s_i + sf_bl + "suffix");
        test("prefix97000000suffix1truesuffix2", "prefix" + s_i + "suffix1" + sf_bl + "suffix2");
        test("970000005500", "" + s_i + sf_s);
        test("970000005500suffix", "" + s_i + sf_s + "suffix");
        test("prefix97000000suffix15500suffix2", "prefix" + s_i + "suffix1" + sf_s + "suffix2");
        test("97000000-2900", "" + s_i + s_sM);
        test("97000000-2900suffix", "" + s_i + s_sM + "suffix");
        test("prefix97000000suffix1-2900suffix2", "prefix" + s_i + "suffix1" + s_sM + "suffix2");
        test("97000000-194313216", "" + s_i + sf_l);
        test("97000000-194313216suffix", "" + s_i + sf_l + "suffix");
        test("prefix97000000suffix1-194313216suffix2", "prefix" + s_i + "suffix1" + sf_l + "suffix2");
        test("9700000012", "" + s_i + s_strU1);
        test("9700000012suffix", "" + s_i + s_strU1 + "suffix");
        test("prefix97000000suffix112suffix2", "prefix" + s_i + "suffix1" + s_strU1 + "suffix2");
        test("97000000C(87)", "" + s_i + sf_o);
        test("97000000C(87)suffix", "" + s_i + sf_o + "suffix");
        test("prefix97000000suffix1C(87)suffix2", "prefix" + s_i + "suffix1" + sf_o + "suffix2");
        test("9700000091", "" + s_i + s_strU2);
        test("9700000091suffix", "" + s_i + s_strU2 + "suffix");
        test("prefix97000000suffix191suffix2", "prefix" + s_i + "suffix1" + s_strU2 + "suffix2");
        test("9700000021", "" + s_i + f_strU1);
        test("9700000021suffix", "" + s_i + f_strU1 + "suffix");
        test("prefix97000000suffix121suffix2", "prefix" + s_i + "suffix1" + f_strU1 + "suffix2");
        test("9700000018", "" + s_i + f_strU2);
        test("9700000018suffix", "" + s_i + f_strU2 + "suffix");
        test("prefix97000000suffix118suffix2", "prefix" + s_i + "suffix1" + f_strU2 + "suffix2");
        test("97000000null", "" + s_i + f_iAN);
        test("97000000nullsuffix", "" + s_i + f_iAN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + f_iAN + "suffix2");
        test("97000000null", "" + s_i + s_oN);
        test("97000000nullsuffix", "" + s_i + s_oN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + s_oN + "suffix2");
        test("97000000\u045180", "" + s_i + s_strU);
        test("97000000\u045180suffix", "" + s_i + s_strU + "suffix");
        test("prefix97000000suffix1\u045180suffix2", "prefix" + s_i + "suffix1" + s_strU + "suffix2");
        test("97000000C", "" + s_i + sf_c);
        test("97000000Csuffix", "" + s_i + sf_c + "suffix");
        test("prefix97000000suffix1Csuffix2", "prefix" + s_i + "suffix1" + sf_c + "suffix2");
        test("9700000075", "" + s_i + sf_str);
        test("9700000075suffix", "" + s_i + sf_str + "suffix");
        test("prefix97000000suffix175suffix2", "prefix" + s_i + "suffix1" + sf_str + "suffix2");
        test("97000000-43", "" + s_i + s_bM);
        test("97000000-43suffix", "" + s_i + s_bM + "suffix");
        test("prefix97000000suffix1-43suffix2", "prefix" + s_i + "suffix1" + s_bM + "suffix2");
        test("9700000080", "" + s_i + sf_b);
        test("9700000080suffix", "" + s_i + sf_b + "suffix");
        test("prefix97000000suffix180suffix2", "prefix" + s_i + "suffix1" + sf_b + "suffix2");
        test("97000000null", "" + s_i + s_IN);
        test("97000000nullsuffix", "" + s_i + s_IN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + s_IN + "suffix2");
        test("97000000-52.0", "" + s_i + s_fM);
        test("97000000-52.0suffix", "" + s_i + s_fM + "suffix");
        test("prefix97000000suffix1-52.0suffix2", "prefix" + s_i + "suffix1" + s_fM + "suffix2");
        test("9700000075000000", "" + s_i + sf_i);
        test("9700000075000000suffix", "" + s_i + sf_i + "suffix");
        test("prefix97000000suffix175000000suffix2", "prefix" + s_i + "suffix1" + sf_i + "suffix2");
        test("9700000044", "" + s_i + f_b);
        test("9700000044suffix", "" + s_i + f_b + "suffix");
        test("prefix97000000suffix144suffix2", "prefix" + s_i + "suffix1" + f_b + "suffix2");
        test("97000000-1705032704", "" + s_i + sf_lM);
        test("97000000-1705032704suffix", "" + s_i + sf_lM + "suffix");
        test("prefix97000000suffix1-1705032704suffix2", "prefix" + s_i + "suffix1" + sf_lM + "suffix2");
        test("97000000null", "" + s_i + f_oAN);
        test("97000000nullsuffix", "" + s_i + f_oAN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + f_oAN + "suffix2");
        test("9700000083.0", "" + s_i + f_d);
        test("9700000083.0suffix", "" + s_i + f_d + "suffix");
        test("prefix97000000suffix183.0suffix2", "prefix" + s_i + "suffix1" + f_d + "suffix2");
        test("97000000I", "" + s_i + f_c);
        test("97000000Isuffix", "" + s_i + f_c + "suffix");
        test("prefix97000000suffix1Isuffix2", "prefix" + s_i + "suffix1" + f_c + "suffix2");
        test("9700000094.0", "" + s_i + f_f);
        test("9700000094.0suffix", "" + s_i + f_f + "suffix");
        test("prefix97000000suffix194.0suffix2", "prefix" + s_i + "suffix1" + f_f + "suffix2");
        test("9700000012.0", "" + s_i + sf_d);
        test("9700000012.0suffix", "" + s_i + sf_d + "suffix");
        test("prefix97000000suffix112.0suffix2", "prefix" + s_i + "suffix1" + sf_d + "suffix2");
        test("97000000-99.0", "" + s_i + f_dM);
        test("97000000-99.0suffix", "" + s_i + f_dM + "suffix");
        test("prefix97000000suffix1-99.0suffix2", "prefix" + s_i + "suffix1" + f_dM + "suffix2");
        test("9700000017.0", "" + s_i + sf_f);
        test("9700000017.0suffix", "" + s_i + sf_f + "suffix");
        test("prefix97000000suffix117.0suffix2", "prefix" + s_i + "suffix1" + sf_f + "suffix2");
        test("97000000-84.0", "" + s_i + sf_dM);
        test("97000000-84.0suffix", "" + s_i + sf_dM + "suffix");
        test("prefix97000000suffix1-84.0suffix2", "prefix" + s_i + "suffix1" + sf_dM + "suffix2");
        test("9700000058000000", "" + s_i + f_i);
        test("9700000058000000suffix", "" + s_i + f_i + "suffix");
        test("prefix97000000suffix158000000suffix2", "prefix" + s_i + "suffix1" + f_i + "suffix2");
        test("97000000-55000000", "" + s_i + f_iM);
        test("97000000-55000000suffix", "" + s_i + f_iM + "suffix");
        test("prefix97000000suffix1-55000000suffix2", "prefix" + s_i + "suffix1" + f_iM + "suffix2");
        test("970000001460392448", "" + s_i + f_l);
        test("970000001460392448suffix", "" + s_i + f_l + "suffix");
        test("prefix97000000suffix11460392448suffix2", "prefix" + s_i + "suffix1" + f_l + "suffix2");
        test("97000000C(70)", "" + s_i + f_o);
        test("97000000C(70)suffix", "" + s_i + f_o + "suffix");
        test("prefix97000000suffix1C(70)suffix2", "prefix" + s_i + "suffix1" + f_o + "suffix2");
        test("97000000\u04511", "" + s_i + sf_strU);
        test("97000000\u04511suffix", "" + s_i + sf_strU + "suffix");
        test("prefix97000000suffix1\u04511suffix2", "prefix" + s_i + "suffix1" + sf_strU + "suffix2");
        test("970000008000", "" + s_i + f_s);
        test("970000008000suffix", "" + s_i + f_s + "suffix");
        test("prefix97000000suffix18000suffix2", "prefix" + s_i + "suffix1" + f_s + "suffix2");
        test("9700000018", "" + s_i + s_str);
        test("9700000018suffix", "" + s_i + s_str + "suffix");
        test("prefix97000000suffix118suffix2", "prefix" + s_i + "suffix1" + s_str + "suffix2");
        test("97000000-1000000", "" + s_i + s_iM);
        test("97000000-1000000suffix", "" + s_i + s_iM + "suffix");
        test("prefix97000000suffix1-1000000suffix2", "prefix" + s_i + "suffix1" + s_iM + "suffix2");
        test("970000001000000", "" + s_i + sf_I);
        test("970000001000000suffix", "" + s_i + sf_I + "suffix");
        test("prefix97000000suffix11000000suffix2", "prefix" + s_i + "suffix1" + sf_I + "suffix2");
        test("97000000null", "" + s_i + f_oNtS);
        test("97000000nullsuffix", "" + s_i + f_oNtS + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + f_oNtS + "suffix2");
        test("97000000false", "" + s_i + f_bl);
        test("97000000falsesuffix", "" + s_i + f_bl + "suffix");
        test("prefix97000000suffix1falsesuffix2", "prefix" + s_i + "suffix1" + f_bl + "suffix2");
        test("97000000null", "" + s_i + sf_iAN);
        test("97000000nullsuffix", "" + s_i + sf_iAN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + sf_iAN + "suffix2");
        test("97000000-2000000", "" + s_i + sf_iM);
        test("97000000-2000000suffix", "" + s_i + sf_iM + "suffix");
        test("prefix97000000suffix1-2000000suffix2", "prefix" + s_i + "suffix1" + sf_iM + "suffix2");
        test("97000000-820130816", "" + s_i + f_lM);
        test("97000000-820130816suffix", "" + s_i + f_lM + "suffix");
        test("prefix97000000suffix1-820130816suffix2", "prefix" + s_i + "suffix1" + f_lM + "suffix2");
        test("97000000null", "" + s_i + sf_oAN);
        test("97000000nullsuffix", "" + s_i + sf_oAN + "suffix");
        test("prefix97000000suffix1nullsuffix2", "prefix" + s_i + "suffix1" + sf_oAN + "suffix2");
        test("9700000025000000", "" + s_i + s_I);
        test("9700000025000000suffix", "" + s_i + s_I + "suffix");
        test("prefix97000000suffix125000000suffix2", "prefix" + s_i + "suffix1" + s_I + "suffix2");
        test("-9900-96.0", "" + f_sM + s_dM);
        test("-9900-96.0suffix", "" + f_sM + s_dM + "suffix");
        test("prefix-9900suffix1-96.0suffix2", "prefix" + f_sM + "suffix1" + s_dM + "suffix2");
        test("-9900null", "" + f_sM + s_oNtS);
        test("-9900nullsuffix", "" + f_sM + s_oNtS + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + s_oNtS + "suffix2");
        test("-9900\u045176", "" + f_sM + f_strU);
        test("-9900\u045176suffix", "" + f_sM + f_strU + "suffix");
        test("prefix-9900suffix1\u045176suffix2", "prefix" + f_sM + "suffix1" + f_strU + "suffix2");
        test("-990092", "" + f_sM + sf_strU2);
        test("-990092suffix", "" + f_sM + sf_strU2 + "suffix");
        test("prefix-9900suffix192suffix2", "prefix" + f_sM + "suffix1" + sf_strU2 + "suffix2");
        test("-990051", "" + f_sM + sf_strU1);
        test("-990051suffix", "" + f_sM + sf_strU1 + "suffix");
        test("prefix-9900suffix151suffix2", "prefix" + f_sM + "suffix1" + sf_strU1 + "suffix2");
        test("-9900null", "" + f_sM + s_iAN);
        test("-9900nullsuffix", "" + f_sM + s_iAN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + s_iAN + "suffix2");
        test("-9900-54", "" + f_sM + f_bM);
        test("-9900-54suffix", "" + f_sM + f_bM + "suffix");
        test("prefix-9900suffix1-54suffix2", "prefix" + f_sM + "suffix1" + f_bM + "suffix2");
        test("-9900-87.0", "" + f_sM + f_fM);
        test("-9900-87.0suffix", "" + f_sM + f_fM + "suffix");
        test("prefix-9900suffix1-87.0suffix2", "prefix" + f_sM + "suffix1" + f_fM + "suffix2");
        test("-9900null", "" + f_sM + s_oAN);
        test("-9900nullsuffix", "" + f_sM + s_oAN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + s_oAN + "suffix2");
        test("-990019", "" + f_sM + f_str);
        test("-990019suffix", "" + f_sM + f_str + "suffix");
        test("prefix-9900suffix119suffix2", "prefix" + f_sM + "suffix1" + f_str + "suffix2");
        test("-9900-41", "" + f_sM + sf_bM);
        test("-9900-41suffix", "" + f_sM + sf_bM + "suffix");
        test("prefix-9900suffix1-41suffix2", "prefix" + f_sM + "suffix1" + sf_bM + "suffix2");
        test("-9900null", "" + f_sM + sf_IN);
        test("-9900nullsuffix", "" + f_sM + sf_IN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + sf_IN + "suffix2");
        test("-9900T", "" + f_sM + s_c);
        test("-9900Tsuffix", "" + f_sM + s_c + "suffix");
        test("prefix-9900suffix1Tsuffix2", "prefix" + f_sM + "suffix1" + s_c + "suffix2");
        test("-9900-42.0", "" + f_sM + sf_fM);
        test("-9900-42.0suffix", "" + f_sM + sf_fM + "suffix");
        test("prefix-9900suffix1-42.0suffix2", "prefix" + f_sM + "suffix1" + sf_fM + "suffix2");
        test("-990025", "" + f_sM + s_b);
        test("-990025suffix", "" + f_sM + s_b + "suffix");
        test("prefix-9900suffix125suffix2", "prefix" + f_sM + "suffix1" + s_b + "suffix2");
        test("-9900null", "" + f_sM + f_oN);
        test("-9900nullsuffix", "" + f_sM + f_oN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + f_oN + "suffix2");
        test("-9900-1410065408", "" + f_sM + s_lM);
        test("-9900-1410065408suffix", "" + f_sM + s_lM + "suffix");
        test("prefix-9900suffix1-1410065408suffix2", "prefix" + f_sM + "suffix1" + s_lM + "suffix2");
        test("-99008.0", "" + f_sM + s_d);
        test("-99008.0suffix", "" + f_sM + s_d + "suffix");
        test("prefix-9900suffix18.0suffix2", "prefix" + f_sM + "suffix1" + s_d + "suffix2");
        test("-990055.0", "" + f_sM + s_f);
        test("-990055.0suffix", "" + f_sM + s_f + "suffix");
        test("prefix-9900suffix155.0suffix2", "prefix" + f_sM + "suffix1" + s_f + "suffix2");
        test("-990097000000", "" + f_sM + s_i);
        test("-990097000000suffix", "" + f_sM + s_i + "suffix");
        test("prefix-9900suffix197000000suffix2", "prefix" + f_sM + "suffix1" + s_i + "suffix2");
        test("-9900-9900", "" + f_sM + f_sM);
        test("-9900-9900suffix", "" + f_sM + f_sM + "suffix");
        test("prefix-9900suffix1-9900suffix2", "prefix" + f_sM + "suffix1" + f_sM + "suffix2");
        test("-9900935228928", "" + f_sM + s_l);
        test("-9900935228928suffix", "" + f_sM + s_l + "suffix");
        test("prefix-9900suffix1935228928suffix2", "prefix" + f_sM + "suffix1" + s_l + "suffix2");
        test("-9900-8400", "" + f_sM + sf_sM);
        test("-9900-8400suffix", "" + f_sM + sf_sM + "suffix");
        test("prefix-9900suffix1-8400suffix2", "prefix" + f_sM + "suffix1" + sf_sM + "suffix2");
        test("-9900C(82)", "" + f_sM + s_o);
        test("-9900C(82)suffix", "" + f_sM + s_o + "suffix");
        test("prefix-9900suffix1C(82)suffix2", "prefix" + f_sM + "suffix1" + s_o + "suffix2");
        test("-9900null", "" + f_sM + sf_oNtS);
        test("-9900nullsuffix", "" + f_sM + sf_oNtS + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + sf_oNtS + "suffix2");
        test("-9900true", "" + f_sM + s_bl);
        test("-9900truesuffix", "" + f_sM + s_bl + "suffix");
        test("prefix-9900suffix1truesuffix2", "prefix" + f_sM + "suffix1" + s_bl + "suffix2");
        test("-99003900", "" + f_sM + s_s);
        test("-99003900suffix", "" + f_sM + s_s + "suffix");
        test("prefix-9900suffix13900suffix2", "prefix" + f_sM + "suffix1" + s_s + "suffix2");
        test("-9900null", "" + f_sM + sf_oN);
        test("-9900nullsuffix", "" + f_sM + sf_oN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + sf_oN + "suffix2");
        test("-990094000000", "" + f_sM + f_I);
        test("-990094000000suffix", "" + f_sM + f_I + "suffix");
        test("prefix-9900suffix194000000suffix2", "prefix" + f_sM + "suffix1" + f_I + "suffix2");
        test("-9900null", "" + f_sM + f_IN);
        test("-9900nullsuffix", "" + f_sM + f_IN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + f_IN + "suffix2");
        test("-9900true", "" + f_sM + sf_bl);
        test("-9900truesuffix", "" + f_sM + sf_bl + "suffix");
        test("prefix-9900suffix1truesuffix2", "prefix" + f_sM + "suffix1" + sf_bl + "suffix2");
        test("-99005500", "" + f_sM + sf_s);
        test("-99005500suffix", "" + f_sM + sf_s + "suffix");
        test("prefix-9900suffix15500suffix2", "prefix" + f_sM + "suffix1" + sf_s + "suffix2");
        test("-9900-2900", "" + f_sM + s_sM);
        test("-9900-2900suffix", "" + f_sM + s_sM + "suffix");
        test("prefix-9900suffix1-2900suffix2", "prefix" + f_sM + "suffix1" + s_sM + "suffix2");
        test("-9900-194313216", "" + f_sM + sf_l);
        test("-9900-194313216suffix", "" + f_sM + sf_l + "suffix");
        test("prefix-9900suffix1-194313216suffix2", "prefix" + f_sM + "suffix1" + sf_l + "suffix2");
        test("-990012", "" + f_sM + s_strU1);
        test("-990012suffix", "" + f_sM + s_strU1 + "suffix");
        test("prefix-9900suffix112suffix2", "prefix" + f_sM + "suffix1" + s_strU1 + "suffix2");
        test("-9900C(87)", "" + f_sM + sf_o);
        test("-9900C(87)suffix", "" + f_sM + sf_o + "suffix");
        test("prefix-9900suffix1C(87)suffix2", "prefix" + f_sM + "suffix1" + sf_o + "suffix2");
        test("-990091", "" + f_sM + s_strU2);
        test("-990091suffix", "" + f_sM + s_strU2 + "suffix");
        test("prefix-9900suffix191suffix2", "prefix" + f_sM + "suffix1" + s_strU2 + "suffix2");
        test("-990021", "" + f_sM + f_strU1);
        test("-990021suffix", "" + f_sM + f_strU1 + "suffix");
        test("prefix-9900suffix121suffix2", "prefix" + f_sM + "suffix1" + f_strU1 + "suffix2");
        test("-990018", "" + f_sM + f_strU2);
        test("-990018suffix", "" + f_sM + f_strU2 + "suffix");
        test("prefix-9900suffix118suffix2", "prefix" + f_sM + "suffix1" + f_strU2 + "suffix2");
        test("-9900null", "" + f_sM + f_iAN);
        test("-9900nullsuffix", "" + f_sM + f_iAN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + f_iAN + "suffix2");
        test("-9900null", "" + f_sM + s_oN);
        test("-9900nullsuffix", "" + f_sM + s_oN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + s_oN + "suffix2");
        test("-9900\u045180", "" + f_sM + s_strU);
        test("-9900\u045180suffix", "" + f_sM + s_strU + "suffix");
        test("prefix-9900suffix1\u045180suffix2", "prefix" + f_sM + "suffix1" + s_strU + "suffix2");
        test("-9900C", "" + f_sM + sf_c);
        test("-9900Csuffix", "" + f_sM + sf_c + "suffix");
        test("prefix-9900suffix1Csuffix2", "prefix" + f_sM + "suffix1" + sf_c + "suffix2");
        test("-990075", "" + f_sM + sf_str);
        test("-990075suffix", "" + f_sM + sf_str + "suffix");
        test("prefix-9900suffix175suffix2", "prefix" + f_sM + "suffix1" + sf_str + "suffix2");
        test("-9900-43", "" + f_sM + s_bM);
        test("-9900-43suffix", "" + f_sM + s_bM + "suffix");
        test("prefix-9900suffix1-43suffix2", "prefix" + f_sM + "suffix1" + s_bM + "suffix2");
        test("-990080", "" + f_sM + sf_b);
        test("-990080suffix", "" + f_sM + sf_b + "suffix");
        test("prefix-9900suffix180suffix2", "prefix" + f_sM + "suffix1" + sf_b + "suffix2");
        test("-9900null", "" + f_sM + s_IN);
        test("-9900nullsuffix", "" + f_sM + s_IN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + s_IN + "suffix2");
        test("-9900-52.0", "" + f_sM + s_fM);
        test("-9900-52.0suffix", "" + f_sM + s_fM + "suffix");
        test("prefix-9900suffix1-52.0suffix2", "prefix" + f_sM + "suffix1" + s_fM + "suffix2");
        test("-990075000000", "" + f_sM + sf_i);
        test("-990075000000suffix", "" + f_sM + sf_i + "suffix");
        test("prefix-9900suffix175000000suffix2", "prefix" + f_sM + "suffix1" + sf_i + "suffix2");
        test("-990044", "" + f_sM + f_b);
        test("-990044suffix", "" + f_sM + f_b + "suffix");
        test("prefix-9900suffix144suffix2", "prefix" + f_sM + "suffix1" + f_b + "suffix2");
        test("-9900-1705032704", "" + f_sM + sf_lM);
        test("-9900-1705032704suffix", "" + f_sM + sf_lM + "suffix");
        test("prefix-9900suffix1-1705032704suffix2", "prefix" + f_sM + "suffix1" + sf_lM + "suffix2");
        test("-9900null", "" + f_sM + f_oAN);
        test("-9900nullsuffix", "" + f_sM + f_oAN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + f_oAN + "suffix2");
        test("-990083.0", "" + f_sM + f_d);
        test("-990083.0suffix", "" + f_sM + f_d + "suffix");
        test("prefix-9900suffix183.0suffix2", "prefix" + f_sM + "suffix1" + f_d + "suffix2");
        test("-9900I", "" + f_sM + f_c);
        test("-9900Isuffix", "" + f_sM + f_c + "suffix");
        test("prefix-9900suffix1Isuffix2", "prefix" + f_sM + "suffix1" + f_c + "suffix2");
        test("-990094.0", "" + f_sM + f_f);
        test("-990094.0suffix", "" + f_sM + f_f + "suffix");
        test("prefix-9900suffix194.0suffix2", "prefix" + f_sM + "suffix1" + f_f + "suffix2");
        test("-990012.0", "" + f_sM + sf_d);
        test("-990012.0suffix", "" + f_sM + sf_d + "suffix");
        test("prefix-9900suffix112.0suffix2", "prefix" + f_sM + "suffix1" + sf_d + "suffix2");
        test("-9900-99.0", "" + f_sM + f_dM);
        test("-9900-99.0suffix", "" + f_sM + f_dM + "suffix");
        test("prefix-9900suffix1-99.0suffix2", "prefix" + f_sM + "suffix1" + f_dM + "suffix2");
        test("-990017.0", "" + f_sM + sf_f);
        test("-990017.0suffix", "" + f_sM + sf_f + "suffix");
        test("prefix-9900suffix117.0suffix2", "prefix" + f_sM + "suffix1" + sf_f + "suffix2");
        test("-9900-84.0", "" + f_sM + sf_dM);
        test("-9900-84.0suffix", "" + f_sM + sf_dM + "suffix");
        test("prefix-9900suffix1-84.0suffix2", "prefix" + f_sM + "suffix1" + sf_dM + "suffix2");
        test("-990058000000", "" + f_sM + f_i);
        test("-990058000000suffix", "" + f_sM + f_i + "suffix");
        test("prefix-9900suffix158000000suffix2", "prefix" + f_sM + "suffix1" + f_i + "suffix2");
        test("-9900-55000000", "" + f_sM + f_iM);
        test("-9900-55000000suffix", "" + f_sM + f_iM + "suffix");
        test("prefix-9900suffix1-55000000suffix2", "prefix" + f_sM + "suffix1" + f_iM + "suffix2");
        test("-99001460392448", "" + f_sM + f_l);
        test("-99001460392448suffix", "" + f_sM + f_l + "suffix");
        test("prefix-9900suffix11460392448suffix2", "prefix" + f_sM + "suffix1" + f_l + "suffix2");
        test("-9900C(70)", "" + f_sM + f_o);
        test("-9900C(70)suffix", "" + f_sM + f_o + "suffix");
        test("prefix-9900suffix1C(70)suffix2", "prefix" + f_sM + "suffix1" + f_o + "suffix2");
        test("-9900\u04511", "" + f_sM + sf_strU);
        test("-9900\u04511suffix", "" + f_sM + sf_strU + "suffix");
        test("prefix-9900suffix1\u04511suffix2", "prefix" + f_sM + "suffix1" + sf_strU + "suffix2");
        test("-99008000", "" + f_sM + f_s);
        test("-99008000suffix", "" + f_sM + f_s + "suffix");
        test("prefix-9900suffix18000suffix2", "prefix" + f_sM + "suffix1" + f_s + "suffix2");
        test("-990018", "" + f_sM + s_str);
        test("-990018suffix", "" + f_sM + s_str + "suffix");
        test("prefix-9900suffix118suffix2", "prefix" + f_sM + "suffix1" + s_str + "suffix2");
        test("-9900-1000000", "" + f_sM + s_iM);
        test("-9900-1000000suffix", "" + f_sM + s_iM + "suffix");
    }

    public void run5() {
        test("prefix-9900suffix1-1000000suffix2", "prefix" + f_sM + "suffix1" + s_iM + "suffix2");
        test("-99001000000", "" + f_sM + sf_I);
        test("-99001000000suffix", "" + f_sM + sf_I + "suffix");
        test("prefix-9900suffix11000000suffix2", "prefix" + f_sM + "suffix1" + sf_I + "suffix2");
        test("-9900null", "" + f_sM + f_oNtS);
        test("-9900nullsuffix", "" + f_sM + f_oNtS + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + f_oNtS + "suffix2");
        test("-9900false", "" + f_sM + f_bl);
        test("-9900falsesuffix", "" + f_sM + f_bl + "suffix");
        test("prefix-9900suffix1falsesuffix2", "prefix" + f_sM + "suffix1" + f_bl + "suffix2");
        test("-9900null", "" + f_sM + sf_iAN);
        test("-9900nullsuffix", "" + f_sM + sf_iAN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + sf_iAN + "suffix2");
        test("-9900-2000000", "" + f_sM + sf_iM);
        test("-9900-2000000suffix", "" + f_sM + sf_iM + "suffix");
        test("prefix-9900suffix1-2000000suffix2", "prefix" + f_sM + "suffix1" + sf_iM + "suffix2");
        test("-9900-820130816", "" + f_sM + f_lM);
        test("-9900-820130816suffix", "" + f_sM + f_lM + "suffix");
        test("prefix-9900suffix1-820130816suffix2", "prefix" + f_sM + "suffix1" + f_lM + "suffix2");
        test("-9900null", "" + f_sM + sf_oAN);
        test("-9900nullsuffix", "" + f_sM + sf_oAN + "suffix");
        test("prefix-9900suffix1nullsuffix2", "prefix" + f_sM + "suffix1" + sf_oAN + "suffix2");
        test("-990025000000", "" + f_sM + s_I);
        test("-990025000000suffix", "" + f_sM + s_I + "suffix");
        test("prefix-9900suffix125000000suffix2", "prefix" + f_sM + "suffix1" + s_I + "suffix2");
        test("935228928-96.0", "" + s_l + s_dM);
        test("935228928-96.0suffix", "" + s_l + s_dM + "suffix");
        test("prefix935228928suffix1-96.0suffix2", "prefix" + s_l + "suffix1" + s_dM + "suffix2");
        test("935228928null", "" + s_l + s_oNtS);
        test("935228928nullsuffix", "" + s_l + s_oNtS + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + s_oNtS + "suffix2");
        test("935228928\u045176", "" + s_l + f_strU);
        test("935228928\u045176suffix", "" + s_l + f_strU + "suffix");
        test("prefix935228928suffix1\u045176suffix2", "prefix" + s_l + "suffix1" + f_strU + "suffix2");
        test("93522892892", "" + s_l + sf_strU2);
        test("93522892892suffix", "" + s_l + sf_strU2 + "suffix");
        test("prefix935228928suffix192suffix2", "prefix" + s_l + "suffix1" + sf_strU2 + "suffix2");
        test("93522892851", "" + s_l + sf_strU1);
        test("93522892851suffix", "" + s_l + sf_strU1 + "suffix");
        test("prefix935228928suffix151suffix2", "prefix" + s_l + "suffix1" + sf_strU1 + "suffix2");
        test("935228928null", "" + s_l + s_iAN);
        test("935228928nullsuffix", "" + s_l + s_iAN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + s_iAN + "suffix2");
        test("935228928-54", "" + s_l + f_bM);
        test("935228928-54suffix", "" + s_l + f_bM + "suffix");
        test("prefix935228928suffix1-54suffix2", "prefix" + s_l + "suffix1" + f_bM + "suffix2");
        test("935228928-87.0", "" + s_l + f_fM);
        test("935228928-87.0suffix", "" + s_l + f_fM + "suffix");
        test("prefix935228928suffix1-87.0suffix2", "prefix" + s_l + "suffix1" + f_fM + "suffix2");
        test("935228928null", "" + s_l + s_oAN);
        test("935228928nullsuffix", "" + s_l + s_oAN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + s_oAN + "suffix2");
        test("93522892819", "" + s_l + f_str);
        test("93522892819suffix", "" + s_l + f_str + "suffix");
        test("prefix935228928suffix119suffix2", "prefix" + s_l + "suffix1" + f_str + "suffix2");
        test("935228928-41", "" + s_l + sf_bM);
        test("935228928-41suffix", "" + s_l + sf_bM + "suffix");
        test("prefix935228928suffix1-41suffix2", "prefix" + s_l + "suffix1" + sf_bM + "suffix2");
        test("935228928null", "" + s_l + sf_IN);
        test("935228928nullsuffix", "" + s_l + sf_IN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + sf_IN + "suffix2");
        test("935228928T", "" + s_l + s_c);
        test("935228928Tsuffix", "" + s_l + s_c + "suffix");
        test("prefix935228928suffix1Tsuffix2", "prefix" + s_l + "suffix1" + s_c + "suffix2");
        test("935228928-42.0", "" + s_l + sf_fM);
        test("935228928-42.0suffix", "" + s_l + sf_fM + "suffix");
        test("prefix935228928suffix1-42.0suffix2", "prefix" + s_l + "suffix1" + sf_fM + "suffix2");
        test("93522892825", "" + s_l + s_b);
        test("93522892825suffix", "" + s_l + s_b + "suffix");
        test("prefix935228928suffix125suffix2", "prefix" + s_l + "suffix1" + s_b + "suffix2");
        test("935228928null", "" + s_l + f_oN);
        test("935228928nullsuffix", "" + s_l + f_oN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + f_oN + "suffix2");
        test("935228928-1410065408", "" + s_l + s_lM);
        test("935228928-1410065408suffix", "" + s_l + s_lM + "suffix");
        test("prefix935228928suffix1-1410065408suffix2", "prefix" + s_l + "suffix1" + s_lM + "suffix2");
        test("9352289288.0", "" + s_l + s_d);
        test("9352289288.0suffix", "" + s_l + s_d + "suffix");
        test("prefix935228928suffix18.0suffix2", "prefix" + s_l + "suffix1" + s_d + "suffix2");
        test("93522892855.0", "" + s_l + s_f);
        test("93522892855.0suffix", "" + s_l + s_f + "suffix");
        test("prefix935228928suffix155.0suffix2", "prefix" + s_l + "suffix1" + s_f + "suffix2");
        test("93522892897000000", "" + s_l + s_i);
        test("93522892897000000suffix", "" + s_l + s_i + "suffix");
        test("prefix935228928suffix197000000suffix2", "prefix" + s_l + "suffix1" + s_i + "suffix2");
        test("935228928-9900", "" + s_l + f_sM);
        test("935228928-9900suffix", "" + s_l + f_sM + "suffix");
        test("prefix935228928suffix1-9900suffix2", "prefix" + s_l + "suffix1" + f_sM + "suffix2");
        test("935228928935228928", "" + s_l + s_l);
        test("935228928935228928suffix", "" + s_l + s_l + "suffix");
        test("prefix935228928suffix1935228928suffix2", "prefix" + s_l + "suffix1" + s_l + "suffix2");
        test("935228928-8400", "" + s_l + sf_sM);
        test("935228928-8400suffix", "" + s_l + sf_sM + "suffix");
        test("prefix935228928suffix1-8400suffix2", "prefix" + s_l + "suffix1" + sf_sM + "suffix2");
        test("935228928C(82)", "" + s_l + s_o);
        test("935228928C(82)suffix", "" + s_l + s_o + "suffix");
        test("prefix935228928suffix1C(82)suffix2", "prefix" + s_l + "suffix1" + s_o + "suffix2");
        test("935228928null", "" + s_l + sf_oNtS);
        test("935228928nullsuffix", "" + s_l + sf_oNtS + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + sf_oNtS + "suffix2");
        test("935228928true", "" + s_l + s_bl);
        test("935228928truesuffix", "" + s_l + s_bl + "suffix");
        test("prefix935228928suffix1truesuffix2", "prefix" + s_l + "suffix1" + s_bl + "suffix2");
        test("9352289283900", "" + s_l + s_s);
        test("9352289283900suffix", "" + s_l + s_s + "suffix");
        test("prefix935228928suffix13900suffix2", "prefix" + s_l + "suffix1" + s_s + "suffix2");
        test("935228928null", "" + s_l + sf_oN);
        test("935228928nullsuffix", "" + s_l + sf_oN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + sf_oN + "suffix2");
        test("93522892894000000", "" + s_l + f_I);
        test("93522892894000000suffix", "" + s_l + f_I + "suffix");
        test("prefix935228928suffix194000000suffix2", "prefix" + s_l + "suffix1" + f_I + "suffix2");
        test("935228928null", "" + s_l + f_IN);
        test("935228928nullsuffix", "" + s_l + f_IN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + f_IN + "suffix2");
        test("935228928true", "" + s_l + sf_bl);
        test("935228928truesuffix", "" + s_l + sf_bl + "suffix");
        test("prefix935228928suffix1truesuffix2", "prefix" + s_l + "suffix1" + sf_bl + "suffix2");
        test("9352289285500", "" + s_l + sf_s);
        test("9352289285500suffix", "" + s_l + sf_s + "suffix");
        test("prefix935228928suffix15500suffix2", "prefix" + s_l + "suffix1" + sf_s + "suffix2");
        test("935228928-2900", "" + s_l + s_sM);
        test("935228928-2900suffix", "" + s_l + s_sM + "suffix");
        test("prefix935228928suffix1-2900suffix2", "prefix" + s_l + "suffix1" + s_sM + "suffix2");
        test("935228928-194313216", "" + s_l + sf_l);
        test("935228928-194313216suffix", "" + s_l + sf_l + "suffix");
        test("prefix935228928suffix1-194313216suffix2", "prefix" + s_l + "suffix1" + sf_l + "suffix2");
        test("93522892812", "" + s_l + s_strU1);
        test("93522892812suffix", "" + s_l + s_strU1 + "suffix");
        test("prefix935228928suffix112suffix2", "prefix" + s_l + "suffix1" + s_strU1 + "suffix2");
        test("935228928C(87)", "" + s_l + sf_o);
        test("935228928C(87)suffix", "" + s_l + sf_o + "suffix");
        test("prefix935228928suffix1C(87)suffix2", "prefix" + s_l + "suffix1" + sf_o + "suffix2");
        test("93522892891", "" + s_l + s_strU2);
        test("93522892891suffix", "" + s_l + s_strU2 + "suffix");
        test("prefix935228928suffix191suffix2", "prefix" + s_l + "suffix1" + s_strU2 + "suffix2");
        test("93522892821", "" + s_l + f_strU1);
        test("93522892821suffix", "" + s_l + f_strU1 + "suffix");
        test("prefix935228928suffix121suffix2", "prefix" + s_l + "suffix1" + f_strU1 + "suffix2");
        test("93522892818", "" + s_l + f_strU2);
        test("93522892818suffix", "" + s_l + f_strU2 + "suffix");
        test("prefix935228928suffix118suffix2", "prefix" + s_l + "suffix1" + f_strU2 + "suffix2");
        test("935228928null", "" + s_l + f_iAN);
        test("935228928nullsuffix", "" + s_l + f_iAN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + f_iAN + "suffix2");
        test("935228928null", "" + s_l + s_oN);
        test("935228928nullsuffix", "" + s_l + s_oN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + s_oN + "suffix2");
        test("935228928\u045180", "" + s_l + s_strU);
        test("935228928\u045180suffix", "" + s_l + s_strU + "suffix");
        test("prefix935228928suffix1\u045180suffix2", "prefix" + s_l + "suffix1" + s_strU + "suffix2");
        test("935228928C", "" + s_l + sf_c);
        test("935228928Csuffix", "" + s_l + sf_c + "suffix");
        test("prefix935228928suffix1Csuffix2", "prefix" + s_l + "suffix1" + sf_c + "suffix2");
        test("93522892875", "" + s_l + sf_str);
        test("93522892875suffix", "" + s_l + sf_str + "suffix");
        test("prefix935228928suffix175suffix2", "prefix" + s_l + "suffix1" + sf_str + "suffix2");
        test("935228928-43", "" + s_l + s_bM);
        test("935228928-43suffix", "" + s_l + s_bM + "suffix");
        test("prefix935228928suffix1-43suffix2", "prefix" + s_l + "suffix1" + s_bM + "suffix2");
        test("93522892880", "" + s_l + sf_b);
        test("93522892880suffix", "" + s_l + sf_b + "suffix");
        test("prefix935228928suffix180suffix2", "prefix" + s_l + "suffix1" + sf_b + "suffix2");
        test("935228928null", "" + s_l + s_IN);
        test("935228928nullsuffix", "" + s_l + s_IN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + s_IN + "suffix2");
        test("935228928-52.0", "" + s_l + s_fM);
        test("935228928-52.0suffix", "" + s_l + s_fM + "suffix");
        test("prefix935228928suffix1-52.0suffix2", "prefix" + s_l + "suffix1" + s_fM + "suffix2");
        test("93522892875000000", "" + s_l + sf_i);
        test("93522892875000000suffix", "" + s_l + sf_i + "suffix");
        test("prefix935228928suffix175000000suffix2", "prefix" + s_l + "suffix1" + sf_i + "suffix2");
        test("93522892844", "" + s_l + f_b);
        test("93522892844suffix", "" + s_l + f_b + "suffix");
        test("prefix935228928suffix144suffix2", "prefix" + s_l + "suffix1" + f_b + "suffix2");
        test("935228928-1705032704", "" + s_l + sf_lM);
        test("935228928-1705032704suffix", "" + s_l + sf_lM + "suffix");
        test("prefix935228928suffix1-1705032704suffix2", "prefix" + s_l + "suffix1" + sf_lM + "suffix2");
        test("935228928null", "" + s_l + f_oAN);
        test("935228928nullsuffix", "" + s_l + f_oAN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + f_oAN + "suffix2");
        test("93522892883.0", "" + s_l + f_d);
        test("93522892883.0suffix", "" + s_l + f_d + "suffix");
        test("prefix935228928suffix183.0suffix2", "prefix" + s_l + "suffix1" + f_d + "suffix2");
        test("935228928I", "" + s_l + f_c);
        test("935228928Isuffix", "" + s_l + f_c + "suffix");
        test("prefix935228928suffix1Isuffix2", "prefix" + s_l + "suffix1" + f_c + "suffix2");
        test("93522892894.0", "" + s_l + f_f);
        test("93522892894.0suffix", "" + s_l + f_f + "suffix");
        test("prefix935228928suffix194.0suffix2", "prefix" + s_l + "suffix1" + f_f + "suffix2");
        test("93522892812.0", "" + s_l + sf_d);
        test("93522892812.0suffix", "" + s_l + sf_d + "suffix");
        test("prefix935228928suffix112.0suffix2", "prefix" + s_l + "suffix1" + sf_d + "suffix2");
        test("935228928-99.0", "" + s_l + f_dM);
        test("935228928-99.0suffix", "" + s_l + f_dM + "suffix");
        test("prefix935228928suffix1-99.0suffix2", "prefix" + s_l + "suffix1" + f_dM + "suffix2");
        test("93522892817.0", "" + s_l + sf_f);
        test("93522892817.0suffix", "" + s_l + sf_f + "suffix");
        test("prefix935228928suffix117.0suffix2", "prefix" + s_l + "suffix1" + sf_f + "suffix2");
        test("935228928-84.0", "" + s_l + sf_dM);
        test("935228928-84.0suffix", "" + s_l + sf_dM + "suffix");
        test("prefix935228928suffix1-84.0suffix2", "prefix" + s_l + "suffix1" + sf_dM + "suffix2");
        test("93522892858000000", "" + s_l + f_i);
        test("93522892858000000suffix", "" + s_l + f_i + "suffix");
        test("prefix935228928suffix158000000suffix2", "prefix" + s_l + "suffix1" + f_i + "suffix2");
        test("935228928-55000000", "" + s_l + f_iM);
        test("935228928-55000000suffix", "" + s_l + f_iM + "suffix");
        test("prefix935228928suffix1-55000000suffix2", "prefix" + s_l + "suffix1" + f_iM + "suffix2");
        test("9352289281460392448", "" + s_l + f_l);
        test("9352289281460392448suffix", "" + s_l + f_l + "suffix");
        test("prefix935228928suffix11460392448suffix2", "prefix" + s_l + "suffix1" + f_l + "suffix2");
        test("935228928C(70)", "" + s_l + f_o);
        test("935228928C(70)suffix", "" + s_l + f_o + "suffix");
        test("prefix935228928suffix1C(70)suffix2", "prefix" + s_l + "suffix1" + f_o + "suffix2");
        test("935228928\u04511", "" + s_l + sf_strU);
        test("935228928\u04511suffix", "" + s_l + sf_strU + "suffix");
        test("prefix935228928suffix1\u04511suffix2", "prefix" + s_l + "suffix1" + sf_strU + "suffix2");
        test("9352289288000", "" + s_l + f_s);
        test("9352289288000suffix", "" + s_l + f_s + "suffix");
        test("prefix935228928suffix18000suffix2", "prefix" + s_l + "suffix1" + f_s + "suffix2");
        test("93522892818", "" + s_l + s_str);
        test("93522892818suffix", "" + s_l + s_str + "suffix");
        test("prefix935228928suffix118suffix2", "prefix" + s_l + "suffix1" + s_str + "suffix2");
        test("935228928-1000000", "" + s_l + s_iM);
        test("935228928-1000000suffix", "" + s_l + s_iM + "suffix");
        test("prefix935228928suffix1-1000000suffix2", "prefix" + s_l + "suffix1" + s_iM + "suffix2");
        test("9352289281000000", "" + s_l + sf_I);
        test("9352289281000000suffix", "" + s_l + sf_I + "suffix");
        test("prefix935228928suffix11000000suffix2", "prefix" + s_l + "suffix1" + sf_I + "suffix2");
        test("935228928null", "" + s_l + f_oNtS);
        test("935228928nullsuffix", "" + s_l + f_oNtS + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + f_oNtS + "suffix2");
        test("935228928false", "" + s_l + f_bl);
        test("935228928falsesuffix", "" + s_l + f_bl + "suffix");
        test("prefix935228928suffix1falsesuffix2", "prefix" + s_l + "suffix1" + f_bl + "suffix2");
        test("935228928null", "" + s_l + sf_iAN);
        test("935228928nullsuffix", "" + s_l + sf_iAN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + sf_iAN + "suffix2");
        test("935228928-2000000", "" + s_l + sf_iM);
        test("935228928-2000000suffix", "" + s_l + sf_iM + "suffix");
        test("prefix935228928suffix1-2000000suffix2", "prefix" + s_l + "suffix1" + sf_iM + "suffix2");
        test("935228928-820130816", "" + s_l + f_lM);
        test("935228928-820130816suffix", "" + s_l + f_lM + "suffix");
        test("prefix935228928suffix1-820130816suffix2", "prefix" + s_l + "suffix1" + f_lM + "suffix2");
        test("935228928null", "" + s_l + sf_oAN);
        test("935228928nullsuffix", "" + s_l + sf_oAN + "suffix");
        test("prefix935228928suffix1nullsuffix2", "prefix" + s_l + "suffix1" + sf_oAN + "suffix2");
        test("93522892825000000", "" + s_l + s_I);
        test("93522892825000000suffix", "" + s_l + s_I + "suffix");
        test("prefix935228928suffix125000000suffix2", "prefix" + s_l + "suffix1" + s_I + "suffix2");
        test("-8400-96.0", "" + sf_sM + s_dM);
        test("-8400-96.0suffix", "" + sf_sM + s_dM + "suffix");
        test("prefix-8400suffix1-96.0suffix2", "prefix" + sf_sM + "suffix1" + s_dM + "suffix2");
        test("-8400null", "" + sf_sM + s_oNtS);
        test("-8400nullsuffix", "" + sf_sM + s_oNtS + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + s_oNtS + "suffix2");
        test("-8400\u045176", "" + sf_sM + f_strU);
        test("-8400\u045176suffix", "" + sf_sM + f_strU + "suffix");
        test("prefix-8400suffix1\u045176suffix2", "prefix" + sf_sM + "suffix1" + f_strU + "suffix2");
        test("-840092", "" + sf_sM + sf_strU2);
        test("-840092suffix", "" + sf_sM + sf_strU2 + "suffix");
        test("prefix-8400suffix192suffix2", "prefix" + sf_sM + "suffix1" + sf_strU2 + "suffix2");
        test("-840051", "" + sf_sM + sf_strU1);
        test("-840051suffix", "" + sf_sM + sf_strU1 + "suffix");
        test("prefix-8400suffix151suffix2", "prefix" + sf_sM + "suffix1" + sf_strU1 + "suffix2");
        test("-8400null", "" + sf_sM + s_iAN);
        test("-8400nullsuffix", "" + sf_sM + s_iAN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + s_iAN + "suffix2");
        test("-8400-54", "" + sf_sM + f_bM);
        test("-8400-54suffix", "" + sf_sM + f_bM + "suffix");
        test("prefix-8400suffix1-54suffix2", "prefix" + sf_sM + "suffix1" + f_bM + "suffix2");
        test("-8400-87.0", "" + sf_sM + f_fM);
        test("-8400-87.0suffix", "" + sf_sM + f_fM + "suffix");
        test("prefix-8400suffix1-87.0suffix2", "prefix" + sf_sM + "suffix1" + f_fM + "suffix2");
        test("-8400null", "" + sf_sM + s_oAN);
        test("-8400nullsuffix", "" + sf_sM + s_oAN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + s_oAN + "suffix2");
        test("-840019", "" + sf_sM + f_str);
        test("-840019suffix", "" + sf_sM + f_str + "suffix");
        test("prefix-8400suffix119suffix2", "prefix" + sf_sM + "suffix1" + f_str + "suffix2");
        test("-8400-41", "" + sf_sM + sf_bM);
        test("-8400-41suffix", "" + sf_sM + sf_bM + "suffix");
        test("prefix-8400suffix1-41suffix2", "prefix" + sf_sM + "suffix1" + sf_bM + "suffix2");
        test("-8400null", "" + sf_sM + sf_IN);
        test("-8400nullsuffix", "" + sf_sM + sf_IN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + sf_IN + "suffix2");
        test("-8400T", "" + sf_sM + s_c);
        test("-8400Tsuffix", "" + sf_sM + s_c + "suffix");
        test("prefix-8400suffix1Tsuffix2", "prefix" + sf_sM + "suffix1" + s_c + "suffix2");
        test("-8400-42.0", "" + sf_sM + sf_fM);
        test("-8400-42.0suffix", "" + sf_sM + sf_fM + "suffix");
        test("prefix-8400suffix1-42.0suffix2", "prefix" + sf_sM + "suffix1" + sf_fM + "suffix2");
        test("-840025", "" + sf_sM + s_b);
        test("-840025suffix", "" + sf_sM + s_b + "suffix");
        test("prefix-8400suffix125suffix2", "prefix" + sf_sM + "suffix1" + s_b + "suffix2");
        test("-8400null", "" + sf_sM + f_oN);
        test("-8400nullsuffix", "" + sf_sM + f_oN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + f_oN + "suffix2");
        test("-8400-1410065408", "" + sf_sM + s_lM);
        test("-8400-1410065408suffix", "" + sf_sM + s_lM + "suffix");
        test("prefix-8400suffix1-1410065408suffix2", "prefix" + sf_sM + "suffix1" + s_lM + "suffix2");
        test("-84008.0", "" + sf_sM + s_d);
        test("-84008.0suffix", "" + sf_sM + s_d + "suffix");
        test("prefix-8400suffix18.0suffix2", "prefix" + sf_sM + "suffix1" + s_d + "suffix2");
        test("-840055.0", "" + sf_sM + s_f);
        test("-840055.0suffix", "" + sf_sM + s_f + "suffix");
        test("prefix-8400suffix155.0suffix2", "prefix" + sf_sM + "suffix1" + s_f + "suffix2");
        test("-840097000000", "" + sf_sM + s_i);
        test("-840097000000suffix", "" + sf_sM + s_i + "suffix");
        test("prefix-8400suffix197000000suffix2", "prefix" + sf_sM + "suffix1" + s_i + "suffix2");
        test("-8400-9900", "" + sf_sM + f_sM);
        test("-8400-9900suffix", "" + sf_sM + f_sM + "suffix");
        test("prefix-8400suffix1-9900suffix2", "prefix" + sf_sM + "suffix1" + f_sM + "suffix2");
        test("-8400935228928", "" + sf_sM + s_l);
        test("-8400935228928suffix", "" + sf_sM + s_l + "suffix");
        test("prefix-8400suffix1935228928suffix2", "prefix" + sf_sM + "suffix1" + s_l + "suffix2");
        test("-8400-8400", "" + sf_sM + sf_sM);
        test("-8400-8400suffix", "" + sf_sM + sf_sM + "suffix");
        test("prefix-8400suffix1-8400suffix2", "prefix" + sf_sM + "suffix1" + sf_sM + "suffix2");
        test("-8400C(82)", "" + sf_sM + s_o);
        test("-8400C(82)suffix", "" + sf_sM + s_o + "suffix");
        test("prefix-8400suffix1C(82)suffix2", "prefix" + sf_sM + "suffix1" + s_o + "suffix2");
        test("-8400null", "" + sf_sM + sf_oNtS);
        test("-8400nullsuffix", "" + sf_sM + sf_oNtS + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + sf_oNtS + "suffix2");
        test("-8400true", "" + sf_sM + s_bl);
        test("-8400truesuffix", "" + sf_sM + s_bl + "suffix");
        test("prefix-8400suffix1truesuffix2", "prefix" + sf_sM + "suffix1" + s_bl + "suffix2");
        test("-84003900", "" + sf_sM + s_s);
        test("-84003900suffix", "" + sf_sM + s_s + "suffix");
        test("prefix-8400suffix13900suffix2", "prefix" + sf_sM + "suffix1" + s_s + "suffix2");
        test("-8400null", "" + sf_sM + sf_oN);
        test("-8400nullsuffix", "" + sf_sM + sf_oN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + sf_oN + "suffix2");
        test("-840094000000", "" + sf_sM + f_I);
        test("-840094000000suffix", "" + sf_sM + f_I + "suffix");
        test("prefix-8400suffix194000000suffix2", "prefix" + sf_sM + "suffix1" + f_I + "suffix2");
        test("-8400null", "" + sf_sM + f_IN);
        test("-8400nullsuffix", "" + sf_sM + f_IN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + f_IN + "suffix2");
        test("-8400true", "" + sf_sM + sf_bl);
        test("-8400truesuffix", "" + sf_sM + sf_bl + "suffix");
        test("prefix-8400suffix1truesuffix2", "prefix" + sf_sM + "suffix1" + sf_bl + "suffix2");
        test("-84005500", "" + sf_sM + sf_s);
        test("-84005500suffix", "" + sf_sM + sf_s + "suffix");
        test("prefix-8400suffix15500suffix2", "prefix" + sf_sM + "suffix1" + sf_s + "suffix2");
        test("-8400-2900", "" + sf_sM + s_sM);
        test("-8400-2900suffix", "" + sf_sM + s_sM + "suffix");
        test("prefix-8400suffix1-2900suffix2", "prefix" + sf_sM + "suffix1" + s_sM + "suffix2");
        test("-8400-194313216", "" + sf_sM + sf_l);
        test("-8400-194313216suffix", "" + sf_sM + sf_l + "suffix");
        test("prefix-8400suffix1-194313216suffix2", "prefix" + sf_sM + "suffix1" + sf_l + "suffix2");
        test("-840012", "" + sf_sM + s_strU1);
        test("-840012suffix", "" + sf_sM + s_strU1 + "suffix");
        test("prefix-8400suffix112suffix2", "prefix" + sf_sM + "suffix1" + s_strU1 + "suffix2");
        test("-8400C(87)", "" + sf_sM + sf_o);
        test("-8400C(87)suffix", "" + sf_sM + sf_o + "suffix");
        test("prefix-8400suffix1C(87)suffix2", "prefix" + sf_sM + "suffix1" + sf_o + "suffix2");
        test("-840091", "" + sf_sM + s_strU2);
        test("-840091suffix", "" + sf_sM + s_strU2 + "suffix");
        test("prefix-8400suffix191suffix2", "prefix" + sf_sM + "suffix1" + s_strU2 + "suffix2");
        test("-840021", "" + sf_sM + f_strU1);
        test("-840021suffix", "" + sf_sM + f_strU1 + "suffix");
        test("prefix-8400suffix121suffix2", "prefix" + sf_sM + "suffix1" + f_strU1 + "suffix2");
        test("-840018", "" + sf_sM + f_strU2);
        test("-840018suffix", "" + sf_sM + f_strU2 + "suffix");
        test("prefix-8400suffix118suffix2", "prefix" + sf_sM + "suffix1" + f_strU2 + "suffix2");
        test("-8400null", "" + sf_sM + f_iAN);
        test("-8400nullsuffix", "" + sf_sM + f_iAN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + f_iAN + "suffix2");
        test("-8400null", "" + sf_sM + s_oN);
        test("-8400nullsuffix", "" + sf_sM + s_oN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + s_oN + "suffix2");
        test("-8400\u045180", "" + sf_sM + s_strU);
        test("-8400\u045180suffix", "" + sf_sM + s_strU + "suffix");
        test("prefix-8400suffix1\u045180suffix2", "prefix" + sf_sM + "suffix1" + s_strU + "suffix2");
        test("-8400C", "" + sf_sM + sf_c);
        test("-8400Csuffix", "" + sf_sM + sf_c + "suffix");
        test("prefix-8400suffix1Csuffix2", "prefix" + sf_sM + "suffix1" + sf_c + "suffix2");
        test("-840075", "" + sf_sM + sf_str);
        test("-840075suffix", "" + sf_sM + sf_str + "suffix");
        test("prefix-8400suffix175suffix2", "prefix" + sf_sM + "suffix1" + sf_str + "suffix2");
        test("-8400-43", "" + sf_sM + s_bM);
        test("-8400-43suffix", "" + sf_sM + s_bM + "suffix");
        test("prefix-8400suffix1-43suffix2", "prefix" + sf_sM + "suffix1" + s_bM + "suffix2");
        test("-840080", "" + sf_sM + sf_b);
        test("-840080suffix", "" + sf_sM + sf_b + "suffix");
        test("prefix-8400suffix180suffix2", "prefix" + sf_sM + "suffix1" + sf_b + "suffix2");
        test("-8400null", "" + sf_sM + s_IN);
        test("-8400nullsuffix", "" + sf_sM + s_IN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + s_IN + "suffix2");
        test("-8400-52.0", "" + sf_sM + s_fM);
        test("-8400-52.0suffix", "" + sf_sM + s_fM + "suffix");
        test("prefix-8400suffix1-52.0suffix2", "prefix" + sf_sM + "suffix1" + s_fM + "suffix2");
        test("-840075000000", "" + sf_sM + sf_i);
        test("-840075000000suffix", "" + sf_sM + sf_i + "suffix");
        test("prefix-8400suffix175000000suffix2", "prefix" + sf_sM + "suffix1" + sf_i + "suffix2");
        test("-840044", "" + sf_sM + f_b);
        test("-840044suffix", "" + sf_sM + f_b + "suffix");
        test("prefix-8400suffix144suffix2", "prefix" + sf_sM + "suffix1" + f_b + "suffix2");
        test("-8400-1705032704", "" + sf_sM + sf_lM);
        test("-8400-1705032704suffix", "" + sf_sM + sf_lM + "suffix");
        test("prefix-8400suffix1-1705032704suffix2", "prefix" + sf_sM + "suffix1" + sf_lM + "suffix2");
        test("-8400null", "" + sf_sM + f_oAN);
        test("-8400nullsuffix", "" + sf_sM + f_oAN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + f_oAN + "suffix2");
        test("-840083.0", "" + sf_sM + f_d);
        test("-840083.0suffix", "" + sf_sM + f_d + "suffix");
        test("prefix-8400suffix183.0suffix2", "prefix" + sf_sM + "suffix1" + f_d + "suffix2");
        test("-8400I", "" + sf_sM + f_c);
        test("-8400Isuffix", "" + sf_sM + f_c + "suffix");
        test("prefix-8400suffix1Isuffix2", "prefix" + sf_sM + "suffix1" + f_c + "suffix2");
        test("-840094.0", "" + sf_sM + f_f);
        test("-840094.0suffix", "" + sf_sM + f_f + "suffix");
        test("prefix-8400suffix194.0suffix2", "prefix" + sf_sM + "suffix1" + f_f + "suffix2");
        test("-840012.0", "" + sf_sM + sf_d);
        test("-840012.0suffix", "" + sf_sM + sf_d + "suffix");
        test("prefix-8400suffix112.0suffix2", "prefix" + sf_sM + "suffix1" + sf_d + "suffix2");
        test("-8400-99.0", "" + sf_sM + f_dM);
        test("-8400-99.0suffix", "" + sf_sM + f_dM + "suffix");
        test("prefix-8400suffix1-99.0suffix2", "prefix" + sf_sM + "suffix1" + f_dM + "suffix2");
        test("-840017.0", "" + sf_sM + sf_f);
        test("-840017.0suffix", "" + sf_sM + sf_f + "suffix");
        test("prefix-8400suffix117.0suffix2", "prefix" + sf_sM + "suffix1" + sf_f + "suffix2");
        test("-8400-84.0", "" + sf_sM + sf_dM);
        test("-8400-84.0suffix", "" + sf_sM + sf_dM + "suffix");
        test("prefix-8400suffix1-84.0suffix2", "prefix" + sf_sM + "suffix1" + sf_dM + "suffix2");
        test("-840058000000", "" + sf_sM + f_i);
        test("-840058000000suffix", "" + sf_sM + f_i + "suffix");
        test("prefix-8400suffix158000000suffix2", "prefix" + sf_sM + "suffix1" + f_i + "suffix2");
        test("-8400-55000000", "" + sf_sM + f_iM);
        test("-8400-55000000suffix", "" + sf_sM + f_iM + "suffix");
        test("prefix-8400suffix1-55000000suffix2", "prefix" + sf_sM + "suffix1" + f_iM + "suffix2");
        test("-84001460392448", "" + sf_sM + f_l);
        test("-84001460392448suffix", "" + sf_sM + f_l + "suffix");
        test("prefix-8400suffix11460392448suffix2", "prefix" + sf_sM + "suffix1" + f_l + "suffix2");
        test("-8400C(70)", "" + sf_sM + f_o);
        test("-8400C(70)suffix", "" + sf_sM + f_o + "suffix");
        test("prefix-8400suffix1C(70)suffix2", "prefix" + sf_sM + "suffix1" + f_o + "suffix2");
        test("-8400\u04511", "" + sf_sM + sf_strU);
        test("-8400\u04511suffix", "" + sf_sM + sf_strU + "suffix");
        test("prefix-8400suffix1\u04511suffix2", "prefix" + sf_sM + "suffix1" + sf_strU + "suffix2");
        test("-84008000", "" + sf_sM + f_s);
        test("-84008000suffix", "" + sf_sM + f_s + "suffix");
        test("prefix-8400suffix18000suffix2", "prefix" + sf_sM + "suffix1" + f_s + "suffix2");
        test("-840018", "" + sf_sM + s_str);
        test("-840018suffix", "" + sf_sM + s_str + "suffix");
        test("prefix-8400suffix118suffix2", "prefix" + sf_sM + "suffix1" + s_str + "suffix2");
        test("-8400-1000000", "" + sf_sM + s_iM);
        test("-8400-1000000suffix", "" + sf_sM + s_iM + "suffix");
        test("prefix-8400suffix1-1000000suffix2", "prefix" + sf_sM + "suffix1" + s_iM + "suffix2");
        test("-84001000000", "" + sf_sM + sf_I);
        test("-84001000000suffix", "" + sf_sM + sf_I + "suffix");
        test("prefix-8400suffix11000000suffix2", "prefix" + sf_sM + "suffix1" + sf_I + "suffix2");
        test("-8400null", "" + sf_sM + f_oNtS);
        test("-8400nullsuffix", "" + sf_sM + f_oNtS + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + f_oNtS + "suffix2");
        test("-8400false", "" + sf_sM + f_bl);
        test("-8400falsesuffix", "" + sf_sM + f_bl + "suffix");
        test("prefix-8400suffix1falsesuffix2", "prefix" + sf_sM + "suffix1" + f_bl + "suffix2");
        test("-8400null", "" + sf_sM + sf_iAN);
        test("-8400nullsuffix", "" + sf_sM + sf_iAN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + sf_iAN + "suffix2");
        test("-8400-2000000", "" + sf_sM + sf_iM);
        test("-8400-2000000suffix", "" + sf_sM + sf_iM + "suffix");
        test("prefix-8400suffix1-2000000suffix2", "prefix" + sf_sM + "suffix1" + sf_iM + "suffix2");
        test("-8400-820130816", "" + sf_sM + f_lM);
        test("-8400-820130816suffix", "" + sf_sM + f_lM + "suffix");
        test("prefix-8400suffix1-820130816suffix2", "prefix" + sf_sM + "suffix1" + f_lM + "suffix2");
        test("-8400null", "" + sf_sM + sf_oAN);
        test("-8400nullsuffix", "" + sf_sM + sf_oAN + "suffix");
        test("prefix-8400suffix1nullsuffix2", "prefix" + sf_sM + "suffix1" + sf_oAN + "suffix2");
        test("-840025000000", "" + sf_sM + s_I);
        test("-840025000000suffix", "" + sf_sM + s_I + "suffix");
        test("prefix-8400suffix125000000suffix2", "prefix" + sf_sM + "suffix1" + s_I + "suffix2");
        test("C(82)-96.0", "" + s_o + s_dM);
        test("C(82)-96.0suffix", "" + s_o + s_dM + "suffix");
        test("prefixC(82)suffix1-96.0suffix2", "prefix" + s_o + "suffix1" + s_dM + "suffix2");
        test("C(82)null", "" + s_o + s_oNtS);
        test("C(82)nullsuffix", "" + s_o + s_oNtS + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + s_oNtS + "suffix2");
        test("C(82)\u045176", "" + s_o + f_strU);
        test("C(82)\u045176suffix", "" + s_o + f_strU + "suffix");
        test("prefixC(82)suffix1\u045176suffix2", "prefix" + s_o + "suffix1" + f_strU + "suffix2");
        test("C(82)92", "" + s_o + sf_strU2);
        test("C(82)92suffix", "" + s_o + sf_strU2 + "suffix");
        test("prefixC(82)suffix192suffix2", "prefix" + s_o + "suffix1" + sf_strU2 + "suffix2");
        test("C(82)51", "" + s_o + sf_strU1);
        test("C(82)51suffix", "" + s_o + sf_strU1 + "suffix");
        test("prefixC(82)suffix151suffix2", "prefix" + s_o + "suffix1" + sf_strU1 + "suffix2");
        test("C(82)null", "" + s_o + s_iAN);
        test("C(82)nullsuffix", "" + s_o + s_iAN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + s_iAN + "suffix2");
        test("C(82)-54", "" + s_o + f_bM);
        test("C(82)-54suffix", "" + s_o + f_bM + "suffix");
        test("prefixC(82)suffix1-54suffix2", "prefix" + s_o + "suffix1" + f_bM + "suffix2");
        test("C(82)-87.0", "" + s_o + f_fM);
        test("C(82)-87.0suffix", "" + s_o + f_fM + "suffix");
        test("prefixC(82)suffix1-87.0suffix2", "prefix" + s_o + "suffix1" + f_fM + "suffix2");
        test("C(82)null", "" + s_o + s_oAN);
        test("C(82)nullsuffix", "" + s_o + s_oAN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + s_oAN + "suffix2");
        test("C(82)19", "" + s_o + f_str);
        test("C(82)19suffix", "" + s_o + f_str + "suffix");
        test("prefixC(82)suffix119suffix2", "prefix" + s_o + "suffix1" + f_str + "suffix2");
        test("C(82)-41", "" + s_o + sf_bM);
        test("C(82)-41suffix", "" + s_o + sf_bM + "suffix");
        test("prefixC(82)suffix1-41suffix2", "prefix" + s_o + "suffix1" + sf_bM + "suffix2");
        test("C(82)null", "" + s_o + sf_IN);
        test("C(82)nullsuffix", "" + s_o + sf_IN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + sf_IN + "suffix2");
        test("C(82)T", "" + s_o + s_c);
        test("C(82)Tsuffix", "" + s_o + s_c + "suffix");
        test("prefixC(82)suffix1Tsuffix2", "prefix" + s_o + "suffix1" + s_c + "suffix2");
        test("C(82)-42.0", "" + s_o + sf_fM);
        test("C(82)-42.0suffix", "" + s_o + sf_fM + "suffix");
        test("prefixC(82)suffix1-42.0suffix2", "prefix" + s_o + "suffix1" + sf_fM + "suffix2");
        test("C(82)25", "" + s_o + s_b);
        test("C(82)25suffix", "" + s_o + s_b + "suffix");
        test("prefixC(82)suffix125suffix2", "prefix" + s_o + "suffix1" + s_b + "suffix2");
        test("C(82)null", "" + s_o + f_oN);
        test("C(82)nullsuffix", "" + s_o + f_oN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + f_oN + "suffix2");
        test("C(82)-1410065408", "" + s_o + s_lM);
        test("C(82)-1410065408suffix", "" + s_o + s_lM + "suffix");
        test("prefixC(82)suffix1-1410065408suffix2", "prefix" + s_o + "suffix1" + s_lM + "suffix2");
        test("C(82)8.0", "" + s_o + s_d);
        test("C(82)8.0suffix", "" + s_o + s_d + "suffix");
        test("prefixC(82)suffix18.0suffix2", "prefix" + s_o + "suffix1" + s_d + "suffix2");
        test("C(82)55.0", "" + s_o + s_f);
        test("C(82)55.0suffix", "" + s_o + s_f + "suffix");
        test("prefixC(82)suffix155.0suffix2", "prefix" + s_o + "suffix1" + s_f + "suffix2");
        test("C(82)97000000", "" + s_o + s_i);
        test("C(82)97000000suffix", "" + s_o + s_i + "suffix");
        test("prefixC(82)suffix197000000suffix2", "prefix" + s_o + "suffix1" + s_i + "suffix2");
        test("C(82)-9900", "" + s_o + f_sM);
        test("C(82)-9900suffix", "" + s_o + f_sM + "suffix");
        test("prefixC(82)suffix1-9900suffix2", "prefix" + s_o + "suffix1" + f_sM + "suffix2");
        test("C(82)935228928", "" + s_o + s_l);
        test("C(82)935228928suffix", "" + s_o + s_l + "suffix");
        test("prefixC(82)suffix1935228928suffix2", "prefix" + s_o + "suffix1" + s_l + "suffix2");
        test("C(82)-8400", "" + s_o + sf_sM);
        test("C(82)-8400suffix", "" + s_o + sf_sM + "suffix");
        test("prefixC(82)suffix1-8400suffix2", "prefix" + s_o + "suffix1" + sf_sM + "suffix2");
        test("C(82)C(82)", "" + s_o + s_o);
        test("C(82)C(82)suffix", "" + s_o + s_o + "suffix");
        test("prefixC(82)suffix1C(82)suffix2", "prefix" + s_o + "suffix1" + s_o + "suffix2");
        test("C(82)null", "" + s_o + sf_oNtS);
        test("C(82)nullsuffix", "" + s_o + sf_oNtS + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + sf_oNtS + "suffix2");
        test("C(82)true", "" + s_o + s_bl);
        test("C(82)truesuffix", "" + s_o + s_bl + "suffix");
        test("prefixC(82)suffix1truesuffix2", "prefix" + s_o + "suffix1" + s_bl + "suffix2");
        test("C(82)3900", "" + s_o + s_s);
        test("C(82)3900suffix", "" + s_o + s_s + "suffix");
        test("prefixC(82)suffix13900suffix2", "prefix" + s_o + "suffix1" + s_s + "suffix2");
        test("C(82)null", "" + s_o + sf_oN);
        test("C(82)nullsuffix", "" + s_o + sf_oN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + sf_oN + "suffix2");
        test("C(82)94000000", "" + s_o + f_I);
        test("C(82)94000000suffix", "" + s_o + f_I + "suffix");
        test("prefixC(82)suffix194000000suffix2", "prefix" + s_o + "suffix1" + f_I + "suffix2");
        test("C(82)null", "" + s_o + f_IN);
        test("C(82)nullsuffix", "" + s_o + f_IN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + f_IN + "suffix2");
        test("C(82)true", "" + s_o + sf_bl);
        test("C(82)truesuffix", "" + s_o + sf_bl + "suffix");
        test("prefixC(82)suffix1truesuffix2", "prefix" + s_o + "suffix1" + sf_bl + "suffix2");
        test("C(82)5500", "" + s_o + sf_s);
        test("C(82)5500suffix", "" + s_o + sf_s + "suffix");
        test("prefixC(82)suffix15500suffix2", "prefix" + s_o + "suffix1" + sf_s + "suffix2");
        test("C(82)-2900", "" + s_o + s_sM);
        test("C(82)-2900suffix", "" + s_o + s_sM + "suffix");
        test("prefixC(82)suffix1-2900suffix2", "prefix" + s_o + "suffix1" + s_sM + "suffix2");
        test("C(82)-194313216", "" + s_o + sf_l);
        test("C(82)-194313216suffix", "" + s_o + sf_l + "suffix");
        test("prefixC(82)suffix1-194313216suffix2", "prefix" + s_o + "suffix1" + sf_l + "suffix2");
        test("C(82)12", "" + s_o + s_strU1);
        test("C(82)12suffix", "" + s_o + s_strU1 + "suffix");
        test("prefixC(82)suffix112suffix2", "prefix" + s_o + "suffix1" + s_strU1 + "suffix2");
        test("C(82)C(87)", "" + s_o + sf_o);
        test("C(82)C(87)suffix", "" + s_o + sf_o + "suffix");
        test("prefixC(82)suffix1C(87)suffix2", "prefix" + s_o + "suffix1" + sf_o + "suffix2");
        test("C(82)91", "" + s_o + s_strU2);
        test("C(82)91suffix", "" + s_o + s_strU2 + "suffix");
        test("prefixC(82)suffix191suffix2", "prefix" + s_o + "suffix1" + s_strU2 + "suffix2");
        test("C(82)21", "" + s_o + f_strU1);
        test("C(82)21suffix", "" + s_o + f_strU1 + "suffix");
        test("prefixC(82)suffix121suffix2", "prefix" + s_o + "suffix1" + f_strU1 + "suffix2");
        test("C(82)18", "" + s_o + f_strU2);
        test("C(82)18suffix", "" + s_o + f_strU2 + "suffix");
        test("prefixC(82)suffix118suffix2", "prefix" + s_o + "suffix1" + f_strU2 + "suffix2");
        test("C(82)null", "" + s_o + f_iAN);
        test("C(82)nullsuffix", "" + s_o + f_iAN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + f_iAN + "suffix2");
        test("C(82)null", "" + s_o + s_oN);
        test("C(82)nullsuffix", "" + s_o + s_oN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + s_oN + "suffix2");
        test("C(82)\u045180", "" + s_o + s_strU);
        test("C(82)\u045180suffix", "" + s_o + s_strU + "suffix");
        test("prefixC(82)suffix1\u045180suffix2", "prefix" + s_o + "suffix1" + s_strU + "suffix2");
        test("C(82)C", "" + s_o + sf_c);
        test("C(82)Csuffix", "" + s_o + sf_c + "suffix");
        test("prefixC(82)suffix1Csuffix2", "prefix" + s_o + "suffix1" + sf_c + "suffix2");
        test("C(82)75", "" + s_o + sf_str);
        test("C(82)75suffix", "" + s_o + sf_str + "suffix");
        test("prefixC(82)suffix175suffix2", "prefix" + s_o + "suffix1" + sf_str + "suffix2");
        test("C(82)-43", "" + s_o + s_bM);
        test("C(82)-43suffix", "" + s_o + s_bM + "suffix");
        test("prefixC(82)suffix1-43suffix2", "prefix" + s_o + "suffix1" + s_bM + "suffix2");
        test("C(82)80", "" + s_o + sf_b);
        test("C(82)80suffix", "" + s_o + sf_b + "suffix");
        test("prefixC(82)suffix180suffix2", "prefix" + s_o + "suffix1" + sf_b + "suffix2");
        test("C(82)null", "" + s_o + s_IN);
        test("C(82)nullsuffix", "" + s_o + s_IN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + s_IN + "suffix2");
        test("C(82)-52.0", "" + s_o + s_fM);
        test("C(82)-52.0suffix", "" + s_o + s_fM + "suffix");
        test("prefixC(82)suffix1-52.0suffix2", "prefix" + s_o + "suffix1" + s_fM + "suffix2");
        test("C(82)75000000", "" + s_o + sf_i);
        test("C(82)75000000suffix", "" + s_o + sf_i + "suffix");
        test("prefixC(82)suffix175000000suffix2", "prefix" + s_o + "suffix1" + sf_i + "suffix2");
        test("C(82)44", "" + s_o + f_b);
        test("C(82)44suffix", "" + s_o + f_b + "suffix");
        test("prefixC(82)suffix144suffix2", "prefix" + s_o + "suffix1" + f_b + "suffix2");
        test("C(82)-1705032704", "" + s_o + sf_lM);
        test("C(82)-1705032704suffix", "" + s_o + sf_lM + "suffix");
        test("prefixC(82)suffix1-1705032704suffix2", "prefix" + s_o + "suffix1" + sf_lM + "suffix2");
        test("C(82)null", "" + s_o + f_oAN);
        test("C(82)nullsuffix", "" + s_o + f_oAN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + f_oAN + "suffix2");
        test("C(82)83.0", "" + s_o + f_d);
        test("C(82)83.0suffix", "" + s_o + f_d + "suffix");
        test("prefixC(82)suffix183.0suffix2", "prefix" + s_o + "suffix1" + f_d + "suffix2");
        test("C(82)I", "" + s_o + f_c);
        test("C(82)Isuffix", "" + s_o + f_c + "suffix");
        test("prefixC(82)suffix1Isuffix2", "prefix" + s_o + "suffix1" + f_c + "suffix2");
        test("C(82)94.0", "" + s_o + f_f);
        test("C(82)94.0suffix", "" + s_o + f_f + "suffix");
        test("prefixC(82)suffix194.0suffix2", "prefix" + s_o + "suffix1" + f_f + "suffix2");
        test("C(82)12.0", "" + s_o + sf_d);
        test("C(82)12.0suffix", "" + s_o + sf_d + "suffix");
        test("prefixC(82)suffix112.0suffix2", "prefix" + s_o + "suffix1" + sf_d + "suffix2");
        test("C(82)-99.0", "" + s_o + f_dM);
        test("C(82)-99.0suffix", "" + s_o + f_dM + "suffix");
        test("prefixC(82)suffix1-99.0suffix2", "prefix" + s_o + "suffix1" + f_dM + "suffix2");
        test("C(82)17.0", "" + s_o + sf_f);
        test("C(82)17.0suffix", "" + s_o + sf_f + "suffix");
        test("prefixC(82)suffix117.0suffix2", "prefix" + s_o + "suffix1" + sf_f + "suffix2");
        test("C(82)-84.0", "" + s_o + sf_dM);
        test("C(82)-84.0suffix", "" + s_o + sf_dM + "suffix");
        test("prefixC(82)suffix1-84.0suffix2", "prefix" + s_o + "suffix1" + sf_dM + "suffix2");
        test("C(82)58000000", "" + s_o + f_i);
        test("C(82)58000000suffix", "" + s_o + f_i + "suffix");
        test("prefixC(82)suffix158000000suffix2", "prefix" + s_o + "suffix1" + f_i + "suffix2");
        test("C(82)-55000000", "" + s_o + f_iM);
        test("C(82)-55000000suffix", "" + s_o + f_iM + "suffix");
        test("prefixC(82)suffix1-55000000suffix2", "prefix" + s_o + "suffix1" + f_iM + "suffix2");
        test("C(82)1460392448", "" + s_o + f_l);
        test("C(82)1460392448suffix", "" + s_o + f_l + "suffix");
        test("prefixC(82)suffix11460392448suffix2", "prefix" + s_o + "suffix1" + f_l + "suffix2");
        test("C(82)C(70)", "" + s_o + f_o);
        test("C(82)C(70)suffix", "" + s_o + f_o + "suffix");
        test("prefixC(82)suffix1C(70)suffix2", "prefix" + s_o + "suffix1" + f_o + "suffix2");
        test("C(82)\u04511", "" + s_o + sf_strU);
        test("C(82)\u04511suffix", "" + s_o + sf_strU + "suffix");
        test("prefixC(82)suffix1\u04511suffix2", "prefix" + s_o + "suffix1" + sf_strU + "suffix2");
        test("C(82)8000", "" + s_o + f_s);
        test("C(82)8000suffix", "" + s_o + f_s + "suffix");
        test("prefixC(82)suffix18000suffix2", "prefix" + s_o + "suffix1" + f_s + "suffix2");
        test("C(82)18", "" + s_o + s_str);
        test("C(82)18suffix", "" + s_o + s_str + "suffix");
        test("prefixC(82)suffix118suffix2", "prefix" + s_o + "suffix1" + s_str + "suffix2");
        test("C(82)-1000000", "" + s_o + s_iM);
        test("C(82)-1000000suffix", "" + s_o + s_iM + "suffix");
        test("prefixC(82)suffix1-1000000suffix2", "prefix" + s_o + "suffix1" + s_iM + "suffix2");
        test("C(82)1000000", "" + s_o + sf_I);
        test("C(82)1000000suffix", "" + s_o + sf_I + "suffix");
        test("prefixC(82)suffix11000000suffix2", "prefix" + s_o + "suffix1" + sf_I + "suffix2");
        test("C(82)null", "" + s_o + f_oNtS);
        test("C(82)nullsuffix", "" + s_o + f_oNtS + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + f_oNtS + "suffix2");
        test("C(82)false", "" + s_o + f_bl);
        test("C(82)falsesuffix", "" + s_o + f_bl + "suffix");
        test("prefixC(82)suffix1falsesuffix2", "prefix" + s_o + "suffix1" + f_bl + "suffix2");
        test("C(82)null", "" + s_o + sf_iAN);
        test("C(82)nullsuffix", "" + s_o + sf_iAN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + sf_iAN + "suffix2");
        test("C(82)-2000000", "" + s_o + sf_iM);
        test("C(82)-2000000suffix", "" + s_o + sf_iM + "suffix");
        test("prefixC(82)suffix1-2000000suffix2", "prefix" + s_o + "suffix1" + sf_iM + "suffix2");
        test("C(82)-820130816", "" + s_o + f_lM);
        test("C(82)-820130816suffix", "" + s_o + f_lM + "suffix");
        test("prefixC(82)suffix1-820130816suffix2", "prefix" + s_o + "suffix1" + f_lM + "suffix2");
        test("C(82)null", "" + s_o + sf_oAN);
        test("C(82)nullsuffix", "" + s_o + sf_oAN + "suffix");
        test("prefixC(82)suffix1nullsuffix2", "prefix" + s_o + "suffix1" + sf_oAN + "suffix2");
        test("C(82)25000000", "" + s_o + s_I);
        test("C(82)25000000suffix", "" + s_o + s_I + "suffix");
        test("prefixC(82)suffix125000000suffix2", "prefix" + s_o + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + sf_oNtS + s_dM);
        test("null-96.0suffix", "" + sf_oNtS + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + sf_oNtS + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + sf_oNtS + s_oNtS);
        test("nullnullsuffix", "" + sf_oNtS + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + sf_oNtS + f_strU);
        test("null\u045176suffix", "" + sf_oNtS + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + sf_oNtS + "suffix1" + f_strU + "suffix2");
        test("null92", "" + sf_oNtS + sf_strU2);
        test("null92suffix", "" + sf_oNtS + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + sf_oNtS + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + sf_oNtS + sf_strU1);
        test("null51suffix", "" + sf_oNtS + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + sf_oNtS + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + sf_oNtS + s_iAN);
        test("nullnullsuffix", "" + sf_oNtS + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + sf_oNtS + f_bM);
        test("null-54suffix", "" + sf_oNtS + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + sf_oNtS + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + sf_oNtS + f_fM);
        test("null-87.0suffix", "" + sf_oNtS + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + sf_oNtS + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + sf_oNtS + s_oAN);
        test("nullnullsuffix", "" + sf_oNtS + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + sf_oNtS + f_str);
        test("null19suffix", "" + sf_oNtS + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + sf_oNtS + "suffix1" + f_str + "suffix2");
        test("null-41", "" + sf_oNtS + sf_bM);
        test("null-41suffix", "" + sf_oNtS + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + sf_oNtS + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + sf_oNtS + sf_IN);
        test("nullnullsuffix", "" + sf_oNtS + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + sf_oNtS + s_c);
        test("nullTsuffix", "" + sf_oNtS + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + sf_oNtS + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + sf_oNtS + sf_fM);
        test("null-42.0suffix", "" + sf_oNtS + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + sf_oNtS + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + sf_oNtS + s_b);
        test("null25suffix", "" + sf_oNtS + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + sf_oNtS + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + sf_oNtS + f_oN);
        test("nullnullsuffix", "" + sf_oNtS + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + sf_oNtS + s_lM);
        test("null-1410065408suffix", "" + sf_oNtS + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + sf_oNtS + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + sf_oNtS + s_d);
        test("null8.0suffix", "" + sf_oNtS + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + sf_oNtS + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + sf_oNtS + s_f);
        test("null55.0suffix", "" + sf_oNtS + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + sf_oNtS + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + sf_oNtS + s_i);
        test("null97000000suffix", "" + sf_oNtS + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + sf_oNtS + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + sf_oNtS + f_sM);
        test("null-9900suffix", "" + sf_oNtS + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + sf_oNtS + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + sf_oNtS + s_l);
        test("null935228928suffix", "" + sf_oNtS + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + sf_oNtS + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + sf_oNtS + sf_sM);
        test("null-8400suffix", "" + sf_oNtS + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + sf_oNtS + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + sf_oNtS + s_o);
        test("nullC(82)suffix", "" + sf_oNtS + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + sf_oNtS + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + sf_oNtS + sf_oNtS);
        test("nullnullsuffix", "" + sf_oNtS + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + sf_oNtS + s_bl);
        test("nulltruesuffix", "" + sf_oNtS + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + sf_oNtS + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + sf_oNtS + s_s);
        test("null3900suffix", "" + sf_oNtS + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + sf_oNtS + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + sf_oNtS + sf_oN);
        test("nullnullsuffix", "" + sf_oNtS + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + sf_oNtS + f_I);
        test("null94000000suffix", "" + sf_oNtS + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + sf_oNtS + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + sf_oNtS + f_IN);
        test("nullnullsuffix", "" + sf_oNtS + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + sf_oNtS + sf_bl);
        test("nulltruesuffix", "" + sf_oNtS + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + sf_oNtS + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + sf_oNtS + sf_s);
        test("null5500suffix", "" + sf_oNtS + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + sf_oNtS + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + sf_oNtS + s_sM);
        test("null-2900suffix", "" + sf_oNtS + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + sf_oNtS + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + sf_oNtS + sf_l);
        test("null-194313216suffix", "" + sf_oNtS + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + sf_oNtS + "suffix1" + sf_l + "suffix2");
        test("null12", "" + sf_oNtS + s_strU1);
        test("null12suffix", "" + sf_oNtS + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + sf_oNtS + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + sf_oNtS + sf_o);
        test("nullC(87)suffix", "" + sf_oNtS + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + sf_oNtS + "suffix1" + sf_o + "suffix2");
        test("null91", "" + sf_oNtS + s_strU2);
        test("null91suffix", "" + sf_oNtS + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + sf_oNtS + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + sf_oNtS + f_strU1);
        test("null21suffix", "" + sf_oNtS + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + sf_oNtS + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + sf_oNtS + f_strU2);
        test("null18suffix", "" + sf_oNtS + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + sf_oNtS + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + sf_oNtS + f_iAN);
        test("nullnullsuffix", "" + sf_oNtS + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + sf_oNtS + s_oN);
        test("nullnullsuffix", "" + sf_oNtS + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + sf_oNtS + s_strU);
        test("null\u045180suffix", "" + sf_oNtS + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + sf_oNtS + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + sf_oNtS + sf_c);
        test("nullCsuffix", "" + sf_oNtS + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + sf_oNtS + "suffix1" + sf_c + "suffix2");
        test("null75", "" + sf_oNtS + sf_str);
        test("null75suffix", "" + sf_oNtS + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + sf_oNtS + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + sf_oNtS + s_bM);
        test("null-43suffix", "" + sf_oNtS + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + sf_oNtS + "suffix1" + s_bM + "suffix2");
        test("null80", "" + sf_oNtS + sf_b);
        test("null80suffix", "" + sf_oNtS + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + sf_oNtS + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + sf_oNtS + s_IN);
        test("nullnullsuffix", "" + sf_oNtS + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + sf_oNtS + s_fM);
        test("null-52.0suffix", "" + sf_oNtS + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + sf_oNtS + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + sf_oNtS + sf_i);
        test("null75000000suffix", "" + sf_oNtS + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + sf_oNtS + "suffix1" + sf_i + "suffix2");
        test("null44", "" + sf_oNtS + f_b);
        test("null44suffix", "" + sf_oNtS + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + sf_oNtS + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + sf_oNtS + sf_lM);
        test("null-1705032704suffix", "" + sf_oNtS + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + sf_oNtS + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + sf_oNtS + f_oAN);
        test("nullnullsuffix", "" + sf_oNtS + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + sf_oNtS + f_d);
        test("null83.0suffix", "" + sf_oNtS + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + sf_oNtS + "suffix1" + f_d + "suffix2");
        test("nullI", "" + sf_oNtS + f_c);
        test("nullIsuffix", "" + sf_oNtS + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + sf_oNtS + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + sf_oNtS + f_f);
        test("null94.0suffix", "" + sf_oNtS + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + sf_oNtS + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + sf_oNtS + sf_d);
        test("null12.0suffix", "" + sf_oNtS + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + sf_oNtS + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + sf_oNtS + f_dM);
        test("null-99.0suffix", "" + sf_oNtS + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + sf_oNtS + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + sf_oNtS + sf_f);
        test("null17.0suffix", "" + sf_oNtS + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + sf_oNtS + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + sf_oNtS + sf_dM);
        test("null-84.0suffix", "" + sf_oNtS + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + sf_oNtS + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + sf_oNtS + f_i);
        test("null58000000suffix", "" + sf_oNtS + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + sf_oNtS + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + sf_oNtS + f_iM);
        test("null-55000000suffix", "" + sf_oNtS + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + sf_oNtS + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + sf_oNtS + f_l);
        test("null1460392448suffix", "" + sf_oNtS + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + sf_oNtS + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + sf_oNtS + f_o);
        test("nullC(70)suffix", "" + sf_oNtS + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + sf_oNtS + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + sf_oNtS + sf_strU);
        test("null\u04511suffix", "" + sf_oNtS + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + sf_oNtS + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + sf_oNtS + f_s);
        test("null8000suffix", "" + sf_oNtS + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + sf_oNtS + "suffix1" + f_s + "suffix2");
        test("null18", "" + sf_oNtS + s_str);
        test("null18suffix", "" + sf_oNtS + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + sf_oNtS + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + sf_oNtS + s_iM);
        test("null-1000000suffix", "" + sf_oNtS + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + sf_oNtS + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + sf_oNtS + sf_I);
        test("null1000000suffix", "" + sf_oNtS + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + sf_oNtS + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + sf_oNtS + f_oNtS);
        test("nullnullsuffix", "" + sf_oNtS + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + sf_oNtS + f_bl);
        test("nullfalsesuffix", "" + sf_oNtS + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + sf_oNtS + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + sf_oNtS + sf_iAN);
        test("nullnullsuffix", "" + sf_oNtS + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + sf_oNtS + sf_iM);
        test("null-2000000suffix", "" + sf_oNtS + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + sf_oNtS + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + sf_oNtS + f_lM);
        test("null-820130816suffix", "" + sf_oNtS + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + sf_oNtS + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + sf_oNtS + sf_oAN);
        test("nullnullsuffix", "" + sf_oNtS + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oNtS + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + sf_oNtS + s_I);
        test("null25000000suffix", "" + sf_oNtS + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + sf_oNtS + "suffix1" + s_I + "suffix2");
        test("true-96.0", "" + s_bl + s_dM);
        test("true-96.0suffix", "" + s_bl + s_dM + "suffix");
        test("prefixtruesuffix1-96.0suffix2", "prefix" + s_bl + "suffix1" + s_dM + "suffix2");
        test("truenull", "" + s_bl + s_oNtS);
        test("truenullsuffix", "" + s_bl + s_oNtS + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + s_oNtS + "suffix2");
        test("true\u045176", "" + s_bl + f_strU);
        test("true\u045176suffix", "" + s_bl + f_strU + "suffix");
        test("prefixtruesuffix1\u045176suffix2", "prefix" + s_bl + "suffix1" + f_strU + "suffix2");
        test("true92", "" + s_bl + sf_strU2);
        test("true92suffix", "" + s_bl + sf_strU2 + "suffix");
        test("prefixtruesuffix192suffix2", "prefix" + s_bl + "suffix1" + sf_strU2 + "suffix2");
        test("true51", "" + s_bl + sf_strU1);
        test("true51suffix", "" + s_bl + sf_strU1 + "suffix");
        test("prefixtruesuffix151suffix2", "prefix" + s_bl + "suffix1" + sf_strU1 + "suffix2");
        test("truenull", "" + s_bl + s_iAN);
        test("truenullsuffix", "" + s_bl + s_iAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + s_iAN + "suffix2");
        test("true-54", "" + s_bl + f_bM);
        test("true-54suffix", "" + s_bl + f_bM + "suffix");
        test("prefixtruesuffix1-54suffix2", "prefix" + s_bl + "suffix1" + f_bM + "suffix2");
        test("true-87.0", "" + s_bl + f_fM);
        test("true-87.0suffix", "" + s_bl + f_fM + "suffix");
        test("prefixtruesuffix1-87.0suffix2", "prefix" + s_bl + "suffix1" + f_fM + "suffix2");
        test("truenull", "" + s_bl + s_oAN);
        test("truenullsuffix", "" + s_bl + s_oAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + s_oAN + "suffix2");
        test("true19", "" + s_bl + f_str);
        test("true19suffix", "" + s_bl + f_str + "suffix");
        test("prefixtruesuffix119suffix2", "prefix" + s_bl + "suffix1" + f_str + "suffix2");
        test("true-41", "" + s_bl + sf_bM);
        test("true-41suffix", "" + s_bl + sf_bM + "suffix");
        test("prefixtruesuffix1-41suffix2", "prefix" + s_bl + "suffix1" + sf_bM + "suffix2");
        test("truenull", "" + s_bl + sf_IN);
        test("truenullsuffix", "" + s_bl + sf_IN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + sf_IN + "suffix2");
        test("trueT", "" + s_bl + s_c);
        test("trueTsuffix", "" + s_bl + s_c + "suffix");
        test("prefixtruesuffix1Tsuffix2", "prefix" + s_bl + "suffix1" + s_c + "suffix2");
        test("true-42.0", "" + s_bl + sf_fM);
        test("true-42.0suffix", "" + s_bl + sf_fM + "suffix");
        test("prefixtruesuffix1-42.0suffix2", "prefix" + s_bl + "suffix1" + sf_fM + "suffix2");
        test("true25", "" + s_bl + s_b);
        test("true25suffix", "" + s_bl + s_b + "suffix");
        test("prefixtruesuffix125suffix2", "prefix" + s_bl + "suffix1" + s_b + "suffix2");
        test("truenull", "" + s_bl + f_oN);
        test("truenullsuffix", "" + s_bl + f_oN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + f_oN + "suffix2");
        test("true-1410065408", "" + s_bl + s_lM);
        test("true-1410065408suffix", "" + s_bl + s_lM + "suffix");
        test("prefixtruesuffix1-1410065408suffix2", "prefix" + s_bl + "suffix1" + s_lM + "suffix2");
        test("true8.0", "" + s_bl + s_d);
        test("true8.0suffix", "" + s_bl + s_d + "suffix");
        test("prefixtruesuffix18.0suffix2", "prefix" + s_bl + "suffix1" + s_d + "suffix2");
        test("true55.0", "" + s_bl + s_f);
        test("true55.0suffix", "" + s_bl + s_f + "suffix");
        test("prefixtruesuffix155.0suffix2", "prefix" + s_bl + "suffix1" + s_f + "suffix2");
        test("true97000000", "" + s_bl + s_i);
        test("true97000000suffix", "" + s_bl + s_i + "suffix");
        test("prefixtruesuffix197000000suffix2", "prefix" + s_bl + "suffix1" + s_i + "suffix2");
        test("true-9900", "" + s_bl + f_sM);
        test("true-9900suffix", "" + s_bl + f_sM + "suffix");
        test("prefixtruesuffix1-9900suffix2", "prefix" + s_bl + "suffix1" + f_sM + "suffix2");
        test("true935228928", "" + s_bl + s_l);
        test("true935228928suffix", "" + s_bl + s_l + "suffix");
        test("prefixtruesuffix1935228928suffix2", "prefix" + s_bl + "suffix1" + s_l + "suffix2");
        test("true-8400", "" + s_bl + sf_sM);
        test("true-8400suffix", "" + s_bl + sf_sM + "suffix");
        test("prefixtruesuffix1-8400suffix2", "prefix" + s_bl + "suffix1" + sf_sM + "suffix2");
        test("trueC(82)", "" + s_bl + s_o);
        test("trueC(82)suffix", "" + s_bl + s_o + "suffix");
        test("prefixtruesuffix1C(82)suffix2", "prefix" + s_bl + "suffix1" + s_o + "suffix2");
        test("truenull", "" + s_bl + sf_oNtS);
        test("truenullsuffix", "" + s_bl + sf_oNtS + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + sf_oNtS + "suffix2");
    }

    public void run6() {
        test("truetrue", "" + s_bl + s_bl);
        test("truetruesuffix", "" + s_bl + s_bl + "suffix");
        test("prefixtruesuffix1truesuffix2", "prefix" + s_bl + "suffix1" + s_bl + "suffix2");
        test("true3900", "" + s_bl + s_s);
        test("true3900suffix", "" + s_bl + s_s + "suffix");
        test("prefixtruesuffix13900suffix2", "prefix" + s_bl + "suffix1" + s_s + "suffix2");
        test("truenull", "" + s_bl + sf_oN);
        test("truenullsuffix", "" + s_bl + sf_oN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + sf_oN + "suffix2");
        test("true94000000", "" + s_bl + f_I);
        test("true94000000suffix", "" + s_bl + f_I + "suffix");
        test("prefixtruesuffix194000000suffix2", "prefix" + s_bl + "suffix1" + f_I + "suffix2");
        test("truenull", "" + s_bl + f_IN);
        test("truenullsuffix", "" + s_bl + f_IN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + f_IN + "suffix2");
        test("truetrue", "" + s_bl + sf_bl);
        test("truetruesuffix", "" + s_bl + sf_bl + "suffix");
        test("prefixtruesuffix1truesuffix2", "prefix" + s_bl + "suffix1" + sf_bl + "suffix2");
        test("true5500", "" + s_bl + sf_s);
        test("true5500suffix", "" + s_bl + sf_s + "suffix");
        test("prefixtruesuffix15500suffix2", "prefix" + s_bl + "suffix1" + sf_s + "suffix2");
        test("true-2900", "" + s_bl + s_sM);
        test("true-2900suffix", "" + s_bl + s_sM + "suffix");
        test("prefixtruesuffix1-2900suffix2", "prefix" + s_bl + "suffix1" + s_sM + "suffix2");
        test("true-194313216", "" + s_bl + sf_l);
        test("true-194313216suffix", "" + s_bl + sf_l + "suffix");
        test("prefixtruesuffix1-194313216suffix2", "prefix" + s_bl + "suffix1" + sf_l + "suffix2");
        test("true12", "" + s_bl + s_strU1);
        test("true12suffix", "" + s_bl + s_strU1 + "suffix");
        test("prefixtruesuffix112suffix2", "prefix" + s_bl + "suffix1" + s_strU1 + "suffix2");
        test("trueC(87)", "" + s_bl + sf_o);
        test("trueC(87)suffix", "" + s_bl + sf_o + "suffix");
        test("prefixtruesuffix1C(87)suffix2", "prefix" + s_bl + "suffix1" + sf_o + "suffix2");
        test("true91", "" + s_bl + s_strU2);
        test("true91suffix", "" + s_bl + s_strU2 + "suffix");
        test("prefixtruesuffix191suffix2", "prefix" + s_bl + "suffix1" + s_strU2 + "suffix2");
        test("true21", "" + s_bl + f_strU1);
        test("true21suffix", "" + s_bl + f_strU1 + "suffix");
        test("prefixtruesuffix121suffix2", "prefix" + s_bl + "suffix1" + f_strU1 + "suffix2");
        test("true18", "" + s_bl + f_strU2);
        test("true18suffix", "" + s_bl + f_strU2 + "suffix");
        test("prefixtruesuffix118suffix2", "prefix" + s_bl + "suffix1" + f_strU2 + "suffix2");
        test("truenull", "" + s_bl + f_iAN);
        test("truenullsuffix", "" + s_bl + f_iAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + f_iAN + "suffix2");
        test("truenull", "" + s_bl + s_oN);
        test("truenullsuffix", "" + s_bl + s_oN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + s_oN + "suffix2");
        test("true\u045180", "" + s_bl + s_strU);
        test("true\u045180suffix", "" + s_bl + s_strU + "suffix");
        test("prefixtruesuffix1\u045180suffix2", "prefix" + s_bl + "suffix1" + s_strU + "suffix2");
        test("trueC", "" + s_bl + sf_c);
        test("trueCsuffix", "" + s_bl + sf_c + "suffix");
        test("prefixtruesuffix1Csuffix2", "prefix" + s_bl + "suffix1" + sf_c + "suffix2");
        test("true75", "" + s_bl + sf_str);
        test("true75suffix", "" + s_bl + sf_str + "suffix");
        test("prefixtruesuffix175suffix2", "prefix" + s_bl + "suffix1" + sf_str + "suffix2");
        test("true-43", "" + s_bl + s_bM);
        test("true-43suffix", "" + s_bl + s_bM + "suffix");
        test("prefixtruesuffix1-43suffix2", "prefix" + s_bl + "suffix1" + s_bM + "suffix2");
        test("true80", "" + s_bl + sf_b);
        test("true80suffix", "" + s_bl + sf_b + "suffix");
        test("prefixtruesuffix180suffix2", "prefix" + s_bl + "suffix1" + sf_b + "suffix2");
        test("truenull", "" + s_bl + s_IN);
        test("truenullsuffix", "" + s_bl + s_IN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + s_IN + "suffix2");
        test("true-52.0", "" + s_bl + s_fM);
        test("true-52.0suffix", "" + s_bl + s_fM + "suffix");
        test("prefixtruesuffix1-52.0suffix2", "prefix" + s_bl + "suffix1" + s_fM + "suffix2");
        test("true75000000", "" + s_bl + sf_i);
        test("true75000000suffix", "" + s_bl + sf_i + "suffix");
        test("prefixtruesuffix175000000suffix2", "prefix" + s_bl + "suffix1" + sf_i + "suffix2");
        test("true44", "" + s_bl + f_b);
        test("true44suffix", "" + s_bl + f_b + "suffix");
        test("prefixtruesuffix144suffix2", "prefix" + s_bl + "suffix1" + f_b + "suffix2");
        test("true-1705032704", "" + s_bl + sf_lM);
        test("true-1705032704suffix", "" + s_bl + sf_lM + "suffix");
        test("prefixtruesuffix1-1705032704suffix2", "prefix" + s_bl + "suffix1" + sf_lM + "suffix2");
        test("truenull", "" + s_bl + f_oAN);
        test("truenullsuffix", "" + s_bl + f_oAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + f_oAN + "suffix2");
        test("true83.0", "" + s_bl + f_d);
        test("true83.0suffix", "" + s_bl + f_d + "suffix");
        test("prefixtruesuffix183.0suffix2", "prefix" + s_bl + "suffix1" + f_d + "suffix2");
        test("trueI", "" + s_bl + f_c);
        test("trueIsuffix", "" + s_bl + f_c + "suffix");
        test("prefixtruesuffix1Isuffix2", "prefix" + s_bl + "suffix1" + f_c + "suffix2");
        test("true94.0", "" + s_bl + f_f);
        test("true94.0suffix", "" + s_bl + f_f + "suffix");
        test("prefixtruesuffix194.0suffix2", "prefix" + s_bl + "suffix1" + f_f + "suffix2");
        test("true12.0", "" + s_bl + sf_d);
        test("true12.0suffix", "" + s_bl + sf_d + "suffix");
        test("prefixtruesuffix112.0suffix2", "prefix" + s_bl + "suffix1" + sf_d + "suffix2");
        test("true-99.0", "" + s_bl + f_dM);
        test("true-99.0suffix", "" + s_bl + f_dM + "suffix");
        test("prefixtruesuffix1-99.0suffix2", "prefix" + s_bl + "suffix1" + f_dM + "suffix2");
        test("true17.0", "" + s_bl + sf_f);
        test("true17.0suffix", "" + s_bl + sf_f + "suffix");
        test("prefixtruesuffix117.0suffix2", "prefix" + s_bl + "suffix1" + sf_f + "suffix2");
        test("true-84.0", "" + s_bl + sf_dM);
        test("true-84.0suffix", "" + s_bl + sf_dM + "suffix");
        test("prefixtruesuffix1-84.0suffix2", "prefix" + s_bl + "suffix1" + sf_dM + "suffix2");
        test("true58000000", "" + s_bl + f_i);
        test("true58000000suffix", "" + s_bl + f_i + "suffix");
        test("prefixtruesuffix158000000suffix2", "prefix" + s_bl + "suffix1" + f_i + "suffix2");
        test("true-55000000", "" + s_bl + f_iM);
        test("true-55000000suffix", "" + s_bl + f_iM + "suffix");
        test("prefixtruesuffix1-55000000suffix2", "prefix" + s_bl + "suffix1" + f_iM + "suffix2");
        test("true1460392448", "" + s_bl + f_l);
        test("true1460392448suffix", "" + s_bl + f_l + "suffix");
        test("prefixtruesuffix11460392448suffix2", "prefix" + s_bl + "suffix1" + f_l + "suffix2");
        test("trueC(70)", "" + s_bl + f_o);
        test("trueC(70)suffix", "" + s_bl + f_o + "suffix");
        test("prefixtruesuffix1C(70)suffix2", "prefix" + s_bl + "suffix1" + f_o + "suffix2");
        test("true\u04511", "" + s_bl + sf_strU);
        test("true\u04511suffix", "" + s_bl + sf_strU + "suffix");
        test("prefixtruesuffix1\u04511suffix2", "prefix" + s_bl + "suffix1" + sf_strU + "suffix2");
        test("true8000", "" + s_bl + f_s);
        test("true8000suffix", "" + s_bl + f_s + "suffix");
        test("prefixtruesuffix18000suffix2", "prefix" + s_bl + "suffix1" + f_s + "suffix2");
        test("true18", "" + s_bl + s_str);
        test("true18suffix", "" + s_bl + s_str + "suffix");
        test("prefixtruesuffix118suffix2", "prefix" + s_bl + "suffix1" + s_str + "suffix2");
        test("true-1000000", "" + s_bl + s_iM);
        test("true-1000000suffix", "" + s_bl + s_iM + "suffix");
        test("prefixtruesuffix1-1000000suffix2", "prefix" + s_bl + "suffix1" + s_iM + "suffix2");
        test("true1000000", "" + s_bl + sf_I);
        test("true1000000suffix", "" + s_bl + sf_I + "suffix");
        test("prefixtruesuffix11000000suffix2", "prefix" + s_bl + "suffix1" + sf_I + "suffix2");
        test("truenull", "" + s_bl + f_oNtS);
        test("truenullsuffix", "" + s_bl + f_oNtS + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + f_oNtS + "suffix2");
        test("truefalse", "" + s_bl + f_bl);
        test("truefalsesuffix", "" + s_bl + f_bl + "suffix");
        test("prefixtruesuffix1falsesuffix2", "prefix" + s_bl + "suffix1" + f_bl + "suffix2");
        test("truenull", "" + s_bl + sf_iAN);
        test("truenullsuffix", "" + s_bl + sf_iAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + sf_iAN + "suffix2");
        test("true-2000000", "" + s_bl + sf_iM);
        test("true-2000000suffix", "" + s_bl + sf_iM + "suffix");
        test("prefixtruesuffix1-2000000suffix2", "prefix" + s_bl + "suffix1" + sf_iM + "suffix2");
        test("true-820130816", "" + s_bl + f_lM);
        test("true-820130816suffix", "" + s_bl + f_lM + "suffix");
        test("prefixtruesuffix1-820130816suffix2", "prefix" + s_bl + "suffix1" + f_lM + "suffix2");
        test("truenull", "" + s_bl + sf_oAN);
        test("truenullsuffix", "" + s_bl + sf_oAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + s_bl + "suffix1" + sf_oAN + "suffix2");
        test("true25000000", "" + s_bl + s_I);
        test("true25000000suffix", "" + s_bl + s_I + "suffix");
        test("prefixtruesuffix125000000suffix2", "prefix" + s_bl + "suffix1" + s_I + "suffix2");
        test("3900-96.0", "" + s_s + s_dM);
        test("3900-96.0suffix", "" + s_s + s_dM + "suffix");
        test("prefix3900suffix1-96.0suffix2", "prefix" + s_s + "suffix1" + s_dM + "suffix2");
        test("3900null", "" + s_s + s_oNtS);
        test("3900nullsuffix", "" + s_s + s_oNtS + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + s_oNtS + "suffix2");
        test("3900\u045176", "" + s_s + f_strU);
        test("3900\u045176suffix", "" + s_s + f_strU + "suffix");
        test("prefix3900suffix1\u045176suffix2", "prefix" + s_s + "suffix1" + f_strU + "suffix2");
        test("390092", "" + s_s + sf_strU2);
        test("390092suffix", "" + s_s + sf_strU2 + "suffix");
        test("prefix3900suffix192suffix2", "prefix" + s_s + "suffix1" + sf_strU2 + "suffix2");
        test("390051", "" + s_s + sf_strU1);
        test("390051suffix", "" + s_s + sf_strU1 + "suffix");
        test("prefix3900suffix151suffix2", "prefix" + s_s + "suffix1" + sf_strU1 + "suffix2");
        test("3900null", "" + s_s + s_iAN);
        test("3900nullsuffix", "" + s_s + s_iAN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + s_iAN + "suffix2");
        test("3900-54", "" + s_s + f_bM);
        test("3900-54suffix", "" + s_s + f_bM + "suffix");
        test("prefix3900suffix1-54suffix2", "prefix" + s_s + "suffix1" + f_bM + "suffix2");
        test("3900-87.0", "" + s_s + f_fM);
        test("3900-87.0suffix", "" + s_s + f_fM + "suffix");
        test("prefix3900suffix1-87.0suffix2", "prefix" + s_s + "suffix1" + f_fM + "suffix2");
        test("3900null", "" + s_s + s_oAN);
        test("3900nullsuffix", "" + s_s + s_oAN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + s_oAN + "suffix2");
        test("390019", "" + s_s + f_str);
        test("390019suffix", "" + s_s + f_str + "suffix");
        test("prefix3900suffix119suffix2", "prefix" + s_s + "suffix1" + f_str + "suffix2");
        test("3900-41", "" + s_s + sf_bM);
        test("3900-41suffix", "" + s_s + sf_bM + "suffix");
        test("prefix3900suffix1-41suffix2", "prefix" + s_s + "suffix1" + sf_bM + "suffix2");
        test("3900null", "" + s_s + sf_IN);
        test("3900nullsuffix", "" + s_s + sf_IN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + sf_IN + "suffix2");
        test("3900T", "" + s_s + s_c);
        test("3900Tsuffix", "" + s_s + s_c + "suffix");
        test("prefix3900suffix1Tsuffix2", "prefix" + s_s + "suffix1" + s_c + "suffix2");
        test("3900-42.0", "" + s_s + sf_fM);
        test("3900-42.0suffix", "" + s_s + sf_fM + "suffix");
        test("prefix3900suffix1-42.0suffix2", "prefix" + s_s + "suffix1" + sf_fM + "suffix2");
        test("390025", "" + s_s + s_b);
        test("390025suffix", "" + s_s + s_b + "suffix");
        test("prefix3900suffix125suffix2", "prefix" + s_s + "suffix1" + s_b + "suffix2");
        test("3900null", "" + s_s + f_oN);
        test("3900nullsuffix", "" + s_s + f_oN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + f_oN + "suffix2");
        test("3900-1410065408", "" + s_s + s_lM);
        test("3900-1410065408suffix", "" + s_s + s_lM + "suffix");
        test("prefix3900suffix1-1410065408suffix2", "prefix" + s_s + "suffix1" + s_lM + "suffix2");
        test("39008.0", "" + s_s + s_d);
        test("39008.0suffix", "" + s_s + s_d + "suffix");
        test("prefix3900suffix18.0suffix2", "prefix" + s_s + "suffix1" + s_d + "suffix2");
        test("390055.0", "" + s_s + s_f);
        test("390055.0suffix", "" + s_s + s_f + "suffix");
        test("prefix3900suffix155.0suffix2", "prefix" + s_s + "suffix1" + s_f + "suffix2");
        test("390097000000", "" + s_s + s_i);
        test("390097000000suffix", "" + s_s + s_i + "suffix");
        test("prefix3900suffix197000000suffix2", "prefix" + s_s + "suffix1" + s_i + "suffix2");
        test("3900-9900", "" + s_s + f_sM);
        test("3900-9900suffix", "" + s_s + f_sM + "suffix");
        test("prefix3900suffix1-9900suffix2", "prefix" + s_s + "suffix1" + f_sM + "suffix2");
        test("3900935228928", "" + s_s + s_l);
        test("3900935228928suffix", "" + s_s + s_l + "suffix");
        test("prefix3900suffix1935228928suffix2", "prefix" + s_s + "suffix1" + s_l + "suffix2");
        test("3900-8400", "" + s_s + sf_sM);
        test("3900-8400suffix", "" + s_s + sf_sM + "suffix");
        test("prefix3900suffix1-8400suffix2", "prefix" + s_s + "suffix1" + sf_sM + "suffix2");
        test("3900C(82)", "" + s_s + s_o);
        test("3900C(82)suffix", "" + s_s + s_o + "suffix");
        test("prefix3900suffix1C(82)suffix2", "prefix" + s_s + "suffix1" + s_o + "suffix2");
        test("3900null", "" + s_s + sf_oNtS);
        test("3900nullsuffix", "" + s_s + sf_oNtS + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + sf_oNtS + "suffix2");
        test("3900true", "" + s_s + s_bl);
        test("3900truesuffix", "" + s_s + s_bl + "suffix");
        test("prefix3900suffix1truesuffix2", "prefix" + s_s + "suffix1" + s_bl + "suffix2");
        test("39003900", "" + s_s + s_s);
        test("39003900suffix", "" + s_s + s_s + "suffix");
        test("prefix3900suffix13900suffix2", "prefix" + s_s + "suffix1" + s_s + "suffix2");
        test("3900null", "" + s_s + sf_oN);
        test("3900nullsuffix", "" + s_s + sf_oN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + sf_oN + "suffix2");
        test("390094000000", "" + s_s + f_I);
        test("390094000000suffix", "" + s_s + f_I + "suffix");
        test("prefix3900suffix194000000suffix2", "prefix" + s_s + "suffix1" + f_I + "suffix2");
        test("3900null", "" + s_s + f_IN);
        test("3900nullsuffix", "" + s_s + f_IN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + f_IN + "suffix2");
        test("3900true", "" + s_s + sf_bl);
        test("3900truesuffix", "" + s_s + sf_bl + "suffix");
        test("prefix3900suffix1truesuffix2", "prefix" + s_s + "suffix1" + sf_bl + "suffix2");
        test("39005500", "" + s_s + sf_s);
        test("39005500suffix", "" + s_s + sf_s + "suffix");
        test("prefix3900suffix15500suffix2", "prefix" + s_s + "suffix1" + sf_s + "suffix2");
        test("3900-2900", "" + s_s + s_sM);
        test("3900-2900suffix", "" + s_s + s_sM + "suffix");
        test("prefix3900suffix1-2900suffix2", "prefix" + s_s + "suffix1" + s_sM + "suffix2");
        test("3900-194313216", "" + s_s + sf_l);
        test("3900-194313216suffix", "" + s_s + sf_l + "suffix");
        test("prefix3900suffix1-194313216suffix2", "prefix" + s_s + "suffix1" + sf_l + "suffix2");
        test("390012", "" + s_s + s_strU1);
        test("390012suffix", "" + s_s + s_strU1 + "suffix");
        test("prefix3900suffix112suffix2", "prefix" + s_s + "suffix1" + s_strU1 + "suffix2");
        test("3900C(87)", "" + s_s + sf_o);
        test("3900C(87)suffix", "" + s_s + sf_o + "suffix");
        test("prefix3900suffix1C(87)suffix2", "prefix" + s_s + "suffix1" + sf_o + "suffix2");
        test("390091", "" + s_s + s_strU2);
        test("390091suffix", "" + s_s + s_strU2 + "suffix");
        test("prefix3900suffix191suffix2", "prefix" + s_s + "suffix1" + s_strU2 + "suffix2");
        test("390021", "" + s_s + f_strU1);
        test("390021suffix", "" + s_s + f_strU1 + "suffix");
        test("prefix3900suffix121suffix2", "prefix" + s_s + "suffix1" + f_strU1 + "suffix2");
        test("390018", "" + s_s + f_strU2);
        test("390018suffix", "" + s_s + f_strU2 + "suffix");
        test("prefix3900suffix118suffix2", "prefix" + s_s + "suffix1" + f_strU2 + "suffix2");
        test("3900null", "" + s_s + f_iAN);
        test("3900nullsuffix", "" + s_s + f_iAN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + f_iAN + "suffix2");
        test("3900null", "" + s_s + s_oN);
        test("3900nullsuffix", "" + s_s + s_oN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + s_oN + "suffix2");
        test("3900\u045180", "" + s_s + s_strU);
        test("3900\u045180suffix", "" + s_s + s_strU + "suffix");
        test("prefix3900suffix1\u045180suffix2", "prefix" + s_s + "suffix1" + s_strU + "suffix2");
        test("3900C", "" + s_s + sf_c);
        test("3900Csuffix", "" + s_s + sf_c + "suffix");
        test("prefix3900suffix1Csuffix2", "prefix" + s_s + "suffix1" + sf_c + "suffix2");
        test("390075", "" + s_s + sf_str);
        test("390075suffix", "" + s_s + sf_str + "suffix");
        test("prefix3900suffix175suffix2", "prefix" + s_s + "suffix1" + sf_str + "suffix2");
        test("3900-43", "" + s_s + s_bM);
        test("3900-43suffix", "" + s_s + s_bM + "suffix");
        test("prefix3900suffix1-43suffix2", "prefix" + s_s + "suffix1" + s_bM + "suffix2");
        test("390080", "" + s_s + sf_b);
        test("390080suffix", "" + s_s + sf_b + "suffix");
        test("prefix3900suffix180suffix2", "prefix" + s_s + "suffix1" + sf_b + "suffix2");
        test("3900null", "" + s_s + s_IN);
        test("3900nullsuffix", "" + s_s + s_IN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + s_IN + "suffix2");
        test("3900-52.0", "" + s_s + s_fM);
        test("3900-52.0suffix", "" + s_s + s_fM + "suffix");
        test("prefix3900suffix1-52.0suffix2", "prefix" + s_s + "suffix1" + s_fM + "suffix2");
        test("390075000000", "" + s_s + sf_i);
        test("390075000000suffix", "" + s_s + sf_i + "suffix");
        test("prefix3900suffix175000000suffix2", "prefix" + s_s + "suffix1" + sf_i + "suffix2");
        test("390044", "" + s_s + f_b);
        test("390044suffix", "" + s_s + f_b + "suffix");
        test("prefix3900suffix144suffix2", "prefix" + s_s + "suffix1" + f_b + "suffix2");
        test("3900-1705032704", "" + s_s + sf_lM);
        test("3900-1705032704suffix", "" + s_s + sf_lM + "suffix");
        test("prefix3900suffix1-1705032704suffix2", "prefix" + s_s + "suffix1" + sf_lM + "suffix2");
        test("3900null", "" + s_s + f_oAN);
        test("3900nullsuffix", "" + s_s + f_oAN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + f_oAN + "suffix2");
        test("390083.0", "" + s_s + f_d);
        test("390083.0suffix", "" + s_s + f_d + "suffix");
        test("prefix3900suffix183.0suffix2", "prefix" + s_s + "suffix1" + f_d + "suffix2");
        test("3900I", "" + s_s + f_c);
        test("3900Isuffix", "" + s_s + f_c + "suffix");
        test("prefix3900suffix1Isuffix2", "prefix" + s_s + "suffix1" + f_c + "suffix2");
        test("390094.0", "" + s_s + f_f);
        test("390094.0suffix", "" + s_s + f_f + "suffix");
        test("prefix3900suffix194.0suffix2", "prefix" + s_s + "suffix1" + f_f + "suffix2");
        test("390012.0", "" + s_s + sf_d);
        test("390012.0suffix", "" + s_s + sf_d + "suffix");
        test("prefix3900suffix112.0suffix2", "prefix" + s_s + "suffix1" + sf_d + "suffix2");
        test("3900-99.0", "" + s_s + f_dM);
        test("3900-99.0suffix", "" + s_s + f_dM + "suffix");
        test("prefix3900suffix1-99.0suffix2", "prefix" + s_s + "suffix1" + f_dM + "suffix2");
        test("390017.0", "" + s_s + sf_f);
        test("390017.0suffix", "" + s_s + sf_f + "suffix");
        test("prefix3900suffix117.0suffix2", "prefix" + s_s + "suffix1" + sf_f + "suffix2");
        test("3900-84.0", "" + s_s + sf_dM);
        test("3900-84.0suffix", "" + s_s + sf_dM + "suffix");
        test("prefix3900suffix1-84.0suffix2", "prefix" + s_s + "suffix1" + sf_dM + "suffix2");
        test("390058000000", "" + s_s + f_i);
        test("390058000000suffix", "" + s_s + f_i + "suffix");
        test("prefix3900suffix158000000suffix2", "prefix" + s_s + "suffix1" + f_i + "suffix2");
        test("3900-55000000", "" + s_s + f_iM);
        test("3900-55000000suffix", "" + s_s + f_iM + "suffix");
        test("prefix3900suffix1-55000000suffix2", "prefix" + s_s + "suffix1" + f_iM + "suffix2");
        test("39001460392448", "" + s_s + f_l);
        test("39001460392448suffix", "" + s_s + f_l + "suffix");
        test("prefix3900suffix11460392448suffix2", "prefix" + s_s + "suffix1" + f_l + "suffix2");
        test("3900C(70)", "" + s_s + f_o);
        test("3900C(70)suffix", "" + s_s + f_o + "suffix");
        test("prefix3900suffix1C(70)suffix2", "prefix" + s_s + "suffix1" + f_o + "suffix2");
        test("3900\u04511", "" + s_s + sf_strU);
        test("3900\u04511suffix", "" + s_s + sf_strU + "suffix");
        test("prefix3900suffix1\u04511suffix2", "prefix" + s_s + "suffix1" + sf_strU + "suffix2");
        test("39008000", "" + s_s + f_s);
        test("39008000suffix", "" + s_s + f_s + "suffix");
        test("prefix3900suffix18000suffix2", "prefix" + s_s + "suffix1" + f_s + "suffix2");
        test("390018", "" + s_s + s_str);
        test("390018suffix", "" + s_s + s_str + "suffix");
        test("prefix3900suffix118suffix2", "prefix" + s_s + "suffix1" + s_str + "suffix2");
        test("3900-1000000", "" + s_s + s_iM);
        test("3900-1000000suffix", "" + s_s + s_iM + "suffix");
        test("prefix3900suffix1-1000000suffix2", "prefix" + s_s + "suffix1" + s_iM + "suffix2");
        test("39001000000", "" + s_s + sf_I);
        test("39001000000suffix", "" + s_s + sf_I + "suffix");
        test("prefix3900suffix11000000suffix2", "prefix" + s_s + "suffix1" + sf_I + "suffix2");
        test("3900null", "" + s_s + f_oNtS);
        test("3900nullsuffix", "" + s_s + f_oNtS + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + f_oNtS + "suffix2");
        test("3900false", "" + s_s + f_bl);
        test("3900falsesuffix", "" + s_s + f_bl + "suffix");
        test("prefix3900suffix1falsesuffix2", "prefix" + s_s + "suffix1" + f_bl + "suffix2");
        test("3900null", "" + s_s + sf_iAN);
        test("3900nullsuffix", "" + s_s + sf_iAN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + sf_iAN + "suffix2");
        test("3900-2000000", "" + s_s + sf_iM);
        test("3900-2000000suffix", "" + s_s + sf_iM + "suffix");
        test("prefix3900suffix1-2000000suffix2", "prefix" + s_s + "suffix1" + sf_iM + "suffix2");
        test("3900-820130816", "" + s_s + f_lM);
        test("3900-820130816suffix", "" + s_s + f_lM + "suffix");
        test("prefix3900suffix1-820130816suffix2", "prefix" + s_s + "suffix1" + f_lM + "suffix2");
        test("3900null", "" + s_s + sf_oAN);
        test("3900nullsuffix", "" + s_s + sf_oAN + "suffix");
        test("prefix3900suffix1nullsuffix2", "prefix" + s_s + "suffix1" + sf_oAN + "suffix2");
        test("390025000000", "" + s_s + s_I);
        test("390025000000suffix", "" + s_s + s_I + "suffix");
        test("prefix3900suffix125000000suffix2", "prefix" + s_s + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + sf_oN + s_dM);
        test("null-96.0suffix", "" + sf_oN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + sf_oN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + sf_oN + s_oNtS);
        test("nullnullsuffix", "" + sf_oN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + sf_oN + f_strU);
        test("null\u045176suffix", "" + sf_oN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + sf_oN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + sf_oN + sf_strU2);
        test("null92suffix", "" + sf_oN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + sf_oN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + sf_oN + sf_strU1);
        test("null51suffix", "" + sf_oN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + sf_oN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + sf_oN + s_iAN);
        test("nullnullsuffix", "" + sf_oN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + sf_oN + f_bM);
        test("null-54suffix", "" + sf_oN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + sf_oN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + sf_oN + f_fM);
        test("null-87.0suffix", "" + sf_oN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + sf_oN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + sf_oN + s_oAN);
        test("nullnullsuffix", "" + sf_oN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + sf_oN + f_str);
        test("null19suffix", "" + sf_oN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + sf_oN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + sf_oN + sf_bM);
        test("null-41suffix", "" + sf_oN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + sf_oN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + sf_oN + sf_IN);
        test("nullnullsuffix", "" + sf_oN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + sf_oN + s_c);
        test("nullTsuffix", "" + sf_oN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + sf_oN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + sf_oN + sf_fM);
        test("null-42.0suffix", "" + sf_oN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + sf_oN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + sf_oN + s_b);
        test("null25suffix", "" + sf_oN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + sf_oN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + sf_oN + f_oN);
        test("nullnullsuffix", "" + sf_oN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + sf_oN + s_lM);
        test("null-1410065408suffix", "" + sf_oN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + sf_oN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + sf_oN + s_d);
        test("null8.0suffix", "" + sf_oN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + sf_oN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + sf_oN + s_f);
        test("null55.0suffix", "" + sf_oN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + sf_oN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + sf_oN + s_i);
        test("null97000000suffix", "" + sf_oN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + sf_oN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + sf_oN + f_sM);
        test("null-9900suffix", "" + sf_oN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + sf_oN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + sf_oN + s_l);
        test("null935228928suffix", "" + sf_oN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + sf_oN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + sf_oN + sf_sM);
        test("null-8400suffix", "" + sf_oN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + sf_oN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + sf_oN + s_o);
        test("nullC(82)suffix", "" + sf_oN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + sf_oN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + sf_oN + sf_oNtS);
        test("nullnullsuffix", "" + sf_oN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + sf_oN + s_bl);
        test("nulltruesuffix", "" + sf_oN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + sf_oN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + sf_oN + s_s);
        test("null3900suffix", "" + sf_oN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + sf_oN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + sf_oN + sf_oN);
        test("nullnullsuffix", "" + sf_oN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + sf_oN + f_I);
        test("null94000000suffix", "" + sf_oN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + sf_oN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + sf_oN + f_IN);
        test("nullnullsuffix", "" + sf_oN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + sf_oN + sf_bl);
        test("nulltruesuffix", "" + sf_oN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + sf_oN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + sf_oN + sf_s);
        test("null5500suffix", "" + sf_oN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + sf_oN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + sf_oN + s_sM);
        test("null-2900suffix", "" + sf_oN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + sf_oN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + sf_oN + sf_l);
        test("null-194313216suffix", "" + sf_oN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + sf_oN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + sf_oN + s_strU1);
        test("null12suffix", "" + sf_oN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + sf_oN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + sf_oN + sf_o);
        test("nullC(87)suffix", "" + sf_oN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + sf_oN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + sf_oN + s_strU2);
        test("null91suffix", "" + sf_oN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + sf_oN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + sf_oN + f_strU1);
        test("null21suffix", "" + sf_oN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + sf_oN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + sf_oN + f_strU2);
        test("null18suffix", "" + sf_oN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + sf_oN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + sf_oN + f_iAN);
        test("nullnullsuffix", "" + sf_oN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + sf_oN + s_oN);
        test("nullnullsuffix", "" + sf_oN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + sf_oN + s_strU);
        test("null\u045180suffix", "" + sf_oN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + sf_oN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + sf_oN + sf_c);
        test("nullCsuffix", "" + sf_oN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + sf_oN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + sf_oN + sf_str);
        test("null75suffix", "" + sf_oN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + sf_oN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + sf_oN + s_bM);
        test("null-43suffix", "" + sf_oN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + sf_oN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + sf_oN + sf_b);
        test("null80suffix", "" + sf_oN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + sf_oN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + sf_oN + s_IN);
        test("nullnullsuffix", "" + sf_oN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + sf_oN + s_fM);
        test("null-52.0suffix", "" + sf_oN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + sf_oN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + sf_oN + sf_i);
        test("null75000000suffix", "" + sf_oN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + sf_oN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + sf_oN + f_b);
        test("null44suffix", "" + sf_oN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + sf_oN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + sf_oN + sf_lM);
        test("null-1705032704suffix", "" + sf_oN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + sf_oN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + sf_oN + f_oAN);
        test("nullnullsuffix", "" + sf_oN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + sf_oN + f_d);
        test("null83.0suffix", "" + sf_oN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + sf_oN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + sf_oN + f_c);
        test("nullIsuffix", "" + sf_oN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + sf_oN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + sf_oN + f_f);
        test("null94.0suffix", "" + sf_oN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + sf_oN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + sf_oN + sf_d);
        test("null12.0suffix", "" + sf_oN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + sf_oN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + sf_oN + f_dM);
        test("null-99.0suffix", "" + sf_oN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + sf_oN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + sf_oN + sf_f);
        test("null17.0suffix", "" + sf_oN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + sf_oN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + sf_oN + sf_dM);
        test("null-84.0suffix", "" + sf_oN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + sf_oN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + sf_oN + f_i);
        test("null58000000suffix", "" + sf_oN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + sf_oN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + sf_oN + f_iM);
        test("null-55000000suffix", "" + sf_oN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + sf_oN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + sf_oN + f_l);
        test("null1460392448suffix", "" + sf_oN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + sf_oN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + sf_oN + f_o);
        test("nullC(70)suffix", "" + sf_oN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + sf_oN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + sf_oN + sf_strU);
        test("null\u04511suffix", "" + sf_oN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + sf_oN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + sf_oN + f_s);
        test("null8000suffix", "" + sf_oN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + sf_oN + "suffix1" + f_s + "suffix2");
        test("null18", "" + sf_oN + s_str);
        test("null18suffix", "" + sf_oN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + sf_oN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + sf_oN + s_iM);
        test("null-1000000suffix", "" + sf_oN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + sf_oN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + sf_oN + sf_I);
        test("null1000000suffix", "" + sf_oN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + sf_oN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + sf_oN + f_oNtS);
        test("nullnullsuffix", "" + sf_oN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + sf_oN + f_bl);
        test("nullfalsesuffix", "" + sf_oN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + sf_oN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + sf_oN + sf_iAN);
        test("nullnullsuffix", "" + sf_oN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + sf_oN + sf_iM);
        test("null-2000000suffix", "" + sf_oN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + sf_oN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + sf_oN + f_lM);
        test("null-820130816suffix", "" + sf_oN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + sf_oN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + sf_oN + sf_oAN);
        test("nullnullsuffix", "" + sf_oN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + sf_oN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + sf_oN + s_I);
        test("null25000000suffix", "" + sf_oN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + sf_oN + "suffix1" + s_I + "suffix2");
        test("94000000-96.0", "" + f_I + s_dM);
        test("94000000-96.0suffix", "" + f_I + s_dM + "suffix");
        test("prefix94000000suffix1-96.0suffix2", "prefix" + f_I + "suffix1" + s_dM + "suffix2");
        test("94000000null", "" + f_I + s_oNtS);
        test("94000000nullsuffix", "" + f_I + s_oNtS + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + s_oNtS + "suffix2");
        test("94000000\u045176", "" + f_I + f_strU);
        test("94000000\u045176suffix", "" + f_I + f_strU + "suffix");
        test("prefix94000000suffix1\u045176suffix2", "prefix" + f_I + "suffix1" + f_strU + "suffix2");
        test("9400000092", "" + f_I + sf_strU2);
        test("9400000092suffix", "" + f_I + sf_strU2 + "suffix");
        test("prefix94000000suffix192suffix2", "prefix" + f_I + "suffix1" + sf_strU2 + "suffix2");
        test("9400000051", "" + f_I + sf_strU1);
        test("9400000051suffix", "" + f_I + sf_strU1 + "suffix");
        test("prefix94000000suffix151suffix2", "prefix" + f_I + "suffix1" + sf_strU1 + "suffix2");
        test("94000000null", "" + f_I + s_iAN);
        test("94000000nullsuffix", "" + f_I + s_iAN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + s_iAN + "suffix2");
        test("94000000-54", "" + f_I + f_bM);
        test("94000000-54suffix", "" + f_I + f_bM + "suffix");
        test("prefix94000000suffix1-54suffix2", "prefix" + f_I + "suffix1" + f_bM + "suffix2");
        test("94000000-87.0", "" + f_I + f_fM);
        test("94000000-87.0suffix", "" + f_I + f_fM + "suffix");
        test("prefix94000000suffix1-87.0suffix2", "prefix" + f_I + "suffix1" + f_fM + "suffix2");
        test("94000000null", "" + f_I + s_oAN);
        test("94000000nullsuffix", "" + f_I + s_oAN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + s_oAN + "suffix2");
        test("9400000019", "" + f_I + f_str);
        test("9400000019suffix", "" + f_I + f_str + "suffix");
        test("prefix94000000suffix119suffix2", "prefix" + f_I + "suffix1" + f_str + "suffix2");
        test("94000000-41", "" + f_I + sf_bM);
        test("94000000-41suffix", "" + f_I + sf_bM + "suffix");
        test("prefix94000000suffix1-41suffix2", "prefix" + f_I + "suffix1" + sf_bM + "suffix2");
        test("94000000null", "" + f_I + sf_IN);
        test("94000000nullsuffix", "" + f_I + sf_IN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + sf_IN + "suffix2");
        test("94000000T", "" + f_I + s_c);
        test("94000000Tsuffix", "" + f_I + s_c + "suffix");
        test("prefix94000000suffix1Tsuffix2", "prefix" + f_I + "suffix1" + s_c + "suffix2");
        test("94000000-42.0", "" + f_I + sf_fM);
        test("94000000-42.0suffix", "" + f_I + sf_fM + "suffix");
        test("prefix94000000suffix1-42.0suffix2", "prefix" + f_I + "suffix1" + sf_fM + "suffix2");
        test("9400000025", "" + f_I + s_b);
        test("9400000025suffix", "" + f_I + s_b + "suffix");
        test("prefix94000000suffix125suffix2", "prefix" + f_I + "suffix1" + s_b + "suffix2");
        test("94000000null", "" + f_I + f_oN);
        test("94000000nullsuffix", "" + f_I + f_oN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + f_oN + "suffix2");
        test("94000000-1410065408", "" + f_I + s_lM);
        test("94000000-1410065408suffix", "" + f_I + s_lM + "suffix");
        test("prefix94000000suffix1-1410065408suffix2", "prefix" + f_I + "suffix1" + s_lM + "suffix2");
        test("940000008.0", "" + f_I + s_d);
        test("940000008.0suffix", "" + f_I + s_d + "suffix");
        test("prefix94000000suffix18.0suffix2", "prefix" + f_I + "suffix1" + s_d + "suffix2");
        test("9400000055.0", "" + f_I + s_f);
        test("9400000055.0suffix", "" + f_I + s_f + "suffix");
        test("prefix94000000suffix155.0suffix2", "prefix" + f_I + "suffix1" + s_f + "suffix2");
        test("9400000097000000", "" + f_I + s_i);
        test("9400000097000000suffix", "" + f_I + s_i + "suffix");
        test("prefix94000000suffix197000000suffix2", "prefix" + f_I + "suffix1" + s_i + "suffix2");
        test("94000000-9900", "" + f_I + f_sM);
        test("94000000-9900suffix", "" + f_I + f_sM + "suffix");
        test("prefix94000000suffix1-9900suffix2", "prefix" + f_I + "suffix1" + f_sM + "suffix2");
        test("94000000935228928", "" + f_I + s_l);
        test("94000000935228928suffix", "" + f_I + s_l + "suffix");
        test("prefix94000000suffix1935228928suffix2", "prefix" + f_I + "suffix1" + s_l + "suffix2");
        test("94000000-8400", "" + f_I + sf_sM);
        test("94000000-8400suffix", "" + f_I + sf_sM + "suffix");
        test("prefix94000000suffix1-8400suffix2", "prefix" + f_I + "suffix1" + sf_sM + "suffix2");
        test("94000000C(82)", "" + f_I + s_o);
        test("94000000C(82)suffix", "" + f_I + s_o + "suffix");
        test("prefix94000000suffix1C(82)suffix2", "prefix" + f_I + "suffix1" + s_o + "suffix2");
        test("94000000null", "" + f_I + sf_oNtS);
        test("94000000nullsuffix", "" + f_I + sf_oNtS + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + sf_oNtS + "suffix2");
        test("94000000true", "" + f_I + s_bl);
        test("94000000truesuffix", "" + f_I + s_bl + "suffix");
        test("prefix94000000suffix1truesuffix2", "prefix" + f_I + "suffix1" + s_bl + "suffix2");
        test("940000003900", "" + f_I + s_s);
        test("940000003900suffix", "" + f_I + s_s + "suffix");
        test("prefix94000000suffix13900suffix2", "prefix" + f_I + "suffix1" + s_s + "suffix2");
        test("94000000null", "" + f_I + sf_oN);
        test("94000000nullsuffix", "" + f_I + sf_oN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + sf_oN + "suffix2");
        test("9400000094000000", "" + f_I + f_I);
        test("9400000094000000suffix", "" + f_I + f_I + "suffix");
        test("prefix94000000suffix194000000suffix2", "prefix" + f_I + "suffix1" + f_I + "suffix2");
        test("94000000null", "" + f_I + f_IN);
        test("94000000nullsuffix", "" + f_I + f_IN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + f_IN + "suffix2");
        test("94000000true", "" + f_I + sf_bl);
        test("94000000truesuffix", "" + f_I + sf_bl + "suffix");
        test("prefix94000000suffix1truesuffix2", "prefix" + f_I + "suffix1" + sf_bl + "suffix2");
        test("940000005500", "" + f_I + sf_s);
        test("940000005500suffix", "" + f_I + sf_s + "suffix");
        test("prefix94000000suffix15500suffix2", "prefix" + f_I + "suffix1" + sf_s + "suffix2");
        test("94000000-2900", "" + f_I + s_sM);
        test("94000000-2900suffix", "" + f_I + s_sM + "suffix");
        test("prefix94000000suffix1-2900suffix2", "prefix" + f_I + "suffix1" + s_sM + "suffix2");
        test("94000000-194313216", "" + f_I + sf_l);
        test("94000000-194313216suffix", "" + f_I + sf_l + "suffix");
        test("prefix94000000suffix1-194313216suffix2", "prefix" + f_I + "suffix1" + sf_l + "suffix2");
        test("9400000012", "" + f_I + s_strU1);
        test("9400000012suffix", "" + f_I + s_strU1 + "suffix");
        test("prefix94000000suffix112suffix2", "prefix" + f_I + "suffix1" + s_strU1 + "suffix2");
        test("94000000C(87)", "" + f_I + sf_o);
        test("94000000C(87)suffix", "" + f_I + sf_o + "suffix");
        test("prefix94000000suffix1C(87)suffix2", "prefix" + f_I + "suffix1" + sf_o + "suffix2");
        test("9400000091", "" + f_I + s_strU2);
        test("9400000091suffix", "" + f_I + s_strU2 + "suffix");
        test("prefix94000000suffix191suffix2", "prefix" + f_I + "suffix1" + s_strU2 + "suffix2");
        test("9400000021", "" + f_I + f_strU1);
        test("9400000021suffix", "" + f_I + f_strU1 + "suffix");
        test("prefix94000000suffix121suffix2", "prefix" + f_I + "suffix1" + f_strU1 + "suffix2");
        test("9400000018", "" + f_I + f_strU2);
        test("9400000018suffix", "" + f_I + f_strU2 + "suffix");
        test("prefix94000000suffix118suffix2", "prefix" + f_I + "suffix1" + f_strU2 + "suffix2");
        test("94000000null", "" + f_I + f_iAN);
        test("94000000nullsuffix", "" + f_I + f_iAN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + f_iAN + "suffix2");
        test("94000000null", "" + f_I + s_oN);
        test("94000000nullsuffix", "" + f_I + s_oN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + s_oN + "suffix2");
        test("94000000\u045180", "" + f_I + s_strU);
        test("94000000\u045180suffix", "" + f_I + s_strU + "suffix");
        test("prefix94000000suffix1\u045180suffix2", "prefix" + f_I + "suffix1" + s_strU + "suffix2");
        test("94000000C", "" + f_I + sf_c);
        test("94000000Csuffix", "" + f_I + sf_c + "suffix");
        test("prefix94000000suffix1Csuffix2", "prefix" + f_I + "suffix1" + sf_c + "suffix2");
        test("9400000075", "" + f_I + sf_str);
        test("9400000075suffix", "" + f_I + sf_str + "suffix");
        test("prefix94000000suffix175suffix2", "prefix" + f_I + "suffix1" + sf_str + "suffix2");
        test("94000000-43", "" + f_I + s_bM);
        test("94000000-43suffix", "" + f_I + s_bM + "suffix");
        test("prefix94000000suffix1-43suffix2", "prefix" + f_I + "suffix1" + s_bM + "suffix2");
        test("9400000080", "" + f_I + sf_b);
        test("9400000080suffix", "" + f_I + sf_b + "suffix");
        test("prefix94000000suffix180suffix2", "prefix" + f_I + "suffix1" + sf_b + "suffix2");
        test("94000000null", "" + f_I + s_IN);
        test("94000000nullsuffix", "" + f_I + s_IN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + s_IN + "suffix2");
        test("94000000-52.0", "" + f_I + s_fM);
        test("94000000-52.0suffix", "" + f_I + s_fM + "suffix");
        test("prefix94000000suffix1-52.0suffix2", "prefix" + f_I + "suffix1" + s_fM + "suffix2");
        test("9400000075000000", "" + f_I + sf_i);
        test("9400000075000000suffix", "" + f_I + sf_i + "suffix");
        test("prefix94000000suffix175000000suffix2", "prefix" + f_I + "suffix1" + sf_i + "suffix2");
        test("9400000044", "" + f_I + f_b);
        test("9400000044suffix", "" + f_I + f_b + "suffix");
        test("prefix94000000suffix144suffix2", "prefix" + f_I + "suffix1" + f_b + "suffix2");
        test("94000000-1705032704", "" + f_I + sf_lM);
        test("94000000-1705032704suffix", "" + f_I + sf_lM + "suffix");
        test("prefix94000000suffix1-1705032704suffix2", "prefix" + f_I + "suffix1" + sf_lM + "suffix2");
        test("94000000null", "" + f_I + f_oAN);
        test("94000000nullsuffix", "" + f_I + f_oAN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + f_oAN + "suffix2");
        test("9400000083.0", "" + f_I + f_d);
        test("9400000083.0suffix", "" + f_I + f_d + "suffix");
        test("prefix94000000suffix183.0suffix2", "prefix" + f_I + "suffix1" + f_d + "suffix2");
        test("94000000I", "" + f_I + f_c);
        test("94000000Isuffix", "" + f_I + f_c + "suffix");
        test("prefix94000000suffix1Isuffix2", "prefix" + f_I + "suffix1" + f_c + "suffix2");
        test("9400000094.0", "" + f_I + f_f);
        test("9400000094.0suffix", "" + f_I + f_f + "suffix");
        test("prefix94000000suffix194.0suffix2", "prefix" + f_I + "suffix1" + f_f + "suffix2");
        test("9400000012.0", "" + f_I + sf_d);
        test("9400000012.0suffix", "" + f_I + sf_d + "suffix");
        test("prefix94000000suffix112.0suffix2", "prefix" + f_I + "suffix1" + sf_d + "suffix2");
        test("94000000-99.0", "" + f_I + f_dM);
        test("94000000-99.0suffix", "" + f_I + f_dM + "suffix");
        test("prefix94000000suffix1-99.0suffix2", "prefix" + f_I + "suffix1" + f_dM + "suffix2");
        test("9400000017.0", "" + f_I + sf_f);
        test("9400000017.0suffix", "" + f_I + sf_f + "suffix");
        test("prefix94000000suffix117.0suffix2", "prefix" + f_I + "suffix1" + sf_f + "suffix2");
        test("94000000-84.0", "" + f_I + sf_dM);
        test("94000000-84.0suffix", "" + f_I + sf_dM + "suffix");
        test("prefix94000000suffix1-84.0suffix2", "prefix" + f_I + "suffix1" + sf_dM + "suffix2");
        test("9400000058000000", "" + f_I + f_i);
        test("9400000058000000suffix", "" + f_I + f_i + "suffix");
        test("prefix94000000suffix158000000suffix2", "prefix" + f_I + "suffix1" + f_i + "suffix2");
        test("94000000-55000000", "" + f_I + f_iM);
        test("94000000-55000000suffix", "" + f_I + f_iM + "suffix");
        test("prefix94000000suffix1-55000000suffix2", "prefix" + f_I + "suffix1" + f_iM + "suffix2");
        test("940000001460392448", "" + f_I + f_l);
        test("940000001460392448suffix", "" + f_I + f_l + "suffix");
        test("prefix94000000suffix11460392448suffix2", "prefix" + f_I + "suffix1" + f_l + "suffix2");
        test("94000000C(70)", "" + f_I + f_o);
        test("94000000C(70)suffix", "" + f_I + f_o + "suffix");
        test("prefix94000000suffix1C(70)suffix2", "prefix" + f_I + "suffix1" + f_o + "suffix2");
        test("94000000\u04511", "" + f_I + sf_strU);
        test("94000000\u04511suffix", "" + f_I + sf_strU + "suffix");
        test("prefix94000000suffix1\u04511suffix2", "prefix" + f_I + "suffix1" + sf_strU + "suffix2");
        test("940000008000", "" + f_I + f_s);
        test("940000008000suffix", "" + f_I + f_s + "suffix");
        test("prefix94000000suffix18000suffix2", "prefix" + f_I + "suffix1" + f_s + "suffix2");
        test("9400000018", "" + f_I + s_str);
        test("9400000018suffix", "" + f_I + s_str + "suffix");
        test("prefix94000000suffix118suffix2", "prefix" + f_I + "suffix1" + s_str + "suffix2");
        test("94000000-1000000", "" + f_I + s_iM);
        test("94000000-1000000suffix", "" + f_I + s_iM + "suffix");
        test("prefix94000000suffix1-1000000suffix2", "prefix" + f_I + "suffix1" + s_iM + "suffix2");
        test("940000001000000", "" + f_I + sf_I);
        test("940000001000000suffix", "" + f_I + sf_I + "suffix");
        test("prefix94000000suffix11000000suffix2", "prefix" + f_I + "suffix1" + sf_I + "suffix2");
        test("94000000null", "" + f_I + f_oNtS);
        test("94000000nullsuffix", "" + f_I + f_oNtS + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + f_oNtS + "suffix2");
        test("94000000false", "" + f_I + f_bl);
        test("94000000falsesuffix", "" + f_I + f_bl + "suffix");
        test("prefix94000000suffix1falsesuffix2", "prefix" + f_I + "suffix1" + f_bl + "suffix2");
        test("94000000null", "" + f_I + sf_iAN);
        test("94000000nullsuffix", "" + f_I + sf_iAN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + sf_iAN + "suffix2");
        test("94000000-2000000", "" + f_I + sf_iM);
        test("94000000-2000000suffix", "" + f_I + sf_iM + "suffix");
        test("prefix94000000suffix1-2000000suffix2", "prefix" + f_I + "suffix1" + sf_iM + "suffix2");
        test("94000000-820130816", "" + f_I + f_lM);
        test("94000000-820130816suffix", "" + f_I + f_lM + "suffix");
        test("prefix94000000suffix1-820130816suffix2", "prefix" + f_I + "suffix1" + f_lM + "suffix2");
        test("94000000null", "" + f_I + sf_oAN);
        test("94000000nullsuffix", "" + f_I + sf_oAN + "suffix");
        test("prefix94000000suffix1nullsuffix2", "prefix" + f_I + "suffix1" + sf_oAN + "suffix2");
        test("9400000025000000", "" + f_I + s_I);
        test("9400000025000000suffix", "" + f_I + s_I + "suffix");
        test("prefix94000000suffix125000000suffix2", "prefix" + f_I + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + f_IN + s_dM);
        test("null-96.0suffix", "" + f_IN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + f_IN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + f_IN + s_oNtS);
        test("nullnullsuffix", "" + f_IN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + f_IN + f_strU);
        test("null\u045176suffix", "" + f_IN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + f_IN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + f_IN + sf_strU2);
        test("null92suffix", "" + f_IN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + f_IN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + f_IN + sf_strU1);
        test("null51suffix", "" + f_IN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + f_IN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + f_IN + s_iAN);
        test("nullnullsuffix", "" + f_IN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + f_IN + f_bM);
        test("null-54suffix", "" + f_IN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + f_IN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + f_IN + f_fM);
        test("null-87.0suffix", "" + f_IN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + f_IN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + f_IN + s_oAN);
        test("nullnullsuffix", "" + f_IN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + f_IN + f_str);
        test("null19suffix", "" + f_IN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + f_IN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + f_IN + sf_bM);
        test("null-41suffix", "" + f_IN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + f_IN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + f_IN + sf_IN);
        test("nullnullsuffix", "" + f_IN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + f_IN + s_c);
        test("nullTsuffix", "" + f_IN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + f_IN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + f_IN + sf_fM);
        test("null-42.0suffix", "" + f_IN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + f_IN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + f_IN + s_b);
        test("null25suffix", "" + f_IN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + f_IN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + f_IN + f_oN);
        test("nullnullsuffix", "" + f_IN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + f_IN + s_lM);
        test("null-1410065408suffix", "" + f_IN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + f_IN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + f_IN + s_d);
        test("null8.0suffix", "" + f_IN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + f_IN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + f_IN + s_f);
        test("null55.0suffix", "" + f_IN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + f_IN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + f_IN + s_i);
        test("null97000000suffix", "" + f_IN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + f_IN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + f_IN + f_sM);
        test("null-9900suffix", "" + f_IN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + f_IN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + f_IN + s_l);
        test("null935228928suffix", "" + f_IN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + f_IN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + f_IN + sf_sM);
        test("null-8400suffix", "" + f_IN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + f_IN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + f_IN + s_o);
        test("nullC(82)suffix", "" + f_IN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + f_IN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + f_IN + sf_oNtS);
        test("nullnullsuffix", "" + f_IN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + f_IN + s_bl);
        test("nulltruesuffix", "" + f_IN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_IN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + f_IN + s_s);
        test("null3900suffix", "" + f_IN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + f_IN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + f_IN + sf_oN);
        test("nullnullsuffix", "" + f_IN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + f_IN + f_I);
        test("null94000000suffix", "" + f_IN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + f_IN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + f_IN + f_IN);
        test("nullnullsuffix", "" + f_IN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + f_IN + sf_bl);
        test("nulltruesuffix", "" + f_IN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_IN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + f_IN + sf_s);
        test("null5500suffix", "" + f_IN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + f_IN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + f_IN + s_sM);
        test("null-2900suffix", "" + f_IN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + f_IN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + f_IN + sf_l);
        test("null-194313216suffix", "" + f_IN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + f_IN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + f_IN + s_strU1);
        test("null12suffix", "" + f_IN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + f_IN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + f_IN + sf_o);
        test("nullC(87)suffix", "" + f_IN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + f_IN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + f_IN + s_strU2);
        test("null91suffix", "" + f_IN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + f_IN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + f_IN + f_strU1);
        test("null21suffix", "" + f_IN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + f_IN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + f_IN + f_strU2);
        test("null18suffix", "" + f_IN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_IN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + f_IN + f_iAN);
        test("nullnullsuffix", "" + f_IN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + f_IN + s_oN);
        test("nullnullsuffix", "" + f_IN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + f_IN + s_strU);
        test("null\u045180suffix", "" + f_IN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + f_IN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + f_IN + sf_c);
        test("nullCsuffix", "" + f_IN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + f_IN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + f_IN + sf_str);
        test("null75suffix", "" + f_IN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + f_IN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + f_IN + s_bM);
        test("null-43suffix", "" + f_IN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + f_IN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + f_IN + sf_b);
        test("null80suffix", "" + f_IN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + f_IN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + f_IN + s_IN);
        test("nullnullsuffix", "" + f_IN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + f_IN + s_fM);
        test("null-52.0suffix", "" + f_IN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + f_IN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + f_IN + sf_i);
        test("null75000000suffix", "" + f_IN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + f_IN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + f_IN + f_b);
        test("null44suffix", "" + f_IN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + f_IN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + f_IN + sf_lM);
        test("null-1705032704suffix", "" + f_IN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + f_IN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + f_IN + f_oAN);
        test("nullnullsuffix", "" + f_IN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + f_IN + f_d);
        test("null83.0suffix", "" + f_IN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + f_IN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + f_IN + f_c);
        test("nullIsuffix", "" + f_IN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + f_IN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + f_IN + f_f);
        test("null94.0suffix", "" + f_IN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + f_IN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + f_IN + sf_d);
        test("null12.0suffix", "" + f_IN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + f_IN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + f_IN + f_dM);
        test("null-99.0suffix", "" + f_IN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + f_IN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + f_IN + sf_f);
        test("null17.0suffix", "" + f_IN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + f_IN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + f_IN + sf_dM);
    }

    public void run7() {
        test("null-84.0suffix", "" + f_IN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + f_IN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + f_IN + f_i);
        test("null58000000suffix", "" + f_IN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + f_IN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + f_IN + f_iM);
        test("null-55000000suffix", "" + f_IN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + f_IN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + f_IN + f_l);
        test("null1460392448suffix", "" + f_IN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + f_IN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + f_IN + f_o);
        test("nullC(70)suffix", "" + f_IN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + f_IN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + f_IN + sf_strU);
        test("null\u04511suffix", "" + f_IN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + f_IN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + f_IN + f_s);
        test("null8000suffix", "" + f_IN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + f_IN + "suffix1" + f_s + "suffix2");
        test("null18", "" + f_IN + s_str);
        test("null18suffix", "" + f_IN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_IN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + f_IN + s_iM);
        test("null-1000000suffix", "" + f_IN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + f_IN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + f_IN + sf_I);
        test("null1000000suffix", "" + f_IN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + f_IN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + f_IN + f_oNtS);
        test("nullnullsuffix", "" + f_IN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + f_IN + f_bl);
        test("nullfalsesuffix", "" + f_IN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + f_IN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + f_IN + sf_iAN);
        test("nullnullsuffix", "" + f_IN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + f_IN + sf_iM);
        test("null-2000000suffix", "" + f_IN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + f_IN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + f_IN + f_lM);
        test("null-820130816suffix", "" + f_IN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + f_IN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + f_IN + sf_oAN);
        test("nullnullsuffix", "" + f_IN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_IN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + f_IN + s_I);
        test("null25000000suffix", "" + f_IN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + f_IN + "suffix1" + s_I + "suffix2");
        test("true-96.0", "" + sf_bl + s_dM);
        test("true-96.0suffix", "" + sf_bl + s_dM + "suffix");
        test("prefixtruesuffix1-96.0suffix2", "prefix" + sf_bl + "suffix1" + s_dM + "suffix2");
        test("truenull", "" + sf_bl + s_oNtS);
        test("truenullsuffix", "" + sf_bl + s_oNtS + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + s_oNtS + "suffix2");
        test("true\u045176", "" + sf_bl + f_strU);
        test("true\u045176suffix", "" + sf_bl + f_strU + "suffix");
        test("prefixtruesuffix1\u045176suffix2", "prefix" + sf_bl + "suffix1" + f_strU + "suffix2");
        test("true92", "" + sf_bl + sf_strU2);
        test("true92suffix", "" + sf_bl + sf_strU2 + "suffix");
        test("prefixtruesuffix192suffix2", "prefix" + sf_bl + "suffix1" + sf_strU2 + "suffix2");
        test("true51", "" + sf_bl + sf_strU1);
        test("true51suffix", "" + sf_bl + sf_strU1 + "suffix");
        test("prefixtruesuffix151suffix2", "prefix" + sf_bl + "suffix1" + sf_strU1 + "suffix2");
        test("truenull", "" + sf_bl + s_iAN);
        test("truenullsuffix", "" + sf_bl + s_iAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + s_iAN + "suffix2");
        test("true-54", "" + sf_bl + f_bM);
        test("true-54suffix", "" + sf_bl + f_bM + "suffix");
        test("prefixtruesuffix1-54suffix2", "prefix" + sf_bl + "suffix1" + f_bM + "suffix2");
        test("true-87.0", "" + sf_bl + f_fM);
        test("true-87.0suffix", "" + sf_bl + f_fM + "suffix");
        test("prefixtruesuffix1-87.0suffix2", "prefix" + sf_bl + "suffix1" + f_fM + "suffix2");
        test("truenull", "" + sf_bl + s_oAN);
        test("truenullsuffix", "" + sf_bl + s_oAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + s_oAN + "suffix2");
        test("true19", "" + sf_bl + f_str);
        test("true19suffix", "" + sf_bl + f_str + "suffix");
        test("prefixtruesuffix119suffix2", "prefix" + sf_bl + "suffix1" + f_str + "suffix2");
        test("true-41", "" + sf_bl + sf_bM);
        test("true-41suffix", "" + sf_bl + sf_bM + "suffix");
        test("prefixtruesuffix1-41suffix2", "prefix" + sf_bl + "suffix1" + sf_bM + "suffix2");
        test("truenull", "" + sf_bl + sf_IN);
        test("truenullsuffix", "" + sf_bl + sf_IN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + sf_IN + "suffix2");
        test("trueT", "" + sf_bl + s_c);
        test("trueTsuffix", "" + sf_bl + s_c + "suffix");
        test("prefixtruesuffix1Tsuffix2", "prefix" + sf_bl + "suffix1" + s_c + "suffix2");
        test("true-42.0", "" + sf_bl + sf_fM);
        test("true-42.0suffix", "" + sf_bl + sf_fM + "suffix");
        test("prefixtruesuffix1-42.0suffix2", "prefix" + sf_bl + "suffix1" + sf_fM + "suffix2");
        test("true25", "" + sf_bl + s_b);
        test("true25suffix", "" + sf_bl + s_b + "suffix");
        test("prefixtruesuffix125suffix2", "prefix" + sf_bl + "suffix1" + s_b + "suffix2");
        test("truenull", "" + sf_bl + f_oN);
        test("truenullsuffix", "" + sf_bl + f_oN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + f_oN + "suffix2");
        test("true-1410065408", "" + sf_bl + s_lM);
        test("true-1410065408suffix", "" + sf_bl + s_lM + "suffix");
        test("prefixtruesuffix1-1410065408suffix2", "prefix" + sf_bl + "suffix1" + s_lM + "suffix2");
        test("true8.0", "" + sf_bl + s_d);
        test("true8.0suffix", "" + sf_bl + s_d + "suffix");
        test("prefixtruesuffix18.0suffix2", "prefix" + sf_bl + "suffix1" + s_d + "suffix2");
        test("true55.0", "" + sf_bl + s_f);
        test("true55.0suffix", "" + sf_bl + s_f + "suffix");
        test("prefixtruesuffix155.0suffix2", "prefix" + sf_bl + "suffix1" + s_f + "suffix2");
        test("true97000000", "" + sf_bl + s_i);
        test("true97000000suffix", "" + sf_bl + s_i + "suffix");
        test("prefixtruesuffix197000000suffix2", "prefix" + sf_bl + "suffix1" + s_i + "suffix2");
        test("true-9900", "" + sf_bl + f_sM);
        test("true-9900suffix", "" + sf_bl + f_sM + "suffix");
        test("prefixtruesuffix1-9900suffix2", "prefix" + sf_bl + "suffix1" + f_sM + "suffix2");
        test("true935228928", "" + sf_bl + s_l);
        test("true935228928suffix", "" + sf_bl + s_l + "suffix");
        test("prefixtruesuffix1935228928suffix2", "prefix" + sf_bl + "suffix1" + s_l + "suffix2");
        test("true-8400", "" + sf_bl + sf_sM);
        test("true-8400suffix", "" + sf_bl + sf_sM + "suffix");
        test("prefixtruesuffix1-8400suffix2", "prefix" + sf_bl + "suffix1" + sf_sM + "suffix2");
        test("trueC(82)", "" + sf_bl + s_o);
        test("trueC(82)suffix", "" + sf_bl + s_o + "suffix");
        test("prefixtruesuffix1C(82)suffix2", "prefix" + sf_bl + "suffix1" + s_o + "suffix2");
        test("truenull", "" + sf_bl + sf_oNtS);
        test("truenullsuffix", "" + sf_bl + sf_oNtS + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + sf_oNtS + "suffix2");
        test("truetrue", "" + sf_bl + s_bl);
        test("truetruesuffix", "" + sf_bl + s_bl + "suffix");
        test("prefixtruesuffix1truesuffix2", "prefix" + sf_bl + "suffix1" + s_bl + "suffix2");
        test("true3900", "" + sf_bl + s_s);
        test("true3900suffix", "" + sf_bl + s_s + "suffix");
        test("prefixtruesuffix13900suffix2", "prefix" + sf_bl + "suffix1" + s_s + "suffix2");
        test("truenull", "" + sf_bl + sf_oN);
        test("truenullsuffix", "" + sf_bl + sf_oN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + sf_oN + "suffix2");
        test("true94000000", "" + sf_bl + f_I);
        test("true94000000suffix", "" + sf_bl + f_I + "suffix");
        test("prefixtruesuffix194000000suffix2", "prefix" + sf_bl + "suffix1" + f_I + "suffix2");
        test("truenull", "" + sf_bl + f_IN);
        test("truenullsuffix", "" + sf_bl + f_IN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + f_IN + "suffix2");
        test("truetrue", "" + sf_bl + sf_bl);
        test("truetruesuffix", "" + sf_bl + sf_bl + "suffix");
        test("prefixtruesuffix1truesuffix2", "prefix" + sf_bl + "suffix1" + sf_bl + "suffix2");
        test("true5500", "" + sf_bl + sf_s);
        test("true5500suffix", "" + sf_bl + sf_s + "suffix");
        test("prefixtruesuffix15500suffix2", "prefix" + sf_bl + "suffix1" + sf_s + "suffix2");
        test("true-2900", "" + sf_bl + s_sM);
        test("true-2900suffix", "" + sf_bl + s_sM + "suffix");
        test("prefixtruesuffix1-2900suffix2", "prefix" + sf_bl + "suffix1" + s_sM + "suffix2");
        test("true-194313216", "" + sf_bl + sf_l);
        test("true-194313216suffix", "" + sf_bl + sf_l + "suffix");
        test("prefixtruesuffix1-194313216suffix2", "prefix" + sf_bl + "suffix1" + sf_l + "suffix2");
        test("true12", "" + sf_bl + s_strU1);
        test("true12suffix", "" + sf_bl + s_strU1 + "suffix");
        test("prefixtruesuffix112suffix2", "prefix" + sf_bl + "suffix1" + s_strU1 + "suffix2");
        test("trueC(87)", "" + sf_bl + sf_o);
        test("trueC(87)suffix", "" + sf_bl + sf_o + "suffix");
        test("prefixtruesuffix1C(87)suffix2", "prefix" + sf_bl + "suffix1" + sf_o + "suffix2");
        test("true91", "" + sf_bl + s_strU2);
        test("true91suffix", "" + sf_bl + s_strU2 + "suffix");
        test("prefixtruesuffix191suffix2", "prefix" + sf_bl + "suffix1" + s_strU2 + "suffix2");
        test("true21", "" + sf_bl + f_strU1);
        test("true21suffix", "" + sf_bl + f_strU1 + "suffix");
        test("prefixtruesuffix121suffix2", "prefix" + sf_bl + "suffix1" + f_strU1 + "suffix2");
        test("true18", "" + sf_bl + f_strU2);
        test("true18suffix", "" + sf_bl + f_strU2 + "suffix");
        test("prefixtruesuffix118suffix2", "prefix" + sf_bl + "suffix1" + f_strU2 + "suffix2");
        test("truenull", "" + sf_bl + f_iAN);
        test("truenullsuffix", "" + sf_bl + f_iAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + f_iAN + "suffix2");
        test("truenull", "" + sf_bl + s_oN);
        test("truenullsuffix", "" + sf_bl + s_oN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + s_oN + "suffix2");
        test("true\u045180", "" + sf_bl + s_strU);
        test("true\u045180suffix", "" + sf_bl + s_strU + "suffix");
        test("prefixtruesuffix1\u045180suffix2", "prefix" + sf_bl + "suffix1" + s_strU + "suffix2");
        test("trueC", "" + sf_bl + sf_c);
        test("trueCsuffix", "" + sf_bl + sf_c + "suffix");
        test("prefixtruesuffix1Csuffix2", "prefix" + sf_bl + "suffix1" + sf_c + "suffix2");
        test("true75", "" + sf_bl + sf_str);
        test("true75suffix", "" + sf_bl + sf_str + "suffix");
        test("prefixtruesuffix175suffix2", "prefix" + sf_bl + "suffix1" + sf_str + "suffix2");
        test("true-43", "" + sf_bl + s_bM);
        test("true-43suffix", "" + sf_bl + s_bM + "suffix");
        test("prefixtruesuffix1-43suffix2", "prefix" + sf_bl + "suffix1" + s_bM + "suffix2");
        test("true80", "" + sf_bl + sf_b);
        test("true80suffix", "" + sf_bl + sf_b + "suffix");
        test("prefixtruesuffix180suffix2", "prefix" + sf_bl + "suffix1" + sf_b + "suffix2");
        test("truenull", "" + sf_bl + s_IN);
        test("truenullsuffix", "" + sf_bl + s_IN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + s_IN + "suffix2");
        test("true-52.0", "" + sf_bl + s_fM);
        test("true-52.0suffix", "" + sf_bl + s_fM + "suffix");
        test("prefixtruesuffix1-52.0suffix2", "prefix" + sf_bl + "suffix1" + s_fM + "suffix2");
        test("true75000000", "" + sf_bl + sf_i);
        test("true75000000suffix", "" + sf_bl + sf_i + "suffix");
        test("prefixtruesuffix175000000suffix2", "prefix" + sf_bl + "suffix1" + sf_i + "suffix2");
        test("true44", "" + sf_bl + f_b);
        test("true44suffix", "" + sf_bl + f_b + "suffix");
        test("prefixtruesuffix144suffix2", "prefix" + sf_bl + "suffix1" + f_b + "suffix2");
        test("true-1705032704", "" + sf_bl + sf_lM);
        test("true-1705032704suffix", "" + sf_bl + sf_lM + "suffix");
        test("prefixtruesuffix1-1705032704suffix2", "prefix" + sf_bl + "suffix1" + sf_lM + "suffix2");
        test("truenull", "" + sf_bl + f_oAN);
        test("truenullsuffix", "" + sf_bl + f_oAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + f_oAN + "suffix2");
        test("true83.0", "" + sf_bl + f_d);
        test("true83.0suffix", "" + sf_bl + f_d + "suffix");
        test("prefixtruesuffix183.0suffix2", "prefix" + sf_bl + "suffix1" + f_d + "suffix2");
        test("trueI", "" + sf_bl + f_c);
        test("trueIsuffix", "" + sf_bl + f_c + "suffix");
        test("prefixtruesuffix1Isuffix2", "prefix" + sf_bl + "suffix1" + f_c + "suffix2");
        test("true94.0", "" + sf_bl + f_f);
        test("true94.0suffix", "" + sf_bl + f_f + "suffix");
        test("prefixtruesuffix194.0suffix2", "prefix" + sf_bl + "suffix1" + f_f + "suffix2");
        test("true12.0", "" + sf_bl + sf_d);
        test("true12.0suffix", "" + sf_bl + sf_d + "suffix");
        test("prefixtruesuffix112.0suffix2", "prefix" + sf_bl + "suffix1" + sf_d + "suffix2");
        test("true-99.0", "" + sf_bl + f_dM);
        test("true-99.0suffix", "" + sf_bl + f_dM + "suffix");
        test("prefixtruesuffix1-99.0suffix2", "prefix" + sf_bl + "suffix1" + f_dM + "suffix2");
        test("true17.0", "" + sf_bl + sf_f);
        test("true17.0suffix", "" + sf_bl + sf_f + "suffix");
        test("prefixtruesuffix117.0suffix2", "prefix" + sf_bl + "suffix1" + sf_f + "suffix2");
        test("true-84.0", "" + sf_bl + sf_dM);
        test("true-84.0suffix", "" + sf_bl + sf_dM + "suffix");
        test("prefixtruesuffix1-84.0suffix2", "prefix" + sf_bl + "suffix1" + sf_dM + "suffix2");
        test("true58000000", "" + sf_bl + f_i);
        test("true58000000suffix", "" + sf_bl + f_i + "suffix");
        test("prefixtruesuffix158000000suffix2", "prefix" + sf_bl + "suffix1" + f_i + "suffix2");
        test("true-55000000", "" + sf_bl + f_iM);
        test("true-55000000suffix", "" + sf_bl + f_iM + "suffix");
        test("prefixtruesuffix1-55000000suffix2", "prefix" + sf_bl + "suffix1" + f_iM + "suffix2");
        test("true1460392448", "" + sf_bl + f_l);
        test("true1460392448suffix", "" + sf_bl + f_l + "suffix");
        test("prefixtruesuffix11460392448suffix2", "prefix" + sf_bl + "suffix1" + f_l + "suffix2");
        test("trueC(70)", "" + sf_bl + f_o);
        test("trueC(70)suffix", "" + sf_bl + f_o + "suffix");
        test("prefixtruesuffix1C(70)suffix2", "prefix" + sf_bl + "suffix1" + f_o + "suffix2");
        test("true\u04511", "" + sf_bl + sf_strU);
        test("true\u04511suffix", "" + sf_bl + sf_strU + "suffix");
        test("prefixtruesuffix1\u04511suffix2", "prefix" + sf_bl + "suffix1" + sf_strU + "suffix2");
        test("true8000", "" + sf_bl + f_s);
        test("true8000suffix", "" + sf_bl + f_s + "suffix");
        test("prefixtruesuffix18000suffix2", "prefix" + sf_bl + "suffix1" + f_s + "suffix2");
        test("true18", "" + sf_bl + s_str);
        test("true18suffix", "" + sf_bl + s_str + "suffix");
        test("prefixtruesuffix118suffix2", "prefix" + sf_bl + "suffix1" + s_str + "suffix2");
        test("true-1000000", "" + sf_bl + s_iM);
        test("true-1000000suffix", "" + sf_bl + s_iM + "suffix");
        test("prefixtruesuffix1-1000000suffix2", "prefix" + sf_bl + "suffix1" + s_iM + "suffix2");
        test("true1000000", "" + sf_bl + sf_I);
        test("true1000000suffix", "" + sf_bl + sf_I + "suffix");
        test("prefixtruesuffix11000000suffix2", "prefix" + sf_bl + "suffix1" + sf_I + "suffix2");
        test("truenull", "" + sf_bl + f_oNtS);
        test("truenullsuffix", "" + sf_bl + f_oNtS + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + f_oNtS + "suffix2");
        test("truefalse", "" + sf_bl + f_bl);
        test("truefalsesuffix", "" + sf_bl + f_bl + "suffix");
        test("prefixtruesuffix1falsesuffix2", "prefix" + sf_bl + "suffix1" + f_bl + "suffix2");
        test("truenull", "" + sf_bl + sf_iAN);
        test("truenullsuffix", "" + sf_bl + sf_iAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + sf_iAN + "suffix2");
        test("true-2000000", "" + sf_bl + sf_iM);
        test("true-2000000suffix", "" + sf_bl + sf_iM + "suffix");
        test("prefixtruesuffix1-2000000suffix2", "prefix" + sf_bl + "suffix1" + sf_iM + "suffix2");
        test("true-820130816", "" + sf_bl + f_lM);
        test("true-820130816suffix", "" + sf_bl + f_lM + "suffix");
        test("prefixtruesuffix1-820130816suffix2", "prefix" + sf_bl + "suffix1" + f_lM + "suffix2");
        test("truenull", "" + sf_bl + sf_oAN);
        test("truenullsuffix", "" + sf_bl + sf_oAN + "suffix");
        test("prefixtruesuffix1nullsuffix2", "prefix" + sf_bl + "suffix1" + sf_oAN + "suffix2");
        test("true25000000", "" + sf_bl + s_I);
        test("true25000000suffix", "" + sf_bl + s_I + "suffix");
        test("prefixtruesuffix125000000suffix2", "prefix" + sf_bl + "suffix1" + s_I + "suffix2");
        test("5500-96.0", "" + sf_s + s_dM);
        test("5500-96.0suffix", "" + sf_s + s_dM + "suffix");
        test("prefix5500suffix1-96.0suffix2", "prefix" + sf_s + "suffix1" + s_dM + "suffix2");
        test("5500null", "" + sf_s + s_oNtS);
        test("5500nullsuffix", "" + sf_s + s_oNtS + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + s_oNtS + "suffix2");
        test("5500\u045176", "" + sf_s + f_strU);
        test("5500\u045176suffix", "" + sf_s + f_strU + "suffix");
        test("prefix5500suffix1\u045176suffix2", "prefix" + sf_s + "suffix1" + f_strU + "suffix2");
        test("550092", "" + sf_s + sf_strU2);
        test("550092suffix", "" + sf_s + sf_strU2 + "suffix");
        test("prefix5500suffix192suffix2", "prefix" + sf_s + "suffix1" + sf_strU2 + "suffix2");
        test("550051", "" + sf_s + sf_strU1);
        test("550051suffix", "" + sf_s + sf_strU1 + "suffix");
        test("prefix5500suffix151suffix2", "prefix" + sf_s + "suffix1" + sf_strU1 + "suffix2");
        test("5500null", "" + sf_s + s_iAN);
        test("5500nullsuffix", "" + sf_s + s_iAN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + s_iAN + "suffix2");
        test("5500-54", "" + sf_s + f_bM);
        test("5500-54suffix", "" + sf_s + f_bM + "suffix");
        test("prefix5500suffix1-54suffix2", "prefix" + sf_s + "suffix1" + f_bM + "suffix2");
        test("5500-87.0", "" + sf_s + f_fM);
        test("5500-87.0suffix", "" + sf_s + f_fM + "suffix");
        test("prefix5500suffix1-87.0suffix2", "prefix" + sf_s + "suffix1" + f_fM + "suffix2");
        test("5500null", "" + sf_s + s_oAN);
        test("5500nullsuffix", "" + sf_s + s_oAN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + s_oAN + "suffix2");
        test("550019", "" + sf_s + f_str);
        test("550019suffix", "" + sf_s + f_str + "suffix");
        test("prefix5500suffix119suffix2", "prefix" + sf_s + "suffix1" + f_str + "suffix2");
        test("5500-41", "" + sf_s + sf_bM);
        test("5500-41suffix", "" + sf_s + sf_bM + "suffix");
        test("prefix5500suffix1-41suffix2", "prefix" + sf_s + "suffix1" + sf_bM + "suffix2");
        test("5500null", "" + sf_s + sf_IN);
        test("5500nullsuffix", "" + sf_s + sf_IN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + sf_IN + "suffix2");
        test("5500T", "" + sf_s + s_c);
        test("5500Tsuffix", "" + sf_s + s_c + "suffix");
        test("prefix5500suffix1Tsuffix2", "prefix" + sf_s + "suffix1" + s_c + "suffix2");
        test("5500-42.0", "" + sf_s + sf_fM);
        test("5500-42.0suffix", "" + sf_s + sf_fM + "suffix");
        test("prefix5500suffix1-42.0suffix2", "prefix" + sf_s + "suffix1" + sf_fM + "suffix2");
        test("550025", "" + sf_s + s_b);
        test("550025suffix", "" + sf_s + s_b + "suffix");
        test("prefix5500suffix125suffix2", "prefix" + sf_s + "suffix1" + s_b + "suffix2");
        test("5500null", "" + sf_s + f_oN);
        test("5500nullsuffix", "" + sf_s + f_oN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + f_oN + "suffix2");
        test("5500-1410065408", "" + sf_s + s_lM);
        test("5500-1410065408suffix", "" + sf_s + s_lM + "suffix");
        test("prefix5500suffix1-1410065408suffix2", "prefix" + sf_s + "suffix1" + s_lM + "suffix2");
        test("55008.0", "" + sf_s + s_d);
        test("55008.0suffix", "" + sf_s + s_d + "suffix");
        test("prefix5500suffix18.0suffix2", "prefix" + sf_s + "suffix1" + s_d + "suffix2");
        test("550055.0", "" + sf_s + s_f);
        test("550055.0suffix", "" + sf_s + s_f + "suffix");
        test("prefix5500suffix155.0suffix2", "prefix" + sf_s + "suffix1" + s_f + "suffix2");
        test("550097000000", "" + sf_s + s_i);
        test("550097000000suffix", "" + sf_s + s_i + "suffix");
        test("prefix5500suffix197000000suffix2", "prefix" + sf_s + "suffix1" + s_i + "suffix2");
        test("5500-9900", "" + sf_s + f_sM);
        test("5500-9900suffix", "" + sf_s + f_sM + "suffix");
        test("prefix5500suffix1-9900suffix2", "prefix" + sf_s + "suffix1" + f_sM + "suffix2");
        test("5500935228928", "" + sf_s + s_l);
        test("5500935228928suffix", "" + sf_s + s_l + "suffix");
        test("prefix5500suffix1935228928suffix2", "prefix" + sf_s + "suffix1" + s_l + "suffix2");
        test("5500-8400", "" + sf_s + sf_sM);
        test("5500-8400suffix", "" + sf_s + sf_sM + "suffix");
        test("prefix5500suffix1-8400suffix2", "prefix" + sf_s + "suffix1" + sf_sM + "suffix2");
        test("5500C(82)", "" + sf_s + s_o);
        test("5500C(82)suffix", "" + sf_s + s_o + "suffix");
        test("prefix5500suffix1C(82)suffix2", "prefix" + sf_s + "suffix1" + s_o + "suffix2");
        test("5500null", "" + sf_s + sf_oNtS);
        test("5500nullsuffix", "" + sf_s + sf_oNtS + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + sf_oNtS + "suffix2");
        test("5500true", "" + sf_s + s_bl);
        test("5500truesuffix", "" + sf_s + s_bl + "suffix");
        test("prefix5500suffix1truesuffix2", "prefix" + sf_s + "suffix1" + s_bl + "suffix2");
        test("55003900", "" + sf_s + s_s);
        test("55003900suffix", "" + sf_s + s_s + "suffix");
        test("prefix5500suffix13900suffix2", "prefix" + sf_s + "suffix1" + s_s + "suffix2");
        test("5500null", "" + sf_s + sf_oN);
        test("5500nullsuffix", "" + sf_s + sf_oN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + sf_oN + "suffix2");
        test("550094000000", "" + sf_s + f_I);
        test("550094000000suffix", "" + sf_s + f_I + "suffix");
        test("prefix5500suffix194000000suffix2", "prefix" + sf_s + "suffix1" + f_I + "suffix2");
        test("5500null", "" + sf_s + f_IN);
        test("5500nullsuffix", "" + sf_s + f_IN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + f_IN + "suffix2");
        test("5500true", "" + sf_s + sf_bl);
        test("5500truesuffix", "" + sf_s + sf_bl + "suffix");
        test("prefix5500suffix1truesuffix2", "prefix" + sf_s + "suffix1" + sf_bl + "suffix2");
        test("55005500", "" + sf_s + sf_s);
        test("55005500suffix", "" + sf_s + sf_s + "suffix");
        test("prefix5500suffix15500suffix2", "prefix" + sf_s + "suffix1" + sf_s + "suffix2");
        test("5500-2900", "" + sf_s + s_sM);
        test("5500-2900suffix", "" + sf_s + s_sM + "suffix");
        test("prefix5500suffix1-2900suffix2", "prefix" + sf_s + "suffix1" + s_sM + "suffix2");
        test("5500-194313216", "" + sf_s + sf_l);
        test("5500-194313216suffix", "" + sf_s + sf_l + "suffix");
        test("prefix5500suffix1-194313216suffix2", "prefix" + sf_s + "suffix1" + sf_l + "suffix2");
        test("550012", "" + sf_s + s_strU1);
        test("550012suffix", "" + sf_s + s_strU1 + "suffix");
        test("prefix5500suffix112suffix2", "prefix" + sf_s + "suffix1" + s_strU1 + "suffix2");
        test("5500C(87)", "" + sf_s + sf_o);
        test("5500C(87)suffix", "" + sf_s + sf_o + "suffix");
        test("prefix5500suffix1C(87)suffix2", "prefix" + sf_s + "suffix1" + sf_o + "suffix2");
        test("550091", "" + sf_s + s_strU2);
        test("550091suffix", "" + sf_s + s_strU2 + "suffix");
        test("prefix5500suffix191suffix2", "prefix" + sf_s + "suffix1" + s_strU2 + "suffix2");
        test("550021", "" + sf_s + f_strU1);
        test("550021suffix", "" + sf_s + f_strU1 + "suffix");
        test("prefix5500suffix121suffix2", "prefix" + sf_s + "suffix1" + f_strU1 + "suffix2");
        test("550018", "" + sf_s + f_strU2);
        test("550018suffix", "" + sf_s + f_strU2 + "suffix");
        test("prefix5500suffix118suffix2", "prefix" + sf_s + "suffix1" + f_strU2 + "suffix2");
        test("5500null", "" + sf_s + f_iAN);
        test("5500nullsuffix", "" + sf_s + f_iAN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + f_iAN + "suffix2");
        test("5500null", "" + sf_s + s_oN);
        test("5500nullsuffix", "" + sf_s + s_oN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + s_oN + "suffix2");
        test("5500\u045180", "" + sf_s + s_strU);
        test("5500\u045180suffix", "" + sf_s + s_strU + "suffix");
        test("prefix5500suffix1\u045180suffix2", "prefix" + sf_s + "suffix1" + s_strU + "suffix2");
        test("5500C", "" + sf_s + sf_c);
        test("5500Csuffix", "" + sf_s + sf_c + "suffix");
        test("prefix5500suffix1Csuffix2", "prefix" + sf_s + "suffix1" + sf_c + "suffix2");
        test("550075", "" + sf_s + sf_str);
        test("550075suffix", "" + sf_s + sf_str + "suffix");
        test("prefix5500suffix175suffix2", "prefix" + sf_s + "suffix1" + sf_str + "suffix2");
        test("5500-43", "" + sf_s + s_bM);
        test("5500-43suffix", "" + sf_s + s_bM + "suffix");
        test("prefix5500suffix1-43suffix2", "prefix" + sf_s + "suffix1" + s_bM + "suffix2");
        test("550080", "" + sf_s + sf_b);
        test("550080suffix", "" + sf_s + sf_b + "suffix");
        test("prefix5500suffix180suffix2", "prefix" + sf_s + "suffix1" + sf_b + "suffix2");
        test("5500null", "" + sf_s + s_IN);
        test("5500nullsuffix", "" + sf_s + s_IN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + s_IN + "suffix2");
        test("5500-52.0", "" + sf_s + s_fM);
        test("5500-52.0suffix", "" + sf_s + s_fM + "suffix");
        test("prefix5500suffix1-52.0suffix2", "prefix" + sf_s + "suffix1" + s_fM + "suffix2");
        test("550075000000", "" + sf_s + sf_i);
        test("550075000000suffix", "" + sf_s + sf_i + "suffix");
        test("prefix5500suffix175000000suffix2", "prefix" + sf_s + "suffix1" + sf_i + "suffix2");
        test("550044", "" + sf_s + f_b);
        test("550044suffix", "" + sf_s + f_b + "suffix");
        test("prefix5500suffix144suffix2", "prefix" + sf_s + "suffix1" + f_b + "suffix2");
        test("5500-1705032704", "" + sf_s + sf_lM);
        test("5500-1705032704suffix", "" + sf_s + sf_lM + "suffix");
        test("prefix5500suffix1-1705032704suffix2", "prefix" + sf_s + "suffix1" + sf_lM + "suffix2");
        test("5500null", "" + sf_s + f_oAN);
        test("5500nullsuffix", "" + sf_s + f_oAN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + f_oAN + "suffix2");
        test("550083.0", "" + sf_s + f_d);
        test("550083.0suffix", "" + sf_s + f_d + "suffix");
        test("prefix5500suffix183.0suffix2", "prefix" + sf_s + "suffix1" + f_d + "suffix2");
        test("5500I", "" + sf_s + f_c);
        test("5500Isuffix", "" + sf_s + f_c + "suffix");
        test("prefix5500suffix1Isuffix2", "prefix" + sf_s + "suffix1" + f_c + "suffix2");
        test("550094.0", "" + sf_s + f_f);
        test("550094.0suffix", "" + sf_s + f_f + "suffix");
        test("prefix5500suffix194.0suffix2", "prefix" + sf_s + "suffix1" + f_f + "suffix2");
        test("550012.0", "" + sf_s + sf_d);
        test("550012.0suffix", "" + sf_s + sf_d + "suffix");
        test("prefix5500suffix112.0suffix2", "prefix" + sf_s + "suffix1" + sf_d + "suffix2");
        test("5500-99.0", "" + sf_s + f_dM);
        test("5500-99.0suffix", "" + sf_s + f_dM + "suffix");
        test("prefix5500suffix1-99.0suffix2", "prefix" + sf_s + "suffix1" + f_dM + "suffix2");
        test("550017.0", "" + sf_s + sf_f);
        test("550017.0suffix", "" + sf_s + sf_f + "suffix");
        test("prefix5500suffix117.0suffix2", "prefix" + sf_s + "suffix1" + sf_f + "suffix2");
        test("5500-84.0", "" + sf_s + sf_dM);
        test("5500-84.0suffix", "" + sf_s + sf_dM + "suffix");
        test("prefix5500suffix1-84.0suffix2", "prefix" + sf_s + "suffix1" + sf_dM + "suffix2");
        test("550058000000", "" + sf_s + f_i);
        test("550058000000suffix", "" + sf_s + f_i + "suffix");
        test("prefix5500suffix158000000suffix2", "prefix" + sf_s + "suffix1" + f_i + "suffix2");
        test("5500-55000000", "" + sf_s + f_iM);
        test("5500-55000000suffix", "" + sf_s + f_iM + "suffix");
        test("prefix5500suffix1-55000000suffix2", "prefix" + sf_s + "suffix1" + f_iM + "suffix2");
        test("55001460392448", "" + sf_s + f_l);
        test("55001460392448suffix", "" + sf_s + f_l + "suffix");
        test("prefix5500suffix11460392448suffix2", "prefix" + sf_s + "suffix1" + f_l + "suffix2");
        test("5500C(70)", "" + sf_s + f_o);
        test("5500C(70)suffix", "" + sf_s + f_o + "suffix");
        test("prefix5500suffix1C(70)suffix2", "prefix" + sf_s + "suffix1" + f_o + "suffix2");
        test("5500\u04511", "" + sf_s + sf_strU);
        test("5500\u04511suffix", "" + sf_s + sf_strU + "suffix");
        test("prefix5500suffix1\u04511suffix2", "prefix" + sf_s + "suffix1" + sf_strU + "suffix2");
        test("55008000", "" + sf_s + f_s);
        test("55008000suffix", "" + sf_s + f_s + "suffix");
        test("prefix5500suffix18000suffix2", "prefix" + sf_s + "suffix1" + f_s + "suffix2");
        test("550018", "" + sf_s + s_str);
        test("550018suffix", "" + sf_s + s_str + "suffix");
        test("prefix5500suffix118suffix2", "prefix" + sf_s + "suffix1" + s_str + "suffix2");
        test("5500-1000000", "" + sf_s + s_iM);
        test("5500-1000000suffix", "" + sf_s + s_iM + "suffix");
        test("prefix5500suffix1-1000000suffix2", "prefix" + sf_s + "suffix1" + s_iM + "suffix2");
        test("55001000000", "" + sf_s + sf_I);
        test("55001000000suffix", "" + sf_s + sf_I + "suffix");
        test("prefix5500suffix11000000suffix2", "prefix" + sf_s + "suffix1" + sf_I + "suffix2");
        test("5500null", "" + sf_s + f_oNtS);
        test("5500nullsuffix", "" + sf_s + f_oNtS + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + f_oNtS + "suffix2");
        test("5500false", "" + sf_s + f_bl);
        test("5500falsesuffix", "" + sf_s + f_bl + "suffix");
        test("prefix5500suffix1falsesuffix2", "prefix" + sf_s + "suffix1" + f_bl + "suffix2");
        test("5500null", "" + sf_s + sf_iAN);
        test("5500nullsuffix", "" + sf_s + sf_iAN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + sf_iAN + "suffix2");
        test("5500-2000000", "" + sf_s + sf_iM);
        test("5500-2000000suffix", "" + sf_s + sf_iM + "suffix");
        test("prefix5500suffix1-2000000suffix2", "prefix" + sf_s + "suffix1" + sf_iM + "suffix2");
        test("5500-820130816", "" + sf_s + f_lM);
        test("5500-820130816suffix", "" + sf_s + f_lM + "suffix");
        test("prefix5500suffix1-820130816suffix2", "prefix" + sf_s + "suffix1" + f_lM + "suffix2");
        test("5500null", "" + sf_s + sf_oAN);
        test("5500nullsuffix", "" + sf_s + sf_oAN + "suffix");
        test("prefix5500suffix1nullsuffix2", "prefix" + sf_s + "suffix1" + sf_oAN + "suffix2");
        test("550025000000", "" + sf_s + s_I);
        test("550025000000suffix", "" + sf_s + s_I + "suffix");
        test("prefix5500suffix125000000suffix2", "prefix" + sf_s + "suffix1" + s_I + "suffix2");
        test("-2900-96.0", "" + s_sM + s_dM);
        test("-2900-96.0suffix", "" + s_sM + s_dM + "suffix");
        test("prefix-2900suffix1-96.0suffix2", "prefix" + s_sM + "suffix1" + s_dM + "suffix2");
        test("-2900null", "" + s_sM + s_oNtS);
        test("-2900nullsuffix", "" + s_sM + s_oNtS + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + s_oNtS + "suffix2");
        test("-2900\u045176", "" + s_sM + f_strU);
        test("-2900\u045176suffix", "" + s_sM + f_strU + "suffix");
        test("prefix-2900suffix1\u045176suffix2", "prefix" + s_sM + "suffix1" + f_strU + "suffix2");
        test("-290092", "" + s_sM + sf_strU2);
        test("-290092suffix", "" + s_sM + sf_strU2 + "suffix");
        test("prefix-2900suffix192suffix2", "prefix" + s_sM + "suffix1" + sf_strU2 + "suffix2");
        test("-290051", "" + s_sM + sf_strU1);
        test("-290051suffix", "" + s_sM + sf_strU1 + "suffix");
        test("prefix-2900suffix151suffix2", "prefix" + s_sM + "suffix1" + sf_strU1 + "suffix2");
        test("-2900null", "" + s_sM + s_iAN);
        test("-2900nullsuffix", "" + s_sM + s_iAN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + s_iAN + "suffix2");
        test("-2900-54", "" + s_sM + f_bM);
        test("-2900-54suffix", "" + s_sM + f_bM + "suffix");
        test("prefix-2900suffix1-54suffix2", "prefix" + s_sM + "suffix1" + f_bM + "suffix2");
        test("-2900-87.0", "" + s_sM + f_fM);
        test("-2900-87.0suffix", "" + s_sM + f_fM + "suffix");
        test("prefix-2900suffix1-87.0suffix2", "prefix" + s_sM + "suffix1" + f_fM + "suffix2");
        test("-2900null", "" + s_sM + s_oAN);
        test("-2900nullsuffix", "" + s_sM + s_oAN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + s_oAN + "suffix2");
        test("-290019", "" + s_sM + f_str);
        test("-290019suffix", "" + s_sM + f_str + "suffix");
        test("prefix-2900suffix119suffix2", "prefix" + s_sM + "suffix1" + f_str + "suffix2");
        test("-2900-41", "" + s_sM + sf_bM);
        test("-2900-41suffix", "" + s_sM + sf_bM + "suffix");
        test("prefix-2900suffix1-41suffix2", "prefix" + s_sM + "suffix1" + sf_bM + "suffix2");
        test("-2900null", "" + s_sM + sf_IN);
        test("-2900nullsuffix", "" + s_sM + sf_IN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + sf_IN + "suffix2");
        test("-2900T", "" + s_sM + s_c);
        test("-2900Tsuffix", "" + s_sM + s_c + "suffix");
        test("prefix-2900suffix1Tsuffix2", "prefix" + s_sM + "suffix1" + s_c + "suffix2");
        test("-2900-42.0", "" + s_sM + sf_fM);
        test("-2900-42.0suffix", "" + s_sM + sf_fM + "suffix");
        test("prefix-2900suffix1-42.0suffix2", "prefix" + s_sM + "suffix1" + sf_fM + "suffix2");
        test("-290025", "" + s_sM + s_b);
        test("-290025suffix", "" + s_sM + s_b + "suffix");
        test("prefix-2900suffix125suffix2", "prefix" + s_sM + "suffix1" + s_b + "suffix2");
        test("-2900null", "" + s_sM + f_oN);
        test("-2900nullsuffix", "" + s_sM + f_oN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + f_oN + "suffix2");
        test("-2900-1410065408", "" + s_sM + s_lM);
        test("-2900-1410065408suffix", "" + s_sM + s_lM + "suffix");
        test("prefix-2900suffix1-1410065408suffix2", "prefix" + s_sM + "suffix1" + s_lM + "suffix2");
        test("-29008.0", "" + s_sM + s_d);
        test("-29008.0suffix", "" + s_sM + s_d + "suffix");
        test("prefix-2900suffix18.0suffix2", "prefix" + s_sM + "suffix1" + s_d + "suffix2");
        test("-290055.0", "" + s_sM + s_f);
        test("-290055.0suffix", "" + s_sM + s_f + "suffix");
        test("prefix-2900suffix155.0suffix2", "prefix" + s_sM + "suffix1" + s_f + "suffix2");
        test("-290097000000", "" + s_sM + s_i);
        test("-290097000000suffix", "" + s_sM + s_i + "suffix");
        test("prefix-2900suffix197000000suffix2", "prefix" + s_sM + "suffix1" + s_i + "suffix2");
        test("-2900-9900", "" + s_sM + f_sM);
        test("-2900-9900suffix", "" + s_sM + f_sM + "suffix");
        test("prefix-2900suffix1-9900suffix2", "prefix" + s_sM + "suffix1" + f_sM + "suffix2");
        test("-2900935228928", "" + s_sM + s_l);
        test("-2900935228928suffix", "" + s_sM + s_l + "suffix");
        test("prefix-2900suffix1935228928suffix2", "prefix" + s_sM + "suffix1" + s_l + "suffix2");
        test("-2900-8400", "" + s_sM + sf_sM);
        test("-2900-8400suffix", "" + s_sM + sf_sM + "suffix");
        test("prefix-2900suffix1-8400suffix2", "prefix" + s_sM + "suffix1" + sf_sM + "suffix2");
        test("-2900C(82)", "" + s_sM + s_o);
        test("-2900C(82)suffix", "" + s_sM + s_o + "suffix");
        test("prefix-2900suffix1C(82)suffix2", "prefix" + s_sM + "suffix1" + s_o + "suffix2");
        test("-2900null", "" + s_sM + sf_oNtS);
        test("-2900nullsuffix", "" + s_sM + sf_oNtS + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + sf_oNtS + "suffix2");
        test("-2900true", "" + s_sM + s_bl);
        test("-2900truesuffix", "" + s_sM + s_bl + "suffix");
        test("prefix-2900suffix1truesuffix2", "prefix" + s_sM + "suffix1" + s_bl + "suffix2");
        test("-29003900", "" + s_sM + s_s);
        test("-29003900suffix", "" + s_sM + s_s + "suffix");
        test("prefix-2900suffix13900suffix2", "prefix" + s_sM + "suffix1" + s_s + "suffix2");
        test("-2900null", "" + s_sM + sf_oN);
        test("-2900nullsuffix", "" + s_sM + sf_oN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + sf_oN + "suffix2");
        test("-290094000000", "" + s_sM + f_I);
        test("-290094000000suffix", "" + s_sM + f_I + "suffix");
        test("prefix-2900suffix194000000suffix2", "prefix" + s_sM + "suffix1" + f_I + "suffix2");
        test("-2900null", "" + s_sM + f_IN);
        test("-2900nullsuffix", "" + s_sM + f_IN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + f_IN + "suffix2");
        test("-2900true", "" + s_sM + sf_bl);
        test("-2900truesuffix", "" + s_sM + sf_bl + "suffix");
        test("prefix-2900suffix1truesuffix2", "prefix" + s_sM + "suffix1" + sf_bl + "suffix2");
        test("-29005500", "" + s_sM + sf_s);
        test("-29005500suffix", "" + s_sM + sf_s + "suffix");
        test("prefix-2900suffix15500suffix2", "prefix" + s_sM + "suffix1" + sf_s + "suffix2");
        test("-2900-2900", "" + s_sM + s_sM);
        test("-2900-2900suffix", "" + s_sM + s_sM + "suffix");
        test("prefix-2900suffix1-2900suffix2", "prefix" + s_sM + "suffix1" + s_sM + "suffix2");
        test("-2900-194313216", "" + s_sM + sf_l);
        test("-2900-194313216suffix", "" + s_sM + sf_l + "suffix");
        test("prefix-2900suffix1-194313216suffix2", "prefix" + s_sM + "suffix1" + sf_l + "suffix2");
        test("-290012", "" + s_sM + s_strU1);
        test("-290012suffix", "" + s_sM + s_strU1 + "suffix");
        test("prefix-2900suffix112suffix2", "prefix" + s_sM + "suffix1" + s_strU1 + "suffix2");
        test("-2900C(87)", "" + s_sM + sf_o);
        test("-2900C(87)suffix", "" + s_sM + sf_o + "suffix");
        test("prefix-2900suffix1C(87)suffix2", "prefix" + s_sM + "suffix1" + sf_o + "suffix2");
        test("-290091", "" + s_sM + s_strU2);
        test("-290091suffix", "" + s_sM + s_strU2 + "suffix");
        test("prefix-2900suffix191suffix2", "prefix" + s_sM + "suffix1" + s_strU2 + "suffix2");
        test("-290021", "" + s_sM + f_strU1);
        test("-290021suffix", "" + s_sM + f_strU1 + "suffix");
        test("prefix-2900suffix121suffix2", "prefix" + s_sM + "suffix1" + f_strU1 + "suffix2");
        test("-290018", "" + s_sM + f_strU2);
        test("-290018suffix", "" + s_sM + f_strU2 + "suffix");
        test("prefix-2900suffix118suffix2", "prefix" + s_sM + "suffix1" + f_strU2 + "suffix2");
        test("-2900null", "" + s_sM + f_iAN);
        test("-2900nullsuffix", "" + s_sM + f_iAN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + f_iAN + "suffix2");
        test("-2900null", "" + s_sM + s_oN);
        test("-2900nullsuffix", "" + s_sM + s_oN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + s_oN + "suffix2");
        test("-2900\u045180", "" + s_sM + s_strU);
        test("-2900\u045180suffix", "" + s_sM + s_strU + "suffix");
        test("prefix-2900suffix1\u045180suffix2", "prefix" + s_sM + "suffix1" + s_strU + "suffix2");
        test("-2900C", "" + s_sM + sf_c);
        test("-2900Csuffix", "" + s_sM + sf_c + "suffix");
        test("prefix-2900suffix1Csuffix2", "prefix" + s_sM + "suffix1" + sf_c + "suffix2");
        test("-290075", "" + s_sM + sf_str);
        test("-290075suffix", "" + s_sM + sf_str + "suffix");
        test("prefix-2900suffix175suffix2", "prefix" + s_sM + "suffix1" + sf_str + "suffix2");
        test("-2900-43", "" + s_sM + s_bM);
        test("-2900-43suffix", "" + s_sM + s_bM + "suffix");
        test("prefix-2900suffix1-43suffix2", "prefix" + s_sM + "suffix1" + s_bM + "suffix2");
        test("-290080", "" + s_sM + sf_b);
        test("-290080suffix", "" + s_sM + sf_b + "suffix");
        test("prefix-2900suffix180suffix2", "prefix" + s_sM + "suffix1" + sf_b + "suffix2");
        test("-2900null", "" + s_sM + s_IN);
        test("-2900nullsuffix", "" + s_sM + s_IN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + s_IN + "suffix2");
        test("-2900-52.0", "" + s_sM + s_fM);
        test("-2900-52.0suffix", "" + s_sM + s_fM + "suffix");
        test("prefix-2900suffix1-52.0suffix2", "prefix" + s_sM + "suffix1" + s_fM + "suffix2");
        test("-290075000000", "" + s_sM + sf_i);
        test("-290075000000suffix", "" + s_sM + sf_i + "suffix");
        test("prefix-2900suffix175000000suffix2", "prefix" + s_sM + "suffix1" + sf_i + "suffix2");
        test("-290044", "" + s_sM + f_b);
        test("-290044suffix", "" + s_sM + f_b + "suffix");
        test("prefix-2900suffix144suffix2", "prefix" + s_sM + "suffix1" + f_b + "suffix2");
        test("-2900-1705032704", "" + s_sM + sf_lM);
        test("-2900-1705032704suffix", "" + s_sM + sf_lM + "suffix");
        test("prefix-2900suffix1-1705032704suffix2", "prefix" + s_sM + "suffix1" + sf_lM + "suffix2");
        test("-2900null", "" + s_sM + f_oAN);
        test("-2900nullsuffix", "" + s_sM + f_oAN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + f_oAN + "suffix2");
        test("-290083.0", "" + s_sM + f_d);
        test("-290083.0suffix", "" + s_sM + f_d + "suffix");
        test("prefix-2900suffix183.0suffix2", "prefix" + s_sM + "suffix1" + f_d + "suffix2");
        test("-2900I", "" + s_sM + f_c);
        test("-2900Isuffix", "" + s_sM + f_c + "suffix");
        test("prefix-2900suffix1Isuffix2", "prefix" + s_sM + "suffix1" + f_c + "suffix2");
        test("-290094.0", "" + s_sM + f_f);
        test("-290094.0suffix", "" + s_sM + f_f + "suffix");
        test("prefix-2900suffix194.0suffix2", "prefix" + s_sM + "suffix1" + f_f + "suffix2");
        test("-290012.0", "" + s_sM + sf_d);
        test("-290012.0suffix", "" + s_sM + sf_d + "suffix");
        test("prefix-2900suffix112.0suffix2", "prefix" + s_sM + "suffix1" + sf_d + "suffix2");
        test("-2900-99.0", "" + s_sM + f_dM);
        test("-2900-99.0suffix", "" + s_sM + f_dM + "suffix");
        test("prefix-2900suffix1-99.0suffix2", "prefix" + s_sM + "suffix1" + f_dM + "suffix2");
        test("-290017.0", "" + s_sM + sf_f);
        test("-290017.0suffix", "" + s_sM + sf_f + "suffix");
        test("prefix-2900suffix117.0suffix2", "prefix" + s_sM + "suffix1" + sf_f + "suffix2");
        test("-2900-84.0", "" + s_sM + sf_dM);
        test("-2900-84.0suffix", "" + s_sM + sf_dM + "suffix");
        test("prefix-2900suffix1-84.0suffix2", "prefix" + s_sM + "suffix1" + sf_dM + "suffix2");
        test("-290058000000", "" + s_sM + f_i);
        test("-290058000000suffix", "" + s_sM + f_i + "suffix");
        test("prefix-2900suffix158000000suffix2", "prefix" + s_sM + "suffix1" + f_i + "suffix2");
        test("-2900-55000000", "" + s_sM + f_iM);
        test("-2900-55000000suffix", "" + s_sM + f_iM + "suffix");
        test("prefix-2900suffix1-55000000suffix2", "prefix" + s_sM + "suffix1" + f_iM + "suffix2");
        test("-29001460392448", "" + s_sM + f_l);
        test("-29001460392448suffix", "" + s_sM + f_l + "suffix");
        test("prefix-2900suffix11460392448suffix2", "prefix" + s_sM + "suffix1" + f_l + "suffix2");
        test("-2900C(70)", "" + s_sM + f_o);
        test("-2900C(70)suffix", "" + s_sM + f_o + "suffix");
        test("prefix-2900suffix1C(70)suffix2", "prefix" + s_sM + "suffix1" + f_o + "suffix2");
        test("-2900\u04511", "" + s_sM + sf_strU);
        test("-2900\u04511suffix", "" + s_sM + sf_strU + "suffix");
        test("prefix-2900suffix1\u04511suffix2", "prefix" + s_sM + "suffix1" + sf_strU + "suffix2");
        test("-29008000", "" + s_sM + f_s);
        test("-29008000suffix", "" + s_sM + f_s + "suffix");
        test("prefix-2900suffix18000suffix2", "prefix" + s_sM + "suffix1" + f_s + "suffix2");
        test("-290018", "" + s_sM + s_str);
        test("-290018suffix", "" + s_sM + s_str + "suffix");
        test("prefix-2900suffix118suffix2", "prefix" + s_sM + "suffix1" + s_str + "suffix2");
        test("-2900-1000000", "" + s_sM + s_iM);
        test("-2900-1000000suffix", "" + s_sM + s_iM + "suffix");
        test("prefix-2900suffix1-1000000suffix2", "prefix" + s_sM + "suffix1" + s_iM + "suffix2");
        test("-29001000000", "" + s_sM + sf_I);
        test("-29001000000suffix", "" + s_sM + sf_I + "suffix");
        test("prefix-2900suffix11000000suffix2", "prefix" + s_sM + "suffix1" + sf_I + "suffix2");
        test("-2900null", "" + s_sM + f_oNtS);
        test("-2900nullsuffix", "" + s_sM + f_oNtS + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + f_oNtS + "suffix2");
        test("-2900false", "" + s_sM + f_bl);
        test("-2900falsesuffix", "" + s_sM + f_bl + "suffix");
        test("prefix-2900suffix1falsesuffix2", "prefix" + s_sM + "suffix1" + f_bl + "suffix2");
        test("-2900null", "" + s_sM + sf_iAN);
        test("-2900nullsuffix", "" + s_sM + sf_iAN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + sf_iAN + "suffix2");
        test("-2900-2000000", "" + s_sM + sf_iM);
        test("-2900-2000000suffix", "" + s_sM + sf_iM + "suffix");
        test("prefix-2900suffix1-2000000suffix2", "prefix" + s_sM + "suffix1" + sf_iM + "suffix2");
        test("-2900-820130816", "" + s_sM + f_lM);
        test("-2900-820130816suffix", "" + s_sM + f_lM + "suffix");
        test("prefix-2900suffix1-820130816suffix2", "prefix" + s_sM + "suffix1" + f_lM + "suffix2");
        test("-2900null", "" + s_sM + sf_oAN);
        test("-2900nullsuffix", "" + s_sM + sf_oAN + "suffix");
        test("prefix-2900suffix1nullsuffix2", "prefix" + s_sM + "suffix1" + sf_oAN + "suffix2");
        test("-290025000000", "" + s_sM + s_I);
        test("-290025000000suffix", "" + s_sM + s_I + "suffix");
        test("prefix-2900suffix125000000suffix2", "prefix" + s_sM + "suffix1" + s_I + "suffix2");
        test("-194313216-96.0", "" + sf_l + s_dM);
        test("-194313216-96.0suffix", "" + sf_l + s_dM + "suffix");
        test("prefix-194313216suffix1-96.0suffix2", "prefix" + sf_l + "suffix1" + s_dM + "suffix2");
        test("-194313216null", "" + sf_l + s_oNtS);
        test("-194313216nullsuffix", "" + sf_l + s_oNtS + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + s_oNtS + "suffix2");
        test("-194313216\u045176", "" + sf_l + f_strU);
        test("-194313216\u045176suffix", "" + sf_l + f_strU + "suffix");
        test("prefix-194313216suffix1\u045176suffix2", "prefix" + sf_l + "suffix1" + f_strU + "suffix2");
        test("-19431321692", "" + sf_l + sf_strU2);
        test("-19431321692suffix", "" + sf_l + sf_strU2 + "suffix");
        test("prefix-194313216suffix192suffix2", "prefix" + sf_l + "suffix1" + sf_strU2 + "suffix2");
        test("-19431321651", "" + sf_l + sf_strU1);
        test("-19431321651suffix", "" + sf_l + sf_strU1 + "suffix");
        test("prefix-194313216suffix151suffix2", "prefix" + sf_l + "suffix1" + sf_strU1 + "suffix2");
        test("-194313216null", "" + sf_l + s_iAN);
        test("-194313216nullsuffix", "" + sf_l + s_iAN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + s_iAN + "suffix2");
        test("-194313216-54", "" + sf_l + f_bM);
        test("-194313216-54suffix", "" + sf_l + f_bM + "suffix");
        test("prefix-194313216suffix1-54suffix2", "prefix" + sf_l + "suffix1" + f_bM + "suffix2");
        test("-194313216-87.0", "" + sf_l + f_fM);
        test("-194313216-87.0suffix", "" + sf_l + f_fM + "suffix");
        test("prefix-194313216suffix1-87.0suffix2", "prefix" + sf_l + "suffix1" + f_fM + "suffix2");
        test("-194313216null", "" + sf_l + s_oAN);
        test("-194313216nullsuffix", "" + sf_l + s_oAN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + s_oAN + "suffix2");
        test("-19431321619", "" + sf_l + f_str);
        test("-19431321619suffix", "" + sf_l + f_str + "suffix");
        test("prefix-194313216suffix119suffix2", "prefix" + sf_l + "suffix1" + f_str + "suffix2");
        test("-194313216-41", "" + sf_l + sf_bM);
        test("-194313216-41suffix", "" + sf_l + sf_bM + "suffix");
        test("prefix-194313216suffix1-41suffix2", "prefix" + sf_l + "suffix1" + sf_bM + "suffix2");
        test("-194313216null", "" + sf_l + sf_IN);
        test("-194313216nullsuffix", "" + sf_l + sf_IN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + sf_IN + "suffix2");
        test("-194313216T", "" + sf_l + s_c);
        test("-194313216Tsuffix", "" + sf_l + s_c + "suffix");
        test("prefix-194313216suffix1Tsuffix2", "prefix" + sf_l + "suffix1" + s_c + "suffix2");
        test("-194313216-42.0", "" + sf_l + sf_fM);
        test("-194313216-42.0suffix", "" + sf_l + sf_fM + "suffix");
        test("prefix-194313216suffix1-42.0suffix2", "prefix" + sf_l + "suffix1" + sf_fM + "suffix2");
        test("-19431321625", "" + sf_l + s_b);
        test("-19431321625suffix", "" + sf_l + s_b + "suffix");
        test("prefix-194313216suffix125suffix2", "prefix" + sf_l + "suffix1" + s_b + "suffix2");
        test("-194313216null", "" + sf_l + f_oN);
        test("-194313216nullsuffix", "" + sf_l + f_oN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + f_oN + "suffix2");
        test("-194313216-1410065408", "" + sf_l + s_lM);
        test("-194313216-1410065408suffix", "" + sf_l + s_lM + "suffix");
        test("prefix-194313216suffix1-1410065408suffix2", "prefix" + sf_l + "suffix1" + s_lM + "suffix2");
        test("-1943132168.0", "" + sf_l + s_d);
        test("-1943132168.0suffix", "" + sf_l + s_d + "suffix");
        test("prefix-194313216suffix18.0suffix2", "prefix" + sf_l + "suffix1" + s_d + "suffix2");
        test("-19431321655.0", "" + sf_l + s_f);
        test("-19431321655.0suffix", "" + sf_l + s_f + "suffix");
        test("prefix-194313216suffix155.0suffix2", "prefix" + sf_l + "suffix1" + s_f + "suffix2");
        test("-19431321697000000", "" + sf_l + s_i);
        test("-19431321697000000suffix", "" + sf_l + s_i + "suffix");
        test("prefix-194313216suffix197000000suffix2", "prefix" + sf_l + "suffix1" + s_i + "suffix2");
        test("-194313216-9900", "" + sf_l + f_sM);
        test("-194313216-9900suffix", "" + sf_l + f_sM + "suffix");
        test("prefix-194313216suffix1-9900suffix2", "prefix" + sf_l + "suffix1" + f_sM + "suffix2");
        test("-194313216935228928", "" + sf_l + s_l);
        test("-194313216935228928suffix", "" + sf_l + s_l + "suffix");
        test("prefix-194313216suffix1935228928suffix2", "prefix" + sf_l + "suffix1" + s_l + "suffix2");
        test("-194313216-8400", "" + sf_l + sf_sM);
        test("-194313216-8400suffix", "" + sf_l + sf_sM + "suffix");
        test("prefix-194313216suffix1-8400suffix2", "prefix" + sf_l + "suffix1" + sf_sM + "suffix2");
        test("-194313216C(82)", "" + sf_l + s_o);
        test("-194313216C(82)suffix", "" + sf_l + s_o + "suffix");
        test("prefix-194313216suffix1C(82)suffix2", "prefix" + sf_l + "suffix1" + s_o + "suffix2");
        test("-194313216null", "" + sf_l + sf_oNtS);
        test("-194313216nullsuffix", "" + sf_l + sf_oNtS + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + sf_oNtS + "suffix2");
        test("-194313216true", "" + sf_l + s_bl);
        test("-194313216truesuffix", "" + sf_l + s_bl + "suffix");
        test("prefix-194313216suffix1truesuffix2", "prefix" + sf_l + "suffix1" + s_bl + "suffix2");
        test("-1943132163900", "" + sf_l + s_s);
        test("-1943132163900suffix", "" + sf_l + s_s + "suffix");
        test("prefix-194313216suffix13900suffix2", "prefix" + sf_l + "suffix1" + s_s + "suffix2");
        test("-194313216null", "" + sf_l + sf_oN);
        test("-194313216nullsuffix", "" + sf_l + sf_oN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + sf_oN + "suffix2");
        test("-19431321694000000", "" + sf_l + f_I);
        test("-19431321694000000suffix", "" + sf_l + f_I + "suffix");
        test("prefix-194313216suffix194000000suffix2", "prefix" + sf_l + "suffix1" + f_I + "suffix2");
        test("-194313216null", "" + sf_l + f_IN);
        test("-194313216nullsuffix", "" + sf_l + f_IN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + f_IN + "suffix2");
        test("-194313216true", "" + sf_l + sf_bl);
        test("-194313216truesuffix", "" + sf_l + sf_bl + "suffix");
        test("prefix-194313216suffix1truesuffix2", "prefix" + sf_l + "suffix1" + sf_bl + "suffix2");
        test("-1943132165500", "" + sf_l + sf_s);
        test("-1943132165500suffix", "" + sf_l + sf_s + "suffix");
        test("prefix-194313216suffix15500suffix2", "prefix" + sf_l + "suffix1" + sf_s + "suffix2");
        test("-194313216-2900", "" + sf_l + s_sM);
        test("-194313216-2900suffix", "" + sf_l + s_sM + "suffix");
        test("prefix-194313216suffix1-2900suffix2", "prefix" + sf_l + "suffix1" + s_sM + "suffix2");
        test("-194313216-194313216", "" + sf_l + sf_l);
        test("-194313216-194313216suffix", "" + sf_l + sf_l + "suffix");
        test("prefix-194313216suffix1-194313216suffix2", "prefix" + sf_l + "suffix1" + sf_l + "suffix2");
        test("-19431321612", "" + sf_l + s_strU1);
        test("-19431321612suffix", "" + sf_l + s_strU1 + "suffix");
        test("prefix-194313216suffix112suffix2", "prefix" + sf_l + "suffix1" + s_strU1 + "suffix2");
        test("-194313216C(87)", "" + sf_l + sf_o);
        test("-194313216C(87)suffix", "" + sf_l + sf_o + "suffix");
        test("prefix-194313216suffix1C(87)suffix2", "prefix" + sf_l + "suffix1" + sf_o + "suffix2");
        test("-19431321691", "" + sf_l + s_strU2);
        test("-19431321691suffix", "" + sf_l + s_strU2 + "suffix");
        test("prefix-194313216suffix191suffix2", "prefix" + sf_l + "suffix1" + s_strU2 + "suffix2");
        test("-19431321621", "" + sf_l + f_strU1);
        test("-19431321621suffix", "" + sf_l + f_strU1 + "suffix");
        test("prefix-194313216suffix121suffix2", "prefix" + sf_l + "suffix1" + f_strU1 + "suffix2");
        test("-19431321618", "" + sf_l + f_strU2);
        test("-19431321618suffix", "" + sf_l + f_strU2 + "suffix");
        test("prefix-194313216suffix118suffix2", "prefix" + sf_l + "suffix1" + f_strU2 + "suffix2");
        test("-194313216null", "" + sf_l + f_iAN);
        test("-194313216nullsuffix", "" + sf_l + f_iAN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + f_iAN + "suffix2");
        test("-194313216null", "" + sf_l + s_oN);
        test("-194313216nullsuffix", "" + sf_l + s_oN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + s_oN + "suffix2");
        test("-194313216\u045180", "" + sf_l + s_strU);
        test("-194313216\u045180suffix", "" + sf_l + s_strU + "suffix");
        test("prefix-194313216suffix1\u045180suffix2", "prefix" + sf_l + "suffix1" + s_strU + "suffix2");
        test("-194313216C", "" + sf_l + sf_c);
        test("-194313216Csuffix", "" + sf_l + sf_c + "suffix");
        test("prefix-194313216suffix1Csuffix2", "prefix" + sf_l + "suffix1" + sf_c + "suffix2");
        test("-19431321675", "" + sf_l + sf_str);
        test("-19431321675suffix", "" + sf_l + sf_str + "suffix");
        test("prefix-194313216suffix175suffix2", "prefix" + sf_l + "suffix1" + sf_str + "suffix2");
        test("-194313216-43", "" + sf_l + s_bM);
        test("-194313216-43suffix", "" + sf_l + s_bM + "suffix");
        test("prefix-194313216suffix1-43suffix2", "prefix" + sf_l + "suffix1" + s_bM + "suffix2");
        test("-19431321680", "" + sf_l + sf_b);
        test("-19431321680suffix", "" + sf_l + sf_b + "suffix");
        test("prefix-194313216suffix180suffix2", "prefix" + sf_l + "suffix1" + sf_b + "suffix2");
        test("-194313216null", "" + sf_l + s_IN);
        test("-194313216nullsuffix", "" + sf_l + s_IN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + s_IN + "suffix2");
        test("-194313216-52.0", "" + sf_l + s_fM);
        test("-194313216-52.0suffix", "" + sf_l + s_fM + "suffix");
        test("prefix-194313216suffix1-52.0suffix2", "prefix" + sf_l + "suffix1" + s_fM + "suffix2");
        test("-19431321675000000", "" + sf_l + sf_i);
        test("-19431321675000000suffix", "" + sf_l + sf_i + "suffix");
        test("prefix-194313216suffix175000000suffix2", "prefix" + sf_l + "suffix1" + sf_i + "suffix2");
        test("-19431321644", "" + sf_l + f_b);
        test("-19431321644suffix", "" + sf_l + f_b + "suffix");
        test("prefix-194313216suffix144suffix2", "prefix" + sf_l + "suffix1" + f_b + "suffix2");
        test("-194313216-1705032704", "" + sf_l + sf_lM);
        test("-194313216-1705032704suffix", "" + sf_l + sf_lM + "suffix");
        test("prefix-194313216suffix1-1705032704suffix2", "prefix" + sf_l + "suffix1" + sf_lM + "suffix2");
        test("-194313216null", "" + sf_l + f_oAN);
        test("-194313216nullsuffix", "" + sf_l + f_oAN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + f_oAN + "suffix2");
        test("-19431321683.0", "" + sf_l + f_d);
        test("-19431321683.0suffix", "" + sf_l + f_d + "suffix");
        test("prefix-194313216suffix183.0suffix2", "prefix" + sf_l + "suffix1" + f_d + "suffix2");
        test("-194313216I", "" + sf_l + f_c);
        test("-194313216Isuffix", "" + sf_l + f_c + "suffix");
        test("prefix-194313216suffix1Isuffix2", "prefix" + sf_l + "suffix1" + f_c + "suffix2");
        test("-19431321694.0", "" + sf_l + f_f);
        test("-19431321694.0suffix", "" + sf_l + f_f + "suffix");
        test("prefix-194313216suffix194.0suffix2", "prefix" + sf_l + "suffix1" + f_f + "suffix2");
        test("-19431321612.0", "" + sf_l + sf_d);
        test("-19431321612.0suffix", "" + sf_l + sf_d + "suffix");
        test("prefix-194313216suffix112.0suffix2", "prefix" + sf_l + "suffix1" + sf_d + "suffix2");
        test("-194313216-99.0", "" + sf_l + f_dM);
        test("-194313216-99.0suffix", "" + sf_l + f_dM + "suffix");
        test("prefix-194313216suffix1-99.0suffix2", "prefix" + sf_l + "suffix1" + f_dM + "suffix2");
        test("-19431321617.0", "" + sf_l + sf_f);
        test("-19431321617.0suffix", "" + sf_l + sf_f + "suffix");
        test("prefix-194313216suffix117.0suffix2", "prefix" + sf_l + "suffix1" + sf_f + "suffix2");
        test("-194313216-84.0", "" + sf_l + sf_dM);
        test("-194313216-84.0suffix", "" + sf_l + sf_dM + "suffix");
        test("prefix-194313216suffix1-84.0suffix2", "prefix" + sf_l + "suffix1" + sf_dM + "suffix2");
        test("-19431321658000000", "" + sf_l + f_i);
        test("-19431321658000000suffix", "" + sf_l + f_i + "suffix");
        test("prefix-194313216suffix158000000suffix2", "prefix" + sf_l + "suffix1" + f_i + "suffix2");
        test("-194313216-55000000", "" + sf_l + f_iM);
        test("-194313216-55000000suffix", "" + sf_l + f_iM + "suffix");
        test("prefix-194313216suffix1-55000000suffix2", "prefix" + sf_l + "suffix1" + f_iM + "suffix2");
        test("-1943132161460392448", "" + sf_l + f_l);
        test("-1943132161460392448suffix", "" + sf_l + f_l + "suffix");
        test("prefix-194313216suffix11460392448suffix2", "prefix" + sf_l + "suffix1" + f_l + "suffix2");
        test("-194313216C(70)", "" + sf_l + f_o);
        test("-194313216C(70)suffix", "" + sf_l + f_o + "suffix");
        test("prefix-194313216suffix1C(70)suffix2", "prefix" + sf_l + "suffix1" + f_o + "suffix2");
        test("-194313216\u04511", "" + sf_l + sf_strU);
        test("-194313216\u04511suffix", "" + sf_l + sf_strU + "suffix");
        test("prefix-194313216suffix1\u04511suffix2", "prefix" + sf_l + "suffix1" + sf_strU + "suffix2");
        test("-1943132168000", "" + sf_l + f_s);
        test("-1943132168000suffix", "" + sf_l + f_s + "suffix");
        test("prefix-194313216suffix18000suffix2", "prefix" + sf_l + "suffix1" + f_s + "suffix2");
        test("-19431321618", "" + sf_l + s_str);
        test("-19431321618suffix", "" + sf_l + s_str + "suffix");
        test("prefix-194313216suffix118suffix2", "prefix" + sf_l + "suffix1" + s_str + "suffix2");
        test("-194313216-1000000", "" + sf_l + s_iM);
        test("-194313216-1000000suffix", "" + sf_l + s_iM + "suffix");
        test("prefix-194313216suffix1-1000000suffix2", "prefix" + sf_l + "suffix1" + s_iM + "suffix2");
        test("-1943132161000000", "" + sf_l + sf_I);
        test("-1943132161000000suffix", "" + sf_l + sf_I + "suffix");
        test("prefix-194313216suffix11000000suffix2", "prefix" + sf_l + "suffix1" + sf_I + "suffix2");
        test("-194313216null", "" + sf_l + f_oNtS);
        test("-194313216nullsuffix", "" + sf_l + f_oNtS + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + f_oNtS + "suffix2");
        test("-194313216false", "" + sf_l + f_bl);
        test("-194313216falsesuffix", "" + sf_l + f_bl + "suffix");
        test("prefix-194313216suffix1falsesuffix2", "prefix" + sf_l + "suffix1" + f_bl + "suffix2");
        test("-194313216null", "" + sf_l + sf_iAN);
        test("-194313216nullsuffix", "" + sf_l + sf_iAN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + sf_iAN + "suffix2");
        test("-194313216-2000000", "" + sf_l + sf_iM);
        test("-194313216-2000000suffix", "" + sf_l + sf_iM + "suffix");
        test("prefix-194313216suffix1-2000000suffix2", "prefix" + sf_l + "suffix1" + sf_iM + "suffix2");
        test("-194313216-820130816", "" + sf_l + f_lM);
        test("-194313216-820130816suffix", "" + sf_l + f_lM + "suffix");
        test("prefix-194313216suffix1-820130816suffix2", "prefix" + sf_l + "suffix1" + f_lM + "suffix2");
        test("-194313216null", "" + sf_l + sf_oAN);
        test("-194313216nullsuffix", "" + sf_l + sf_oAN + "suffix");
        test("prefix-194313216suffix1nullsuffix2", "prefix" + sf_l + "suffix1" + sf_oAN + "suffix2");
        test("-19431321625000000", "" + sf_l + s_I);
        test("-19431321625000000suffix", "" + sf_l + s_I + "suffix");
        test("prefix-194313216suffix125000000suffix2", "prefix" + sf_l + "suffix1" + s_I + "suffix2");
        test("12-96.0", "" + s_strU1 + s_dM);
        test("12-96.0suffix", "" + s_strU1 + s_dM + "suffix");
        test("prefix12suffix1-96.0suffix2", "prefix" + s_strU1 + "suffix1" + s_dM + "suffix2");
        test("12null", "" + s_strU1 + s_oNtS);
        test("12nullsuffix", "" + s_strU1 + s_oNtS + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + s_oNtS + "suffix2");
        test("12\u045176", "" + s_strU1 + f_strU);
        test("12\u045176suffix", "" + s_strU1 + f_strU + "suffix");
        test("prefix12suffix1\u045176suffix2", "prefix" + s_strU1 + "suffix1" + f_strU + "suffix2");
        test("1292", "" + s_strU1 + sf_strU2);
        test("1292suffix", "" + s_strU1 + sf_strU2 + "suffix");
        test("prefix12suffix192suffix2", "prefix" + s_strU1 + "suffix1" + sf_strU2 + "suffix2");
        test("1251", "" + s_strU1 + sf_strU1);
        test("1251suffix", "" + s_strU1 + sf_strU1 + "suffix");
        test("prefix12suffix151suffix2", "prefix" + s_strU1 + "suffix1" + sf_strU1 + "suffix2");
        test("12null", "" + s_strU1 + s_iAN);
        test("12nullsuffix", "" + s_strU1 + s_iAN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + s_iAN + "suffix2");
        test("12-54", "" + s_strU1 + f_bM);
        test("12-54suffix", "" + s_strU1 + f_bM + "suffix");
        test("prefix12suffix1-54suffix2", "prefix" + s_strU1 + "suffix1" + f_bM + "suffix2");
        test("12-87.0", "" + s_strU1 + f_fM);
        test("12-87.0suffix", "" + s_strU1 + f_fM + "suffix");
        test("prefix12suffix1-87.0suffix2", "prefix" + s_strU1 + "suffix1" + f_fM + "suffix2");
        test("12null", "" + s_strU1 + s_oAN);
        test("12nullsuffix", "" + s_strU1 + s_oAN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + s_oAN + "suffix2");
        test("1219", "" + s_strU1 + f_str);
        test("1219suffix", "" + s_strU1 + f_str + "suffix");
        test("prefix12suffix119suffix2", "prefix" + s_strU1 + "suffix1" + f_str + "suffix2");
        test("12-41", "" + s_strU1 + sf_bM);
        test("12-41suffix", "" + s_strU1 + sf_bM + "suffix");
        test("prefix12suffix1-41suffix2", "prefix" + s_strU1 + "suffix1" + sf_bM + "suffix2");
        test("12null", "" + s_strU1 + sf_IN);
        test("12nullsuffix", "" + s_strU1 + sf_IN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + sf_IN + "suffix2");
        test("12T", "" + s_strU1 + s_c);
        test("12Tsuffix", "" + s_strU1 + s_c + "suffix");
        test("prefix12suffix1Tsuffix2", "prefix" + s_strU1 + "suffix1" + s_c + "suffix2");
        test("12-42.0", "" + s_strU1 + sf_fM);
        test("12-42.0suffix", "" + s_strU1 + sf_fM + "suffix");
        test("prefix12suffix1-42.0suffix2", "prefix" + s_strU1 + "suffix1" + sf_fM + "suffix2");
        test("1225", "" + s_strU1 + s_b);
        test("1225suffix", "" + s_strU1 + s_b + "suffix");
        test("prefix12suffix125suffix2", "prefix" + s_strU1 + "suffix1" + s_b + "suffix2");
        test("12null", "" + s_strU1 + f_oN);
        test("12nullsuffix", "" + s_strU1 + f_oN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + f_oN + "suffix2");
        test("12-1410065408", "" + s_strU1 + s_lM);
        test("12-1410065408suffix", "" + s_strU1 + s_lM + "suffix");
    }

    public void run8() {
        test("prefix12suffix1-1410065408suffix2", "prefix" + s_strU1 + "suffix1" + s_lM + "suffix2");
        test("128.0", "" + s_strU1 + s_d);
        test("128.0suffix", "" + s_strU1 + s_d + "suffix");
        test("prefix12suffix18.0suffix2", "prefix" + s_strU1 + "suffix1" + s_d + "suffix2");
        test("1255.0", "" + s_strU1 + s_f);
        test("1255.0suffix", "" + s_strU1 + s_f + "suffix");
        test("prefix12suffix155.0suffix2", "prefix" + s_strU1 + "suffix1" + s_f + "suffix2");
        test("1297000000", "" + s_strU1 + s_i);
        test("1297000000suffix", "" + s_strU1 + s_i + "suffix");
        test("prefix12suffix197000000suffix2", "prefix" + s_strU1 + "suffix1" + s_i + "suffix2");
        test("12-9900", "" + s_strU1 + f_sM);
        test("12-9900suffix", "" + s_strU1 + f_sM + "suffix");
        test("prefix12suffix1-9900suffix2", "prefix" + s_strU1 + "suffix1" + f_sM + "suffix2");
        test("12935228928", "" + s_strU1 + s_l);
        test("12935228928suffix", "" + s_strU1 + s_l + "suffix");
        test("prefix12suffix1935228928suffix2", "prefix" + s_strU1 + "suffix1" + s_l + "suffix2");
        test("12-8400", "" + s_strU1 + sf_sM);
        test("12-8400suffix", "" + s_strU1 + sf_sM + "suffix");
        test("prefix12suffix1-8400suffix2", "prefix" + s_strU1 + "suffix1" + sf_sM + "suffix2");
        test("12C(82)", "" + s_strU1 + s_o);
        test("12C(82)suffix", "" + s_strU1 + s_o + "suffix");
        test("prefix12suffix1C(82)suffix2", "prefix" + s_strU1 + "suffix1" + s_o + "suffix2");
        test("12null", "" + s_strU1 + sf_oNtS);
        test("12nullsuffix", "" + s_strU1 + sf_oNtS + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + sf_oNtS + "suffix2");
        test("12true", "" + s_strU1 + s_bl);
        test("12truesuffix", "" + s_strU1 + s_bl + "suffix");
        test("prefix12suffix1truesuffix2", "prefix" + s_strU1 + "suffix1" + s_bl + "suffix2");
        test("123900", "" + s_strU1 + s_s);
        test("123900suffix", "" + s_strU1 + s_s + "suffix");
        test("prefix12suffix13900suffix2", "prefix" + s_strU1 + "suffix1" + s_s + "suffix2");
        test("12null", "" + s_strU1 + sf_oN);
        test("12nullsuffix", "" + s_strU1 + sf_oN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + sf_oN + "suffix2");
        test("1294000000", "" + s_strU1 + f_I);
        test("1294000000suffix", "" + s_strU1 + f_I + "suffix");
        test("prefix12suffix194000000suffix2", "prefix" + s_strU1 + "suffix1" + f_I + "suffix2");
        test("12null", "" + s_strU1 + f_IN);
        test("12nullsuffix", "" + s_strU1 + f_IN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + f_IN + "suffix2");
        test("12true", "" + s_strU1 + sf_bl);
        test("12truesuffix", "" + s_strU1 + sf_bl + "suffix");
        test("prefix12suffix1truesuffix2", "prefix" + s_strU1 + "suffix1" + sf_bl + "suffix2");
        test("125500", "" + s_strU1 + sf_s);
        test("125500suffix", "" + s_strU1 + sf_s + "suffix");
        test("prefix12suffix15500suffix2", "prefix" + s_strU1 + "suffix1" + sf_s + "suffix2");
        test("12-2900", "" + s_strU1 + s_sM);
        test("12-2900suffix", "" + s_strU1 + s_sM + "suffix");
        test("prefix12suffix1-2900suffix2", "prefix" + s_strU1 + "suffix1" + s_sM + "suffix2");
        test("12-194313216", "" + s_strU1 + sf_l);
        test("12-194313216suffix", "" + s_strU1 + sf_l + "suffix");
        test("prefix12suffix1-194313216suffix2", "prefix" + s_strU1 + "suffix1" + sf_l + "suffix2");
        test("1212", "" + s_strU1 + s_strU1);
        test("1212suffix", "" + s_strU1 + s_strU1 + "suffix");
        test("prefix12suffix112suffix2", "prefix" + s_strU1 + "suffix1" + s_strU1 + "suffix2");
        test("12C(87)", "" + s_strU1 + sf_o);
        test("12C(87)suffix", "" + s_strU1 + sf_o + "suffix");
        test("prefix12suffix1C(87)suffix2", "prefix" + s_strU1 + "suffix1" + sf_o + "suffix2");
        test("1291", "" + s_strU1 + s_strU2);
        test("1291suffix", "" + s_strU1 + s_strU2 + "suffix");
        test("prefix12suffix191suffix2", "prefix" + s_strU1 + "suffix1" + s_strU2 + "suffix2");
        test("1221", "" + s_strU1 + f_strU1);
        test("1221suffix", "" + s_strU1 + f_strU1 + "suffix");
        test("prefix12suffix121suffix2", "prefix" + s_strU1 + "suffix1" + f_strU1 + "suffix2");
        test("1218", "" + s_strU1 + f_strU2);
        test("1218suffix", "" + s_strU1 + f_strU2 + "suffix");
        test("prefix12suffix118suffix2", "prefix" + s_strU1 + "suffix1" + f_strU2 + "suffix2");
        test("12null", "" + s_strU1 + f_iAN);
        test("12nullsuffix", "" + s_strU1 + f_iAN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + f_iAN + "suffix2");
        test("12null", "" + s_strU1 + s_oN);
        test("12nullsuffix", "" + s_strU1 + s_oN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + s_oN + "suffix2");
        test("12\u045180", "" + s_strU1 + s_strU);
        test("12\u045180suffix", "" + s_strU1 + s_strU + "suffix");
        test("prefix12suffix1\u045180suffix2", "prefix" + s_strU1 + "suffix1" + s_strU + "suffix2");
        test("12C", "" + s_strU1 + sf_c);
        test("12Csuffix", "" + s_strU1 + sf_c + "suffix");
        test("prefix12suffix1Csuffix2", "prefix" + s_strU1 + "suffix1" + sf_c + "suffix2");
        test("1275", "" + s_strU1 + sf_str);
        test("1275suffix", "" + s_strU1 + sf_str + "suffix");
        test("prefix12suffix175suffix2", "prefix" + s_strU1 + "suffix1" + sf_str + "suffix2");
        test("12-43", "" + s_strU1 + s_bM);
        test("12-43suffix", "" + s_strU1 + s_bM + "suffix");
        test("prefix12suffix1-43suffix2", "prefix" + s_strU1 + "suffix1" + s_bM + "suffix2");
        test("1280", "" + s_strU1 + sf_b);
        test("1280suffix", "" + s_strU1 + sf_b + "suffix");
        test("prefix12suffix180suffix2", "prefix" + s_strU1 + "suffix1" + sf_b + "suffix2");
        test("12null", "" + s_strU1 + s_IN);
        test("12nullsuffix", "" + s_strU1 + s_IN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + s_IN + "suffix2");
        test("12-52.0", "" + s_strU1 + s_fM);
        test("12-52.0suffix", "" + s_strU1 + s_fM + "suffix");
        test("prefix12suffix1-52.0suffix2", "prefix" + s_strU1 + "suffix1" + s_fM + "suffix2");
        test("1275000000", "" + s_strU1 + sf_i);
        test("1275000000suffix", "" + s_strU1 + sf_i + "suffix");
        test("prefix12suffix175000000suffix2", "prefix" + s_strU1 + "suffix1" + sf_i + "suffix2");
        test("1244", "" + s_strU1 + f_b);
        test("1244suffix", "" + s_strU1 + f_b + "suffix");
        test("prefix12suffix144suffix2", "prefix" + s_strU1 + "suffix1" + f_b + "suffix2");
        test("12-1705032704", "" + s_strU1 + sf_lM);
        test("12-1705032704suffix", "" + s_strU1 + sf_lM + "suffix");
        test("prefix12suffix1-1705032704suffix2", "prefix" + s_strU1 + "suffix1" + sf_lM + "suffix2");
        test("12null", "" + s_strU1 + f_oAN);
        test("12nullsuffix", "" + s_strU1 + f_oAN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + f_oAN + "suffix2");
        test("1283.0", "" + s_strU1 + f_d);
        test("1283.0suffix", "" + s_strU1 + f_d + "suffix");
        test("prefix12suffix183.0suffix2", "prefix" + s_strU1 + "suffix1" + f_d + "suffix2");
        test("12I", "" + s_strU1 + f_c);
        test("12Isuffix", "" + s_strU1 + f_c + "suffix");
        test("prefix12suffix1Isuffix2", "prefix" + s_strU1 + "suffix1" + f_c + "suffix2");
        test("1294.0", "" + s_strU1 + f_f);
        test("1294.0suffix", "" + s_strU1 + f_f + "suffix");
        test("prefix12suffix194.0suffix2", "prefix" + s_strU1 + "suffix1" + f_f + "suffix2");
        test("1212.0", "" + s_strU1 + sf_d);
        test("1212.0suffix", "" + s_strU1 + sf_d + "suffix");
        test("prefix12suffix112.0suffix2", "prefix" + s_strU1 + "suffix1" + sf_d + "suffix2");
        test("12-99.0", "" + s_strU1 + f_dM);
        test("12-99.0suffix", "" + s_strU1 + f_dM + "suffix");
        test("prefix12suffix1-99.0suffix2", "prefix" + s_strU1 + "suffix1" + f_dM + "suffix2");
        test("1217.0", "" + s_strU1 + sf_f);
        test("1217.0suffix", "" + s_strU1 + sf_f + "suffix");
        test("prefix12suffix117.0suffix2", "prefix" + s_strU1 + "suffix1" + sf_f + "suffix2");
        test("12-84.0", "" + s_strU1 + sf_dM);
        test("12-84.0suffix", "" + s_strU1 + sf_dM + "suffix");
        test("prefix12suffix1-84.0suffix2", "prefix" + s_strU1 + "suffix1" + sf_dM + "suffix2");
        test("1258000000", "" + s_strU1 + f_i);
        test("1258000000suffix", "" + s_strU1 + f_i + "suffix");
        test("prefix12suffix158000000suffix2", "prefix" + s_strU1 + "suffix1" + f_i + "suffix2");
        test("12-55000000", "" + s_strU1 + f_iM);
        test("12-55000000suffix", "" + s_strU1 + f_iM + "suffix");
        test("prefix12suffix1-55000000suffix2", "prefix" + s_strU1 + "suffix1" + f_iM + "suffix2");
        test("121460392448", "" + s_strU1 + f_l);
        test("121460392448suffix", "" + s_strU1 + f_l + "suffix");
        test("prefix12suffix11460392448suffix2", "prefix" + s_strU1 + "suffix1" + f_l + "suffix2");
        test("12C(70)", "" + s_strU1 + f_o);
        test("12C(70)suffix", "" + s_strU1 + f_o + "suffix");
        test("prefix12suffix1C(70)suffix2", "prefix" + s_strU1 + "suffix1" + f_o + "suffix2");
        test("12\u04511", "" + s_strU1 + sf_strU);
        test("12\u04511suffix", "" + s_strU1 + sf_strU + "suffix");
        test("prefix12suffix1\u04511suffix2", "prefix" + s_strU1 + "suffix1" + sf_strU + "suffix2");
        test("128000", "" + s_strU1 + f_s);
        test("128000suffix", "" + s_strU1 + f_s + "suffix");
        test("prefix12suffix18000suffix2", "prefix" + s_strU1 + "suffix1" + f_s + "suffix2");
        test("1218", "" + s_strU1 + s_str);
        test("1218suffix", "" + s_strU1 + s_str + "suffix");
        test("prefix12suffix118suffix2", "prefix" + s_strU1 + "suffix1" + s_str + "suffix2");
        test("12-1000000", "" + s_strU1 + s_iM);
        test("12-1000000suffix", "" + s_strU1 + s_iM + "suffix");
        test("prefix12suffix1-1000000suffix2", "prefix" + s_strU1 + "suffix1" + s_iM + "suffix2");
        test("121000000", "" + s_strU1 + sf_I);
        test("121000000suffix", "" + s_strU1 + sf_I + "suffix");
        test("prefix12suffix11000000suffix2", "prefix" + s_strU1 + "suffix1" + sf_I + "suffix2");
        test("12null", "" + s_strU1 + f_oNtS);
        test("12nullsuffix", "" + s_strU1 + f_oNtS + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + f_oNtS + "suffix2");
        test("12false", "" + s_strU1 + f_bl);
        test("12falsesuffix", "" + s_strU1 + f_bl + "suffix");
        test("prefix12suffix1falsesuffix2", "prefix" + s_strU1 + "suffix1" + f_bl + "suffix2");
        test("12null", "" + s_strU1 + sf_iAN);
        test("12nullsuffix", "" + s_strU1 + sf_iAN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + sf_iAN + "suffix2");
        test("12-2000000", "" + s_strU1 + sf_iM);
        test("12-2000000suffix", "" + s_strU1 + sf_iM + "suffix");
        test("prefix12suffix1-2000000suffix2", "prefix" + s_strU1 + "suffix1" + sf_iM + "suffix2");
        test("12-820130816", "" + s_strU1 + f_lM);
        test("12-820130816suffix", "" + s_strU1 + f_lM + "suffix");
        test("prefix12suffix1-820130816suffix2", "prefix" + s_strU1 + "suffix1" + f_lM + "suffix2");
        test("12null", "" + s_strU1 + sf_oAN);
        test("12nullsuffix", "" + s_strU1 + sf_oAN + "suffix");
        test("prefix12suffix1nullsuffix2", "prefix" + s_strU1 + "suffix1" + sf_oAN + "suffix2");
        test("1225000000", "" + s_strU1 + s_I);
        test("1225000000suffix", "" + s_strU1 + s_I + "suffix");
        test("prefix12suffix125000000suffix2", "prefix" + s_strU1 + "suffix1" + s_I + "suffix2");
        test("C(87)-96.0", "" + sf_o + s_dM);
        test("C(87)-96.0suffix", "" + sf_o + s_dM + "suffix");
        test("prefixC(87)suffix1-96.0suffix2", "prefix" + sf_o + "suffix1" + s_dM + "suffix2");
        test("C(87)null", "" + sf_o + s_oNtS);
        test("C(87)nullsuffix", "" + sf_o + s_oNtS + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + s_oNtS + "suffix2");
        test("C(87)\u045176", "" + sf_o + f_strU);
        test("C(87)\u045176suffix", "" + sf_o + f_strU + "suffix");
        test("prefixC(87)suffix1\u045176suffix2", "prefix" + sf_o + "suffix1" + f_strU + "suffix2");
        test("C(87)92", "" + sf_o + sf_strU2);
        test("C(87)92suffix", "" + sf_o + sf_strU2 + "suffix");
        test("prefixC(87)suffix192suffix2", "prefix" + sf_o + "suffix1" + sf_strU2 + "suffix2");
        test("C(87)51", "" + sf_o + sf_strU1);
        test("C(87)51suffix", "" + sf_o + sf_strU1 + "suffix");
        test("prefixC(87)suffix151suffix2", "prefix" + sf_o + "suffix1" + sf_strU1 + "suffix2");
        test("C(87)null", "" + sf_o + s_iAN);
        test("C(87)nullsuffix", "" + sf_o + s_iAN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + s_iAN + "suffix2");
        test("C(87)-54", "" + sf_o + f_bM);
        test("C(87)-54suffix", "" + sf_o + f_bM + "suffix");
        test("prefixC(87)suffix1-54suffix2", "prefix" + sf_o + "suffix1" + f_bM + "suffix2");
        test("C(87)-87.0", "" + sf_o + f_fM);
        test("C(87)-87.0suffix", "" + sf_o + f_fM + "suffix");
        test("prefixC(87)suffix1-87.0suffix2", "prefix" + sf_o + "suffix1" + f_fM + "suffix2");
        test("C(87)null", "" + sf_o + s_oAN);
        test("C(87)nullsuffix", "" + sf_o + s_oAN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + s_oAN + "suffix2");
        test("C(87)19", "" + sf_o + f_str);
        test("C(87)19suffix", "" + sf_o + f_str + "suffix");
        test("prefixC(87)suffix119suffix2", "prefix" + sf_o + "suffix1" + f_str + "suffix2");
        test("C(87)-41", "" + sf_o + sf_bM);
        test("C(87)-41suffix", "" + sf_o + sf_bM + "suffix");
        test("prefixC(87)suffix1-41suffix2", "prefix" + sf_o + "suffix1" + sf_bM + "suffix2");
        test("C(87)null", "" + sf_o + sf_IN);
        test("C(87)nullsuffix", "" + sf_o + sf_IN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + sf_IN + "suffix2");
        test("C(87)T", "" + sf_o + s_c);
        test("C(87)Tsuffix", "" + sf_o + s_c + "suffix");
        test("prefixC(87)suffix1Tsuffix2", "prefix" + sf_o + "suffix1" + s_c + "suffix2");
        test("C(87)-42.0", "" + sf_o + sf_fM);
        test("C(87)-42.0suffix", "" + sf_o + sf_fM + "suffix");
        test("prefixC(87)suffix1-42.0suffix2", "prefix" + sf_o + "suffix1" + sf_fM + "suffix2");
        test("C(87)25", "" + sf_o + s_b);
        test("C(87)25suffix", "" + sf_o + s_b + "suffix");
        test("prefixC(87)suffix125suffix2", "prefix" + sf_o + "suffix1" + s_b + "suffix2");
        test("C(87)null", "" + sf_o + f_oN);
        test("C(87)nullsuffix", "" + sf_o + f_oN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + f_oN + "suffix2");
        test("C(87)-1410065408", "" + sf_o + s_lM);
        test("C(87)-1410065408suffix", "" + sf_o + s_lM + "suffix");
        test("prefixC(87)suffix1-1410065408suffix2", "prefix" + sf_o + "suffix1" + s_lM + "suffix2");
        test("C(87)8.0", "" + sf_o + s_d);
        test("C(87)8.0suffix", "" + sf_o + s_d + "suffix");
        test("prefixC(87)suffix18.0suffix2", "prefix" + sf_o + "suffix1" + s_d + "suffix2");
        test("C(87)55.0", "" + sf_o + s_f);
        test("C(87)55.0suffix", "" + sf_o + s_f + "suffix");
        test("prefixC(87)suffix155.0suffix2", "prefix" + sf_o + "suffix1" + s_f + "suffix2");
        test("C(87)97000000", "" + sf_o + s_i);
        test("C(87)97000000suffix", "" + sf_o + s_i + "suffix");
        test("prefixC(87)suffix197000000suffix2", "prefix" + sf_o + "suffix1" + s_i + "suffix2");
        test("C(87)-9900", "" + sf_o + f_sM);
        test("C(87)-9900suffix", "" + sf_o + f_sM + "suffix");
        test("prefixC(87)suffix1-9900suffix2", "prefix" + sf_o + "suffix1" + f_sM + "suffix2");
        test("C(87)935228928", "" + sf_o + s_l);
        test("C(87)935228928suffix", "" + sf_o + s_l + "suffix");
        test("prefixC(87)suffix1935228928suffix2", "prefix" + sf_o + "suffix1" + s_l + "suffix2");
        test("C(87)-8400", "" + sf_o + sf_sM);
        test("C(87)-8400suffix", "" + sf_o + sf_sM + "suffix");
        test("prefixC(87)suffix1-8400suffix2", "prefix" + sf_o + "suffix1" + sf_sM + "suffix2");
        test("C(87)C(82)", "" + sf_o + s_o);
        test("C(87)C(82)suffix", "" + sf_o + s_o + "suffix");
        test("prefixC(87)suffix1C(82)suffix2", "prefix" + sf_o + "suffix1" + s_o + "suffix2");
        test("C(87)null", "" + sf_o + sf_oNtS);
        test("C(87)nullsuffix", "" + sf_o + sf_oNtS + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + sf_oNtS + "suffix2");
        test("C(87)true", "" + sf_o + s_bl);
        test("C(87)truesuffix", "" + sf_o + s_bl + "suffix");
        test("prefixC(87)suffix1truesuffix2", "prefix" + sf_o + "suffix1" + s_bl + "suffix2");
        test("C(87)3900", "" + sf_o + s_s);
        test("C(87)3900suffix", "" + sf_o + s_s + "suffix");
        test("prefixC(87)suffix13900suffix2", "prefix" + sf_o + "suffix1" + s_s + "suffix2");
        test("C(87)null", "" + sf_o + sf_oN);
        test("C(87)nullsuffix", "" + sf_o + sf_oN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + sf_oN + "suffix2");
        test("C(87)94000000", "" + sf_o + f_I);
        test("C(87)94000000suffix", "" + sf_o + f_I + "suffix");
        test("prefixC(87)suffix194000000suffix2", "prefix" + sf_o + "suffix1" + f_I + "suffix2");
        test("C(87)null", "" + sf_o + f_IN);
        test("C(87)nullsuffix", "" + sf_o + f_IN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + f_IN + "suffix2");
        test("C(87)true", "" + sf_o + sf_bl);
        test("C(87)truesuffix", "" + sf_o + sf_bl + "suffix");
        test("prefixC(87)suffix1truesuffix2", "prefix" + sf_o + "suffix1" + sf_bl + "suffix2");
        test("C(87)5500", "" + sf_o + sf_s);
        test("C(87)5500suffix", "" + sf_o + sf_s + "suffix");
        test("prefixC(87)suffix15500suffix2", "prefix" + sf_o + "suffix1" + sf_s + "suffix2");
        test("C(87)-2900", "" + sf_o + s_sM);
        test("C(87)-2900suffix", "" + sf_o + s_sM + "suffix");
        test("prefixC(87)suffix1-2900suffix2", "prefix" + sf_o + "suffix1" + s_sM + "suffix2");
        test("C(87)-194313216", "" + sf_o + sf_l);
        test("C(87)-194313216suffix", "" + sf_o + sf_l + "suffix");
        test("prefixC(87)suffix1-194313216suffix2", "prefix" + sf_o + "suffix1" + sf_l + "suffix2");
        test("C(87)12", "" + sf_o + s_strU1);
        test("C(87)12suffix", "" + sf_o + s_strU1 + "suffix");
        test("prefixC(87)suffix112suffix2", "prefix" + sf_o + "suffix1" + s_strU1 + "suffix2");
        test("C(87)C(87)", "" + sf_o + sf_o);
        test("C(87)C(87)suffix", "" + sf_o + sf_o + "suffix");
        test("prefixC(87)suffix1C(87)suffix2", "prefix" + sf_o + "suffix1" + sf_o + "suffix2");
        test("C(87)91", "" + sf_o + s_strU2);
        test("C(87)91suffix", "" + sf_o + s_strU2 + "suffix");
        test("prefixC(87)suffix191suffix2", "prefix" + sf_o + "suffix1" + s_strU2 + "suffix2");
        test("C(87)21", "" + sf_o + f_strU1);
        test("C(87)21suffix", "" + sf_o + f_strU1 + "suffix");
        test("prefixC(87)suffix121suffix2", "prefix" + sf_o + "suffix1" + f_strU1 + "suffix2");
        test("C(87)18", "" + sf_o + f_strU2);
        test("C(87)18suffix", "" + sf_o + f_strU2 + "suffix");
        test("prefixC(87)suffix118suffix2", "prefix" + sf_o + "suffix1" + f_strU2 + "suffix2");
        test("C(87)null", "" + sf_o + f_iAN);
        test("C(87)nullsuffix", "" + sf_o + f_iAN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + f_iAN + "suffix2");
        test("C(87)null", "" + sf_o + s_oN);
        test("C(87)nullsuffix", "" + sf_o + s_oN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + s_oN + "suffix2");
        test("C(87)\u045180", "" + sf_o + s_strU);
        test("C(87)\u045180suffix", "" + sf_o + s_strU + "suffix");
        test("prefixC(87)suffix1\u045180suffix2", "prefix" + sf_o + "suffix1" + s_strU + "suffix2");
        test("C(87)C", "" + sf_o + sf_c);
        test("C(87)Csuffix", "" + sf_o + sf_c + "suffix");
        test("prefixC(87)suffix1Csuffix2", "prefix" + sf_o + "suffix1" + sf_c + "suffix2");
        test("C(87)75", "" + sf_o + sf_str);
        test("C(87)75suffix", "" + sf_o + sf_str + "suffix");
        test("prefixC(87)suffix175suffix2", "prefix" + sf_o + "suffix1" + sf_str + "suffix2");
        test("C(87)-43", "" + sf_o + s_bM);
        test("C(87)-43suffix", "" + sf_o + s_bM + "suffix");
        test("prefixC(87)suffix1-43suffix2", "prefix" + sf_o + "suffix1" + s_bM + "suffix2");
        test("C(87)80", "" + sf_o + sf_b);
        test("C(87)80suffix", "" + sf_o + sf_b + "suffix");
        test("prefixC(87)suffix180suffix2", "prefix" + sf_o + "suffix1" + sf_b + "suffix2");
        test("C(87)null", "" + sf_o + s_IN);
        test("C(87)nullsuffix", "" + sf_o + s_IN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + s_IN + "suffix2");
        test("C(87)-52.0", "" + sf_o + s_fM);
        test("C(87)-52.0suffix", "" + sf_o + s_fM + "suffix");
        test("prefixC(87)suffix1-52.0suffix2", "prefix" + sf_o + "suffix1" + s_fM + "suffix2");
        test("C(87)75000000", "" + sf_o + sf_i);
        test("C(87)75000000suffix", "" + sf_o + sf_i + "suffix");
        test("prefixC(87)suffix175000000suffix2", "prefix" + sf_o + "suffix1" + sf_i + "suffix2");
        test("C(87)44", "" + sf_o + f_b);
        test("C(87)44suffix", "" + sf_o + f_b + "suffix");
        test("prefixC(87)suffix144suffix2", "prefix" + sf_o + "suffix1" + f_b + "suffix2");
        test("C(87)-1705032704", "" + sf_o + sf_lM);
        test("C(87)-1705032704suffix", "" + sf_o + sf_lM + "suffix");
        test("prefixC(87)suffix1-1705032704suffix2", "prefix" + sf_o + "suffix1" + sf_lM + "suffix2");
        test("C(87)null", "" + sf_o + f_oAN);
        test("C(87)nullsuffix", "" + sf_o + f_oAN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + f_oAN + "suffix2");
        test("C(87)83.0", "" + sf_o + f_d);
        test("C(87)83.0suffix", "" + sf_o + f_d + "suffix");
        test("prefixC(87)suffix183.0suffix2", "prefix" + sf_o + "suffix1" + f_d + "suffix2");
        test("C(87)I", "" + sf_o + f_c);
        test("C(87)Isuffix", "" + sf_o + f_c + "suffix");
        test("prefixC(87)suffix1Isuffix2", "prefix" + sf_o + "suffix1" + f_c + "suffix2");
        test("C(87)94.0", "" + sf_o + f_f);
        test("C(87)94.0suffix", "" + sf_o + f_f + "suffix");
        test("prefixC(87)suffix194.0suffix2", "prefix" + sf_o + "suffix1" + f_f + "suffix2");
        test("C(87)12.0", "" + sf_o + sf_d);
        test("C(87)12.0suffix", "" + sf_o + sf_d + "suffix");
        test("prefixC(87)suffix112.0suffix2", "prefix" + sf_o + "suffix1" + sf_d + "suffix2");
        test("C(87)-99.0", "" + sf_o + f_dM);
        test("C(87)-99.0suffix", "" + sf_o + f_dM + "suffix");
        test("prefixC(87)suffix1-99.0suffix2", "prefix" + sf_o + "suffix1" + f_dM + "suffix2");
        test("C(87)17.0", "" + sf_o + sf_f);
        test("C(87)17.0suffix", "" + sf_o + sf_f + "suffix");
        test("prefixC(87)suffix117.0suffix2", "prefix" + sf_o + "suffix1" + sf_f + "suffix2");
        test("C(87)-84.0", "" + sf_o + sf_dM);
        test("C(87)-84.0suffix", "" + sf_o + sf_dM + "suffix");
        test("prefixC(87)suffix1-84.0suffix2", "prefix" + sf_o + "suffix1" + sf_dM + "suffix2");
        test("C(87)58000000", "" + sf_o + f_i);
        test("C(87)58000000suffix", "" + sf_o + f_i + "suffix");
        test("prefixC(87)suffix158000000suffix2", "prefix" + sf_o + "suffix1" + f_i + "suffix2");
        test("C(87)-55000000", "" + sf_o + f_iM);
        test("C(87)-55000000suffix", "" + sf_o + f_iM + "suffix");
        test("prefixC(87)suffix1-55000000suffix2", "prefix" + sf_o + "suffix1" + f_iM + "suffix2");
        test("C(87)1460392448", "" + sf_o + f_l);
        test("C(87)1460392448suffix", "" + sf_o + f_l + "suffix");
        test("prefixC(87)suffix11460392448suffix2", "prefix" + sf_o + "suffix1" + f_l + "suffix2");
        test("C(87)C(70)", "" + sf_o + f_o);
        test("C(87)C(70)suffix", "" + sf_o + f_o + "suffix");
        test("prefixC(87)suffix1C(70)suffix2", "prefix" + sf_o + "suffix1" + f_o + "suffix2");
        test("C(87)\u04511", "" + sf_o + sf_strU);
        test("C(87)\u04511suffix", "" + sf_o + sf_strU + "suffix");
        test("prefixC(87)suffix1\u04511suffix2", "prefix" + sf_o + "suffix1" + sf_strU + "suffix2");
        test("C(87)8000", "" + sf_o + f_s);
        test("C(87)8000suffix", "" + sf_o + f_s + "suffix");
        test("prefixC(87)suffix18000suffix2", "prefix" + sf_o + "suffix1" + f_s + "suffix2");
        test("C(87)18", "" + sf_o + s_str);
        test("C(87)18suffix", "" + sf_o + s_str + "suffix");
        test("prefixC(87)suffix118suffix2", "prefix" + sf_o + "suffix1" + s_str + "suffix2");
        test("C(87)-1000000", "" + sf_o + s_iM);
        test("C(87)-1000000suffix", "" + sf_o + s_iM + "suffix");
        test("prefixC(87)suffix1-1000000suffix2", "prefix" + sf_o + "suffix1" + s_iM + "suffix2");
        test("C(87)1000000", "" + sf_o + sf_I);
        test("C(87)1000000suffix", "" + sf_o + sf_I + "suffix");
        test("prefixC(87)suffix11000000suffix2", "prefix" + sf_o + "suffix1" + sf_I + "suffix2");
        test("C(87)null", "" + sf_o + f_oNtS);
        test("C(87)nullsuffix", "" + sf_o + f_oNtS + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + f_oNtS + "suffix2");
        test("C(87)false", "" + sf_o + f_bl);
        test("C(87)falsesuffix", "" + sf_o + f_bl + "suffix");
        test("prefixC(87)suffix1falsesuffix2", "prefix" + sf_o + "suffix1" + f_bl + "suffix2");
        test("C(87)null", "" + sf_o + sf_iAN);
        test("C(87)nullsuffix", "" + sf_o + sf_iAN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + sf_iAN + "suffix2");
        test("C(87)-2000000", "" + sf_o + sf_iM);
        test("C(87)-2000000suffix", "" + sf_o + sf_iM + "suffix");
        test("prefixC(87)suffix1-2000000suffix2", "prefix" + sf_o + "suffix1" + sf_iM + "suffix2");
        test("C(87)-820130816", "" + sf_o + f_lM);
        test("C(87)-820130816suffix", "" + sf_o + f_lM + "suffix");
        test("prefixC(87)suffix1-820130816suffix2", "prefix" + sf_o + "suffix1" + f_lM + "suffix2");
        test("C(87)null", "" + sf_o + sf_oAN);
        test("C(87)nullsuffix", "" + sf_o + sf_oAN + "suffix");
        test("prefixC(87)suffix1nullsuffix2", "prefix" + sf_o + "suffix1" + sf_oAN + "suffix2");
        test("C(87)25000000", "" + sf_o + s_I);
        test("C(87)25000000suffix", "" + sf_o + s_I + "suffix");
        test("prefixC(87)suffix125000000suffix2", "prefix" + sf_o + "suffix1" + s_I + "suffix2");
        test("91-96.0", "" + s_strU2 + s_dM);
        test("91-96.0suffix", "" + s_strU2 + s_dM + "suffix");
        test("prefix91suffix1-96.0suffix2", "prefix" + s_strU2 + "suffix1" + s_dM + "suffix2");
        test("91null", "" + s_strU2 + s_oNtS);
        test("91nullsuffix", "" + s_strU2 + s_oNtS + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + s_oNtS + "suffix2");
        test("91\u045176", "" + s_strU2 + f_strU);
        test("91\u045176suffix", "" + s_strU2 + f_strU + "suffix");
        test("prefix91suffix1\u045176suffix2", "prefix" + s_strU2 + "suffix1" + f_strU + "suffix2");
        test("9192", "" + s_strU2 + sf_strU2);
        test("9192suffix", "" + s_strU2 + sf_strU2 + "suffix");
        test("prefix91suffix192suffix2", "prefix" + s_strU2 + "suffix1" + sf_strU2 + "suffix2");
        test("9151", "" + s_strU2 + sf_strU1);
        test("9151suffix", "" + s_strU2 + sf_strU1 + "suffix");
        test("prefix91suffix151suffix2", "prefix" + s_strU2 + "suffix1" + sf_strU1 + "suffix2");
        test("91null", "" + s_strU2 + s_iAN);
        test("91nullsuffix", "" + s_strU2 + s_iAN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + s_iAN + "suffix2");
        test("91-54", "" + s_strU2 + f_bM);
        test("91-54suffix", "" + s_strU2 + f_bM + "suffix");
        test("prefix91suffix1-54suffix2", "prefix" + s_strU2 + "suffix1" + f_bM + "suffix2");
        test("91-87.0", "" + s_strU2 + f_fM);
        test("91-87.0suffix", "" + s_strU2 + f_fM + "suffix");
        test("prefix91suffix1-87.0suffix2", "prefix" + s_strU2 + "suffix1" + f_fM + "suffix2");
        test("91null", "" + s_strU2 + s_oAN);
        test("91nullsuffix", "" + s_strU2 + s_oAN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + s_oAN + "suffix2");
        test("9119", "" + s_strU2 + f_str);
        test("9119suffix", "" + s_strU2 + f_str + "suffix");
        test("prefix91suffix119suffix2", "prefix" + s_strU2 + "suffix1" + f_str + "suffix2");
        test("91-41", "" + s_strU2 + sf_bM);
        test("91-41suffix", "" + s_strU2 + sf_bM + "suffix");
        test("prefix91suffix1-41suffix2", "prefix" + s_strU2 + "suffix1" + sf_bM + "suffix2");
        test("91null", "" + s_strU2 + sf_IN);
        test("91nullsuffix", "" + s_strU2 + sf_IN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + sf_IN + "suffix2");
        test("91T", "" + s_strU2 + s_c);
        test("91Tsuffix", "" + s_strU2 + s_c + "suffix");
        test("prefix91suffix1Tsuffix2", "prefix" + s_strU2 + "suffix1" + s_c + "suffix2");
        test("91-42.0", "" + s_strU2 + sf_fM);
        test("91-42.0suffix", "" + s_strU2 + sf_fM + "suffix");
        test("prefix91suffix1-42.0suffix2", "prefix" + s_strU2 + "suffix1" + sf_fM + "suffix2");
        test("9125", "" + s_strU2 + s_b);
        test("9125suffix", "" + s_strU2 + s_b + "suffix");
        test("prefix91suffix125suffix2", "prefix" + s_strU2 + "suffix1" + s_b + "suffix2");
        test("91null", "" + s_strU2 + f_oN);
        test("91nullsuffix", "" + s_strU2 + f_oN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + f_oN + "suffix2");
        test("91-1410065408", "" + s_strU2 + s_lM);
        test("91-1410065408suffix", "" + s_strU2 + s_lM + "suffix");
        test("prefix91suffix1-1410065408suffix2", "prefix" + s_strU2 + "suffix1" + s_lM + "suffix2");
        test("918.0", "" + s_strU2 + s_d);
        test("918.0suffix", "" + s_strU2 + s_d + "suffix");
        test("prefix91suffix18.0suffix2", "prefix" + s_strU2 + "suffix1" + s_d + "suffix2");
        test("9155.0", "" + s_strU2 + s_f);
        test("9155.0suffix", "" + s_strU2 + s_f + "suffix");
        test("prefix91suffix155.0suffix2", "prefix" + s_strU2 + "suffix1" + s_f + "suffix2");
        test("9197000000", "" + s_strU2 + s_i);
        test("9197000000suffix", "" + s_strU2 + s_i + "suffix");
        test("prefix91suffix197000000suffix2", "prefix" + s_strU2 + "suffix1" + s_i + "suffix2");
        test("91-9900", "" + s_strU2 + f_sM);
        test("91-9900suffix", "" + s_strU2 + f_sM + "suffix");
        test("prefix91suffix1-9900suffix2", "prefix" + s_strU2 + "suffix1" + f_sM + "suffix2");
        test("91935228928", "" + s_strU2 + s_l);
        test("91935228928suffix", "" + s_strU2 + s_l + "suffix");
        test("prefix91suffix1935228928suffix2", "prefix" + s_strU2 + "suffix1" + s_l + "suffix2");
        test("91-8400", "" + s_strU2 + sf_sM);
        test("91-8400suffix", "" + s_strU2 + sf_sM + "suffix");
        test("prefix91suffix1-8400suffix2", "prefix" + s_strU2 + "suffix1" + sf_sM + "suffix2");
        test("91C(82)", "" + s_strU2 + s_o);
        test("91C(82)suffix", "" + s_strU2 + s_o + "suffix");
        test("prefix91suffix1C(82)suffix2", "prefix" + s_strU2 + "suffix1" + s_o + "suffix2");
        test("91null", "" + s_strU2 + sf_oNtS);
        test("91nullsuffix", "" + s_strU2 + sf_oNtS + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + sf_oNtS + "suffix2");
        test("91true", "" + s_strU2 + s_bl);
        test("91truesuffix", "" + s_strU2 + s_bl + "suffix");
        test("prefix91suffix1truesuffix2", "prefix" + s_strU2 + "suffix1" + s_bl + "suffix2");
        test("913900", "" + s_strU2 + s_s);
        test("913900suffix", "" + s_strU2 + s_s + "suffix");
        test("prefix91suffix13900suffix2", "prefix" + s_strU2 + "suffix1" + s_s + "suffix2");
        test("91null", "" + s_strU2 + sf_oN);
        test("91nullsuffix", "" + s_strU2 + sf_oN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + sf_oN + "suffix2");
        test("9194000000", "" + s_strU2 + f_I);
        test("9194000000suffix", "" + s_strU2 + f_I + "suffix");
        test("prefix91suffix194000000suffix2", "prefix" + s_strU2 + "suffix1" + f_I + "suffix2");
        test("91null", "" + s_strU2 + f_IN);
        test("91nullsuffix", "" + s_strU2 + f_IN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + f_IN + "suffix2");
        test("91true", "" + s_strU2 + sf_bl);
        test("91truesuffix", "" + s_strU2 + sf_bl + "suffix");
        test("prefix91suffix1truesuffix2", "prefix" + s_strU2 + "suffix1" + sf_bl + "suffix2");
        test("915500", "" + s_strU2 + sf_s);
        test("915500suffix", "" + s_strU2 + sf_s + "suffix");
        test("prefix91suffix15500suffix2", "prefix" + s_strU2 + "suffix1" + sf_s + "suffix2");
        test("91-2900", "" + s_strU2 + s_sM);
        test("91-2900suffix", "" + s_strU2 + s_sM + "suffix");
        test("prefix91suffix1-2900suffix2", "prefix" + s_strU2 + "suffix1" + s_sM + "suffix2");
        test("91-194313216", "" + s_strU2 + sf_l);
        test("91-194313216suffix", "" + s_strU2 + sf_l + "suffix");
        test("prefix91suffix1-194313216suffix2", "prefix" + s_strU2 + "suffix1" + sf_l + "suffix2");
        test("9112", "" + s_strU2 + s_strU1);
        test("9112suffix", "" + s_strU2 + s_strU1 + "suffix");
        test("prefix91suffix112suffix2", "prefix" + s_strU2 + "suffix1" + s_strU1 + "suffix2");
        test("91C(87)", "" + s_strU2 + sf_o);
        test("91C(87)suffix", "" + s_strU2 + sf_o + "suffix");
        test("prefix91suffix1C(87)suffix2", "prefix" + s_strU2 + "suffix1" + sf_o + "suffix2");
        test("9191", "" + s_strU2 + s_strU2);
        test("9191suffix", "" + s_strU2 + s_strU2 + "suffix");
        test("prefix91suffix191suffix2", "prefix" + s_strU2 + "suffix1" + s_strU2 + "suffix2");
        test("9121", "" + s_strU2 + f_strU1);
        test("9121suffix", "" + s_strU2 + f_strU1 + "suffix");
        test("prefix91suffix121suffix2", "prefix" + s_strU2 + "suffix1" + f_strU1 + "suffix2");
        test("9118", "" + s_strU2 + f_strU2);
        test("9118suffix", "" + s_strU2 + f_strU2 + "suffix");
        test("prefix91suffix118suffix2", "prefix" + s_strU2 + "suffix1" + f_strU2 + "suffix2");
        test("91null", "" + s_strU2 + f_iAN);
        test("91nullsuffix", "" + s_strU2 + f_iAN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + f_iAN + "suffix2");
        test("91null", "" + s_strU2 + s_oN);
        test("91nullsuffix", "" + s_strU2 + s_oN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + s_oN + "suffix2");
        test("91\u045180", "" + s_strU2 + s_strU);
        test("91\u045180suffix", "" + s_strU2 + s_strU + "suffix");
        test("prefix91suffix1\u045180suffix2", "prefix" + s_strU2 + "suffix1" + s_strU + "suffix2");
        test("91C", "" + s_strU2 + sf_c);
        test("91Csuffix", "" + s_strU2 + sf_c + "suffix");
        test("prefix91suffix1Csuffix2", "prefix" + s_strU2 + "suffix1" + sf_c + "suffix2");
        test("9175", "" + s_strU2 + sf_str);
        test("9175suffix", "" + s_strU2 + sf_str + "suffix");
        test("prefix91suffix175suffix2", "prefix" + s_strU2 + "suffix1" + sf_str + "suffix2");
        test("91-43", "" + s_strU2 + s_bM);
        test("91-43suffix", "" + s_strU2 + s_bM + "suffix");
        test("prefix91suffix1-43suffix2", "prefix" + s_strU2 + "suffix1" + s_bM + "suffix2");
        test("9180", "" + s_strU2 + sf_b);
        test("9180suffix", "" + s_strU2 + sf_b + "suffix");
        test("prefix91suffix180suffix2", "prefix" + s_strU2 + "suffix1" + sf_b + "suffix2");
        test("91null", "" + s_strU2 + s_IN);
        test("91nullsuffix", "" + s_strU2 + s_IN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + s_IN + "suffix2");
        test("91-52.0", "" + s_strU2 + s_fM);
        test("91-52.0suffix", "" + s_strU2 + s_fM + "suffix");
        test("prefix91suffix1-52.0suffix2", "prefix" + s_strU2 + "suffix1" + s_fM + "suffix2");
        test("9175000000", "" + s_strU2 + sf_i);
        test("9175000000suffix", "" + s_strU2 + sf_i + "suffix");
        test("prefix91suffix175000000suffix2", "prefix" + s_strU2 + "suffix1" + sf_i + "suffix2");
        test("9144", "" + s_strU2 + f_b);
        test("9144suffix", "" + s_strU2 + f_b + "suffix");
        test("prefix91suffix144suffix2", "prefix" + s_strU2 + "suffix1" + f_b + "suffix2");
        test("91-1705032704", "" + s_strU2 + sf_lM);
        test("91-1705032704suffix", "" + s_strU2 + sf_lM + "suffix");
        test("prefix91suffix1-1705032704suffix2", "prefix" + s_strU2 + "suffix1" + sf_lM + "suffix2");
        test("91null", "" + s_strU2 + f_oAN);
        test("91nullsuffix", "" + s_strU2 + f_oAN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + f_oAN + "suffix2");
        test("9183.0", "" + s_strU2 + f_d);
        test("9183.0suffix", "" + s_strU2 + f_d + "suffix");
        test("prefix91suffix183.0suffix2", "prefix" + s_strU2 + "suffix1" + f_d + "suffix2");
        test("91I", "" + s_strU2 + f_c);
        test("91Isuffix", "" + s_strU2 + f_c + "suffix");
        test("prefix91suffix1Isuffix2", "prefix" + s_strU2 + "suffix1" + f_c + "suffix2");
        test("9194.0", "" + s_strU2 + f_f);
        test("9194.0suffix", "" + s_strU2 + f_f + "suffix");
        test("prefix91suffix194.0suffix2", "prefix" + s_strU2 + "suffix1" + f_f + "suffix2");
        test("9112.0", "" + s_strU2 + sf_d);
        test("9112.0suffix", "" + s_strU2 + sf_d + "suffix");
        test("prefix91suffix112.0suffix2", "prefix" + s_strU2 + "suffix1" + sf_d + "suffix2");
        test("91-99.0", "" + s_strU2 + f_dM);
        test("91-99.0suffix", "" + s_strU2 + f_dM + "suffix");
        test("prefix91suffix1-99.0suffix2", "prefix" + s_strU2 + "suffix1" + f_dM + "suffix2");
        test("9117.0", "" + s_strU2 + sf_f);
        test("9117.0suffix", "" + s_strU2 + sf_f + "suffix");
        test("prefix91suffix117.0suffix2", "prefix" + s_strU2 + "suffix1" + sf_f + "suffix2");
        test("91-84.0", "" + s_strU2 + sf_dM);
        test("91-84.0suffix", "" + s_strU2 + sf_dM + "suffix");
        test("prefix91suffix1-84.0suffix2", "prefix" + s_strU2 + "suffix1" + sf_dM + "suffix2");
        test("9158000000", "" + s_strU2 + f_i);
        test("9158000000suffix", "" + s_strU2 + f_i + "suffix");
        test("prefix91suffix158000000suffix2", "prefix" + s_strU2 + "suffix1" + f_i + "suffix2");
        test("91-55000000", "" + s_strU2 + f_iM);
        test("91-55000000suffix", "" + s_strU2 + f_iM + "suffix");
        test("prefix91suffix1-55000000suffix2", "prefix" + s_strU2 + "suffix1" + f_iM + "suffix2");
        test("911460392448", "" + s_strU2 + f_l);
        test("911460392448suffix", "" + s_strU2 + f_l + "suffix");
        test("prefix91suffix11460392448suffix2", "prefix" + s_strU2 + "suffix1" + f_l + "suffix2");
        test("91C(70)", "" + s_strU2 + f_o);
        test("91C(70)suffix", "" + s_strU2 + f_o + "suffix");
        test("prefix91suffix1C(70)suffix2", "prefix" + s_strU2 + "suffix1" + f_o + "suffix2");
        test("91\u04511", "" + s_strU2 + sf_strU);
        test("91\u04511suffix", "" + s_strU2 + sf_strU + "suffix");
        test("prefix91suffix1\u04511suffix2", "prefix" + s_strU2 + "suffix1" + sf_strU + "suffix2");
        test("918000", "" + s_strU2 + f_s);
        test("918000suffix", "" + s_strU2 + f_s + "suffix");
        test("prefix91suffix18000suffix2", "prefix" + s_strU2 + "suffix1" + f_s + "suffix2");
        test("9118", "" + s_strU2 + s_str);
        test("9118suffix", "" + s_strU2 + s_str + "suffix");
        test("prefix91suffix118suffix2", "prefix" + s_strU2 + "suffix1" + s_str + "suffix2");
        test("91-1000000", "" + s_strU2 + s_iM);
        test("91-1000000suffix", "" + s_strU2 + s_iM + "suffix");
        test("prefix91suffix1-1000000suffix2", "prefix" + s_strU2 + "suffix1" + s_iM + "suffix2");
        test("911000000", "" + s_strU2 + sf_I);
        test("911000000suffix", "" + s_strU2 + sf_I + "suffix");
        test("prefix91suffix11000000suffix2", "prefix" + s_strU2 + "suffix1" + sf_I + "suffix2");
        test("91null", "" + s_strU2 + f_oNtS);
        test("91nullsuffix", "" + s_strU2 + f_oNtS + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + f_oNtS + "suffix2");
        test("91false", "" + s_strU2 + f_bl);
        test("91falsesuffix", "" + s_strU2 + f_bl + "suffix");
        test("prefix91suffix1falsesuffix2", "prefix" + s_strU2 + "suffix1" + f_bl + "suffix2");
        test("91null", "" + s_strU2 + sf_iAN);
        test("91nullsuffix", "" + s_strU2 + sf_iAN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + sf_iAN + "suffix2");
        test("91-2000000", "" + s_strU2 + sf_iM);
        test("91-2000000suffix", "" + s_strU2 + sf_iM + "suffix");
        test("prefix91suffix1-2000000suffix2", "prefix" + s_strU2 + "suffix1" + sf_iM + "suffix2");
        test("91-820130816", "" + s_strU2 + f_lM);
        test("91-820130816suffix", "" + s_strU2 + f_lM + "suffix");
        test("prefix91suffix1-820130816suffix2", "prefix" + s_strU2 + "suffix1" + f_lM + "suffix2");
        test("91null", "" + s_strU2 + sf_oAN);
        test("91nullsuffix", "" + s_strU2 + sf_oAN + "suffix");
        test("prefix91suffix1nullsuffix2", "prefix" + s_strU2 + "suffix1" + sf_oAN + "suffix2");
        test("9125000000", "" + s_strU2 + s_I);
        test("9125000000suffix", "" + s_strU2 + s_I + "suffix");
        test("prefix91suffix125000000suffix2", "prefix" + s_strU2 + "suffix1" + s_I + "suffix2");
        test("21-96.0", "" + f_strU1 + s_dM);
        test("21-96.0suffix", "" + f_strU1 + s_dM + "suffix");
        test("prefix21suffix1-96.0suffix2", "prefix" + f_strU1 + "suffix1" + s_dM + "suffix2");
        test("21null", "" + f_strU1 + s_oNtS);
        test("21nullsuffix", "" + f_strU1 + s_oNtS + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + s_oNtS + "suffix2");
        test("21\u045176", "" + f_strU1 + f_strU);
        test("21\u045176suffix", "" + f_strU1 + f_strU + "suffix");
        test("prefix21suffix1\u045176suffix2", "prefix" + f_strU1 + "suffix1" + f_strU + "suffix2");
        test("2192", "" + f_strU1 + sf_strU2);
        test("2192suffix", "" + f_strU1 + sf_strU2 + "suffix");
        test("prefix21suffix192suffix2", "prefix" + f_strU1 + "suffix1" + sf_strU2 + "suffix2");
        test("2151", "" + f_strU1 + sf_strU1);
        test("2151suffix", "" + f_strU1 + sf_strU1 + "suffix");
        test("prefix21suffix151suffix2", "prefix" + f_strU1 + "suffix1" + sf_strU1 + "suffix2");
        test("21null", "" + f_strU1 + s_iAN);
        test("21nullsuffix", "" + f_strU1 + s_iAN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + s_iAN + "suffix2");
        test("21-54", "" + f_strU1 + f_bM);
        test("21-54suffix", "" + f_strU1 + f_bM + "suffix");
        test("prefix21suffix1-54suffix2", "prefix" + f_strU1 + "suffix1" + f_bM + "suffix2");
        test("21-87.0", "" + f_strU1 + f_fM);
        test("21-87.0suffix", "" + f_strU1 + f_fM + "suffix");
        test("prefix21suffix1-87.0suffix2", "prefix" + f_strU1 + "suffix1" + f_fM + "suffix2");
        test("21null", "" + f_strU1 + s_oAN);
        test("21nullsuffix", "" + f_strU1 + s_oAN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + s_oAN + "suffix2");
        test("2119", "" + f_strU1 + f_str);
        test("2119suffix", "" + f_strU1 + f_str + "suffix");
        test("prefix21suffix119suffix2", "prefix" + f_strU1 + "suffix1" + f_str + "suffix2");
        test("21-41", "" + f_strU1 + sf_bM);
        test("21-41suffix", "" + f_strU1 + sf_bM + "suffix");
        test("prefix21suffix1-41suffix2", "prefix" + f_strU1 + "suffix1" + sf_bM + "suffix2");
        test("21null", "" + f_strU1 + sf_IN);
        test("21nullsuffix", "" + f_strU1 + sf_IN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + sf_IN + "suffix2");
        test("21T", "" + f_strU1 + s_c);
        test("21Tsuffix", "" + f_strU1 + s_c + "suffix");
        test("prefix21suffix1Tsuffix2", "prefix" + f_strU1 + "suffix1" + s_c + "suffix2");
        test("21-42.0", "" + f_strU1 + sf_fM);
        test("21-42.0suffix", "" + f_strU1 + sf_fM + "suffix");
        test("prefix21suffix1-42.0suffix2", "prefix" + f_strU1 + "suffix1" + sf_fM + "suffix2");
        test("2125", "" + f_strU1 + s_b);
        test("2125suffix", "" + f_strU1 + s_b + "suffix");
        test("prefix21suffix125suffix2", "prefix" + f_strU1 + "suffix1" + s_b + "suffix2");
        test("21null", "" + f_strU1 + f_oN);
        test("21nullsuffix", "" + f_strU1 + f_oN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + f_oN + "suffix2");
        test("21-1410065408", "" + f_strU1 + s_lM);
        test("21-1410065408suffix", "" + f_strU1 + s_lM + "suffix");
        test("prefix21suffix1-1410065408suffix2", "prefix" + f_strU1 + "suffix1" + s_lM + "suffix2");
        test("218.0", "" + f_strU1 + s_d);
        test("218.0suffix", "" + f_strU1 + s_d + "suffix");
        test("prefix21suffix18.0suffix2", "prefix" + f_strU1 + "suffix1" + s_d + "suffix2");
        test("2155.0", "" + f_strU1 + s_f);
        test("2155.0suffix", "" + f_strU1 + s_f + "suffix");
        test("prefix21suffix155.0suffix2", "prefix" + f_strU1 + "suffix1" + s_f + "suffix2");
        test("2197000000", "" + f_strU1 + s_i);
        test("2197000000suffix", "" + f_strU1 + s_i + "suffix");
        test("prefix21suffix197000000suffix2", "prefix" + f_strU1 + "suffix1" + s_i + "suffix2");
        test("21-9900", "" + f_strU1 + f_sM);
        test("21-9900suffix", "" + f_strU1 + f_sM + "suffix");
        test("prefix21suffix1-9900suffix2", "prefix" + f_strU1 + "suffix1" + f_sM + "suffix2");
        test("21935228928", "" + f_strU1 + s_l);
        test("21935228928suffix", "" + f_strU1 + s_l + "suffix");
        test("prefix21suffix1935228928suffix2", "prefix" + f_strU1 + "suffix1" + s_l + "suffix2");
        test("21-8400", "" + f_strU1 + sf_sM);
        test("21-8400suffix", "" + f_strU1 + sf_sM + "suffix");
        test("prefix21suffix1-8400suffix2", "prefix" + f_strU1 + "suffix1" + sf_sM + "suffix2");
        test("21C(82)", "" + f_strU1 + s_o);
        test("21C(82)suffix", "" + f_strU1 + s_o + "suffix");
        test("prefix21suffix1C(82)suffix2", "prefix" + f_strU1 + "suffix1" + s_o + "suffix2");
        test("21null", "" + f_strU1 + sf_oNtS);
        test("21nullsuffix", "" + f_strU1 + sf_oNtS + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + sf_oNtS + "suffix2");
        test("21true", "" + f_strU1 + s_bl);
        test("21truesuffix", "" + f_strU1 + s_bl + "suffix");
        test("prefix21suffix1truesuffix2", "prefix" + f_strU1 + "suffix1" + s_bl + "suffix2");
        test("213900", "" + f_strU1 + s_s);
        test("213900suffix", "" + f_strU1 + s_s + "suffix");
        test("prefix21suffix13900suffix2", "prefix" + f_strU1 + "suffix1" + s_s + "suffix2");
        test("21null", "" + f_strU1 + sf_oN);
        test("21nullsuffix", "" + f_strU1 + sf_oN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + sf_oN + "suffix2");
        test("2194000000", "" + f_strU1 + f_I);
        test("2194000000suffix", "" + f_strU1 + f_I + "suffix");
        test("prefix21suffix194000000suffix2", "prefix" + f_strU1 + "suffix1" + f_I + "suffix2");
        test("21null", "" + f_strU1 + f_IN);
        test("21nullsuffix", "" + f_strU1 + f_IN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + f_IN + "suffix2");
        test("21true", "" + f_strU1 + sf_bl);
        test("21truesuffix", "" + f_strU1 + sf_bl + "suffix");
        test("prefix21suffix1truesuffix2", "prefix" + f_strU1 + "suffix1" + sf_bl + "suffix2");
        test("215500", "" + f_strU1 + sf_s);
        test("215500suffix", "" + f_strU1 + sf_s + "suffix");
        test("prefix21suffix15500suffix2", "prefix" + f_strU1 + "suffix1" + sf_s + "suffix2");
        test("21-2900", "" + f_strU1 + s_sM);
        test("21-2900suffix", "" + f_strU1 + s_sM + "suffix");
        test("prefix21suffix1-2900suffix2", "prefix" + f_strU1 + "suffix1" + s_sM + "suffix2");
        test("21-194313216", "" + f_strU1 + sf_l);
        test("21-194313216suffix", "" + f_strU1 + sf_l + "suffix");
        test("prefix21suffix1-194313216suffix2", "prefix" + f_strU1 + "suffix1" + sf_l + "suffix2");
        test("2112", "" + f_strU1 + s_strU1);
        test("2112suffix", "" + f_strU1 + s_strU1 + "suffix");
        test("prefix21suffix112suffix2", "prefix" + f_strU1 + "suffix1" + s_strU1 + "suffix2");
        test("21C(87)", "" + f_strU1 + sf_o);
        test("21C(87)suffix", "" + f_strU1 + sf_o + "suffix");
        test("prefix21suffix1C(87)suffix2", "prefix" + f_strU1 + "suffix1" + sf_o + "suffix2");
        test("2191", "" + f_strU1 + s_strU2);
        test("2191suffix", "" + f_strU1 + s_strU2 + "suffix");
        test("prefix21suffix191suffix2", "prefix" + f_strU1 + "suffix1" + s_strU2 + "suffix2");
        test("2121", "" + f_strU1 + f_strU1);
        test("2121suffix", "" + f_strU1 + f_strU1 + "suffix");
        test("prefix21suffix121suffix2", "prefix" + f_strU1 + "suffix1" + f_strU1 + "suffix2");
        test("2118", "" + f_strU1 + f_strU2);
        test("2118suffix", "" + f_strU1 + f_strU2 + "suffix");
        test("prefix21suffix118suffix2", "prefix" + f_strU1 + "suffix1" + f_strU2 + "suffix2");
        test("21null", "" + f_strU1 + f_iAN);
        test("21nullsuffix", "" + f_strU1 + f_iAN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + f_iAN + "suffix2");
        test("21null", "" + f_strU1 + s_oN);
        test("21nullsuffix", "" + f_strU1 + s_oN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + s_oN + "suffix2");
        test("21\u045180", "" + f_strU1 + s_strU);
        test("21\u045180suffix", "" + f_strU1 + s_strU + "suffix");
        test("prefix21suffix1\u045180suffix2", "prefix" + f_strU1 + "suffix1" + s_strU + "suffix2");
        test("21C", "" + f_strU1 + sf_c);
        test("21Csuffix", "" + f_strU1 + sf_c + "suffix");
        test("prefix21suffix1Csuffix2", "prefix" + f_strU1 + "suffix1" + sf_c + "suffix2");
        test("2175", "" + f_strU1 + sf_str);
        test("2175suffix", "" + f_strU1 + sf_str + "suffix");
        test("prefix21suffix175suffix2", "prefix" + f_strU1 + "suffix1" + sf_str + "suffix2");
        test("21-43", "" + f_strU1 + s_bM);
        test("21-43suffix", "" + f_strU1 + s_bM + "suffix");
        test("prefix21suffix1-43suffix2", "prefix" + f_strU1 + "suffix1" + s_bM + "suffix2");
        test("2180", "" + f_strU1 + sf_b);
        test("2180suffix", "" + f_strU1 + sf_b + "suffix");
        test("prefix21suffix180suffix2", "prefix" + f_strU1 + "suffix1" + sf_b + "suffix2");
        test("21null", "" + f_strU1 + s_IN);
        test("21nullsuffix", "" + f_strU1 + s_IN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + s_IN + "suffix2");
        test("21-52.0", "" + f_strU1 + s_fM);
        test("21-52.0suffix", "" + f_strU1 + s_fM + "suffix");
        test("prefix21suffix1-52.0suffix2", "prefix" + f_strU1 + "suffix1" + s_fM + "suffix2");
        test("2175000000", "" + f_strU1 + sf_i);
        test("2175000000suffix", "" + f_strU1 + sf_i + "suffix");
        test("prefix21suffix175000000suffix2", "prefix" + f_strU1 + "suffix1" + sf_i + "suffix2");
        test("2144", "" + f_strU1 + f_b);
        test("2144suffix", "" + f_strU1 + f_b + "suffix");
        test("prefix21suffix144suffix2", "prefix" + f_strU1 + "suffix1" + f_b + "suffix2");
        test("21-1705032704", "" + f_strU1 + sf_lM);
        test("21-1705032704suffix", "" + f_strU1 + sf_lM + "suffix");
        test("prefix21suffix1-1705032704suffix2", "prefix" + f_strU1 + "suffix1" + sf_lM + "suffix2");
        test("21null", "" + f_strU1 + f_oAN);
        test("21nullsuffix", "" + f_strU1 + f_oAN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + f_oAN + "suffix2");
        test("2183.0", "" + f_strU1 + f_d);
        test("2183.0suffix", "" + f_strU1 + f_d + "suffix");
        test("prefix21suffix183.0suffix2", "prefix" + f_strU1 + "suffix1" + f_d + "suffix2");
        test("21I", "" + f_strU1 + f_c);
        test("21Isuffix", "" + f_strU1 + f_c + "suffix");
        test("prefix21suffix1Isuffix2", "prefix" + f_strU1 + "suffix1" + f_c + "suffix2");
        test("2194.0", "" + f_strU1 + f_f);
        test("2194.0suffix", "" + f_strU1 + f_f + "suffix");
        test("prefix21suffix194.0suffix2", "prefix" + f_strU1 + "suffix1" + f_f + "suffix2");
        test("2112.0", "" + f_strU1 + sf_d);
        test("2112.0suffix", "" + f_strU1 + sf_d + "suffix");
        test("prefix21suffix112.0suffix2", "prefix" + f_strU1 + "suffix1" + sf_d + "suffix2");
        test("21-99.0", "" + f_strU1 + f_dM);
        test("21-99.0suffix", "" + f_strU1 + f_dM + "suffix");
        test("prefix21suffix1-99.0suffix2", "prefix" + f_strU1 + "suffix1" + f_dM + "suffix2");
        test("2117.0", "" + f_strU1 + sf_f);
        test("2117.0suffix", "" + f_strU1 + sf_f + "suffix");
        test("prefix21suffix117.0suffix2", "prefix" + f_strU1 + "suffix1" + sf_f + "suffix2");
        test("21-84.0", "" + f_strU1 + sf_dM);
        test("21-84.0suffix", "" + f_strU1 + sf_dM + "suffix");
        test("prefix21suffix1-84.0suffix2", "prefix" + f_strU1 + "suffix1" + sf_dM + "suffix2");
        test("2158000000", "" + f_strU1 + f_i);
        test("2158000000suffix", "" + f_strU1 + f_i + "suffix");
        test("prefix21suffix158000000suffix2", "prefix" + f_strU1 + "suffix1" + f_i + "suffix2");
        test("21-55000000", "" + f_strU1 + f_iM);
        test("21-55000000suffix", "" + f_strU1 + f_iM + "suffix");
        test("prefix21suffix1-55000000suffix2", "prefix" + f_strU1 + "suffix1" + f_iM + "suffix2");
        test("211460392448", "" + f_strU1 + f_l);
        test("211460392448suffix", "" + f_strU1 + f_l + "suffix");
        test("prefix21suffix11460392448suffix2", "prefix" + f_strU1 + "suffix1" + f_l + "suffix2");
        test("21C(70)", "" + f_strU1 + f_o);
        test("21C(70)suffix", "" + f_strU1 + f_o + "suffix");
        test("prefix21suffix1C(70)suffix2", "prefix" + f_strU1 + "suffix1" + f_o + "suffix2");
        test("21\u04511", "" + f_strU1 + sf_strU);
        test("21\u04511suffix", "" + f_strU1 + sf_strU + "suffix");
        test("prefix21suffix1\u04511suffix2", "prefix" + f_strU1 + "suffix1" + sf_strU + "suffix2");
        test("218000", "" + f_strU1 + f_s);
        test("218000suffix", "" + f_strU1 + f_s + "suffix");
        test("prefix21suffix18000suffix2", "prefix" + f_strU1 + "suffix1" + f_s + "suffix2");
        test("2118", "" + f_strU1 + s_str);
        test("2118suffix", "" + f_strU1 + s_str + "suffix");
        test("prefix21suffix118suffix2", "prefix" + f_strU1 + "suffix1" + s_str + "suffix2");
        test("21-1000000", "" + f_strU1 + s_iM);
        test("21-1000000suffix", "" + f_strU1 + s_iM + "suffix");
        test("prefix21suffix1-1000000suffix2", "prefix" + f_strU1 + "suffix1" + s_iM + "suffix2");
        test("211000000", "" + f_strU1 + sf_I);
        test("211000000suffix", "" + f_strU1 + sf_I + "suffix");
        test("prefix21suffix11000000suffix2", "prefix" + f_strU1 + "suffix1" + sf_I + "suffix2");
        test("21null", "" + f_strU1 + f_oNtS);
        test("21nullsuffix", "" + f_strU1 + f_oNtS + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + f_oNtS + "suffix2");
        test("21false", "" + f_strU1 + f_bl);
        test("21falsesuffix", "" + f_strU1 + f_bl + "suffix");
        test("prefix21suffix1falsesuffix2", "prefix" + f_strU1 + "suffix1" + f_bl + "suffix2");
        test("21null", "" + f_strU1 + sf_iAN);
        test("21nullsuffix", "" + f_strU1 + sf_iAN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + sf_iAN + "suffix2");
        test("21-2000000", "" + f_strU1 + sf_iM);
        test("21-2000000suffix", "" + f_strU1 + sf_iM + "suffix");
        test("prefix21suffix1-2000000suffix2", "prefix" + f_strU1 + "suffix1" + sf_iM + "suffix2");
        test("21-820130816", "" + f_strU1 + f_lM);
        test("21-820130816suffix", "" + f_strU1 + f_lM + "suffix");
        test("prefix21suffix1-820130816suffix2", "prefix" + f_strU1 + "suffix1" + f_lM + "suffix2");
        test("21null", "" + f_strU1 + sf_oAN);
        test("21nullsuffix", "" + f_strU1 + sf_oAN + "suffix");
        test("prefix21suffix1nullsuffix2", "prefix" + f_strU1 + "suffix1" + sf_oAN + "suffix2");
        test("2125000000", "" + f_strU1 + s_I);
        test("2125000000suffix", "" + f_strU1 + s_I + "suffix");
        test("prefix21suffix125000000suffix2", "prefix" + f_strU1 + "suffix1" + s_I + "suffix2");
        test("18-96.0", "" + f_strU2 + s_dM);
        test("18-96.0suffix", "" + f_strU2 + s_dM + "suffix");
        test("prefix18suffix1-96.0suffix2", "prefix" + f_strU2 + "suffix1" + s_dM + "suffix2");
        test("18null", "" + f_strU2 + s_oNtS);
        test("18nullsuffix", "" + f_strU2 + s_oNtS + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + s_oNtS + "suffix2");
        test("18\u045176", "" + f_strU2 + f_strU);
        test("18\u045176suffix", "" + f_strU2 + f_strU + "suffix");
        test("prefix18suffix1\u045176suffix2", "prefix" + f_strU2 + "suffix1" + f_strU + "suffix2");
        test("1892", "" + f_strU2 + sf_strU2);
        test("1892suffix", "" + f_strU2 + sf_strU2 + "suffix");
        test("prefix18suffix192suffix2", "prefix" + f_strU2 + "suffix1" + sf_strU2 + "suffix2");
        test("1851", "" + f_strU2 + sf_strU1);
        test("1851suffix", "" + f_strU2 + sf_strU1 + "suffix");
        test("prefix18suffix151suffix2", "prefix" + f_strU2 + "suffix1" + sf_strU1 + "suffix2");
        test("18null", "" + f_strU2 + s_iAN);
        test("18nullsuffix", "" + f_strU2 + s_iAN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + s_iAN + "suffix2");
        test("18-54", "" + f_strU2 + f_bM);
        test("18-54suffix", "" + f_strU2 + f_bM + "suffix");
        test("prefix18suffix1-54suffix2", "prefix" + f_strU2 + "suffix1" + f_bM + "suffix2");
        test("18-87.0", "" + f_strU2 + f_fM);
        test("18-87.0suffix", "" + f_strU2 + f_fM + "suffix");
        test("prefix18suffix1-87.0suffix2", "prefix" + f_strU2 + "suffix1" + f_fM + "suffix2");
        test("18null", "" + f_strU2 + s_oAN);
        test("18nullsuffix", "" + f_strU2 + s_oAN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + s_oAN + "suffix2");
        test("1819", "" + f_strU2 + f_str);
        test("1819suffix", "" + f_strU2 + f_str + "suffix");
        test("prefix18suffix119suffix2", "prefix" + f_strU2 + "suffix1" + f_str + "suffix2");
        test("18-41", "" + f_strU2 + sf_bM);
        test("18-41suffix", "" + f_strU2 + sf_bM + "suffix");
        test("prefix18suffix1-41suffix2", "prefix" + f_strU2 + "suffix1" + sf_bM + "suffix2");
        test("18null", "" + f_strU2 + sf_IN);
        test("18nullsuffix", "" + f_strU2 + sf_IN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + sf_IN + "suffix2");
        test("18T", "" + f_strU2 + s_c);
        test("18Tsuffix", "" + f_strU2 + s_c + "suffix");
        test("prefix18suffix1Tsuffix2", "prefix" + f_strU2 + "suffix1" + s_c + "suffix2");
        test("18-42.0", "" + f_strU2 + sf_fM);
        test("18-42.0suffix", "" + f_strU2 + sf_fM + "suffix");
        test("prefix18suffix1-42.0suffix2", "prefix" + f_strU2 + "suffix1" + sf_fM + "suffix2");
        test("1825", "" + f_strU2 + s_b);
        test("1825suffix", "" + f_strU2 + s_b + "suffix");
        test("prefix18suffix125suffix2", "prefix" + f_strU2 + "suffix1" + s_b + "suffix2");
        test("18null", "" + f_strU2 + f_oN);
        test("18nullsuffix", "" + f_strU2 + f_oN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + f_oN + "suffix2");
        test("18-1410065408", "" + f_strU2 + s_lM);
        test("18-1410065408suffix", "" + f_strU2 + s_lM + "suffix");
        test("prefix18suffix1-1410065408suffix2", "prefix" + f_strU2 + "suffix1" + s_lM + "suffix2");
        test("188.0", "" + f_strU2 + s_d);
        test("188.0suffix", "" + f_strU2 + s_d + "suffix");
        test("prefix18suffix18.0suffix2", "prefix" + f_strU2 + "suffix1" + s_d + "suffix2");
        test("1855.0", "" + f_strU2 + s_f);
        test("1855.0suffix", "" + f_strU2 + s_f + "suffix");
        test("prefix18suffix155.0suffix2", "prefix" + f_strU2 + "suffix1" + s_f + "suffix2");
        test("1897000000", "" + f_strU2 + s_i);
        test("1897000000suffix", "" + f_strU2 + s_i + "suffix");
        test("prefix18suffix197000000suffix2", "prefix" + f_strU2 + "suffix1" + s_i + "suffix2");
        test("18-9900", "" + f_strU2 + f_sM);
        test("18-9900suffix", "" + f_strU2 + f_sM + "suffix");
        test("prefix18suffix1-9900suffix2", "prefix" + f_strU2 + "suffix1" + f_sM + "suffix2");
        test("18935228928", "" + f_strU2 + s_l);
        test("18935228928suffix", "" + f_strU2 + s_l + "suffix");
        test("prefix18suffix1935228928suffix2", "prefix" + f_strU2 + "suffix1" + s_l + "suffix2");
        test("18-8400", "" + f_strU2 + sf_sM);
        test("18-8400suffix", "" + f_strU2 + sf_sM + "suffix");
        test("prefix18suffix1-8400suffix2", "prefix" + f_strU2 + "suffix1" + sf_sM + "suffix2");
        test("18C(82)", "" + f_strU2 + s_o);
        test("18C(82)suffix", "" + f_strU2 + s_o + "suffix");
        test("prefix18suffix1C(82)suffix2", "prefix" + f_strU2 + "suffix1" + s_o + "suffix2");
        test("18null", "" + f_strU2 + sf_oNtS);
        test("18nullsuffix", "" + f_strU2 + sf_oNtS + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + sf_oNtS + "suffix2");
        test("18true", "" + f_strU2 + s_bl);
        test("18truesuffix", "" + f_strU2 + s_bl + "suffix");
        test("prefix18suffix1truesuffix2", "prefix" + f_strU2 + "suffix1" + s_bl + "suffix2");
        test("183900", "" + f_strU2 + s_s);
        test("183900suffix", "" + f_strU2 + s_s + "suffix");
        test("prefix18suffix13900suffix2", "prefix" + f_strU2 + "suffix1" + s_s + "suffix2");
        test("18null", "" + f_strU2 + sf_oN);
        test("18nullsuffix", "" + f_strU2 + sf_oN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + sf_oN + "suffix2");
        test("1894000000", "" + f_strU2 + f_I);
        test("1894000000suffix", "" + f_strU2 + f_I + "suffix");
        test("prefix18suffix194000000suffix2", "prefix" + f_strU2 + "suffix1" + f_I + "suffix2");
        test("18null", "" + f_strU2 + f_IN);
        test("18nullsuffix", "" + f_strU2 + f_IN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + f_IN + "suffix2");
        test("18true", "" + f_strU2 + sf_bl);
        test("18truesuffix", "" + f_strU2 + sf_bl + "suffix");
        test("prefix18suffix1truesuffix2", "prefix" + f_strU2 + "suffix1" + sf_bl + "suffix2");
        test("185500", "" + f_strU2 + sf_s);
        test("185500suffix", "" + f_strU2 + sf_s + "suffix");
        test("prefix18suffix15500suffix2", "prefix" + f_strU2 + "suffix1" + sf_s + "suffix2");
        test("18-2900", "" + f_strU2 + s_sM);
        test("18-2900suffix", "" + f_strU2 + s_sM + "suffix");
        test("prefix18suffix1-2900suffix2", "prefix" + f_strU2 + "suffix1" + s_sM + "suffix2");
        test("18-194313216", "" + f_strU2 + sf_l);
        test("18-194313216suffix", "" + f_strU2 + sf_l + "suffix");
        test("prefix18suffix1-194313216suffix2", "prefix" + f_strU2 + "suffix1" + sf_l + "suffix2");
        test("1812", "" + f_strU2 + s_strU1);
        test("1812suffix", "" + f_strU2 + s_strU1 + "suffix");
        test("prefix18suffix112suffix2", "prefix" + f_strU2 + "suffix1" + s_strU1 + "suffix2");
        test("18C(87)", "" + f_strU2 + sf_o);
        test("18C(87)suffix", "" + f_strU2 + sf_o + "suffix");
        test("prefix18suffix1C(87)suffix2", "prefix" + f_strU2 + "suffix1" + sf_o + "suffix2");
        test("1891", "" + f_strU2 + s_strU2);
        test("1891suffix", "" + f_strU2 + s_strU2 + "suffix");
        test("prefix18suffix191suffix2", "prefix" + f_strU2 + "suffix1" + s_strU2 + "suffix2");
        test("1821", "" + f_strU2 + f_strU1);
        test("1821suffix", "" + f_strU2 + f_strU1 + "suffix");
        test("prefix18suffix121suffix2", "prefix" + f_strU2 + "suffix1" + f_strU1 + "suffix2");
        test("1818", "" + f_strU2 + f_strU2);
        test("1818suffix", "" + f_strU2 + f_strU2 + "suffix");
        test("prefix18suffix118suffix2", "prefix" + f_strU2 + "suffix1" + f_strU2 + "suffix2");
        test("18null", "" + f_strU2 + f_iAN);
        test("18nullsuffix", "" + f_strU2 + f_iAN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + f_iAN + "suffix2");
        test("18null", "" + f_strU2 + s_oN);
        test("18nullsuffix", "" + f_strU2 + s_oN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + s_oN + "suffix2");
        test("18\u045180", "" + f_strU2 + s_strU);
        test("18\u045180suffix", "" + f_strU2 + s_strU + "suffix");
        test("prefix18suffix1\u045180suffix2", "prefix" + f_strU2 + "suffix1" + s_strU + "suffix2");
        test("18C", "" + f_strU2 + sf_c);
        test("18Csuffix", "" + f_strU2 + sf_c + "suffix");
        test("prefix18suffix1Csuffix2", "prefix" + f_strU2 + "suffix1" + sf_c + "suffix2");
        test("1875", "" + f_strU2 + sf_str);
        test("1875suffix", "" + f_strU2 + sf_str + "suffix");
        test("prefix18suffix175suffix2", "prefix" + f_strU2 + "suffix1" + sf_str + "suffix2");
        test("18-43", "" + f_strU2 + s_bM);
        test("18-43suffix", "" + f_strU2 + s_bM + "suffix");
        test("prefix18suffix1-43suffix2", "prefix" + f_strU2 + "suffix1" + s_bM + "suffix2");
        test("1880", "" + f_strU2 + sf_b);
        test("1880suffix", "" + f_strU2 + sf_b + "suffix");
        test("prefix18suffix180suffix2", "prefix" + f_strU2 + "suffix1" + sf_b + "suffix2");
        test("18null", "" + f_strU2 + s_IN);
        test("18nullsuffix", "" + f_strU2 + s_IN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + s_IN + "suffix2");
        test("18-52.0", "" + f_strU2 + s_fM);
        test("18-52.0suffix", "" + f_strU2 + s_fM + "suffix");
        test("prefix18suffix1-52.0suffix2", "prefix" + f_strU2 + "suffix1" + s_fM + "suffix2");
        test("1875000000", "" + f_strU2 + sf_i);
        test("1875000000suffix", "" + f_strU2 + sf_i + "suffix");
        test("prefix18suffix175000000suffix2", "prefix" + f_strU2 + "suffix1" + sf_i + "suffix2");
        test("1844", "" + f_strU2 + f_b);
        test("1844suffix", "" + f_strU2 + f_b + "suffix");
        test("prefix18suffix144suffix2", "prefix" + f_strU2 + "suffix1" + f_b + "suffix2");
    }

    public void run9() {
        test("18-1705032704", "" + f_strU2 + sf_lM);
        test("18-1705032704suffix", "" + f_strU2 + sf_lM + "suffix");
        test("prefix18suffix1-1705032704suffix2", "prefix" + f_strU2 + "suffix1" + sf_lM + "suffix2");
        test("18null", "" + f_strU2 + f_oAN);
        test("18nullsuffix", "" + f_strU2 + f_oAN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + f_oAN + "suffix2");
        test("1883.0", "" + f_strU2 + f_d);
        test("1883.0suffix", "" + f_strU2 + f_d + "suffix");
        test("prefix18suffix183.0suffix2", "prefix" + f_strU2 + "suffix1" + f_d + "suffix2");
        test("18I", "" + f_strU2 + f_c);
        test("18Isuffix", "" + f_strU2 + f_c + "suffix");
        test("prefix18suffix1Isuffix2", "prefix" + f_strU2 + "suffix1" + f_c + "suffix2");
        test("1894.0", "" + f_strU2 + f_f);
        test("1894.0suffix", "" + f_strU2 + f_f + "suffix");
        test("prefix18suffix194.0suffix2", "prefix" + f_strU2 + "suffix1" + f_f + "suffix2");
        test("1812.0", "" + f_strU2 + sf_d);
        test("1812.0suffix", "" + f_strU2 + sf_d + "suffix");
        test("prefix18suffix112.0suffix2", "prefix" + f_strU2 + "suffix1" + sf_d + "suffix2");
        test("18-99.0", "" + f_strU2 + f_dM);
        test("18-99.0suffix", "" + f_strU2 + f_dM + "suffix");
        test("prefix18suffix1-99.0suffix2", "prefix" + f_strU2 + "suffix1" + f_dM + "suffix2");
        test("1817.0", "" + f_strU2 + sf_f);
        test("1817.0suffix", "" + f_strU2 + sf_f + "suffix");
        test("prefix18suffix117.0suffix2", "prefix" + f_strU2 + "suffix1" + sf_f + "suffix2");
        test("18-84.0", "" + f_strU2 + sf_dM);
        test("18-84.0suffix", "" + f_strU2 + sf_dM + "suffix");
        test("prefix18suffix1-84.0suffix2", "prefix" + f_strU2 + "suffix1" + sf_dM + "suffix2");
        test("1858000000", "" + f_strU2 + f_i);
        test("1858000000suffix", "" + f_strU2 + f_i + "suffix");
        test("prefix18suffix158000000suffix2", "prefix" + f_strU2 + "suffix1" + f_i + "suffix2");
        test("18-55000000", "" + f_strU2 + f_iM);
        test("18-55000000suffix", "" + f_strU2 + f_iM + "suffix");
        test("prefix18suffix1-55000000suffix2", "prefix" + f_strU2 + "suffix1" + f_iM + "suffix2");
        test("181460392448", "" + f_strU2 + f_l);
        test("181460392448suffix", "" + f_strU2 + f_l + "suffix");
        test("prefix18suffix11460392448suffix2", "prefix" + f_strU2 + "suffix1" + f_l + "suffix2");
        test("18C(70)", "" + f_strU2 + f_o);
        test("18C(70)suffix", "" + f_strU2 + f_o + "suffix");
        test("prefix18suffix1C(70)suffix2", "prefix" + f_strU2 + "suffix1" + f_o + "suffix2");
        test("18\u04511", "" + f_strU2 + sf_strU);
        test("18\u04511suffix", "" + f_strU2 + sf_strU + "suffix");
        test("prefix18suffix1\u04511suffix2", "prefix" + f_strU2 + "suffix1" + sf_strU + "suffix2");
        test("188000", "" + f_strU2 + f_s);
        test("188000suffix", "" + f_strU2 + f_s + "suffix");
        test("prefix18suffix18000suffix2", "prefix" + f_strU2 + "suffix1" + f_s + "suffix2");
        test("1818", "" + f_strU2 + s_str);
        test("1818suffix", "" + f_strU2 + s_str + "suffix");
        test("prefix18suffix118suffix2", "prefix" + f_strU2 + "suffix1" + s_str + "suffix2");
        test("18-1000000", "" + f_strU2 + s_iM);
        test("18-1000000suffix", "" + f_strU2 + s_iM + "suffix");
        test("prefix18suffix1-1000000suffix2", "prefix" + f_strU2 + "suffix1" + s_iM + "suffix2");
        test("181000000", "" + f_strU2 + sf_I);
        test("181000000suffix", "" + f_strU2 + sf_I + "suffix");
        test("prefix18suffix11000000suffix2", "prefix" + f_strU2 + "suffix1" + sf_I + "suffix2");
        test("18null", "" + f_strU2 + f_oNtS);
        test("18nullsuffix", "" + f_strU2 + f_oNtS + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + f_oNtS + "suffix2");
        test("18false", "" + f_strU2 + f_bl);
        test("18falsesuffix", "" + f_strU2 + f_bl + "suffix");
        test("prefix18suffix1falsesuffix2", "prefix" + f_strU2 + "suffix1" + f_bl + "suffix2");
        test("18null", "" + f_strU2 + sf_iAN);
        test("18nullsuffix", "" + f_strU2 + sf_iAN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + sf_iAN + "suffix2");
        test("18-2000000", "" + f_strU2 + sf_iM);
        test("18-2000000suffix", "" + f_strU2 + sf_iM + "suffix");
        test("prefix18suffix1-2000000suffix2", "prefix" + f_strU2 + "suffix1" + sf_iM + "suffix2");
        test("18-820130816", "" + f_strU2 + f_lM);
        test("18-820130816suffix", "" + f_strU2 + f_lM + "suffix");
        test("prefix18suffix1-820130816suffix2", "prefix" + f_strU2 + "suffix1" + f_lM + "suffix2");
        test("18null", "" + f_strU2 + sf_oAN);
        test("18nullsuffix", "" + f_strU2 + sf_oAN + "suffix");
        test("prefix18suffix1nullsuffix2", "prefix" + f_strU2 + "suffix1" + sf_oAN + "suffix2");
        test("1825000000", "" + f_strU2 + s_I);
        test("1825000000suffix", "" + f_strU2 + s_I + "suffix");
        test("prefix18suffix125000000suffix2", "prefix" + f_strU2 + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + f_iAN + s_dM);
        test("null-96.0suffix", "" + f_iAN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + f_iAN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + f_iAN + s_oNtS);
        test("nullnullsuffix", "" + f_iAN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + f_iAN + f_strU);
        test("null\u045176suffix", "" + f_iAN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + f_iAN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + f_iAN + sf_strU2);
        test("null92suffix", "" + f_iAN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + f_iAN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + f_iAN + sf_strU1);
        test("null51suffix", "" + f_iAN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + f_iAN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + f_iAN + s_iAN);
        test("nullnullsuffix", "" + f_iAN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + f_iAN + f_bM);
        test("null-54suffix", "" + f_iAN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + f_iAN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + f_iAN + f_fM);
        test("null-87.0suffix", "" + f_iAN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + f_iAN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + f_iAN + s_oAN);
        test("nullnullsuffix", "" + f_iAN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + f_iAN + f_str);
        test("null19suffix", "" + f_iAN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + f_iAN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + f_iAN + sf_bM);
        test("null-41suffix", "" + f_iAN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + f_iAN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + f_iAN + sf_IN);
        test("nullnullsuffix", "" + f_iAN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + f_iAN + s_c);
        test("nullTsuffix", "" + f_iAN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + f_iAN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + f_iAN + sf_fM);
        test("null-42.0suffix", "" + f_iAN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + f_iAN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + f_iAN + s_b);
        test("null25suffix", "" + f_iAN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + f_iAN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + f_iAN + f_oN);
        test("nullnullsuffix", "" + f_iAN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + f_iAN + s_lM);
        test("null-1410065408suffix", "" + f_iAN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + f_iAN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + f_iAN + s_d);
        test("null8.0suffix", "" + f_iAN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + f_iAN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + f_iAN + s_f);
        test("null55.0suffix", "" + f_iAN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + f_iAN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + f_iAN + s_i);
        test("null97000000suffix", "" + f_iAN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + f_iAN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + f_iAN + f_sM);
        test("null-9900suffix", "" + f_iAN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + f_iAN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + f_iAN + s_l);
        test("null935228928suffix", "" + f_iAN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + f_iAN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + f_iAN + sf_sM);
        test("null-8400suffix", "" + f_iAN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + f_iAN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + f_iAN + s_o);
        test("nullC(82)suffix", "" + f_iAN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + f_iAN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + f_iAN + sf_oNtS);
        test("nullnullsuffix", "" + f_iAN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + f_iAN + s_bl);
        test("nulltruesuffix", "" + f_iAN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_iAN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + f_iAN + s_s);
        test("null3900suffix", "" + f_iAN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + f_iAN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + f_iAN + sf_oN);
        test("nullnullsuffix", "" + f_iAN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + f_iAN + f_I);
        test("null94000000suffix", "" + f_iAN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + f_iAN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + f_iAN + f_IN);
        test("nullnullsuffix", "" + f_iAN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + f_iAN + sf_bl);
        test("nulltruesuffix", "" + f_iAN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_iAN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + f_iAN + sf_s);
        test("null5500suffix", "" + f_iAN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + f_iAN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + f_iAN + s_sM);
        test("null-2900suffix", "" + f_iAN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + f_iAN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + f_iAN + sf_l);
        test("null-194313216suffix", "" + f_iAN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + f_iAN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + f_iAN + s_strU1);
        test("null12suffix", "" + f_iAN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + f_iAN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + f_iAN + sf_o);
        test("nullC(87)suffix", "" + f_iAN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + f_iAN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + f_iAN + s_strU2);
        test("null91suffix", "" + f_iAN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + f_iAN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + f_iAN + f_strU1);
        test("null21suffix", "" + f_iAN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + f_iAN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + f_iAN + f_strU2);
        test("null18suffix", "" + f_iAN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_iAN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + f_iAN + f_iAN);
        test("nullnullsuffix", "" + f_iAN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + f_iAN + s_oN);
        test("nullnullsuffix", "" + f_iAN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + f_iAN + s_strU);
        test("null\u045180suffix", "" + f_iAN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + f_iAN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + f_iAN + sf_c);
        test("nullCsuffix", "" + f_iAN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + f_iAN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + f_iAN + sf_str);
        test("null75suffix", "" + f_iAN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + f_iAN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + f_iAN + s_bM);
        test("null-43suffix", "" + f_iAN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + f_iAN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + f_iAN + sf_b);
        test("null80suffix", "" + f_iAN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + f_iAN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + f_iAN + s_IN);
        test("nullnullsuffix", "" + f_iAN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + f_iAN + s_fM);
        test("null-52.0suffix", "" + f_iAN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + f_iAN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + f_iAN + sf_i);
        test("null75000000suffix", "" + f_iAN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + f_iAN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + f_iAN + f_b);
        test("null44suffix", "" + f_iAN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + f_iAN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + f_iAN + sf_lM);
        test("null-1705032704suffix", "" + f_iAN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + f_iAN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + f_iAN + f_oAN);
        test("nullnullsuffix", "" + f_iAN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + f_iAN + f_d);
        test("null83.0suffix", "" + f_iAN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + f_iAN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + f_iAN + f_c);
        test("nullIsuffix", "" + f_iAN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + f_iAN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + f_iAN + f_f);
        test("null94.0suffix", "" + f_iAN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + f_iAN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + f_iAN + sf_d);
        test("null12.0suffix", "" + f_iAN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + f_iAN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + f_iAN + f_dM);
        test("null-99.0suffix", "" + f_iAN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + f_iAN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + f_iAN + sf_f);
        test("null17.0suffix", "" + f_iAN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + f_iAN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + f_iAN + sf_dM);
        test("null-84.0suffix", "" + f_iAN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + f_iAN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + f_iAN + f_i);
        test("null58000000suffix", "" + f_iAN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + f_iAN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + f_iAN + f_iM);
        test("null-55000000suffix", "" + f_iAN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + f_iAN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + f_iAN + f_l);
        test("null1460392448suffix", "" + f_iAN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + f_iAN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + f_iAN + f_o);
        test("nullC(70)suffix", "" + f_iAN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + f_iAN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + f_iAN + sf_strU);
        test("null\u04511suffix", "" + f_iAN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + f_iAN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + f_iAN + f_s);
        test("null8000suffix", "" + f_iAN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + f_iAN + "suffix1" + f_s + "suffix2");
        test("null18", "" + f_iAN + s_str);
        test("null18suffix", "" + f_iAN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_iAN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + f_iAN + s_iM);
        test("null-1000000suffix", "" + f_iAN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + f_iAN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + f_iAN + sf_I);
        test("null1000000suffix", "" + f_iAN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + f_iAN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + f_iAN + f_oNtS);
        test("nullnullsuffix", "" + f_iAN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + f_iAN + f_bl);
        test("nullfalsesuffix", "" + f_iAN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + f_iAN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + f_iAN + sf_iAN);
        test("nullnullsuffix", "" + f_iAN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + f_iAN + sf_iM);
        test("null-2000000suffix", "" + f_iAN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + f_iAN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + f_iAN + f_lM);
        test("null-820130816suffix", "" + f_iAN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + f_iAN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + f_iAN + sf_oAN);
        test("nullnullsuffix", "" + f_iAN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_iAN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + f_iAN + s_I);
        test("null25000000suffix", "" + f_iAN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + f_iAN + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + s_oN + s_dM);
        test("null-96.0suffix", "" + s_oN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + s_oN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + s_oN + s_oNtS);
        test("nullnullsuffix", "" + s_oN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + s_oN + f_strU);
        test("null\u045176suffix", "" + s_oN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + s_oN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + s_oN + sf_strU2);
        test("null92suffix", "" + s_oN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + s_oN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + s_oN + sf_strU1);
        test("null51suffix", "" + s_oN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + s_oN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + s_oN + s_iAN);
        test("nullnullsuffix", "" + s_oN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + s_oN + f_bM);
        test("null-54suffix", "" + s_oN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + s_oN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + s_oN + f_fM);
        test("null-87.0suffix", "" + s_oN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + s_oN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + s_oN + s_oAN);
        test("nullnullsuffix", "" + s_oN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + s_oN + f_str);
        test("null19suffix", "" + s_oN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + s_oN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + s_oN + sf_bM);
        test("null-41suffix", "" + s_oN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + s_oN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + s_oN + sf_IN);
        test("nullnullsuffix", "" + s_oN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + s_oN + s_c);
        test("nullTsuffix", "" + s_oN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + s_oN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + s_oN + sf_fM);
        test("null-42.0suffix", "" + s_oN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + s_oN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + s_oN + s_b);
        test("null25suffix", "" + s_oN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + s_oN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + s_oN + f_oN);
        test("nullnullsuffix", "" + s_oN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + s_oN + s_lM);
        test("null-1410065408suffix", "" + s_oN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + s_oN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + s_oN + s_d);
        test("null8.0suffix", "" + s_oN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + s_oN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + s_oN + s_f);
        test("null55.0suffix", "" + s_oN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + s_oN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + s_oN + s_i);
        test("null97000000suffix", "" + s_oN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + s_oN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + s_oN + f_sM);
        test("null-9900suffix", "" + s_oN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + s_oN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + s_oN + s_l);
        test("null935228928suffix", "" + s_oN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + s_oN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + s_oN + sf_sM);
        test("null-8400suffix", "" + s_oN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + s_oN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + s_oN + s_o);
        test("nullC(82)suffix", "" + s_oN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + s_oN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + s_oN + sf_oNtS);
        test("nullnullsuffix", "" + s_oN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + s_oN + s_bl);
        test("nulltruesuffix", "" + s_oN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_oN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + s_oN + s_s);
        test("null3900suffix", "" + s_oN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + s_oN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + s_oN + sf_oN);
        test("nullnullsuffix", "" + s_oN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + s_oN + f_I);
        test("null94000000suffix", "" + s_oN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + s_oN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + s_oN + f_IN);
        test("nullnullsuffix", "" + s_oN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + s_oN + sf_bl);
        test("nulltruesuffix", "" + s_oN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_oN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + s_oN + sf_s);
        test("null5500suffix", "" + s_oN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + s_oN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + s_oN + s_sM);
        test("null-2900suffix", "" + s_oN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + s_oN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + s_oN + sf_l);
        test("null-194313216suffix", "" + s_oN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + s_oN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + s_oN + s_strU1);
        test("null12suffix", "" + s_oN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + s_oN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + s_oN + sf_o);
        test("nullC(87)suffix", "" + s_oN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + s_oN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + s_oN + s_strU2);
        test("null91suffix", "" + s_oN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + s_oN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + s_oN + f_strU1);
        test("null21suffix", "" + s_oN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + s_oN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + s_oN + f_strU2);
        test("null18suffix", "" + s_oN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_oN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + s_oN + f_iAN);
        test("nullnullsuffix", "" + s_oN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + s_oN + s_oN);
        test("nullnullsuffix", "" + s_oN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + s_oN + s_strU);
        test("null\u045180suffix", "" + s_oN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + s_oN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + s_oN + sf_c);
        test("nullCsuffix", "" + s_oN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + s_oN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + s_oN + sf_str);
        test("null75suffix", "" + s_oN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + s_oN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + s_oN + s_bM);
        test("null-43suffix", "" + s_oN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + s_oN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + s_oN + sf_b);
        test("null80suffix", "" + s_oN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + s_oN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + s_oN + s_IN);
        test("nullnullsuffix", "" + s_oN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + s_oN + s_fM);
        test("null-52.0suffix", "" + s_oN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + s_oN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + s_oN + sf_i);
        test("null75000000suffix", "" + s_oN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + s_oN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + s_oN + f_b);
        test("null44suffix", "" + s_oN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + s_oN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + s_oN + sf_lM);
        test("null-1705032704suffix", "" + s_oN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + s_oN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + s_oN + f_oAN);
        test("nullnullsuffix", "" + s_oN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + s_oN + f_d);
        test("null83.0suffix", "" + s_oN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + s_oN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + s_oN + f_c);
        test("nullIsuffix", "" + s_oN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + s_oN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + s_oN + f_f);
        test("null94.0suffix", "" + s_oN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + s_oN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + s_oN + sf_d);
        test("null12.0suffix", "" + s_oN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + s_oN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + s_oN + f_dM);
        test("null-99.0suffix", "" + s_oN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + s_oN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + s_oN + sf_f);
        test("null17.0suffix", "" + s_oN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + s_oN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + s_oN + sf_dM);
        test("null-84.0suffix", "" + s_oN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + s_oN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + s_oN + f_i);
        test("null58000000suffix", "" + s_oN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + s_oN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + s_oN + f_iM);
        test("null-55000000suffix", "" + s_oN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + s_oN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + s_oN + f_l);
        test("null1460392448suffix", "" + s_oN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + s_oN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + s_oN + f_o);
        test("nullC(70)suffix", "" + s_oN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + s_oN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + s_oN + sf_strU);
        test("null\u04511suffix", "" + s_oN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + s_oN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + s_oN + f_s);
        test("null8000suffix", "" + s_oN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + s_oN + "suffix1" + f_s + "suffix2");
        test("null18", "" + s_oN + s_str);
        test("null18suffix", "" + s_oN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_oN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + s_oN + s_iM);
        test("null-1000000suffix", "" + s_oN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + s_oN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + s_oN + sf_I);
        test("null1000000suffix", "" + s_oN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + s_oN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + s_oN + f_oNtS);
        test("nullnullsuffix", "" + s_oN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + s_oN + f_bl);
        test("nullfalsesuffix", "" + s_oN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + s_oN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + s_oN + sf_iAN);
        test("nullnullsuffix", "" + s_oN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + s_oN + sf_iM);
        test("null-2000000suffix", "" + s_oN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + s_oN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + s_oN + f_lM);
        test("null-820130816suffix", "" + s_oN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + s_oN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + s_oN + sf_oAN);
        test("nullnullsuffix", "" + s_oN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_oN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + s_oN + s_I);
        test("null25000000suffix", "" + s_oN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + s_oN + "suffix1" + s_I + "suffix2");
        test("\u045180-96.0", "" + s_strU + s_dM);
        test("\u045180-96.0suffix", "" + s_strU + s_dM + "suffix");
        test("prefix\u045180suffix1-96.0suffix2", "prefix" + s_strU + "suffix1" + s_dM + "suffix2");
        test("\u045180null", "" + s_strU + s_oNtS);
        test("\u045180nullsuffix", "" + s_strU + s_oNtS + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + s_oNtS + "suffix2");
        test("\u045180\u045176", "" + s_strU + f_strU);
        test("\u045180\u045176suffix", "" + s_strU + f_strU + "suffix");
        test("prefix\u045180suffix1\u045176suffix2", "prefix" + s_strU + "suffix1" + f_strU + "suffix2");
        test("\u04518092", "" + s_strU + sf_strU2);
        test("\u04518092suffix", "" + s_strU + sf_strU2 + "suffix");
        test("prefix\u045180suffix192suffix2", "prefix" + s_strU + "suffix1" + sf_strU2 + "suffix2");
        test("\u04518051", "" + s_strU + sf_strU1);
        test("\u04518051suffix", "" + s_strU + sf_strU1 + "suffix");
        test("prefix\u045180suffix151suffix2", "prefix" + s_strU + "suffix1" + sf_strU1 + "suffix2");
        test("\u045180null", "" + s_strU + s_iAN);
        test("\u045180nullsuffix", "" + s_strU + s_iAN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + s_iAN + "suffix2");
        test("\u045180-54", "" + s_strU + f_bM);
        test("\u045180-54suffix", "" + s_strU + f_bM + "suffix");
        test("prefix\u045180suffix1-54suffix2", "prefix" + s_strU + "suffix1" + f_bM + "suffix2");
        test("\u045180-87.0", "" + s_strU + f_fM);
        test("\u045180-87.0suffix", "" + s_strU + f_fM + "suffix");
        test("prefix\u045180suffix1-87.0suffix2", "prefix" + s_strU + "suffix1" + f_fM + "suffix2");
        test("\u045180null", "" + s_strU + s_oAN);
        test("\u045180nullsuffix", "" + s_strU + s_oAN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + s_oAN + "suffix2");
        test("\u04518019", "" + s_strU + f_str);
        test("\u04518019suffix", "" + s_strU + f_str + "suffix");
        test("prefix\u045180suffix119suffix2", "prefix" + s_strU + "suffix1" + f_str + "suffix2");
        test("\u045180-41", "" + s_strU + sf_bM);
        test("\u045180-41suffix", "" + s_strU + sf_bM + "suffix");
        test("prefix\u045180suffix1-41suffix2", "prefix" + s_strU + "suffix1" + sf_bM + "suffix2");
        test("\u045180null", "" + s_strU + sf_IN);
        test("\u045180nullsuffix", "" + s_strU + sf_IN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + sf_IN + "suffix2");
        test("\u045180T", "" + s_strU + s_c);
        test("\u045180Tsuffix", "" + s_strU + s_c + "suffix");
        test("prefix\u045180suffix1Tsuffix2", "prefix" + s_strU + "suffix1" + s_c + "suffix2");
        test("\u045180-42.0", "" + s_strU + sf_fM);
        test("\u045180-42.0suffix", "" + s_strU + sf_fM + "suffix");
        test("prefix\u045180suffix1-42.0suffix2", "prefix" + s_strU + "suffix1" + sf_fM + "suffix2");
        test("\u04518025", "" + s_strU + s_b);
        test("\u04518025suffix", "" + s_strU + s_b + "suffix");
        test("prefix\u045180suffix125suffix2", "prefix" + s_strU + "suffix1" + s_b + "suffix2");
        test("\u045180null", "" + s_strU + f_oN);
        test("\u045180nullsuffix", "" + s_strU + f_oN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + f_oN + "suffix2");
        test("\u045180-1410065408", "" + s_strU + s_lM);
        test("\u045180-1410065408suffix", "" + s_strU + s_lM + "suffix");
        test("prefix\u045180suffix1-1410065408suffix2", "prefix" + s_strU + "suffix1" + s_lM + "suffix2");
        test("\u0451808.0", "" + s_strU + s_d);
        test("\u0451808.0suffix", "" + s_strU + s_d + "suffix");
        test("prefix\u045180suffix18.0suffix2", "prefix" + s_strU + "suffix1" + s_d + "suffix2");
        test("\u04518055.0", "" + s_strU + s_f);
        test("\u04518055.0suffix", "" + s_strU + s_f + "suffix");
        test("prefix\u045180suffix155.0suffix2", "prefix" + s_strU + "suffix1" + s_f + "suffix2");
        test("\u04518097000000", "" + s_strU + s_i);
        test("\u04518097000000suffix", "" + s_strU + s_i + "suffix");
        test("prefix\u045180suffix197000000suffix2", "prefix" + s_strU + "suffix1" + s_i + "suffix2");
        test("\u045180-9900", "" + s_strU + f_sM);
        test("\u045180-9900suffix", "" + s_strU + f_sM + "suffix");
        test("prefix\u045180suffix1-9900suffix2", "prefix" + s_strU + "suffix1" + f_sM + "suffix2");
        test("\u045180935228928", "" + s_strU + s_l);
        test("\u045180935228928suffix", "" + s_strU + s_l + "suffix");
        test("prefix\u045180suffix1935228928suffix2", "prefix" + s_strU + "suffix1" + s_l + "suffix2");
        test("\u045180-8400", "" + s_strU + sf_sM);
        test("\u045180-8400suffix", "" + s_strU + sf_sM + "suffix");
        test("prefix\u045180suffix1-8400suffix2", "prefix" + s_strU + "suffix1" + sf_sM + "suffix2");
        test("\u045180C(82)", "" + s_strU + s_o);
        test("\u045180C(82)suffix", "" + s_strU + s_o + "suffix");
        test("prefix\u045180suffix1C(82)suffix2", "prefix" + s_strU + "suffix1" + s_o + "suffix2");
        test("\u045180null", "" + s_strU + sf_oNtS);
        test("\u045180nullsuffix", "" + s_strU + sf_oNtS + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + sf_oNtS + "suffix2");
        test("\u045180true", "" + s_strU + s_bl);
        test("\u045180truesuffix", "" + s_strU + s_bl + "suffix");
        test("prefix\u045180suffix1truesuffix2", "prefix" + s_strU + "suffix1" + s_bl + "suffix2");
        test("\u0451803900", "" + s_strU + s_s);
        test("\u0451803900suffix", "" + s_strU + s_s + "suffix");
        test("prefix\u045180suffix13900suffix2", "prefix" + s_strU + "suffix1" + s_s + "suffix2");
        test("\u045180null", "" + s_strU + sf_oN);
        test("\u045180nullsuffix", "" + s_strU + sf_oN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + sf_oN + "suffix2");
        test("\u04518094000000", "" + s_strU + f_I);
        test("\u04518094000000suffix", "" + s_strU + f_I + "suffix");
        test("prefix\u045180suffix194000000suffix2", "prefix" + s_strU + "suffix1" + f_I + "suffix2");
        test("\u045180null", "" + s_strU + f_IN);
        test("\u045180nullsuffix", "" + s_strU + f_IN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + f_IN + "suffix2");
        test("\u045180true", "" + s_strU + sf_bl);
        test("\u045180truesuffix", "" + s_strU + sf_bl + "suffix");
        test("prefix\u045180suffix1truesuffix2", "prefix" + s_strU + "suffix1" + sf_bl + "suffix2");
        test("\u0451805500", "" + s_strU + sf_s);
        test("\u0451805500suffix", "" + s_strU + sf_s + "suffix");
        test("prefix\u045180suffix15500suffix2", "prefix" + s_strU + "suffix1" + sf_s + "suffix2");
        test("\u045180-2900", "" + s_strU + s_sM);
        test("\u045180-2900suffix", "" + s_strU + s_sM + "suffix");
        test("prefix\u045180suffix1-2900suffix2", "prefix" + s_strU + "suffix1" + s_sM + "suffix2");
        test("\u045180-194313216", "" + s_strU + sf_l);
        test("\u045180-194313216suffix", "" + s_strU + sf_l + "suffix");
        test("prefix\u045180suffix1-194313216suffix2", "prefix" + s_strU + "suffix1" + sf_l + "suffix2");
        test("\u04518012", "" + s_strU + s_strU1);
        test("\u04518012suffix", "" + s_strU + s_strU1 + "suffix");
        test("prefix\u045180suffix112suffix2", "prefix" + s_strU + "suffix1" + s_strU1 + "suffix2");
        test("\u045180C(87)", "" + s_strU + sf_o);
        test("\u045180C(87)suffix", "" + s_strU + sf_o + "suffix");
        test("prefix\u045180suffix1C(87)suffix2", "prefix" + s_strU + "suffix1" + sf_o + "suffix2");
        test("\u04518091", "" + s_strU + s_strU2);
        test("\u04518091suffix", "" + s_strU + s_strU2 + "suffix");
        test("prefix\u045180suffix191suffix2", "prefix" + s_strU + "suffix1" + s_strU2 + "suffix2");
        test("\u04518021", "" + s_strU + f_strU1);
        test("\u04518021suffix", "" + s_strU + f_strU1 + "suffix");
        test("prefix\u045180suffix121suffix2", "prefix" + s_strU + "suffix1" + f_strU1 + "suffix2");
        test("\u04518018", "" + s_strU + f_strU2);
        test("\u04518018suffix", "" + s_strU + f_strU2 + "suffix");
        test("prefix\u045180suffix118suffix2", "prefix" + s_strU + "suffix1" + f_strU2 + "suffix2");
        test("\u045180null", "" + s_strU + f_iAN);
        test("\u045180nullsuffix", "" + s_strU + f_iAN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + f_iAN + "suffix2");
        test("\u045180null", "" + s_strU + s_oN);
        test("\u045180nullsuffix", "" + s_strU + s_oN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + s_oN + "suffix2");
        test("\u045180\u045180", "" + s_strU + s_strU);
        test("\u045180\u045180suffix", "" + s_strU + s_strU + "suffix");
        test("prefix\u045180suffix1\u045180suffix2", "prefix" + s_strU + "suffix1" + s_strU + "suffix2");
        test("\u045180C", "" + s_strU + sf_c);
        test("\u045180Csuffix", "" + s_strU + sf_c + "suffix");
        test("prefix\u045180suffix1Csuffix2", "prefix" + s_strU + "suffix1" + sf_c + "suffix2");
        test("\u04518075", "" + s_strU + sf_str);
        test("\u04518075suffix", "" + s_strU + sf_str + "suffix");
        test("prefix\u045180suffix175suffix2", "prefix" + s_strU + "suffix1" + sf_str + "suffix2");
        test("\u045180-43", "" + s_strU + s_bM);
        test("\u045180-43suffix", "" + s_strU + s_bM + "suffix");
        test("prefix\u045180suffix1-43suffix2", "prefix" + s_strU + "suffix1" + s_bM + "suffix2");
        test("\u04518080", "" + s_strU + sf_b);
        test("\u04518080suffix", "" + s_strU + sf_b + "suffix");
        test("prefix\u045180suffix180suffix2", "prefix" + s_strU + "suffix1" + sf_b + "suffix2");
        test("\u045180null", "" + s_strU + s_IN);
        test("\u045180nullsuffix", "" + s_strU + s_IN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + s_IN + "suffix2");
        test("\u045180-52.0", "" + s_strU + s_fM);
        test("\u045180-52.0suffix", "" + s_strU + s_fM + "suffix");
        test("prefix\u045180suffix1-52.0suffix2", "prefix" + s_strU + "suffix1" + s_fM + "suffix2");
        test("\u04518075000000", "" + s_strU + sf_i);
        test("\u04518075000000suffix", "" + s_strU + sf_i + "suffix");
        test("prefix\u045180suffix175000000suffix2", "prefix" + s_strU + "suffix1" + sf_i + "suffix2");
        test("\u04518044", "" + s_strU + f_b);
        test("\u04518044suffix", "" + s_strU + f_b + "suffix");
        test("prefix\u045180suffix144suffix2", "prefix" + s_strU + "suffix1" + f_b + "suffix2");
        test("\u045180-1705032704", "" + s_strU + sf_lM);
        test("\u045180-1705032704suffix", "" + s_strU + sf_lM + "suffix");
        test("prefix\u045180suffix1-1705032704suffix2", "prefix" + s_strU + "suffix1" + sf_lM + "suffix2");
        test("\u045180null", "" + s_strU + f_oAN);
        test("\u045180nullsuffix", "" + s_strU + f_oAN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + f_oAN + "suffix2");
        test("\u04518083.0", "" + s_strU + f_d);
        test("\u04518083.0suffix", "" + s_strU + f_d + "suffix");
        test("prefix\u045180suffix183.0suffix2", "prefix" + s_strU + "suffix1" + f_d + "suffix2");
        test("\u045180I", "" + s_strU + f_c);
        test("\u045180Isuffix", "" + s_strU + f_c + "suffix");
        test("prefix\u045180suffix1Isuffix2", "prefix" + s_strU + "suffix1" + f_c + "suffix2");
        test("\u04518094.0", "" + s_strU + f_f);
        test("\u04518094.0suffix", "" + s_strU + f_f + "suffix");
        test("prefix\u045180suffix194.0suffix2", "prefix" + s_strU + "suffix1" + f_f + "suffix2");
        test("\u04518012.0", "" + s_strU + sf_d);
        test("\u04518012.0suffix", "" + s_strU + sf_d + "suffix");
        test("prefix\u045180suffix112.0suffix2", "prefix" + s_strU + "suffix1" + sf_d + "suffix2");
        test("\u045180-99.0", "" + s_strU + f_dM);
        test("\u045180-99.0suffix", "" + s_strU + f_dM + "suffix");
        test("prefix\u045180suffix1-99.0suffix2", "prefix" + s_strU + "suffix1" + f_dM + "suffix2");
        test("\u04518017.0", "" + s_strU + sf_f);
        test("\u04518017.0suffix", "" + s_strU + sf_f + "suffix");
        test("prefix\u045180suffix117.0suffix2", "prefix" + s_strU + "suffix1" + sf_f + "suffix2");
        test("\u045180-84.0", "" + s_strU + sf_dM);
        test("\u045180-84.0suffix", "" + s_strU + sf_dM + "suffix");
        test("prefix\u045180suffix1-84.0suffix2", "prefix" + s_strU + "suffix1" + sf_dM + "suffix2");
        test("\u04518058000000", "" + s_strU + f_i);
        test("\u04518058000000suffix", "" + s_strU + f_i + "suffix");
        test("prefix\u045180suffix158000000suffix2", "prefix" + s_strU + "suffix1" + f_i + "suffix2");
        test("\u045180-55000000", "" + s_strU + f_iM);
        test("\u045180-55000000suffix", "" + s_strU + f_iM + "suffix");
        test("prefix\u045180suffix1-55000000suffix2", "prefix" + s_strU + "suffix1" + f_iM + "suffix2");
        test("\u0451801460392448", "" + s_strU + f_l);
        test("\u0451801460392448suffix", "" + s_strU + f_l + "suffix");
        test("prefix\u045180suffix11460392448suffix2", "prefix" + s_strU + "suffix1" + f_l + "suffix2");
        test("\u045180C(70)", "" + s_strU + f_o);
        test("\u045180C(70)suffix", "" + s_strU + f_o + "suffix");
        test("prefix\u045180suffix1C(70)suffix2", "prefix" + s_strU + "suffix1" + f_o + "suffix2");
        test("\u045180\u04511", "" + s_strU + sf_strU);
        test("\u045180\u04511suffix", "" + s_strU + sf_strU + "suffix");
        test("prefix\u045180suffix1\u04511suffix2", "prefix" + s_strU + "suffix1" + sf_strU + "suffix2");
        test("\u0451808000", "" + s_strU + f_s);
        test("\u0451808000suffix", "" + s_strU + f_s + "suffix");
        test("prefix\u045180suffix18000suffix2", "prefix" + s_strU + "suffix1" + f_s + "suffix2");
        test("\u04518018", "" + s_strU + s_str);
        test("\u04518018suffix", "" + s_strU + s_str + "suffix");
        test("prefix\u045180suffix118suffix2", "prefix" + s_strU + "suffix1" + s_str + "suffix2");
        test("\u045180-1000000", "" + s_strU + s_iM);
        test("\u045180-1000000suffix", "" + s_strU + s_iM + "suffix");
        test("prefix\u045180suffix1-1000000suffix2", "prefix" + s_strU + "suffix1" + s_iM + "suffix2");
        test("\u0451801000000", "" + s_strU + sf_I);
        test("\u0451801000000suffix", "" + s_strU + sf_I + "suffix");
        test("prefix\u045180suffix11000000suffix2", "prefix" + s_strU + "suffix1" + sf_I + "suffix2");
        test("\u045180null", "" + s_strU + f_oNtS);
        test("\u045180nullsuffix", "" + s_strU + f_oNtS + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + f_oNtS + "suffix2");
        test("\u045180false", "" + s_strU + f_bl);
        test("\u045180falsesuffix", "" + s_strU + f_bl + "suffix");
        test("prefix\u045180suffix1falsesuffix2", "prefix" + s_strU + "suffix1" + f_bl + "suffix2");
        test("\u045180null", "" + s_strU + sf_iAN);
        test("\u045180nullsuffix", "" + s_strU + sf_iAN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + sf_iAN + "suffix2");
        test("\u045180-2000000", "" + s_strU + sf_iM);
        test("\u045180-2000000suffix", "" + s_strU + sf_iM + "suffix");
        test("prefix\u045180suffix1-2000000suffix2", "prefix" + s_strU + "suffix1" + sf_iM + "suffix2");
        test("\u045180-820130816", "" + s_strU + f_lM);
        test("\u045180-820130816suffix", "" + s_strU + f_lM + "suffix");
        test("prefix\u045180suffix1-820130816suffix2", "prefix" + s_strU + "suffix1" + f_lM + "suffix2");
        test("\u045180null", "" + s_strU + sf_oAN);
        test("\u045180nullsuffix", "" + s_strU + sf_oAN + "suffix");
        test("prefix\u045180suffix1nullsuffix2", "prefix" + s_strU + "suffix1" + sf_oAN + "suffix2");
        test("\u04518025000000", "" + s_strU + s_I);
        test("\u04518025000000suffix", "" + s_strU + s_I + "suffix");
        test("prefix\u045180suffix125000000suffix2", "prefix" + s_strU + "suffix1" + s_I + "suffix2");
        test("C-96.0", "" + sf_c + s_dM);
        test("C-96.0suffix", "" + sf_c + s_dM + "suffix");
        test("prefixCsuffix1-96.0suffix2", "prefix" + sf_c + "suffix1" + s_dM + "suffix2");
        test("Cnull", "" + sf_c + s_oNtS);
        test("Cnullsuffix", "" + sf_c + s_oNtS + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + s_oNtS + "suffix2");
        test("C\u045176", "" + sf_c + f_strU);
        test("C\u045176suffix", "" + sf_c + f_strU + "suffix");
        test("prefixCsuffix1\u045176suffix2", "prefix" + sf_c + "suffix1" + f_strU + "suffix2");
        test("C92", "" + sf_c + sf_strU2);
        test("C92suffix", "" + sf_c + sf_strU2 + "suffix");
        test("prefixCsuffix192suffix2", "prefix" + sf_c + "suffix1" + sf_strU2 + "suffix2");
        test("C51", "" + sf_c + sf_strU1);
        test("C51suffix", "" + sf_c + sf_strU1 + "suffix");
        test("prefixCsuffix151suffix2", "prefix" + sf_c + "suffix1" + sf_strU1 + "suffix2");
        test("Cnull", "" + sf_c + s_iAN);
        test("Cnullsuffix", "" + sf_c + s_iAN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + s_iAN + "suffix2");
        test("C-54", "" + sf_c + f_bM);
        test("C-54suffix", "" + sf_c + f_bM + "suffix");
        test("prefixCsuffix1-54suffix2", "prefix" + sf_c + "suffix1" + f_bM + "suffix2");
        test("C-87.0", "" + sf_c + f_fM);
        test("C-87.0suffix", "" + sf_c + f_fM + "suffix");
        test("prefixCsuffix1-87.0suffix2", "prefix" + sf_c + "suffix1" + f_fM + "suffix2");
        test("Cnull", "" + sf_c + s_oAN);
        test("Cnullsuffix", "" + sf_c + s_oAN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + s_oAN + "suffix2");
        test("C19", "" + sf_c + f_str);
        test("C19suffix", "" + sf_c + f_str + "suffix");
        test("prefixCsuffix119suffix2", "prefix" + sf_c + "suffix1" + f_str + "suffix2");
        test("C-41", "" + sf_c + sf_bM);
        test("C-41suffix", "" + sf_c + sf_bM + "suffix");
        test("prefixCsuffix1-41suffix2", "prefix" + sf_c + "suffix1" + sf_bM + "suffix2");
        test("Cnull", "" + sf_c + sf_IN);
        test("Cnullsuffix", "" + sf_c + sf_IN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + sf_IN + "suffix2");
        test("CT", "" + sf_c + s_c);
        test("CTsuffix", "" + sf_c + s_c + "suffix");
        test("prefixCsuffix1Tsuffix2", "prefix" + sf_c + "suffix1" + s_c + "suffix2");
        test("C-42.0", "" + sf_c + sf_fM);
        test("C-42.0suffix", "" + sf_c + sf_fM + "suffix");
        test("prefixCsuffix1-42.0suffix2", "prefix" + sf_c + "suffix1" + sf_fM + "suffix2");
        test("C25", "" + sf_c + s_b);
        test("C25suffix", "" + sf_c + s_b + "suffix");
        test("prefixCsuffix125suffix2", "prefix" + sf_c + "suffix1" + s_b + "suffix2");
        test("Cnull", "" + sf_c + f_oN);
        test("Cnullsuffix", "" + sf_c + f_oN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + f_oN + "suffix2");
        test("C-1410065408", "" + sf_c + s_lM);
        test("C-1410065408suffix", "" + sf_c + s_lM + "suffix");
        test("prefixCsuffix1-1410065408suffix2", "prefix" + sf_c + "suffix1" + s_lM + "suffix2");
        test("C8.0", "" + sf_c + s_d);
        test("C8.0suffix", "" + sf_c + s_d + "suffix");
        test("prefixCsuffix18.0suffix2", "prefix" + sf_c + "suffix1" + s_d + "suffix2");
        test("C55.0", "" + sf_c + s_f);
        test("C55.0suffix", "" + sf_c + s_f + "suffix");
        test("prefixCsuffix155.0suffix2", "prefix" + sf_c + "suffix1" + s_f + "suffix2");
        test("C97000000", "" + sf_c + s_i);
        test("C97000000suffix", "" + sf_c + s_i + "suffix");
        test("prefixCsuffix197000000suffix2", "prefix" + sf_c + "suffix1" + s_i + "suffix2");
        test("C-9900", "" + sf_c + f_sM);
        test("C-9900suffix", "" + sf_c + f_sM + "suffix");
        test("prefixCsuffix1-9900suffix2", "prefix" + sf_c + "suffix1" + f_sM + "suffix2");
        test("C935228928", "" + sf_c + s_l);
        test("C935228928suffix", "" + sf_c + s_l + "suffix");
        test("prefixCsuffix1935228928suffix2", "prefix" + sf_c + "suffix1" + s_l + "suffix2");
        test("C-8400", "" + sf_c + sf_sM);
        test("C-8400suffix", "" + sf_c + sf_sM + "suffix");
        test("prefixCsuffix1-8400suffix2", "prefix" + sf_c + "suffix1" + sf_sM + "suffix2");
        test("CC(82)", "" + sf_c + s_o);
        test("CC(82)suffix", "" + sf_c + s_o + "suffix");
        test("prefixCsuffix1C(82)suffix2", "prefix" + sf_c + "suffix1" + s_o + "suffix2");
        test("Cnull", "" + sf_c + sf_oNtS);
        test("Cnullsuffix", "" + sf_c + sf_oNtS + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + sf_oNtS + "suffix2");
        test("Ctrue", "" + sf_c + s_bl);
        test("Ctruesuffix", "" + sf_c + s_bl + "suffix");
        test("prefixCsuffix1truesuffix2", "prefix" + sf_c + "suffix1" + s_bl + "suffix2");
        test("C3900", "" + sf_c + s_s);
        test("C3900suffix", "" + sf_c + s_s + "suffix");
        test("prefixCsuffix13900suffix2", "prefix" + sf_c + "suffix1" + s_s + "suffix2");
        test("Cnull", "" + sf_c + sf_oN);
        test("Cnullsuffix", "" + sf_c + sf_oN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + sf_oN + "suffix2");
        test("C94000000", "" + sf_c + f_I);
        test("C94000000suffix", "" + sf_c + f_I + "suffix");
        test("prefixCsuffix194000000suffix2", "prefix" + sf_c + "suffix1" + f_I + "suffix2");
        test("Cnull", "" + sf_c + f_IN);
        test("Cnullsuffix", "" + sf_c + f_IN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + f_IN + "suffix2");
        test("Ctrue", "" + sf_c + sf_bl);
        test("Ctruesuffix", "" + sf_c + sf_bl + "suffix");
        test("prefixCsuffix1truesuffix2", "prefix" + sf_c + "suffix1" + sf_bl + "suffix2");
        test("C5500", "" + sf_c + sf_s);
        test("C5500suffix", "" + sf_c + sf_s + "suffix");
        test("prefixCsuffix15500suffix2", "prefix" + sf_c + "suffix1" + sf_s + "suffix2");
        test("C-2900", "" + sf_c + s_sM);
        test("C-2900suffix", "" + sf_c + s_sM + "suffix");
        test("prefixCsuffix1-2900suffix2", "prefix" + sf_c + "suffix1" + s_sM + "suffix2");
        test("C-194313216", "" + sf_c + sf_l);
        test("C-194313216suffix", "" + sf_c + sf_l + "suffix");
        test("prefixCsuffix1-194313216suffix2", "prefix" + sf_c + "suffix1" + sf_l + "suffix2");
        test("C12", "" + sf_c + s_strU1);
        test("C12suffix", "" + sf_c + s_strU1 + "suffix");
        test("prefixCsuffix112suffix2", "prefix" + sf_c + "suffix1" + s_strU1 + "suffix2");
        test("CC(87)", "" + sf_c + sf_o);
        test("CC(87)suffix", "" + sf_c + sf_o + "suffix");
        test("prefixCsuffix1C(87)suffix2", "prefix" + sf_c + "suffix1" + sf_o + "suffix2");
        test("C91", "" + sf_c + s_strU2);
        test("C91suffix", "" + sf_c + s_strU2 + "suffix");
        test("prefixCsuffix191suffix2", "prefix" + sf_c + "suffix1" + s_strU2 + "suffix2");
        test("C21", "" + sf_c + f_strU1);
        test("C21suffix", "" + sf_c + f_strU1 + "suffix");
        test("prefixCsuffix121suffix2", "prefix" + sf_c + "suffix1" + f_strU1 + "suffix2");
        test("C18", "" + sf_c + f_strU2);
        test("C18suffix", "" + sf_c + f_strU2 + "suffix");
        test("prefixCsuffix118suffix2", "prefix" + sf_c + "suffix1" + f_strU2 + "suffix2");
        test("Cnull", "" + sf_c + f_iAN);
        test("Cnullsuffix", "" + sf_c + f_iAN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + f_iAN + "suffix2");
        test("Cnull", "" + sf_c + s_oN);
        test("Cnullsuffix", "" + sf_c + s_oN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + s_oN + "suffix2");
        test("C\u045180", "" + sf_c + s_strU);
        test("C\u045180suffix", "" + sf_c + s_strU + "suffix");
        test("prefixCsuffix1\u045180suffix2", "prefix" + sf_c + "suffix1" + s_strU + "suffix2");
        test("CC", "" + sf_c + sf_c);
        test("CCsuffix", "" + sf_c + sf_c + "suffix");
        test("prefixCsuffix1Csuffix2", "prefix" + sf_c + "suffix1" + sf_c + "suffix2");
        test("C75", "" + sf_c + sf_str);
        test("C75suffix", "" + sf_c + sf_str + "suffix");
        test("prefixCsuffix175suffix2", "prefix" + sf_c + "suffix1" + sf_str + "suffix2");
        test("C-43", "" + sf_c + s_bM);
        test("C-43suffix", "" + sf_c + s_bM + "suffix");
        test("prefixCsuffix1-43suffix2", "prefix" + sf_c + "suffix1" + s_bM + "suffix2");
        test("C80", "" + sf_c + sf_b);
        test("C80suffix", "" + sf_c + sf_b + "suffix");
        test("prefixCsuffix180suffix2", "prefix" + sf_c + "suffix1" + sf_b + "suffix2");
        test("Cnull", "" + sf_c + s_IN);
        test("Cnullsuffix", "" + sf_c + s_IN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + s_IN + "suffix2");
        test("C-52.0", "" + sf_c + s_fM);
        test("C-52.0suffix", "" + sf_c + s_fM + "suffix");
        test("prefixCsuffix1-52.0suffix2", "prefix" + sf_c + "suffix1" + s_fM + "suffix2");
        test("C75000000", "" + sf_c + sf_i);
        test("C75000000suffix", "" + sf_c + sf_i + "suffix");
        test("prefixCsuffix175000000suffix2", "prefix" + sf_c + "suffix1" + sf_i + "suffix2");
        test("C44", "" + sf_c + f_b);
        test("C44suffix", "" + sf_c + f_b + "suffix");
        test("prefixCsuffix144suffix2", "prefix" + sf_c + "suffix1" + f_b + "suffix2");
        test("C-1705032704", "" + sf_c + sf_lM);
        test("C-1705032704suffix", "" + sf_c + sf_lM + "suffix");
        test("prefixCsuffix1-1705032704suffix2", "prefix" + sf_c + "suffix1" + sf_lM + "suffix2");
        test("Cnull", "" + sf_c + f_oAN);
        test("Cnullsuffix", "" + sf_c + f_oAN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + f_oAN + "suffix2");
        test("C83.0", "" + sf_c + f_d);
        test("C83.0suffix", "" + sf_c + f_d + "suffix");
        test("prefixCsuffix183.0suffix2", "prefix" + sf_c + "suffix1" + f_d + "suffix2");
        test("CI", "" + sf_c + f_c);
        test("CIsuffix", "" + sf_c + f_c + "suffix");
        test("prefixCsuffix1Isuffix2", "prefix" + sf_c + "suffix1" + f_c + "suffix2");
        test("C94.0", "" + sf_c + f_f);
        test("C94.0suffix", "" + sf_c + f_f + "suffix");
        test("prefixCsuffix194.0suffix2", "prefix" + sf_c + "suffix1" + f_f + "suffix2");
        test("C12.0", "" + sf_c + sf_d);
        test("C12.0suffix", "" + sf_c + sf_d + "suffix");
        test("prefixCsuffix112.0suffix2", "prefix" + sf_c + "suffix1" + sf_d + "suffix2");
        test("C-99.0", "" + sf_c + f_dM);
        test("C-99.0suffix", "" + sf_c + f_dM + "suffix");
        test("prefixCsuffix1-99.0suffix2", "prefix" + sf_c + "suffix1" + f_dM + "suffix2");
        test("C17.0", "" + sf_c + sf_f);
        test("C17.0suffix", "" + sf_c + sf_f + "suffix");
        test("prefixCsuffix117.0suffix2", "prefix" + sf_c + "suffix1" + sf_f + "suffix2");
        test("C-84.0", "" + sf_c + sf_dM);
        test("C-84.0suffix", "" + sf_c + sf_dM + "suffix");
        test("prefixCsuffix1-84.0suffix2", "prefix" + sf_c + "suffix1" + sf_dM + "suffix2");
        test("C58000000", "" + sf_c + f_i);
        test("C58000000suffix", "" + sf_c + f_i + "suffix");
        test("prefixCsuffix158000000suffix2", "prefix" + sf_c + "suffix1" + f_i + "suffix2");
        test("C-55000000", "" + sf_c + f_iM);
        test("C-55000000suffix", "" + sf_c + f_iM + "suffix");
        test("prefixCsuffix1-55000000suffix2", "prefix" + sf_c + "suffix1" + f_iM + "suffix2");
        test("C1460392448", "" + sf_c + f_l);
        test("C1460392448suffix", "" + sf_c + f_l + "suffix");
        test("prefixCsuffix11460392448suffix2", "prefix" + sf_c + "suffix1" + f_l + "suffix2");
        test("CC(70)", "" + sf_c + f_o);
        test("CC(70)suffix", "" + sf_c + f_o + "suffix");
        test("prefixCsuffix1C(70)suffix2", "prefix" + sf_c + "suffix1" + f_o + "suffix2");
        test("C\u04511", "" + sf_c + sf_strU);
        test("C\u04511suffix", "" + sf_c + sf_strU + "suffix");
        test("prefixCsuffix1\u04511suffix2", "prefix" + sf_c + "suffix1" + sf_strU + "suffix2");
        test("C8000", "" + sf_c + f_s);
        test("C8000suffix", "" + sf_c + f_s + "suffix");
        test("prefixCsuffix18000suffix2", "prefix" + sf_c + "suffix1" + f_s + "suffix2");
        test("C18", "" + sf_c + s_str);
        test("C18suffix", "" + sf_c + s_str + "suffix");
        test("prefixCsuffix118suffix2", "prefix" + sf_c + "suffix1" + s_str + "suffix2");
        test("C-1000000", "" + sf_c + s_iM);
        test("C-1000000suffix", "" + sf_c + s_iM + "suffix");
        test("prefixCsuffix1-1000000suffix2", "prefix" + sf_c + "suffix1" + s_iM + "suffix2");
        test("C1000000", "" + sf_c + sf_I);
        test("C1000000suffix", "" + sf_c + sf_I + "suffix");
        test("prefixCsuffix11000000suffix2", "prefix" + sf_c + "suffix1" + sf_I + "suffix2");
        test("Cnull", "" + sf_c + f_oNtS);
        test("Cnullsuffix", "" + sf_c + f_oNtS + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + f_oNtS + "suffix2");
        test("Cfalse", "" + sf_c + f_bl);
        test("Cfalsesuffix", "" + sf_c + f_bl + "suffix");
        test("prefixCsuffix1falsesuffix2", "prefix" + sf_c + "suffix1" + f_bl + "suffix2");
        test("Cnull", "" + sf_c + sf_iAN);
        test("Cnullsuffix", "" + sf_c + sf_iAN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + sf_iAN + "suffix2");
        test("C-2000000", "" + sf_c + sf_iM);
        test("C-2000000suffix", "" + sf_c + sf_iM + "suffix");
        test("prefixCsuffix1-2000000suffix2", "prefix" + sf_c + "suffix1" + sf_iM + "suffix2");
        test("C-820130816", "" + sf_c + f_lM);
        test("C-820130816suffix", "" + sf_c + f_lM + "suffix");
        test("prefixCsuffix1-820130816suffix2", "prefix" + sf_c + "suffix1" + f_lM + "suffix2");
        test("Cnull", "" + sf_c + sf_oAN);
        test("Cnullsuffix", "" + sf_c + sf_oAN + "suffix");
        test("prefixCsuffix1nullsuffix2", "prefix" + sf_c + "suffix1" + sf_oAN + "suffix2");
        test("C25000000", "" + sf_c + s_I);
        test("C25000000suffix", "" + sf_c + s_I + "suffix");
        test("prefixCsuffix125000000suffix2", "prefix" + sf_c + "suffix1" + s_I + "suffix2");
        test("75-96.0", "" + sf_str + s_dM);
        test("75-96.0suffix", "" + sf_str + s_dM + "suffix");
        test("prefix75suffix1-96.0suffix2", "prefix" + sf_str + "suffix1" + s_dM + "suffix2");
        test("75null", "" + sf_str + s_oNtS);
        test("75nullsuffix", "" + sf_str + s_oNtS + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + s_oNtS + "suffix2");
        test("75\u045176", "" + sf_str + f_strU);
        test("75\u045176suffix", "" + sf_str + f_strU + "suffix");
        test("prefix75suffix1\u045176suffix2", "prefix" + sf_str + "suffix1" + f_strU + "suffix2");
        test("7592", "" + sf_str + sf_strU2);
        test("7592suffix", "" + sf_str + sf_strU2 + "suffix");
        test("prefix75suffix192suffix2", "prefix" + sf_str + "suffix1" + sf_strU2 + "suffix2");
        test("7551", "" + sf_str + sf_strU1);
        test("7551suffix", "" + sf_str + sf_strU1 + "suffix");
        test("prefix75suffix151suffix2", "prefix" + sf_str + "suffix1" + sf_strU1 + "suffix2");
        test("75null", "" + sf_str + s_iAN);
        test("75nullsuffix", "" + sf_str + s_iAN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + s_iAN + "suffix2");
        test("75-54", "" + sf_str + f_bM);
        test("75-54suffix", "" + sf_str + f_bM + "suffix");
        test("prefix75suffix1-54suffix2", "prefix" + sf_str + "suffix1" + f_bM + "suffix2");
        test("75-87.0", "" + sf_str + f_fM);
        test("75-87.0suffix", "" + sf_str + f_fM + "suffix");
        test("prefix75suffix1-87.0suffix2", "prefix" + sf_str + "suffix1" + f_fM + "suffix2");
        test("75null", "" + sf_str + s_oAN);
    }

    public void run10() {
        test("75nullsuffix", "" + sf_str + s_oAN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + s_oAN + "suffix2");
        test("7519", "" + sf_str + f_str);
        test("7519suffix", "" + sf_str + f_str + "suffix");
        test("prefix75suffix119suffix2", "prefix" + sf_str + "suffix1" + f_str + "suffix2");
        test("75-41", "" + sf_str + sf_bM);
        test("75-41suffix", "" + sf_str + sf_bM + "suffix");
        test("prefix75suffix1-41suffix2", "prefix" + sf_str + "suffix1" + sf_bM + "suffix2");
        test("75null", "" + sf_str + sf_IN);
        test("75nullsuffix", "" + sf_str + sf_IN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + sf_IN + "suffix2");
        test("75T", "" + sf_str + s_c);
        test("75Tsuffix", "" + sf_str + s_c + "suffix");
        test("prefix75suffix1Tsuffix2", "prefix" + sf_str + "suffix1" + s_c + "suffix2");
        test("75-42.0", "" + sf_str + sf_fM);
        test("75-42.0suffix", "" + sf_str + sf_fM + "suffix");
        test("prefix75suffix1-42.0suffix2", "prefix" + sf_str + "suffix1" + sf_fM + "suffix2");
        test("7525", "" + sf_str + s_b);
        test("7525suffix", "" + sf_str + s_b + "suffix");
        test("prefix75suffix125suffix2", "prefix" + sf_str + "suffix1" + s_b + "suffix2");
        test("75null", "" + sf_str + f_oN);
        test("75nullsuffix", "" + sf_str + f_oN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + f_oN + "suffix2");
        test("75-1410065408", "" + sf_str + s_lM);
        test("75-1410065408suffix", "" + sf_str + s_lM + "suffix");
        test("prefix75suffix1-1410065408suffix2", "prefix" + sf_str + "suffix1" + s_lM + "suffix2");
        test("758.0", "" + sf_str + s_d);
        test("758.0suffix", "" + sf_str + s_d + "suffix");
        test("prefix75suffix18.0suffix2", "prefix" + sf_str + "suffix1" + s_d + "suffix2");
        test("7555.0", "" + sf_str + s_f);
        test("7555.0suffix", "" + sf_str + s_f + "suffix");
        test("prefix75suffix155.0suffix2", "prefix" + sf_str + "suffix1" + s_f + "suffix2");
        test("7597000000", "" + sf_str + s_i);
        test("7597000000suffix", "" + sf_str + s_i + "suffix");
        test("prefix75suffix197000000suffix2", "prefix" + sf_str + "suffix1" + s_i + "suffix2");
        test("75-9900", "" + sf_str + f_sM);
        test("75-9900suffix", "" + sf_str + f_sM + "suffix");
        test("prefix75suffix1-9900suffix2", "prefix" + sf_str + "suffix1" + f_sM + "suffix2");
        test("75935228928", "" + sf_str + s_l);
        test("75935228928suffix", "" + sf_str + s_l + "suffix");
        test("prefix75suffix1935228928suffix2", "prefix" + sf_str + "suffix1" + s_l + "suffix2");
        test("75-8400", "" + sf_str + sf_sM);
        test("75-8400suffix", "" + sf_str + sf_sM + "suffix");
        test("prefix75suffix1-8400suffix2", "prefix" + sf_str + "suffix1" + sf_sM + "suffix2");
        test("75C(82)", "" + sf_str + s_o);
        test("75C(82)suffix", "" + sf_str + s_o + "suffix");
        test("prefix75suffix1C(82)suffix2", "prefix" + sf_str + "suffix1" + s_o + "suffix2");
        test("75null", "" + sf_str + sf_oNtS);
        test("75nullsuffix", "" + sf_str + sf_oNtS + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + sf_oNtS + "suffix2");
        test("75true", "" + sf_str + s_bl);
        test("75truesuffix", "" + sf_str + s_bl + "suffix");
        test("prefix75suffix1truesuffix2", "prefix" + sf_str + "suffix1" + s_bl + "suffix2");
        test("753900", "" + sf_str + s_s);
        test("753900suffix", "" + sf_str + s_s + "suffix");
        test("prefix75suffix13900suffix2", "prefix" + sf_str + "suffix1" + s_s + "suffix2");
        test("75null", "" + sf_str + sf_oN);
        test("75nullsuffix", "" + sf_str + sf_oN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + sf_oN + "suffix2");
        test("7594000000", "" + sf_str + f_I);
        test("7594000000suffix", "" + sf_str + f_I + "suffix");
        test("prefix75suffix194000000suffix2", "prefix" + sf_str + "suffix1" + f_I + "suffix2");
        test("75null", "" + sf_str + f_IN);
        test("75nullsuffix", "" + sf_str + f_IN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + f_IN + "suffix2");
        test("75true", "" + sf_str + sf_bl);
        test("75truesuffix", "" + sf_str + sf_bl + "suffix");
        test("prefix75suffix1truesuffix2", "prefix" + sf_str + "suffix1" + sf_bl + "suffix2");
        test("755500", "" + sf_str + sf_s);
        test("755500suffix", "" + sf_str + sf_s + "suffix");
        test("prefix75suffix15500suffix2", "prefix" + sf_str + "suffix1" + sf_s + "suffix2");
        test("75-2900", "" + sf_str + s_sM);
        test("75-2900suffix", "" + sf_str + s_sM + "suffix");
        test("prefix75suffix1-2900suffix2", "prefix" + sf_str + "suffix1" + s_sM + "suffix2");
        test("75-194313216", "" + sf_str + sf_l);
        test("75-194313216suffix", "" + sf_str + sf_l + "suffix");
        test("prefix75suffix1-194313216suffix2", "prefix" + sf_str + "suffix1" + sf_l + "suffix2");
        test("7512", "" + sf_str + s_strU1);
        test("7512suffix", "" + sf_str + s_strU1 + "suffix");
        test("prefix75suffix112suffix2", "prefix" + sf_str + "suffix1" + s_strU1 + "suffix2");
        test("75C(87)", "" + sf_str + sf_o);
        test("75C(87)suffix", "" + sf_str + sf_o + "suffix");
        test("prefix75suffix1C(87)suffix2", "prefix" + sf_str + "suffix1" + sf_o + "suffix2");
        test("7591", "" + sf_str + s_strU2);
        test("7591suffix", "" + sf_str + s_strU2 + "suffix");
        test("prefix75suffix191suffix2", "prefix" + sf_str + "suffix1" + s_strU2 + "suffix2");
        test("7521", "" + sf_str + f_strU1);
        test("7521suffix", "" + sf_str + f_strU1 + "suffix");
        test("prefix75suffix121suffix2", "prefix" + sf_str + "suffix1" + f_strU1 + "suffix2");
        test("7518", "" + sf_str + f_strU2);
        test("7518suffix", "" + sf_str + f_strU2 + "suffix");
        test("prefix75suffix118suffix2", "prefix" + sf_str + "suffix1" + f_strU2 + "suffix2");
        test("75null", "" + sf_str + f_iAN);
        test("75nullsuffix", "" + sf_str + f_iAN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + f_iAN + "suffix2");
        test("75null", "" + sf_str + s_oN);
        test("75nullsuffix", "" + sf_str + s_oN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + s_oN + "suffix2");
        test("75\u045180", "" + sf_str + s_strU);
        test("75\u045180suffix", "" + sf_str + s_strU + "suffix");
        test("prefix75suffix1\u045180suffix2", "prefix" + sf_str + "suffix1" + s_strU + "suffix2");
        test("75C", "" + sf_str + sf_c);
        test("75Csuffix", "" + sf_str + sf_c + "suffix");
        test("prefix75suffix1Csuffix2", "prefix" + sf_str + "suffix1" + sf_c + "suffix2");
        test("7575", "" + sf_str + sf_str);
        test("7575suffix", "" + sf_str + sf_str + "suffix");
        test("prefix75suffix175suffix2", "prefix" + sf_str + "suffix1" + sf_str + "suffix2");
        test("75-43", "" + sf_str + s_bM);
        test("75-43suffix", "" + sf_str + s_bM + "suffix");
        test("prefix75suffix1-43suffix2", "prefix" + sf_str + "suffix1" + s_bM + "suffix2");
        test("7580", "" + sf_str + sf_b);
        test("7580suffix", "" + sf_str + sf_b + "suffix");
        test("prefix75suffix180suffix2", "prefix" + sf_str + "suffix1" + sf_b + "suffix2");
        test("75null", "" + sf_str + s_IN);
        test("75nullsuffix", "" + sf_str + s_IN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + s_IN + "suffix2");
        test("75-52.0", "" + sf_str + s_fM);
        test("75-52.0suffix", "" + sf_str + s_fM + "suffix");
        test("prefix75suffix1-52.0suffix2", "prefix" + sf_str + "suffix1" + s_fM + "suffix2");
        test("7575000000", "" + sf_str + sf_i);
        test("7575000000suffix", "" + sf_str + sf_i + "suffix");
        test("prefix75suffix175000000suffix2", "prefix" + sf_str + "suffix1" + sf_i + "suffix2");
        test("7544", "" + sf_str + f_b);
        test("7544suffix", "" + sf_str + f_b + "suffix");
        test("prefix75suffix144suffix2", "prefix" + sf_str + "suffix1" + f_b + "suffix2");
        test("75-1705032704", "" + sf_str + sf_lM);
        test("75-1705032704suffix", "" + sf_str + sf_lM + "suffix");
        test("prefix75suffix1-1705032704suffix2", "prefix" + sf_str + "suffix1" + sf_lM + "suffix2");
        test("75null", "" + sf_str + f_oAN);
        test("75nullsuffix", "" + sf_str + f_oAN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + f_oAN + "suffix2");
        test("7583.0", "" + sf_str + f_d);
        test("7583.0suffix", "" + sf_str + f_d + "suffix");
        test("prefix75suffix183.0suffix2", "prefix" + sf_str + "suffix1" + f_d + "suffix2");
        test("75I", "" + sf_str + f_c);
        test("75Isuffix", "" + sf_str + f_c + "suffix");
        test("prefix75suffix1Isuffix2", "prefix" + sf_str + "suffix1" + f_c + "suffix2");
        test("7594.0", "" + sf_str + f_f);
        test("7594.0suffix", "" + sf_str + f_f + "suffix");
        test("prefix75suffix194.0suffix2", "prefix" + sf_str + "suffix1" + f_f + "suffix2");
        test("7512.0", "" + sf_str + sf_d);
        test("7512.0suffix", "" + sf_str + sf_d + "suffix");
        test("prefix75suffix112.0suffix2", "prefix" + sf_str + "suffix1" + sf_d + "suffix2");
        test("75-99.0", "" + sf_str + f_dM);
        test("75-99.0suffix", "" + sf_str + f_dM + "suffix");
        test("prefix75suffix1-99.0suffix2", "prefix" + sf_str + "suffix1" + f_dM + "suffix2");
        test("7517.0", "" + sf_str + sf_f);
        test("7517.0suffix", "" + sf_str + sf_f + "suffix");
        test("prefix75suffix117.0suffix2", "prefix" + sf_str + "suffix1" + sf_f + "suffix2");
        test("75-84.0", "" + sf_str + sf_dM);
        test("75-84.0suffix", "" + sf_str + sf_dM + "suffix");
        test("prefix75suffix1-84.0suffix2", "prefix" + sf_str + "suffix1" + sf_dM + "suffix2");
        test("7558000000", "" + sf_str + f_i);
        test("7558000000suffix", "" + sf_str + f_i + "suffix");
        test("prefix75suffix158000000suffix2", "prefix" + sf_str + "suffix1" + f_i + "suffix2");
        test("75-55000000", "" + sf_str + f_iM);
        test("75-55000000suffix", "" + sf_str + f_iM + "suffix");
        test("prefix75suffix1-55000000suffix2", "prefix" + sf_str + "suffix1" + f_iM + "suffix2");
        test("751460392448", "" + sf_str + f_l);
        test("751460392448suffix", "" + sf_str + f_l + "suffix");
        test("prefix75suffix11460392448suffix2", "prefix" + sf_str + "suffix1" + f_l + "suffix2");
        test("75C(70)", "" + sf_str + f_o);
        test("75C(70)suffix", "" + sf_str + f_o + "suffix");
        test("prefix75suffix1C(70)suffix2", "prefix" + sf_str + "suffix1" + f_o + "suffix2");
        test("75\u04511", "" + sf_str + sf_strU);
        test("75\u04511suffix", "" + sf_str + sf_strU + "suffix");
        test("prefix75suffix1\u04511suffix2", "prefix" + sf_str + "suffix1" + sf_strU + "suffix2");
        test("758000", "" + sf_str + f_s);
        test("758000suffix", "" + sf_str + f_s + "suffix");
        test("prefix75suffix18000suffix2", "prefix" + sf_str + "suffix1" + f_s + "suffix2");
        test("7518", "" + sf_str + s_str);
        test("7518suffix", "" + sf_str + s_str + "suffix");
        test("prefix75suffix118suffix2", "prefix" + sf_str + "suffix1" + s_str + "suffix2");
        test("75-1000000", "" + sf_str + s_iM);
        test("75-1000000suffix", "" + sf_str + s_iM + "suffix");
        test("prefix75suffix1-1000000suffix2", "prefix" + sf_str + "suffix1" + s_iM + "suffix2");
        test("751000000", "" + sf_str + sf_I);
        test("751000000suffix", "" + sf_str + sf_I + "suffix");
        test("prefix75suffix11000000suffix2", "prefix" + sf_str + "suffix1" + sf_I + "suffix2");
        test("75null", "" + sf_str + f_oNtS);
        test("75nullsuffix", "" + sf_str + f_oNtS + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + f_oNtS + "suffix2");
        test("75false", "" + sf_str + f_bl);
        test("75falsesuffix", "" + sf_str + f_bl + "suffix");
        test("prefix75suffix1falsesuffix2", "prefix" + sf_str + "suffix1" + f_bl + "suffix2");
        test("75null", "" + sf_str + sf_iAN);
        test("75nullsuffix", "" + sf_str + sf_iAN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + sf_iAN + "suffix2");
        test("75-2000000", "" + sf_str + sf_iM);
        test("75-2000000suffix", "" + sf_str + sf_iM + "suffix");
        test("prefix75suffix1-2000000suffix2", "prefix" + sf_str + "suffix1" + sf_iM + "suffix2");
        test("75-820130816", "" + sf_str + f_lM);
        test("75-820130816suffix", "" + sf_str + f_lM + "suffix");
        test("prefix75suffix1-820130816suffix2", "prefix" + sf_str + "suffix1" + f_lM + "suffix2");
        test("75null", "" + sf_str + sf_oAN);
        test("75nullsuffix", "" + sf_str + sf_oAN + "suffix");
        test("prefix75suffix1nullsuffix2", "prefix" + sf_str + "suffix1" + sf_oAN + "suffix2");
        test("7525000000", "" + sf_str + s_I);
        test("7525000000suffix", "" + sf_str + s_I + "suffix");
        test("prefix75suffix125000000suffix2", "prefix" + sf_str + "suffix1" + s_I + "suffix2");
        test("-43-96.0", "" + s_bM + s_dM);
        test("-43-96.0suffix", "" + s_bM + s_dM + "suffix");
        test("prefix-43suffix1-96.0suffix2", "prefix" + s_bM + "suffix1" + s_dM + "suffix2");
        test("-43null", "" + s_bM + s_oNtS);
        test("-43nullsuffix", "" + s_bM + s_oNtS + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + s_oNtS + "suffix2");
        test("-43\u045176", "" + s_bM + f_strU);
        test("-43\u045176suffix", "" + s_bM + f_strU + "suffix");
        test("prefix-43suffix1\u045176suffix2", "prefix" + s_bM + "suffix1" + f_strU + "suffix2");
        test("-4392", "" + s_bM + sf_strU2);
        test("-4392suffix", "" + s_bM + sf_strU2 + "suffix");
        test("prefix-43suffix192suffix2", "prefix" + s_bM + "suffix1" + sf_strU2 + "suffix2");
        test("-4351", "" + s_bM + sf_strU1);
        test("-4351suffix", "" + s_bM + sf_strU1 + "suffix");
        test("prefix-43suffix151suffix2", "prefix" + s_bM + "suffix1" + sf_strU1 + "suffix2");
        test("-43null", "" + s_bM + s_iAN);
        test("-43nullsuffix", "" + s_bM + s_iAN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + s_iAN + "suffix2");
        test("-43-54", "" + s_bM + f_bM);
        test("-43-54suffix", "" + s_bM + f_bM + "suffix");
        test("prefix-43suffix1-54suffix2", "prefix" + s_bM + "suffix1" + f_bM + "suffix2");
        test("-43-87.0", "" + s_bM + f_fM);
        test("-43-87.0suffix", "" + s_bM + f_fM + "suffix");
        test("prefix-43suffix1-87.0suffix2", "prefix" + s_bM + "suffix1" + f_fM + "suffix2");
        test("-43null", "" + s_bM + s_oAN);
        test("-43nullsuffix", "" + s_bM + s_oAN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + s_oAN + "suffix2");
        test("-4319", "" + s_bM + f_str);
        test("-4319suffix", "" + s_bM + f_str + "suffix");
        test("prefix-43suffix119suffix2", "prefix" + s_bM + "suffix1" + f_str + "suffix2");
        test("-43-41", "" + s_bM + sf_bM);
        test("-43-41suffix", "" + s_bM + sf_bM + "suffix");
        test("prefix-43suffix1-41suffix2", "prefix" + s_bM + "suffix1" + sf_bM + "suffix2");
        test("-43null", "" + s_bM + sf_IN);
        test("-43nullsuffix", "" + s_bM + sf_IN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + sf_IN + "suffix2");
        test("-43T", "" + s_bM + s_c);
        test("-43Tsuffix", "" + s_bM + s_c + "suffix");
        test("prefix-43suffix1Tsuffix2", "prefix" + s_bM + "suffix1" + s_c + "suffix2");
        test("-43-42.0", "" + s_bM + sf_fM);
        test("-43-42.0suffix", "" + s_bM + sf_fM + "suffix");
        test("prefix-43suffix1-42.0suffix2", "prefix" + s_bM + "suffix1" + sf_fM + "suffix2");
        test("-4325", "" + s_bM + s_b);
        test("-4325suffix", "" + s_bM + s_b + "suffix");
        test("prefix-43suffix125suffix2", "prefix" + s_bM + "suffix1" + s_b + "suffix2");
        test("-43null", "" + s_bM + f_oN);
        test("-43nullsuffix", "" + s_bM + f_oN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + f_oN + "suffix2");
        test("-43-1410065408", "" + s_bM + s_lM);
        test("-43-1410065408suffix", "" + s_bM + s_lM + "suffix");
        test("prefix-43suffix1-1410065408suffix2", "prefix" + s_bM + "suffix1" + s_lM + "suffix2");
        test("-438.0", "" + s_bM + s_d);
        test("-438.0suffix", "" + s_bM + s_d + "suffix");
        test("prefix-43suffix18.0suffix2", "prefix" + s_bM + "suffix1" + s_d + "suffix2");
        test("-4355.0", "" + s_bM + s_f);
        test("-4355.0suffix", "" + s_bM + s_f + "suffix");
        test("prefix-43suffix155.0suffix2", "prefix" + s_bM + "suffix1" + s_f + "suffix2");
        test("-4397000000", "" + s_bM + s_i);
        test("-4397000000suffix", "" + s_bM + s_i + "suffix");
        test("prefix-43suffix197000000suffix2", "prefix" + s_bM + "suffix1" + s_i + "suffix2");
        test("-43-9900", "" + s_bM + f_sM);
        test("-43-9900suffix", "" + s_bM + f_sM + "suffix");
        test("prefix-43suffix1-9900suffix2", "prefix" + s_bM + "suffix1" + f_sM + "suffix2");
        test("-43935228928", "" + s_bM + s_l);
        test("-43935228928suffix", "" + s_bM + s_l + "suffix");
        test("prefix-43suffix1935228928suffix2", "prefix" + s_bM + "suffix1" + s_l + "suffix2");
        test("-43-8400", "" + s_bM + sf_sM);
        test("-43-8400suffix", "" + s_bM + sf_sM + "suffix");
        test("prefix-43suffix1-8400suffix2", "prefix" + s_bM + "suffix1" + sf_sM + "suffix2");
        test("-43C(82)", "" + s_bM + s_o);
        test("-43C(82)suffix", "" + s_bM + s_o + "suffix");
        test("prefix-43suffix1C(82)suffix2", "prefix" + s_bM + "suffix1" + s_o + "suffix2");
        test("-43null", "" + s_bM + sf_oNtS);
        test("-43nullsuffix", "" + s_bM + sf_oNtS + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + sf_oNtS + "suffix2");
        test("-43true", "" + s_bM + s_bl);
        test("-43truesuffix", "" + s_bM + s_bl + "suffix");
        test("prefix-43suffix1truesuffix2", "prefix" + s_bM + "suffix1" + s_bl + "suffix2");
        test("-433900", "" + s_bM + s_s);
        test("-433900suffix", "" + s_bM + s_s + "suffix");
        test("prefix-43suffix13900suffix2", "prefix" + s_bM + "suffix1" + s_s + "suffix2");
        test("-43null", "" + s_bM + sf_oN);
        test("-43nullsuffix", "" + s_bM + sf_oN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + sf_oN + "suffix2");
        test("-4394000000", "" + s_bM + f_I);
        test("-4394000000suffix", "" + s_bM + f_I + "suffix");
        test("prefix-43suffix194000000suffix2", "prefix" + s_bM + "suffix1" + f_I + "suffix2");
        test("-43null", "" + s_bM + f_IN);
        test("-43nullsuffix", "" + s_bM + f_IN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + f_IN + "suffix2");
        test("-43true", "" + s_bM + sf_bl);
        test("-43truesuffix", "" + s_bM + sf_bl + "suffix");
        test("prefix-43suffix1truesuffix2", "prefix" + s_bM + "suffix1" + sf_bl + "suffix2");
        test("-435500", "" + s_bM + sf_s);
        test("-435500suffix", "" + s_bM + sf_s + "suffix");
        test("prefix-43suffix15500suffix2", "prefix" + s_bM + "suffix1" + sf_s + "suffix2");
        test("-43-2900", "" + s_bM + s_sM);
        test("-43-2900suffix", "" + s_bM + s_sM + "suffix");
        test("prefix-43suffix1-2900suffix2", "prefix" + s_bM + "suffix1" + s_sM + "suffix2");
        test("-43-194313216", "" + s_bM + sf_l);
        test("-43-194313216suffix", "" + s_bM + sf_l + "suffix");
        test("prefix-43suffix1-194313216suffix2", "prefix" + s_bM + "suffix1" + sf_l + "suffix2");
        test("-4312", "" + s_bM + s_strU1);
        test("-4312suffix", "" + s_bM + s_strU1 + "suffix");
        test("prefix-43suffix112suffix2", "prefix" + s_bM + "suffix1" + s_strU1 + "suffix2");
        test("-43C(87)", "" + s_bM + sf_o);
        test("-43C(87)suffix", "" + s_bM + sf_o + "suffix");
        test("prefix-43suffix1C(87)suffix2", "prefix" + s_bM + "suffix1" + sf_o + "suffix2");
        test("-4391", "" + s_bM + s_strU2);
        test("-4391suffix", "" + s_bM + s_strU2 + "suffix");
        test("prefix-43suffix191suffix2", "prefix" + s_bM + "suffix1" + s_strU2 + "suffix2");
        test("-4321", "" + s_bM + f_strU1);
        test("-4321suffix", "" + s_bM + f_strU1 + "suffix");
        test("prefix-43suffix121suffix2", "prefix" + s_bM + "suffix1" + f_strU1 + "suffix2");
        test("-4318", "" + s_bM + f_strU2);
        test("-4318suffix", "" + s_bM + f_strU2 + "suffix");
        test("prefix-43suffix118suffix2", "prefix" + s_bM + "suffix1" + f_strU2 + "suffix2");
        test("-43null", "" + s_bM + f_iAN);
        test("-43nullsuffix", "" + s_bM + f_iAN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + f_iAN + "suffix2");
        test("-43null", "" + s_bM + s_oN);
        test("-43nullsuffix", "" + s_bM + s_oN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + s_oN + "suffix2");
        test("-43\u045180", "" + s_bM + s_strU);
        test("-43\u045180suffix", "" + s_bM + s_strU + "suffix");
        test("prefix-43suffix1\u045180suffix2", "prefix" + s_bM + "suffix1" + s_strU + "suffix2");
        test("-43C", "" + s_bM + sf_c);
        test("-43Csuffix", "" + s_bM + sf_c + "suffix");
        test("prefix-43suffix1Csuffix2", "prefix" + s_bM + "suffix1" + sf_c + "suffix2");
        test("-4375", "" + s_bM + sf_str);
        test("-4375suffix", "" + s_bM + sf_str + "suffix");
        test("prefix-43suffix175suffix2", "prefix" + s_bM + "suffix1" + sf_str + "suffix2");
        test("-43-43", "" + s_bM + s_bM);
        test("-43-43suffix", "" + s_bM + s_bM + "suffix");
        test("prefix-43suffix1-43suffix2", "prefix" + s_bM + "suffix1" + s_bM + "suffix2");
        test("-4380", "" + s_bM + sf_b);
        test("-4380suffix", "" + s_bM + sf_b + "suffix");
        test("prefix-43suffix180suffix2", "prefix" + s_bM + "suffix1" + sf_b + "suffix2");
        test("-43null", "" + s_bM + s_IN);
        test("-43nullsuffix", "" + s_bM + s_IN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + s_IN + "suffix2");
        test("-43-52.0", "" + s_bM + s_fM);
        test("-43-52.0suffix", "" + s_bM + s_fM + "suffix");
        test("prefix-43suffix1-52.0suffix2", "prefix" + s_bM + "suffix1" + s_fM + "suffix2");
        test("-4375000000", "" + s_bM + sf_i);
        test("-4375000000suffix", "" + s_bM + sf_i + "suffix");
        test("prefix-43suffix175000000suffix2", "prefix" + s_bM + "suffix1" + sf_i + "suffix2");
        test("-4344", "" + s_bM + f_b);
        test("-4344suffix", "" + s_bM + f_b + "suffix");
        test("prefix-43suffix144suffix2", "prefix" + s_bM + "suffix1" + f_b + "suffix2");
        test("-43-1705032704", "" + s_bM + sf_lM);
        test("-43-1705032704suffix", "" + s_bM + sf_lM + "suffix");
        test("prefix-43suffix1-1705032704suffix2", "prefix" + s_bM + "suffix1" + sf_lM + "suffix2");
        test("-43null", "" + s_bM + f_oAN);
        test("-43nullsuffix", "" + s_bM + f_oAN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + f_oAN + "suffix2");
        test("-4383.0", "" + s_bM + f_d);
        test("-4383.0suffix", "" + s_bM + f_d + "suffix");
        test("prefix-43suffix183.0suffix2", "prefix" + s_bM + "suffix1" + f_d + "suffix2");
        test("-43I", "" + s_bM + f_c);
        test("-43Isuffix", "" + s_bM + f_c + "suffix");
        test("prefix-43suffix1Isuffix2", "prefix" + s_bM + "suffix1" + f_c + "suffix2");
        test("-4394.0", "" + s_bM + f_f);
        test("-4394.0suffix", "" + s_bM + f_f + "suffix");
        test("prefix-43suffix194.0suffix2", "prefix" + s_bM + "suffix1" + f_f + "suffix2");
        test("-4312.0", "" + s_bM + sf_d);
        test("-4312.0suffix", "" + s_bM + sf_d + "suffix");
        test("prefix-43suffix112.0suffix2", "prefix" + s_bM + "suffix1" + sf_d + "suffix2");
        test("-43-99.0", "" + s_bM + f_dM);
        test("-43-99.0suffix", "" + s_bM + f_dM + "suffix");
        test("prefix-43suffix1-99.0suffix2", "prefix" + s_bM + "suffix1" + f_dM + "suffix2");
        test("-4317.0", "" + s_bM + sf_f);
        test("-4317.0suffix", "" + s_bM + sf_f + "suffix");
        test("prefix-43suffix117.0suffix2", "prefix" + s_bM + "suffix1" + sf_f + "suffix2");
        test("-43-84.0", "" + s_bM + sf_dM);
        test("-43-84.0suffix", "" + s_bM + sf_dM + "suffix");
        test("prefix-43suffix1-84.0suffix2", "prefix" + s_bM + "suffix1" + sf_dM + "suffix2");
        test("-4358000000", "" + s_bM + f_i);
        test("-4358000000suffix", "" + s_bM + f_i + "suffix");
        test("prefix-43suffix158000000suffix2", "prefix" + s_bM + "suffix1" + f_i + "suffix2");
        test("-43-55000000", "" + s_bM + f_iM);
        test("-43-55000000suffix", "" + s_bM + f_iM + "suffix");
        test("prefix-43suffix1-55000000suffix2", "prefix" + s_bM + "suffix1" + f_iM + "suffix2");
        test("-431460392448", "" + s_bM + f_l);
        test("-431460392448suffix", "" + s_bM + f_l + "suffix");
        test("prefix-43suffix11460392448suffix2", "prefix" + s_bM + "suffix1" + f_l + "suffix2");
        test("-43C(70)", "" + s_bM + f_o);
        test("-43C(70)suffix", "" + s_bM + f_o + "suffix");
        test("prefix-43suffix1C(70)suffix2", "prefix" + s_bM + "suffix1" + f_o + "suffix2");
        test("-43\u04511", "" + s_bM + sf_strU);
        test("-43\u04511suffix", "" + s_bM + sf_strU + "suffix");
        test("prefix-43suffix1\u04511suffix2", "prefix" + s_bM + "suffix1" + sf_strU + "suffix2");
        test("-438000", "" + s_bM + f_s);
        test("-438000suffix", "" + s_bM + f_s + "suffix");
        test("prefix-43suffix18000suffix2", "prefix" + s_bM + "suffix1" + f_s + "suffix2");
        test("-4318", "" + s_bM + s_str);
        test("-4318suffix", "" + s_bM + s_str + "suffix");
        test("prefix-43suffix118suffix2", "prefix" + s_bM + "suffix1" + s_str + "suffix2");
        test("-43-1000000", "" + s_bM + s_iM);
        test("-43-1000000suffix", "" + s_bM + s_iM + "suffix");
        test("prefix-43suffix1-1000000suffix2", "prefix" + s_bM + "suffix1" + s_iM + "suffix2");
        test("-431000000", "" + s_bM + sf_I);
        test("-431000000suffix", "" + s_bM + sf_I + "suffix");
        test("prefix-43suffix11000000suffix2", "prefix" + s_bM + "suffix1" + sf_I + "suffix2");
        test("-43null", "" + s_bM + f_oNtS);
        test("-43nullsuffix", "" + s_bM + f_oNtS + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + f_oNtS + "suffix2");
        test("-43false", "" + s_bM + f_bl);
        test("-43falsesuffix", "" + s_bM + f_bl + "suffix");
        test("prefix-43suffix1falsesuffix2", "prefix" + s_bM + "suffix1" + f_bl + "suffix2");
        test("-43null", "" + s_bM + sf_iAN);
        test("-43nullsuffix", "" + s_bM + sf_iAN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + sf_iAN + "suffix2");
        test("-43-2000000", "" + s_bM + sf_iM);
        test("-43-2000000suffix", "" + s_bM + sf_iM + "suffix");
        test("prefix-43suffix1-2000000suffix2", "prefix" + s_bM + "suffix1" + sf_iM + "suffix2");
        test("-43-820130816", "" + s_bM + f_lM);
        test("-43-820130816suffix", "" + s_bM + f_lM + "suffix");
        test("prefix-43suffix1-820130816suffix2", "prefix" + s_bM + "suffix1" + f_lM + "suffix2");
        test("-43null", "" + s_bM + sf_oAN);
        test("-43nullsuffix", "" + s_bM + sf_oAN + "suffix");
        test("prefix-43suffix1nullsuffix2", "prefix" + s_bM + "suffix1" + sf_oAN + "suffix2");
        test("-4325000000", "" + s_bM + s_I);
        test("-4325000000suffix", "" + s_bM + s_I + "suffix");
        test("prefix-43suffix125000000suffix2", "prefix" + s_bM + "suffix1" + s_I + "suffix2");
        test("80-96.0", "" + sf_b + s_dM);
        test("80-96.0suffix", "" + sf_b + s_dM + "suffix");
        test("prefix80suffix1-96.0suffix2", "prefix" + sf_b + "suffix1" + s_dM + "suffix2");
        test("80null", "" + sf_b + s_oNtS);
        test("80nullsuffix", "" + sf_b + s_oNtS + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + s_oNtS + "suffix2");
        test("80\u045176", "" + sf_b + f_strU);
        test("80\u045176suffix", "" + sf_b + f_strU + "suffix");
        test("prefix80suffix1\u045176suffix2", "prefix" + sf_b + "suffix1" + f_strU + "suffix2");
        test("8092", "" + sf_b + sf_strU2);
        test("8092suffix", "" + sf_b + sf_strU2 + "suffix");
        test("prefix80suffix192suffix2", "prefix" + sf_b + "suffix1" + sf_strU2 + "suffix2");
        test("8051", "" + sf_b + sf_strU1);
        test("8051suffix", "" + sf_b + sf_strU1 + "suffix");
        test("prefix80suffix151suffix2", "prefix" + sf_b + "suffix1" + sf_strU1 + "suffix2");
        test("80null", "" + sf_b + s_iAN);
        test("80nullsuffix", "" + sf_b + s_iAN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + s_iAN + "suffix2");
        test("80-54", "" + sf_b + f_bM);
        test("80-54suffix", "" + sf_b + f_bM + "suffix");
        test("prefix80suffix1-54suffix2", "prefix" + sf_b + "suffix1" + f_bM + "suffix2");
        test("80-87.0", "" + sf_b + f_fM);
        test("80-87.0suffix", "" + sf_b + f_fM + "suffix");
        test("prefix80suffix1-87.0suffix2", "prefix" + sf_b + "suffix1" + f_fM + "suffix2");
        test("80null", "" + sf_b + s_oAN);
        test("80nullsuffix", "" + sf_b + s_oAN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + s_oAN + "suffix2");
        test("8019", "" + sf_b + f_str);
        test("8019suffix", "" + sf_b + f_str + "suffix");
        test("prefix80suffix119suffix2", "prefix" + sf_b + "suffix1" + f_str + "suffix2");
        test("80-41", "" + sf_b + sf_bM);
        test("80-41suffix", "" + sf_b + sf_bM + "suffix");
        test("prefix80suffix1-41suffix2", "prefix" + sf_b + "suffix1" + sf_bM + "suffix2");
        test("80null", "" + sf_b + sf_IN);
        test("80nullsuffix", "" + sf_b + sf_IN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + sf_IN + "suffix2");
        test("80T", "" + sf_b + s_c);
        test("80Tsuffix", "" + sf_b + s_c + "suffix");
        test("prefix80suffix1Tsuffix2", "prefix" + sf_b + "suffix1" + s_c + "suffix2");
        test("80-42.0", "" + sf_b + sf_fM);
        test("80-42.0suffix", "" + sf_b + sf_fM + "suffix");
        test("prefix80suffix1-42.0suffix2", "prefix" + sf_b + "suffix1" + sf_fM + "suffix2");
        test("8025", "" + sf_b + s_b);
        test("8025suffix", "" + sf_b + s_b + "suffix");
        test("prefix80suffix125suffix2", "prefix" + sf_b + "suffix1" + s_b + "suffix2");
        test("80null", "" + sf_b + f_oN);
        test("80nullsuffix", "" + sf_b + f_oN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + f_oN + "suffix2");
        test("80-1410065408", "" + sf_b + s_lM);
        test("80-1410065408suffix", "" + sf_b + s_lM + "suffix");
        test("prefix80suffix1-1410065408suffix2", "prefix" + sf_b + "suffix1" + s_lM + "suffix2");
        test("808.0", "" + sf_b + s_d);
        test("808.0suffix", "" + sf_b + s_d + "suffix");
        test("prefix80suffix18.0suffix2", "prefix" + sf_b + "suffix1" + s_d + "suffix2");
        test("8055.0", "" + sf_b + s_f);
        test("8055.0suffix", "" + sf_b + s_f + "suffix");
        test("prefix80suffix155.0suffix2", "prefix" + sf_b + "suffix1" + s_f + "suffix2");
        test("8097000000", "" + sf_b + s_i);
        test("8097000000suffix", "" + sf_b + s_i + "suffix");
        test("prefix80suffix197000000suffix2", "prefix" + sf_b + "suffix1" + s_i + "suffix2");
        test("80-9900", "" + sf_b + f_sM);
        test("80-9900suffix", "" + sf_b + f_sM + "suffix");
        test("prefix80suffix1-9900suffix2", "prefix" + sf_b + "suffix1" + f_sM + "suffix2");
        test("80935228928", "" + sf_b + s_l);
        test("80935228928suffix", "" + sf_b + s_l + "suffix");
        test("prefix80suffix1935228928suffix2", "prefix" + sf_b + "suffix1" + s_l + "suffix2");
        test("80-8400", "" + sf_b + sf_sM);
        test("80-8400suffix", "" + sf_b + sf_sM + "suffix");
        test("prefix80suffix1-8400suffix2", "prefix" + sf_b + "suffix1" + sf_sM + "suffix2");
        test("80C(82)", "" + sf_b + s_o);
        test("80C(82)suffix", "" + sf_b + s_o + "suffix");
        test("prefix80suffix1C(82)suffix2", "prefix" + sf_b + "suffix1" + s_o + "suffix2");
        test("80null", "" + sf_b + sf_oNtS);
        test("80nullsuffix", "" + sf_b + sf_oNtS + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + sf_oNtS + "suffix2");
        test("80true", "" + sf_b + s_bl);
        test("80truesuffix", "" + sf_b + s_bl + "suffix");
        test("prefix80suffix1truesuffix2", "prefix" + sf_b + "suffix1" + s_bl + "suffix2");
        test("803900", "" + sf_b + s_s);
        test("803900suffix", "" + sf_b + s_s + "suffix");
        test("prefix80suffix13900suffix2", "prefix" + sf_b + "suffix1" + s_s + "suffix2");
        test("80null", "" + sf_b + sf_oN);
        test("80nullsuffix", "" + sf_b + sf_oN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + sf_oN + "suffix2");
        test("8094000000", "" + sf_b + f_I);
        test("8094000000suffix", "" + sf_b + f_I + "suffix");
        test("prefix80suffix194000000suffix2", "prefix" + sf_b + "suffix1" + f_I + "suffix2");
        test("80null", "" + sf_b + f_IN);
        test("80nullsuffix", "" + sf_b + f_IN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + f_IN + "suffix2");
        test("80true", "" + sf_b + sf_bl);
        test("80truesuffix", "" + sf_b + sf_bl + "suffix");
        test("prefix80suffix1truesuffix2", "prefix" + sf_b + "suffix1" + sf_bl + "suffix2");
        test("805500", "" + sf_b + sf_s);
        test("805500suffix", "" + sf_b + sf_s + "suffix");
        test("prefix80suffix15500suffix2", "prefix" + sf_b + "suffix1" + sf_s + "suffix2");
        test("80-2900", "" + sf_b + s_sM);
        test("80-2900suffix", "" + sf_b + s_sM + "suffix");
        test("prefix80suffix1-2900suffix2", "prefix" + sf_b + "suffix1" + s_sM + "suffix2");
        test("80-194313216", "" + sf_b + sf_l);
        test("80-194313216suffix", "" + sf_b + sf_l + "suffix");
        test("prefix80suffix1-194313216suffix2", "prefix" + sf_b + "suffix1" + sf_l + "suffix2");
        test("8012", "" + sf_b + s_strU1);
        test("8012suffix", "" + sf_b + s_strU1 + "suffix");
        test("prefix80suffix112suffix2", "prefix" + sf_b + "suffix1" + s_strU1 + "suffix2");
        test("80C(87)", "" + sf_b + sf_o);
        test("80C(87)suffix", "" + sf_b + sf_o + "suffix");
        test("prefix80suffix1C(87)suffix2", "prefix" + sf_b + "suffix1" + sf_o + "suffix2");
        test("8091", "" + sf_b + s_strU2);
        test("8091suffix", "" + sf_b + s_strU2 + "suffix");
        test("prefix80suffix191suffix2", "prefix" + sf_b + "suffix1" + s_strU2 + "suffix2");
        test("8021", "" + sf_b + f_strU1);
        test("8021suffix", "" + sf_b + f_strU1 + "suffix");
        test("prefix80suffix121suffix2", "prefix" + sf_b + "suffix1" + f_strU1 + "suffix2");
        test("8018", "" + sf_b + f_strU2);
        test("8018suffix", "" + sf_b + f_strU2 + "suffix");
        test("prefix80suffix118suffix2", "prefix" + sf_b + "suffix1" + f_strU2 + "suffix2");
        test("80null", "" + sf_b + f_iAN);
        test("80nullsuffix", "" + sf_b + f_iAN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + f_iAN + "suffix2");
        test("80null", "" + sf_b + s_oN);
        test("80nullsuffix", "" + sf_b + s_oN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + s_oN + "suffix2");
        test("80\u045180", "" + sf_b + s_strU);
        test("80\u045180suffix", "" + sf_b + s_strU + "suffix");
        test("prefix80suffix1\u045180suffix2", "prefix" + sf_b + "suffix1" + s_strU + "suffix2");
        test("80C", "" + sf_b + sf_c);
        test("80Csuffix", "" + sf_b + sf_c + "suffix");
        test("prefix80suffix1Csuffix2", "prefix" + sf_b + "suffix1" + sf_c + "suffix2");
        test("8075", "" + sf_b + sf_str);
        test("8075suffix", "" + sf_b + sf_str + "suffix");
        test("prefix80suffix175suffix2", "prefix" + sf_b + "suffix1" + sf_str + "suffix2");
        test("80-43", "" + sf_b + s_bM);
        test("80-43suffix", "" + sf_b + s_bM + "suffix");
        test("prefix80suffix1-43suffix2", "prefix" + sf_b + "suffix1" + s_bM + "suffix2");
        test("8080", "" + sf_b + sf_b);
        test("8080suffix", "" + sf_b + sf_b + "suffix");
        test("prefix80suffix180suffix2", "prefix" + sf_b + "suffix1" + sf_b + "suffix2");
        test("80null", "" + sf_b + s_IN);
        test("80nullsuffix", "" + sf_b + s_IN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + s_IN + "suffix2");
        test("80-52.0", "" + sf_b + s_fM);
        test("80-52.0suffix", "" + sf_b + s_fM + "suffix");
        test("prefix80suffix1-52.0suffix2", "prefix" + sf_b + "suffix1" + s_fM + "suffix2");
        test("8075000000", "" + sf_b + sf_i);
        test("8075000000suffix", "" + sf_b + sf_i + "suffix");
        test("prefix80suffix175000000suffix2", "prefix" + sf_b + "suffix1" + sf_i + "suffix2");
        test("8044", "" + sf_b + f_b);
        test("8044suffix", "" + sf_b + f_b + "suffix");
        test("prefix80suffix144suffix2", "prefix" + sf_b + "suffix1" + f_b + "suffix2");
        test("80-1705032704", "" + sf_b + sf_lM);
        test("80-1705032704suffix", "" + sf_b + sf_lM + "suffix");
        test("prefix80suffix1-1705032704suffix2", "prefix" + sf_b + "suffix1" + sf_lM + "suffix2");
        test("80null", "" + sf_b + f_oAN);
        test("80nullsuffix", "" + sf_b + f_oAN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + f_oAN + "suffix2");
        test("8083.0", "" + sf_b + f_d);
        test("8083.0suffix", "" + sf_b + f_d + "suffix");
        test("prefix80suffix183.0suffix2", "prefix" + sf_b + "suffix1" + f_d + "suffix2");
        test("80I", "" + sf_b + f_c);
        test("80Isuffix", "" + sf_b + f_c + "suffix");
        test("prefix80suffix1Isuffix2", "prefix" + sf_b + "suffix1" + f_c + "suffix2");
        test("8094.0", "" + sf_b + f_f);
        test("8094.0suffix", "" + sf_b + f_f + "suffix");
        test("prefix80suffix194.0suffix2", "prefix" + sf_b + "suffix1" + f_f + "suffix2");
        test("8012.0", "" + sf_b + sf_d);
        test("8012.0suffix", "" + sf_b + sf_d + "suffix");
        test("prefix80suffix112.0suffix2", "prefix" + sf_b + "suffix1" + sf_d + "suffix2");
        test("80-99.0", "" + sf_b + f_dM);
        test("80-99.0suffix", "" + sf_b + f_dM + "suffix");
        test("prefix80suffix1-99.0suffix2", "prefix" + sf_b + "suffix1" + f_dM + "suffix2");
        test("8017.0", "" + sf_b + sf_f);
        test("8017.0suffix", "" + sf_b + sf_f + "suffix");
        test("prefix80suffix117.0suffix2", "prefix" + sf_b + "suffix1" + sf_f + "suffix2");
        test("80-84.0", "" + sf_b + sf_dM);
        test("80-84.0suffix", "" + sf_b + sf_dM + "suffix");
        test("prefix80suffix1-84.0suffix2", "prefix" + sf_b + "suffix1" + sf_dM + "suffix2");
        test("8058000000", "" + sf_b + f_i);
        test("8058000000suffix", "" + sf_b + f_i + "suffix");
        test("prefix80suffix158000000suffix2", "prefix" + sf_b + "suffix1" + f_i + "suffix2");
        test("80-55000000", "" + sf_b + f_iM);
        test("80-55000000suffix", "" + sf_b + f_iM + "suffix");
        test("prefix80suffix1-55000000suffix2", "prefix" + sf_b + "suffix1" + f_iM + "suffix2");
        test("801460392448", "" + sf_b + f_l);
        test("801460392448suffix", "" + sf_b + f_l + "suffix");
        test("prefix80suffix11460392448suffix2", "prefix" + sf_b + "suffix1" + f_l + "suffix2");
        test("80C(70)", "" + sf_b + f_o);
        test("80C(70)suffix", "" + sf_b + f_o + "suffix");
        test("prefix80suffix1C(70)suffix2", "prefix" + sf_b + "suffix1" + f_o + "suffix2");
        test("80\u04511", "" + sf_b + sf_strU);
        test("80\u04511suffix", "" + sf_b + sf_strU + "suffix");
        test("prefix80suffix1\u04511suffix2", "prefix" + sf_b + "suffix1" + sf_strU + "suffix2");
        test("808000", "" + sf_b + f_s);
        test("808000suffix", "" + sf_b + f_s + "suffix");
        test("prefix80suffix18000suffix2", "prefix" + sf_b + "suffix1" + f_s + "suffix2");
        test("8018", "" + sf_b + s_str);
        test("8018suffix", "" + sf_b + s_str + "suffix");
        test("prefix80suffix118suffix2", "prefix" + sf_b + "suffix1" + s_str + "suffix2");
        test("80-1000000", "" + sf_b + s_iM);
        test("80-1000000suffix", "" + sf_b + s_iM + "suffix");
        test("prefix80suffix1-1000000suffix2", "prefix" + sf_b + "suffix1" + s_iM + "suffix2");
        test("801000000", "" + sf_b + sf_I);
        test("801000000suffix", "" + sf_b + sf_I + "suffix");
        test("prefix80suffix11000000suffix2", "prefix" + sf_b + "suffix1" + sf_I + "suffix2");
        test("80null", "" + sf_b + f_oNtS);
        test("80nullsuffix", "" + sf_b + f_oNtS + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + f_oNtS + "suffix2");
        test("80false", "" + sf_b + f_bl);
        test("80falsesuffix", "" + sf_b + f_bl + "suffix");
        test("prefix80suffix1falsesuffix2", "prefix" + sf_b + "suffix1" + f_bl + "suffix2");
        test("80null", "" + sf_b + sf_iAN);
        test("80nullsuffix", "" + sf_b + sf_iAN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + sf_iAN + "suffix2");
        test("80-2000000", "" + sf_b + sf_iM);
        test("80-2000000suffix", "" + sf_b + sf_iM + "suffix");
        test("prefix80suffix1-2000000suffix2", "prefix" + sf_b + "suffix1" + sf_iM + "suffix2");
        test("80-820130816", "" + sf_b + f_lM);
        test("80-820130816suffix", "" + sf_b + f_lM + "suffix");
        test("prefix80suffix1-820130816suffix2", "prefix" + sf_b + "suffix1" + f_lM + "suffix2");
        test("80null", "" + sf_b + sf_oAN);
        test("80nullsuffix", "" + sf_b + sf_oAN + "suffix");
        test("prefix80suffix1nullsuffix2", "prefix" + sf_b + "suffix1" + sf_oAN + "suffix2");
        test("8025000000", "" + sf_b + s_I);
        test("8025000000suffix", "" + sf_b + s_I + "suffix");
        test("prefix80suffix125000000suffix2", "prefix" + sf_b + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + s_IN + s_dM);
        test("null-96.0suffix", "" + s_IN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + s_IN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + s_IN + s_oNtS);
        test("nullnullsuffix", "" + s_IN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + s_IN + f_strU);
        test("null\u045176suffix", "" + s_IN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + s_IN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + s_IN + sf_strU2);
        test("null92suffix", "" + s_IN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + s_IN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + s_IN + sf_strU1);
        test("null51suffix", "" + s_IN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + s_IN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + s_IN + s_iAN);
        test("nullnullsuffix", "" + s_IN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + s_IN + f_bM);
        test("null-54suffix", "" + s_IN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + s_IN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + s_IN + f_fM);
        test("null-87.0suffix", "" + s_IN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + s_IN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + s_IN + s_oAN);
        test("nullnullsuffix", "" + s_IN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + s_IN + f_str);
        test("null19suffix", "" + s_IN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + s_IN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + s_IN + sf_bM);
        test("null-41suffix", "" + s_IN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + s_IN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + s_IN + sf_IN);
        test("nullnullsuffix", "" + s_IN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + s_IN + s_c);
        test("nullTsuffix", "" + s_IN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + s_IN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + s_IN + sf_fM);
        test("null-42.0suffix", "" + s_IN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + s_IN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + s_IN + s_b);
        test("null25suffix", "" + s_IN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + s_IN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + s_IN + f_oN);
        test("nullnullsuffix", "" + s_IN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + s_IN + s_lM);
        test("null-1410065408suffix", "" + s_IN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + s_IN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + s_IN + s_d);
        test("null8.0suffix", "" + s_IN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + s_IN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + s_IN + s_f);
        test("null55.0suffix", "" + s_IN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + s_IN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + s_IN + s_i);
        test("null97000000suffix", "" + s_IN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + s_IN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + s_IN + f_sM);
        test("null-9900suffix", "" + s_IN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + s_IN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + s_IN + s_l);
        test("null935228928suffix", "" + s_IN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + s_IN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + s_IN + sf_sM);
        test("null-8400suffix", "" + s_IN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + s_IN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + s_IN + s_o);
        test("nullC(82)suffix", "" + s_IN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + s_IN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + s_IN + sf_oNtS);
        test("nullnullsuffix", "" + s_IN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + s_IN + s_bl);
        test("nulltruesuffix", "" + s_IN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_IN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + s_IN + s_s);
        test("null3900suffix", "" + s_IN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + s_IN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + s_IN + sf_oN);
        test("nullnullsuffix", "" + s_IN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + s_IN + f_I);
        test("null94000000suffix", "" + s_IN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + s_IN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + s_IN + f_IN);
        test("nullnullsuffix", "" + s_IN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + s_IN + sf_bl);
        test("nulltruesuffix", "" + s_IN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + s_IN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + s_IN + sf_s);
        test("null5500suffix", "" + s_IN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + s_IN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + s_IN + s_sM);
        test("null-2900suffix", "" + s_IN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + s_IN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + s_IN + sf_l);
        test("null-194313216suffix", "" + s_IN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + s_IN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + s_IN + s_strU1);
        test("null12suffix", "" + s_IN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + s_IN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + s_IN + sf_o);
        test("nullC(87)suffix", "" + s_IN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + s_IN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + s_IN + s_strU2);
        test("null91suffix", "" + s_IN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + s_IN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + s_IN + f_strU1);
        test("null21suffix", "" + s_IN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + s_IN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + s_IN + f_strU2);
        test("null18suffix", "" + s_IN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_IN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + s_IN + f_iAN);
        test("nullnullsuffix", "" + s_IN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + s_IN + s_oN);
        test("nullnullsuffix", "" + s_IN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + s_IN + s_strU);
        test("null\u045180suffix", "" + s_IN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + s_IN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + s_IN + sf_c);
        test("nullCsuffix", "" + s_IN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + s_IN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + s_IN + sf_str);
        test("null75suffix", "" + s_IN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + s_IN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + s_IN + s_bM);
        test("null-43suffix", "" + s_IN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + s_IN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + s_IN + sf_b);
        test("null80suffix", "" + s_IN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + s_IN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + s_IN + s_IN);
        test("nullnullsuffix", "" + s_IN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + s_IN + s_fM);
        test("null-52.0suffix", "" + s_IN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + s_IN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + s_IN + sf_i);
        test("null75000000suffix", "" + s_IN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + s_IN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + s_IN + f_b);
        test("null44suffix", "" + s_IN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + s_IN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + s_IN + sf_lM);
        test("null-1705032704suffix", "" + s_IN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + s_IN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + s_IN + f_oAN);
        test("nullnullsuffix", "" + s_IN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + s_IN + f_d);
        test("null83.0suffix", "" + s_IN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + s_IN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + s_IN + f_c);
        test("nullIsuffix", "" + s_IN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + s_IN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + s_IN + f_f);
        test("null94.0suffix", "" + s_IN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + s_IN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + s_IN + sf_d);
        test("null12.0suffix", "" + s_IN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + s_IN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + s_IN + f_dM);
        test("null-99.0suffix", "" + s_IN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + s_IN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + s_IN + sf_f);
        test("null17.0suffix", "" + s_IN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + s_IN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + s_IN + sf_dM);
        test("null-84.0suffix", "" + s_IN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + s_IN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + s_IN + f_i);
        test("null58000000suffix", "" + s_IN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + s_IN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + s_IN + f_iM);
        test("null-55000000suffix", "" + s_IN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + s_IN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + s_IN + f_l);
        test("null1460392448suffix", "" + s_IN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + s_IN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + s_IN + f_o);
        test("nullC(70)suffix", "" + s_IN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + s_IN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + s_IN + sf_strU);
        test("null\u04511suffix", "" + s_IN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + s_IN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + s_IN + f_s);
        test("null8000suffix", "" + s_IN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + s_IN + "suffix1" + f_s + "suffix2");
        test("null18", "" + s_IN + s_str);
        test("null18suffix", "" + s_IN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + s_IN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + s_IN + s_iM);
        test("null-1000000suffix", "" + s_IN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + s_IN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + s_IN + sf_I);
        test("null1000000suffix", "" + s_IN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + s_IN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + s_IN + f_oNtS);
        test("nullnullsuffix", "" + s_IN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + s_IN + f_bl);
        test("nullfalsesuffix", "" + s_IN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + s_IN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + s_IN + sf_iAN);
        test("nullnullsuffix", "" + s_IN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + s_IN + sf_iM);
        test("null-2000000suffix", "" + s_IN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + s_IN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + s_IN + f_lM);
        test("null-820130816suffix", "" + s_IN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + s_IN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + s_IN + sf_oAN);
        test("nullnullsuffix", "" + s_IN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + s_IN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + s_IN + s_I);
        test("null25000000suffix", "" + s_IN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + s_IN + "suffix1" + s_I + "suffix2");
        test("-52.0-96.0", "" + s_fM + s_dM);
        test("-52.0-96.0suffix", "" + s_fM + s_dM + "suffix");
        test("prefix-52.0suffix1-96.0suffix2", "prefix" + s_fM + "suffix1" + s_dM + "suffix2");
        test("-52.0null", "" + s_fM + s_oNtS);
        test("-52.0nullsuffix", "" + s_fM + s_oNtS + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + s_oNtS + "suffix2");
        test("-52.0\u045176", "" + s_fM + f_strU);
        test("-52.0\u045176suffix", "" + s_fM + f_strU + "suffix");
        test("prefix-52.0suffix1\u045176suffix2", "prefix" + s_fM + "suffix1" + f_strU + "suffix2");
        test("-52.092", "" + s_fM + sf_strU2);
        test("-52.092suffix", "" + s_fM + sf_strU2 + "suffix");
        test("prefix-52.0suffix192suffix2", "prefix" + s_fM + "suffix1" + sf_strU2 + "suffix2");
        test("-52.051", "" + s_fM + sf_strU1);
        test("-52.051suffix", "" + s_fM + sf_strU1 + "suffix");
        test("prefix-52.0suffix151suffix2", "prefix" + s_fM + "suffix1" + sf_strU1 + "suffix2");
        test("-52.0null", "" + s_fM + s_iAN);
        test("-52.0nullsuffix", "" + s_fM + s_iAN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + s_iAN + "suffix2");
        test("-52.0-54", "" + s_fM + f_bM);
        test("-52.0-54suffix", "" + s_fM + f_bM + "suffix");
        test("prefix-52.0suffix1-54suffix2", "prefix" + s_fM + "suffix1" + f_bM + "suffix2");
        test("-52.0-87.0", "" + s_fM + f_fM);
        test("-52.0-87.0suffix", "" + s_fM + f_fM + "suffix");
        test("prefix-52.0suffix1-87.0suffix2", "prefix" + s_fM + "suffix1" + f_fM + "suffix2");
        test("-52.0null", "" + s_fM + s_oAN);
        test("-52.0nullsuffix", "" + s_fM + s_oAN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + s_oAN + "suffix2");
        test("-52.019", "" + s_fM + f_str);
        test("-52.019suffix", "" + s_fM + f_str + "suffix");
        test("prefix-52.0suffix119suffix2", "prefix" + s_fM + "suffix1" + f_str + "suffix2");
        test("-52.0-41", "" + s_fM + sf_bM);
        test("-52.0-41suffix", "" + s_fM + sf_bM + "suffix");
        test("prefix-52.0suffix1-41suffix2", "prefix" + s_fM + "suffix1" + sf_bM + "suffix2");
        test("-52.0null", "" + s_fM + sf_IN);
        test("-52.0nullsuffix", "" + s_fM + sf_IN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + sf_IN + "suffix2");
        test("-52.0T", "" + s_fM + s_c);
        test("-52.0Tsuffix", "" + s_fM + s_c + "suffix");
        test("prefix-52.0suffix1Tsuffix2", "prefix" + s_fM + "suffix1" + s_c + "suffix2");
        test("-52.0-42.0", "" + s_fM + sf_fM);
        test("-52.0-42.0suffix", "" + s_fM + sf_fM + "suffix");
        test("prefix-52.0suffix1-42.0suffix2", "prefix" + s_fM + "suffix1" + sf_fM + "suffix2");
        test("-52.025", "" + s_fM + s_b);
        test("-52.025suffix", "" + s_fM + s_b + "suffix");
        test("prefix-52.0suffix125suffix2", "prefix" + s_fM + "suffix1" + s_b + "suffix2");
        test("-52.0null", "" + s_fM + f_oN);
        test("-52.0nullsuffix", "" + s_fM + f_oN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + f_oN + "suffix2");
        test("-52.0-1410065408", "" + s_fM + s_lM);
        test("-52.0-1410065408suffix", "" + s_fM + s_lM + "suffix");
        test("prefix-52.0suffix1-1410065408suffix2", "prefix" + s_fM + "suffix1" + s_lM + "suffix2");
        test("-52.08.0", "" + s_fM + s_d);
        test("-52.08.0suffix", "" + s_fM + s_d + "suffix");
        test("prefix-52.0suffix18.0suffix2", "prefix" + s_fM + "suffix1" + s_d + "suffix2");
        test("-52.055.0", "" + s_fM + s_f);
        test("-52.055.0suffix", "" + s_fM + s_f + "suffix");
        test("prefix-52.0suffix155.0suffix2", "prefix" + s_fM + "suffix1" + s_f + "suffix2");
        test("-52.097000000", "" + s_fM + s_i);
        test("-52.097000000suffix", "" + s_fM + s_i + "suffix");
        test("prefix-52.0suffix197000000suffix2", "prefix" + s_fM + "suffix1" + s_i + "suffix2");
        test("-52.0-9900", "" + s_fM + f_sM);
        test("-52.0-9900suffix", "" + s_fM + f_sM + "suffix");
        test("prefix-52.0suffix1-9900suffix2", "prefix" + s_fM + "suffix1" + f_sM + "suffix2");
        test("-52.0935228928", "" + s_fM + s_l);
        test("-52.0935228928suffix", "" + s_fM + s_l + "suffix");
        test("prefix-52.0suffix1935228928suffix2", "prefix" + s_fM + "suffix1" + s_l + "suffix2");
        test("-52.0-8400", "" + s_fM + sf_sM);
        test("-52.0-8400suffix", "" + s_fM + sf_sM + "suffix");
        test("prefix-52.0suffix1-8400suffix2", "prefix" + s_fM + "suffix1" + sf_sM + "suffix2");
        test("-52.0C(82)", "" + s_fM + s_o);
        test("-52.0C(82)suffix", "" + s_fM + s_o + "suffix");
        test("prefix-52.0suffix1C(82)suffix2", "prefix" + s_fM + "suffix1" + s_o + "suffix2");
        test("-52.0null", "" + s_fM + sf_oNtS);
        test("-52.0nullsuffix", "" + s_fM + sf_oNtS + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + sf_oNtS + "suffix2");
        test("-52.0true", "" + s_fM + s_bl);
        test("-52.0truesuffix", "" + s_fM + s_bl + "suffix");
        test("prefix-52.0suffix1truesuffix2", "prefix" + s_fM + "suffix1" + s_bl + "suffix2");
        test("-52.03900", "" + s_fM + s_s);
        test("-52.03900suffix", "" + s_fM + s_s + "suffix");
        test("prefix-52.0suffix13900suffix2", "prefix" + s_fM + "suffix1" + s_s + "suffix2");
        test("-52.0null", "" + s_fM + sf_oN);
        test("-52.0nullsuffix", "" + s_fM + sf_oN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + sf_oN + "suffix2");
        test("-52.094000000", "" + s_fM + f_I);
        test("-52.094000000suffix", "" + s_fM + f_I + "suffix");
        test("prefix-52.0suffix194000000suffix2", "prefix" + s_fM + "suffix1" + f_I + "suffix2");
        test("-52.0null", "" + s_fM + f_IN);
        test("-52.0nullsuffix", "" + s_fM + f_IN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + f_IN + "suffix2");
        test("-52.0true", "" + s_fM + sf_bl);
        test("-52.0truesuffix", "" + s_fM + sf_bl + "suffix");
        test("prefix-52.0suffix1truesuffix2", "prefix" + s_fM + "suffix1" + sf_bl + "suffix2");
        test("-52.05500", "" + s_fM + sf_s);
        test("-52.05500suffix", "" + s_fM + sf_s + "suffix");
        test("prefix-52.0suffix15500suffix2", "prefix" + s_fM + "suffix1" + sf_s + "suffix2");
        test("-52.0-2900", "" + s_fM + s_sM);
        test("-52.0-2900suffix", "" + s_fM + s_sM + "suffix");
        test("prefix-52.0suffix1-2900suffix2", "prefix" + s_fM + "suffix1" + s_sM + "suffix2");
        test("-52.0-194313216", "" + s_fM + sf_l);
        test("-52.0-194313216suffix", "" + s_fM + sf_l + "suffix");
        test("prefix-52.0suffix1-194313216suffix2", "prefix" + s_fM + "suffix1" + sf_l + "suffix2");
        test("-52.012", "" + s_fM + s_strU1);
        test("-52.012suffix", "" + s_fM + s_strU1 + "suffix");
        test("prefix-52.0suffix112suffix2", "prefix" + s_fM + "suffix1" + s_strU1 + "suffix2");
        test("-52.0C(87)", "" + s_fM + sf_o);
        test("-52.0C(87)suffix", "" + s_fM + sf_o + "suffix");
        test("prefix-52.0suffix1C(87)suffix2", "prefix" + s_fM + "suffix1" + sf_o + "suffix2");
        test("-52.091", "" + s_fM + s_strU2);
        test("-52.091suffix", "" + s_fM + s_strU2 + "suffix");
        test("prefix-52.0suffix191suffix2", "prefix" + s_fM + "suffix1" + s_strU2 + "suffix2");
        test("-52.021", "" + s_fM + f_strU1);
        test("-52.021suffix", "" + s_fM + f_strU1 + "suffix");
        test("prefix-52.0suffix121suffix2", "prefix" + s_fM + "suffix1" + f_strU1 + "suffix2");
        test("-52.018", "" + s_fM + f_strU2);
        test("-52.018suffix", "" + s_fM + f_strU2 + "suffix");
        test("prefix-52.0suffix118suffix2", "prefix" + s_fM + "suffix1" + f_strU2 + "suffix2");
        test("-52.0null", "" + s_fM + f_iAN);
        test("-52.0nullsuffix", "" + s_fM + f_iAN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + f_iAN + "suffix2");
        test("-52.0null", "" + s_fM + s_oN);
        test("-52.0nullsuffix", "" + s_fM + s_oN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + s_oN + "suffix2");
        test("-52.0\u045180", "" + s_fM + s_strU);
        test("-52.0\u045180suffix", "" + s_fM + s_strU + "suffix");
    }

    public void run11() {
        test("prefix-52.0suffix1\u045180suffix2", "prefix" + s_fM + "suffix1" + s_strU + "suffix2");
        test("-52.0C", "" + s_fM + sf_c);
        test("-52.0Csuffix", "" + s_fM + sf_c + "suffix");
        test("prefix-52.0suffix1Csuffix2", "prefix" + s_fM + "suffix1" + sf_c + "suffix2");
        test("-52.075", "" + s_fM + sf_str);
        test("-52.075suffix", "" + s_fM + sf_str + "suffix");
        test("prefix-52.0suffix175suffix2", "prefix" + s_fM + "suffix1" + sf_str + "suffix2");
        test("-52.0-43", "" + s_fM + s_bM);
        test("-52.0-43suffix", "" + s_fM + s_bM + "suffix");
        test("prefix-52.0suffix1-43suffix2", "prefix" + s_fM + "suffix1" + s_bM + "suffix2");
        test("-52.080", "" + s_fM + sf_b);
        test("-52.080suffix", "" + s_fM + sf_b + "suffix");
        test("prefix-52.0suffix180suffix2", "prefix" + s_fM + "suffix1" + sf_b + "suffix2");
        test("-52.0null", "" + s_fM + s_IN);
        test("-52.0nullsuffix", "" + s_fM + s_IN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + s_IN + "suffix2");
        test("-52.0-52.0", "" + s_fM + s_fM);
        test("-52.0-52.0suffix", "" + s_fM + s_fM + "suffix");
        test("prefix-52.0suffix1-52.0suffix2", "prefix" + s_fM + "suffix1" + s_fM + "suffix2");
        test("-52.075000000", "" + s_fM + sf_i);
        test("-52.075000000suffix", "" + s_fM + sf_i + "suffix");
        test("prefix-52.0suffix175000000suffix2", "prefix" + s_fM + "suffix1" + sf_i + "suffix2");
        test("-52.044", "" + s_fM + f_b);
        test("-52.044suffix", "" + s_fM + f_b + "suffix");
        test("prefix-52.0suffix144suffix2", "prefix" + s_fM + "suffix1" + f_b + "suffix2");
        test("-52.0-1705032704", "" + s_fM + sf_lM);
        test("-52.0-1705032704suffix", "" + s_fM + sf_lM + "suffix");
        test("prefix-52.0suffix1-1705032704suffix2", "prefix" + s_fM + "suffix1" + sf_lM + "suffix2");
        test("-52.0null", "" + s_fM + f_oAN);
        test("-52.0nullsuffix", "" + s_fM + f_oAN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + f_oAN + "suffix2");
        test("-52.083.0", "" + s_fM + f_d);
        test("-52.083.0suffix", "" + s_fM + f_d + "suffix");
        test("prefix-52.0suffix183.0suffix2", "prefix" + s_fM + "suffix1" + f_d + "suffix2");
        test("-52.0I", "" + s_fM + f_c);
        test("-52.0Isuffix", "" + s_fM + f_c + "suffix");
        test("prefix-52.0suffix1Isuffix2", "prefix" + s_fM + "suffix1" + f_c + "suffix2");
        test("-52.094.0", "" + s_fM + f_f);
        test("-52.094.0suffix", "" + s_fM + f_f + "suffix");
        test("prefix-52.0suffix194.0suffix2", "prefix" + s_fM + "suffix1" + f_f + "suffix2");
        test("-52.012.0", "" + s_fM + sf_d);
        test("-52.012.0suffix", "" + s_fM + sf_d + "suffix");
        test("prefix-52.0suffix112.0suffix2", "prefix" + s_fM + "suffix1" + sf_d + "suffix2");
        test("-52.0-99.0", "" + s_fM + f_dM);
        test("-52.0-99.0suffix", "" + s_fM + f_dM + "suffix");
        test("prefix-52.0suffix1-99.0suffix2", "prefix" + s_fM + "suffix1" + f_dM + "suffix2");
        test("-52.017.0", "" + s_fM + sf_f);
        test("-52.017.0suffix", "" + s_fM + sf_f + "suffix");
        test("prefix-52.0suffix117.0suffix2", "prefix" + s_fM + "suffix1" + sf_f + "suffix2");
        test("-52.0-84.0", "" + s_fM + sf_dM);
        test("-52.0-84.0suffix", "" + s_fM + sf_dM + "suffix");
        test("prefix-52.0suffix1-84.0suffix2", "prefix" + s_fM + "suffix1" + sf_dM + "suffix2");
        test("-52.058000000", "" + s_fM + f_i);
        test("-52.058000000suffix", "" + s_fM + f_i + "suffix");
        test("prefix-52.0suffix158000000suffix2", "prefix" + s_fM + "suffix1" + f_i + "suffix2");
        test("-52.0-55000000", "" + s_fM + f_iM);
        test("-52.0-55000000suffix", "" + s_fM + f_iM + "suffix");
        test("prefix-52.0suffix1-55000000suffix2", "prefix" + s_fM + "suffix1" + f_iM + "suffix2");
        test("-52.01460392448", "" + s_fM + f_l);
        test("-52.01460392448suffix", "" + s_fM + f_l + "suffix");
        test("prefix-52.0suffix11460392448suffix2", "prefix" + s_fM + "suffix1" + f_l + "suffix2");
        test("-52.0C(70)", "" + s_fM + f_o);
        test("-52.0C(70)suffix", "" + s_fM + f_o + "suffix");
        test("prefix-52.0suffix1C(70)suffix2", "prefix" + s_fM + "suffix1" + f_o + "suffix2");
        test("-52.0\u04511", "" + s_fM + sf_strU);
        test("-52.0\u04511suffix", "" + s_fM + sf_strU + "suffix");
        test("prefix-52.0suffix1\u04511suffix2", "prefix" + s_fM + "suffix1" + sf_strU + "suffix2");
        test("-52.08000", "" + s_fM + f_s);
        test("-52.08000suffix", "" + s_fM + f_s + "suffix");
        test("prefix-52.0suffix18000suffix2", "prefix" + s_fM + "suffix1" + f_s + "suffix2");
        test("-52.018", "" + s_fM + s_str);
        test("-52.018suffix", "" + s_fM + s_str + "suffix");
        test("prefix-52.0suffix118suffix2", "prefix" + s_fM + "suffix1" + s_str + "suffix2");
        test("-52.0-1000000", "" + s_fM + s_iM);
        test("-52.0-1000000suffix", "" + s_fM + s_iM + "suffix");
        test("prefix-52.0suffix1-1000000suffix2", "prefix" + s_fM + "suffix1" + s_iM + "suffix2");
        test("-52.01000000", "" + s_fM + sf_I);
        test("-52.01000000suffix", "" + s_fM + sf_I + "suffix");
        test("prefix-52.0suffix11000000suffix2", "prefix" + s_fM + "suffix1" + sf_I + "suffix2");
        test("-52.0null", "" + s_fM + f_oNtS);
        test("-52.0nullsuffix", "" + s_fM + f_oNtS + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + f_oNtS + "suffix2");
        test("-52.0false", "" + s_fM + f_bl);
        test("-52.0falsesuffix", "" + s_fM + f_bl + "suffix");
        test("prefix-52.0suffix1falsesuffix2", "prefix" + s_fM + "suffix1" + f_bl + "suffix2");
        test("-52.0null", "" + s_fM + sf_iAN);
        test("-52.0nullsuffix", "" + s_fM + sf_iAN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + sf_iAN + "suffix2");
        test("-52.0-2000000", "" + s_fM + sf_iM);
        test("-52.0-2000000suffix", "" + s_fM + sf_iM + "suffix");
        test("prefix-52.0suffix1-2000000suffix2", "prefix" + s_fM + "suffix1" + sf_iM + "suffix2");
        test("-52.0-820130816", "" + s_fM + f_lM);
        test("-52.0-820130816suffix", "" + s_fM + f_lM + "suffix");
        test("prefix-52.0suffix1-820130816suffix2", "prefix" + s_fM + "suffix1" + f_lM + "suffix2");
        test("-52.0null", "" + s_fM + sf_oAN);
        test("-52.0nullsuffix", "" + s_fM + sf_oAN + "suffix");
        test("prefix-52.0suffix1nullsuffix2", "prefix" + s_fM + "suffix1" + sf_oAN + "suffix2");
        test("-52.025000000", "" + s_fM + s_I);
        test("-52.025000000suffix", "" + s_fM + s_I + "suffix");
        test("prefix-52.0suffix125000000suffix2", "prefix" + s_fM + "suffix1" + s_I + "suffix2");
        test("75000000-96.0", "" + sf_i + s_dM);
        test("75000000-96.0suffix", "" + sf_i + s_dM + "suffix");
        test("prefix75000000suffix1-96.0suffix2", "prefix" + sf_i + "suffix1" + s_dM + "suffix2");
        test("75000000null", "" + sf_i + s_oNtS);
        test("75000000nullsuffix", "" + sf_i + s_oNtS + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + s_oNtS + "suffix2");
        test("75000000\u045176", "" + sf_i + f_strU);
        test("75000000\u045176suffix", "" + sf_i + f_strU + "suffix");
        test("prefix75000000suffix1\u045176suffix2", "prefix" + sf_i + "suffix1" + f_strU + "suffix2");
        test("7500000092", "" + sf_i + sf_strU2);
        test("7500000092suffix", "" + sf_i + sf_strU2 + "suffix");
        test("prefix75000000suffix192suffix2", "prefix" + sf_i + "suffix1" + sf_strU2 + "suffix2");
        test("7500000051", "" + sf_i + sf_strU1);
        test("7500000051suffix", "" + sf_i + sf_strU1 + "suffix");
        test("prefix75000000suffix151suffix2", "prefix" + sf_i + "suffix1" + sf_strU1 + "suffix2");
        test("75000000null", "" + sf_i + s_iAN);
        test("75000000nullsuffix", "" + sf_i + s_iAN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + s_iAN + "suffix2");
        test("75000000-54", "" + sf_i + f_bM);
        test("75000000-54suffix", "" + sf_i + f_bM + "suffix");
        test("prefix75000000suffix1-54suffix2", "prefix" + sf_i + "suffix1" + f_bM + "suffix2");
        test("75000000-87.0", "" + sf_i + f_fM);
        test("75000000-87.0suffix", "" + sf_i + f_fM + "suffix");
        test("prefix75000000suffix1-87.0suffix2", "prefix" + sf_i + "suffix1" + f_fM + "suffix2");
        test("75000000null", "" + sf_i + s_oAN);
        test("75000000nullsuffix", "" + sf_i + s_oAN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + s_oAN + "suffix2");
        test("7500000019", "" + sf_i + f_str);
        test("7500000019suffix", "" + sf_i + f_str + "suffix");
        test("prefix75000000suffix119suffix2", "prefix" + sf_i + "suffix1" + f_str + "suffix2");
        test("75000000-41", "" + sf_i + sf_bM);
        test("75000000-41suffix", "" + sf_i + sf_bM + "suffix");
        test("prefix75000000suffix1-41suffix2", "prefix" + sf_i + "suffix1" + sf_bM + "suffix2");
        test("75000000null", "" + sf_i + sf_IN);
        test("75000000nullsuffix", "" + sf_i + sf_IN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + sf_IN + "suffix2");
        test("75000000T", "" + sf_i + s_c);
        test("75000000Tsuffix", "" + sf_i + s_c + "suffix");
        test("prefix75000000suffix1Tsuffix2", "prefix" + sf_i + "suffix1" + s_c + "suffix2");
        test("75000000-42.0", "" + sf_i + sf_fM);
        test("75000000-42.0suffix", "" + sf_i + sf_fM + "suffix");
        test("prefix75000000suffix1-42.0suffix2", "prefix" + sf_i + "suffix1" + sf_fM + "suffix2");
        test("7500000025", "" + sf_i + s_b);
        test("7500000025suffix", "" + sf_i + s_b + "suffix");
        test("prefix75000000suffix125suffix2", "prefix" + sf_i + "suffix1" + s_b + "suffix2");
        test("75000000null", "" + sf_i + f_oN);
        test("75000000nullsuffix", "" + sf_i + f_oN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + f_oN + "suffix2");
        test("75000000-1410065408", "" + sf_i + s_lM);
        test("75000000-1410065408suffix", "" + sf_i + s_lM + "suffix");
        test("prefix75000000suffix1-1410065408suffix2", "prefix" + sf_i + "suffix1" + s_lM + "suffix2");
        test("750000008.0", "" + sf_i + s_d);
        test("750000008.0suffix", "" + sf_i + s_d + "suffix");
        test("prefix75000000suffix18.0suffix2", "prefix" + sf_i + "suffix1" + s_d + "suffix2");
        test("7500000055.0", "" + sf_i + s_f);
        test("7500000055.0suffix", "" + sf_i + s_f + "suffix");
        test("prefix75000000suffix155.0suffix2", "prefix" + sf_i + "suffix1" + s_f + "suffix2");
        test("7500000097000000", "" + sf_i + s_i);
        test("7500000097000000suffix", "" + sf_i + s_i + "suffix");
        test("prefix75000000suffix197000000suffix2", "prefix" + sf_i + "suffix1" + s_i + "suffix2");
        test("75000000-9900", "" + sf_i + f_sM);
        test("75000000-9900suffix", "" + sf_i + f_sM + "suffix");
        test("prefix75000000suffix1-9900suffix2", "prefix" + sf_i + "suffix1" + f_sM + "suffix2");
        test("75000000935228928", "" + sf_i + s_l);
        test("75000000935228928suffix", "" + sf_i + s_l + "suffix");
        test("prefix75000000suffix1935228928suffix2", "prefix" + sf_i + "suffix1" + s_l + "suffix2");
        test("75000000-8400", "" + sf_i + sf_sM);
        test("75000000-8400suffix", "" + sf_i + sf_sM + "suffix");
        test("prefix75000000suffix1-8400suffix2", "prefix" + sf_i + "suffix1" + sf_sM + "suffix2");
        test("75000000C(82)", "" + sf_i + s_o);
        test("75000000C(82)suffix", "" + sf_i + s_o + "suffix");
        test("prefix75000000suffix1C(82)suffix2", "prefix" + sf_i + "suffix1" + s_o + "suffix2");
        test("75000000null", "" + sf_i + sf_oNtS);
        test("75000000nullsuffix", "" + sf_i + sf_oNtS + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + sf_oNtS + "suffix2");
        test("75000000true", "" + sf_i + s_bl);
        test("75000000truesuffix", "" + sf_i + s_bl + "suffix");
        test("prefix75000000suffix1truesuffix2", "prefix" + sf_i + "suffix1" + s_bl + "suffix2");
        test("750000003900", "" + sf_i + s_s);
        test("750000003900suffix", "" + sf_i + s_s + "suffix");
        test("prefix75000000suffix13900suffix2", "prefix" + sf_i + "suffix1" + s_s + "suffix2");
        test("75000000null", "" + sf_i + sf_oN);
        test("75000000nullsuffix", "" + sf_i + sf_oN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + sf_oN + "suffix2");
        test("7500000094000000", "" + sf_i + f_I);
        test("7500000094000000suffix", "" + sf_i + f_I + "suffix");
        test("prefix75000000suffix194000000suffix2", "prefix" + sf_i + "suffix1" + f_I + "suffix2");
        test("75000000null", "" + sf_i + f_IN);
        test("75000000nullsuffix", "" + sf_i + f_IN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + f_IN + "suffix2");
        test("75000000true", "" + sf_i + sf_bl);
        test("75000000truesuffix", "" + sf_i + sf_bl + "suffix");
        test("prefix75000000suffix1truesuffix2", "prefix" + sf_i + "suffix1" + sf_bl + "suffix2");
        test("750000005500", "" + sf_i + sf_s);
        test("750000005500suffix", "" + sf_i + sf_s + "suffix");
        test("prefix75000000suffix15500suffix2", "prefix" + sf_i + "suffix1" + sf_s + "suffix2");
        test("75000000-2900", "" + sf_i + s_sM);
        test("75000000-2900suffix", "" + sf_i + s_sM + "suffix");
        test("prefix75000000suffix1-2900suffix2", "prefix" + sf_i + "suffix1" + s_sM + "suffix2");
        test("75000000-194313216", "" + sf_i + sf_l);
        test("75000000-194313216suffix", "" + sf_i + sf_l + "suffix");
        test("prefix75000000suffix1-194313216suffix2", "prefix" + sf_i + "suffix1" + sf_l + "suffix2");
        test("7500000012", "" + sf_i + s_strU1);
        test("7500000012suffix", "" + sf_i + s_strU1 + "suffix");
        test("prefix75000000suffix112suffix2", "prefix" + sf_i + "suffix1" + s_strU1 + "suffix2");
        test("75000000C(87)", "" + sf_i + sf_o);
        test("75000000C(87)suffix", "" + sf_i + sf_o + "suffix");
        test("prefix75000000suffix1C(87)suffix2", "prefix" + sf_i + "suffix1" + sf_o + "suffix2");
        test("7500000091", "" + sf_i + s_strU2);
        test("7500000091suffix", "" + sf_i + s_strU2 + "suffix");
        test("prefix75000000suffix191suffix2", "prefix" + sf_i + "suffix1" + s_strU2 + "suffix2");
        test("7500000021", "" + sf_i + f_strU1);
        test("7500000021suffix", "" + sf_i + f_strU1 + "suffix");
        test("prefix75000000suffix121suffix2", "prefix" + sf_i + "suffix1" + f_strU1 + "suffix2");
        test("7500000018", "" + sf_i + f_strU2);
        test("7500000018suffix", "" + sf_i + f_strU2 + "suffix");
        test("prefix75000000suffix118suffix2", "prefix" + sf_i + "suffix1" + f_strU2 + "suffix2");
        test("75000000null", "" + sf_i + f_iAN);
        test("75000000nullsuffix", "" + sf_i + f_iAN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + f_iAN + "suffix2");
        test("75000000null", "" + sf_i + s_oN);
        test("75000000nullsuffix", "" + sf_i + s_oN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + s_oN + "suffix2");
        test("75000000\u045180", "" + sf_i + s_strU);
        test("75000000\u045180suffix", "" + sf_i + s_strU + "suffix");
        test("prefix75000000suffix1\u045180suffix2", "prefix" + sf_i + "suffix1" + s_strU + "suffix2");
        test("75000000C", "" + sf_i + sf_c);
        test("75000000Csuffix", "" + sf_i + sf_c + "suffix");
        test("prefix75000000suffix1Csuffix2", "prefix" + sf_i + "suffix1" + sf_c + "suffix2");
        test("7500000075", "" + sf_i + sf_str);
        test("7500000075suffix", "" + sf_i + sf_str + "suffix");
        test("prefix75000000suffix175suffix2", "prefix" + sf_i + "suffix1" + sf_str + "suffix2");
        test("75000000-43", "" + sf_i + s_bM);
        test("75000000-43suffix", "" + sf_i + s_bM + "suffix");
        test("prefix75000000suffix1-43suffix2", "prefix" + sf_i + "suffix1" + s_bM + "suffix2");
        test("7500000080", "" + sf_i + sf_b);
        test("7500000080suffix", "" + sf_i + sf_b + "suffix");
        test("prefix75000000suffix180suffix2", "prefix" + sf_i + "suffix1" + sf_b + "suffix2");
        test("75000000null", "" + sf_i + s_IN);
        test("75000000nullsuffix", "" + sf_i + s_IN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + s_IN + "suffix2");
        test("75000000-52.0", "" + sf_i + s_fM);
        test("75000000-52.0suffix", "" + sf_i + s_fM + "suffix");
        test("prefix75000000suffix1-52.0suffix2", "prefix" + sf_i + "suffix1" + s_fM + "suffix2");
        test("7500000075000000", "" + sf_i + sf_i);
        test("7500000075000000suffix", "" + sf_i + sf_i + "suffix");
        test("prefix75000000suffix175000000suffix2", "prefix" + sf_i + "suffix1" + sf_i + "suffix2");
        test("7500000044", "" + sf_i + f_b);
        test("7500000044suffix", "" + sf_i + f_b + "suffix");
        test("prefix75000000suffix144suffix2", "prefix" + sf_i + "suffix1" + f_b + "suffix2");
        test("75000000-1705032704", "" + sf_i + sf_lM);
        test("75000000-1705032704suffix", "" + sf_i + sf_lM + "suffix");
        test("prefix75000000suffix1-1705032704suffix2", "prefix" + sf_i + "suffix1" + sf_lM + "suffix2");
        test("75000000null", "" + sf_i + f_oAN);
        test("75000000nullsuffix", "" + sf_i + f_oAN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + f_oAN + "suffix2");
        test("7500000083.0", "" + sf_i + f_d);
        test("7500000083.0suffix", "" + sf_i + f_d + "suffix");
        test("prefix75000000suffix183.0suffix2", "prefix" + sf_i + "suffix1" + f_d + "suffix2");
        test("75000000I", "" + sf_i + f_c);
        test("75000000Isuffix", "" + sf_i + f_c + "suffix");
        test("prefix75000000suffix1Isuffix2", "prefix" + sf_i + "suffix1" + f_c + "suffix2");
        test("7500000094.0", "" + sf_i + f_f);
        test("7500000094.0suffix", "" + sf_i + f_f + "suffix");
        test("prefix75000000suffix194.0suffix2", "prefix" + sf_i + "suffix1" + f_f + "suffix2");
        test("7500000012.0", "" + sf_i + sf_d);
        test("7500000012.0suffix", "" + sf_i + sf_d + "suffix");
        test("prefix75000000suffix112.0suffix2", "prefix" + sf_i + "suffix1" + sf_d + "suffix2");
        test("75000000-99.0", "" + sf_i + f_dM);
        test("75000000-99.0suffix", "" + sf_i + f_dM + "suffix");
        test("prefix75000000suffix1-99.0suffix2", "prefix" + sf_i + "suffix1" + f_dM + "suffix2");
        test("7500000017.0", "" + sf_i + sf_f);
        test("7500000017.0suffix", "" + sf_i + sf_f + "suffix");
        test("prefix75000000suffix117.0suffix2", "prefix" + sf_i + "suffix1" + sf_f + "suffix2");
        test("75000000-84.0", "" + sf_i + sf_dM);
        test("75000000-84.0suffix", "" + sf_i + sf_dM + "suffix");
        test("prefix75000000suffix1-84.0suffix2", "prefix" + sf_i + "suffix1" + sf_dM + "suffix2");
        test("7500000058000000", "" + sf_i + f_i);
        test("7500000058000000suffix", "" + sf_i + f_i + "suffix");
        test("prefix75000000suffix158000000suffix2", "prefix" + sf_i + "suffix1" + f_i + "suffix2");
        test("75000000-55000000", "" + sf_i + f_iM);
        test("75000000-55000000suffix", "" + sf_i + f_iM + "suffix");
        test("prefix75000000suffix1-55000000suffix2", "prefix" + sf_i + "suffix1" + f_iM + "suffix2");
        test("750000001460392448", "" + sf_i + f_l);
        test("750000001460392448suffix", "" + sf_i + f_l + "suffix");
        test("prefix75000000suffix11460392448suffix2", "prefix" + sf_i + "suffix1" + f_l + "suffix2");
        test("75000000C(70)", "" + sf_i + f_o);
        test("75000000C(70)suffix", "" + sf_i + f_o + "suffix");
        test("prefix75000000suffix1C(70)suffix2", "prefix" + sf_i + "suffix1" + f_o + "suffix2");
        test("75000000\u04511", "" + sf_i + sf_strU);
        test("75000000\u04511suffix", "" + sf_i + sf_strU + "suffix");
        test("prefix75000000suffix1\u04511suffix2", "prefix" + sf_i + "suffix1" + sf_strU + "suffix2");
        test("750000008000", "" + sf_i + f_s);
        test("750000008000suffix", "" + sf_i + f_s + "suffix");
        test("prefix75000000suffix18000suffix2", "prefix" + sf_i + "suffix1" + f_s + "suffix2");
        test("7500000018", "" + sf_i + s_str);
        test("7500000018suffix", "" + sf_i + s_str + "suffix");
        test("prefix75000000suffix118suffix2", "prefix" + sf_i + "suffix1" + s_str + "suffix2");
        test("75000000-1000000", "" + sf_i + s_iM);
        test("75000000-1000000suffix", "" + sf_i + s_iM + "suffix");
        test("prefix75000000suffix1-1000000suffix2", "prefix" + sf_i + "suffix1" + s_iM + "suffix2");
        test("750000001000000", "" + sf_i + sf_I);
        test("750000001000000suffix", "" + sf_i + sf_I + "suffix");
        test("prefix75000000suffix11000000suffix2", "prefix" + sf_i + "suffix1" + sf_I + "suffix2");
        test("75000000null", "" + sf_i + f_oNtS);
        test("75000000nullsuffix", "" + sf_i + f_oNtS + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + f_oNtS + "suffix2");
        test("75000000false", "" + sf_i + f_bl);
        test("75000000falsesuffix", "" + sf_i + f_bl + "suffix");
        test("prefix75000000suffix1falsesuffix2", "prefix" + sf_i + "suffix1" + f_bl + "suffix2");
        test("75000000null", "" + sf_i + sf_iAN);
        test("75000000nullsuffix", "" + sf_i + sf_iAN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + sf_iAN + "suffix2");
        test("75000000-2000000", "" + sf_i + sf_iM);
        test("75000000-2000000suffix", "" + sf_i + sf_iM + "suffix");
        test("prefix75000000suffix1-2000000suffix2", "prefix" + sf_i + "suffix1" + sf_iM + "suffix2");
        test("75000000-820130816", "" + sf_i + f_lM);
        test("75000000-820130816suffix", "" + sf_i + f_lM + "suffix");
        test("prefix75000000suffix1-820130816suffix2", "prefix" + sf_i + "suffix1" + f_lM + "suffix2");
        test("75000000null", "" + sf_i + sf_oAN);
        test("75000000nullsuffix", "" + sf_i + sf_oAN + "suffix");
        test("prefix75000000suffix1nullsuffix2", "prefix" + sf_i + "suffix1" + sf_oAN + "suffix2");
        test("7500000025000000", "" + sf_i + s_I);
        test("7500000025000000suffix", "" + sf_i + s_I + "suffix");
        test("prefix75000000suffix125000000suffix2", "prefix" + sf_i + "suffix1" + s_I + "suffix2");
        test("44-96.0", "" + f_b + s_dM);
        test("44-96.0suffix", "" + f_b + s_dM + "suffix");
        test("prefix44suffix1-96.0suffix2", "prefix" + f_b + "suffix1" + s_dM + "suffix2");
        test("44null", "" + f_b + s_oNtS);
        test("44nullsuffix", "" + f_b + s_oNtS + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + s_oNtS + "suffix2");
        test("44\u045176", "" + f_b + f_strU);
        test("44\u045176suffix", "" + f_b + f_strU + "suffix");
        test("prefix44suffix1\u045176suffix2", "prefix" + f_b + "suffix1" + f_strU + "suffix2");
        test("4492", "" + f_b + sf_strU2);
        test("4492suffix", "" + f_b + sf_strU2 + "suffix");
        test("prefix44suffix192suffix2", "prefix" + f_b + "suffix1" + sf_strU2 + "suffix2");
        test("4451", "" + f_b + sf_strU1);
        test("4451suffix", "" + f_b + sf_strU1 + "suffix");
        test("prefix44suffix151suffix2", "prefix" + f_b + "suffix1" + sf_strU1 + "suffix2");
        test("44null", "" + f_b + s_iAN);
        test("44nullsuffix", "" + f_b + s_iAN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + s_iAN + "suffix2");
        test("44-54", "" + f_b + f_bM);
        test("44-54suffix", "" + f_b + f_bM + "suffix");
        test("prefix44suffix1-54suffix2", "prefix" + f_b + "suffix1" + f_bM + "suffix2");
        test("44-87.0", "" + f_b + f_fM);
        test("44-87.0suffix", "" + f_b + f_fM + "suffix");
        test("prefix44suffix1-87.0suffix2", "prefix" + f_b + "suffix1" + f_fM + "suffix2");
        test("44null", "" + f_b + s_oAN);
        test("44nullsuffix", "" + f_b + s_oAN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + s_oAN + "suffix2");
        test("4419", "" + f_b + f_str);
        test("4419suffix", "" + f_b + f_str + "suffix");
        test("prefix44suffix119suffix2", "prefix" + f_b + "suffix1" + f_str + "suffix2");
        test("44-41", "" + f_b + sf_bM);
        test("44-41suffix", "" + f_b + sf_bM + "suffix");
        test("prefix44suffix1-41suffix2", "prefix" + f_b + "suffix1" + sf_bM + "suffix2");
        test("44null", "" + f_b + sf_IN);
        test("44nullsuffix", "" + f_b + sf_IN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + sf_IN + "suffix2");
        test("44T", "" + f_b + s_c);
        test("44Tsuffix", "" + f_b + s_c + "suffix");
        test("prefix44suffix1Tsuffix2", "prefix" + f_b + "suffix1" + s_c + "suffix2");
        test("44-42.0", "" + f_b + sf_fM);
        test("44-42.0suffix", "" + f_b + sf_fM + "suffix");
        test("prefix44suffix1-42.0suffix2", "prefix" + f_b + "suffix1" + sf_fM + "suffix2");
        test("4425", "" + f_b + s_b);
        test("4425suffix", "" + f_b + s_b + "suffix");
        test("prefix44suffix125suffix2", "prefix" + f_b + "suffix1" + s_b + "suffix2");
        test("44null", "" + f_b + f_oN);
        test("44nullsuffix", "" + f_b + f_oN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + f_oN + "suffix2");
        test("44-1410065408", "" + f_b + s_lM);
        test("44-1410065408suffix", "" + f_b + s_lM + "suffix");
        test("prefix44suffix1-1410065408suffix2", "prefix" + f_b + "suffix1" + s_lM + "suffix2");
        test("448.0", "" + f_b + s_d);
        test("448.0suffix", "" + f_b + s_d + "suffix");
        test("prefix44suffix18.0suffix2", "prefix" + f_b + "suffix1" + s_d + "suffix2");
        test("4455.0", "" + f_b + s_f);
        test("4455.0suffix", "" + f_b + s_f + "suffix");
        test("prefix44suffix155.0suffix2", "prefix" + f_b + "suffix1" + s_f + "suffix2");
        test("4497000000", "" + f_b + s_i);
        test("4497000000suffix", "" + f_b + s_i + "suffix");
        test("prefix44suffix197000000suffix2", "prefix" + f_b + "suffix1" + s_i + "suffix2");
        test("44-9900", "" + f_b + f_sM);
        test("44-9900suffix", "" + f_b + f_sM + "suffix");
        test("prefix44suffix1-9900suffix2", "prefix" + f_b + "suffix1" + f_sM + "suffix2");
        test("44935228928", "" + f_b + s_l);
        test("44935228928suffix", "" + f_b + s_l + "suffix");
        test("prefix44suffix1935228928suffix2", "prefix" + f_b + "suffix1" + s_l + "suffix2");
        test("44-8400", "" + f_b + sf_sM);
        test("44-8400suffix", "" + f_b + sf_sM + "suffix");
        test("prefix44suffix1-8400suffix2", "prefix" + f_b + "suffix1" + sf_sM + "suffix2");
        test("44C(82)", "" + f_b + s_o);
        test("44C(82)suffix", "" + f_b + s_o + "suffix");
        test("prefix44suffix1C(82)suffix2", "prefix" + f_b + "suffix1" + s_o + "suffix2");
        test("44null", "" + f_b + sf_oNtS);
        test("44nullsuffix", "" + f_b + sf_oNtS + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + sf_oNtS + "suffix2");
        test("44true", "" + f_b + s_bl);
        test("44truesuffix", "" + f_b + s_bl + "suffix");
        test("prefix44suffix1truesuffix2", "prefix" + f_b + "suffix1" + s_bl + "suffix2");
        test("443900", "" + f_b + s_s);
        test("443900suffix", "" + f_b + s_s + "suffix");
        test("prefix44suffix13900suffix2", "prefix" + f_b + "suffix1" + s_s + "suffix2");
        test("44null", "" + f_b + sf_oN);
        test("44nullsuffix", "" + f_b + sf_oN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + sf_oN + "suffix2");
        test("4494000000", "" + f_b + f_I);
        test("4494000000suffix", "" + f_b + f_I + "suffix");
        test("prefix44suffix194000000suffix2", "prefix" + f_b + "suffix1" + f_I + "suffix2");
        test("44null", "" + f_b + f_IN);
        test("44nullsuffix", "" + f_b + f_IN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + f_IN + "suffix2");
        test("44true", "" + f_b + sf_bl);
        test("44truesuffix", "" + f_b + sf_bl + "suffix");
        test("prefix44suffix1truesuffix2", "prefix" + f_b + "suffix1" + sf_bl + "suffix2");
        test("445500", "" + f_b + sf_s);
        test("445500suffix", "" + f_b + sf_s + "suffix");
        test("prefix44suffix15500suffix2", "prefix" + f_b + "suffix1" + sf_s + "suffix2");
        test("44-2900", "" + f_b + s_sM);
        test("44-2900suffix", "" + f_b + s_sM + "suffix");
        test("prefix44suffix1-2900suffix2", "prefix" + f_b + "suffix1" + s_sM + "suffix2");
        test("44-194313216", "" + f_b + sf_l);
        test("44-194313216suffix", "" + f_b + sf_l + "suffix");
        test("prefix44suffix1-194313216suffix2", "prefix" + f_b + "suffix1" + sf_l + "suffix2");
        test("4412", "" + f_b + s_strU1);
        test("4412suffix", "" + f_b + s_strU1 + "suffix");
        test("prefix44suffix112suffix2", "prefix" + f_b + "suffix1" + s_strU1 + "suffix2");
        test("44C(87)", "" + f_b + sf_o);
        test("44C(87)suffix", "" + f_b + sf_o + "suffix");
        test("prefix44suffix1C(87)suffix2", "prefix" + f_b + "suffix1" + sf_o + "suffix2");
        test("4491", "" + f_b + s_strU2);
        test("4491suffix", "" + f_b + s_strU2 + "suffix");
        test("prefix44suffix191suffix2", "prefix" + f_b + "suffix1" + s_strU2 + "suffix2");
        test("4421", "" + f_b + f_strU1);
        test("4421suffix", "" + f_b + f_strU1 + "suffix");
        test("prefix44suffix121suffix2", "prefix" + f_b + "suffix1" + f_strU1 + "suffix2");
        test("4418", "" + f_b + f_strU2);
        test("4418suffix", "" + f_b + f_strU2 + "suffix");
        test("prefix44suffix118suffix2", "prefix" + f_b + "suffix1" + f_strU2 + "suffix2");
        test("44null", "" + f_b + f_iAN);
        test("44nullsuffix", "" + f_b + f_iAN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + f_iAN + "suffix2");
        test("44null", "" + f_b + s_oN);
        test("44nullsuffix", "" + f_b + s_oN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + s_oN + "suffix2");
        test("44\u045180", "" + f_b + s_strU);
        test("44\u045180suffix", "" + f_b + s_strU + "suffix");
        test("prefix44suffix1\u045180suffix2", "prefix" + f_b + "suffix1" + s_strU + "suffix2");
        test("44C", "" + f_b + sf_c);
        test("44Csuffix", "" + f_b + sf_c + "suffix");
        test("prefix44suffix1Csuffix2", "prefix" + f_b + "suffix1" + sf_c + "suffix2");
        test("4475", "" + f_b + sf_str);
        test("4475suffix", "" + f_b + sf_str + "suffix");
        test("prefix44suffix175suffix2", "prefix" + f_b + "suffix1" + sf_str + "suffix2");
        test("44-43", "" + f_b + s_bM);
        test("44-43suffix", "" + f_b + s_bM + "suffix");
        test("prefix44suffix1-43suffix2", "prefix" + f_b + "suffix1" + s_bM + "suffix2");
        test("4480", "" + f_b + sf_b);
        test("4480suffix", "" + f_b + sf_b + "suffix");
        test("prefix44suffix180suffix2", "prefix" + f_b + "suffix1" + sf_b + "suffix2");
        test("44null", "" + f_b + s_IN);
        test("44nullsuffix", "" + f_b + s_IN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + s_IN + "suffix2");
        test("44-52.0", "" + f_b + s_fM);
        test("44-52.0suffix", "" + f_b + s_fM + "suffix");
        test("prefix44suffix1-52.0suffix2", "prefix" + f_b + "suffix1" + s_fM + "suffix2");
        test("4475000000", "" + f_b + sf_i);
        test("4475000000suffix", "" + f_b + sf_i + "suffix");
        test("prefix44suffix175000000suffix2", "prefix" + f_b + "suffix1" + sf_i + "suffix2");
        test("4444", "" + f_b + f_b);
        test("4444suffix", "" + f_b + f_b + "suffix");
        test("prefix44suffix144suffix2", "prefix" + f_b + "suffix1" + f_b + "suffix2");
        test("44-1705032704", "" + f_b + sf_lM);
        test("44-1705032704suffix", "" + f_b + sf_lM + "suffix");
        test("prefix44suffix1-1705032704suffix2", "prefix" + f_b + "suffix1" + sf_lM + "suffix2");
        test("44null", "" + f_b + f_oAN);
        test("44nullsuffix", "" + f_b + f_oAN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + f_oAN + "suffix2");
        test("4483.0", "" + f_b + f_d);
        test("4483.0suffix", "" + f_b + f_d + "suffix");
        test("prefix44suffix183.0suffix2", "prefix" + f_b + "suffix1" + f_d + "suffix2");
        test("44I", "" + f_b + f_c);
        test("44Isuffix", "" + f_b + f_c + "suffix");
        test("prefix44suffix1Isuffix2", "prefix" + f_b + "suffix1" + f_c + "suffix2");
        test("4494.0", "" + f_b + f_f);
        test("4494.0suffix", "" + f_b + f_f + "suffix");
        test("prefix44suffix194.0suffix2", "prefix" + f_b + "suffix1" + f_f + "suffix2");
        test("4412.0", "" + f_b + sf_d);
        test("4412.0suffix", "" + f_b + sf_d + "suffix");
        test("prefix44suffix112.0suffix2", "prefix" + f_b + "suffix1" + sf_d + "suffix2");
        test("44-99.0", "" + f_b + f_dM);
        test("44-99.0suffix", "" + f_b + f_dM + "suffix");
        test("prefix44suffix1-99.0suffix2", "prefix" + f_b + "suffix1" + f_dM + "suffix2");
        test("4417.0", "" + f_b + sf_f);
        test("4417.0suffix", "" + f_b + sf_f + "suffix");
        test("prefix44suffix117.0suffix2", "prefix" + f_b + "suffix1" + sf_f + "suffix2");
        test("44-84.0", "" + f_b + sf_dM);
        test("44-84.0suffix", "" + f_b + sf_dM + "suffix");
        test("prefix44suffix1-84.0suffix2", "prefix" + f_b + "suffix1" + sf_dM + "suffix2");
        test("4458000000", "" + f_b + f_i);
        test("4458000000suffix", "" + f_b + f_i + "suffix");
        test("prefix44suffix158000000suffix2", "prefix" + f_b + "suffix1" + f_i + "suffix2");
        test("44-55000000", "" + f_b + f_iM);
        test("44-55000000suffix", "" + f_b + f_iM + "suffix");
        test("prefix44suffix1-55000000suffix2", "prefix" + f_b + "suffix1" + f_iM + "suffix2");
        test("441460392448", "" + f_b + f_l);
        test("441460392448suffix", "" + f_b + f_l + "suffix");
        test("prefix44suffix11460392448suffix2", "prefix" + f_b + "suffix1" + f_l + "suffix2");
        test("44C(70)", "" + f_b + f_o);
        test("44C(70)suffix", "" + f_b + f_o + "suffix");
        test("prefix44suffix1C(70)suffix2", "prefix" + f_b + "suffix1" + f_o + "suffix2");
        test("44\u04511", "" + f_b + sf_strU);
        test("44\u04511suffix", "" + f_b + sf_strU + "suffix");
        test("prefix44suffix1\u04511suffix2", "prefix" + f_b + "suffix1" + sf_strU + "suffix2");
        test("448000", "" + f_b + f_s);
        test("448000suffix", "" + f_b + f_s + "suffix");
        test("prefix44suffix18000suffix2", "prefix" + f_b + "suffix1" + f_s + "suffix2");
        test("4418", "" + f_b + s_str);
        test("4418suffix", "" + f_b + s_str + "suffix");
        test("prefix44suffix118suffix2", "prefix" + f_b + "suffix1" + s_str + "suffix2");
        test("44-1000000", "" + f_b + s_iM);
        test("44-1000000suffix", "" + f_b + s_iM + "suffix");
        test("prefix44suffix1-1000000suffix2", "prefix" + f_b + "suffix1" + s_iM + "suffix2");
        test("441000000", "" + f_b + sf_I);
        test("441000000suffix", "" + f_b + sf_I + "suffix");
        test("prefix44suffix11000000suffix2", "prefix" + f_b + "suffix1" + sf_I + "suffix2");
        test("44null", "" + f_b + f_oNtS);
        test("44nullsuffix", "" + f_b + f_oNtS + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + f_oNtS + "suffix2");
        test("44false", "" + f_b + f_bl);
        test("44falsesuffix", "" + f_b + f_bl + "suffix");
        test("prefix44suffix1falsesuffix2", "prefix" + f_b + "suffix1" + f_bl + "suffix2");
        test("44null", "" + f_b + sf_iAN);
        test("44nullsuffix", "" + f_b + sf_iAN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + sf_iAN + "suffix2");
        test("44-2000000", "" + f_b + sf_iM);
        test("44-2000000suffix", "" + f_b + sf_iM + "suffix");
        test("prefix44suffix1-2000000suffix2", "prefix" + f_b + "suffix1" + sf_iM + "suffix2");
        test("44-820130816", "" + f_b + f_lM);
        test("44-820130816suffix", "" + f_b + f_lM + "suffix");
        test("prefix44suffix1-820130816suffix2", "prefix" + f_b + "suffix1" + f_lM + "suffix2");
        test("44null", "" + f_b + sf_oAN);
        test("44nullsuffix", "" + f_b + sf_oAN + "suffix");
        test("prefix44suffix1nullsuffix2", "prefix" + f_b + "suffix1" + sf_oAN + "suffix2");
        test("4425000000", "" + f_b + s_I);
        test("4425000000suffix", "" + f_b + s_I + "suffix");
        test("prefix44suffix125000000suffix2", "prefix" + f_b + "suffix1" + s_I + "suffix2");
        test("-1705032704-96.0", "" + sf_lM + s_dM);
        test("-1705032704-96.0suffix", "" + sf_lM + s_dM + "suffix");
        test("prefix-1705032704suffix1-96.0suffix2", "prefix" + sf_lM + "suffix1" + s_dM + "suffix2");
        test("-1705032704null", "" + sf_lM + s_oNtS);
        test("-1705032704nullsuffix", "" + sf_lM + s_oNtS + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + s_oNtS + "suffix2");
        test("-1705032704\u045176", "" + sf_lM + f_strU);
        test("-1705032704\u045176suffix", "" + sf_lM + f_strU + "suffix");
        test("prefix-1705032704suffix1\u045176suffix2", "prefix" + sf_lM + "suffix1" + f_strU + "suffix2");
        test("-170503270492", "" + sf_lM + sf_strU2);
        test("-170503270492suffix", "" + sf_lM + sf_strU2 + "suffix");
        test("prefix-1705032704suffix192suffix2", "prefix" + sf_lM + "suffix1" + sf_strU2 + "suffix2");
        test("-170503270451", "" + sf_lM + sf_strU1);
        test("-170503270451suffix", "" + sf_lM + sf_strU1 + "suffix");
        test("prefix-1705032704suffix151suffix2", "prefix" + sf_lM + "suffix1" + sf_strU1 + "suffix2");
        test("-1705032704null", "" + sf_lM + s_iAN);
        test("-1705032704nullsuffix", "" + sf_lM + s_iAN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + s_iAN + "suffix2");
        test("-1705032704-54", "" + sf_lM + f_bM);
        test("-1705032704-54suffix", "" + sf_lM + f_bM + "suffix");
        test("prefix-1705032704suffix1-54suffix2", "prefix" + sf_lM + "suffix1" + f_bM + "suffix2");
        test("-1705032704-87.0", "" + sf_lM + f_fM);
        test("-1705032704-87.0suffix", "" + sf_lM + f_fM + "suffix");
        test("prefix-1705032704suffix1-87.0suffix2", "prefix" + sf_lM + "suffix1" + f_fM + "suffix2");
        test("-1705032704null", "" + sf_lM + s_oAN);
        test("-1705032704nullsuffix", "" + sf_lM + s_oAN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + s_oAN + "suffix2");
        test("-170503270419", "" + sf_lM + f_str);
        test("-170503270419suffix", "" + sf_lM + f_str + "suffix");
        test("prefix-1705032704suffix119suffix2", "prefix" + sf_lM + "suffix1" + f_str + "suffix2");
        test("-1705032704-41", "" + sf_lM + sf_bM);
        test("-1705032704-41suffix", "" + sf_lM + sf_bM + "suffix");
        test("prefix-1705032704suffix1-41suffix2", "prefix" + sf_lM + "suffix1" + sf_bM + "suffix2");
        test("-1705032704null", "" + sf_lM + sf_IN);
        test("-1705032704nullsuffix", "" + sf_lM + sf_IN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + sf_IN + "suffix2");
        test("-1705032704T", "" + sf_lM + s_c);
        test("-1705032704Tsuffix", "" + sf_lM + s_c + "suffix");
        test("prefix-1705032704suffix1Tsuffix2", "prefix" + sf_lM + "suffix1" + s_c + "suffix2");
        test("-1705032704-42.0", "" + sf_lM + sf_fM);
        test("-1705032704-42.0suffix", "" + sf_lM + sf_fM + "suffix");
        test("prefix-1705032704suffix1-42.0suffix2", "prefix" + sf_lM + "suffix1" + sf_fM + "suffix2");
        test("-170503270425", "" + sf_lM + s_b);
        test("-170503270425suffix", "" + sf_lM + s_b + "suffix");
        test("prefix-1705032704suffix125suffix2", "prefix" + sf_lM + "suffix1" + s_b + "suffix2");
        test("-1705032704null", "" + sf_lM + f_oN);
        test("-1705032704nullsuffix", "" + sf_lM + f_oN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + f_oN + "suffix2");
        test("-1705032704-1410065408", "" + sf_lM + s_lM);
        test("-1705032704-1410065408suffix", "" + sf_lM + s_lM + "suffix");
        test("prefix-1705032704suffix1-1410065408suffix2", "prefix" + sf_lM + "suffix1" + s_lM + "suffix2");
        test("-17050327048.0", "" + sf_lM + s_d);
        test("-17050327048.0suffix", "" + sf_lM + s_d + "suffix");
        test("prefix-1705032704suffix18.0suffix2", "prefix" + sf_lM + "suffix1" + s_d + "suffix2");
        test("-170503270455.0", "" + sf_lM + s_f);
        test("-170503270455.0suffix", "" + sf_lM + s_f + "suffix");
        test("prefix-1705032704suffix155.0suffix2", "prefix" + sf_lM + "suffix1" + s_f + "suffix2");
        test("-170503270497000000", "" + sf_lM + s_i);
        test("-170503270497000000suffix", "" + sf_lM + s_i + "suffix");
        test("prefix-1705032704suffix197000000suffix2", "prefix" + sf_lM + "suffix1" + s_i + "suffix2");
        test("-1705032704-9900", "" + sf_lM + f_sM);
        test("-1705032704-9900suffix", "" + sf_lM + f_sM + "suffix");
        test("prefix-1705032704suffix1-9900suffix2", "prefix" + sf_lM + "suffix1" + f_sM + "suffix2");
        test("-1705032704935228928", "" + sf_lM + s_l);
        test("-1705032704935228928suffix", "" + sf_lM + s_l + "suffix");
        test("prefix-1705032704suffix1935228928suffix2", "prefix" + sf_lM + "suffix1" + s_l + "suffix2");
        test("-1705032704-8400", "" + sf_lM + sf_sM);
        test("-1705032704-8400suffix", "" + sf_lM + sf_sM + "suffix");
        test("prefix-1705032704suffix1-8400suffix2", "prefix" + sf_lM + "suffix1" + sf_sM + "suffix2");
        test("-1705032704C(82)", "" + sf_lM + s_o);
        test("-1705032704C(82)suffix", "" + sf_lM + s_o + "suffix");
        test("prefix-1705032704suffix1C(82)suffix2", "prefix" + sf_lM + "suffix1" + s_o + "suffix2");
        test("-1705032704null", "" + sf_lM + sf_oNtS);
        test("-1705032704nullsuffix", "" + sf_lM + sf_oNtS + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + sf_oNtS + "suffix2");
        test("-1705032704true", "" + sf_lM + s_bl);
        test("-1705032704truesuffix", "" + sf_lM + s_bl + "suffix");
        test("prefix-1705032704suffix1truesuffix2", "prefix" + sf_lM + "suffix1" + s_bl + "suffix2");
        test("-17050327043900", "" + sf_lM + s_s);
        test("-17050327043900suffix", "" + sf_lM + s_s + "suffix");
        test("prefix-1705032704suffix13900suffix2", "prefix" + sf_lM + "suffix1" + s_s + "suffix2");
        test("-1705032704null", "" + sf_lM + sf_oN);
        test("-1705032704nullsuffix", "" + sf_lM + sf_oN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + sf_oN + "suffix2");
        test("-170503270494000000", "" + sf_lM + f_I);
        test("-170503270494000000suffix", "" + sf_lM + f_I + "suffix");
        test("prefix-1705032704suffix194000000suffix2", "prefix" + sf_lM + "suffix1" + f_I + "suffix2");
        test("-1705032704null", "" + sf_lM + f_IN);
        test("-1705032704nullsuffix", "" + sf_lM + f_IN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + f_IN + "suffix2");
        test("-1705032704true", "" + sf_lM + sf_bl);
        test("-1705032704truesuffix", "" + sf_lM + sf_bl + "suffix");
        test("prefix-1705032704suffix1truesuffix2", "prefix" + sf_lM + "suffix1" + sf_bl + "suffix2");
        test("-17050327045500", "" + sf_lM + sf_s);
        test("-17050327045500suffix", "" + sf_lM + sf_s + "suffix");
        test("prefix-1705032704suffix15500suffix2", "prefix" + sf_lM + "suffix1" + sf_s + "suffix2");
        test("-1705032704-2900", "" + sf_lM + s_sM);
        test("-1705032704-2900suffix", "" + sf_lM + s_sM + "suffix");
        test("prefix-1705032704suffix1-2900suffix2", "prefix" + sf_lM + "suffix1" + s_sM + "suffix2");
        test("-1705032704-194313216", "" + sf_lM + sf_l);
        test("-1705032704-194313216suffix", "" + sf_lM + sf_l + "suffix");
        test("prefix-1705032704suffix1-194313216suffix2", "prefix" + sf_lM + "suffix1" + sf_l + "suffix2");
        test("-170503270412", "" + sf_lM + s_strU1);
        test("-170503270412suffix", "" + sf_lM + s_strU1 + "suffix");
        test("prefix-1705032704suffix112suffix2", "prefix" + sf_lM + "suffix1" + s_strU1 + "suffix2");
        test("-1705032704C(87)", "" + sf_lM + sf_o);
        test("-1705032704C(87)suffix", "" + sf_lM + sf_o + "suffix");
        test("prefix-1705032704suffix1C(87)suffix2", "prefix" + sf_lM + "suffix1" + sf_o + "suffix2");
        test("-170503270491", "" + sf_lM + s_strU2);
        test("-170503270491suffix", "" + sf_lM + s_strU2 + "suffix");
        test("prefix-1705032704suffix191suffix2", "prefix" + sf_lM + "suffix1" + s_strU2 + "suffix2");
        test("-170503270421", "" + sf_lM + f_strU1);
        test("-170503270421suffix", "" + sf_lM + f_strU1 + "suffix");
        test("prefix-1705032704suffix121suffix2", "prefix" + sf_lM + "suffix1" + f_strU1 + "suffix2");
        test("-170503270418", "" + sf_lM + f_strU2);
        test("-170503270418suffix", "" + sf_lM + f_strU2 + "suffix");
        test("prefix-1705032704suffix118suffix2", "prefix" + sf_lM + "suffix1" + f_strU2 + "suffix2");
        test("-1705032704null", "" + sf_lM + f_iAN);
        test("-1705032704nullsuffix", "" + sf_lM + f_iAN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + f_iAN + "suffix2");
        test("-1705032704null", "" + sf_lM + s_oN);
        test("-1705032704nullsuffix", "" + sf_lM + s_oN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + s_oN + "suffix2");
        test("-1705032704\u045180", "" + sf_lM + s_strU);
        test("-1705032704\u045180suffix", "" + sf_lM + s_strU + "suffix");
        test("prefix-1705032704suffix1\u045180suffix2", "prefix" + sf_lM + "suffix1" + s_strU + "suffix2");
        test("-1705032704C", "" + sf_lM + sf_c);
        test("-1705032704Csuffix", "" + sf_lM + sf_c + "suffix");
        test("prefix-1705032704suffix1Csuffix2", "prefix" + sf_lM + "suffix1" + sf_c + "suffix2");
        test("-170503270475", "" + sf_lM + sf_str);
        test("-170503270475suffix", "" + sf_lM + sf_str + "suffix");
        test("prefix-1705032704suffix175suffix2", "prefix" + sf_lM + "suffix1" + sf_str + "suffix2");
        test("-1705032704-43", "" + sf_lM + s_bM);
        test("-1705032704-43suffix", "" + sf_lM + s_bM + "suffix");
        test("prefix-1705032704suffix1-43suffix2", "prefix" + sf_lM + "suffix1" + s_bM + "suffix2");
        test("-170503270480", "" + sf_lM + sf_b);
        test("-170503270480suffix", "" + sf_lM + sf_b + "suffix");
        test("prefix-1705032704suffix180suffix2", "prefix" + sf_lM + "suffix1" + sf_b + "suffix2");
        test("-1705032704null", "" + sf_lM + s_IN);
        test("-1705032704nullsuffix", "" + sf_lM + s_IN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + s_IN + "suffix2");
        test("-1705032704-52.0", "" + sf_lM + s_fM);
        test("-1705032704-52.0suffix", "" + sf_lM + s_fM + "suffix");
        test("prefix-1705032704suffix1-52.0suffix2", "prefix" + sf_lM + "suffix1" + s_fM + "suffix2");
        test("-170503270475000000", "" + sf_lM + sf_i);
        test("-170503270475000000suffix", "" + sf_lM + sf_i + "suffix");
        test("prefix-1705032704suffix175000000suffix2", "prefix" + sf_lM + "suffix1" + sf_i + "suffix2");
        test("-170503270444", "" + sf_lM + f_b);
        test("-170503270444suffix", "" + sf_lM + f_b + "suffix");
        test("prefix-1705032704suffix144suffix2", "prefix" + sf_lM + "suffix1" + f_b + "suffix2");
        test("-1705032704-1705032704", "" + sf_lM + sf_lM);
        test("-1705032704-1705032704suffix", "" + sf_lM + sf_lM + "suffix");
        test("prefix-1705032704suffix1-1705032704suffix2", "prefix" + sf_lM + "suffix1" + sf_lM + "suffix2");
        test("-1705032704null", "" + sf_lM + f_oAN);
        test("-1705032704nullsuffix", "" + sf_lM + f_oAN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + f_oAN + "suffix2");
        test("-170503270483.0", "" + sf_lM + f_d);
        test("-170503270483.0suffix", "" + sf_lM + f_d + "suffix");
        test("prefix-1705032704suffix183.0suffix2", "prefix" + sf_lM + "suffix1" + f_d + "suffix2");
        test("-1705032704I", "" + sf_lM + f_c);
        test("-1705032704Isuffix", "" + sf_lM + f_c + "suffix");
        test("prefix-1705032704suffix1Isuffix2", "prefix" + sf_lM + "suffix1" + f_c + "suffix2");
        test("-170503270494.0", "" + sf_lM + f_f);
        test("-170503270494.0suffix", "" + sf_lM + f_f + "suffix");
        test("prefix-1705032704suffix194.0suffix2", "prefix" + sf_lM + "suffix1" + f_f + "suffix2");
        test("-170503270412.0", "" + sf_lM + sf_d);
        test("-170503270412.0suffix", "" + sf_lM + sf_d + "suffix");
        test("prefix-1705032704suffix112.0suffix2", "prefix" + sf_lM + "suffix1" + sf_d + "suffix2");
        test("-1705032704-99.0", "" + sf_lM + f_dM);
        test("-1705032704-99.0suffix", "" + sf_lM + f_dM + "suffix");
        test("prefix-1705032704suffix1-99.0suffix2", "prefix" + sf_lM + "suffix1" + f_dM + "suffix2");
        test("-170503270417.0", "" + sf_lM + sf_f);
        test("-170503270417.0suffix", "" + sf_lM + sf_f + "suffix");
        test("prefix-1705032704suffix117.0suffix2", "prefix" + sf_lM + "suffix1" + sf_f + "suffix2");
        test("-1705032704-84.0", "" + sf_lM + sf_dM);
        test("-1705032704-84.0suffix", "" + sf_lM + sf_dM + "suffix");
        test("prefix-1705032704suffix1-84.0suffix2", "prefix" + sf_lM + "suffix1" + sf_dM + "suffix2");
        test("-170503270458000000", "" + sf_lM + f_i);
        test("-170503270458000000suffix", "" + sf_lM + f_i + "suffix");
        test("prefix-1705032704suffix158000000suffix2", "prefix" + sf_lM + "suffix1" + f_i + "suffix2");
        test("-1705032704-55000000", "" + sf_lM + f_iM);
        test("-1705032704-55000000suffix", "" + sf_lM + f_iM + "suffix");
        test("prefix-1705032704suffix1-55000000suffix2", "prefix" + sf_lM + "suffix1" + f_iM + "suffix2");
        test("-17050327041460392448", "" + sf_lM + f_l);
        test("-17050327041460392448suffix", "" + sf_lM + f_l + "suffix");
        test("prefix-1705032704suffix11460392448suffix2", "prefix" + sf_lM + "suffix1" + f_l + "suffix2");
        test("-1705032704C(70)", "" + sf_lM + f_o);
        test("-1705032704C(70)suffix", "" + sf_lM + f_o + "suffix");
        test("prefix-1705032704suffix1C(70)suffix2", "prefix" + sf_lM + "suffix1" + f_o + "suffix2");
        test("-1705032704\u04511", "" + sf_lM + sf_strU);
        test("-1705032704\u04511suffix", "" + sf_lM + sf_strU + "suffix");
        test("prefix-1705032704suffix1\u04511suffix2", "prefix" + sf_lM + "suffix1" + sf_strU + "suffix2");
        test("-17050327048000", "" + sf_lM + f_s);
        test("-17050327048000suffix", "" + sf_lM + f_s + "suffix");
        test("prefix-1705032704suffix18000suffix2", "prefix" + sf_lM + "suffix1" + f_s + "suffix2");
        test("-170503270418", "" + sf_lM + s_str);
        test("-170503270418suffix", "" + sf_lM + s_str + "suffix");
        test("prefix-1705032704suffix118suffix2", "prefix" + sf_lM + "suffix1" + s_str + "suffix2");
        test("-1705032704-1000000", "" + sf_lM + s_iM);
        test("-1705032704-1000000suffix", "" + sf_lM + s_iM + "suffix");
        test("prefix-1705032704suffix1-1000000suffix2", "prefix" + sf_lM + "suffix1" + s_iM + "suffix2");
        test("-17050327041000000", "" + sf_lM + sf_I);
        test("-17050327041000000suffix", "" + sf_lM + sf_I + "suffix");
        test("prefix-1705032704suffix11000000suffix2", "prefix" + sf_lM + "suffix1" + sf_I + "suffix2");
        test("-1705032704null", "" + sf_lM + f_oNtS);
        test("-1705032704nullsuffix", "" + sf_lM + f_oNtS + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + f_oNtS + "suffix2");
        test("-1705032704false", "" + sf_lM + f_bl);
        test("-1705032704falsesuffix", "" + sf_lM + f_bl + "suffix");
        test("prefix-1705032704suffix1falsesuffix2", "prefix" + sf_lM + "suffix1" + f_bl + "suffix2");
        test("-1705032704null", "" + sf_lM + sf_iAN);
        test("-1705032704nullsuffix", "" + sf_lM + sf_iAN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + sf_iAN + "suffix2");
        test("-1705032704-2000000", "" + sf_lM + sf_iM);
        test("-1705032704-2000000suffix", "" + sf_lM + sf_iM + "suffix");
        test("prefix-1705032704suffix1-2000000suffix2", "prefix" + sf_lM + "suffix1" + sf_iM + "suffix2");
        test("-1705032704-820130816", "" + sf_lM + f_lM);
        test("-1705032704-820130816suffix", "" + sf_lM + f_lM + "suffix");
        test("prefix-1705032704suffix1-820130816suffix2", "prefix" + sf_lM + "suffix1" + f_lM + "suffix2");
        test("-1705032704null", "" + sf_lM + sf_oAN);
        test("-1705032704nullsuffix", "" + sf_lM + sf_oAN + "suffix");
        test("prefix-1705032704suffix1nullsuffix2", "prefix" + sf_lM + "suffix1" + sf_oAN + "suffix2");
        test("-170503270425000000", "" + sf_lM + s_I);
        test("-170503270425000000suffix", "" + sf_lM + s_I + "suffix");
        test("prefix-1705032704suffix125000000suffix2", "prefix" + sf_lM + "suffix1" + s_I + "suffix2");
        test("null-96.0", "" + f_oAN + s_dM);
        test("null-96.0suffix", "" + f_oAN + s_dM + "suffix");
        test("prefixnullsuffix1-96.0suffix2", "prefix" + f_oAN + "suffix1" + s_dM + "suffix2");
        test("nullnull", "" + f_oAN + s_oNtS);
        test("nullnullsuffix", "" + f_oAN + s_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + s_oNtS + "suffix2");
        test("null\u045176", "" + f_oAN + f_strU);
        test("null\u045176suffix", "" + f_oAN + f_strU + "suffix");
        test("prefixnullsuffix1\u045176suffix2", "prefix" + f_oAN + "suffix1" + f_strU + "suffix2");
        test("null92", "" + f_oAN + sf_strU2);
        test("null92suffix", "" + f_oAN + sf_strU2 + "suffix");
        test("prefixnullsuffix192suffix2", "prefix" + f_oAN + "suffix1" + sf_strU2 + "suffix2");
        test("null51", "" + f_oAN + sf_strU1);
        test("null51suffix", "" + f_oAN + sf_strU1 + "suffix");
        test("prefixnullsuffix151suffix2", "prefix" + f_oAN + "suffix1" + sf_strU1 + "suffix2");
        test("nullnull", "" + f_oAN + s_iAN);
        test("nullnullsuffix", "" + f_oAN + s_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + s_iAN + "suffix2");
        test("null-54", "" + f_oAN + f_bM);
        test("null-54suffix", "" + f_oAN + f_bM + "suffix");
        test("prefixnullsuffix1-54suffix2", "prefix" + f_oAN + "suffix1" + f_bM + "suffix2");
        test("null-87.0", "" + f_oAN + f_fM);
        test("null-87.0suffix", "" + f_oAN + f_fM + "suffix");
        test("prefixnullsuffix1-87.0suffix2", "prefix" + f_oAN + "suffix1" + f_fM + "suffix2");
        test("nullnull", "" + f_oAN + s_oAN);
        test("nullnullsuffix", "" + f_oAN + s_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + s_oAN + "suffix2");
        test("null19", "" + f_oAN + f_str);
        test("null19suffix", "" + f_oAN + f_str + "suffix");
        test("prefixnullsuffix119suffix2", "prefix" + f_oAN + "suffix1" + f_str + "suffix2");
        test("null-41", "" + f_oAN + sf_bM);
        test("null-41suffix", "" + f_oAN + sf_bM + "suffix");
        test("prefixnullsuffix1-41suffix2", "prefix" + f_oAN + "suffix1" + sf_bM + "suffix2");
        test("nullnull", "" + f_oAN + sf_IN);
        test("nullnullsuffix", "" + f_oAN + sf_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + sf_IN + "suffix2");
        test("nullT", "" + f_oAN + s_c);
        test("nullTsuffix", "" + f_oAN + s_c + "suffix");
        test("prefixnullsuffix1Tsuffix2", "prefix" + f_oAN + "suffix1" + s_c + "suffix2");
        test("null-42.0", "" + f_oAN + sf_fM);
        test("null-42.0suffix", "" + f_oAN + sf_fM + "suffix");
        test("prefixnullsuffix1-42.0suffix2", "prefix" + f_oAN + "suffix1" + sf_fM + "suffix2");
        test("null25", "" + f_oAN + s_b);
        test("null25suffix", "" + f_oAN + s_b + "suffix");
        test("prefixnullsuffix125suffix2", "prefix" + f_oAN + "suffix1" + s_b + "suffix2");
        test("nullnull", "" + f_oAN + f_oN);
        test("nullnullsuffix", "" + f_oAN + f_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + f_oN + "suffix2");
        test("null-1410065408", "" + f_oAN + s_lM);
        test("null-1410065408suffix", "" + f_oAN + s_lM + "suffix");
        test("prefixnullsuffix1-1410065408suffix2", "prefix" + f_oAN + "suffix1" + s_lM + "suffix2");
        test("null8.0", "" + f_oAN + s_d);
        test("null8.0suffix", "" + f_oAN + s_d + "suffix");
        test("prefixnullsuffix18.0suffix2", "prefix" + f_oAN + "suffix1" + s_d + "suffix2");
        test("null55.0", "" + f_oAN + s_f);
        test("null55.0suffix", "" + f_oAN + s_f + "suffix");
        test("prefixnullsuffix155.0suffix2", "prefix" + f_oAN + "suffix1" + s_f + "suffix2");
        test("null97000000", "" + f_oAN + s_i);
        test("null97000000suffix", "" + f_oAN + s_i + "suffix");
        test("prefixnullsuffix197000000suffix2", "prefix" + f_oAN + "suffix1" + s_i + "suffix2");
        test("null-9900", "" + f_oAN + f_sM);
        test("null-9900suffix", "" + f_oAN + f_sM + "suffix");
        test("prefixnullsuffix1-9900suffix2", "prefix" + f_oAN + "suffix1" + f_sM + "suffix2");
        test("null935228928", "" + f_oAN + s_l);
        test("null935228928suffix", "" + f_oAN + s_l + "suffix");
        test("prefixnullsuffix1935228928suffix2", "prefix" + f_oAN + "suffix1" + s_l + "suffix2");
        test("null-8400", "" + f_oAN + sf_sM);
        test("null-8400suffix", "" + f_oAN + sf_sM + "suffix");
        test("prefixnullsuffix1-8400suffix2", "prefix" + f_oAN + "suffix1" + sf_sM + "suffix2");
        test("nullC(82)", "" + f_oAN + s_o);
        test("nullC(82)suffix", "" + f_oAN + s_o + "suffix");
        test("prefixnullsuffix1C(82)suffix2", "prefix" + f_oAN + "suffix1" + s_o + "suffix2");
        test("nullnull", "" + f_oAN + sf_oNtS);
        test("nullnullsuffix", "" + f_oAN + sf_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + sf_oNtS + "suffix2");
        test("nulltrue", "" + f_oAN + s_bl);
        test("nulltruesuffix", "" + f_oAN + s_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_oAN + "suffix1" + s_bl + "suffix2");
        test("null3900", "" + f_oAN + s_s);
        test("null3900suffix", "" + f_oAN + s_s + "suffix");
        test("prefixnullsuffix13900suffix2", "prefix" + f_oAN + "suffix1" + s_s + "suffix2");
        test("nullnull", "" + f_oAN + sf_oN);
        test("nullnullsuffix", "" + f_oAN + sf_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + sf_oN + "suffix2");
        test("null94000000", "" + f_oAN + f_I);
        test("null94000000suffix", "" + f_oAN + f_I + "suffix");
        test("prefixnullsuffix194000000suffix2", "prefix" + f_oAN + "suffix1" + f_I + "suffix2");
        test("nullnull", "" + f_oAN + f_IN);
        test("nullnullsuffix", "" + f_oAN + f_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + f_IN + "suffix2");
        test("nulltrue", "" + f_oAN + sf_bl);
        test("nulltruesuffix", "" + f_oAN + sf_bl + "suffix");
        test("prefixnullsuffix1truesuffix2", "prefix" + f_oAN + "suffix1" + sf_bl + "suffix2");
        test("null5500", "" + f_oAN + sf_s);
        test("null5500suffix", "" + f_oAN + sf_s + "suffix");
        test("prefixnullsuffix15500suffix2", "prefix" + f_oAN + "suffix1" + sf_s + "suffix2");
        test("null-2900", "" + f_oAN + s_sM);
        test("null-2900suffix", "" + f_oAN + s_sM + "suffix");
        test("prefixnullsuffix1-2900suffix2", "prefix" + f_oAN + "suffix1" + s_sM + "suffix2");
        test("null-194313216", "" + f_oAN + sf_l);
        test("null-194313216suffix", "" + f_oAN + sf_l + "suffix");
        test("prefixnullsuffix1-194313216suffix2", "prefix" + f_oAN + "suffix1" + sf_l + "suffix2");
        test("null12", "" + f_oAN + s_strU1);
        test("null12suffix", "" + f_oAN + s_strU1 + "suffix");
        test("prefixnullsuffix112suffix2", "prefix" + f_oAN + "suffix1" + s_strU1 + "suffix2");
        test("nullC(87)", "" + f_oAN + sf_o);
        test("nullC(87)suffix", "" + f_oAN + sf_o + "suffix");
        test("prefixnullsuffix1C(87)suffix2", "prefix" + f_oAN + "suffix1" + sf_o + "suffix2");
        test("null91", "" + f_oAN + s_strU2);
        test("null91suffix", "" + f_oAN + s_strU2 + "suffix");
        test("prefixnullsuffix191suffix2", "prefix" + f_oAN + "suffix1" + s_strU2 + "suffix2");
        test("null21", "" + f_oAN + f_strU1);
        test("null21suffix", "" + f_oAN + f_strU1 + "suffix");
        test("prefixnullsuffix121suffix2", "prefix" + f_oAN + "suffix1" + f_strU1 + "suffix2");
        test("null18", "" + f_oAN + f_strU2);
        test("null18suffix", "" + f_oAN + f_strU2 + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_oAN + "suffix1" + f_strU2 + "suffix2");
        test("nullnull", "" + f_oAN + f_iAN);
        test("nullnullsuffix", "" + f_oAN + f_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + f_iAN + "suffix2");
        test("nullnull", "" + f_oAN + s_oN);
        test("nullnullsuffix", "" + f_oAN + s_oN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + s_oN + "suffix2");
        test("null\u045180", "" + f_oAN + s_strU);
        test("null\u045180suffix", "" + f_oAN + s_strU + "suffix");
        test("prefixnullsuffix1\u045180suffix2", "prefix" + f_oAN + "suffix1" + s_strU + "suffix2");
        test("nullC", "" + f_oAN + sf_c);
        test("nullCsuffix", "" + f_oAN + sf_c + "suffix");
        test("prefixnullsuffix1Csuffix2", "prefix" + f_oAN + "suffix1" + sf_c + "suffix2");
        test("null75", "" + f_oAN + sf_str);
        test("null75suffix", "" + f_oAN + sf_str + "suffix");
        test("prefixnullsuffix175suffix2", "prefix" + f_oAN + "suffix1" + sf_str + "suffix2");
        test("null-43", "" + f_oAN + s_bM);
        test("null-43suffix", "" + f_oAN + s_bM + "suffix");
        test("prefixnullsuffix1-43suffix2", "prefix" + f_oAN + "suffix1" + s_bM + "suffix2");
        test("null80", "" + f_oAN + sf_b);
        test("null80suffix", "" + f_oAN + sf_b + "suffix");
        test("prefixnullsuffix180suffix2", "prefix" + f_oAN + "suffix1" + sf_b + "suffix2");
        test("nullnull", "" + f_oAN + s_IN);
        test("nullnullsuffix", "" + f_oAN + s_IN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + s_IN + "suffix2");
        test("null-52.0", "" + f_oAN + s_fM);
        test("null-52.0suffix", "" + f_oAN + s_fM + "suffix");
        test("prefixnullsuffix1-52.0suffix2", "prefix" + f_oAN + "suffix1" + s_fM + "suffix2");
        test("null75000000", "" + f_oAN + sf_i);
        test("null75000000suffix", "" + f_oAN + sf_i + "suffix");
        test("prefixnullsuffix175000000suffix2", "prefix" + f_oAN + "suffix1" + sf_i + "suffix2");
        test("null44", "" + f_oAN + f_b);
        test("null44suffix", "" + f_oAN + f_b + "suffix");
        test("prefixnullsuffix144suffix2", "prefix" + f_oAN + "suffix1" + f_b + "suffix2");
        test("null-1705032704", "" + f_oAN + sf_lM);
        test("null-1705032704suffix", "" + f_oAN + sf_lM + "suffix");
        test("prefixnullsuffix1-1705032704suffix2", "prefix" + f_oAN + "suffix1" + sf_lM + "suffix2");
        test("nullnull", "" + f_oAN + f_oAN);
        test("nullnullsuffix", "" + f_oAN + f_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + f_oAN + "suffix2");
        test("null83.0", "" + f_oAN + f_d);
        test("null83.0suffix", "" + f_oAN + f_d + "suffix");
        test("prefixnullsuffix183.0suffix2", "prefix" + f_oAN + "suffix1" + f_d + "suffix2");
        test("nullI", "" + f_oAN + f_c);
        test("nullIsuffix", "" + f_oAN + f_c + "suffix");
        test("prefixnullsuffix1Isuffix2", "prefix" + f_oAN + "suffix1" + f_c + "suffix2");
        test("null94.0", "" + f_oAN + f_f);
        test("null94.0suffix", "" + f_oAN + f_f + "suffix");
        test("prefixnullsuffix194.0suffix2", "prefix" + f_oAN + "suffix1" + f_f + "suffix2");
        test("null12.0", "" + f_oAN + sf_d);
        test("null12.0suffix", "" + f_oAN + sf_d + "suffix");
        test("prefixnullsuffix112.0suffix2", "prefix" + f_oAN + "suffix1" + sf_d + "suffix2");
        test("null-99.0", "" + f_oAN + f_dM);
        test("null-99.0suffix", "" + f_oAN + f_dM + "suffix");
        test("prefixnullsuffix1-99.0suffix2", "prefix" + f_oAN + "suffix1" + f_dM + "suffix2");
        test("null17.0", "" + f_oAN + sf_f);
        test("null17.0suffix", "" + f_oAN + sf_f + "suffix");
        test("prefixnullsuffix117.0suffix2", "prefix" + f_oAN + "suffix1" + sf_f + "suffix2");
        test("null-84.0", "" + f_oAN + sf_dM);
        test("null-84.0suffix", "" + f_oAN + sf_dM + "suffix");
        test("prefixnullsuffix1-84.0suffix2", "prefix" + f_oAN + "suffix1" + sf_dM + "suffix2");
        test("null58000000", "" + f_oAN + f_i);
        test("null58000000suffix", "" + f_oAN + f_i + "suffix");
        test("prefixnullsuffix158000000suffix2", "prefix" + f_oAN + "suffix1" + f_i + "suffix2");
        test("null-55000000", "" + f_oAN + f_iM);
        test("null-55000000suffix", "" + f_oAN + f_iM + "suffix");
        test("prefixnullsuffix1-55000000suffix2", "prefix" + f_oAN + "suffix1" + f_iM + "suffix2");
        test("null1460392448", "" + f_oAN + f_l);
        test("null1460392448suffix", "" + f_oAN + f_l + "suffix");
        test("prefixnullsuffix11460392448suffix2", "prefix" + f_oAN + "suffix1" + f_l + "suffix2");
        test("nullC(70)", "" + f_oAN + f_o);
        test("nullC(70)suffix", "" + f_oAN + f_o + "suffix");
        test("prefixnullsuffix1C(70)suffix2", "prefix" + f_oAN + "suffix1" + f_o + "suffix2");
        test("null\u04511", "" + f_oAN + sf_strU);
        test("null\u04511suffix", "" + f_oAN + sf_strU + "suffix");
        test("prefixnullsuffix1\u04511suffix2", "prefix" + f_oAN + "suffix1" + sf_strU + "suffix2");
        test("null8000", "" + f_oAN + f_s);
        test("null8000suffix", "" + f_oAN + f_s + "suffix");
        test("prefixnullsuffix18000suffix2", "prefix" + f_oAN + "suffix1" + f_s + "suffix2");
        test("null18", "" + f_oAN + s_str);
        test("null18suffix", "" + f_oAN + s_str + "suffix");
        test("prefixnullsuffix118suffix2", "prefix" + f_oAN + "suffix1" + s_str + "suffix2");
        test("null-1000000", "" + f_oAN + s_iM);
        test("null-1000000suffix", "" + f_oAN + s_iM + "suffix");
        test("prefixnullsuffix1-1000000suffix2", "prefix" + f_oAN + "suffix1" + s_iM + "suffix2");
        test("null1000000", "" + f_oAN + sf_I);
        test("null1000000suffix", "" + f_oAN + sf_I + "suffix");
        test("prefixnullsuffix11000000suffix2", "prefix" + f_oAN + "suffix1" + sf_I + "suffix2");
        test("nullnull", "" + f_oAN + f_oNtS);
        test("nullnullsuffix", "" + f_oAN + f_oNtS + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + f_oNtS + "suffix2");
        test("nullfalse", "" + f_oAN + f_bl);
        test("nullfalsesuffix", "" + f_oAN + f_bl + "suffix");
        test("prefixnullsuffix1falsesuffix2", "prefix" + f_oAN + "suffix1" + f_bl + "suffix2");
        test("nullnull", "" + f_oAN + sf_iAN);
        test("nullnullsuffix", "" + f_oAN + sf_iAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + sf_iAN + "suffix2");
        test("null-2000000", "" + f_oAN + sf_iM);
        test("null-2000000suffix", "" + f_oAN + sf_iM + "suffix");
        test("prefixnullsuffix1-2000000suffix2", "prefix" + f_oAN + "suffix1" + sf_iM + "suffix2");
        test("null-820130816", "" + f_oAN + f_lM);
        test("null-820130816suffix", "" + f_oAN + f_lM + "suffix");
        test("prefixnullsuffix1-820130816suffix2", "prefix" + f_oAN + "suffix1" + f_lM + "suffix2");
        test("nullnull", "" + f_oAN + sf_oAN);
        test("nullnullsuffix", "" + f_oAN + sf_oAN + "suffix");
        test("prefixnullsuffix1nullsuffix2", "prefix" + f_oAN + "suffix1" + sf_oAN + "suffix2");
        test("null25000000", "" + f_oAN + s_I);
        test("null25000000suffix", "" + f_oAN + s_I + "suffix");
        test("prefixnullsuffix125000000suffix2", "prefix" + f_oAN + "suffix1" + s_I + "suffix2");
    }

    public void run12() {
        test("83.0-96.0", "" + f_d + s_dM);
        test("83.0-96.0suffix", "" + f_d + s_dM + "suffix");
        test("prefix83.0suffix1-96.0suffix2", "prefix" + f_d + "suffix1" + s_dM + "suffix2");
        test("83.0null", "" + f_d + s_oNtS);
        test("83.0nullsuffix", "" + f_d + s_oNtS + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + s_oNtS + "suffix2");
        test("83.0\u045176", "" + f_d + f_strU);
        test("83.0\u045176suffix", "" + f_d + f_strU + "suffix");
        test("prefix83.0suffix1\u045176suffix2", "prefix" + f_d + "suffix1" + f_strU + "suffix2");
        test("83.092", "" + f_d + sf_strU2);
        test("83.092suffix", "" + f_d + sf_strU2 + "suffix");
        test("prefix83.0suffix192suffix2", "prefix" + f_d + "suffix1" + sf_strU2 + "suffix2");
        test("83.051", "" + f_d + sf_strU1);
        test("83.051suffix", "" + f_d + sf_strU1 + "suffix");
        test("prefix83.0suffix151suffix2", "prefix" + f_d + "suffix1" + sf_strU1 + "suffix2");
        test("83.0null", "" + f_d + s_iAN);
        test("83.0nullsuffix", "" + f_d + s_iAN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + s_iAN + "suffix2");
        test("83.0-54", "" + f_d + f_bM);
        test("83.0-54suffix", "" + f_d + f_bM + "suffix");
        test("prefix83.0suffix1-54suffix2", "prefix" + f_d + "suffix1" + f_bM + "suffix2");
        test("83.0-87.0", "" + f_d + f_fM);
        test("83.0-87.0suffix", "" + f_d + f_fM + "suffix");
        test("prefix83.0suffix1-87.0suffix2", "prefix" + f_d + "suffix1" + f_fM + "suffix2");
        test("83.0null", "" + f_d + s_oAN);
        test("83.0nullsuffix", "" + f_d + s_oAN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + s_oAN + "suffix2");
        test("83.019", "" + f_d + f_str);
        test("83.019suffix", "" + f_d + f_str + "suffix");
        test("prefix83.0suffix119suffix2", "prefix" + f_d + "suffix1" + f_str + "suffix2");
        test("83.0-41", "" + f_d + sf_bM);
        test("83.0-41suffix", "" + f_d + sf_bM + "suffix");
        test("prefix83.0suffix1-41suffix2", "prefix" + f_d + "suffix1" + sf_bM + "suffix2");
        test("83.0null", "" + f_d + sf_IN);
        test("83.0nullsuffix", "" + f_d + sf_IN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + sf_IN + "suffix2");
        test("83.0T", "" + f_d + s_c);
        test("83.0Tsuffix", "" + f_d + s_c + "suffix");
        test("prefix83.0suffix1Tsuffix2", "prefix" + f_d + "suffix1" + s_c + "suffix2");
        test("83.0-42.0", "" + f_d + sf_fM);
        test("83.0-42.0suffix", "" + f_d + sf_fM + "suffix");
        test("prefix83.0suffix1-42.0suffix2", "prefix" + f_d + "suffix1" + sf_fM + "suffix2");
        test("83.025", "" + f_d + s_b);
        test("83.025suffix", "" + f_d + s_b + "suffix");
        test("prefix83.0suffix125suffix2", "prefix" + f_d + "suffix1" + s_b + "suffix2");
        test("83.0null", "" + f_d + f_oN);
        test("83.0nullsuffix", "" + f_d + f_oN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + f_oN + "suffix2");
        test("83.0-1410065408", "" + f_d + s_lM);
        test("83.0-1410065408suffix", "" + f_d + s_lM + "suffix");
        test("prefix83.0suffix1-1410065408suffix2", "prefix" + f_d + "suffix1" + s_lM + "suffix2");
        test("83.08.0", "" + f_d + s_d);
        test("83.08.0suffix", "" + f_d + s_d + "suffix");
        test("prefix83.0suffix18.0suffix2", "prefix" + f_d + "suffix1" + s_d + "suffix2");
        test("83.055.0", "" + f_d + s_f);
        test("83.055.0suffix", "" + f_d + s_f + "suffix");
        test("prefix83.0suffix155.0suffix2", "prefix" + f_d + "suffix1" + s_f + "suffix2");
        test("83.097000000", "" + f_d + s_i);
        test("83.097000000suffix", "" + f_d + s_i + "suffix");
        test("prefix83.0suffix197000000suffix2", "prefix" + f_d + "suffix1" + s_i + "suffix2");
        test("83.0-9900", "" + f_d + f_sM);
        test("83.0-9900suffix", "" + f_d + f_sM + "suffix");
        test("prefix83.0suffix1-9900suffix2", "prefix" + f_d + "suffix1" + f_sM + "suffix2");
        test("83.0935228928", "" + f_d + s_l);
        test("83.0935228928suffix", "" + f_d + s_l + "suffix");
        test("prefix83.0suffix1935228928suffix2", "prefix" + f_d + "suffix1" + s_l + "suffix2");
        test("83.0-8400", "" + f_d + sf_sM);
        test("83.0-8400suffix", "" + f_d + sf_sM + "suffix");
        test("prefix83.0suffix1-8400suffix2", "prefix" + f_d + "suffix1" + sf_sM + "suffix2");
        test("83.0C(82)", "" + f_d + s_o);
        test("83.0C(82)suffix", "" + f_d + s_o + "suffix");
        test("prefix83.0suffix1C(82)suffix2", "prefix" + f_d + "suffix1" + s_o + "suffix2");
        test("83.0null", "" + f_d + sf_oNtS);
        test("83.0nullsuffix", "" + f_d + sf_oNtS + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + sf_oNtS + "suffix2");
        test("83.0true", "" + f_d + s_bl);
        test("83.0truesuffix", "" + f_d + s_bl + "suffix");
        test("prefix83.0suffix1truesuffix2", "prefix" + f_d + "suffix1" + s_bl + "suffix2");
        test("83.03900", "" + f_d + s_s);
        test("83.03900suffix", "" + f_d + s_s + "suffix");
        test("prefix83.0suffix13900suffix2", "prefix" + f_d + "suffix1" + s_s + "suffix2");
        test("83.0null", "" + f_d + sf_oN);
        test("83.0nullsuffix", "" + f_d + sf_oN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + sf_oN + "suffix2");
        test("83.094000000", "" + f_d + f_I);
        test("83.094000000suffix", "" + f_d + f_I + "suffix");
        test("prefix83.0suffix194000000suffix2", "prefix" + f_d + "suffix1" + f_I + "suffix2");
        test("83.0null", "" + f_d + f_IN);
        test("83.0nullsuffix", "" + f_d + f_IN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + f_IN + "suffix2");
        test("83.0true", "" + f_d + sf_bl);
        test("83.0truesuffix", "" + f_d + sf_bl + "suffix");
        test("prefix83.0suffix1truesuffix2", "prefix" + f_d + "suffix1" + sf_bl + "suffix2");
        test("83.05500", "" + f_d + sf_s);
        test("83.05500suffix", "" + f_d + sf_s + "suffix");
        test("prefix83.0suffix15500suffix2", "prefix" + f_d + "suffix1" + sf_s + "suffix2");
        test("83.0-2900", "" + f_d + s_sM);
        test("83.0-2900suffix", "" + f_d + s_sM + "suffix");
        test("prefix83.0suffix1-2900suffix2", "prefix" + f_d + "suffix1" + s_sM + "suffix2");
        test("83.0-194313216", "" + f_d + sf_l);
        test("83.0-194313216suffix", "" + f_d + sf_l + "suffix");
        test("prefix83.0suffix1-194313216suffix2", "prefix" + f_d + "suffix1" + sf_l + "suffix2");
        test("83.012", "" + f_d + s_strU1);
        test("83.012suffix", "" + f_d + s_strU1 + "suffix");
        test("prefix83.0suffix112suffix2", "prefix" + f_d + "suffix1" + s_strU1 + "suffix2");
        test("83.0C(87)", "" + f_d + sf_o);
        test("83.0C(87)suffix", "" + f_d + sf_o + "suffix");
        test("prefix83.0suffix1C(87)suffix2", "prefix" + f_d + "suffix1" + sf_o + "suffix2");
        test("83.091", "" + f_d + s_strU2);
        test("83.091suffix", "" + f_d + s_strU2 + "suffix");
        test("prefix83.0suffix191suffix2", "prefix" + f_d + "suffix1" + s_strU2 + "suffix2");
        test("83.021", "" + f_d + f_strU1);
        test("83.021suffix", "" + f_d + f_strU1 + "suffix");
        test("prefix83.0suffix121suffix2", "prefix" + f_d + "suffix1" + f_strU1 + "suffix2");
        test("83.018", "" + f_d + f_strU2);
        test("83.018suffix", "" + f_d + f_strU2 + "suffix");
        test("prefix83.0suffix118suffix2", "prefix" + f_d + "suffix1" + f_strU2 + "suffix2");
        test("83.0null", "" + f_d + f_iAN);
        test("83.0nullsuffix", "" + f_d + f_iAN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + f_iAN + "suffix2");
        test("83.0null", "" + f_d + s_oN);
        test("83.0nullsuffix", "" + f_d + s_oN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + s_oN + "suffix2");
        test("83.0\u045180", "" + f_d + s_strU);
        test("83.0\u045180suffix", "" + f_d + s_strU + "suffix");
        test("prefix83.0suffix1\u045180suffix2", "prefix" + f_d + "suffix1" + s_strU + "suffix2");
        test("83.0C", "" + f_d + sf_c);
        test("83.0Csuffix", "" + f_d + sf_c + "suffix");
        test("prefix83.0suffix1Csuffix2", "prefix" + f_d + "suffix1" + sf_c + "suffix2");
        test("83.075", "" + f_d + sf_str);
        test("83.075suffix", "" + f_d + sf_str + "suffix");
        test("prefix83.0suffix175suffix2", "prefix" + f_d + "suffix1" + sf_str + "suffix2");
        test("83.0-43", "" + f_d + s_bM);
        test("83.0-43suffix", "" + f_d + s_bM + "suffix");
        test("prefix83.0suffix1-43suffix2", "prefix" + f_d + "suffix1" + s_bM + "suffix2");
        test("83.080", "" + f_d + sf_b);
        test("83.080suffix", "" + f_d + sf_b + "suffix");
        test("prefix83.0suffix180suffix2", "prefix" + f_d + "suffix1" + sf_b + "suffix2");
        test("83.0null", "" + f_d + s_IN);
        test("83.0nullsuffix", "" + f_d + s_IN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + s_IN + "suffix2");
        test("83.0-52.0", "" + f_d + s_fM);
        test("83.0-52.0suffix", "" + f_d + s_fM + "suffix");
        test("prefix83.0suffix1-52.0suffix2", "prefix" + f_d + "suffix1" + s_fM + "suffix2");
        test("83.075000000", "" + f_d + sf_i);
        test("83.075000000suffix", "" + f_d + sf_i + "suffix");
        test("prefix83.0suffix175000000suffix2", "prefix" + f_d + "suffix1" + sf_i + "suffix2");
        test("83.044", "" + f_d + f_b);
        test("83.044suffix", "" + f_d + f_b + "suffix");
        test("prefix83.0suffix144suffix2", "prefix" + f_d + "suffix1" + f_b + "suffix2");
        test("83.0-1705032704", "" + f_d + sf_lM);
        test("83.0-1705032704suffix", "" + f_d + sf_lM + "suffix");
        test("prefix83.0suffix1-1705032704suffix2", "prefix" + f_d + "suffix1" + sf_lM + "suffix2");
        test("83.0null", "" + f_d + f_oAN);
        test("83.0nullsuffix", "" + f_d + f_oAN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + f_oAN + "suffix2");
        test("83.083.0", "" + f_d + f_d);
        test("83.083.0suffix", "" + f_d + f_d + "suffix");
        test("prefix83.0suffix183.0suffix2", "prefix" + f_d + "suffix1" + f_d + "suffix2");
        test("83.0I", "" + f_d + f_c);
        test("83.0Isuffix", "" + f_d + f_c + "suffix");
        test("prefix83.0suffix1Isuffix2", "prefix" + f_d + "suffix1" + f_c + "suffix2");
        test("83.094.0", "" + f_d + f_f);
        test("83.094.0suffix", "" + f_d + f_f + "suffix");
        test("prefix83.0suffix194.0suffix2", "prefix" + f_d + "suffix1" + f_f + "suffix2");
        test("83.012.0", "" + f_d + sf_d);
        test("83.012.0suffix", "" + f_d + sf_d + "suffix");
        test("prefix83.0suffix112.0suffix2", "prefix" + f_d + "suffix1" + sf_d + "suffix2");
        test("83.0-99.0", "" + f_d + f_dM);
        test("83.0-99.0suffix", "" + f_d + f_dM + "suffix");
        test("prefix83.0suffix1-99.0suffix2", "prefix" + f_d + "suffix1" + f_dM + "suffix2");
        test("83.017.0", "" + f_d + sf_f);
        test("83.017.0suffix", "" + f_d + sf_f + "suffix");
        test("prefix83.0suffix117.0suffix2", "prefix" + f_d + "suffix1" + sf_f + "suffix2");
        test("83.0-84.0", "" + f_d + sf_dM);
        test("83.0-84.0suffix", "" + f_d + sf_dM + "suffix");
        test("prefix83.0suffix1-84.0suffix2", "prefix" + f_d + "suffix1" + sf_dM + "suffix2");
        test("83.058000000", "" + f_d + f_i);
        test("83.058000000suffix", "" + f_d + f_i + "suffix");
        test("prefix83.0suffix158000000suffix2", "prefix" + f_d + "suffix1" + f_i + "suffix2");
        test("83.0-55000000", "" + f_d + f_iM);
        test("83.0-55000000suffix", "" + f_d + f_iM + "suffix");
        test("prefix83.0suffix1-55000000suffix2", "prefix" + f_d + "suffix1" + f_iM + "suffix2");
        test("83.01460392448", "" + f_d + f_l);
        test("83.01460392448suffix", "" + f_d + f_l + "suffix");
        test("prefix83.0suffix11460392448suffix2", "prefix" + f_d + "suffix1" + f_l + "suffix2");
        test("83.0C(70)", "" + f_d + f_o);
        test("83.0C(70)suffix", "" + f_d + f_o + "suffix");
        test("prefix83.0suffix1C(70)suffix2", "prefix" + f_d + "suffix1" + f_o + "suffix2");
        test("83.0\u04511", "" + f_d + sf_strU);
        test("83.0\u04511suffix", "" + f_d + sf_strU + "suffix");
        test("prefix83.0suffix1\u04511suffix2", "prefix" + f_d + "suffix1" + sf_strU + "suffix2");
        test("83.08000", "" + f_d + f_s);
        test("83.08000suffix", "" + f_d + f_s + "suffix");
        test("prefix83.0suffix18000suffix2", "prefix" + f_d + "suffix1" + f_s + "suffix2");
        test("83.018", "" + f_d + s_str);
        test("83.018suffix", "" + f_d + s_str + "suffix");
        test("prefix83.0suffix118suffix2", "prefix" + f_d + "suffix1" + s_str + "suffix2");
        test("83.0-1000000", "" + f_d + s_iM);
        test("83.0-1000000suffix", "" + f_d + s_iM + "suffix");
        test("prefix83.0suffix1-1000000suffix2", "prefix" + f_d + "suffix1" + s_iM + "suffix2");
        test("83.01000000", "" + f_d + sf_I);
        test("83.01000000suffix", "" + f_d + sf_I + "suffix");
        test("prefix83.0suffix11000000suffix2", "prefix" + f_d + "suffix1" + sf_I + "suffix2");
        test("83.0null", "" + f_d + f_oNtS);
        test("83.0nullsuffix", "" + f_d + f_oNtS + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + f_oNtS + "suffix2");
        test("83.0false", "" + f_d + f_bl);
        test("83.0falsesuffix", "" + f_d + f_bl + "suffix");
        test("prefix83.0suffix1falsesuffix2", "prefix" + f_d + "suffix1" + f_bl + "suffix2");
        test("83.0null", "" + f_d + sf_iAN);
        test("83.0nullsuffix", "" + f_d + sf_iAN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + sf_iAN + "suffix2");
        test("83.0-2000000", "" + f_d + sf_iM);
        test("83.0-2000000suffix", "" + f_d + sf_iM + "suffix");
        test("prefix83.0suffix1-2000000suffix2", "prefix" + f_d + "suffix1" + sf_iM + "suffix2");
        test("83.0-820130816", "" + f_d + f_lM);
        test("83.0-820130816suffix", "" + f_d + f_lM + "suffix");
        test("prefix83.0suffix1-820130816suffix2", "prefix" + f_d + "suffix1" + f_lM + "suffix2");
        test("83.0null", "" + f_d + sf_oAN);
        test("83.0nullsuffix", "" + f_d + sf_oAN + "suffix");
        test("prefix83.0suffix1nullsuffix2", "prefix" + f_d + "suffix1" + sf_oAN + "suffix2");
        test("83.025000000", "" + f_d + s_I);
        test("83.025000000suffix", "" + f_d + s_I + "suffix");
        test("prefix83.0suffix125000000suffix2", "prefix" + f_d + "suffix1" + s_I + "suffix2");
        test("I-96.0", "" + f_c + s_dM);
        test("I-96.0suffix", "" + f_c + s_dM + "suffix");
        test("prefixIsuffix1-96.0suffix2", "prefix" + f_c + "suffix1" + s_dM + "suffix2");
        test("Inull", "" + f_c + s_oNtS);
        test("Inullsuffix", "" + f_c + s_oNtS + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + s_oNtS + "suffix2");
        test("I\u045176", "" + f_c + f_strU);
        test("I\u045176suffix", "" + f_c + f_strU + "suffix");
        test("prefixIsuffix1\u045176suffix2", "prefix" + f_c + "suffix1" + f_strU + "suffix2");
        test("I92", "" + f_c + sf_strU2);
        test("I92suffix", "" + f_c + sf_strU2 + "suffix");
        test("prefixIsuffix192suffix2", "prefix" + f_c + "suffix1" + sf_strU2 + "suffix2");
        test("I51", "" + f_c + sf_strU1);
        test("I51suffix", "" + f_c + sf_strU1 + "suffix");
        test("prefixIsuffix151suffix2", "prefix" + f_c + "suffix1" + sf_strU1 + "suffix2");
        test("Inull", "" + f_c + s_iAN);
        test("Inullsuffix", "" + f_c + s_iAN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + s_iAN + "suffix2");
        test("I-54", "" + f_c + f_bM);
        test("I-54suffix", "" + f_c + f_bM + "suffix");
        test("prefixIsuffix1-54suffix2", "prefix" + f_c + "suffix1" + f_bM + "suffix2");
        test("I-87.0", "" + f_c + f_fM);
        test("I-87.0suffix", "" + f_c + f_fM + "suffix");
        test("prefixIsuffix1-87.0suffix2", "prefix" + f_c + "suffix1" + f_fM + "suffix2");
        test("Inull", "" + f_c + s_oAN);
        test("Inullsuffix", "" + f_c + s_oAN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + s_oAN + "suffix2");
        test("I19", "" + f_c + f_str);
        test("I19suffix", "" + f_c + f_str + "suffix");
        test("prefixIsuffix119suffix2", "prefix" + f_c + "suffix1" + f_str + "suffix2");
        test("I-41", "" + f_c + sf_bM);
        test("I-41suffix", "" + f_c + sf_bM + "suffix");
        test("prefixIsuffix1-41suffix2", "prefix" + f_c + "suffix1" + sf_bM + "suffix2");
        test("Inull", "" + f_c + sf_IN);
        test("Inullsuffix", "" + f_c + sf_IN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + sf_IN + "suffix2");
        test("IT", "" + f_c + s_c);
        test("ITsuffix", "" + f_c + s_c + "suffix");
        test("prefixIsuffix1Tsuffix2", "prefix" + f_c + "suffix1" + s_c + "suffix2");
        test("I-42.0", "" + f_c + sf_fM);
        test("I-42.0suffix", "" + f_c + sf_fM + "suffix");
        test("prefixIsuffix1-42.0suffix2", "prefix" + f_c + "suffix1" + sf_fM + "suffix2");
        test("I25", "" + f_c + s_b);
        test("I25suffix", "" + f_c + s_b + "suffix");
        test("prefixIsuffix125suffix2", "prefix" + f_c + "suffix1" + s_b + "suffix2");
        test("Inull", "" + f_c + f_oN);
        test("Inullsuffix", "" + f_c + f_oN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + f_oN + "suffix2");
        test("I-1410065408", "" + f_c + s_lM);
        test("I-1410065408suffix", "" + f_c + s_lM + "suffix");
        test("prefixIsuffix1-1410065408suffix2", "prefix" + f_c + "suffix1" + s_lM + "suffix2");
        test("I8.0", "" + f_c + s_d);
        test("I8.0suffix", "" + f_c + s_d + "suffix");
        test("prefixIsuffix18.0suffix2", "prefix" + f_c + "suffix1" + s_d + "suffix2");
        test("I55.0", "" + f_c + s_f);
        test("I55.0suffix", "" + f_c + s_f + "suffix");
        test("prefixIsuffix155.0suffix2", "prefix" + f_c + "suffix1" + s_f + "suffix2");
        test("I97000000", "" + f_c + s_i);
        test("I97000000suffix", "" + f_c + s_i + "suffix");
        test("prefixIsuffix197000000suffix2", "prefix" + f_c + "suffix1" + s_i + "suffix2");
        test("I-9900", "" + f_c + f_sM);
        test("I-9900suffix", "" + f_c + f_sM + "suffix");
        test("prefixIsuffix1-9900suffix2", "prefix" + f_c + "suffix1" + f_sM + "suffix2");
        test("I935228928", "" + f_c + s_l);
        test("I935228928suffix", "" + f_c + s_l + "suffix");
        test("prefixIsuffix1935228928suffix2", "prefix" + f_c + "suffix1" + s_l + "suffix2");
        test("I-8400", "" + f_c + sf_sM);
        test("I-8400suffix", "" + f_c + sf_sM + "suffix");
        test("prefixIsuffix1-8400suffix2", "prefix" + f_c + "suffix1" + sf_sM + "suffix2");
        test("IC(82)", "" + f_c + s_o);
        test("IC(82)suffix", "" + f_c + s_o + "suffix");
        test("prefixIsuffix1C(82)suffix2", "prefix" + f_c + "suffix1" + s_o + "suffix2");
        test("Inull", "" + f_c + sf_oNtS);
        test("Inullsuffix", "" + f_c + sf_oNtS + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + sf_oNtS + "suffix2");
        test("Itrue", "" + f_c + s_bl);
        test("Itruesuffix", "" + f_c + s_bl + "suffix");
        test("prefixIsuffix1truesuffix2", "prefix" + f_c + "suffix1" + s_bl + "suffix2");
        test("I3900", "" + f_c + s_s);
        test("I3900suffix", "" + f_c + s_s + "suffix");
        test("prefixIsuffix13900suffix2", "prefix" + f_c + "suffix1" + s_s + "suffix2");
        test("Inull", "" + f_c + sf_oN);
        test("Inullsuffix", "" + f_c + sf_oN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + sf_oN + "suffix2");
        test("I94000000", "" + f_c + f_I);
        test("I94000000suffix", "" + f_c + f_I + "suffix");
        test("prefixIsuffix194000000suffix2", "prefix" + f_c + "suffix1" + f_I + "suffix2");
        test("Inull", "" + f_c + f_IN);
        test("Inullsuffix", "" + f_c + f_IN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + f_IN + "suffix2");
        test("Itrue", "" + f_c + sf_bl);
        test("Itruesuffix", "" + f_c + sf_bl + "suffix");
        test("prefixIsuffix1truesuffix2", "prefix" + f_c + "suffix1" + sf_bl + "suffix2");
        test("I5500", "" + f_c + sf_s);
        test("I5500suffix", "" + f_c + sf_s + "suffix");
        test("prefixIsuffix15500suffix2", "prefix" + f_c + "suffix1" + sf_s + "suffix2");
        test("I-2900", "" + f_c + s_sM);
        test("I-2900suffix", "" + f_c + s_sM + "suffix");
        test("prefixIsuffix1-2900suffix2", "prefix" + f_c + "suffix1" + s_sM + "suffix2");
        test("I-194313216", "" + f_c + sf_l);
        test("I-194313216suffix", "" + f_c + sf_l + "suffix");
        test("prefixIsuffix1-194313216suffix2", "prefix" + f_c + "suffix1" + sf_l + "suffix2");
        test("I12", "" + f_c + s_strU1);
        test("I12suffix", "" + f_c + s_strU1 + "suffix");
        test("prefixIsuffix112suffix2", "prefix" + f_c + "suffix1" + s_strU1 + "suffix2");
        test("IC(87)", "" + f_c + sf_o);
        test("IC(87)suffix", "" + f_c + sf_o + "suffix");
        test("prefixIsuffix1C(87)suffix2", "prefix" + f_c + "suffix1" + sf_o + "suffix2");
        test("I91", "" + f_c + s_strU2);
        test("I91suffix", "" + f_c + s_strU2 + "suffix");
        test("prefixIsuffix191suffix2", "prefix" + f_c + "suffix1" + s_strU2 + "suffix2");
        test("I21", "" + f_c + f_strU1);
        test("I21suffix", "" + f_c + f_strU1 + "suffix");
        test("prefixIsuffix121suffix2", "prefix" + f_c + "suffix1" + f_strU1 + "suffix2");
        test("I18", "" + f_c + f_strU2);
        test("I18suffix", "" + f_c + f_strU2 + "suffix");
        test("prefixIsuffix118suffix2", "prefix" + f_c + "suffix1" + f_strU2 + "suffix2");
        test("Inull", "" + f_c + f_iAN);
        test("Inullsuffix", "" + f_c + f_iAN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + f_iAN + "suffix2");
        test("Inull", "" + f_c + s_oN);
        test("Inullsuffix", "" + f_c + s_oN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + s_oN + "suffix2");
        test("I\u045180", "" + f_c + s_strU);
        test("I\u045180suffix", "" + f_c + s_strU + "suffix");
        test("prefixIsuffix1\u045180suffix2", "prefix" + f_c + "suffix1" + s_strU + "suffix2");
        test("IC", "" + f_c + sf_c);
        test("ICsuffix", "" + f_c + sf_c + "suffix");
        test("prefixIsuffix1Csuffix2", "prefix" + f_c + "suffix1" + sf_c + "suffix2");
        test("I75", "" + f_c + sf_str);
        test("I75suffix", "" + f_c + sf_str + "suffix");
        test("prefixIsuffix175suffix2", "prefix" + f_c + "suffix1" + sf_str + "suffix2");
        test("I-43", "" + f_c + s_bM);
        test("I-43suffix", "" + f_c + s_bM + "suffix");
        test("prefixIsuffix1-43suffix2", "prefix" + f_c + "suffix1" + s_bM + "suffix2");
        test("I80", "" + f_c + sf_b);
        test("I80suffix", "" + f_c + sf_b + "suffix");
        test("prefixIsuffix180suffix2", "prefix" + f_c + "suffix1" + sf_b + "suffix2");
        test("Inull", "" + f_c + s_IN);
        test("Inullsuffix", "" + f_c + s_IN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + s_IN + "suffix2");
        test("I-52.0", "" + f_c + s_fM);
        test("I-52.0suffix", "" + f_c + s_fM + "suffix");
        test("prefixIsuffix1-52.0suffix2", "prefix" + f_c + "suffix1" + s_fM + "suffix2");
        test("I75000000", "" + f_c + sf_i);
        test("I75000000suffix", "" + f_c + sf_i + "suffix");
        test("prefixIsuffix175000000suffix2", "prefix" + f_c + "suffix1" + sf_i + "suffix2");
        test("I44", "" + f_c + f_b);
        test("I44suffix", "" + f_c + f_b + "suffix");
        test("prefixIsuffix144suffix2", "prefix" + f_c + "suffix1" + f_b + "suffix2");
        test("I-1705032704", "" + f_c + sf_lM);
        test("I-1705032704suffix", "" + f_c + sf_lM + "suffix");
        test("prefixIsuffix1-1705032704suffix2", "prefix" + f_c + "suffix1" + sf_lM + "suffix2");
        test("Inull", "" + f_c + f_oAN);
        test("Inullsuffix", "" + f_c + f_oAN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + f_oAN + "suffix2");
        test("I83.0", "" + f_c + f_d);
        test("I83.0suffix", "" + f_c + f_d + "suffix");
        test("prefixIsuffix183.0suffix2", "prefix" + f_c + "suffix1" + f_d + "suffix2");
        test("II", "" + f_c + f_c);
        test("IIsuffix", "" + f_c + f_c + "suffix");
        test("prefixIsuffix1Isuffix2", "prefix" + f_c + "suffix1" + f_c + "suffix2");
        test("I94.0", "" + f_c + f_f);
        test("I94.0suffix", "" + f_c + f_f + "suffix");
        test("prefixIsuffix194.0suffix2", "prefix" + f_c + "suffix1" + f_f + "suffix2");
        test("I12.0", "" + f_c + sf_d);
        test("I12.0suffix", "" + f_c + sf_d + "suffix");
        test("prefixIsuffix112.0suffix2", "prefix" + f_c + "suffix1" + sf_d + "suffix2");
        test("I-99.0", "" + f_c + f_dM);
        test("I-99.0suffix", "" + f_c + f_dM + "suffix");
        test("prefixIsuffix1-99.0suffix2", "prefix" + f_c + "suffix1" + f_dM + "suffix2");
        test("I17.0", "" + f_c + sf_f);
        test("I17.0suffix", "" + f_c + sf_f + "suffix");
        test("prefixIsuffix117.0suffix2", "prefix" + f_c + "suffix1" + sf_f + "suffix2");
        test("I-84.0", "" + f_c + sf_dM);
        test("I-84.0suffix", "" + f_c + sf_dM + "suffix");
        test("prefixIsuffix1-84.0suffix2", "prefix" + f_c + "suffix1" + sf_dM + "suffix2");
        test("I58000000", "" + f_c + f_i);
        test("I58000000suffix", "" + f_c + f_i + "suffix");
        test("prefixIsuffix158000000suffix2", "prefix" + f_c + "suffix1" + f_i + "suffix2");
        test("I-55000000", "" + f_c + f_iM);
        test("I-55000000suffix", "" + f_c + f_iM + "suffix");
        test("prefixIsuffix1-55000000suffix2", "prefix" + f_c + "suffix1" + f_iM + "suffix2");
        test("I1460392448", "" + f_c + f_l);
        test("I1460392448suffix", "" + f_c + f_l + "suffix");
        test("prefixIsuffix11460392448suffix2", "prefix" + f_c + "suffix1" + f_l + "suffix2");
        test("IC(70)", "" + f_c + f_o);
        test("IC(70)suffix", "" + f_c + f_o + "suffix");
        test("prefixIsuffix1C(70)suffix2", "prefix" + f_c + "suffix1" + f_o + "suffix2");
        test("I\u04511", "" + f_c + sf_strU);
        test("I\u04511suffix", "" + f_c + sf_strU + "suffix");
        test("prefixIsuffix1\u04511suffix2", "prefix" + f_c + "suffix1" + sf_strU + "suffix2");
        test("I8000", "" + f_c + f_s);
        test("I8000suffix", "" + f_c + f_s + "suffix");
        test("prefixIsuffix18000suffix2", "prefix" + f_c + "suffix1" + f_s + "suffix2");
        test("I18", "" + f_c + s_str);
        test("I18suffix", "" + f_c + s_str + "suffix");
        test("prefixIsuffix118suffix2", "prefix" + f_c + "suffix1" + s_str + "suffix2");
        test("I-1000000", "" + f_c + s_iM);
        test("I-1000000suffix", "" + f_c + s_iM + "suffix");
        test("prefixIsuffix1-1000000suffix2", "prefix" + f_c + "suffix1" + s_iM + "suffix2");
        test("I1000000", "" + f_c + sf_I);
        test("I1000000suffix", "" + f_c + sf_I + "suffix");
        test("prefixIsuffix11000000suffix2", "prefix" + f_c + "suffix1" + sf_I + "suffix2");
        test("Inull", "" + f_c + f_oNtS);
        test("Inullsuffix", "" + f_c + f_oNtS + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + f_oNtS + "suffix2");
        test("Ifalse", "" + f_c + f_bl);
        test("Ifalsesuffix", "" + f_c + f_bl + "suffix");
        test("prefixIsuffix1falsesuffix2", "prefix" + f_c + "suffix1" + f_bl + "suffix2");
        test("Inull", "" + f_c + sf_iAN);
        test("Inullsuffix", "" + f_c + sf_iAN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + sf_iAN + "suffix2");
        test("I-2000000", "" + f_c + sf_iM);
        test("I-2000000suffix", "" + f_c + sf_iM + "suffix");
        test("prefixIsuffix1-2000000suffix2", "prefix" + f_c + "suffix1" + sf_iM + "suffix2");
        test("I-820130816", "" + f_c + f_lM);
        test("I-820130816suffix", "" + f_c + f_lM + "suffix");
        test("prefixIsuffix1-820130816suffix2", "prefix" + f_c + "suffix1" + f_lM + "suffix2");
        test("Inull", "" + f_c + sf_oAN);
        test("Inullsuffix", "" + f_c + sf_oAN + "suffix");
        test("prefixIsuffix1nullsuffix2", "prefix" + f_c + "suffix1" + sf_oAN + "suffix2");
        test("I25000000", "" + f_c + s_I);
        test("I25000000suffix", "" + f_c + s_I + "suffix");
        test("prefixIsuffix125000000suffix2", "prefix" + f_c + "suffix1" + s_I + "suffix2");
        test("94.0-96.0", "" + f_f + s_dM);
        test("94.0-96.0suffix", "" + f_f + s_dM + "suffix");
        test("prefix94.0suffix1-96.0suffix2", "prefix" + f_f + "suffix1" + s_dM + "suffix2");
        test("94.0null", "" + f_f + s_oNtS);
        test("94.0nullsuffix", "" + f_f + s_oNtS + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + s_oNtS + "suffix2");
        test("94.0\u045176", "" + f_f + f_strU);
        test("94.0\u045176suffix", "" + f_f + f_strU + "suffix");
        test("prefix94.0suffix1\u045176suffix2", "prefix" + f_f + "suffix1" + f_strU + "suffix2");
        test("94.092", "" + f_f + sf_strU2);
        test("94.092suffix", "" + f_f + sf_strU2 + "suffix");
        test("prefix94.0suffix192suffix2", "prefix" + f_f + "suffix1" + sf_strU2 + "suffix2");
        test("94.051", "" + f_f + sf_strU1);
        test("94.051suffix", "" + f_f + sf_strU1 + "suffix");
        test("prefix94.0suffix151suffix2", "prefix" + f_f + "suffix1" + sf_strU1 + "suffix2");
        test("94.0null", "" + f_f + s_iAN);
        test("94.0nullsuffix", "" + f_f + s_iAN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + s_iAN + "suffix2");
        test("94.0-54", "" + f_f + f_bM);
        test("94.0-54suffix", "" + f_f + f_bM + "suffix");
        test("prefix94.0suffix1-54suffix2", "prefix" + f_f + "suffix1" + f_bM + "suffix2");
        test("94.0-87.0", "" + f_f + f_fM);
        test("94.0-87.0suffix", "" + f_f + f_fM + "suffix");
        test("prefix94.0suffix1-87.0suffix2", "prefix" + f_f + "suffix1" + f_fM + "suffix2");
        test("94.0null", "" + f_f + s_oAN);
        test("94.0nullsuffix", "" + f_f + s_oAN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + s_oAN + "suffix2");
        test("94.019", "" + f_f + f_str);
        test("94.019suffix", "" + f_f + f_str + "suffix");
        test("prefix94.0suffix119suffix2", "prefix" + f_f + "suffix1" + f_str + "suffix2");
        test("94.0-41", "" + f_f + sf_bM);
        test("94.0-41suffix", "" + f_f + sf_bM + "suffix");
        test("prefix94.0suffix1-41suffix2", "prefix" + f_f + "suffix1" + sf_bM + "suffix2");
        test("94.0null", "" + f_f + sf_IN);
        test("94.0nullsuffix", "" + f_f + sf_IN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + sf_IN + "suffix2");
        test("94.0T", "" + f_f + s_c);
        test("94.0Tsuffix", "" + f_f + s_c + "suffix");
        test("prefix94.0suffix1Tsuffix2", "prefix" + f_f + "suffix1" + s_c + "suffix2");
        test("94.0-42.0", "" + f_f + sf_fM);
        test("94.0-42.0suffix", "" + f_f + sf_fM + "suffix");
        test("prefix94.0suffix1-42.0suffix2", "prefix" + f_f + "suffix1" + sf_fM + "suffix2");
        test("94.025", "" + f_f + s_b);
        test("94.025suffix", "" + f_f + s_b + "suffix");
        test("prefix94.0suffix125suffix2", "prefix" + f_f + "suffix1" + s_b + "suffix2");
        test("94.0null", "" + f_f + f_oN);
        test("94.0nullsuffix", "" + f_f + f_oN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + f_oN + "suffix2");
        test("94.0-1410065408", "" + f_f + s_lM);
        test("94.0-1410065408suffix", "" + f_f + s_lM + "suffix");
        test("prefix94.0suffix1-1410065408suffix2", "prefix" + f_f + "suffix1" + s_lM + "suffix2");
        test("94.08.0", "" + f_f + s_d);
        test("94.08.0suffix", "" + f_f + s_d + "suffix");
        test("prefix94.0suffix18.0suffix2", "prefix" + f_f + "suffix1" + s_d + "suffix2");
        test("94.055.0", "" + f_f + s_f);
        test("94.055.0suffix", "" + f_f + s_f + "suffix");
        test("prefix94.0suffix155.0suffix2", "prefix" + f_f + "suffix1" + s_f + "suffix2");
        test("94.097000000", "" + f_f + s_i);
        test("94.097000000suffix", "" + f_f + s_i + "suffix");
        test("prefix94.0suffix197000000suffix2", "prefix" + f_f + "suffix1" + s_i + "suffix2");
        test("94.0-9900", "" + f_f + f_sM);
        test("94.0-9900suffix", "" + f_f + f_sM + "suffix");
        test("prefix94.0suffix1-9900suffix2", "prefix" + f_f + "suffix1" + f_sM + "suffix2");
        test("94.0935228928", "" + f_f + s_l);
        test("94.0935228928suffix", "" + f_f + s_l + "suffix");
        test("prefix94.0suffix1935228928suffix2", "prefix" + f_f + "suffix1" + s_l + "suffix2");
        test("94.0-8400", "" + f_f + sf_sM);
        test("94.0-8400suffix", "" + f_f + sf_sM + "suffix");
        test("prefix94.0suffix1-8400suffix2", "prefix" + f_f + "suffix1" + sf_sM + "suffix2");
        test("94.0C(82)", "" + f_f + s_o);
        test("94.0C(82)suffix", "" + f_f + s_o + "suffix");
        test("prefix94.0suffix1C(82)suffix2", "prefix" + f_f + "suffix1" + s_o + "suffix2");
        test("94.0null", "" + f_f + sf_oNtS);
        test("94.0nullsuffix", "" + f_f + sf_oNtS + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + sf_oNtS + "suffix2");
        test("94.0true", "" + f_f + s_bl);
        test("94.0truesuffix", "" + f_f + s_bl + "suffix");
        test("prefix94.0suffix1truesuffix2", "prefix" + f_f + "suffix1" + s_bl + "suffix2");
        test("94.03900", "" + f_f + s_s);
        test("94.03900suffix", "" + f_f + s_s + "suffix");
        test("prefix94.0suffix13900suffix2", "prefix" + f_f + "suffix1" + s_s + "suffix2");
        test("94.0null", "" + f_f + sf_oN);
        test("94.0nullsuffix", "" + f_f + sf_oN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + sf_oN + "suffix2");
        test("94.094000000", "" + f_f + f_I);
        test("94.094000000suffix", "" + f_f + f_I + "suffix");
        test("prefix94.0suffix194000000suffix2", "prefix" + f_f + "suffix1" + f_I + "suffix2");
        test("94.0null", "" + f_f + f_IN);
        test("94.0nullsuffix", "" + f_f + f_IN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + f_IN + "suffix2");
        test("94.0true", "" + f_f + sf_bl);
        test("94.0truesuffix", "" + f_f + sf_bl + "suffix");
        test("prefix94.0suffix1truesuffix2", "prefix" + f_f + "suffix1" + sf_bl + "suffix2");
        test("94.05500", "" + f_f + sf_s);
        test("94.05500suffix", "" + f_f + sf_s + "suffix");
        test("prefix94.0suffix15500suffix2", "prefix" + f_f + "suffix1" + sf_s + "suffix2");
        test("94.0-2900", "" + f_f + s_sM);
        test("94.0-2900suffix", "" + f_f + s_sM + "suffix");
        test("prefix94.0suffix1-2900suffix2", "prefix" + f_f + "suffix1" + s_sM + "suffix2");
        test("94.0-194313216", "" + f_f + sf_l);
        test("94.0-194313216suffix", "" + f_f + sf_l + "suffix");
        test("prefix94.0suffix1-194313216suffix2", "prefix" + f_f + "suffix1" + sf_l + "suffix2");
        test("94.012", "" + f_f + s_strU1);
        test("94.012suffix", "" + f_f + s_strU1 + "suffix");
        test("prefix94.0suffix112suffix2", "prefix" + f_f + "suffix1" + s_strU1 + "suffix2");
        test("94.0C(87)", "" + f_f + sf_o);
        test("94.0C(87)suffix", "" + f_f + sf_o + "suffix");
        test("prefix94.0suffix1C(87)suffix2", "prefix" + f_f + "suffix1" + sf_o + "suffix2");
        test("94.091", "" + f_f + s_strU2);
        test("94.091suffix", "" + f_f + s_strU2 + "suffix");
        test("prefix94.0suffix191suffix2", "prefix" + f_f + "suffix1" + s_strU2 + "suffix2");
        test("94.021", "" + f_f + f_strU1);
        test("94.021suffix", "" + f_f + f_strU1 + "suffix");
        test("prefix94.0suffix121suffix2", "prefix" + f_f + "suffix1" + f_strU1 + "suffix2");
        test("94.018", "" + f_f + f_strU2);
        test("94.018suffix", "" + f_f + f_strU2 + "suffix");
        test("prefix94.0suffix118suffix2", "prefix" + f_f + "suffix1" + f_strU2 + "suffix2");
        test("94.0null", "" + f_f + f_iAN);
        test("94.0nullsuffix", "" + f_f + f_iAN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + f_iAN + "suffix2");
        test("94.0null", "" + f_f + s_oN);
        test("94.0nullsuffix", "" + f_f + s_oN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + s_oN + "suffix2");
        test("94.0\u045180", "" + f_f + s_strU);
        test("94.0\u045180suffix", "" + f_f + s_strU + "suffix");
        test("prefix94.0suffix1\u045180suffix2", "prefix" + f_f + "suffix1" + s_strU + "suffix2");
        test("94.0C", "" + f_f + sf_c);
        test("94.0Csuffix", "" + f_f + sf_c + "suffix");
        test("prefix94.0suffix1Csuffix2", "prefix" + f_f + "suffix1" + sf_c + "suffix2");
        test("94.075", "" + f_f + sf_str);
        test("94.075suffix", "" + f_f + sf_str + "suffix");
        test("prefix94.0suffix175suffix2", "prefix" + f_f + "suffix1" + sf_str + "suffix2");
        test("94.0-43", "" + f_f + s_bM);
        test("94.0-43suffix", "" + f_f + s_bM + "suffix");
        test("prefix94.0suffix1-43suffix2", "prefix" + f_f + "suffix1" + s_bM + "suffix2");
        test("94.080", "" + f_f + sf_b);
        test("94.080suffix", "" + f_f + sf_b + "suffix");
        test("prefix94.0suffix180suffix2", "prefix" + f_f + "suffix1" + sf_b + "suffix2");
        test("94.0null", "" + f_f + s_IN);
        test("94.0nullsuffix", "" + f_f + s_IN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + s_IN + "suffix2");
        test("94.0-52.0", "" + f_f + s_fM);
        test("94.0-52.0suffix", "" + f_f + s_fM + "suffix");
        test("prefix94.0suffix1-52.0suffix2", "prefix" + f_f + "suffix1" + s_fM + "suffix2");
        test("94.075000000", "" + f_f + sf_i);
        test("94.075000000suffix", "" + f_f + sf_i + "suffix");
        test("prefix94.0suffix175000000suffix2", "prefix" + f_f + "suffix1" + sf_i + "suffix2");
        test("94.044", "" + f_f + f_b);
        test("94.044suffix", "" + f_f + f_b + "suffix");
        test("prefix94.0suffix144suffix2", "prefix" + f_f + "suffix1" + f_b + "suffix2");
        test("94.0-1705032704", "" + f_f + sf_lM);
        test("94.0-1705032704suffix", "" + f_f + sf_lM + "suffix");
        test("prefix94.0suffix1-1705032704suffix2", "prefix" + f_f + "suffix1" + sf_lM + "suffix2");
        test("94.0null", "" + f_f + f_oAN);
        test("94.0nullsuffix", "" + f_f + f_oAN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + f_oAN + "suffix2");
        test("94.083.0", "" + f_f + f_d);
        test("94.083.0suffix", "" + f_f + f_d + "suffix");
        test("prefix94.0suffix183.0suffix2", "prefix" + f_f + "suffix1" + f_d + "suffix2");
        test("94.0I", "" + f_f + f_c);
        test("94.0Isuffix", "" + f_f + f_c + "suffix");
        test("prefix94.0suffix1Isuffix2", "prefix" + f_f + "suffix1" + f_c + "suffix2");
        test("94.094.0", "" + f_f + f_f);
        test("94.094.0suffix", "" + f_f + f_f + "suffix");
        test("prefix94.0suffix194.0suffix2", "prefix" + f_f + "suffix1" + f_f + "suffix2");
        test("94.012.0", "" + f_f + sf_d);
        test("94.012.0suffix", "" + f_f + sf_d + "suffix");
        test("prefix94.0suffix112.0suffix2", "prefix" + f_f + "suffix1" + sf_d + "suffix2");
        test("94.0-99.0", "" + f_f + f_dM);
        test("94.0-99.0suffix", "" + f_f + f_dM + "suffix");
        test("prefix94.0suffix1-99.0suffix2", "prefix" + f_f + "suffix1" + f_dM + "suffix2");
        test("94.017.0", "" + f_f + sf_f);
        test("94.017.0suffix", "" + f_f + sf_f + "suffix");
        test("prefix94.0suffix117.0suffix2", "prefix" + f_f + "suffix1" + sf_f + "suffix2");
        test("94.0-84.0", "" + f_f + sf_dM);
        test("94.0-84.0suffix", "" + f_f + sf_dM + "suffix");
        test("prefix94.0suffix1-84.0suffix2", "prefix" + f_f + "suffix1" + sf_dM + "suffix2");
        test("94.058000000", "" + f_f + f_i);
        test("94.058000000suffix", "" + f_f + f_i + "suffix");
        test("prefix94.0suffix158000000suffix2", "prefix" + f_f + "suffix1" + f_i + "suffix2");
        test("94.0-55000000", "" + f_f + f_iM);
        test("94.0-55000000suffix", "" + f_f + f_iM + "suffix");
        test("prefix94.0suffix1-55000000suffix2", "prefix" + f_f + "suffix1" + f_iM + "suffix2");
        test("94.01460392448", "" + f_f + f_l);
        test("94.01460392448suffix", "" + f_f + f_l + "suffix");
        test("prefix94.0suffix11460392448suffix2", "prefix" + f_f + "suffix1" + f_l + "suffix2");
        test("94.0C(70)", "" + f_f + f_o);
        test("94.0C(70)suffix", "" + f_f + f_o + "suffix");
        test("prefix94.0suffix1C(70)suffix2", "prefix" + f_f + "suffix1" + f_o + "suffix2");
        test("94.0\u04511", "" + f_f + sf_strU);
        test("94.0\u04511suffix", "" + f_f + sf_strU + "suffix");
        test("prefix94.0suffix1\u04511suffix2", "prefix" + f_f + "suffix1" + sf_strU + "suffix2");
        test("94.08000", "" + f_f + f_s);
        test("94.08000suffix", "" + f_f + f_s + "suffix");
        test("prefix94.0suffix18000suffix2", "prefix" + f_f + "suffix1" + f_s + "suffix2");
        test("94.018", "" + f_f + s_str);
        test("94.018suffix", "" + f_f + s_str + "suffix");
        test("prefix94.0suffix118suffix2", "prefix" + f_f + "suffix1" + s_str + "suffix2");
        test("94.0-1000000", "" + f_f + s_iM);
        test("94.0-1000000suffix", "" + f_f + s_iM + "suffix");
        test("prefix94.0suffix1-1000000suffix2", "prefix" + f_f + "suffix1" + s_iM + "suffix2");
        test("94.01000000", "" + f_f + sf_I);
        test("94.01000000suffix", "" + f_f + sf_I + "suffix");
        test("prefix94.0suffix11000000suffix2", "prefix" + f_f + "suffix1" + sf_I + "suffix2");
        test("94.0null", "" + f_f + f_oNtS);
        test("94.0nullsuffix", "" + f_f + f_oNtS + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + f_oNtS + "suffix2");
        test("94.0false", "" + f_f + f_bl);
        test("94.0falsesuffix", "" + f_f + f_bl + "suffix");
        test("prefix94.0suffix1falsesuffix2", "prefix" + f_f + "suffix1" + f_bl + "suffix2");
        test("94.0null", "" + f_f + sf_iAN);
        test("94.0nullsuffix", "" + f_f + sf_iAN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + sf_iAN + "suffix2");
        test("94.0-2000000", "" + f_f + sf_iM);
        test("94.0-2000000suffix", "" + f_f + sf_iM + "suffix");
        test("prefix94.0suffix1-2000000suffix2", "prefix" + f_f + "suffix1" + sf_iM + "suffix2");
        test("94.0-820130816", "" + f_f + f_lM);
        test("94.0-820130816suffix", "" + f_f + f_lM + "suffix");
        test("prefix94.0suffix1-820130816suffix2", "prefix" + f_f + "suffix1" + f_lM + "suffix2");
        test("94.0null", "" + f_f + sf_oAN);
        test("94.0nullsuffix", "" + f_f + sf_oAN + "suffix");
        test("prefix94.0suffix1nullsuffix2", "prefix" + f_f + "suffix1" + sf_oAN + "suffix2");
        test("94.025000000", "" + f_f + s_I);
        test("94.025000000suffix", "" + f_f + s_I + "suffix");
        test("prefix94.0suffix125000000suffix2", "prefix" + f_f + "suffix1" + s_I + "suffix2");
        test("12.0-96.0", "" + sf_d + s_dM);
        test("12.0-96.0suffix", "" + sf_d + s_dM + "suffix");
        test("prefix12.0suffix1-96.0suffix2", "prefix" + sf_d + "suffix1" + s_dM + "suffix2");
        test("12.0null", "" + sf_d + s_oNtS);
        test("12.0nullsuffix", "" + sf_d + s_oNtS + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + s_oNtS + "suffix2");
        test("12.0\u045176", "" + sf_d + f_strU);
        test("12.0\u045176suffix", "" + sf_d + f_strU + "suffix");
        test("prefix12.0suffix1\u045176suffix2", "prefix" + sf_d + "suffix1" + f_strU + "suffix2");
        test("12.092", "" + sf_d + sf_strU2);
        test("12.092suffix", "" + sf_d + sf_strU2 + "suffix");
        test("prefix12.0suffix192suffix2", "prefix" + sf_d + "suffix1" + sf_strU2 + "suffix2");
        test("12.051", "" + sf_d + sf_strU1);
        test("12.051suffix", "" + sf_d + sf_strU1 + "suffix");
        test("prefix12.0suffix151suffix2", "prefix" + sf_d + "suffix1" + sf_strU1 + "suffix2");
        test("12.0null", "" + sf_d + s_iAN);
        test("12.0nullsuffix", "" + sf_d + s_iAN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + s_iAN + "suffix2");
        test("12.0-54", "" + sf_d + f_bM);
        test("12.0-54suffix", "" + sf_d + f_bM + "suffix");
        test("prefix12.0suffix1-54suffix2", "prefix" + sf_d + "suffix1" + f_bM + "suffix2");
        test("12.0-87.0", "" + sf_d + f_fM);
        test("12.0-87.0suffix", "" + sf_d + f_fM + "suffix");
        test("prefix12.0suffix1-87.0suffix2", "prefix" + sf_d + "suffix1" + f_fM + "suffix2");
        test("12.0null", "" + sf_d + s_oAN);
        test("12.0nullsuffix", "" + sf_d + s_oAN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + s_oAN + "suffix2");
        test("12.019", "" + sf_d + f_str);
        test("12.019suffix", "" + sf_d + f_str + "suffix");
        test("prefix12.0suffix119suffix2", "prefix" + sf_d + "suffix1" + f_str + "suffix2");
        test("12.0-41", "" + sf_d + sf_bM);
        test("12.0-41suffix", "" + sf_d + sf_bM + "suffix");
        test("prefix12.0suffix1-41suffix2", "prefix" + sf_d + "suffix1" + sf_bM + "suffix2");
        test("12.0null", "" + sf_d + sf_IN);
        test("12.0nullsuffix", "" + sf_d + sf_IN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + sf_IN + "suffix2");
        test("12.0T", "" + sf_d + s_c);
        test("12.0Tsuffix", "" + sf_d + s_c + "suffix");
        test("prefix12.0suffix1Tsuffix2", "prefix" + sf_d + "suffix1" + s_c + "suffix2");
        test("12.0-42.0", "" + sf_d + sf_fM);
        test("12.0-42.0suffix", "" + sf_d + sf_fM + "suffix");
        test("prefix12.0suffix1-42.0suffix2", "prefix" + sf_d + "suffix1" + sf_fM + "suffix2");
        test("12.025", "" + sf_d + s_b);
        test("12.025suffix", "" + sf_d + s_b + "suffix");
        test("prefix12.0suffix125suffix2", "prefix" + sf_d + "suffix1" + s_b + "suffix2");
        test("12.0null", "" + sf_d + f_oN);
        test("12.0nullsuffix", "" + sf_d + f_oN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + f_oN + "suffix2");
        test("12.0-1410065408", "" + sf_d + s_lM);
        test("12.0-1410065408suffix", "" + sf_d + s_lM + "suffix");
        test("prefix12.0suffix1-1410065408suffix2", "prefix" + sf_d + "suffix1" + s_lM + "suffix2");
        test("12.08.0", "" + sf_d + s_d);
        test("12.08.0suffix", "" + sf_d + s_d + "suffix");
        test("prefix12.0suffix18.0suffix2", "prefix" + sf_d + "suffix1" + s_d + "suffix2");
        test("12.055.0", "" + sf_d + s_f);
        test("12.055.0suffix", "" + sf_d + s_f + "suffix");
        test("prefix12.0suffix155.0suffix2", "prefix" + sf_d + "suffix1" + s_f + "suffix2");
        test("12.097000000", "" + sf_d + s_i);
        test("12.097000000suffix", "" + sf_d + s_i + "suffix");
        test("prefix12.0suffix197000000suffix2", "prefix" + sf_d + "suffix1" + s_i + "suffix2");
        test("12.0-9900", "" + sf_d + f_sM);
        test("12.0-9900suffix", "" + sf_d + f_sM + "suffix");
        test("prefix12.0suffix1-9900suffix2", "prefix" + sf_d + "suffix1" + f_sM + "suffix2");
        test("12.0935228928", "" + sf_d + s_l);
        test("12.0935228928suffix", "" + sf_d + s_l + "suffix");
        test("prefix12.0suffix1935228928suffix2", "prefix" + sf_d + "suffix1" + s_l + "suffix2");
        test("12.0-8400", "" + sf_d + sf_sM);
        test("12.0-8400suffix", "" + sf_d + sf_sM + "suffix");
        test("prefix12.0suffix1-8400suffix2", "prefix" + sf_d + "suffix1" + sf_sM + "suffix2");
        test("12.0C(82)", "" + sf_d + s_o);
        test("12.0C(82)suffix", "" + sf_d + s_o + "suffix");
        test("prefix12.0suffix1C(82)suffix2", "prefix" + sf_d + "suffix1" + s_o + "suffix2");
        test("12.0null", "" + sf_d + sf_oNtS);
        test("12.0nullsuffix", "" + sf_d + sf_oNtS + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + sf_oNtS + "suffix2");
        test("12.0true", "" + sf_d + s_bl);
        test("12.0truesuffix", "" + sf_d + s_bl + "suffix");
        test("prefix12.0suffix1truesuffix2", "prefix" + sf_d + "suffix1" + s_bl + "suffix2");
        test("12.03900", "" + sf_d + s_s);
        test("12.03900suffix", "" + sf_d + s_s + "suffix");
        test("prefix12.0suffix13900suffix2", "prefix" + sf_d + "suffix1" + s_s + "suffix2");
        test("12.0null", "" + sf_d + sf_oN);
        test("12.0nullsuffix", "" + sf_d + sf_oN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + sf_oN + "suffix2");
        test("12.094000000", "" + sf_d + f_I);
        test("12.094000000suffix", "" + sf_d + f_I + "suffix");
        test("prefix12.0suffix194000000suffix2", "prefix" + sf_d + "suffix1" + f_I + "suffix2");
        test("12.0null", "" + sf_d + f_IN);
        test("12.0nullsuffix", "" + sf_d + f_IN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + f_IN + "suffix2");
        test("12.0true", "" + sf_d + sf_bl);
        test("12.0truesuffix", "" + sf_d + sf_bl + "suffix");
        test("prefix12.0suffix1truesuffix2", "prefix" + sf_d + "suffix1" + sf_bl + "suffix2");
        test("12.05500", "" + sf_d + sf_s);
        test("12.05500suffix", "" + sf_d + sf_s + "suffix");
        test("prefix12.0suffix15500suffix2", "prefix" + sf_d + "suffix1" + sf_s + "suffix2");
        test("12.0-2900", "" + sf_d + s_sM);
        test("12.0-2900suffix", "" + sf_d + s_sM + "suffix");
        test("prefix12.0suffix1-2900suffix2", "prefix" + sf_d + "suffix1" + s_sM + "suffix2");
        test("12.0-194313216", "" + sf_d + sf_l);
        test("12.0-194313216suffix", "" + sf_d + sf_l + "suffix");
        test("prefix12.0suffix1-194313216suffix2", "prefix" + sf_d + "suffix1" + sf_l + "suffix2");
        test("12.012", "" + sf_d + s_strU1);
        test("12.012suffix", "" + sf_d + s_strU1 + "suffix");
        test("prefix12.0suffix112suffix2", "prefix" + sf_d + "suffix1" + s_strU1 + "suffix2");
        test("12.0C(87)", "" + sf_d + sf_o);
        test("12.0C(87)suffix", "" + sf_d + sf_o + "suffix");
        test("prefix12.0suffix1C(87)suffix2", "prefix" + sf_d + "suffix1" + sf_o + "suffix2");
        test("12.091", "" + sf_d + s_strU2);
        test("12.091suffix", "" + sf_d + s_strU2 + "suffix");
        test("prefix12.0suffix191suffix2", "prefix" + sf_d + "suffix1" + s_strU2 + "suffix2");
        test("12.021", "" + sf_d + f_strU1);
        test("12.021suffix", "" + sf_d + f_strU1 + "suffix");
        test("prefix12.0suffix121suffix2", "prefix" + sf_d + "suffix1" + f_strU1 + "suffix2");
        test("12.018", "" + sf_d + f_strU2);
        test("12.018suffix", "" + sf_d + f_strU2 + "suffix");
        test("prefix12.0suffix118suffix2", "prefix" + sf_d + "suffix1" + f_strU2 + "suffix2");
        test("12.0null", "" + sf_d + f_iAN);
        test("12.0nullsuffix", "" + sf_d + f_iAN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + f_iAN + "suffix2");
        test("12.0null", "" + sf_d + s_oN);
        test("12.0nullsuffix", "" + sf_d + s_oN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + s_oN + "suffix2");
        test("12.0\u045180", "" + sf_d + s_strU);
        test("12.0\u045180suffix", "" + sf_d + s_strU + "suffix");
        test("prefix12.0suffix1\u045180suffix2", "prefix" + sf_d + "suffix1" + s_strU + "suffix2");
        test("12.0C", "" + sf_d + sf_c);
        test("12.0Csuffix", "" + sf_d + sf_c + "suffix");
        test("prefix12.0suffix1Csuffix2", "prefix" + sf_d + "suffix1" + sf_c + "suffix2");
        test("12.075", "" + sf_d + sf_str);
        test("12.075suffix", "" + sf_d + sf_str + "suffix");
        test("prefix12.0suffix175suffix2", "prefix" + sf_d + "suffix1" + sf_str + "suffix2");
        test("12.0-43", "" + sf_d + s_bM);
        test("12.0-43suffix", "" + sf_d + s_bM + "suffix");
        test("prefix12.0suffix1-43suffix2", "prefix" + sf_d + "suffix1" + s_bM + "suffix2");
        test("12.080", "" + sf_d + sf_b);
        test("12.080suffix", "" + sf_d + sf_b + "suffix");
        test("prefix12.0suffix180suffix2", "prefix" + sf_d + "suffix1" + sf_b + "suffix2");
        test("12.0null", "" + sf_d + s_IN);
        test("12.0nullsuffix", "" + sf_d + s_IN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + s_IN + "suffix2");
        test("12.0-52.0", "" + sf_d + s_fM);
        test("12.0-52.0suffix", "" + sf_d + s_fM + "suffix");
        test("prefix12.0suffix1-52.0suffix2", "prefix" + sf_d + "suffix1" + s_fM + "suffix2");
        test("12.075000000", "" + sf_d + sf_i);
        test("12.075000000suffix", "" + sf_d + sf_i + "suffix");
        test("prefix12.0suffix175000000suffix2", "prefix" + sf_d + "suffix1" + sf_i + "suffix2");
        test("12.044", "" + sf_d + f_b);
        test("12.044suffix", "" + sf_d + f_b + "suffix");
        test("prefix12.0suffix144suffix2", "prefix" + sf_d + "suffix1" + f_b + "suffix2");
        test("12.0-1705032704", "" + sf_d + sf_lM);
        test("12.0-1705032704suffix", "" + sf_d + sf_lM + "suffix");
        test("prefix12.0suffix1-1705032704suffix2", "prefix" + sf_d + "suffix1" + sf_lM + "suffix2");
        test("12.0null", "" + sf_d + f_oAN);
        test("12.0nullsuffix", "" + sf_d + f_oAN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + f_oAN + "suffix2");
        test("12.083.0", "" + sf_d + f_d);
        test("12.083.0suffix", "" + sf_d + f_d + "suffix");
        test("prefix12.0suffix183.0suffix2", "prefix" + sf_d + "suffix1" + f_d + "suffix2");
        test("12.0I", "" + sf_d + f_c);
        test("12.0Isuffix", "" + sf_d + f_c + "suffix");
        test("prefix12.0suffix1Isuffix2", "prefix" + sf_d + "suffix1" + f_c + "suffix2");
        test("12.094.0", "" + sf_d + f_f);
        test("12.094.0suffix", "" + sf_d + f_f + "suffix");
        test("prefix12.0suffix194.0suffix2", "prefix" + sf_d + "suffix1" + f_f + "suffix2");
        test("12.012.0", "" + sf_d + sf_d);
        test("12.012.0suffix", "" + sf_d + sf_d + "suffix");
        test("prefix12.0suffix112.0suffix2", "prefix" + sf_d + "suffix1" + sf_d + "suffix2");
        test("12.0-99.0", "" + sf_d + f_dM);
        test("12.0-99.0suffix", "" + sf_d + f_dM + "suffix");
        test("prefix12.0suffix1-99.0suffix2", "prefix" + sf_d + "suffix1" + f_dM + "suffix2");
        test("12.017.0", "" + sf_d + sf_f);
        test("12.017.0suffix", "" + sf_d + sf_f + "suffix");
        test("prefix12.0suffix117.0suffix2", "prefix" + sf_d + "suffix1" + sf_f + "suffix2");
        test("12.0-84.0", "" + sf_d + sf_dM);
        test("12.0-84.0suffix", "" + sf_d + sf_dM + "suffix");
        test("prefix12.0suffix1-84.0suffix2", "prefix" + sf_d + "suffix1" + sf_dM + "suffix2");
        test("12.058000000", "" + sf_d + f_i);
        test("12.058000000suffix", "" + sf_d + f_i + "suffix");
        test("prefix12.0suffix158000000suffix2", "prefix" + sf_d + "suffix1" + f_i + "suffix2");
        test("12.0-55000000", "" + sf_d + f_iM);
        test("12.0-55000000suffix", "" + sf_d + f_iM + "suffix");
        test("prefix12.0suffix1-55000000suffix2", "prefix" + sf_d + "suffix1" + f_iM + "suffix2");
        test("12.01460392448", "" + sf_d + f_l);
        test("12.01460392448suffix", "" + sf_d + f_l + "suffix");
        test("prefix12.0suffix11460392448suffix2", "prefix" + sf_d + "suffix1" + f_l + "suffix2");
        test("12.0C(70)", "" + sf_d + f_o);
        test("12.0C(70)suffix", "" + sf_d + f_o + "suffix");
        test("prefix12.0suffix1C(70)suffix2", "prefix" + sf_d + "suffix1" + f_o + "suffix2");
        test("12.0\u04511", "" + sf_d + sf_strU);
        test("12.0\u04511suffix", "" + sf_d + sf_strU + "suffix");
        test("prefix12.0suffix1\u04511suffix2", "prefix" + sf_d + "suffix1" + sf_strU + "suffix2");
        test("12.08000", "" + sf_d + f_s);
        test("12.08000suffix", "" + sf_d + f_s + "suffix");
        test("prefix12.0suffix18000suffix2", "prefix" + sf_d + "suffix1" + f_s + "suffix2");
        test("12.018", "" + sf_d + s_str);
        test("12.018suffix", "" + sf_d + s_str + "suffix");
        test("prefix12.0suffix118suffix2", "prefix" + sf_d + "suffix1" + s_str + "suffix2");
        test("12.0-1000000", "" + sf_d + s_iM);
        test("12.0-1000000suffix", "" + sf_d + s_iM + "suffix");
        test("prefix12.0suffix1-1000000suffix2", "prefix" + sf_d + "suffix1" + s_iM + "suffix2");
        test("12.01000000", "" + sf_d + sf_I);
        test("12.01000000suffix", "" + sf_d + sf_I + "suffix");
        test("prefix12.0suffix11000000suffix2", "prefix" + sf_d + "suffix1" + sf_I + "suffix2");
        test("12.0null", "" + sf_d + f_oNtS);
        test("12.0nullsuffix", "" + sf_d + f_oNtS + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + f_oNtS + "suffix2");
        test("12.0false", "" + sf_d + f_bl);
        test("12.0falsesuffix", "" + sf_d + f_bl + "suffix");
        test("prefix12.0suffix1falsesuffix2", "prefix" + sf_d + "suffix1" + f_bl + "suffix2");
        test("12.0null", "" + sf_d + sf_iAN);
        test("12.0nullsuffix", "" + sf_d + sf_iAN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + sf_iAN + "suffix2");
        test("12.0-2000000", "" + sf_d + sf_iM);
        test("12.0-2000000suffix", "" + sf_d + sf_iM + "suffix");
        test("prefix12.0suffix1-2000000suffix2", "prefix" + sf_d + "suffix1" + sf_iM + "suffix2");
        test("12.0-820130816", "" + sf_d + f_lM);
        test("12.0-820130816suffix", "" + sf_d + f_lM + "suffix");
        test("prefix12.0suffix1-820130816suffix2", "prefix" + sf_d + "suffix1" + f_lM + "suffix2");
        test("12.0null", "" + sf_d + sf_oAN);
        test("12.0nullsuffix", "" + sf_d + sf_oAN + "suffix");
        test("prefix12.0suffix1nullsuffix2", "prefix" + sf_d + "suffix1" + sf_oAN + "suffix2");
        test("12.025000000", "" + sf_d + s_I);
        test("12.025000000suffix", "" + sf_d + s_I + "suffix");
        test("prefix12.0suffix125000000suffix2", "prefix" + sf_d + "suffix1" + s_I + "suffix2");
        test("-99.0-96.0", "" + f_dM + s_dM);
        test("-99.0-96.0suffix", "" + f_dM + s_dM + "suffix");
        test("prefix-99.0suffix1-96.0suffix2", "prefix" + f_dM + "suffix1" + s_dM + "suffix2");
        test("-99.0null", "" + f_dM + s_oNtS);
        test("-99.0nullsuffix", "" + f_dM + s_oNtS + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + s_oNtS + "suffix2");
        test("-99.0\u045176", "" + f_dM + f_strU);
        test("-99.0\u045176suffix", "" + f_dM + f_strU + "suffix");
        test("prefix-99.0suffix1\u045176suffix2", "prefix" + f_dM + "suffix1" + f_strU + "suffix2");
        test("-99.092", "" + f_dM + sf_strU2);
        test("-99.092suffix", "" + f_dM + sf_strU2 + "suffix");
        test("prefix-99.0suffix192suffix2", "prefix" + f_dM + "suffix1" + sf_strU2 + "suffix2");
        test("-99.051", "" + f_dM + sf_strU1);
        test("-99.051suffix", "" + f_dM + sf_strU1 + "suffix");
        test("prefix-99.0suffix151suffix2", "prefix" + f_dM + "suffix1" + sf_strU1 + "suffix2");
        test("-99.0null", "" + f_dM + s_iAN);
        test("-99.0nullsuffix", "" + f_dM + s_iAN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + s_iAN + "suffix2");
        test("-99.0-54", "" + f_dM + f_bM);
        test("-99.0-54suffix", "" + f_dM + f_bM + "suffix");
        test("prefix-99.0suffix1-54suffix2", "prefix" + f_dM + "suffix1" + f_bM + "suffix2");
        test("-99.0-87.0", "" + f_dM + f_fM);
        test("-99.0-87.0suffix", "" + f_dM + f_fM + "suffix");
        test("prefix-99.0suffix1-87.0suffix2", "prefix" + f_dM + "suffix1" + f_fM + "suffix2");
        test("-99.0null", "" + f_dM + s_oAN);
        test("-99.0nullsuffix", "" + f_dM + s_oAN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + s_oAN + "suffix2");
        test("-99.019", "" + f_dM + f_str);
        test("-99.019suffix", "" + f_dM + f_str + "suffix");
        test("prefix-99.0suffix119suffix2", "prefix" + f_dM + "suffix1" + f_str + "suffix2");
        test("-99.0-41", "" + f_dM + sf_bM);
        test("-99.0-41suffix", "" + f_dM + sf_bM + "suffix");
        test("prefix-99.0suffix1-41suffix2", "prefix" + f_dM + "suffix1" + sf_bM + "suffix2");
        test("-99.0null", "" + f_dM + sf_IN);
        test("-99.0nullsuffix", "" + f_dM + sf_IN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + sf_IN + "suffix2");
        test("-99.0T", "" + f_dM + s_c);
        test("-99.0Tsuffix", "" + f_dM + s_c + "suffix");
        test("prefix-99.0suffix1Tsuffix2", "prefix" + f_dM + "suffix1" + s_c + "suffix2");
        test("-99.0-42.0", "" + f_dM + sf_fM);
        test("-99.0-42.0suffix", "" + f_dM + sf_fM + "suffix");
        test("prefix-99.0suffix1-42.0suffix2", "prefix" + f_dM + "suffix1" + sf_fM + "suffix2");
        test("-99.025", "" + f_dM + s_b);
        test("-99.025suffix", "" + f_dM + s_b + "suffix");
        test("prefix-99.0suffix125suffix2", "prefix" + f_dM + "suffix1" + s_b + "suffix2");
        test("-99.0null", "" + f_dM + f_oN);
        test("-99.0nullsuffix", "" + f_dM + f_oN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + f_oN + "suffix2");
        test("-99.0-1410065408", "" + f_dM + s_lM);
        test("-99.0-1410065408suffix", "" + f_dM + s_lM + "suffix");
        test("prefix-99.0suffix1-1410065408suffix2", "prefix" + f_dM + "suffix1" + s_lM + "suffix2");
        test("-99.08.0", "" + f_dM + s_d);
        test("-99.08.0suffix", "" + f_dM + s_d + "suffix");
        test("prefix-99.0suffix18.0suffix2", "prefix" + f_dM + "suffix1" + s_d + "suffix2");
        test("-99.055.0", "" + f_dM + s_f);
        test("-99.055.0suffix", "" + f_dM + s_f + "suffix");
        test("prefix-99.0suffix155.0suffix2", "prefix" + f_dM + "suffix1" + s_f + "suffix2");
        test("-99.097000000", "" + f_dM + s_i);
        test("-99.097000000suffix", "" + f_dM + s_i + "suffix");
        test("prefix-99.0suffix197000000suffix2", "prefix" + f_dM + "suffix1" + s_i + "suffix2");
        test("-99.0-9900", "" + f_dM + f_sM);
        test("-99.0-9900suffix", "" + f_dM + f_sM + "suffix");
        test("prefix-99.0suffix1-9900suffix2", "prefix" + f_dM + "suffix1" + f_sM + "suffix2");
        test("-99.0935228928", "" + f_dM + s_l);
        test("-99.0935228928suffix", "" + f_dM + s_l + "suffix");
        test("prefix-99.0suffix1935228928suffix2", "prefix" + f_dM + "suffix1" + s_l + "suffix2");
        test("-99.0-8400", "" + f_dM + sf_sM);
        test("-99.0-8400suffix", "" + f_dM + sf_sM + "suffix");
        test("prefix-99.0suffix1-8400suffix2", "prefix" + f_dM + "suffix1" + sf_sM + "suffix2");
        test("-99.0C(82)", "" + f_dM + s_o);
        test("-99.0C(82)suffix", "" + f_dM + s_o + "suffix");
        test("prefix-99.0suffix1C(82)suffix2", "prefix" + f_dM + "suffix1" + s_o + "suffix2");
        test("-99.0null", "" + f_dM + sf_oNtS);
        test("-99.0nullsuffix", "" + f_dM + sf_oNtS + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + sf_oNtS + "suffix2");
        test("-99.0true", "" + f_dM + s_bl);
        test("-99.0truesuffix", "" + f_dM + s_bl + "suffix");
        test("prefix-99.0suffix1truesuffix2", "prefix" + f_dM + "suffix1" + s_bl + "suffix2");
        test("-99.03900", "" + f_dM + s_s);
        test("-99.03900suffix", "" + f_dM + s_s + "suffix");
        test("prefix-99.0suffix13900suffix2", "prefix" + f_dM + "suffix1" + s_s + "suffix2");
        test("-99.0null", "" + f_dM + sf_oN);
        test("-99.0nullsuffix", "" + f_dM + sf_oN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + sf_oN + "suffix2");
        test("-99.094000000", "" + f_dM + f_I);
        test("-99.094000000suffix", "" + f_dM + f_I + "suffix");
        test("prefix-99.0suffix194000000suffix2", "prefix" + f_dM + "suffix1" + f_I + "suffix2");
        test("-99.0null", "" + f_dM + f_IN);
        test("-99.0nullsuffix", "" + f_dM + f_IN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + f_IN + "suffix2");
        test("-99.0true", "" + f_dM + sf_bl);
        test("-99.0truesuffix", "" + f_dM + sf_bl + "suffix");
        test("prefix-99.0suffix1truesuffix2", "prefix" + f_dM + "suffix1" + sf_bl + "suffix2");
        test("-99.05500", "" + f_dM + sf_s);
        test("-99.05500suffix", "" + f_dM + sf_s + "suffix");
        test("prefix-99.0suffix15500suffix2", "prefix" + f_dM + "suffix1" + sf_s + "suffix2");
        test("-99.0-2900", "" + f_dM + s_sM);
        test("-99.0-2900suffix", "" + f_dM + s_sM + "suffix");
        test("prefix-99.0suffix1-2900suffix2", "prefix" + f_dM + "suffix1" + s_sM + "suffix2");
        test("-99.0-194313216", "" + f_dM + sf_l);
    }

    public void run13() {
        test("-99.0-194313216suffix", "" + f_dM + sf_l + "suffix");
        test("prefix-99.0suffix1-194313216suffix2", "prefix" + f_dM + "suffix1" + sf_l + "suffix2");
        test("-99.012", "" + f_dM + s_strU1);
        test("-99.012suffix", "" + f_dM + s_strU1 + "suffix");
        test("prefix-99.0suffix112suffix2", "prefix" + f_dM + "suffix1" + s_strU1 + "suffix2");
        test("-99.0C(87)", "" + f_dM + sf_o);
        test("-99.0C(87)suffix", "" + f_dM + sf_o + "suffix");
        test("prefix-99.0suffix1C(87)suffix2", "prefix" + f_dM + "suffix1" + sf_o + "suffix2");
        test("-99.091", "" + f_dM + s_strU2);
        test("-99.091suffix", "" + f_dM + s_strU2 + "suffix");
        test("prefix-99.0suffix191suffix2", "prefix" + f_dM + "suffix1" + s_strU2 + "suffix2");
        test("-99.021", "" + f_dM + f_strU1);
        test("-99.021suffix", "" + f_dM + f_strU1 + "suffix");
        test("prefix-99.0suffix121suffix2", "prefix" + f_dM + "suffix1" + f_strU1 + "suffix2");
        test("-99.018", "" + f_dM + f_strU2);
        test("-99.018suffix", "" + f_dM + f_strU2 + "suffix");
        test("prefix-99.0suffix118suffix2", "prefix" + f_dM + "suffix1" + f_strU2 + "suffix2");
        test("-99.0null", "" + f_dM + f_iAN);
        test("-99.0nullsuffix", "" + f_dM + f_iAN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + f_iAN + "suffix2");
        test("-99.0null", "" + f_dM + s_oN);
        test("-99.0nullsuffix", "" + f_dM + s_oN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + s_oN + "suffix2");
        test("-99.0\u045180", "" + f_dM + s_strU);
        test("-99.0\u045180suffix", "" + f_dM + s_strU + "suffix");
        test("prefix-99.0suffix1\u045180suffix2", "prefix" + f_dM + "suffix1" + s_strU + "suffix2");
        test("-99.0C", "" + f_dM + sf_c);
        test("-99.0Csuffix", "" + f_dM + sf_c + "suffix");
        test("prefix-99.0suffix1Csuffix2", "prefix" + f_dM + "suffix1" + sf_c + "suffix2");
        test("-99.075", "" + f_dM + sf_str);
        test("-99.075suffix", "" + f_dM + sf_str + "suffix");
        test("prefix-99.0suffix175suffix2", "prefix" + f_dM + "suffix1" + sf_str + "suffix2");
        test("-99.0-43", "" + f_dM + s_bM);
        test("-99.0-43suffix", "" + f_dM + s_bM + "suffix");
        test("prefix-99.0suffix1-43suffix2", "prefix" + f_dM + "suffix1" + s_bM + "suffix2");
        test("-99.080", "" + f_dM + sf_b);
        test("-99.080suffix", "" + f_dM + sf_b + "suffix");
        test("prefix-99.0suffix180suffix2", "prefix" + f_dM + "suffix1" + sf_b + "suffix2");
        test("-99.0null", "" + f_dM + s_IN);
        test("-99.0nullsuffix", "" + f_dM + s_IN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + s_IN + "suffix2");
        test("-99.0-52.0", "" + f_dM + s_fM);
        test("-99.0-52.0suffix", "" + f_dM + s_fM + "suffix");
        test("prefix-99.0suffix1-52.0suffix2", "prefix" + f_dM + "suffix1" + s_fM + "suffix2");
        test("-99.075000000", "" + f_dM + sf_i);
        test("-99.075000000suffix", "" + f_dM + sf_i + "suffix");
        test("prefix-99.0suffix175000000suffix2", "prefix" + f_dM + "suffix1" + sf_i + "suffix2");
        test("-99.044", "" + f_dM + f_b);
        test("-99.044suffix", "" + f_dM + f_b + "suffix");
        test("prefix-99.0suffix144suffix2", "prefix" + f_dM + "suffix1" + f_b + "suffix2");
        test("-99.0-1705032704", "" + f_dM + sf_lM);
        test("-99.0-1705032704suffix", "" + f_dM + sf_lM + "suffix");
        test("prefix-99.0suffix1-1705032704suffix2", "prefix" + f_dM + "suffix1" + sf_lM + "suffix2");
        test("-99.0null", "" + f_dM + f_oAN);
        test("-99.0nullsuffix", "" + f_dM + f_oAN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + f_oAN + "suffix2");
        test("-99.083.0", "" + f_dM + f_d);
        test("-99.083.0suffix", "" + f_dM + f_d + "suffix");
        test("prefix-99.0suffix183.0suffix2", "prefix" + f_dM + "suffix1" + f_d + "suffix2");
        test("-99.0I", "" + f_dM + f_c);
        test("-99.0Isuffix", "" + f_dM + f_c + "suffix");
        test("prefix-99.0suffix1Isuffix2", "prefix" + f_dM + "suffix1" + f_c + "suffix2");
        test("-99.094.0", "" + f_dM + f_f);
        test("-99.094.0suffix", "" + f_dM + f_f + "suffix");
        test("prefix-99.0suffix194.0suffix2", "prefix" + f_dM + "suffix1" + f_f + "suffix2");
        test("-99.012.0", "" + f_dM + sf_d);
        test("-99.012.0suffix", "" + f_dM + sf_d + "suffix");
        test("prefix-99.0suffix112.0suffix2", "prefix" + f_dM + "suffix1" + sf_d + "suffix2");
        test("-99.0-99.0", "" + f_dM + f_dM);
        test("-99.0-99.0suffix", "" + f_dM + f_dM + "suffix");
        test("prefix-99.0suffix1-99.0suffix2", "prefix" + f_dM + "suffix1" + f_dM + "suffix2");
        test("-99.017.0", "" + f_dM + sf_f);
        test("-99.017.0suffix", "" + f_dM + sf_f + "suffix");
        test("prefix-99.0suffix117.0suffix2", "prefix" + f_dM + "suffix1" + sf_f + "suffix2");
        test("-99.0-84.0", "" + f_dM + sf_dM);
        test("-99.0-84.0suffix", "" + f_dM + sf_dM + "suffix");
        test("prefix-99.0suffix1-84.0suffix2", "prefix" + f_dM + "suffix1" + sf_dM + "suffix2");
        test("-99.058000000", "" + f_dM + f_i);
        test("-99.058000000suffix", "" + f_dM + f_i + "suffix");
        test("prefix-99.0suffix158000000suffix2", "prefix" + f_dM + "suffix1" + f_i + "suffix2");
        test("-99.0-55000000", "" + f_dM + f_iM);
        test("-99.0-55000000suffix", "" + f_dM + f_iM + "suffix");
        test("prefix-99.0suffix1-55000000suffix2", "prefix" + f_dM + "suffix1" + f_iM + "suffix2");
        test("-99.01460392448", "" + f_dM + f_l);
        test("-99.01460392448suffix", "" + f_dM + f_l + "suffix");
        test("prefix-99.0suffix11460392448suffix2", "prefix" + f_dM + "suffix1" + f_l + "suffix2");
        test("-99.0C(70)", "" + f_dM + f_o);
        test("-99.0C(70)suffix", "" + f_dM + f_o + "suffix");
        test("prefix-99.0suffix1C(70)suffix2", "prefix" + f_dM + "suffix1" + f_o + "suffix2");
        test("-99.0\u04511", "" + f_dM + sf_strU);
        test("-99.0\u04511suffix", "" + f_dM + sf_strU + "suffix");
        test("prefix-99.0suffix1\u04511suffix2", "prefix" + f_dM + "suffix1" + sf_strU + "suffix2");
        test("-99.08000", "" + f_dM + f_s);
        test("-99.08000suffix", "" + f_dM + f_s + "suffix");
        test("prefix-99.0suffix18000suffix2", "prefix" + f_dM + "suffix1" + f_s + "suffix2");
        test("-99.018", "" + f_dM + s_str);
        test("-99.018suffix", "" + f_dM + s_str + "suffix");
        test("prefix-99.0suffix118suffix2", "prefix" + f_dM + "suffix1" + s_str + "suffix2");
        test("-99.0-1000000", "" + f_dM + s_iM);
        test("-99.0-1000000suffix", "" + f_dM + s_iM + "suffix");
        test("prefix-99.0suffix1-1000000suffix2", "prefix" + f_dM + "suffix1" + s_iM + "suffix2");
        test("-99.01000000", "" + f_dM + sf_I);
        test("-99.01000000suffix", "" + f_dM + sf_I + "suffix");
        test("prefix-99.0suffix11000000suffix2", "prefix" + f_dM + "suffix1" + sf_I + "suffix2");
        test("-99.0null", "" + f_dM + f_oNtS);
        test("-99.0nullsuffix", "" + f_dM + f_oNtS + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + f_oNtS + "suffix2");
        test("-99.0false", "" + f_dM + f_bl);
        test("-99.0falsesuffix", "" + f_dM + f_bl + "suffix");
        test("prefix-99.0suffix1falsesuffix2", "prefix" + f_dM + "suffix1" + f_bl + "suffix2");
        test("-99.0null", "" + f_dM + sf_iAN);
        test("-99.0nullsuffix", "" + f_dM + sf_iAN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + sf_iAN + "suffix2");
        test("-99.0-2000000", "" + f_dM + sf_iM);
        test("-99.0-2000000suffix", "" + f_dM + sf_iM + "suffix");
        test("prefix-99.0suffix1-2000000suffix2", "prefix" + f_dM + "suffix1" + sf_iM + "suffix2");
        test("-99.0-820130816", "" + f_dM + f_lM);
        test("-99.0-820130816suffix", "" + f_dM + f_lM + "suffix");
        test("prefix-99.0suffix1-820130816suffix2", "prefix" + f_dM + "suffix1" + f_lM + "suffix2");
        test("-99.0null", "" + f_dM + sf_oAN);
        test("-99.0nullsuffix", "" + f_dM + sf_oAN + "suffix");
        test("prefix-99.0suffix1nullsuffix2", "prefix" + f_dM + "suffix1" + sf_oAN + "suffix2");
        test("-99.025000000", "" + f_dM + s_I);
        test("-99.025000000suffix", "" + f_dM + s_I + "suffix");
        test("prefix-99.0suffix125000000suffix2", "prefix" + f_dM + "suffix1" + s_I + "suffix2");
        test("17.0-96.0", "" + sf_f + s_dM);
        test("17.0-96.0suffix", "" + sf_f + s_dM + "suffix");
        test("prefix17.0suffix1-96.0suffix2", "prefix" + sf_f + "suffix1" + s_dM + "suffix2");
        test("17.0null", "" + sf_f + s_oNtS);
        test("17.0nullsuffix", "" + sf_f + s_oNtS + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + s_oNtS + "suffix2");
        test("17.0\u045176", "" + sf_f + f_strU);
        test("17.0\u045176suffix", "" + sf_f + f_strU + "suffix");
        test("prefix17.0suffix1\u045176suffix2", "prefix" + sf_f + "suffix1" + f_strU + "suffix2");
        test("17.092", "" + sf_f + sf_strU2);
        test("17.092suffix", "" + sf_f + sf_strU2 + "suffix");
        test("prefix17.0suffix192suffix2", "prefix" + sf_f + "suffix1" + sf_strU2 + "suffix2");
        test("17.051", "" + sf_f + sf_strU1);
        test("17.051suffix", "" + sf_f + sf_strU1 + "suffix");
        test("prefix17.0suffix151suffix2", "prefix" + sf_f + "suffix1" + sf_strU1 + "suffix2");
        test("17.0null", "" + sf_f + s_iAN);
        test("17.0nullsuffix", "" + sf_f + s_iAN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + s_iAN + "suffix2");
        test("17.0-54", "" + sf_f + f_bM);
        test("17.0-54suffix", "" + sf_f + f_bM + "suffix");
        test("prefix17.0suffix1-54suffix2", "prefix" + sf_f + "suffix1" + f_bM + "suffix2");
        test("17.0-87.0", "" + sf_f + f_fM);
        test("17.0-87.0suffix", "" + sf_f + f_fM + "suffix");
        test("prefix17.0suffix1-87.0suffix2", "prefix" + sf_f + "suffix1" + f_fM + "suffix2");
        test("17.0null", "" + sf_f + s_oAN);
        test("17.0nullsuffix", "" + sf_f + s_oAN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + s_oAN + "suffix2");
        test("17.019", "" + sf_f + f_str);
        test("17.019suffix", "" + sf_f + f_str + "suffix");
        test("prefix17.0suffix119suffix2", "prefix" + sf_f + "suffix1" + f_str + "suffix2");
        test("17.0-41", "" + sf_f + sf_bM);
        test("17.0-41suffix", "" + sf_f + sf_bM + "suffix");
        test("prefix17.0suffix1-41suffix2", "prefix" + sf_f + "suffix1" + sf_bM + "suffix2");
        test("17.0null", "" + sf_f + sf_IN);
        test("17.0nullsuffix", "" + sf_f + sf_IN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + sf_IN + "suffix2");
        test("17.0T", "" + sf_f + s_c);
        test("17.0Tsuffix", "" + sf_f + s_c + "suffix");
        test("prefix17.0suffix1Tsuffix2", "prefix" + sf_f + "suffix1" + s_c + "suffix2");
        test("17.0-42.0", "" + sf_f + sf_fM);
        test("17.0-42.0suffix", "" + sf_f + sf_fM + "suffix");
        test("prefix17.0suffix1-42.0suffix2", "prefix" + sf_f + "suffix1" + sf_fM + "suffix2");
        test("17.025", "" + sf_f + s_b);
        test("17.025suffix", "" + sf_f + s_b + "suffix");
        test("prefix17.0suffix125suffix2", "prefix" + sf_f + "suffix1" + s_b + "suffix2");
        test("17.0null", "" + sf_f + f_oN);
        test("17.0nullsuffix", "" + sf_f + f_oN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + f_oN + "suffix2");
        test("17.0-1410065408", "" + sf_f + s_lM);
        test("17.0-1410065408suffix", "" + sf_f + s_lM + "suffix");
        test("prefix17.0suffix1-1410065408suffix2", "prefix" + sf_f + "suffix1" + s_lM + "suffix2");
        test("17.08.0", "" + sf_f + s_d);
        test("17.08.0suffix", "" + sf_f + s_d + "suffix");
        test("prefix17.0suffix18.0suffix2", "prefix" + sf_f + "suffix1" + s_d + "suffix2");
        test("17.055.0", "" + sf_f + s_f);
        test("17.055.0suffix", "" + sf_f + s_f + "suffix");
        test("prefix17.0suffix155.0suffix2", "prefix" + sf_f + "suffix1" + s_f + "suffix2");
        test("17.097000000", "" + sf_f + s_i);
        test("17.097000000suffix", "" + sf_f + s_i + "suffix");
        test("prefix17.0suffix197000000suffix2", "prefix" + sf_f + "suffix1" + s_i + "suffix2");
        test("17.0-9900", "" + sf_f + f_sM);
        test("17.0-9900suffix", "" + sf_f + f_sM + "suffix");
        test("prefix17.0suffix1-9900suffix2", "prefix" + sf_f + "suffix1" + f_sM + "suffix2");
        test("17.0935228928", "" + sf_f + s_l);
        test("17.0935228928suffix", "" + sf_f + s_l + "suffix");
        test("prefix17.0suffix1935228928suffix2", "prefix" + sf_f + "suffix1" + s_l + "suffix2");
        test("17.0-8400", "" + sf_f + sf_sM);
        test("17.0-8400suffix", "" + sf_f + sf_sM + "suffix");
        test("prefix17.0suffix1-8400suffix2", "prefix" + sf_f + "suffix1" + sf_sM + "suffix2");
        test("17.0C(82)", "" + sf_f + s_o);
        test("17.0C(82)suffix", "" + sf_f + s_o + "suffix");
        test("prefix17.0suffix1C(82)suffix2", "prefix" + sf_f + "suffix1" + s_o + "suffix2");
        test("17.0null", "" + sf_f + sf_oNtS);
        test("17.0nullsuffix", "" + sf_f + sf_oNtS + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + sf_oNtS + "suffix2");
        test("17.0true", "" + sf_f + s_bl);
        test("17.0truesuffix", "" + sf_f + s_bl + "suffix");
        test("prefix17.0suffix1truesuffix2", "prefix" + sf_f + "suffix1" + s_bl + "suffix2");
        test("17.03900", "" + sf_f + s_s);
        test("17.03900suffix", "" + sf_f + s_s + "suffix");
        test("prefix17.0suffix13900suffix2", "prefix" + sf_f + "suffix1" + s_s + "suffix2");
        test("17.0null", "" + sf_f + sf_oN);
        test("17.0nullsuffix", "" + sf_f + sf_oN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + sf_oN + "suffix2");
        test("17.094000000", "" + sf_f + f_I);
        test("17.094000000suffix", "" + sf_f + f_I + "suffix");
        test("prefix17.0suffix194000000suffix2", "prefix" + sf_f + "suffix1" + f_I + "suffix2");
        test("17.0null", "" + sf_f + f_IN);
        test("17.0nullsuffix", "" + sf_f + f_IN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + f_IN + "suffix2");
        test("17.0true", "" + sf_f + sf_bl);
        test("17.0truesuffix", "" + sf_f + sf_bl + "suffix");
        test("prefix17.0suffix1truesuffix2", "prefix" + sf_f + "suffix1" + sf_bl + "suffix2");
        test("17.05500", "" + sf_f + sf_s);
        test("17.05500suffix", "" + sf_f + sf_s + "suffix");
        test("prefix17.0suffix15500suffix2", "prefix" + sf_f + "suffix1" + sf_s + "suffix2");
        test("17.0-2900", "" + sf_f + s_sM);
        test("17.0-2900suffix", "" + sf_f + s_sM + "suffix");
        test("prefix17.0suffix1-2900suffix2", "prefix" + sf_f + "suffix1" + s_sM + "suffix2");
        test("17.0-194313216", "" + sf_f + sf_l);
        test("17.0-194313216suffix", "" + sf_f + sf_l + "suffix");
        test("prefix17.0suffix1-194313216suffix2", "prefix" + sf_f + "suffix1" + sf_l + "suffix2");
        test("17.012", "" + sf_f + s_strU1);
        test("17.012suffix", "" + sf_f + s_strU1 + "suffix");
        test("prefix17.0suffix112suffix2", "prefix" + sf_f + "suffix1" + s_strU1 + "suffix2");
        test("17.0C(87)", "" + sf_f + sf_o);
        test("17.0C(87)suffix", "" + sf_f + sf_o + "suffix");
        test("prefix17.0suffix1C(87)suffix2", "prefix" + sf_f + "suffix1" + sf_o + "suffix2");
        test("17.091", "" + sf_f + s_strU2);
        test("17.091suffix", "" + sf_f + s_strU2 + "suffix");
        test("prefix17.0suffix191suffix2", "prefix" + sf_f + "suffix1" + s_strU2 + "suffix2");
        test("17.021", "" + sf_f + f_strU1);
        test("17.021suffix", "" + sf_f + f_strU1 + "suffix");
        test("prefix17.0suffix121suffix2", "prefix" + sf_f + "suffix1" + f_strU1 + "suffix2");
        test("17.018", "" + sf_f + f_strU2);
        test("17.018suffix", "" + sf_f + f_strU2 + "suffix");
        test("prefix17.0suffix118suffix2", "prefix" + sf_f + "suffix1" + f_strU2 + "suffix2");
        test("17.0null", "" + sf_f + f_iAN);
        test("17.0nullsuffix", "" + sf_f + f_iAN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + f_iAN + "suffix2");
        test("17.0null", "" + sf_f + s_oN);
        test("17.0nullsuffix", "" + sf_f + s_oN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + s_oN + "suffix2");
        test("17.0\u045180", "" + sf_f + s_strU);
        test("17.0\u045180suffix", "" + sf_f + s_strU + "suffix");
        test("prefix17.0suffix1\u045180suffix2", "prefix" + sf_f + "suffix1" + s_strU + "suffix2");
        test("17.0C", "" + sf_f + sf_c);
        test("17.0Csuffix", "" + sf_f + sf_c + "suffix");
        test("prefix17.0suffix1Csuffix2", "prefix" + sf_f + "suffix1" + sf_c + "suffix2");
        test("17.075", "" + sf_f + sf_str);
        test("17.075suffix", "" + sf_f + sf_str + "suffix");
        test("prefix17.0suffix175suffix2", "prefix" + sf_f + "suffix1" + sf_str + "suffix2");
        test("17.0-43", "" + sf_f + s_bM);
        test("17.0-43suffix", "" + sf_f + s_bM + "suffix");
        test("prefix17.0suffix1-43suffix2", "prefix" + sf_f + "suffix1" + s_bM + "suffix2");
        test("17.080", "" + sf_f + sf_b);
        test("17.080suffix", "" + sf_f + sf_b + "suffix");
        test("prefix17.0suffix180suffix2", "prefix" + sf_f + "suffix1" + sf_b + "suffix2");
        test("17.0null", "" + sf_f + s_IN);
        test("17.0nullsuffix", "" + sf_f + s_IN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + s_IN + "suffix2");
        test("17.0-52.0", "" + sf_f + s_fM);
        test("17.0-52.0suffix", "" + sf_f + s_fM + "suffix");
        test("prefix17.0suffix1-52.0suffix2", "prefix" + sf_f + "suffix1" + s_fM + "suffix2");
        test("17.075000000", "" + sf_f + sf_i);
        test("17.075000000suffix", "" + sf_f + sf_i + "suffix");
        test("prefix17.0suffix175000000suffix2", "prefix" + sf_f + "suffix1" + sf_i + "suffix2");
        test("17.044", "" + sf_f + f_b);
        test("17.044suffix", "" + sf_f + f_b + "suffix");
        test("prefix17.0suffix144suffix2", "prefix" + sf_f + "suffix1" + f_b + "suffix2");
        test("17.0-1705032704", "" + sf_f + sf_lM);
        test("17.0-1705032704suffix", "" + sf_f + sf_lM + "suffix");
        test("prefix17.0suffix1-1705032704suffix2", "prefix" + sf_f + "suffix1" + sf_lM + "suffix2");
        test("17.0null", "" + sf_f + f_oAN);
        test("17.0nullsuffix", "" + sf_f + f_oAN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + f_oAN + "suffix2");
        test("17.083.0", "" + sf_f + f_d);
        test("17.083.0suffix", "" + sf_f + f_d + "suffix");
        test("prefix17.0suffix183.0suffix2", "prefix" + sf_f + "suffix1" + f_d + "suffix2");
        test("17.0I", "" + sf_f + f_c);
        test("17.0Isuffix", "" + sf_f + f_c + "suffix");
        test("prefix17.0suffix1Isuffix2", "prefix" + sf_f + "suffix1" + f_c + "suffix2");
        test("17.094.0", "" + sf_f + f_f);
        test("17.094.0suffix", "" + sf_f + f_f + "suffix");
        test("prefix17.0suffix194.0suffix2", "prefix" + sf_f + "suffix1" + f_f + "suffix2");
        test("17.012.0", "" + sf_f + sf_d);
        test("17.012.0suffix", "" + sf_f + sf_d + "suffix");
        test("prefix17.0suffix112.0suffix2", "prefix" + sf_f + "suffix1" + sf_d + "suffix2");
        test("17.0-99.0", "" + sf_f + f_dM);
        test("17.0-99.0suffix", "" + sf_f + f_dM + "suffix");
        test("prefix17.0suffix1-99.0suffix2", "prefix" + sf_f + "suffix1" + f_dM + "suffix2");
        test("17.017.0", "" + sf_f + sf_f);
        test("17.017.0suffix", "" + sf_f + sf_f + "suffix");
        test("prefix17.0suffix117.0suffix2", "prefix" + sf_f + "suffix1" + sf_f + "suffix2");
        test("17.0-84.0", "" + sf_f + sf_dM);
        test("17.0-84.0suffix", "" + sf_f + sf_dM + "suffix");
        test("prefix17.0suffix1-84.0suffix2", "prefix" + sf_f + "suffix1" + sf_dM + "suffix2");
        test("17.058000000", "" + sf_f + f_i);
        test("17.058000000suffix", "" + sf_f + f_i + "suffix");
        test("prefix17.0suffix158000000suffix2", "prefix" + sf_f + "suffix1" + f_i + "suffix2");
        test("17.0-55000000", "" + sf_f + f_iM);
        test("17.0-55000000suffix", "" + sf_f + f_iM + "suffix");
        test("prefix17.0suffix1-55000000suffix2", "prefix" + sf_f + "suffix1" + f_iM + "suffix2");
        test("17.01460392448", "" + sf_f + f_l);
        test("17.01460392448suffix", "" + sf_f + f_l + "suffix");
        test("prefix17.0suffix11460392448suffix2", "prefix" + sf_f + "suffix1" + f_l + "suffix2");
        test("17.0C(70)", "" + sf_f + f_o);
        test("17.0C(70)suffix", "" + sf_f + f_o + "suffix");
        test("prefix17.0suffix1C(70)suffix2", "prefix" + sf_f + "suffix1" + f_o + "suffix2");
        test("17.0\u04511", "" + sf_f + sf_strU);
        test("17.0\u04511suffix", "" + sf_f + sf_strU + "suffix");
        test("prefix17.0suffix1\u04511suffix2", "prefix" + sf_f + "suffix1" + sf_strU + "suffix2");
        test("17.08000", "" + sf_f + f_s);
        test("17.08000suffix", "" + sf_f + f_s + "suffix");
        test("prefix17.0suffix18000suffix2", "prefix" + sf_f + "suffix1" + f_s + "suffix2");
        test("17.018", "" + sf_f + s_str);
        test("17.018suffix", "" + sf_f + s_str + "suffix");
        test("prefix17.0suffix118suffix2", "prefix" + sf_f + "suffix1" + s_str + "suffix2");
        test("17.0-1000000", "" + sf_f + s_iM);
        test("17.0-1000000suffix", "" + sf_f + s_iM + "suffix");
        test("prefix17.0suffix1-1000000suffix2", "prefix" + sf_f + "suffix1" + s_iM + "suffix2");
        test("17.01000000", "" + sf_f + sf_I);
        test("17.01000000suffix", "" + sf_f + sf_I + "suffix");
        test("prefix17.0suffix11000000suffix2", "prefix" + sf_f + "suffix1" + sf_I + "suffix2");
        test("17.0null", "" + sf_f + f_oNtS);
        test("17.0nullsuffix", "" + sf_f + f_oNtS + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + f_oNtS + "suffix2");
        test("17.0false", "" + sf_f + f_bl);
        test("17.0falsesuffix", "" + sf_f + f_bl + "suffix");
        test("prefix17.0suffix1falsesuffix2", "prefix" + sf_f + "suffix1" + f_bl + "suffix2");
        test("17.0null", "" + sf_f + sf_iAN);
        test("17.0nullsuffix", "" + sf_f + sf_iAN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + sf_iAN + "suffix2");
        test("17.0-2000000", "" + sf_f + sf_iM);
        test("17.0-2000000suffix", "" + sf_f + sf_iM + "suffix");
        test("prefix17.0suffix1-2000000suffix2", "prefix" + sf_f + "suffix1" + sf_iM + "suffix2");
        test("17.0-820130816", "" + sf_f + f_lM);
        test("17.0-820130816suffix", "" + sf_f + f_lM + "suffix");
        test("prefix17.0suffix1-820130816suffix2", "prefix" + sf_f + "suffix1" + f_lM + "suffix2");
        test("17.0null", "" + sf_f + sf_oAN);
        test("17.0nullsuffix", "" + sf_f + sf_oAN + "suffix");
        test("prefix17.0suffix1nullsuffix2", "prefix" + sf_f + "suffix1" + sf_oAN + "suffix2");
        test("17.025000000", "" + sf_f + s_I);
        test("17.025000000suffix", "" + sf_f + s_I + "suffix");
        test("prefix17.0suffix125000000suffix2", "prefix" + sf_f + "suffix1" + s_I + "suffix2");
        test("-84.0-96.0", "" + sf_dM + s_dM);
        test("-84.0-96.0suffix", "" + sf_dM + s_dM + "suffix");
        test("prefix-84.0suffix1-96.0suffix2", "prefix" + sf_dM + "suffix1" + s_dM + "suffix2");
        test("-84.0null", "" + sf_dM + s_oNtS);
        test("-84.0nullsuffix", "" + sf_dM + s_oNtS + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + s_oNtS + "suffix2");
        test("-84.0\u045176", "" + sf_dM + f_strU);
        test("-84.0\u045176suffix", "" + sf_dM + f_strU + "suffix");
        test("prefix-84.0suffix1\u045176suffix2", "prefix" + sf_dM + "suffix1" + f_strU + "suffix2");
        test("-84.092", "" + sf_dM + sf_strU2);
        test("-84.092suffix", "" + sf_dM + sf_strU2 + "suffix");
        test("prefix-84.0suffix192suffix2", "prefix" + sf_dM + "suffix1" + sf_strU2 + "suffix2");
        test("-84.051", "" + sf_dM + sf_strU1);
        test("-84.051suffix", "" + sf_dM + sf_strU1 + "suffix");
        test("prefix-84.0suffix151suffix2", "prefix" + sf_dM + "suffix1" + sf_strU1 + "suffix2");
        test("-84.0null", "" + sf_dM + s_iAN);
        test("-84.0nullsuffix", "" + sf_dM + s_iAN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + s_iAN + "suffix2");
        test("-84.0-54", "" + sf_dM + f_bM);
        test("-84.0-54suffix", "" + sf_dM + f_bM + "suffix");
        test("prefix-84.0suffix1-54suffix2", "prefix" + sf_dM + "suffix1" + f_bM + "suffix2");
        test("-84.0-87.0", "" + sf_dM + f_fM);
        test("-84.0-87.0suffix", "" + sf_dM + f_fM + "suffix");
        test("prefix-84.0suffix1-87.0suffix2", "prefix" + sf_dM + "suffix1" + f_fM + "suffix2");
        test("-84.0null", "" + sf_dM + s_oAN);
        test("-84.0nullsuffix", "" + sf_dM + s_oAN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + s_oAN + "suffix2");
        test("-84.019", "" + sf_dM + f_str);
        test("-84.019suffix", "" + sf_dM + f_str + "suffix");
        test("prefix-84.0suffix119suffix2", "prefix" + sf_dM + "suffix1" + f_str + "suffix2");
        test("-84.0-41", "" + sf_dM + sf_bM);
        test("-84.0-41suffix", "" + sf_dM + sf_bM + "suffix");
        test("prefix-84.0suffix1-41suffix2", "prefix" + sf_dM + "suffix1" + sf_bM + "suffix2");
        test("-84.0null", "" + sf_dM + sf_IN);
        test("-84.0nullsuffix", "" + sf_dM + sf_IN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + sf_IN + "suffix2");
        test("-84.0T", "" + sf_dM + s_c);
        test("-84.0Tsuffix", "" + sf_dM + s_c + "suffix");
        test("prefix-84.0suffix1Tsuffix2", "prefix" + sf_dM + "suffix1" + s_c + "suffix2");
        test("-84.0-42.0", "" + sf_dM + sf_fM);
        test("-84.0-42.0suffix", "" + sf_dM + sf_fM + "suffix");
        test("prefix-84.0suffix1-42.0suffix2", "prefix" + sf_dM + "suffix1" + sf_fM + "suffix2");
        test("-84.025", "" + sf_dM + s_b);
        test("-84.025suffix", "" + sf_dM + s_b + "suffix");
        test("prefix-84.0suffix125suffix2", "prefix" + sf_dM + "suffix1" + s_b + "suffix2");
        test("-84.0null", "" + sf_dM + f_oN);
        test("-84.0nullsuffix", "" + sf_dM + f_oN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + f_oN + "suffix2");
        test("-84.0-1410065408", "" + sf_dM + s_lM);
        test("-84.0-1410065408suffix", "" + sf_dM + s_lM + "suffix");
        test("prefix-84.0suffix1-1410065408suffix2", "prefix" + sf_dM + "suffix1" + s_lM + "suffix2");
        test("-84.08.0", "" + sf_dM + s_d);
        test("-84.08.0suffix", "" + sf_dM + s_d + "suffix");
        test("prefix-84.0suffix18.0suffix2", "prefix" + sf_dM + "suffix1" + s_d + "suffix2");
        test("-84.055.0", "" + sf_dM + s_f);
        test("-84.055.0suffix", "" + sf_dM + s_f + "suffix");
        test("prefix-84.0suffix155.0suffix2", "prefix" + sf_dM + "suffix1" + s_f + "suffix2");
        test("-84.097000000", "" + sf_dM + s_i);
        test("-84.097000000suffix", "" + sf_dM + s_i + "suffix");
        test("prefix-84.0suffix197000000suffix2", "prefix" + sf_dM + "suffix1" + s_i + "suffix2");
        test("-84.0-9900", "" + sf_dM + f_sM);
        test("-84.0-9900suffix", "" + sf_dM + f_sM + "suffix");
        test("prefix-84.0suffix1-9900suffix2", "prefix" + sf_dM + "suffix1" + f_sM + "suffix2");
        test("-84.0935228928", "" + sf_dM + s_l);
        test("-84.0935228928suffix", "" + sf_dM + s_l + "suffix");
        test("prefix-84.0suffix1935228928suffix2", "prefix" + sf_dM + "suffix1" + s_l + "suffix2");
        test("-84.0-8400", "" + sf_dM + sf_sM);
        test("-84.0-8400suffix", "" + sf_dM + sf_sM + "suffix");
        test("prefix-84.0suffix1-8400suffix2", "prefix" + sf_dM + "suffix1" + sf_sM + "suffix2");
        test("-84.0C(82)", "" + sf_dM + s_o);
        test("-84.0C(82)suffix", "" + sf_dM + s_o + "suffix");
        test("prefix-84.0suffix1C(82)suffix2", "prefix" + sf_dM + "suffix1" + s_o + "suffix2");
        test("-84.0null", "" + sf_dM + sf_oNtS);
        test("-84.0nullsuffix", "" + sf_dM + sf_oNtS + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + sf_oNtS + "suffix2");
        test("-84.0true", "" + sf_dM + s_bl);
        test("-84.0truesuffix", "" + sf_dM + s_bl + "suffix");
        test("prefix-84.0suffix1truesuffix2", "prefix" + sf_dM + "suffix1" + s_bl + "suffix2");
        test("-84.03900", "" + sf_dM + s_s);
        test("-84.03900suffix", "" + sf_dM + s_s + "suffix");
        test("prefix-84.0suffix13900suffix2", "prefix" + sf_dM + "suffix1" + s_s + "suffix2");
        test("-84.0null", "" + sf_dM + sf_oN);
        test("-84.0nullsuffix", "" + sf_dM + sf_oN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + sf_oN + "suffix2");
        test("-84.094000000", "" + sf_dM + f_I);
        test("-84.094000000suffix", "" + sf_dM + f_I + "suffix");
        test("prefix-84.0suffix194000000suffix2", "prefix" + sf_dM + "suffix1" + f_I + "suffix2");
        test("-84.0null", "" + sf_dM + f_IN);
        test("-84.0nullsuffix", "" + sf_dM + f_IN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + f_IN + "suffix2");
        test("-84.0true", "" + sf_dM + sf_bl);
        test("-84.0truesuffix", "" + sf_dM + sf_bl + "suffix");
        test("prefix-84.0suffix1truesuffix2", "prefix" + sf_dM + "suffix1" + sf_bl + "suffix2");
        test("-84.05500", "" + sf_dM + sf_s);
        test("-84.05500suffix", "" + sf_dM + sf_s + "suffix");
        test("prefix-84.0suffix15500suffix2", "prefix" + sf_dM + "suffix1" + sf_s + "suffix2");
        test("-84.0-2900", "" + sf_dM + s_sM);
        test("-84.0-2900suffix", "" + sf_dM + s_sM + "suffix");
        test("prefix-84.0suffix1-2900suffix2", "prefix" + sf_dM + "suffix1" + s_sM + "suffix2");
        test("-84.0-194313216", "" + sf_dM + sf_l);
        test("-84.0-194313216suffix", "" + sf_dM + sf_l + "suffix");
        test("prefix-84.0suffix1-194313216suffix2", "prefix" + sf_dM + "suffix1" + sf_l + "suffix2");
        test("-84.012", "" + sf_dM + s_strU1);
        test("-84.012suffix", "" + sf_dM + s_strU1 + "suffix");
        test("prefix-84.0suffix112suffix2", "prefix" + sf_dM + "suffix1" + s_strU1 + "suffix2");
        test("-84.0C(87)", "" + sf_dM + sf_o);
        test("-84.0C(87)suffix", "" + sf_dM + sf_o + "suffix");
        test("prefix-84.0suffix1C(87)suffix2", "prefix" + sf_dM + "suffix1" + sf_o + "suffix2");
        test("-84.091", "" + sf_dM + s_strU2);
        test("-84.091suffix", "" + sf_dM + s_strU2 + "suffix");
        test("prefix-84.0suffix191suffix2", "prefix" + sf_dM + "suffix1" + s_strU2 + "suffix2");
        test("-84.021", "" + sf_dM + f_strU1);
        test("-84.021suffix", "" + sf_dM + f_strU1 + "suffix");
        test("prefix-84.0suffix121suffix2", "prefix" + sf_dM + "suffix1" + f_strU1 + "suffix2");
        test("-84.018", "" + sf_dM + f_strU2);
        test("-84.018suffix", "" + sf_dM + f_strU2 + "suffix");
        test("prefix-84.0suffix118suffix2", "prefix" + sf_dM + "suffix1" + f_strU2 + "suffix2");
        test("-84.0null", "" + sf_dM + f_iAN);
        test("-84.0nullsuffix", "" + sf_dM + f_iAN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + f_iAN + "suffix2");
        test("-84.0null", "" + sf_dM + s_oN);
        test("-84.0nullsuffix", "" + sf_dM + s_oN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + s_oN + "suffix2");
        test("-84.0\u045180", "" + sf_dM + s_strU);
        test("-84.0\u045180suffix", "" + sf_dM + s_strU + "suffix");
        test("prefix-84.0suffix1\u045180suffix2", "prefix" + sf_dM + "suffix1" + s_strU + "suffix2");
        test("-84.0C", "" + sf_dM + sf_c);
        test("-84.0Csuffix", "" + sf_dM + sf_c + "suffix");
        test("prefix-84.0suffix1Csuffix2", "prefix" + sf_dM + "suffix1" + sf_c + "suffix2");
        test("-84.075", "" + sf_dM + sf_str);
        test("-84.075suffix", "" + sf_dM + sf_str + "suffix");
        test("prefix-84.0suffix175suffix2", "prefix" + sf_dM + "suffix1" + sf_str + "suffix2");
        test("-84.0-43", "" + sf_dM + s_bM);
        test("-84.0-43suffix", "" + sf_dM + s_bM + "suffix");
        test("prefix-84.0suffix1-43suffix2", "prefix" + sf_dM + "suffix1" + s_bM + "suffix2");
        test("-84.080", "" + sf_dM + sf_b);
        test("-84.080suffix", "" + sf_dM + sf_b + "suffix");
        test("prefix-84.0suffix180suffix2", "prefix" + sf_dM + "suffix1" + sf_b + "suffix2");
        test("-84.0null", "" + sf_dM + s_IN);
        test("-84.0nullsuffix", "" + sf_dM + s_IN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + s_IN + "suffix2");
        test("-84.0-52.0", "" + sf_dM + s_fM);
        test("-84.0-52.0suffix", "" + sf_dM + s_fM + "suffix");
        test("prefix-84.0suffix1-52.0suffix2", "prefix" + sf_dM + "suffix1" + s_fM + "suffix2");
        test("-84.075000000", "" + sf_dM + sf_i);
        test("-84.075000000suffix", "" + sf_dM + sf_i + "suffix");
        test("prefix-84.0suffix175000000suffix2", "prefix" + sf_dM + "suffix1" + sf_i + "suffix2");
        test("-84.044", "" + sf_dM + f_b);
        test("-84.044suffix", "" + sf_dM + f_b + "suffix");
        test("prefix-84.0suffix144suffix2", "prefix" + sf_dM + "suffix1" + f_b + "suffix2");
        test("-84.0-1705032704", "" + sf_dM + sf_lM);
        test("-84.0-1705032704suffix", "" + sf_dM + sf_lM + "suffix");
        test("prefix-84.0suffix1-1705032704suffix2", "prefix" + sf_dM + "suffix1" + sf_lM + "suffix2");
        test("-84.0null", "" + sf_dM + f_oAN);
        test("-84.0nullsuffix", "" + sf_dM + f_oAN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + f_oAN + "suffix2");
        test("-84.083.0", "" + sf_dM + f_d);
        test("-84.083.0suffix", "" + sf_dM + f_d + "suffix");
        test("prefix-84.0suffix183.0suffix2", "prefix" + sf_dM + "suffix1" + f_d + "suffix2");
        test("-84.0I", "" + sf_dM + f_c);
        test("-84.0Isuffix", "" + sf_dM + f_c + "suffix");
        test("prefix-84.0suffix1Isuffix2", "prefix" + sf_dM + "suffix1" + f_c + "suffix2");
        test("-84.094.0", "" + sf_dM + f_f);
        test("-84.094.0suffix", "" + sf_dM + f_f + "suffix");
        test("prefix-84.0suffix194.0suffix2", "prefix" + sf_dM + "suffix1" + f_f + "suffix2");
        test("-84.012.0", "" + sf_dM + sf_d);
        test("-84.012.0suffix", "" + sf_dM + sf_d + "suffix");
        test("prefix-84.0suffix112.0suffix2", "prefix" + sf_dM + "suffix1" + sf_d + "suffix2");
        test("-84.0-99.0", "" + sf_dM + f_dM);
        test("-84.0-99.0suffix", "" + sf_dM + f_dM + "suffix");
        test("prefix-84.0suffix1-99.0suffix2", "prefix" + sf_dM + "suffix1" + f_dM + "suffix2");
        test("-84.017.0", "" + sf_dM + sf_f);
        test("-84.017.0suffix", "" + sf_dM + sf_f + "suffix");
        test("prefix-84.0suffix117.0suffix2", "prefix" + sf_dM + "suffix1" + sf_f + "suffix2");
        test("-84.0-84.0", "" + sf_dM + sf_dM);
        test("-84.0-84.0suffix", "" + sf_dM + sf_dM + "suffix");
        test("prefix-84.0suffix1-84.0suffix2", "prefix" + sf_dM + "suffix1" + sf_dM + "suffix2");
        test("-84.058000000", "" + sf_dM + f_i);
        test("-84.058000000suffix", "" + sf_dM + f_i + "suffix");
        test("prefix-84.0suffix158000000suffix2", "prefix" + sf_dM + "suffix1" + f_i + "suffix2");
        test("-84.0-55000000", "" + sf_dM + f_iM);
        test("-84.0-55000000suffix", "" + sf_dM + f_iM + "suffix");
        test("prefix-84.0suffix1-55000000suffix2", "prefix" + sf_dM + "suffix1" + f_iM + "suffix2");
        test("-84.01460392448", "" + sf_dM + f_l);
        test("-84.01460392448suffix", "" + sf_dM + f_l + "suffix");
        test("prefix-84.0suffix11460392448suffix2", "prefix" + sf_dM + "suffix1" + f_l + "suffix2");
        test("-84.0C(70)", "" + sf_dM + f_o);
        test("-84.0C(70)suffix", "" + sf_dM + f_o + "suffix");
        test("prefix-84.0suffix1C(70)suffix2", "prefix" + sf_dM + "suffix1" + f_o + "suffix2");
        test("-84.0\u04511", "" + sf_dM + sf_strU);
        test("-84.0\u04511suffix", "" + sf_dM + sf_strU + "suffix");
        test("prefix-84.0suffix1\u04511suffix2", "prefix" + sf_dM + "suffix1" + sf_strU + "suffix2");
        test("-84.08000", "" + sf_dM + f_s);
        test("-84.08000suffix", "" + sf_dM + f_s + "suffix");
        test("prefix-84.0suffix18000suffix2", "prefix" + sf_dM + "suffix1" + f_s + "suffix2");
        test("-84.018", "" + sf_dM + s_str);
        test("-84.018suffix", "" + sf_dM + s_str + "suffix");
        test("prefix-84.0suffix118suffix2", "prefix" + sf_dM + "suffix1" + s_str + "suffix2");
        test("-84.0-1000000", "" + sf_dM + s_iM);
        test("-84.0-1000000suffix", "" + sf_dM + s_iM + "suffix");
        test("prefix-84.0suffix1-1000000suffix2", "prefix" + sf_dM + "suffix1" + s_iM + "suffix2");
        test("-84.01000000", "" + sf_dM + sf_I);
        test("-84.01000000suffix", "" + sf_dM + sf_I + "suffix");
        test("prefix-84.0suffix11000000suffix2", "prefix" + sf_dM + "suffix1" + sf_I + "suffix2");
        test("-84.0null", "" + sf_dM + f_oNtS);
        test("-84.0nullsuffix", "" + sf_dM + f_oNtS + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + f_oNtS + "suffix2");
        test("-84.0false", "" + sf_dM + f_bl);
        test("-84.0falsesuffix", "" + sf_dM + f_bl + "suffix");
        test("prefix-84.0suffix1falsesuffix2", "prefix" + sf_dM + "suffix1" + f_bl + "suffix2");
        test("-84.0null", "" + sf_dM + sf_iAN);
        test("-84.0nullsuffix", "" + sf_dM + sf_iAN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + sf_iAN + "suffix2");
        test("-84.0-2000000", "" + sf_dM + sf_iM);
        test("-84.0-2000000suffix", "" + sf_dM + sf_iM + "suffix");
        test("prefix-84.0suffix1-2000000suffix2", "prefix" + sf_dM + "suffix1" + sf_iM + "suffix2");
        test("-84.0-820130816", "" + sf_dM + f_lM);
        test("-84.0-820130816suffix", "" + sf_dM + f_lM + "suffix");
        test("prefix-84.0suffix1-820130816suffix2", "prefix" + sf_dM + "suffix1" + f_lM + "suffix2");
        test("-84.0null", "" + sf_dM + sf_oAN);
        test("-84.0nullsuffix", "" + sf_dM + sf_oAN + "suffix");
        test("prefix-84.0suffix1nullsuffix2", "prefix" + sf_dM + "suffix1" + sf_oAN + "suffix2");
        test("-84.025000000", "" + sf_dM + s_I);
        test("-84.025000000suffix", "" + sf_dM + s_I + "suffix");
        test("prefix-84.0suffix125000000suffix2", "prefix" + sf_dM + "suffix1" + s_I + "suffix2");
        test("58000000-96.0", "" + f_i + s_dM);
        test("58000000-96.0suffix", "" + f_i + s_dM + "suffix");
        test("prefix58000000suffix1-96.0suffix2", "prefix" + f_i + "suffix1" + s_dM + "suffix2");
        test("58000000null", "" + f_i + s_oNtS);
        test("58000000nullsuffix", "" + f_i + s_oNtS + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + s_oNtS + "suffix2");
        test("58000000\u045176", "" + f_i + f_strU);
        test("58000000\u045176suffix", "" + f_i + f_strU + "suffix");
        test("prefix58000000suffix1\u045176suffix2", "prefix" + f_i + "suffix1" + f_strU + "suffix2");
        test("5800000092", "" + f_i + sf_strU2);
        test("5800000092suffix", "" + f_i + sf_strU2 + "suffix");
        test("prefix58000000suffix192suffix2", "prefix" + f_i + "suffix1" + sf_strU2 + "suffix2");
        test("5800000051", "" + f_i + sf_strU1);
        test("5800000051suffix", "" + f_i + sf_strU1 + "suffix");
        test("prefix58000000suffix151suffix2", "prefix" + f_i + "suffix1" + sf_strU1 + "suffix2");
        test("58000000null", "" + f_i + s_iAN);
        test("58000000nullsuffix", "" + f_i + s_iAN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + s_iAN + "suffix2");
        test("58000000-54", "" + f_i + f_bM);
        test("58000000-54suffix", "" + f_i + f_bM + "suffix");
        test("prefix58000000suffix1-54suffix2", "prefix" + f_i + "suffix1" + f_bM + "suffix2");
        test("58000000-87.0", "" + f_i + f_fM);
        test("58000000-87.0suffix", "" + f_i + f_fM + "suffix");
        test("prefix58000000suffix1-87.0suffix2", "prefix" + f_i + "suffix1" + f_fM + "suffix2");
        test("58000000null", "" + f_i + s_oAN);
        test("58000000nullsuffix", "" + f_i + s_oAN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + s_oAN + "suffix2");
        test("5800000019", "" + f_i + f_str);
        test("5800000019suffix", "" + f_i + f_str + "suffix");
        test("prefix58000000suffix119suffix2", "prefix" + f_i + "suffix1" + f_str + "suffix2");
        test("58000000-41", "" + f_i + sf_bM);
        test("58000000-41suffix", "" + f_i + sf_bM + "suffix");
        test("prefix58000000suffix1-41suffix2", "prefix" + f_i + "suffix1" + sf_bM + "suffix2");
        test("58000000null", "" + f_i + sf_IN);
        test("58000000nullsuffix", "" + f_i + sf_IN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + sf_IN + "suffix2");
        test("58000000T", "" + f_i + s_c);
        test("58000000Tsuffix", "" + f_i + s_c + "suffix");
        test("prefix58000000suffix1Tsuffix2", "prefix" + f_i + "suffix1" + s_c + "suffix2");
        test("58000000-42.0", "" + f_i + sf_fM);
        test("58000000-42.0suffix", "" + f_i + sf_fM + "suffix");
        test("prefix58000000suffix1-42.0suffix2", "prefix" + f_i + "suffix1" + sf_fM + "suffix2");
        test("5800000025", "" + f_i + s_b);
        test("5800000025suffix", "" + f_i + s_b + "suffix");
        test("prefix58000000suffix125suffix2", "prefix" + f_i + "suffix1" + s_b + "suffix2");
        test("58000000null", "" + f_i + f_oN);
        test("58000000nullsuffix", "" + f_i + f_oN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + f_oN + "suffix2");
        test("58000000-1410065408", "" + f_i + s_lM);
        test("58000000-1410065408suffix", "" + f_i + s_lM + "suffix");
        test("prefix58000000suffix1-1410065408suffix2", "prefix" + f_i + "suffix1" + s_lM + "suffix2");
        test("580000008.0", "" + f_i + s_d);
        test("580000008.0suffix", "" + f_i + s_d + "suffix");
        test("prefix58000000suffix18.0suffix2", "prefix" + f_i + "suffix1" + s_d + "suffix2");
        test("5800000055.0", "" + f_i + s_f);
        test("5800000055.0suffix", "" + f_i + s_f + "suffix");
        test("prefix58000000suffix155.0suffix2", "prefix" + f_i + "suffix1" + s_f + "suffix2");
        test("5800000097000000", "" + f_i + s_i);
        test("5800000097000000suffix", "" + f_i + s_i + "suffix");
        test("prefix58000000suffix197000000suffix2", "prefix" + f_i + "suffix1" + s_i + "suffix2");
        test("58000000-9900", "" + f_i + f_sM);
        test("58000000-9900suffix", "" + f_i + f_sM + "suffix");
        test("prefix58000000suffix1-9900suffix2", "prefix" + f_i + "suffix1" + f_sM + "suffix2");
        test("58000000935228928", "" + f_i + s_l);
        test("58000000935228928suffix", "" + f_i + s_l + "suffix");
        test("prefix58000000suffix1935228928suffix2", "prefix" + f_i + "suffix1" + s_l + "suffix2");
        test("58000000-8400", "" + f_i + sf_sM);
        test("58000000-8400suffix", "" + f_i + sf_sM + "suffix");
        test("prefix58000000suffix1-8400suffix2", "prefix" + f_i + "suffix1" + sf_sM + "suffix2");
        test("58000000C(82)", "" + f_i + s_o);
        test("58000000C(82)suffix", "" + f_i + s_o + "suffix");
        test("prefix58000000suffix1C(82)suffix2", "prefix" + f_i + "suffix1" + s_o + "suffix2");
        test("58000000null", "" + f_i + sf_oNtS);
        test("58000000nullsuffix", "" + f_i + sf_oNtS + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + sf_oNtS + "suffix2");
        test("58000000true", "" + f_i + s_bl);
        test("58000000truesuffix", "" + f_i + s_bl + "suffix");
        test("prefix58000000suffix1truesuffix2", "prefix" + f_i + "suffix1" + s_bl + "suffix2");
        test("580000003900", "" + f_i + s_s);
        test("580000003900suffix", "" + f_i + s_s + "suffix");
        test("prefix58000000suffix13900suffix2", "prefix" + f_i + "suffix1" + s_s + "suffix2");
        test("58000000null", "" + f_i + sf_oN);
        test("58000000nullsuffix", "" + f_i + sf_oN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + sf_oN + "suffix2");
        test("5800000094000000", "" + f_i + f_I);
        test("5800000094000000suffix", "" + f_i + f_I + "suffix");
        test("prefix58000000suffix194000000suffix2", "prefix" + f_i + "suffix1" + f_I + "suffix2");
        test("58000000null", "" + f_i + f_IN);
        test("58000000nullsuffix", "" + f_i + f_IN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + f_IN + "suffix2");
        test("58000000true", "" + f_i + sf_bl);
        test("58000000truesuffix", "" + f_i + sf_bl + "suffix");
        test("prefix58000000suffix1truesuffix2", "prefix" + f_i + "suffix1" + sf_bl + "suffix2");
        test("580000005500", "" + f_i + sf_s);
        test("580000005500suffix", "" + f_i + sf_s + "suffix");
        test("prefix58000000suffix15500suffix2", "prefix" + f_i + "suffix1" + sf_s + "suffix2");
        test("58000000-2900", "" + f_i + s_sM);
        test("58000000-2900suffix", "" + f_i + s_sM + "suffix");
        test("prefix58000000suffix1-2900suffix2", "prefix" + f_i + "suffix1" + s_sM + "suffix2");
        test("58000000-194313216", "" + f_i + sf_l);
        test("58000000-194313216suffix", "" + f_i + sf_l + "suffix");
        test("prefix58000000suffix1-194313216suffix2", "prefix" + f_i + "suffix1" + sf_l + "suffix2");
        test("5800000012", "" + f_i + s_strU1);
        test("5800000012suffix", "" + f_i + s_strU1 + "suffix");
        test("prefix58000000suffix112suffix2", "prefix" + f_i + "suffix1" + s_strU1 + "suffix2");
        test("58000000C(87)", "" + f_i + sf_o);
        test("58000000C(87)suffix", "" + f_i + sf_o + "suffix");
        test("prefix58000000suffix1C(87)suffix2", "prefix" + f_i + "suffix1" + sf_o + "suffix2");
        test("5800000091", "" + f_i + s_strU2);
        test("5800000091suffix", "" + f_i + s_strU2 + "suffix");
        test("prefix58000000suffix191suffix2", "prefix" + f_i + "suffix1" + s_strU2 + "suffix2");
        test("5800000021", "" + f_i + f_strU1);
        test("5800000021suffix", "" + f_i + f_strU1 + "suffix");
        test("prefix58000000suffix121suffix2", "prefix" + f_i + "suffix1" + f_strU1 + "suffix2");
        test("5800000018", "" + f_i + f_strU2);
        test("5800000018suffix", "" + f_i + f_strU2 + "suffix");
        test("prefix58000000suffix118suffix2", "prefix" + f_i + "suffix1" + f_strU2 + "suffix2");
        test("58000000null", "" + f_i + f_iAN);
        test("58000000nullsuffix", "" + f_i + f_iAN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + f_iAN + "suffix2");
        test("58000000null", "" + f_i + s_oN);
        test("58000000nullsuffix", "" + f_i + s_oN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + s_oN + "suffix2");
        test("58000000\u045180", "" + f_i + s_strU);
        test("58000000\u045180suffix", "" + f_i + s_strU + "suffix");
        test("prefix58000000suffix1\u045180suffix2", "prefix" + f_i + "suffix1" + s_strU + "suffix2");
        test("58000000C", "" + f_i + sf_c);
        test("58000000Csuffix", "" + f_i + sf_c + "suffix");
        test("prefix58000000suffix1Csuffix2", "prefix" + f_i + "suffix1" + sf_c + "suffix2");
        test("5800000075", "" + f_i + sf_str);
        test("5800000075suffix", "" + f_i + sf_str + "suffix");
        test("prefix58000000suffix175suffix2", "prefix" + f_i + "suffix1" + sf_str + "suffix2");
        test("58000000-43", "" + f_i + s_bM);
        test("58000000-43suffix", "" + f_i + s_bM + "suffix");
        test("prefix58000000suffix1-43suffix2", "prefix" + f_i + "suffix1" + s_bM + "suffix2");
        test("5800000080", "" + f_i + sf_b);
        test("5800000080suffix", "" + f_i + sf_b + "suffix");
        test("prefix58000000suffix180suffix2", "prefix" + f_i + "suffix1" + sf_b + "suffix2");
        test("58000000null", "" + f_i + s_IN);
        test("58000000nullsuffix", "" + f_i + s_IN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + s_IN + "suffix2");
        test("58000000-52.0", "" + f_i + s_fM);
        test("58000000-52.0suffix", "" + f_i + s_fM + "suffix");
        test("prefix58000000suffix1-52.0suffix2", "prefix" + f_i + "suffix1" + s_fM + "suffix2");
        test("5800000075000000", "" + f_i + sf_i);
        test("5800000075000000suffix", "" + f_i + sf_i + "suffix");
        test("prefix58000000suffix175000000suffix2", "prefix" + f_i + "suffix1" + sf_i + "suffix2");
        test("5800000044", "" + f_i + f_b);
        test("5800000044suffix", "" + f_i + f_b + "suffix");
        test("prefix58000000suffix144suffix2", "prefix" + f_i + "suffix1" + f_b + "suffix2");
        test("58000000-1705032704", "" + f_i + sf_lM);
        test("58000000-1705032704suffix", "" + f_i + sf_lM + "suffix");
        test("prefix58000000suffix1-1705032704suffix2", "prefix" + f_i + "suffix1" + sf_lM + "suffix2");
        test("58000000null", "" + f_i + f_oAN);
        test("58000000nullsuffix", "" + f_i + f_oAN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + f_oAN + "suffix2");
        test("5800000083.0", "" + f_i + f_d);
        test("5800000083.0suffix", "" + f_i + f_d + "suffix");
        test("prefix58000000suffix183.0suffix2", "prefix" + f_i + "suffix1" + f_d + "suffix2");
        test("58000000I", "" + f_i + f_c);
        test("58000000Isuffix", "" + f_i + f_c + "suffix");
        test("prefix58000000suffix1Isuffix2", "prefix" + f_i + "suffix1" + f_c + "suffix2");
        test("5800000094.0", "" + f_i + f_f);
        test("5800000094.0suffix", "" + f_i + f_f + "suffix");
        test("prefix58000000suffix194.0suffix2", "prefix" + f_i + "suffix1" + f_f + "suffix2");
        test("5800000012.0", "" + f_i + sf_d);
        test("5800000012.0suffix", "" + f_i + sf_d + "suffix");
        test("prefix58000000suffix112.0suffix2", "prefix" + f_i + "suffix1" + sf_d + "suffix2");
        test("58000000-99.0", "" + f_i + f_dM);
        test("58000000-99.0suffix", "" + f_i + f_dM + "suffix");
        test("prefix58000000suffix1-99.0suffix2", "prefix" + f_i + "suffix1" + f_dM + "suffix2");
        test("5800000017.0", "" + f_i + sf_f);
        test("5800000017.0suffix", "" + f_i + sf_f + "suffix");
        test("prefix58000000suffix117.0suffix2", "prefix" + f_i + "suffix1" + sf_f + "suffix2");
        test("58000000-84.0", "" + f_i + sf_dM);
        test("58000000-84.0suffix", "" + f_i + sf_dM + "suffix");
        test("prefix58000000suffix1-84.0suffix2", "prefix" + f_i + "suffix1" + sf_dM + "suffix2");
        test("5800000058000000", "" + f_i + f_i);
        test("5800000058000000suffix", "" + f_i + f_i + "suffix");
        test("prefix58000000suffix158000000suffix2", "prefix" + f_i + "suffix1" + f_i + "suffix2");
        test("58000000-55000000", "" + f_i + f_iM);
        test("58000000-55000000suffix", "" + f_i + f_iM + "suffix");
        test("prefix58000000suffix1-55000000suffix2", "prefix" + f_i + "suffix1" + f_iM + "suffix2");
        test("580000001460392448", "" + f_i + f_l);
        test("580000001460392448suffix", "" + f_i + f_l + "suffix");
        test("prefix58000000suffix11460392448suffix2", "prefix" + f_i + "suffix1" + f_l + "suffix2");
        test("58000000C(70)", "" + f_i + f_o);
        test("58000000C(70)suffix", "" + f_i + f_o + "suffix");
        test("prefix58000000suffix1C(70)suffix2", "prefix" + f_i + "suffix1" + f_o + "suffix2");
        test("58000000\u04511", "" + f_i + sf_strU);
        test("58000000\u04511suffix", "" + f_i + sf_strU + "suffix");
        test("prefix58000000suffix1\u04511suffix2", "prefix" + f_i + "suffix1" + sf_strU + "suffix2");
        test("580000008000", "" + f_i + f_s);
        test("580000008000suffix", "" + f_i + f_s + "suffix");
        test("prefix58000000suffix18000suffix2", "prefix" + f_i + "suffix1" + f_s + "suffix2");
        test("5800000018", "" + f_i + s_str);
        test("5800000018suffix", "" + f_i + s_str + "suffix");
        test("prefix58000000suffix118suffix2", "prefix" + f_i + "suffix1" + s_str + "suffix2");
        test("58000000-1000000", "" + f_i + s_iM);
        test("58000000-1000000suffix", "" + f_i + s_iM + "suffix");
        test("prefix58000000suffix1-1000000suffix2", "prefix" + f_i + "suffix1" + s_iM + "suffix2");
        test("580000001000000", "" + f_i + sf_I);
        test("580000001000000suffix", "" + f_i + sf_I + "suffix");
        test("prefix58000000suffix11000000suffix2", "prefix" + f_i + "suffix1" + sf_I + "suffix2");
        test("58000000null", "" + f_i + f_oNtS);
        test("58000000nullsuffix", "" + f_i + f_oNtS + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + f_oNtS + "suffix2");
        test("58000000false", "" + f_i + f_bl);
        test("58000000falsesuffix", "" + f_i + f_bl + "suffix");
        test("prefix58000000suffix1falsesuffix2", "prefix" + f_i + "suffix1" + f_bl + "suffix2");
        test("58000000null", "" + f_i + sf_iAN);
        test("58000000nullsuffix", "" + f_i + sf_iAN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + sf_iAN + "suffix2");
        test("58000000-2000000", "" + f_i + sf_iM);
        test("58000000-2000000suffix", "" + f_i + sf_iM + "suffix");
        test("prefix58000000suffix1-2000000suffix2", "prefix" + f_i + "suffix1" + sf_iM + "suffix2");
        test("58000000-820130816", "" + f_i + f_lM);
        test("58000000-820130816suffix", "" + f_i + f_lM + "suffix");
        test("prefix58000000suffix1-820130816suffix2", "prefix" + f_i + "suffix1" + f_lM + "suffix2");
        test("58000000null", "" + f_i + sf_oAN);
        test("58000000nullsuffix", "" + f_i + sf_oAN + "suffix");
        test("prefix58000000suffix1nullsuffix2", "prefix" + f_i + "suffix1" + sf_oAN + "suffix2");
        test("5800000025000000", "" + f_i + s_I);
        test("5800000025000000suffix", "" + f_i + s_I + "suffix");
        test("prefix58000000suffix125000000suffix2", "prefix" + f_i + "suffix1" + s_I + "suffix2");
        test("-55000000-96.0", "" + f_iM + s_dM);
        test("-55000000-96.0suffix", "" + f_iM + s_dM + "suffix");
        test("prefix-55000000suffix1-96.0suffix2", "prefix" + f_iM + "suffix1" + s_dM + "suffix2");
        test("-55000000null", "" + f_iM + s_oNtS);
        test("-55000000nullsuffix", "" + f_iM + s_oNtS + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + s_oNtS + "suffix2");
        test("-55000000\u045176", "" + f_iM + f_strU);
        test("-55000000\u045176suffix", "" + f_iM + f_strU + "suffix");
        test("prefix-55000000suffix1\u045176suffix2", "prefix" + f_iM + "suffix1" + f_strU + "suffix2");
        test("-5500000092", "" + f_iM + sf_strU2);
        test("-5500000092suffix", "" + f_iM + sf_strU2 + "suffix");
        test("prefix-55000000suffix192suffix2", "prefix" + f_iM + "suffix1" + sf_strU2 + "suffix2");
        test("-5500000051", "" + f_iM + sf_strU1);
        test("-5500000051suffix", "" + f_iM + sf_strU1 + "suffix");
        test("prefix-55000000suffix151suffix2", "prefix" + f_iM + "suffix1" + sf_strU1 + "suffix2");
        test("-55000000null", "" + f_iM + s_iAN);
        test("-55000000nullsuffix", "" + f_iM + s_iAN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + s_iAN + "suffix2");
        test("-55000000-54", "" + f_iM + f_bM);
        test("-55000000-54suffix", "" + f_iM + f_bM + "suffix");
        test("prefix-55000000suffix1-54suffix2", "prefix" + f_iM + "suffix1" + f_bM + "suffix2");
        test("-55000000-87.0", "" + f_iM + f_fM);
        test("-55000000-87.0suffix", "" + f_iM + f_fM + "suffix");
        test("prefix-55000000suffix1-87.0suffix2", "prefix" + f_iM + "suffix1" + f_fM + "suffix2");
        test("-55000000null", "" + f_iM + s_oAN);
        test("-55000000nullsuffix", "" + f_iM + s_oAN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + s_oAN + "suffix2");
        test("-5500000019", "" + f_iM + f_str);
        test("-5500000019suffix", "" + f_iM + f_str + "suffix");
        test("prefix-55000000suffix119suffix2", "prefix" + f_iM + "suffix1" + f_str + "suffix2");
        test("-55000000-41", "" + f_iM + sf_bM);
        test("-55000000-41suffix", "" + f_iM + sf_bM + "suffix");
        test("prefix-55000000suffix1-41suffix2", "prefix" + f_iM + "suffix1" + sf_bM + "suffix2");
        test("-55000000null", "" + f_iM + sf_IN);
        test("-55000000nullsuffix", "" + f_iM + sf_IN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + sf_IN + "suffix2");
        test("-55000000T", "" + f_iM + s_c);
        test("-55000000Tsuffix", "" + f_iM + s_c + "suffix");
        test("prefix-55000000suffix1Tsuffix2", "prefix" + f_iM + "suffix1" + s_c + "suffix2");
        test("-55000000-42.0", "" + f_iM + sf_fM);
        test("-55000000-42.0suffix", "" + f_iM + sf_fM + "suffix");
        test("prefix-55000000suffix1-42.0suffix2", "prefix" + f_iM + "suffix1" + sf_fM + "suffix2");
        test("-5500000025", "" + f_iM + s_b);
        test("-5500000025suffix", "" + f_iM + s_b + "suffix");
        test("prefix-55000000suffix125suffix2", "prefix" + f_iM + "suffix1" + s_b + "suffix2");
        test("-55000000null", "" + f_iM + f_oN);
        test("-55000000nullsuffix", "" + f_iM + f_oN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + f_oN + "suffix2");
        test("-55000000-1410065408", "" + f_iM + s_lM);
        test("-55000000-1410065408suffix", "" + f_iM + s_lM + "suffix");
        test("prefix-55000000suffix1-1410065408suffix2", "prefix" + f_iM + "suffix1" + s_lM + "suffix2");
        test("-550000008.0", "" + f_iM + s_d);
        test("-550000008.0suffix", "" + f_iM + s_d + "suffix");
        test("prefix-55000000suffix18.0suffix2", "prefix" + f_iM + "suffix1" + s_d + "suffix2");
        test("-5500000055.0", "" + f_iM + s_f);
        test("-5500000055.0suffix", "" + f_iM + s_f + "suffix");
        test("prefix-55000000suffix155.0suffix2", "prefix" + f_iM + "suffix1" + s_f + "suffix2");
        test("-5500000097000000", "" + f_iM + s_i);
        test("-5500000097000000suffix", "" + f_iM + s_i + "suffix");
        test("prefix-55000000suffix197000000suffix2", "prefix" + f_iM + "suffix1" + s_i + "suffix2");
        test("-55000000-9900", "" + f_iM + f_sM);
        test("-55000000-9900suffix", "" + f_iM + f_sM + "suffix");
        test("prefix-55000000suffix1-9900suffix2", "prefix" + f_iM + "suffix1" + f_sM + "suffix2");
        test("-55000000935228928", "" + f_iM + s_l);
        test("-55000000935228928suffix", "" + f_iM + s_l + "suffix");
        test("prefix-55000000suffix1935228928suffix2", "prefix" + f_iM + "suffix1" + s_l + "suffix2");
        test("-55000000-8400", "" + f_iM + sf_sM);
        test("-55000000-8400suffix", "" + f_iM + sf_sM + "suffix");
        test("prefix-55000000suffix1-8400suffix2", "prefix" + f_iM + "suffix1" + sf_sM + "suffix2");
        test("-55000000C(82)", "" + f_iM + s_o);
        test("-55000000C(82)suffix", "" + f_iM + s_o + "suffix");
        test("prefix-55000000suffix1C(82)suffix2", "prefix" + f_iM + "suffix1" + s_o + "suffix2");
        test("-55000000null", "" + f_iM + sf_oNtS);
        test("-55000000nullsuffix", "" + f_iM + sf_oNtS + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + sf_oNtS + "suffix2");
        test("-55000000true", "" + f_iM + s_bl);
        test("-55000000truesuffix", "" + f_iM + s_bl + "suffix");
        test("prefix-55000000suffix1truesuffix2", "prefix" + f_iM + "suffix1" + s_bl + "suffix2");
        test("-550000003900", "" + f_iM + s_s);
        test("-550000003900suffix", "" + f_iM + s_s + "suffix");
        test("prefix-55000000suffix13900suffix2", "prefix" + f_iM + "suffix1" + s_s + "suffix2");
        test("-55000000null", "" + f_iM + sf_oN);
        test("-55000000nullsuffix", "" + f_iM + sf_oN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + sf_oN + "suffix2");
        test("-5500000094000000", "" + f_iM + f_I);
        test("-5500000094000000suffix", "" + f_iM + f_I + "suffix");
        test("prefix-55000000suffix194000000suffix2", "prefix" + f_iM + "suffix1" + f_I + "suffix2");
        test("-55000000null", "" + f_iM + f_IN);
        test("-55000000nullsuffix", "" + f_iM + f_IN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + f_IN + "suffix2");
        test("-55000000true", "" + f_iM + sf_bl);
        test("-55000000truesuffix", "" + f_iM + sf_bl + "suffix");
        test("prefix-55000000suffix1truesuffix2", "prefix" + f_iM + "suffix1" + sf_bl + "suffix2");
        test("-550000005500", "" + f_iM + sf_s);
        test("-550000005500suffix", "" + f_iM + sf_s + "suffix");
        test("prefix-55000000suffix15500suffix2", "prefix" + f_iM + "suffix1" + sf_s + "suffix2");
        test("-55000000-2900", "" + f_iM + s_sM);
        test("-55000000-2900suffix", "" + f_iM + s_sM + "suffix");
        test("prefix-55000000suffix1-2900suffix2", "prefix" + f_iM + "suffix1" + s_sM + "suffix2");
        test("-55000000-194313216", "" + f_iM + sf_l);
        test("-55000000-194313216suffix", "" + f_iM + sf_l + "suffix");
        test("prefix-55000000suffix1-194313216suffix2", "prefix" + f_iM + "suffix1" + sf_l + "suffix2");
        test("-5500000012", "" + f_iM + s_strU1);
        test("-5500000012suffix", "" + f_iM + s_strU1 + "suffix");
        test("prefix-55000000suffix112suffix2", "prefix" + f_iM + "suffix1" + s_strU1 + "suffix2");
        test("-55000000C(87)", "" + f_iM + sf_o);
        test("-55000000C(87)suffix", "" + f_iM + sf_o + "suffix");
        test("prefix-55000000suffix1C(87)suffix2", "prefix" + f_iM + "suffix1" + sf_o + "suffix2");
        test("-5500000091", "" + f_iM + s_strU2);
        test("-5500000091suffix", "" + f_iM + s_strU2 + "suffix");
        test("prefix-55000000suffix191suffix2", "prefix" + f_iM + "suffix1" + s_strU2 + "suffix2");
        test("-5500000021", "" + f_iM + f_strU1);
        test("-5500000021suffix", "" + f_iM + f_strU1 + "suffix");
        test("prefix-55000000suffix121suffix2", "prefix" + f_iM + "suffix1" + f_strU1 + "suffix2");
        test("-5500000018", "" + f_iM + f_strU2);
        test("-5500000018suffix", "" + f_iM + f_strU2 + "suffix");
        test("prefix-55000000suffix118suffix2", "prefix" + f_iM + "suffix1" + f_strU2 + "suffix2");
        test("-55000000null", "" + f_iM + f_iAN);
        test("-55000000nullsuffix", "" + f_iM + f_iAN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + f_iAN + "suffix2");
        test("-55000000null", "" + f_iM + s_oN);
        test("-55000000nullsuffix", "" + f_iM + s_oN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + s_oN + "suffix2");
        test("-55000000\u045180", "" + f_iM + s_strU);
        test("-55000000\u045180suffix", "" + f_iM + s_strU + "suffix");
        test("prefix-55000000suffix1\u045180suffix2", "prefix" + f_iM + "suffix1" + s_strU + "suffix2");
        test("-55000000C", "" + f_iM + sf_c);
        test("-55000000Csuffix", "" + f_iM + sf_c + "suffix");
        test("prefix-55000000suffix1Csuffix2", "prefix" + f_iM + "suffix1" + sf_c + "suffix2");
        test("-5500000075", "" + f_iM + sf_str);
        test("-5500000075suffix", "" + f_iM + sf_str + "suffix");
        test("prefix-55000000suffix175suffix2", "prefix" + f_iM + "suffix1" + sf_str + "suffix2");
        test("-55000000-43", "" + f_iM + s_bM);
        test("-55000000-43suffix", "" + f_iM + s_bM + "suffix");
        test("prefix-55000000suffix1-43suffix2", "prefix" + f_iM + "suffix1" + s_bM + "suffix2");
        test("-5500000080", "" + f_iM + sf_b);
        test("-5500000080suffix", "" + f_iM + sf_b + "suffix");
        test("prefix-55000000suffix180suffix2", "prefix" + f_iM + "suffix1" + sf_b + "suffix2");
        test("-55000000null", "" + f_iM + s_IN);
        test("-55000000nullsuffix", "" + f_iM + s_IN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + s_IN + "suffix2");
        test("-55000000-52.0", "" + f_iM + s_fM);
        test("-55000000-52.0suffix", "" + f_iM + s_fM + "suffix");
        test("prefix-55000000suffix1-52.0suffix2", "prefix" + f_iM + "suffix1" + s_fM + "suffix2");
        test("-5500000075000000", "" + f_iM + sf_i);
        test("-5500000075000000suffix", "" + f_iM + sf_i + "suffix");
        test("prefix-55000000suffix175000000suffix2", "prefix" + f_iM + "suffix1" + sf_i + "suffix2");
        test("-5500000044", "" + f_iM + f_b);
        test("-5500000044suffix", "" + f_iM + f_b + "suffix");
        test("prefix-55000000suffix144suffix2", "prefix" + f_iM + "suffix1" + f_b + "suffix2");
        test("-55000000-1705032704", "" + f_iM + sf_lM);
        test("-55000000-1705032704suffix", "" + f_iM + sf_lM + "suffix");
        test("prefix-55000000suffix1-1705032704suffix2", "prefix" + f_iM + "suffix1" + sf_lM + "suffix2");
        test("-55000000null", "" + f_iM + f_oAN);
        test("-55000000nullsuffix", "" + f_iM + f_oAN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + f_oAN + "suffix2");
        test("-5500000083.0", "" + f_iM + f_d);
        test("-5500000083.0suffix", "" + f_iM + f_d + "suffix");
        test("prefix-55000000suffix183.0suffix2", "prefix" + f_iM + "suffix1" + f_d + "suffix2");
        test("-55000000I", "" + f_iM + f_c);
        test("-55000000Isuffix", "" + f_iM + f_c + "suffix");
        test("prefix-55000000suffix1Isuffix2", "prefix" + f_iM + "suffix1" + f_c + "suffix2");
        test("-5500000094.0", "" + f_iM + f_f);
        test("-5500000094.0suffix", "" + f_iM + f_f + "suffix");
        test("prefix-55000000suffix194.0suffix2", "prefix" + f_iM + "suffix1" + f_f + "suffix2");
        test("-5500000012.0", "" + f_iM + sf_d);
        test("-5500000012.0suffix", "" + f_iM + sf_d + "suffix");
        test("prefix-55000000suffix112.0suffix2", "prefix" + f_iM + "suffix1" + sf_d + "suffix2");
        test("-55000000-99.0", "" + f_iM + f_dM);
        test("-55000000-99.0suffix", "" + f_iM + f_dM + "suffix");
        test("prefix-55000000suffix1-99.0suffix2", "prefix" + f_iM + "suffix1" + f_dM + "suffix2");
        test("-5500000017.0", "" + f_iM + sf_f);
        test("-5500000017.0suffix", "" + f_iM + sf_f + "suffix");
        test("prefix-55000000suffix117.0suffix2", "prefix" + f_iM + "suffix1" + sf_f + "suffix2");
        test("-55000000-84.0", "" + f_iM + sf_dM);
        test("-55000000-84.0suffix", "" + f_iM + sf_dM + "suffix");
        test("prefix-55000000suffix1-84.0suffix2", "prefix" + f_iM + "suffix1" + sf_dM + "suffix2");
        test("-5500000058000000", "" + f_iM + f_i);
        test("-5500000058000000suffix", "" + f_iM + f_i + "suffix");
        test("prefix-55000000suffix158000000suffix2", "prefix" + f_iM + "suffix1" + f_i + "suffix2");
        test("-55000000-55000000", "" + f_iM + f_iM);
        test("-55000000-55000000suffix", "" + f_iM + f_iM + "suffix");
        test("prefix-55000000suffix1-55000000suffix2", "prefix" + f_iM + "suffix1" + f_iM + "suffix2");
        test("-550000001460392448", "" + f_iM + f_l);
        test("-550000001460392448suffix", "" + f_iM + f_l + "suffix");
        test("prefix-55000000suffix11460392448suffix2", "prefix" + f_iM + "suffix1" + f_l + "suffix2");
        test("-55000000C(70)", "" + f_iM + f_o);
        test("-55000000C(70)suffix", "" + f_iM + f_o + "suffix");
        test("prefix-55000000suffix1C(70)suffix2", "prefix" + f_iM + "suffix1" + f_o + "suffix2");
        test("-55000000\u04511", "" + f_iM + sf_strU);
        test("-55000000\u04511suffix", "" + f_iM + sf_strU + "suffix");
        test("prefix-55000000suffix1\u04511suffix2", "prefix" + f_iM + "suffix1" + sf_strU + "suffix2");
        test("-550000008000", "" + f_iM + f_s);
        test("-550000008000suffix", "" + f_iM + f_s + "suffix");
        test("prefix-55000000suffix18000suffix2", "prefix" + f_iM + "suffix1" + f_s + "suffix2");
        test("-5500000018", "" + f_iM + s_str);
        test("-5500000018suffix", "" + f_iM + s_str + "suffix");
        test("prefix-55000000suffix118suffix2", "prefix" + f_iM + "suffix1" + s_str + "suffix2");
        test("-55000000-1000000", "" + f_iM + s_iM);
        test("-55000000-1000000suffix", "" + f_iM + s_iM + "suffix");
    }

    public void run14() {
        test("prefix-55000000suffix1-1000000suffix2", "prefix" + f_iM + "suffix1" + s_iM + "suffix2");
        test("-550000001000000", "" + f_iM + sf_I);
        test("-550000001000000suffix", "" + f_iM + sf_I + "suffix");
        test("prefix-55000000suffix11000000suffix2", "prefix" + f_iM + "suffix1" + sf_I + "suffix2");
        test("-55000000null", "" + f_iM + f_oNtS);
        test("-55000000nullsuffix", "" + f_iM + f_oNtS + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + f_oNtS + "suffix2");
        test("-55000000false", "" + f_iM + f_bl);
        test("-55000000falsesuffix", "" + f_iM + f_bl + "suffix");
        test("prefix-55000000suffix1falsesuffix2", "prefix" + f_iM + "suffix1" + f_bl + "suffix2");
        test("-55000000null", "" + f_iM + sf_iAN);
        test("-55000000nullsuffix", "" + f_iM + sf_iAN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + sf_iAN + "suffix2");
        test("-55000000-2000000", "" + f_iM + sf_iM);
        test("-55000000-2000000suffix", "" + f_iM + sf_iM + "suffix");
        test("prefix-55000000suffix1-2000000suffix2", "prefix" + f_iM + "suffix1" + sf_iM + "suffix2");
        test("-55000000-820130816", "" + f_iM + f_lM);
        test("-55000000-820130816suffix", "" + f_iM + f_lM + "suffix");
        test("prefix-55000000suffix1-820130816suffix2", "prefix" + f_iM + "suffix1" + f_lM + "suffix2");
        test("-55000000null", "" + f_iM + sf_oAN);
        test("-55000000nullsuffix", "" + f_iM + sf_oAN + "suffix");
        test("prefix-55000000suffix1nullsuffix2", "prefix" + f_iM + "suffix1" + sf_oAN + "suffix2");
        test("-5500000025000000", "" + f_iM + s_I);
        test("-5500000025000000suffix", "" + f_iM + s_I + "suffix");
        test("prefix-55000000suffix125000000suffix2", "prefix" + f_iM + "suffix1" + s_I + "suffix2");
        test("1460392448-96.0", "" + f_l + s_dM);
        test("1460392448-96.0suffix", "" + f_l + s_dM + "suffix");
        test("prefix1460392448suffix1-96.0suffix2", "prefix" + f_l + "suffix1" + s_dM + "suffix2");
        test("1460392448null", "" + f_l + s_oNtS);
        test("1460392448nullsuffix", "" + f_l + s_oNtS + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + s_oNtS + "suffix2");
        test("1460392448\u045176", "" + f_l + f_strU);
        test("1460392448\u045176suffix", "" + f_l + f_strU + "suffix");
        test("prefix1460392448suffix1\u045176suffix2", "prefix" + f_l + "suffix1" + f_strU + "suffix2");
        test("146039244892", "" + f_l + sf_strU2);
        test("146039244892suffix", "" + f_l + sf_strU2 + "suffix");
        test("prefix1460392448suffix192suffix2", "prefix" + f_l + "suffix1" + sf_strU2 + "suffix2");
        test("146039244851", "" + f_l + sf_strU1);
        test("146039244851suffix", "" + f_l + sf_strU1 + "suffix");
        test("prefix1460392448suffix151suffix2", "prefix" + f_l + "suffix1" + sf_strU1 + "suffix2");
        test("1460392448null", "" + f_l + s_iAN);
        test("1460392448nullsuffix", "" + f_l + s_iAN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + s_iAN + "suffix2");
        test("1460392448-54", "" + f_l + f_bM);
        test("1460392448-54suffix", "" + f_l + f_bM + "suffix");
        test("prefix1460392448suffix1-54suffix2", "prefix" + f_l + "suffix1" + f_bM + "suffix2");
        test("1460392448-87.0", "" + f_l + f_fM);
        test("1460392448-87.0suffix", "" + f_l + f_fM + "suffix");
        test("prefix1460392448suffix1-87.0suffix2", "prefix" + f_l + "suffix1" + f_fM + "suffix2");
        test("1460392448null", "" + f_l + s_oAN);
        test("1460392448nullsuffix", "" + f_l + s_oAN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + s_oAN + "suffix2");
        test("146039244819", "" + f_l + f_str);
        test("146039244819suffix", "" + f_l + f_str + "suffix");
        test("prefix1460392448suffix119suffix2", "prefix" + f_l + "suffix1" + f_str + "suffix2");
        test("1460392448-41", "" + f_l + sf_bM);
        test("1460392448-41suffix", "" + f_l + sf_bM + "suffix");
        test("prefix1460392448suffix1-41suffix2", "prefix" + f_l + "suffix1" + sf_bM + "suffix2");
        test("1460392448null", "" + f_l + sf_IN);
        test("1460392448nullsuffix", "" + f_l + sf_IN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + sf_IN + "suffix2");
        test("1460392448T", "" + f_l + s_c);
        test("1460392448Tsuffix", "" + f_l + s_c + "suffix");
        test("prefix1460392448suffix1Tsuffix2", "prefix" + f_l + "suffix1" + s_c + "suffix2");
        test("1460392448-42.0", "" + f_l + sf_fM);
        test("1460392448-42.0suffix", "" + f_l + sf_fM + "suffix");
        test("prefix1460392448suffix1-42.0suffix2", "prefix" + f_l + "suffix1" + sf_fM + "suffix2");
        test("146039244825", "" + f_l + s_b);
        test("146039244825suffix", "" + f_l + s_b + "suffix");
        test("prefix1460392448suffix125suffix2", "prefix" + f_l + "suffix1" + s_b + "suffix2");
        test("1460392448null", "" + f_l + f_oN);
        test("1460392448nullsuffix", "" + f_l + f_oN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + f_oN + "suffix2");
        test("1460392448-1410065408", "" + f_l + s_lM);
        test("1460392448-1410065408suffix", "" + f_l + s_lM + "suffix");
        test("prefix1460392448suffix1-1410065408suffix2", "prefix" + f_l + "suffix1" + s_lM + "suffix2");
        test("14603924488.0", "" + f_l + s_d);
        test("14603924488.0suffix", "" + f_l + s_d + "suffix");
        test("prefix1460392448suffix18.0suffix2", "prefix" + f_l + "suffix1" + s_d + "suffix2");
        test("146039244855.0", "" + f_l + s_f);
        test("146039244855.0suffix", "" + f_l + s_f + "suffix");
        test("prefix1460392448suffix155.0suffix2", "prefix" + f_l + "suffix1" + s_f + "suffix2");
        test("146039244897000000", "" + f_l + s_i);
        test("146039244897000000suffix", "" + f_l + s_i + "suffix");
        test("prefix1460392448suffix197000000suffix2", "prefix" + f_l + "suffix1" + s_i + "suffix2");
        test("1460392448-9900", "" + f_l + f_sM);
        test("1460392448-9900suffix", "" + f_l + f_sM + "suffix");
        test("prefix1460392448suffix1-9900suffix2", "prefix" + f_l + "suffix1" + f_sM + "suffix2");
        test("1460392448935228928", "" + f_l + s_l);
        test("1460392448935228928suffix", "" + f_l + s_l + "suffix");
        test("prefix1460392448suffix1935228928suffix2", "prefix" + f_l + "suffix1" + s_l + "suffix2");
        test("1460392448-8400", "" + f_l + sf_sM);
        test("1460392448-8400suffix", "" + f_l + sf_sM + "suffix");
        test("prefix1460392448suffix1-8400suffix2", "prefix" + f_l + "suffix1" + sf_sM + "suffix2");
        test("1460392448C(82)", "" + f_l + s_o);
        test("1460392448C(82)suffix", "" + f_l + s_o + "suffix");
        test("prefix1460392448suffix1C(82)suffix2", "prefix" + f_l + "suffix1" + s_o + "suffix2");
        test("1460392448null", "" + f_l + sf_oNtS);
        test("1460392448nullsuffix", "" + f_l + sf_oNtS + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + sf_oNtS + "suffix2");
        test("1460392448true", "" + f_l + s_bl);
        test("1460392448truesuffix", "" + f_l + s_bl + "suffix");
        test("prefix1460392448suffix1truesuffix2", "prefix" + f_l + "suffix1" + s_bl + "suffix2");
        test("14603924483900", "" + f_l + s_s);
        test("14603924483900suffix", "" + f_l + s_s + "suffix");
        test("prefix1460392448suffix13900suffix2", "prefix" + f_l + "suffix1" + s_s + "suffix2");
        test("1460392448null", "" + f_l + sf_oN);
        test("1460392448nullsuffix", "" + f_l + sf_oN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + sf_oN + "suffix2");
        test("146039244894000000", "" + f_l + f_I);
        test("146039244894000000suffix", "" + f_l + f_I + "suffix");
        test("prefix1460392448suffix194000000suffix2", "prefix" + f_l + "suffix1" + f_I + "suffix2");
        test("1460392448null", "" + f_l + f_IN);
        test("1460392448nullsuffix", "" + f_l + f_IN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + f_IN + "suffix2");
        test("1460392448true", "" + f_l + sf_bl);
        test("1460392448truesuffix", "" + f_l + sf_bl + "suffix");
        test("prefix1460392448suffix1truesuffix2", "prefix" + f_l + "suffix1" + sf_bl + "suffix2");
        test("14603924485500", "" + f_l + sf_s);
        test("14603924485500suffix", "" + f_l + sf_s + "suffix");
        test("prefix1460392448suffix15500suffix2", "prefix" + f_l + "suffix1" + sf_s + "suffix2");
        test("1460392448-2900", "" + f_l + s_sM);
        test("1460392448-2900suffix", "" + f_l + s_sM + "suffix");
        test("prefix1460392448suffix1-2900suffix2", "prefix" + f_l + "suffix1" + s_sM + "suffix2");
        test("1460392448-194313216", "" + f_l + sf_l);
        test("1460392448-194313216suffix", "" + f_l + sf_l + "suffix");
        test("prefix1460392448suffix1-194313216suffix2", "prefix" + f_l + "suffix1" + sf_l + "suffix2");
        test("146039244812", "" + f_l + s_strU1);
        test("146039244812suffix", "" + f_l + s_strU1 + "suffix");
        test("prefix1460392448suffix112suffix2", "prefix" + f_l + "suffix1" + s_strU1 + "suffix2");
        test("1460392448C(87)", "" + f_l + sf_o);
        test("1460392448C(87)suffix", "" + f_l + sf_o + "suffix");
        test("prefix1460392448suffix1C(87)suffix2", "prefix" + f_l + "suffix1" + sf_o + "suffix2");
        test("146039244891", "" + f_l + s_strU2);
        test("146039244891suffix", "" + f_l + s_strU2 + "suffix");
        test("prefix1460392448suffix191suffix2", "prefix" + f_l + "suffix1" + s_strU2 + "suffix2");
        test("146039244821", "" + f_l + f_strU1);
        test("146039244821suffix", "" + f_l + f_strU1 + "suffix");
        test("prefix1460392448suffix121suffix2", "prefix" + f_l + "suffix1" + f_strU1 + "suffix2");
        test("146039244818", "" + f_l + f_strU2);
        test("146039244818suffix", "" + f_l + f_strU2 + "suffix");
        test("prefix1460392448suffix118suffix2", "prefix" + f_l + "suffix1" + f_strU2 + "suffix2");
        test("1460392448null", "" + f_l + f_iAN);
        test("1460392448nullsuffix", "" + f_l + f_iAN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + f_iAN + "suffix2");
        test("1460392448null", "" + f_l + s_oN);
        test("1460392448nullsuffix", "" + f_l + s_oN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + s_oN + "suffix2");
        test("1460392448\u045180", "" + f_l + s_strU);
        test("1460392448\u045180suffix", "" + f_l + s_strU + "suffix");
        test("prefix1460392448suffix1\u045180suffix2", "prefix" + f_l + "suffix1" + s_strU + "suffix2");
        test("1460392448C", "" + f_l + sf_c);
        test("1460392448Csuffix", "" + f_l + sf_c + "suffix");
        test("prefix1460392448suffix1Csuffix2", "prefix" + f_l + "suffix1" + sf_c + "suffix2");
        test("146039244875", "" + f_l + sf_str);
        test("146039244875suffix", "" + f_l + sf_str + "suffix");
        test("prefix1460392448suffix175suffix2", "prefix" + f_l + "suffix1" + sf_str + "suffix2");
        test("1460392448-43", "" + f_l + s_bM);
        test("1460392448-43suffix", "" + f_l + s_bM + "suffix");
        test("prefix1460392448suffix1-43suffix2", "prefix" + f_l + "suffix1" + s_bM + "suffix2");
        test("146039244880", "" + f_l + sf_b);
        test("146039244880suffix", "" + f_l + sf_b + "suffix");
        test("prefix1460392448suffix180suffix2", "prefix" + f_l + "suffix1" + sf_b + "suffix2");
        test("1460392448null", "" + f_l + s_IN);
        test("1460392448nullsuffix", "" + f_l + s_IN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + s_IN + "suffix2");
        test("1460392448-52.0", "" + f_l + s_fM);
        test("1460392448-52.0suffix", "" + f_l + s_fM + "suffix");
        test("prefix1460392448suffix1-52.0suffix2", "prefix" + f_l + "suffix1" + s_fM + "suffix2");
        test("146039244875000000", "" + f_l + sf_i);
        test("146039244875000000suffix", "" + f_l + sf_i + "suffix");
        test("prefix1460392448suffix175000000suffix2", "prefix" + f_l + "suffix1" + sf_i + "suffix2");
        test("146039244844", "" + f_l + f_b);
        test("146039244844suffix", "" + f_l + f_b + "suffix");
        test("prefix1460392448suffix144suffix2", "prefix" + f_l + "suffix1" + f_b + "suffix2");
        test("1460392448-1705032704", "" + f_l + sf_lM);
        test("1460392448-1705032704suffix", "" + f_l + sf_lM + "suffix");
        test("prefix1460392448suffix1-1705032704suffix2", "prefix" + f_l + "suffix1" + sf_lM + "suffix2");
        test("1460392448null", "" + f_l + f_oAN);
        test("1460392448nullsuffix", "" + f_l + f_oAN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + f_oAN + "suffix2");
        test("146039244883.0", "" + f_l + f_d);
        test("146039244883.0suffix", "" + f_l + f_d + "suffix");
        test("prefix1460392448suffix183.0suffix2", "prefix" + f_l + "suffix1" + f_d + "suffix2");
        test("1460392448I", "" + f_l + f_c);
        test("1460392448Isuffix", "" + f_l + f_c + "suffix");
        test("prefix1460392448suffix1Isuffix2", "prefix" + f_l + "suffix1" + f_c + "suffix2");
        test("146039244894.0", "" + f_l + f_f);
        test("146039244894.0suffix", "" + f_l + f_f + "suffix");
        test("prefix1460392448suffix194.0suffix2", "prefix" + f_l + "suffix1" + f_f + "suffix2");
        test("146039244812.0", "" + f_l + sf_d);
        test("146039244812.0suffix", "" + f_l + sf_d + "suffix");
        test("prefix1460392448suffix112.0suffix2", "prefix" + f_l + "suffix1" + sf_d + "suffix2");
        test("1460392448-99.0", "" + f_l + f_dM);
        test("1460392448-99.0suffix", "" + f_l + f_dM + "suffix");
        test("prefix1460392448suffix1-99.0suffix2", "prefix" + f_l + "suffix1" + f_dM + "suffix2");
        test("146039244817.0", "" + f_l + sf_f);
        test("146039244817.0suffix", "" + f_l + sf_f + "suffix");
        test("prefix1460392448suffix117.0suffix2", "prefix" + f_l + "suffix1" + sf_f + "suffix2");
        test("1460392448-84.0", "" + f_l + sf_dM);
        test("1460392448-84.0suffix", "" + f_l + sf_dM + "suffix");
        test("prefix1460392448suffix1-84.0suffix2", "prefix" + f_l + "suffix1" + sf_dM + "suffix2");
        test("146039244858000000", "" + f_l + f_i);
        test("146039244858000000suffix", "" + f_l + f_i + "suffix");
        test("prefix1460392448suffix158000000suffix2", "prefix" + f_l + "suffix1" + f_i + "suffix2");
        test("1460392448-55000000", "" + f_l + f_iM);
        test("1460392448-55000000suffix", "" + f_l + f_iM + "suffix");
        test("prefix1460392448suffix1-55000000suffix2", "prefix" + f_l + "suffix1" + f_iM + "suffix2");
        test("14603924481460392448", "" + f_l + f_l);
        test("14603924481460392448suffix", "" + f_l + f_l + "suffix");
        test("prefix1460392448suffix11460392448suffix2", "prefix" + f_l + "suffix1" + f_l + "suffix2");
        test("1460392448C(70)", "" + f_l + f_o);
        test("1460392448C(70)suffix", "" + f_l + f_o + "suffix");
        test("prefix1460392448suffix1C(70)suffix2", "prefix" + f_l + "suffix1" + f_o + "suffix2");
        test("1460392448\u04511", "" + f_l + sf_strU);
        test("1460392448\u04511suffix", "" + f_l + sf_strU + "suffix");
        test("prefix1460392448suffix1\u04511suffix2", "prefix" + f_l + "suffix1" + sf_strU + "suffix2");
        test("14603924488000", "" + f_l + f_s);
        test("14603924488000suffix", "" + f_l + f_s + "suffix");
        test("prefix1460392448suffix18000suffix2", "prefix" + f_l + "suffix1" + f_s + "suffix2");
        test("146039244818", "" + f_l + s_str);
        test("146039244818suffix", "" + f_l + s_str + "suffix");
        test("prefix1460392448suffix118suffix2", "prefix" + f_l + "suffix1" + s_str + "suffix2");
        test("1460392448-1000000", "" + f_l + s_iM);
        test("1460392448-1000000suffix", "" + f_l + s_iM + "suffix");
        test("prefix1460392448suffix1-1000000suffix2", "prefix" + f_l + "suffix1" + s_iM + "suffix2");
        test("14603924481000000", "" + f_l + sf_I);
        test("14603924481000000suffix", "" + f_l + sf_I + "suffix");
        test("prefix1460392448suffix11000000suffix2", "prefix" + f_l + "suffix1" + sf_I + "suffix2");
        test("1460392448null", "" + f_l + f_oNtS);
        test("1460392448nullsuffix", "" + f_l + f_oNtS + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + f_oNtS + "suffix2");
        test("1460392448false", "" + f_l + f_bl);
        test("1460392448falsesuffix", "" + f_l + f_bl + "suffix");
        test("prefix1460392448suffix1falsesuffix2", "prefix" + f_l + "suffix1" + f_bl + "suffix2");
        test("1460392448null", "" + f_l + sf_iAN);
        test("1460392448nullsuffix", "" + f_l + sf_iAN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + sf_iAN + "suffix2");
        test("1460392448-2000000", "" + f_l + sf_iM);
        test("1460392448-2000000suffix", "" + f_l + sf_iM + "suffix");
        test("prefix1460392448suffix1-2000000suffix2", "prefix" + f_l + "suffix1" + sf_iM + "suffix2");
        test("1460392448-820130816", "" + f_l + f_lM);
        test("1460392448-820130816suffix", "" + f_l + f_lM + "suffix");
        test("prefix1460392448suffix1-820130816suffix2", "prefix" + f_l + "suffix1" + f_lM + "suffix2");
        test("1460392448null", "" + f_l + sf_oAN);
        test("1460392448nullsuffix", "" + f_l + sf_oAN + "suffix");
        test("prefix1460392448suffix1nullsuffix2", "prefix" + f_l + "suffix1" + sf_oAN + "suffix2");
        test("146039244825000000", "" + f_l + s_I);
        test("146039244825000000suffix", "" + f_l + s_I + "suffix");
        test("prefix1460392448suffix125000000suffix2", "prefix" + f_l + "suffix1" + s_I + "suffix2");
        test("C(70)-96.0", "" + f_o + s_dM);
        test("C(70)-96.0suffix", "" + f_o + s_dM + "suffix");
        test("prefixC(70)suffix1-96.0suffix2", "prefix" + f_o + "suffix1" + s_dM + "suffix2");
        test("C(70)null", "" + f_o + s_oNtS);
        test("C(70)nullsuffix", "" + f_o + s_oNtS + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + s_oNtS + "suffix2");
        test("C(70)\u045176", "" + f_o + f_strU);
        test("C(70)\u045176suffix", "" + f_o + f_strU + "suffix");
        test("prefixC(70)suffix1\u045176suffix2", "prefix" + f_o + "suffix1" + f_strU + "suffix2");
        test("C(70)92", "" + f_o + sf_strU2);
        test("C(70)92suffix", "" + f_o + sf_strU2 + "suffix");
        test("prefixC(70)suffix192suffix2", "prefix" + f_o + "suffix1" + sf_strU2 + "suffix2");
        test("C(70)51", "" + f_o + sf_strU1);
        test("C(70)51suffix", "" + f_o + sf_strU1 + "suffix");
        test("prefixC(70)suffix151suffix2", "prefix" + f_o + "suffix1" + sf_strU1 + "suffix2");
        test("C(70)null", "" + f_o + s_iAN);
        test("C(70)nullsuffix", "" + f_o + s_iAN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + s_iAN + "suffix2");
        test("C(70)-54", "" + f_o + f_bM);
        test("C(70)-54suffix", "" + f_o + f_bM + "suffix");
        test("prefixC(70)suffix1-54suffix2", "prefix" + f_o + "suffix1" + f_bM + "suffix2");
        test("C(70)-87.0", "" + f_o + f_fM);
        test("C(70)-87.0suffix", "" + f_o + f_fM + "suffix");
        test("prefixC(70)suffix1-87.0suffix2", "prefix" + f_o + "suffix1" + f_fM + "suffix2");
        test("C(70)null", "" + f_o + s_oAN);
        test("C(70)nullsuffix", "" + f_o + s_oAN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + s_oAN + "suffix2");
        test("C(70)19", "" + f_o + f_str);
        test("C(70)19suffix", "" + f_o + f_str + "suffix");
        test("prefixC(70)suffix119suffix2", "prefix" + f_o + "suffix1" + f_str + "suffix2");
        test("C(70)-41", "" + f_o + sf_bM);
        test("C(70)-41suffix", "" + f_o + sf_bM + "suffix");
        test("prefixC(70)suffix1-41suffix2", "prefix" + f_o + "suffix1" + sf_bM + "suffix2");
        test("C(70)null", "" + f_o + sf_IN);
        test("C(70)nullsuffix", "" + f_o + sf_IN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + sf_IN + "suffix2");
        test("C(70)T", "" + f_o + s_c);
        test("C(70)Tsuffix", "" + f_o + s_c + "suffix");
        test("prefixC(70)suffix1Tsuffix2", "prefix" + f_o + "suffix1" + s_c + "suffix2");
        test("C(70)-42.0", "" + f_o + sf_fM);
        test("C(70)-42.0suffix", "" + f_o + sf_fM + "suffix");
        test("prefixC(70)suffix1-42.0suffix2", "prefix" + f_o + "suffix1" + sf_fM + "suffix2");
        test("C(70)25", "" + f_o + s_b);
        test("C(70)25suffix", "" + f_o + s_b + "suffix");
        test("prefixC(70)suffix125suffix2", "prefix" + f_o + "suffix1" + s_b + "suffix2");
        test("C(70)null", "" + f_o + f_oN);
        test("C(70)nullsuffix", "" + f_o + f_oN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + f_oN + "suffix2");
        test("C(70)-1410065408", "" + f_o + s_lM);
        test("C(70)-1410065408suffix", "" + f_o + s_lM + "suffix");
        test("prefixC(70)suffix1-1410065408suffix2", "prefix" + f_o + "suffix1" + s_lM + "suffix2");
        test("C(70)8.0", "" + f_o + s_d);
        test("C(70)8.0suffix", "" + f_o + s_d + "suffix");
        test("prefixC(70)suffix18.0suffix2", "prefix" + f_o + "suffix1" + s_d + "suffix2");
        test("C(70)55.0", "" + f_o + s_f);
        test("C(70)55.0suffix", "" + f_o + s_f + "suffix");
        test("prefixC(70)suffix155.0suffix2", "prefix" + f_o + "suffix1" + s_f + "suffix2");
        test("C(70)97000000", "" + f_o + s_i);
        test("C(70)97000000suffix", "" + f_o + s_i + "suffix");
        test("prefixC(70)suffix197000000suffix2", "prefix" + f_o + "suffix1" + s_i + "suffix2");
        test("C(70)-9900", "" + f_o + f_sM);
        test("C(70)-9900suffix", "" + f_o + f_sM + "suffix");
        test("prefixC(70)suffix1-9900suffix2", "prefix" + f_o + "suffix1" + f_sM + "suffix2");
        test("C(70)935228928", "" + f_o + s_l);
        test("C(70)935228928suffix", "" + f_o + s_l + "suffix");
        test("prefixC(70)suffix1935228928suffix2", "prefix" + f_o + "suffix1" + s_l + "suffix2");
        test("C(70)-8400", "" + f_o + sf_sM);
        test("C(70)-8400suffix", "" + f_o + sf_sM + "suffix");
        test("prefixC(70)suffix1-8400suffix2", "prefix" + f_o + "suffix1" + sf_sM + "suffix2");
        test("C(70)C(82)", "" + f_o + s_o);
        test("C(70)C(82)suffix", "" + f_o + s_o + "suffix");
        test("prefixC(70)suffix1C(82)suffix2", "prefix" + f_o + "suffix1" + s_o + "suffix2");
        test("C(70)null", "" + f_o + sf_oNtS);
        test("C(70)nullsuffix", "" + f_o + sf_oNtS + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + sf_oNtS + "suffix2");
        test("C(70)true", "" + f_o + s_bl);
        test("C(70)truesuffix", "" + f_o + s_bl + "suffix");
        test("prefixC(70)suffix1truesuffix2", "prefix" + f_o + "suffix1" + s_bl + "suffix2");
        test("C(70)3900", "" + f_o + s_s);
        test("C(70)3900suffix", "" + f_o + s_s + "suffix");
        test("prefixC(70)suffix13900suffix2", "prefix" + f_o + "suffix1" + s_s + "suffix2");
        test("C(70)null", "" + f_o + sf_oN);
        test("C(70)nullsuffix", "" + f_o + sf_oN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + sf_oN + "suffix2");
        test("C(70)94000000", "" + f_o + f_I);
        test("C(70)94000000suffix", "" + f_o + f_I + "suffix");
        test("prefixC(70)suffix194000000suffix2", "prefix" + f_o + "suffix1" + f_I + "suffix2");
        test("C(70)null", "" + f_o + f_IN);
        test("C(70)nullsuffix", "" + f_o + f_IN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + f_IN + "suffix2");
        test("C(70)true", "" + f_o + sf_bl);
        test("C(70)truesuffix", "" + f_o + sf_bl + "suffix");
        test("prefixC(70)suffix1truesuffix2", "prefix" + f_o + "suffix1" + sf_bl + "suffix2");
        test("C(70)5500", "" + f_o + sf_s);
        test("C(70)5500suffix", "" + f_o + sf_s + "suffix");
        test("prefixC(70)suffix15500suffix2", "prefix" + f_o + "suffix1" + sf_s + "suffix2");
        test("C(70)-2900", "" + f_o + s_sM);
        test("C(70)-2900suffix", "" + f_o + s_sM + "suffix");
        test("prefixC(70)suffix1-2900suffix2", "prefix" + f_o + "suffix1" + s_sM + "suffix2");
        test("C(70)-194313216", "" + f_o + sf_l);
        test("C(70)-194313216suffix", "" + f_o + sf_l + "suffix");
        test("prefixC(70)suffix1-194313216suffix2", "prefix" + f_o + "suffix1" + sf_l + "suffix2");
        test("C(70)12", "" + f_o + s_strU1);
        test("C(70)12suffix", "" + f_o + s_strU1 + "suffix");
        test("prefixC(70)suffix112suffix2", "prefix" + f_o + "suffix1" + s_strU1 + "suffix2");
        test("C(70)C(87)", "" + f_o + sf_o);
        test("C(70)C(87)suffix", "" + f_o + sf_o + "suffix");
        test("prefixC(70)suffix1C(87)suffix2", "prefix" + f_o + "suffix1" + sf_o + "suffix2");
        test("C(70)91", "" + f_o + s_strU2);
        test("C(70)91suffix", "" + f_o + s_strU2 + "suffix");
        test("prefixC(70)suffix191suffix2", "prefix" + f_o + "suffix1" + s_strU2 + "suffix2");
        test("C(70)21", "" + f_o + f_strU1);
        test("C(70)21suffix", "" + f_o + f_strU1 + "suffix");
        test("prefixC(70)suffix121suffix2", "prefix" + f_o + "suffix1" + f_strU1 + "suffix2");
        test("C(70)18", "" + f_o + f_strU2);
        test("C(70)18suffix", "" + f_o + f_strU2 + "suffix");
        test("prefixC(70)suffix118suffix2", "prefix" + f_o + "suffix1" + f_strU2 + "suffix2");
        test("C(70)null", "" + f_o + f_iAN);
        test("C(70)nullsuffix", "" + f_o + f_iAN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + f_iAN + "suffix2");
        test("C(70)null", "" + f_o + s_oN);
        test("C(70)nullsuffix", "" + f_o + s_oN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + s_oN + "suffix2");
        test("C(70)\u045180", "" + f_o + s_strU);
        test("C(70)\u045180suffix", "" + f_o + s_strU + "suffix");
        test("prefixC(70)suffix1\u045180suffix2", "prefix" + f_o + "suffix1" + s_strU + "suffix2");
        test("C(70)C", "" + f_o + sf_c);
        test("C(70)Csuffix", "" + f_o + sf_c + "suffix");
        test("prefixC(70)suffix1Csuffix2", "prefix" + f_o + "suffix1" + sf_c + "suffix2");
        test("C(70)75", "" + f_o + sf_str);
        test("C(70)75suffix", "" + f_o + sf_str + "suffix");
        test("prefixC(70)suffix175suffix2", "prefix" + f_o + "suffix1" + sf_str + "suffix2");
        test("C(70)-43", "" + f_o + s_bM);
        test("C(70)-43suffix", "" + f_o + s_bM + "suffix");
        test("prefixC(70)suffix1-43suffix2", "prefix" + f_o + "suffix1" + s_bM + "suffix2");
        test("C(70)80", "" + f_o + sf_b);
        test("C(70)80suffix", "" + f_o + sf_b + "suffix");
        test("prefixC(70)suffix180suffix2", "prefix" + f_o + "suffix1" + sf_b + "suffix2");
        test("C(70)null", "" + f_o + s_IN);
        test("C(70)nullsuffix", "" + f_o + s_IN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + s_IN + "suffix2");
        test("C(70)-52.0", "" + f_o + s_fM);
        test("C(70)-52.0suffix", "" + f_o + s_fM + "suffix");
        test("prefixC(70)suffix1-52.0suffix2", "prefix" + f_o + "suffix1" + s_fM + "suffix2");
        test("C(70)75000000", "" + f_o + sf_i);
        test("C(70)75000000suffix", "" + f_o + sf_i + "suffix");
        test("prefixC(70)suffix175000000suffix2", "prefix" + f_o + "suffix1" + sf_i + "suffix2");
        test("C(70)44", "" + f_o + f_b);
        test("C(70)44suffix", "" + f_o + f_b + "suffix");
        test("prefixC(70)suffix144suffix2", "prefix" + f_o + "suffix1" + f_b + "suffix2");
        test("C(70)-1705032704", "" + f_o + sf_lM);
        test("C(70)-1705032704suffix", "" + f_o + sf_lM + "suffix");
        test("prefixC(70)suffix1-1705032704suffix2", "prefix" + f_o + "suffix1" + sf_lM + "suffix2");
        test("C(70)null", "" + f_o + f_oAN);
        test("C(70)nullsuffix", "" + f_o + f_oAN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + f_oAN + "suffix2");
        test("C(70)83.0", "" + f_o + f_d);
        test("C(70)83.0suffix", "" + f_o + f_d + "suffix");
        test("prefixC(70)suffix183.0suffix2", "prefix" + f_o + "suffix1" + f_d + "suffix2");
        test("C(70)I", "" + f_o + f_c);
        test("C(70)Isuffix", "" + f_o + f_c + "suffix");
        test("prefixC(70)suffix1Isuffix2", "prefix" + f_o + "suffix1" + f_c + "suffix2");
        test("C(70)94.0", "" + f_o + f_f);
        test("C(70)94.0suffix", "" + f_o + f_f + "suffix");
        test("prefixC(70)suffix194.0suffix2", "prefix" + f_o + "suffix1" + f_f + "suffix2");
        test("C(70)12.0", "" + f_o + sf_d);
        test("C(70)12.0suffix", "" + f_o + sf_d + "suffix");
        test("prefixC(70)suffix112.0suffix2", "prefix" + f_o + "suffix1" + sf_d + "suffix2");
        test("C(70)-99.0", "" + f_o + f_dM);
        test("C(70)-99.0suffix", "" + f_o + f_dM + "suffix");
        test("prefixC(70)suffix1-99.0suffix2", "prefix" + f_o + "suffix1" + f_dM + "suffix2");
        test("C(70)17.0", "" + f_o + sf_f);
        test("C(70)17.0suffix", "" + f_o + sf_f + "suffix");
        test("prefixC(70)suffix117.0suffix2", "prefix" + f_o + "suffix1" + sf_f + "suffix2");
        test("C(70)-84.0", "" + f_o + sf_dM);
        test("C(70)-84.0suffix", "" + f_o + sf_dM + "suffix");
        test("prefixC(70)suffix1-84.0suffix2", "prefix" + f_o + "suffix1" + sf_dM + "suffix2");
        test("C(70)58000000", "" + f_o + f_i);
        test("C(70)58000000suffix", "" + f_o + f_i + "suffix");
        test("prefixC(70)suffix158000000suffix2", "prefix" + f_o + "suffix1" + f_i + "suffix2");
        test("C(70)-55000000", "" + f_o + f_iM);
        test("C(70)-55000000suffix", "" + f_o + f_iM + "suffix");
        test("prefixC(70)suffix1-55000000suffix2", "prefix" + f_o + "suffix1" + f_iM + "suffix2");
        test("C(70)1460392448", "" + f_o + f_l);
        test("C(70)1460392448suffix", "" + f_o + f_l + "suffix");
        test("prefixC(70)suffix11460392448suffix2", "prefix" + f_o + "suffix1" + f_l + "suffix2");
        test("C(70)C(70)", "" + f_o + f_o);
        test("C(70)C(70)suffix", "" + f_o + f_o + "suffix");
        test("prefixC(70)suffix1C(70)suffix2", "prefix" + f_o + "suffix1" + f_o + "suffix2");
        test("C(70)\u04511", "" + f_o + sf_strU);
        test("C(70)\u04511suffix", "" + f_o + sf_strU + "suffix");
        test("prefixC(70)suffix1\u04511suffix2", "prefix" + f_o + "suffix1" + sf_strU + "suffix2");
        test("C(70)8000", "" + f_o + f_s);
        test("C(70)8000suffix", "" + f_o + f_s + "suffix");
        test("prefixC(70)suffix18000suffix2", "prefix" + f_o + "suffix1" + f_s + "suffix2");
        test("C(70)18", "" + f_o + s_str);
        test("C(70)18suffix", "" + f_o + s_str + "suffix");
        test("prefixC(70)suffix118suffix2", "prefix" + f_o + "suffix1" + s_str + "suffix2");
        test("C(70)-1000000", "" + f_o + s_iM);
        test("C(70)-1000000suffix", "" + f_o + s_iM + "suffix");
        test("prefixC(70)suffix1-1000000suffix2", "prefix" + f_o + "suffix1" + s_iM + "suffix2");
        test("C(70)1000000", "" + f_o + sf_I);
        test("C(70)1000000suffix", "" + f_o + sf_I + "suffix");
        test("prefixC(70)suffix11000000suffix2", "prefix" + f_o + "suffix1" + sf_I + "suffix2");
        test("C(70)null", "" + f_o + f_oNtS);
        test("C(70)nullsuffix", "" + f_o + f_oNtS + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + f_oNtS + "suffix2");
        test("C(70)false", "" + f_o + f_bl);
        test("C(70)falsesuffix", "" + f_o + f_bl + "suffix");
        test("prefixC(70)suffix1falsesuffix2", "prefix" + f_o + "suffix1" + f_bl + "suffix2");
        test("C(70)null", "" + f_o + sf_iAN);
        test("C(70)nullsuffix", "" + f_o + sf_iAN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + sf_iAN + "suffix2");
        test("C(70)-2000000", "" + f_o + sf_iM);
        test("C(70)-2000000suffix", "" + f_o + sf_iM + "suffix");
        test("prefixC(70)suffix1-2000000suffix2", "prefix" + f_o + "suffix1" + sf_iM + "suffix2");
        test("C(70)-820130816", "" + f_o + f_lM);
        test("C(70)-820130816suffix", "" + f_o + f_lM + "suffix");
        test("prefixC(70)suffix1-820130816suffix2", "prefix" + f_o + "suffix1" + f_lM + "suffix2");
        test("C(70)null", "" + f_o + sf_oAN);
        test("C(70)nullsuffix", "" + f_o + sf_oAN + "suffix");
        test("prefixC(70)suffix1nullsuffix2", "prefix" + f_o + "suffix1" + sf_oAN + "suffix2");
        test("C(70)25000000", "" + f_o + s_I);
        test("C(70)25000000suffix", "" + f_o + s_I + "suffix");
        test("prefixC(70)suffix125000000suffix2", "prefix" + f_o + "suffix1" + s_I + "suffix2");
        test("\u04511-96.0", "" + sf_strU + s_dM);
        test("\u04511-96.0suffix", "" + sf_strU + s_dM + "suffix");
        test("prefix\u04511suffix1-96.0suffix2", "prefix" + sf_strU + "suffix1" + s_dM + "suffix2");
        test("\u04511null", "" + sf_strU + s_oNtS);
        test("\u04511nullsuffix", "" + sf_strU + s_oNtS + "suffix");
        test("prefix\u04511suffix1nullsuffix2", "prefix" + sf_strU + "suffix1" + s_oNtS + "suffix2");
        test("\u04511\u045176", "" + sf_strU + f_strU);
        test("\u04511\u045176suffix", "" + sf_strU + f_strU + "suffix");
        test("prefix\u04511suffix1\u045176suffix2", "prefix" + sf_strU + "suffix1" + f_strU + "suffix2");
        test("\u0451192", "" + sf_strU + sf_strU2);
        test("\u0451192suffix", "" + sf_strU + sf_strU2 + "suffix");
        test("prefix\u04511suffix192suffix2", "prefix" + sf_strU + "suffix1" + sf_strU2 + "suffix2");
        test("\u0451151", "" + sf_strU + sf_strU1);
        test("\u0451151suffix", "" + sf_strU + sf_strU1 + "suffix");
        test("prefix\u04511suffix151suffix2", "prefix" + sf_strU + "suffix1" + sf_strU1 + "suffix2");
        test("\u04511null", "" + sf_strU + s_iAN);
        test("\u04511nullsuffix", "" + sf_strU + s_iAN + "suffix");
        test("prefix\u04511suffix1nullsuffix2", "prefix" + sf_strU + "suffix1" + s_iAN + "suffix2");
        test("\u04511-54", "" + sf_strU + f_bM);
        test("\u04511-54suffix", "" + sf_strU + f_bM + "suffix");
        test("prefix\u04511suffix1-54suffix2", "prefix" + sf_strU + "suffix1" + f_bM + "suffix2");
        test("\u04511-87.0", "" + sf_strU + f_fM);
        test("\u04511-87.0suffix", "" + sf_strU + f_fM + "suffix");
        test("prefix\u04511suffix1-87.0suffix2", "prefix" + sf_strU + "suffix1" + f_fM + "suffix2");
        test("\u04511null", "" + sf_strU + s_oAN);
        test("\u04511nullsuffix", "" + sf_strU + s_oAN + "suffix");
        test("prefix\u04511suffix1nullsuffix2", "prefix" + sf_strU + "suffix1" + s_oAN + "suffix2");
        test("\u0451119", "" + sf_strU + f_str);
        test("\u0451119suffix", "" + sf_strU + f_str + "suffix");
        test("prefix\u04511suffix119suffix2", "prefix" + sf_strU + "suffix1" + f_str + "suffix2");
        test("\u04511-41", "" + sf_strU + sf_bM);
        test("\u04511-41suffix", "" + sf_strU + sf_bM + "suffix");
        test("prefix\u04511suffix1-41suffix2", "prefix" + sf_strU + "suffix1" + sf_bM + "suffix2");
        test("\u04511null", "" + sf_strU + sf_IN);
        test("\u04511nullsuffix", "" + sf_strU + sf_IN + "suffix");
        test("prefix\u04511suffix1nullsuffix2", "prefix" + sf_strU + "suffix1" + sf_IN + "suffix2");
        test("\u04511T", "" + sf_strU + s_c);
        test("\u04511Tsuffix", "" + sf_strU + s_c + "suffix");
        test("prefix\u04511suffix1Tsuffix2", "prefix" + sf_strU + "suffix1" + s_c + "suffix2");
        test("\u04511-42.0", "" + sf_strU + sf_fM);
        test("\u04511-42.0suffix", "" + sf_strU + sf_fM + "suffix");
        test("prefix\u04511suffix1-42.0suffix2", "prefix" + sf_strU + "suffix1" + sf_fM + "suffix2");
        test("\u0451125", "" + sf_strU + s_b);
        test("\u0451125suffix", "" + sf_strU + s_b + "suffix");
        test("prefix\u04511suffix125suffix2", "prefix" + sf_strU + "suffix1" + s_b + "suffix2");
        test("\u04511null", "" + sf_strU + f_oN);
        test("\u04511nullsuffix", "" + sf_strU + f_oN + "suffix");
        test("prefix\u04511suffix1nullsuffix2", "prefix" + sf_strU + "suffix1" + f_oN + "suffix2");
        test("\u04511-1410065408", "" + sf_strU + s_lM);
        test("\u04511-1410065408suffix", "" + sf_strU + s_lM + "suffix");
        test("prefix\u04511suffix1-1410065408suffix2", "prefix" + sf_strU + "suffix1" + s_lM + "suffix2");
        test("\u045118.0", "" + sf_strU + s_d);
        test("\u045118.0suffix", "" + sf_st