/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.util.Objects;

public final class OpaqueType
extends Type {
    private final String name;

    public OpaqueType() {
        this("<anon>");
    }

    public OpaqueType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getBitSize() {
        return 0L;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        return 8;
    }

    @Override
    public long getSize(DataLayout targetDataLayout) {
        return 0L;
    }

    public String toString() {
        if (LLVMIdentifier.isUnknown(this.name)) {
            return "opaque";
        }
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpaqueType) {
            OpaqueType other = (OpaqueType)obj;
            return Objects.equals(this.name, other.name);
        }
        return false;
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        throw new LLVMParserException("Unsupported Type for Zero Constant: " + this);
    }
}

