/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pointer;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetMemberPointerNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNodeGen;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignWriteNodeGen;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.CommonPointerLibraries;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointerImpl;
import com.oracle.truffle.llvm.runtime.pointer.NativePointerLibraries;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativePointerLibraries.class)
final class NativePointerLibrariesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private NativePointerLibrariesGen() {
    }

    static {
        LibraryExport.register(NativePointerLibraries.class, (LibraryExport[])new LibraryExport[]{new LLVMNativeLibraryExports(), new InteropLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=NativePointerLibraries.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Uncached
        extends LLVMAsForeignLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && NativePointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isForeign((LLVMPointerImpl)receiver);
            }
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Cached
        extends LLVMAsForeignLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver)));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && NativePointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isForeign((LLVMPointerImpl)receiver);
            }
        }
    }

    @GeneratedBy(value=NativePointerLibraries.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMPointerImpl.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Uncached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_ = this.lookupContextReference(LLVMLanguage.class);

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && NativePointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, (LLVMContext)this.lLVMLanguageContextReference_.get(), (InteropLibrary)INTEROP_LIBRARY_.getUncached(), LLVMDynAccessSymbolNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                if (arg1Value instanceof LLVMPointerImpl) {
                    LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                    return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, LLVMAddressEqualsNodeGen.OperationNodeGen.getUncached());
                }
                return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getMembers(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readMember(arg0Value, arg1Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInvocable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, LLVMForeignGetMemberPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.getArraySize(arg0Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignReadNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, ConditionProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, LLVMForeignGetIndexPointerNodeGen.getUncached(), LLVMForeignWriteNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.identityHashCode((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return NativePointerLibraries.IsExecutable.doNative(arg0Value, (LLVMContext)this.lLVMLanguageContextReference_.get());
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                return NativePointerLibraries.Execute.doNative(arg0Value, arg1Value, (LLVMContext)this.lLVMLanguageContextReference_.get(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isNull((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)receiver);
            }
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isObject;
            @Node.Child
            private LLVMForeignGetMemberPointerNode getMember;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile isArray;
            @Node.Child
            private LLVMForeignGetIndexPointerNode getIndex;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
            @Node.Child
            private InvokeMemberCachedData invokeMember_cached_cache;
            @Node.Child
            private InteropLibrary invokeMember_resolve_interop_;
            @Node.Child
            private LLVMDynAccessSymbolNode invokeMember_resolve_dynAccessSymbolNode_;
            @Node.Child
            private LLVMAddressEqualsNode.Operation isIdenticalOrUndefined_pointer_equals_;
            @Node.Child
            private LLVMForeignReadNode readMemberNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeMemberNode__write_;
            @Node.Child
            private LLVMForeignReadNode readArrayElementNode__read_;
            @Node.Child
            private LLVMForeignWriteNode writeArrayElementNode__write_;
            @Node.Child
            private ExecuteNativeCachedData execute_nativeCached_cache;
            @Node.Child
            private InteropLibrary execute_native_interop_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver)));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && NativePointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            @ExplodeLoop
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        InvokeMemberCachedData s1_ = this.invokeMember_cached_cache;
                        while (s1_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeCached_((Object)s1_);
                                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
                            }
                            if (CommonPointerLibraries.asClazz(arg0Value) == s1_.clazz_ && arg1Value.equals(s1_.methodName_) && s1_.argCount_ == arg2Value.length) {
                                TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                                LLVMContext context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                                return CommonPointerLibraries.InvokeMember.doCached(arg0Value, arg1Value, arg2Value, context__, s1_.interop_, s1_.clazz_, s1_.method_, s1_.argCount_, s1_.methodName_, s1_.llvmFunction_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                        LLVMContext invokeMember_resolve_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                        return CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, invokeMember_resolve_context__, this.invokeMember_resolve_interop_, this.invokeMember_resolve_dynAccessSymbolNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberAndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    LLVMContext context__ = null;
                    if ((exclude & 1) == 0) {
                        int count1_ = 0;
                        InvokeMemberCachedData s1_ = this.invokeMember_cached_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null) {
                                if (CommonPointerLibraries.asClazz(arg0Value) == s1_.clazz_ && arg1Value.equals(s1_.methodName_) && s1_.argCount_ == arg2Value.length && (s1_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                                    TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                    if (lLVMLanguageContextReference__2 == null) {
                                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                    }
                                    context__ = (LLVMContext)lLVMLanguageContextReference__2.get();
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null) {
                            Assumption assumption0;
                            LLVMInteropType.Method method__;
                            String methodName__;
                            LLVMInteropType.Clazz clazz__ = CommonPointerLibraries.asClazz(arg0Value);
                            if (CommonPointerLibraries.asClazz(arg0Value) == clazz__ && arg1Value.equals(methodName__ = (method__ = clazz__.findMethodByArguments(arg0Value, arg1Value, arg2Value)).getName()) && Assumption.isValidAssumption((Assumption)(assumption0 = LLVMLanguage.getLanguage().singleContextAssumption)) && count1_ < 3) {
                                s1_ = (InvokeMemberCachedData)super.insert((Node)new InvokeMemberCachedData(this.invokeMember_cached_cache));
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__3 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                context__ = (LLVMContext)lLVMLanguageContextReference__3.get();
                                s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5));
                                s1_.clazz_ = clazz__;
                                s1_.method_ = method__;
                                s1_.argCount_ = arg2Value.length;
                                s1_.methodName_ = methodName__;
                                s1_.llvmFunction_ = CommonPointerLibraries.getLLVMFunction(context__, method__, clazz__, arg1Value);
                                s1_.assumption0_ = assumption0;
                                this.invokeMember_cached_cache = s1_;
                                this.state_0_ = state_0 |= 1;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = CommonPointerLibraries.InvokeMember.doCached(arg0Value, arg1Value, arg2Value, context__, s1_.interop_, s1_.clazz_, s1_.method_, s1_.argCount_, s1_.methodName_, s1_.llvmFunction_);
                            return object;
                        }
                    }
                    LLVMContext invokeMember_resolve_context__ = null;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__4 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    invokeMember_resolve_context__ = (LLVMContext)lLVMLanguageContextReference__4.get();
                    this.invokeMember_resolve_interop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    this.invokeMember_resolve_dynAccessSymbolNode_ = (LLVMDynAccessSymbolNode)super.insert((Node)LLVMDynAccessSymbolNodeGen.create());
                    this.exclude_ = exclude |= 1;
                    this.invokeMember_cached_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.InvokeMember.doResolve(arg0Value, arg1Value, arg2Value, invokeMember_resolve_context__, this.invokeMember_resolve_interop_, this.invokeMember_resolve_dynAccessSymbolNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                InvokeMemberCachedData s1_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s1_ = this.invokeMember_cached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeCached_(Object s1_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    InvokeMemberCachedData prev = null;
                    InvokeMemberCachedData cur = this.invokeMember_cached_cache;
                    while (cur != null) {
                        if (cur == s1_) {
                            if (prev == null) {
                                this.invokeMember_cached_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.invokeMember_cached_cache == null) {
                        this.state_0_ &= 0xFFFFFFFE;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0 && arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                    }
                    if ((state_0 & 8) != 0 && Cached.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TriState isIdenticalOrUndefinedAndSpecialize(LLVMPointerImpl arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (arg1Value instanceof LLVMPointerImpl) {
                        LLVMPointerImpl arg1Value_ = (LLVMPointerImpl)arg1Value;
                        this.isIdenticalOrUndefined_pointer_equals_ = (LLVMAddressEqualsNode.Operation)super.insert((Node)LLVMAddressEqualsNodeGen.OperationNodeGen.create());
                        this.state_0_ = state_0 |= 4;
                        lock.unlock();
                        hasLock = false;
                        TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doPointer(arg0Value, arg1Value_, this.isIdenticalOrUndefined_pointer_equals_);
                        return triState;
                    }
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    TriState triState = CommonPointerLibraries.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    return triState;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMembers((LLVMPointerImpl)receiver);
            }

            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0) {
                    return CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getMembersNode_AndSpecialize(LLVMPointerImpl arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.getMembers(arg0Value, arg1Value, this.isObject);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0) {
                    return CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberReadable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0) {
                    return CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.readMemberNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readMember(arg0Value, arg1Value, this.getMember, this.readMemberNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0) {
                    return CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isMemberModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isObject == null) {
                        this.isObject = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isMemberModifiable(arg0Value, arg1Value, this.isObject);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInvocable((LLVMPointerImpl)receiver, member);
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isMemberInsertable((LLVMPointerImpl)receiver, member);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0) {
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberNode_AndSpecialize(LLVMPointerImpl arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getMember == null) {
                        this.getMember = (LLVMForeignGetMemberPointerNode)super.insert((Node)LLVMForeignGetMemberPointerNodeGen.create());
                    }
                    this.writeMemberNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeMember(arg0Value, arg1Value, arg2Value, this.getMember, this.writeMemberNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasArrayElements((LLVMPointerImpl)receiver);
            }

            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0) {
                    return CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArraySizeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long getArraySizeNode_AndSpecialize(LLVMPointerImpl arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    long l = CommonPointerLibraries.getArraySize(arg0Value, this.isArray);
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0) {
                    return CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementReadableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementReadable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0) {
                    return CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.readArrayElementNode__read_ = (LLVMForeignReadNode)super.insert((Node)LLVMForeignReadNodeGen.create());
                    this.state_0_ = state_0 |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    Object object = CommonPointerLibraries.readArrayElement(arg0Value, arg1Value, this.getIndex, this.readArrayElementNode__read_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0) {
                    return CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isArrayElementModifiableNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.isArray == null) {
                        this.isArray = ConditionProfile.create();
                    }
                    this.state_0_ = state_0 |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = CommonPointerLibraries.isArrayElementModifiable(arg0Value, arg1Value, this.isArray);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.isArrayElementInsertable((LLVMPointerImpl)receiver, index);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0) {
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeArrayElementNode_AndSpecialize(LLVMPointerImpl arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (this.getIndex == null) {
                        this.getIndex = (LLVMForeignGetIndexPointerNode)super.insert((Node)LLVMForeignGetIndexPointerNodeGen.create());
                    }
                    this.writeArrayElementNode__write_ = (LLVMForeignWriteNode)super.insert((Node)LLVMForeignWriteNodeGen.create());
                    this.state_0_ = state_0 |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    CommonPointerLibraries.writeArrayElement(arg0Value, arg1Value, arg2Value, this.getIndex, this.writeArrayElementNode__write_);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasLanguage((LLVMPointerImpl)receiver);
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getLanguage((LLVMPointerImpl)receiver);
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.toDisplayString((LLVMPointerImpl)receiver, allowSideEffects);
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.getMetaObject((LLVMPointerImpl)receiver);
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return CommonPointerLibraries.hasMetaObject((LLVMPointerImpl)receiver);
            }

            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NativePointerLibraries.identityHashCode((LLVMPointerImpl)receiver);
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0) {
                    TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                    LLVMContext isExecutable_context__ = (LLVMContext)lLVMLanguageContextReference__.get();
                    return NativePointerLibraries.IsExecutable.doNative(arg0Value, isExecutable_context__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableAndSpecialize(LLVMPointerImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    LLVMContext isExecutable_context__ = null;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__1 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__1 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    isExecutable_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                    this.state_0_ = state_0 |= 0x4000;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = NativePointerLibraries.IsExecutable.doNative(arg0Value, isExecutable_context__);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                LLVMPointerImpl arg0Value = (LLVMPointerImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x18000) != 0) {
                    if ((state_0 & 0x8000) != 0) {
                        ExecuteNativeCachedData s1_ = this.execute_nativeCached_cache;
                        while (s1_ != null) {
                            TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__;
                            if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeNativeCached_((Object)s1_);
                                return this.executeAndSpecialize(arg0Value, arg1Value);
                            }
                            TruffleLanguage.ContextReference<LLVMContext> ctxRef__ = lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                            assert (s1_.interop_.accepts((Object)s1_.cachedDescriptor_));
                            if (arg0Value.asNative() == s1_.cachedAddress_) {
                                assert (s1_.cachedDescriptor_ != null);
                                return NativePointerLibraries.Execute.doNativeCached(arg0Value, arg1Value, s1_.cachedAddress_, ctxRef__, s1_.cachedDescriptor_, s1_.interop_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0x10000) != 0) {
                        TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference__1 = this.lLVMLanguageContextReference_;
                        LLVMContext execute_native_context__ = (LLVMContext)lLVMLanguageContextReference__1.get();
                        return NativePointerLibraries.Execute.doNative(arg0Value, arg1Value, execute_native_context__, this.execute_native_interop_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LLVMPointerImpl arg0Value, Object[] arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    TruffleLanguage.ContextReference ctxRef__ = null;
                    if ((exclude & 2) == 0) {
                        int count1_ = 0;
                        ExecuteNativeCachedData s1_ = this.execute_nativeCached_cache;
                        if ((state_0 & 0x8000) != 0) {
                            while (s1_ != null) {
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__2 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__2 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__2 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                ctxRef__ = lLVMLanguageContextReference__2;
                                assert (s1_.interop_.accepts((Object)s1_.cachedDescriptor_));
                                if (arg0Value.asNative() == s1_.cachedAddress_) {
                                    assert (s1_.cachedDescriptor_ != null);
                                    if (s1_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s1_.assumption0_)) break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null) {
                            long cachedAddress__ = arg0Value.asNative();
                            if (arg0Value.asNative() == cachedAddress__) {
                                Assumption assumption0;
                                LLVMFunctionDescriptor cachedDescriptor__;
                                TruffleLanguage.ContextReference lLVMLanguageContextReference__3 = this.lLVMLanguageContextReference_;
                                if (lLVMLanguageContextReference__3 == null) {
                                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__3 = super.lookupContextReference(LLVMLanguage.class);
                                }
                                if ((cachedDescriptor__ = NativePointerLibraries.Execute.getDescriptor(ctxRef__ = lLVMLanguageContextReference__3, arg0Value)) != null && Assumption.isValidAssumption((Assumption)(assumption0 = LLVMLanguage.getLanguage().singleContextAssumption)) && count1_ < 5) {
                                    s1_ = (ExecuteNativeCachedData)super.insert((Node)new ExecuteNativeCachedData(this.execute_nativeCached_cache));
                                    s1_.cachedAddress_ = cachedAddress__;
                                    s1_.cachedDescriptor_ = cachedDescriptor__;
                                    s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create((Object)cachedDescriptor__));
                                    s1_.assumption0_ = assumption0;
                                    this.execute_nativeCached_cache = s1_;
                                    this.state_0_ = state_0 |= 0x8000;
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = NativePointerLibraries.Execute.doNativeCached(arg0Value, arg1Value, s1_.cachedAddress_, ctxRef__, s1_.cachedDescriptor_, s1_.interop_);
                            return object;
                        }
                    }
                    LLVMContext execute_native_context__ = null;
                    TruffleLanguage.ContextReference lLVMLanguageContextReference__4 = this.lLVMLanguageContextReference_;
                    if (lLVMLanguageContextReference__4 == null) {
                        this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__4 = super.lookupContextReference(LLVMLanguage.class);
                    }
                    execute_native_context__ = (LLVMContext)lLVMLanguageContextReference__4.get();
                    this.execute_native_interop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(5)));
                    this.exclude_ = exclude |= 2;
                    this.execute_nativeCached_cache = null;
                    state_0 &= 0xFFFF7FFF;
                    this.state_0_ = state_0 |= 0x10000;
                    lock.unlock();
                    hasLock = false;
                    Object object = NativePointerLibraries.Execute.doNative(arg0Value, arg1Value, execute_native_context__, this.execute_native_interop_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeNativeCached_(Object s1_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    ExecuteNativeCachedData prev = null;
                    ExecuteNativeCachedData cur = this.execute_nativeCached_cache;
                    while (cur != null) {
                        if (cur == s1_) {
                            if (prev == null) {
                                this.execute_nativeCached_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.execute_nativeCached_cache == null) {
                        this.state_0_ &= 0xFFFF7FFF;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            public boolean isNull(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NativePointerLibraries.isNull((LLVMPointerImpl)receiver);
            }

            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NativePointerLibraries.isPointer((LLVMPointerImpl)receiver);
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return NativePointerLibraries.asPointer((LLVMPointerImpl)receiver);
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, LLVMPointerImpl arg0Value, Object arg1Value) {
                return (state_0 & 4) != 0 || !(arg1Value instanceof LLVMPointerImpl);
            }

            @GeneratedBy(value=NativePointerLibraries.class)
            private static final class ExecuteNativeCachedData
            extends Node {
                @Node.Child
                ExecuteNativeCachedData next_;
                @CompilerDirectives.CompilationFinal
                long cachedAddress_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionDescriptor cachedDescriptor_;
                @Node.Child
                InteropLibrary interop_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                ExecuteNativeCachedData(ExecuteNativeCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }

            @GeneratedBy(value=CommonPointerLibraries.class)
            private static final class InvokeMemberCachedData
            extends Node {
                @Node.Child
                InvokeMemberCachedData next_;
                @Node.Child
                InteropLibrary interop_;
                @CompilerDirectives.CompilationFinal
                LLVMInteropType.Clazz clazz_;
                @CompilerDirectives.CompilationFinal
                LLVMInteropType.Method method_;
                @CompilerDirectives.CompilationFinal
                int argCount_;
                @CompilerDirectives.CompilationFinal
                String methodName_;
                @CompilerDirectives.CompilationFinal
                LLVMFunction llvmFunction_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                InvokeMemberCachedData(InvokeMemberCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=NativePointerLibraries.class)
    private static final class LLVMNativeLibraryExports
    extends LibraryExport<LLVMNativeLibrary> {
        private LLVMNativeLibraryExports() {
            super(LLVMNativeLibrary.class, LLVMPointerImpl.class, false);
        }

        protected LLVMNativeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMNativeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMPointerImpl);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Uncached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && NativePointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMNativePointer toNativePointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.toNativePointer((LLVMPointerImpl)receiver);
            }
        }

        @GeneratedBy(value=NativePointerLibraries.class)
        private static final class Cached
        extends LLVMNativeLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;

            protected Cached(Object receiver) {
                LLVMPointerImpl castReceiver = (LLVMPointerImpl)receiver;
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create((Object)castReceiver)));
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && NativePointerLibraries.class.isAssignableFrom(this.dynamicDispatch_.dispatch(receiver));
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.isPointer((LLVMPointerImpl)receiver);
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.asPointer((LLVMPointerImpl)receiver);
            }

            @Override
            public LLVMNativePointer toNativePointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return NativePointerLibraries.toNativePointer((LLVMPointerImpl)receiver);
            }
        }
    }
}

