/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vector;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right"), @NodeChild(value="mask", type=LLVMExpressionNode.class)})
@NodeField(name="vectorLength", type=int.class)
public abstract class LLVMShuffleVectorNode
extends LLVMExpressionNode {
    protected final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    protected abstract int getVectorLength();

    public static abstract class LLVMShuffleDoubleVectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMDoubleVector doOp(LLVMDoubleVector leftVector, LLVMDoubleVector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            double[] newValues = new double[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMDoubleVector.create(newValues);
        }
    }

    public static abstract class LLVMShuffleFloatVectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMFloatVector doOp(LLVMFloatVector leftVector, LLVMFloatVector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            float[] newValues = new float[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMFloatVector.create(newValues);
        }
    }

    public static abstract class LLVMShuffleI64VectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI64Vector doI64Vector(LLVMI64Vector leftVector, LLVMI64Vector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            long[] newValues = new long[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMI64Vector.create(newValues);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMPointerVector doPointerVector(LLVMPointerVector leftVector, LLVMI64Vector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            LLVMPointer[] newValues = new LLVMPointer[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : LLVMNativePointer.create(rightVector.getValue(element - leftVectorLength));
            }
            return LLVMPointerVector.create(newValues);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMPointerVector doPointerVector(LLVMI64Vector leftVector, LLVMPointerVector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            LLVMPointer[] newValues = new LLVMPointer[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? LLVMNativePointer.create(leftVector.getValue(element)) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMPointerVector.create(newValues);
        }

        @Specialization
        @ExplodeLoop
        protected LLVMPointerVector doPointerVector(LLVMPointerVector leftVector, LLVMPointerVector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            LLVMPointer[] newValues = new LLVMPointer[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMPointerVector.create(newValues);
        }
    }

    public static abstract class LLVMShuffleI32VectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI32Vector doI32Vector(LLVMI32Vector leftVector, LLVMI32Vector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            int[] newValues = new int[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMI32Vector.create(newValues);
        }
    }

    public static abstract class LLVMShuffleI16VectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI16Vector doI8Vector(LLVMI16Vector leftVector, LLVMI16Vector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            short[] newValues = new short[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMI16Vector.create(newValues);
        }
    }

    public static abstract class LLVMShuffleI8VectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI8Vector doI8Vector(LLVMI8Vector leftVector, LLVMI8Vector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            byte[] newValues = new byte[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMI8Vector.create(newValues);
        }
    }

    public static abstract class LLVMShuffleI1VectorNode
    extends LLVMShuffleVectorNode {
        @Specialization
        @ExplodeLoop
        protected LLVMI1Vector doI1Vector(LLVMI1Vector leftVector, LLVMI1Vector rightVector, LLVMI32Vector maskVector) {
            assert (maskVector.getLength() == this.getVectorLength());
            boolean[] newValues = new boolean[this.getVectorLength()];
            int leftVectorLength = leftVector.getLength();
            for (int i = 0; i < this.getVectorLength(); ++i) {
                int element = maskVector.getValue(i);
                newValues[i] = this.conditionProfile.profile(element < leftVectorLength) ? leftVector.getValue(element) : rightVector.getValue(element - leftVectorLength);
            }
            return LLVMI1Vector.create(newValues);
        }
    }
}

