/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

public class LLVMReadVectorNode {

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMDoubleVectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected LLVMDoubleVector readDoubleVector(VirtualFrame frame) {
            return (LLVMDoubleVector)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
        }
    }

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMFloatVectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected LLVMFloatVector readFloatVector(VirtualFrame frame) {
            return (LLVMFloatVector)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
        }
    }

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMI64VectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected Object readVector(VirtualFrame frame) {
            Object result = FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
            assert (result instanceof LLVMI64Vector || result instanceof LLVMPointerVector);
            return result;
        }
    }

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMI32VectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected LLVMI32Vector readI32Vector(VirtualFrame frame) {
            return (LLVMI32Vector)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
        }
    }

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMI16VectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected LLVMI16Vector readI16Vector(VirtualFrame frame) {
            return (LLVMI16Vector)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
        }
    }

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMI8VectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected LLVMI8Vector readI8Vector(VirtualFrame frame) {
            return (LLVMI8Vector)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
        }
    }

    @NodeField(name="slot", type=FrameSlot.class)
    public static abstract class LLVMI1VectorReadNode
    extends LLVMExpressionNode {
        protected abstract FrameSlot getSlot();

        @Specialization
        protected LLVMI1Vector readI1Vector(VirtualFrame frame) {
            return (LLVMI1Vector)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot());
        }
    }
}

