/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;

public abstract class AggregateLiteralInPlaceNode
extends LLVMStatementNode {
    @Node.Children
    private final LLVMOffsetStoreNode[] stores;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] data;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] offsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] sizes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] bufferOffsets;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMGlobal[] descriptors;
    private static final ByteArraySupport byteSupport = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteArraySupport.bigEndian() : ByteArraySupport.littleEndian();

    public AggregateLiteralInPlaceNode(byte[] data, LLVMOffsetStoreNode[] stores, int[] offsets, int[] sizes, int[] bufferOffsets, LLVMGlobal[] descriptors) {
        assert (offsets.length == stores.length + 1 && stores.length == sizes.length);
        assert (offsets[offsets.length - 1] == data.length) : "offsets is expected to have a trailing entry with the overall size";
        assert (bufferOffsets.length == descriptors.length);
        this.data = data;
        this.stores = stores;
        this.sizes = sizes;
        this.offsets = offsets;
        this.bufferOffsets = bufferOffsets;
        this.descriptors = descriptors;
    }

    @Specialization
    protected void initialize(VirtualFrame frame, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode storeI8, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64) {
        this.writePrimitives(context, storeI8, storeI64);
        this.writeObjects(frame, context);
    }

    private void writePrimitives(LLVMContext context, LLVMI8StoreNode.LLVMI8OffsetStoreNode storeI8, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64) {
        int offset = 0;
        int nextStore = 0;
        for (int i = 0; i < this.descriptors.length; ++i) {
            int bufferEnd;
            LLVMPointer address = context.getSymbol(this.descriptors[i]);
            int bufferOffset = this.bufferOffsets[i];
            int n = bufferEnd = i == this.descriptors.length - 1 ? this.data.length : this.bufferOffsets[i + 1];
            while (offset < bufferEnd) {
                int nextStoreOffset = Math.min(this.offsets[nextStore], bufferEnd);
                if ((offset = this.initializePrimitiveBlock(address, storeI8, storeI64, offset, nextStoreOffset, bufferOffset)) >= bufferEnd || nextStore >= this.stores.length) continue;
                offset += this.sizes[nextStore++];
            }
        }
    }

    @ExplodeLoop
    private void writeObjects(VirtualFrame frame, LLVMContext context) {
        int offset = 0;
        int nextStore = 0;
        for (int i = 0; i < this.descriptors.length; ++i) {
            int bufferEnd;
            LLVMPointer address = context.getSymbol(this.descriptors[i]);
            int bufferOffset = this.bufferOffsets[i];
            int n = bufferEnd = i == this.descriptors.length - 1 ? this.data.length : this.bufferOffsets[i + 1];
            while (offset < bufferEnd) {
                offset = Math.min(this.offsets[nextStore], bufferEnd);
                if (offset >= bufferEnd || nextStore >= this.stores.length) continue;
                this.stores[nextStore].executeWithTarget(frame, address, offset - bufferOffset);
                offset += this.sizes[nextStore++];
            }
        }
    }

    private int initializePrimitiveBlock(LLVMPointer address, LLVMI8StoreNode.LLVMI8OffsetStoreNode storeI8, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64, int startOffset, int nextStoreOffset, int bufferOffset) {
        int offset;
        for (offset = startOffset; offset < nextStoreOffset && (offset - bufferOffset & 7) != 0; ++offset) {
            storeI8.executeWithTarget(address, offset - bufferOffset, this.data[offset]);
        }
        while (offset < nextStoreOffset - 7) {
            storeI64.executeWithTarget(address, offset - bufferOffset, byteSupport.getLong(this.data, offset));
            offset += 8;
        }
        while (offset < nextStoreOffset) {
            storeI8.executeWithTarget(address, offset - bufferOffset, this.data[offset]);
            ++offset;
        }
        return offset;
    }
}

