/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.LLVMNegatedForeignObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.arith.floating.LLVMArithmeticFactory;
import com.oracle.truffle.llvm.runtime.nodes.util.LLVMSameObjectNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="leftNode"), @NodeChild(value="rightNode")})
public abstract class LLVMArithmeticNode
extends LLVMExpressionNode {
    final LLVMArithmeticOp op;
    private static final LLVMFPArithmeticOp ADD = new LLVMFPArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left ^ right;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left + right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left + right);
        }

        @Override
        int doInt(int left, int right) {
            return left + right;
        }

        @Override
        long doLong(long left, long right) {
            return left + right;
        }

        @Override
        boolean canDoManaged(long op) {
            return true;
        }

        @Override
        ManagedArithmeticNode createManagedNode() {
            return new ManagedAddNode();
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.add(right);
        }

        @Override
        float doFloat(float left, float right) {
            return left + right;
        }

        @Override
        double doDouble(double left, double right) {
            return left + right;
        }

        @Override
        LLVMArithmetic.LLVMArithmeticOpNode createFP80Node() {
            return LLVMArithmeticFactory.createAddNode();
        }
    };
    private static final LLVMFPArithmeticOp MUL = new LLVMFPArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left & right;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left * right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left * right);
        }

        @Override
        int doInt(int left, int right) {
            return left * right;
        }

        @Override
        long doLong(long left, long right) {
            return left * right;
        }

        @Override
        boolean canDoManaged(long op) {
            return op == 1L || op == -1L || op == 0L;
        }

        @Override
        ManagedArithmeticNode createManagedNode() {
            return LLVMArithmeticNodeFactory.ManagedMulNodeGen.create();
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.mul(right);
        }

        @Override
        float doFloat(float left, float right) {
            return left * right;
        }

        @Override
        double doDouble(double left, double right) {
            return left * right;
        }

        @Override
        LLVMArithmetic.LLVMArithmeticOpNode createFP80Node() {
            return LLVMArithmeticFactory.createMulNode();
        }
    };
    private static final LLVMFPArithmeticOp SUB = new LLVMFPArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left ^ right;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left - right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left - right);
        }

        @Override
        int doInt(int left, int right) {
            return left - right;
        }

        @Override
        long doLong(long left, long right) {
            return left - right;
        }

        @Override
        boolean canDoManaged(long op) {
            return true;
        }

        @Override
        ManagedArithmeticNode createManagedNode() {
            return LLVMArithmeticNodeFactory.ManagedSubNodeGen.create();
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.sub(right);
        }

        @Override
        float doFloat(float left, float right) {
            return left - right;
        }

        @Override
        double doDouble(double left, double right) {
            return left - right;
        }

        @Override
        LLVMArithmetic.LLVMArithmeticOpNode createFP80Node() {
            return LLVMArithmeticFactory.createSubNode();
        }
    };
    private static final LLVMFPArithmeticOp DIV = new LLVMFPArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            if (!right) {
                CompilerDirectives.transferToInterpreter();
                throw new ArithmeticException("Division by zero!");
            }
            return left;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left / right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left / right);
        }

        @Override
        int doInt(int left, int right) {
            return left / right;
        }

        @Override
        long doLong(long left, long right) {
            return left / right;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.div(right);
        }

        @Override
        float doFloat(float left, float right) {
            return left / right;
        }

        @Override
        double doDouble(double left, double right) {
            return left / right;
        }

        @Override
        LLVMArithmetic.LLVMArithmeticOpNode createFP80Node() {
            return LLVMArithmeticFactory.createDivNode();
        }
    };
    private static final LLVMArithmeticOp UDIV = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            if (!right) {
                CompilerDirectives.transferToInterpreter();
                throw new ArithmeticException("Division by zero!");
            }
            return left;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(Byte.toUnsignedInt(left) / Byte.toUnsignedInt(right));
        }

        @Override
        short doShort(short left, short right) {
            return (short)(Short.toUnsignedInt(left) / Short.toUnsignedInt(right));
        }

        @Override
        int doInt(int left, int right) {
            return Integer.divideUnsigned(left, right);
        }

        @Override
        long doLong(long left, long right) {
            return Long.divideUnsigned(left, right);
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.unsignedDiv(right);
        }
    };
    private static final LLVMFPArithmeticOp REM = new LLVMFPArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            if (!right) {
                CompilerDirectives.transferToInterpreter();
                throw new ArithmeticException("Division by zero!");
            }
            return false;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left % right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left % right);
        }

        @Override
        int doInt(int left, int right) {
            return left % right;
        }

        @Override
        long doLong(long left, long right) {
            return left % right;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.rem(right);
        }

        @Override
        float doFloat(float left, float right) {
            return left % right;
        }

        @Override
        double doDouble(double left, double right) {
            return left % right;
        }

        @Override
        LLVMArithmetic.LLVMArithmeticOpNode createFP80Node() {
            return LLVMArithmeticFactory.createRemNode();
        }
    };
    private static final LLVMArithmeticOp UREM = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            if (!right) {
                CompilerDirectives.transferToInterpreter();
                throw new ArithmeticException("Division by zero!");
            }
            return left;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(Byte.toUnsignedInt(left) % Byte.toUnsignedInt(right));
        }

        @Override
        short doShort(short left, short right) {
            return (short)(Short.toUnsignedInt(left) % Short.toUnsignedInt(right));
        }

        @Override
        int doInt(int left, int right) {
            return Integer.remainderUnsigned(left, right);
        }

        @Override
        long doLong(long left, long right) {
            return Long.remainderUnsigned(left, right);
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.unsignedRem(right);
        }
    };
    private static final LLVMArithmeticOp AND = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left && right;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left & right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left & right);
        }

        @Override
        int doInt(int left, int right) {
            return left & right;
        }

        @Override
        long doLong(long left, long right) {
            return left & right;
        }

        @Override
        boolean canDoManaged(long op) {
            return ManagedAndNode.highBitsSet(op) || ManagedAndNode.highBitsClear(op);
        }

        @Override
        ManagedArithmeticNode createManagedNode() {
            return LLVMArithmeticNodeFactory.ManagedAndNodeGen.create();
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.and(right);
        }
    };
    private static final LLVMArithmeticOp OR = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left || right;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left | right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left | right);
        }

        @Override
        int doInt(int left, int right) {
            return left | right;
        }

        @Override
        long doLong(long left, long right) {
            return left | right;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.or(right);
        }
    };
    private static final LLVMArithmeticOp XOR = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left ^ right;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left ^ right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left ^ right);
        }

        @Override
        int doInt(int left, int right) {
            return left ^ right;
        }

        @Override
        long doLong(long left, long right) {
            return left ^ right;
        }

        @Override
        boolean canDoManaged(long op) {
            return op == -1L;
        }

        @Override
        ManagedArithmeticNode createManagedNode() {
            return LLVMArithmeticNodeFactory.ManagedXorNodeGen.create();
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.xor(right);
        }
    };
    private static final LLVMArithmeticOp SHL = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return right ? false : left;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left << right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left << right);
        }

        @Override
        int doInt(int left, int right) {
            return left << right;
        }

        @Override
        long doLong(long left, long right) {
            return left << (int)right;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.leftShift(right);
        }
    };
    private static final LLVMArithmeticOp LSHR = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return right ? false : left;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)((left & 0xFF) >>> right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)((left & 0xFFFF) >>> right);
        }

        @Override
        int doInt(int left, int right) {
            return left >>> right;
        }

        @Override
        long doLong(long left, long right) {
            return left >>> (int)right;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.logicalRightShift(right);
        }
    };
    private static final LLVMArithmeticOp ASHR = new LLVMArithmeticOp(){

        @Override
        boolean doBoolean(boolean left, boolean right) {
            return left;
        }

        @Override
        byte doByte(byte left, byte right) {
            return (byte)(left >> right);
        }

        @Override
        short doShort(short left, short right) {
            return (short)(left >> right);
        }

        @Override
        int doInt(int left, int right) {
            return left >> right;
        }

        @Override
        long doLong(long left, long right) {
            return left >> (int)right;
        }

        @Override
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return left.arithmeticRightShift(right);
        }
    };

    public abstract Object executeWithTarget(Object var1, Object var2);

    protected boolean canDoManaged(long operand) {
        return this.op.canDoManaged(operand);
    }

    protected LLVMArithmeticNode(ArithmeticOperation op) {
        switch (op) {
            case ADD: {
                this.op = ADD;
                break;
            }
            case SUB: {
                this.op = SUB;
                break;
            }
            case MUL: {
                this.op = MUL;
                break;
            }
            case DIV: {
                this.op = DIV;
                break;
            }
            case UDIV: {
                this.op = UDIV;
                break;
            }
            case REM: {
                this.op = REM;
                break;
            }
            case UREM: {
                this.op = UREM;
                break;
            }
            case AND: {
                this.op = AND;
                break;
            }
            case OR: {
                this.op = OR;
                break;
            }
            case XOR: {
                this.op = XOR;
                break;
            }
            case SHL: {
                this.op = SHL;
                break;
            }
            case LSHR: {
                this.op = LSHR;
                break;
            }
            case ASHR: {
                this.op = ASHR;
                break;
            }
            default: {
                throw new AssertionError((Object)op.name());
            }
        }
    }

    static abstract class ManagedXorNode
    extends ManagedCommutativeArithmeticNode {
        ManagedXorNode() {
        }

        @Specialization
        LLVMManagedPointer doXor(LLVMManagedPointer left, long right, @Cached(value="createClassProfile()") ValueProfile type) {
            Object foreign = type.profile(left.getObject());
            assert (right == -1L);
            Object negated = LLVMNegatedForeignObject.negate(foreign);
            return LLVMManagedPointer.create(negated, -left.getOffset() - 1L);
        }
    }

    static abstract class ManagedAndNode
    extends ManagedCommutativeArithmeticNode {
        private static final int POINTER_OFFSET_BITS = 32;

        ManagedAndNode() {
        }

        static boolean highBitsSet(long op) {
            long highBits = op >> 32;
            return highBits == -1L;
        }

        @Specialization(guards={"highBitsSet(right)"})
        LLVMManagedPointer doAlign(LLVMManagedPointer left, long right) {
            return LLVMManagedPointer.create(left.getObject(), left.getOffset() & right);
        }

        static boolean highBitsClear(long op) {
            long highBits = op >> 32;
            return highBits == 0L;
        }

        @Specialization(guards={"highBitsClear(right)"})
        long doMask(LLVMManagedPointer left, long right) {
            return left.getOffset() & right;
        }
    }

    static abstract class ManagedSubNode
    extends ManagedArithmeticNode {
        ManagedSubNode() {
        }

        @Specialization
        LLVMManagedPointer doLeft(LLVMManagedPointer left, long right) {
            return left.increment(-right);
        }

        @Specialization
        LLVMManagedPointer doRight(long left, LLVMManagedPointer right, @Cached(value="createClassProfile()") ValueProfile type) {
            Object foreign = type.profile(right.getObject());
            Object negated = LLVMNegatedForeignObject.negate(foreign);
            return LLVMManagedPointer.create(negated, left - right.getOffset());
        }
    }

    static abstract class ManagedMulNode
    extends ManagedCommutativeArithmeticNode {
        ManagedMulNode() {
        }

        @Specialization(guards={"right == 1"})
        LLVMManagedPointer doIdentity(LLVMManagedPointer left, long right) {
            return left;
        }

        @Specialization(guards={"right == 0"})
        long doZero(LLVMManagedPointer left, long right) {
            return 0L;
        }

        static boolean isMinusOne(long v) {
            return v == -1L;
        }

        @Specialization(guards={"isMinusOne(right)"})
        LLVMManagedPointer doNegate(LLVMManagedPointer left, long right) {
            Object negated = LLVMNegatedForeignObject.negate(left.getObject());
            return LLVMManagedPointer.create(negated, -left.getOffset());
        }
    }

    static final class ManagedAddNode
    extends ManagedCommutativeArithmeticNode {
        ManagedAddNode() {
        }

        @Override
        Object execute(LLVMManagedPointer left, long right) {
            return left.increment(right);
        }
    }

    public static abstract class LLVMFP80ArithmeticNode
    extends LLVMFloatingArithmeticNode {
        LLVMFP80ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        LLVMArithmetic.LLVMArithmeticOpNode createFP80Node() {
            return this.fpOp().createFP80Node();
        }

        @Specialization
        LLVM80BitFloat do80BitFloat(LLVM80BitFloat left, LLVM80BitFloat right, @Cached(value="createFP80Node()") LLVMArithmetic.LLVMArithmeticOpNode node) {
            return (LLVM80BitFloat)node.execute(left, right);
        }
    }

    public static abstract class LLVMDoubleArithmeticNode
    extends LLVMFloatingArithmeticNode {
        LLVMDoubleArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        double doDouble(double left, double right) {
            return this.fpOp().doDouble(left, right);
        }
    }

    public static abstract class LLVMFloatArithmeticNode
    extends LLVMFloatingArithmeticNode {
        LLVMFloatArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        float doFloat(float left, float right) {
            return this.fpOp().doFloat(left, right);
        }
    }

    public static abstract class LLVMFloatingArithmeticNode
    extends LLVMArithmeticNode {
        LLVMFloatingArithmeticNode(ArithmeticOperation op) {
            super(op);
            assert (this.op instanceof LLVMFPArithmeticOp);
        }

        LLVMFPArithmeticOp fpOp() {
            return (LLVMFPArithmeticOp)this.op;
        }
    }

    public static abstract class LLVMIVarBitArithmeticNode
    extends LLVMArithmeticNode {
        LLVMIVarBitArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        LLVMIVarBit doVarBit(LLVMIVarBit left, LLVMIVarBit right) {
            return this.op.doVarBit(left, right);
        }
    }

    static abstract class LLVMI64SubNode
    extends LLVMAbstractI64ArithmeticNode {
        protected LLVMI64SubNode() {
            super(ArithmeticOperation.SUB);
        }

        @Specialization(guards={"sameObject.execute(left.getObject(), right.getObject())"})
        long doSameObjectLong(LLVMManagedPointer left, LLVMManagedPointer right, @Cached LLVMSameObjectNode sameObject) {
            return left.getOffset() - right.getOffset();
        }

        @Specialization(limit="3", guards={"!sameObject.execute(left.getObject(), right.getObject())"})
        long doNotSameObject(LLVMManagedPointer left, LLVMManagedPointer right, @Cached LLVMSameObjectNode sameObject, @CachedLibrary(value="left") LLVMNativeLibrary leftLib, @CachedLibrary(value="right") LLVMNativeLibrary rightLib) {
            return leftLib.toNativePointer(left).asNative() - rightLib.toNativePointer(right).asNative();
        }
    }

    static abstract class LLVMI64ArithmeticNode
    extends LLVMAbstractI64ArithmeticNode {
        protected LLVMI64ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization(limit="3")
        long doPointer(LLVMPointer left, LLVMPointer right, @CachedLibrary(value="left") LLVMNativeLibrary leftLib, @CachedLibrary(value="right") LLVMNativeLibrary rightLib) {
            return this.op.doLong(leftLib.toNativePointer(left).asNative(), rightLib.toNativePointer(right).asNative());
        }
    }

    public static abstract class LLVMAbstractI64ArithmeticNode
    extends LLVMArithmeticNode {
        public abstract long executeLongWithTarget(long var1, long var3);

        public static LLVMAbstractI64ArithmeticNode create(ArithmeticOperation op, LLVMExpressionNode left, LLVMExpressionNode right) {
            if (op == ArithmeticOperation.SUB) {
                return LLVMArithmeticNodeFactory.LLVMI64SubNodeGen.create(left, right);
            }
            return LLVMArithmeticNodeFactory.LLVMI64ArithmeticNodeGen.create(op, left, right);
        }

        protected LLVMAbstractI64ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @CreateCast(value={"leftNode", "rightNode"})
        PointerToI64Node createCast(LLVMExpressionNode child) {
            return LLVMArithmeticNodeFactory.PointerToI64NodeGen.create(child);
        }

        @Specialization
        protected long doLong(long left, long right) {
            return this.op.doLong(left, right);
        }

        ManagedArithmeticNode createManagedNode() {
            return this.op.createManagedNode();
        }

        @Specialization(guards={"canDoManaged(right)"}, rewriteOn={UnexpectedResultException.class})
        long doManagedLeftLong(LLVMManagedPointer left, long right, @Cached(value="createManagedNode()") ManagedArithmeticNode node) throws UnexpectedResultException {
            return node.executeLong(left, right);
        }

        @Specialization(guards={"canDoManaged(right)"}, replaces={"doManagedLeftLong"})
        Object doManagedLeft(LLVMManagedPointer left, long right, @Cached(value="createManagedNode()") ManagedArithmeticNode node) {
            return node.execute(left, right);
        }

        @Specialization(guards={"canDoManaged(left)"}, rewriteOn={UnexpectedResultException.class})
        long doManagedRightLong(long left, LLVMManagedPointer right, @Cached(value="createManagedNode()") ManagedArithmeticNode node) throws UnexpectedResultException {
            return node.executeLong(left, right);
        }

        @Specialization(guards={"canDoManaged(left)"}, replaces={"doManagedRightLong"})
        Object doManagedRight(long left, LLVMManagedPointer right, @Cached(value="createManagedNode()") ManagedArithmeticNode node) {
            return node.execute(left, right);
        }

        @Specialization(limit="3", guards={"!canDoManaged(left)"})
        long doPointerRight(long left, LLVMPointer right, @CachedLibrary(value="right") LLVMNativeLibrary rightLib) {
            return this.op.doLong(left, rightLib.toNativePointer(right).asNative());
        }

        @Specialization(limit="3", guards={"!canDoManaged(right)"})
        long doPointerLeft(LLVMPointer left, long right, @CachedLibrary(value="left") LLVMNativeLibrary leftLib) {
            return this.op.doLong(leftLib.toNativePointer(left).asNative(), right);
        }
    }

    @NodeChild
    public static abstract class PointerToI64Node
    extends LLVMExpressionNode {
        @Specialization
        long doLong(long l) {
            return l;
        }

        @Specialization(limit="3", guards={"lib.isPointer(ptr)"}, rewriteOn={UnsupportedMessageException.class})
        long doPointer(Object ptr, @CachedLibrary(value="ptr") LLVMNativeLibrary lib) throws UnsupportedMessageException {
            return lib.asPointer(ptr);
        }

        @Specialization(limit="3", guards={"!lib.isPointer(ptr)"})
        Object doManaged(Object ptr, @CachedLibrary(value="ptr") LLVMNativeLibrary lib) {
            return ptr;
        }

        @Specialization(limit="5", replaces={"doLong", "doPointer", "doManaged"})
        Object doGeneric(Object ptr, @CachedLibrary(value="ptr") LLVMNativeLibrary lib) {
            if (lib.isPointer(ptr)) {
                try {
                    return lib.asPointer(ptr);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return ptr;
        }
    }

    public static abstract class LLVMI32ArithmeticNode
    extends LLVMArithmeticNode {
        LLVMI32ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        int doInt(int left, int right) {
            return this.op.doInt(left, right);
        }
    }

    public static abstract class LLVMI16ArithmeticNode
    extends LLVMArithmeticNode {
        LLVMI16ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        short doShort(short left, short right) {
            return this.op.doShort(left, right);
        }
    }

    public static abstract class LLVMI8ArithmeticNode
    extends LLVMArithmeticNode {
        LLVMI8ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        byte doByte(byte left, byte right) {
            return this.op.doByte(left, right);
        }
    }

    public static abstract class LLVMI1ArithmeticNode
    extends LLVMArithmeticNode {
        LLVMI1ArithmeticNode(ArithmeticOperation op) {
            super(op);
        }

        @Specialization
        boolean doBoolean(boolean left, boolean right) {
            return this.op.doBoolean(left, right);
        }
    }

    static abstract class ManagedCommutativeArithmeticNode
    extends ManagedArithmeticNode {
        ManagedCommutativeArithmeticNode() {
        }

        @Override
        final Object execute(long left, LLVMManagedPointer right) {
            return this.execute(right, left);
        }

        @Override
        final long executeLong(long left, LLVMManagedPointer right) throws UnexpectedResultException {
            return this.executeLong(right, left);
        }
    }

    static abstract class ManagedArithmeticNode
    extends LLVMNode {
        ManagedArithmeticNode() {
        }

        abstract Object execute(LLVMManagedPointer var1, long var2);

        abstract Object execute(long var1, LLVMManagedPointer var3);

        long executeLong(LLVMManagedPointer left, long right) throws UnexpectedResultException {
            return LLVMTypesGen.expectLong(this.execute(left, right));
        }

        long executeLong(long left, LLVMManagedPointer right) throws UnexpectedResultException {
            return LLVMTypesGen.expectLong(this.execute(left, right));
        }
    }

    private static abstract class LLVMFPArithmeticOp
    extends LLVMArithmeticOp {
        private LLVMFPArithmeticOp() {
        }

        abstract float doFloat(float var1, float var2);

        abstract double doDouble(double var1, double var3);

        abstract LLVMArithmetic.LLVMArithmeticOpNode createFP80Node();
    }

    private static abstract class LLVMArithmeticOp {
        private LLVMArithmeticOp() {
        }

        abstract boolean doBoolean(boolean var1, boolean var2);

        abstract byte doByte(byte var1, byte var2);

        abstract short doShort(short var1, short var2);

        abstract int doInt(int var1, int var2);

        abstract long doLong(long var1, long var3);

        abstract LLVMIVarBit doVarBit(LLVMIVarBit var1, LLVMIVarBit var2);

        boolean canDoManaged(long operand) {
            return false;
        }

        ManagedArithmeticNode createManagedNode() {
            return null;
        }
    }
}

