/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeField(type=long.class, name="structSize")
public abstract class LLVMStructStoreNode
extends LLVMStoreNode {
    @Node.Child
    private LLVMMemMoveNode memMove;

    public abstract long getStructSize();

    protected LLVMStructStoreNode(LLVMMemMoveNode memMove) {
        this.memMove = memMove;
    }

    @Specialization(guards={"getStructSize() == 0"})
    protected void noCopy(Object address, Object value) {
    }

    @Specialization(guards={"getStructSize() > 0", "!isAutoDerefHandle(language, address)", "!isAutoDerefHandle(language, value)"})
    protected void doOp(LLVMNativePointer address, LLVMNativePointer value, @CachedLanguage LLVMLanguage language) {
        this.memMove.executeWithTarget(address, value, this.getStructSize());
    }

    @Specialization(guards={"getStructSize() > 0", "isAutoDerefHandle(language, addr)", "isAutoDerefHandle(language, value)"})
    protected void doOpDerefHandle(LLVMNativePointer addr, LLVMNativePointer value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver) {
        this.doManaged(getReceiver.execute(addr), getReceiver.execute(value));
    }

    @Specialization(guards={"getStructSize() > 0"})
    protected void doManaged(LLVMManagedPointer address, LLVMPointer value) {
        this.memMove.executeWithTarget(address, value, this.getStructSize());
    }

    @Specialization(guards={"getStructSize() > 0", "!isAutoDerefHandle(language, address)"}, replaces={"doOp"})
    protected void doConvert(LLVMNativePointer address, LLVMPointer value, @CachedLanguage LLVMLanguage language, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        this.memMove.executeWithTarget(address, toNative.executeWithTarget(value), this.getStructSize());
    }
}

