/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMOffsetStoreNode.class)
public final class LLVMOffsetStoreNodeFactory {

    @GeneratedBy(value=LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode.class)
    public static final class LLVMGenericOffsetStoreNodeGen
    extends LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode {
        @Node.Child
        private LLVMExpressionNode target_;
        @Node.Child
        private LLVMExpressionNode offset_;
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMGenericOffsetStoreNodeGen(LLVMStoreNode store, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            super(store);
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @Override
        public void executeWithTargetGeneric(LLVMPointer targetValue, long offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                this.doOp(targetValue, offsetValue, valueValue);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(targetValue, offsetValue, valueValue);
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (state_0 != 0) {
                this.doOp(targetValue, offsetValue, valueValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(targetValue, offsetValue, valueValue_);
        }

        private void executeAndSpecialize(Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_0_ = state_0 |= 1;
                    this.doOp(targetValue_, offsetValue_, valueValue);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.target_, this.offset_, this.value_}, new Object[]{targetValue, offsetValue, valueValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode create(LLVMStoreNode store, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMGenericOffsetStoreNodeGen(store, target, offset, value);
        }
    }
}

