/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI16StoreNode
extends LLVMStoreNode {
    public abstract void executeWithTarget(LLVMPointer var1, short var2);

    @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
    protected void doOp(LLVMNativePointer addr, short value, @CachedLanguage LLVMLanguage language) {
        language.getLLVMMemory().putI16((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(language, addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, short value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMI16StoreNode.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    protected static void doOpManaged(LLVMManagedPointer address, short value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI16(address.getObject(), address.getOffset(), value);
    }

    public static LLVMI16StoreNode create() {
        return LLVMI16StoreNodeGen.create(null, null);
    }

    @GenerateUncached
    public static abstract class LLVMI16OffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVMI16OffsetStoreNode create() {
            return LLVMI16StoreNodeGen.LLVMI16OffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMI16OffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMI16StoreNodeGen.LLVMI16OffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, short var4);

        @Specialization(guards={"!isAutoDerefHandle(language, addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, short value, @CachedLanguage LLVMLanguage language) {
            language.getLLVMMemory().putI16((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(language, addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, short value, @CachedLanguage LLVMLanguage language, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMI16OffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(limit="3")
        protected static void doOpManaged(LLVMManagedPointer address, long offset, short value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeI16(address.getObject(), address.getOffset() + offset, value);
        }
    }
}

